var Gameotherw = function() {
	
	this.initialize = function() {
		var self = this;
		this.el = $('<div/>');
		if (phonegap == "android") {
			beepwarn = new Media(pgpath + "content/beepwarn.mp3");
			beepout = new Media(pgpath + "content/beepout.mp3");
			//console.log("android");
		} else if (phonegap == "ios") {
			beepwarn = new Media("content/beepwarn.mp3");
			beepout = new Media("content/beepout.mp3");			
		} else if (phonegap == "wp") {
			beepwarn = new Media("app/www/content/beepwarn.mp3");
			beepout = new Media("app/www/content/beepout.mp3");	
		}
		self.cleanup();
		self.registerEvents();
	},
	
	this.render = function() {
		this.el.html(Gamecharades.template);
        return this;
	},

	this.registerEvents = function() {
		var self = this;
		var rounds = 10;
		var difficulty = 1;
		this.el.on("click", "#nextcharades", function() {
			if (otherwteamscores.teams[0].players.length > 0 && otherwteamscores.teams[1].players.length > 0) {
				$('.charadescontentwrapper').html(inotherwsettings2);
			}
			else {
				if (otherwteamscores.teams[0].players.length > 0) {
					app.showAlert("You need to add players to team 2");
				}
				else if (otherwteamscores.teams[1].players.length > 0) {
					app.showAlert("You need to add players to team 1");
				}
				else {
					app.showAlert("You need to add players to both teams!")
				}
				return;
			}
		});
		this.el.on("click", "#nextcharades2", function() {
			$.jStorage.set("diff", difficulty);
			$('.charadescontentwrapper').html(inotherwhowto);
		});
		this.el.on("click", "#startcharades", function() {
			//console.log(rounds);
			self.newgame(rounds);
		});
		this.el.on("click", ".endround", function() {
			var round = $.jStorage.get("round");
			var t1s = otherwteamscores.teams[0].score;
			var t2s = otherwteamscores.teams[1].score;
			if (round % 2 == 0) {
				t1s++;
				otherwteamscores.teams[0].score = t1s;
				$('.ts1').html(t1s);
			} else {
				t2s++;
				otherwteamscores.teams[1].score = t2s;
				$('.ts2').html(t2s);
			}
			if (t1s > t2s) {
				$('.teamname1').removeClass("label-default").addClass("label-success");
				$('.teamname2').removeClass("label-success").addClass("label-default");
			} else if (t2s > t1s) {
				$('.teamname2').removeClass("label-default").addClass("label-success");
				$('.teamname1').removeClass("label-success").addClass("label-default");
			}
			var charadetodisplay = self.getcharade();
			$('.charadeinstructions').html("<b>" + otherwnowplaying + "</b>, describe <h3><b>" + charadetodisplay + "</b></h3> in other words!");
		});
		this.el.on("click", ".endpass", function() {
			var round = $.jStorage.get("round");
			var charadetodisplay = self.getcharade();
			$('.charadeinstructions').html("<b>" + otherwnowplaying + "</b>, describe <h3><b>" + charadetodisplay + "</b></h3> in other words!");
		});
		this.el.on("click", "#team1", function() {
			clearInterval(countdown);
			var t1s = otherwteamscores.teams[0].score;
			t1s++;
			otherwteamscores.teams[0].score = t1s;
			var round = $.jStorage.get("round")
			round++;
			$.jStorage.set("round", round);
			self.waitstart();
		});
		this.el.on("click", "#team2", function() {
			clearInterval(countdown);
			var t2s = otherwteamscores.teams[1].score;
			t2s++;
			otherwteamscores.teams[1].score = t2s;
			var round = $.jStorage.get("round")
			round++;
			$.jStorage.set("round", round);
			self.waitstart();
		});
		this.el.on("click", ".stopcounter", function() {
			clearInterval(countdown);
		});
		this.el.on("click", ".addteam1", function() {
			var t1addplayer = $('.team1players').val();
			if (t1addplayer.length > 0) {
				otherwteamscores.teams[0].players.push({ player: t1addplayer });
				//console.log(otherwteamscores.teams[0].players);
				$('.t1p').append("<li class=\"teamslist\"><small>" + t1addplayer + "</small></li>");
				$('.team1players').val("");
				$('.team1players').attr("placeholder", "Add another player..");
			} else {
				app.showAlert("You need to type a name first!");
			}
		});
		this.el.on("click", ".addteam2", function() {
			var t2addplayer = $('.team2players').val();
			if (t2addplayer.length > 0) {
				otherwteamscores.teams[1].players.push({ player: t2addplayer });
				//console.log(otherwteamscores.teams[1].players);
				$('.t2p').append("<li class=\"teamslist\"><small>" + t2addplayer + "</small></li>");
				$('.team2players').val("");
				$('.team2players').attr("placeholder", "Add another player..");
			} else {
				app.showAlert("You need to type a name first!");
			}
		});
		this.el.on("keypress", ".team1players", function(event) {
        	var t1addplayer = $('.team1players').val();
        	var p = event.which;
        	if (p == 13) { 
        		event.preventDefault();
				if (t1addplayer.length > 0) {
					otherwteamscores.teams[0].players.push({ player: t1addplayer });
					//console.log(otherwteamscores.teams[0].players);
					$('.t1p').append("<li class=\"teamslist\"><small>" + t1addplayer + "</small></li>");
					$('.team1players').val("");
					$('.team1players').attr("placeholder", "Add another player..");
				} else {
					app.showAlert("You need to type a name first!");
				}
			}
       	});
		this.el.on("keypress", ".team2players", function(event) {
        	var t2addplayer = $('.team2players').val();
        	var p = event.which;
        	if (p == 13) { 
        		event.preventDefault();
				if (t2addplayer.length > 0) {
					otherwteamscores.teams[1].players.push({ player: t2addplayer });
					//console.log(otherwteamscores.teams[1].players);
					$('.t2p').append("<li class=\"teamslist\"><small>" + t2addplayer + "</small></li>");
					$('.team2players').val("");
					$('.team2players').attr("placeholder", "Add another player..");
				} else {
					app.showAlert("You need to type a name first!");
				}
			}
       	});
		this.el.on("click", ".cr5", function() {
			rounds = 10;
			$('.selectrounds').text("10");
		});
		this.el.on("click", ".cr10", function() {
			rounds = 20;
			$('.selectrounds').text("20");
		});
		this.el.on("click", ".cr15", function() {
			rounds = 30;
			$('.selectrounds').text("30");
		});
		this.el.on("click", ".cr30", function() {
			rounds = 50;
			$('.selectrounds').text("50");
		});
		this.el.on("click", ".cheasy", function() {
			difficulty = 0;
			$('.selectdifficulty').text("Easy");
		});
		this.el.on("click", ".chmedium", function() {
			difficulty = 1;
			$('.selectdifficulty').text("Medium");
		});
		this.el.on("click", ".chhard", function() {
			difficulty = 2;
			$('.selectdifficulty').text("Hard");
		});
		self.el.on('click', '#startnewround', function() {
			self.startround(otherwnowplaying);
		});
		self.el.on('click', '.playagain', function() {
			self.playAgain();
		});
	},

	this.waitstart = function() {
		var self = this;
		clearInterval(countdown);
		var round = $.jStorage.get("round");
		var rounds = $.jStorage.get("rounds");
		if (round == rounds) {
			self.endgame();
		}
		else {
			$('.charadescontentwrapper').html(charadeswaitstart);
			var t1s = otherwteamscores.teams[0].score;
			var t2s = otherwteamscores.teams[1].score;
			var t1p = otherwteamscores.teams[0].players;
			var t2p = otherwteamscores.teams[1].players;
			//console.log(t1p);
			$.each(t1p, function(index, value) {
				//console.log(value.player);
				$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$.each(t2p, function(index, value) {
				//console.log(value.player);
				$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
			$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
			if (t1s > t2s) {
				$('.teamname1').removeClass("label-default").addClass("label-success");
			} else if (t2s > t1s) {
				$('.teamname2').removeClass("label-default").addClass("label-success");
			}
			if (round % 2 == 0) {
				var playernm = parseFloat(otherwteamscores.teams[0].players.length);
				var p1 = Math.floor(Math.random()*playernm);
				otherwnowplaying = otherwteamscores.teams[0].players[p1].player;
				$('.playername').append("Next up is <b>" + otherwnowplaying + ".</b> \n Press start when ready!");
			}
			else if (round % 2 != 0) {
				var playernm = parseFloat(otherwteamscores.teams[1].players.length);
				var p1 = Math.floor(Math.random()*playernm);
				otherwnowplaying = otherwteamscores.teams[1].players[p1].player;
				$('.playername').append("Next up is <b>" + otherwnowplaying + ".</b> \n Press start when ready!");
			}
		}

	}

	this.cleanup = function() {
		otherwteamscores.teams[0].players.length = 0;
		otherwteamscores.teams[1].players.length = 0;
		otherwteamscores.teams[0].score = 0;
		otherwteamscores.teams[1].score = 0;
		clearInterval(countdown);
	}

	this.endround = function() {
		var self = this;
		clearInterval(countdown);
		var round = $.jStorage.get("round");
		round++;
		$.jStorage.set("round", round);
		self.waitstart();
	}

	this.playAgain = function() {
		var self = this;
		var rounds = $.jStorage.get("rounds");
		otherwteamscores.teams[0].score = 0;
		otherwteamscores.teams[1].score = 0;
		clearInterval(countdown);
		self.newgame(rounds);
	}

	this.endgame = function() {
		$.jStorage.deleteKey("round");
		app.hasPlayedGame();
		$('.charadescontentwrapper').html(endofgame);
		$('.charadesbottomwrapper').detach();
		var t1s = otherwteamscores.teams[0].score;
		var t2s = otherwteamscores.teams[1].score;
		var t1p = otherwteamscores.teams[0].players;
		var t2p = otherwteamscores.teams[1].players;
		//console.log(t1p);
		$.each(t1p, function(index, value) {
			//console.log(value.player);
			$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$.each(t2p, function(index, value) {
			//console.log(value.player);
			$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
		$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
		if (t1s > t2s) {
			$('.teamname1').removeClass("label-default").addClass("label-success");
		} else if (t2s > t1s) {
			$('.teamname2').removeClass("label-default").addClass("label-success");
		}
		if (t1s > t2s) {
			$('.charadeswinningteam').html("<b>Team 1 won with " + t1s + " points versus " + t2s + ".</b><br>");
		}
		else if (t2s > t1s) {
			$('.charadeswinningteam').html("<b>Team 2 won with " + t2s + " points versus " + t1s + ".</b><br>");
		}
		else {
			$('.charadeswinningteam').html("<b>The game was tied at " + t1s + ".</b><br>")
		}
	}

	this.startround = function(player) {
		var self = this;
		var round = $.jStorage.get("round");
		var rounds = $.jStorage.get("rounds");
		//console.log(round + "," + rounds); 
		if (round == rounds) {
			self.endgame();
			return;
		} else {
			var charadetodisplay = self.getcharade();
			$('.charadescontentwrapper').html(inotherwstartround);
			$('.charadeinstructions').html("<b>" + otherwnowplaying + "</b>, describe <h3><b>" + charadetodisplay + "</b></h3> in other words!");
			var t1s = otherwteamscores.teams[0].score;
			var t2s = otherwteamscores.teams[1].score;
			var t1p = otherwteamscores.teams[0].players;
			var t2p = otherwteamscores.teams[1].players;
			//console.log(t1p);
			$.each(t1p, function(index, value) {
				//console.log(value.player);
				$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$.each(t2p, function(index, value) {
				//console.log(value.player);
				$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$('.tn1').append("<b> <span class=\"label label-info ts1\">" + t1s + "</b></span>");
			$('.tn2').append("<b> <span class=\"label label-info ts2\">" + t2s + "</b></span>");
			if (t1s > t2s) {
				$('.teamname1').removeClass("label-default").addClass("label-success");
			} else if (t2s > t1s) {
				$('.teamname2').removeClass("label-default").addClass("label-success");
			}
			$('.charadesbottomwrapper').html("");
			self.timer();
		}
		return;
	}

	this.newgame = function(rounds) {
		var rounds = parseFloat(rounds);
		$.jStorage.set("rounds", rounds);
		$.jStorage.set("round", 0);
		var self = this;
		$('#startcharades').detach();
		self.populateContent();
		this.waitstart();
	},

	this.timer = function() {
		var self = this;
		clearInterval(countdown);
		var timer = 61;
		var width = 100;
		countdown = window.setInterval(function() {
			if (timer > 0 && timer != 5 && timer != 1) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Time remaining: <b>" + timer + "s</b>")
				width = parseFloat(width)-1.667;
				//console.log(width);
				$('.timerprogress').css("width", width+"%");
				$('.endround').css('visibility', 'visible');
				$('.endpass').css('visibility', 'visible');
			} else if (timer == 5) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Time remaining: <b>" + timer + "s</b>")
				$('.endround').css('visibility', 'visible');
				$('.endpass').css('visibility', 'visible');
				width = parseFloat(width)-1.667;
				//console.log(width);
				$('.timerprogress').css("width", width+"%");
				if (phonegap) {
					beepwarn.play();
				} else {
					document.getElementById('beepwarn').play();					
				}
				//console.log("audio?");
			} else if (timer == 1) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Time remaining: <b>" + timer + "s</b>")
				$('.endround').css('visibility', 'visible');
				$('.endpass').css('visibility', 'visible');
				if (phonegap) {
					beepout.play();
				} else {
					document.getElementById('beepout').play();
				}
				//console.log("audioout?");
			} else {
				clearInterval(countdown);
				self.endround();
			}
		}, 1000);
	},

	this.getcharade = function() {
        var length = inotherwall.length;
        var generatedid = Math.floor(Math.random()*length);
	    var charade = inotherwall.splice(generatedid, 1);
	    return charade;		
		/*
		var difficulty = $.jStorage.get("diff");
        if (difficulty == 0) {
        	var length = inotherweasy.length;
        	var generatedid = Math.floor(Math.random()*length);
	        var charade = inotherweasy.splice(generatedid, 1);
	        return charade;
        } else if (difficulty == 1) {
        	var length = inotherwmedium.length;
        	var generatedid = Math.floor(Math.random()*length);
	        var charade = inotherwmedium.splice(generatedid, 1);
	        return charade;   	
        } else {
        	var length = inotherwhard.length;
        	var generatedid = Math.floor(Math.random()*length);
	        var charade = inotherwhard.splice(generatedid, 1);
	        return charade;
        }*/
	},

		this.populateContent = function() {
		//function reloads the variables with content
		inotherwall = ["Point","Scissors","Elephant","Jump","Chair","Pinch","Mosquito","Sunglasses",
		"Head","Balloon","Drink","Robot","Chicken","Rock","Camera","Book","Rabbit","Arm",
		"Crayon","Pig","Monkey","Baby","Happy","Hopscotch","Spider","Bird","Doll","Wings","Turtle",
		"Room","Drum","Ear","Cheek","Smile","Jar","Chin","Telephone","Mouth","Basketball","Tail","Airplane",
		"Tree","Star","Kick","Football","Frog","Dance","Alligator","Stop","Milk","Baseball","Clap","Kangaroo",
		"Sleep","Pillow","Flower","Dog","Sneeze","Circle","Icecream","Hamburger","Princess","Clown","Doctor","Snob","Brat","Barbie",
		"Phone","Car","Airplane","Flower","Snake","Horse","Cat","Beer","Wine","Gift","Shoe","Star","Pizza","Kiss","Twerk",
		"Small","Sheet","Trap","Quicksand","Funny","Whisk","Volcano","Eraser","Business","Brain","Blinds",
		"Dryer","Cuff","Flamingo","Basket","Lung","Beggar","Spider web","Carrot","Cowboy","Torch","Sip","Gym",
		"Trip","Beetle","Badge","Knot","Anger","Vegetable","Nightmare","Marble","Washing","Poison","Mouse","Spine",
		"Hair","Wrench","Party","Softball","Pizza","Swordfish","Vest","Stain","Year","Sand","Bobsled","Windmill",
		"Peck","Lawn mower","Doghouse","Cramp","Bubble","Artist","Giraffe","Honey","Scale","Wax","Cast","Sunburn",
		"Bathroom","Stiff","Chess","Shadow","Cloth","Wig","Doctor","Mirror","Alligator","Stop","Christmas","Drunk taxi driver",
		"Space ship","Grandma","Serial killer","Brad Pitt","3 legged dog","Bride","Angry mom","Cow","Summer","Rope","Rollerblade",
		"Snowball","Turtle","Table tennis","Beg","Cape","Rain","Saddle","Fire fighter","Zlatan Ibrahimovic","Royal queen","Zombie",
		"Drunkie","Michael Jackson","James Bond","Pilot","Cricket player","Rich","Money","Fire","DJ","Bartender",
		"Bikini","Engagement ring","Head phones","Britney Spears","Handbag","Afro hair","TV","Unicorn","Lollipop","Candy","Hot dog","Crocodile","Pharmacy",
		"Morning Boner","Hooker","Tourist","Party hat","Hawaii","Donkey","Fox","Poop","Key","Heart broken","Owl","Stylist","Ghost","Bitch","Snob",
		"Unicorn","Harry Potter","Voldermort","The Twiligt movie","Sheep","Puke","Handsome","Gourgeous","Sexy","Lime",
		"Redbull Vodka","Cosmopolitan","Dry Martini","Nail polish","Twerk","Muscles","Doggy style","Dick","Penis","Wedding",
		"London","New York","Dubai","Los Angeles","Hollywood","Sweden","France","Diamond","Porn","Feather","Angel","Beard",
		"Prison","Whiskey","Coca Cola","Fairytale","Drugs","Stoned","Zombie","Vampire","Computer","Barbeque","Bank robber",
		"Pirate","Dragon","Black","White","Tooth paste","Dangerous","Donkey","Snob","Barbie","Blind","Date","Costume party",
		"Nerd","Bonfire","Dildo","One night stand","Garlic","Onion","Sun blocker","Eiffel tower","Sunday","Saturday",
		"Dublin","Ice skating","Train","Cookie","Work","Word","Barack Obama","Virgin","Butterfly","Casino","Moon",
		"Moonlight","Hair dresser","High school","Weed","Boner","Boomerang","Bad boy","Vegetarian","Pizza",
		"Ferarri","Castle","Ginger","Sushi","Hamburger","Steak house","Nipple","Boat race","Toy","Spiderman","Hot",
		"Spain","Italy","Hot dog","Shop lifter","Carpenter","Shark","Shark tale","Whale","Ice cream","Umberella",
		"Snowstorm","Curry","Hip hop","Kanye West","Earth","Candy Crush","Union jack","Post man","Fireworks",
		"Snake","Cuddle","Sound","Snooze","YOLO","Awesome","Pasta bolognese","Paparazzi","Painting","Tattoo",
		"Back slick","Popcorn","Fish","Boob job","Evil","Devil","Actor","Cinema","Dog walker","Ham","Hair cut",
		"Judge","Believe","Justin Bieber","Socks","Kitchen","Toilet","Fashion Designer","Sweet","Wheel chair","Beach",
		"Lap dance","Blog","Internet","Newspaper","Heartless","Dreams","Goal","Charity","Beard","Babe","Cry","Tie",
		"Famous","Friend","Old","Camera","Chips","Brain","Chest hair","Medium","Dishwasher","Bark","Doggy bag"]
		/*inotherwmedium = ["Cow","Summer","Rope","Rollerblade","Snowball","Turtle","Table tennis","Beg","Cape","Rain","Saddle","Fire fighter",
					"Zlatan Ibrahimovic","Royal queen","Zombie","Drunkie","Michael Jackson","James Bond","Pilot","Cricket player",
					"Rich","Money","Fire","DJ","Bartender","Bikini","Engagement ring","Head phones","Britney Spears","Handbag",
					"Afro hair","TV","Unicorn","Lolipop","Candy","Hot dog","Crocodile","Farmacy","Morning Boner","Hooker",
					"Tourist","Party hat","Hawaii","Donkey","Fox","Poop","Key","Heart broken","Owl","Stylist"]

		inotherweasy = ["Point","Scissors","Elephant","Jump","Chair","Pinch","Mosquito","Sunglasses",
					"Head","Balloon","Drink","Robot","Chicken","Rock","Camera","Book","Rabbit","Arm",
					"Crayon","Pig","Monkey","Baby","Happy","Hopscotch","Spider","Bird","Doll","Wings","Turtle",
					"Room","Drum","Ear","Cheek","Smile","Jar","Chin","Telephone","Mouth","Basketball","Tail","Airplane",
					"Tree","Star","Kick","Football","Frog","Dance","Alligator","Stop","Milk","Baseball","Clap","Kangaroo",
					"Sleep","Pillow","Flower","Dog","Sneeze","Circle","Icecream","Hamburger","Princess","Clown","Doctor","Snob","Brat","Barbie",
					"iPhone","Car","Airplane","Flower","Snake","Horse","Cat","Beer","Wine","Gift","Shoe","Star","Pizza","Kiss","Twerk"]

		inotherwmedium = ["Small","Sheet","Trap","Quicksand","Funny","Whisk","Volcano","Eraser","Business","Brain","Blinds",
					"Dryer","Cuff","Flamingo","Basket","Lung","Beggar","Spider web","Carrot","Cowboy","Torch","Sip","Gym",
					"Trip","Beetle","Badge","Knot","Anger","Vegetable","Nightmare","Marble","Washing","Poison","Mouse","Spine",
					"Hair","Wrench","Party","Softball","Pizza","Swordfish","Vest","Stain","Year","Sand","Bobsled","Windmill",
					"Peck","Lawn mower","Doghouse","Cramp","Bubble","Artist","Giraffe","Honey","Scale","Wax","Cast","Sunburn",
					"Bathroom","Stiff","Chess","Shadow","Cloth","Wig","Doctor","Mirror","Alligator","Stop","Christmas","Drunk taxi driver",
					"Space ship","Grandma","Serial killer","Brad Pitt","3 legd dog","Bride","Angry mom"]*/
	}

	this.initialize();

};

Gamecharades.template = Handlebars.compile($("#gamecharades").html());
var charadesendround = Handlebars.compile($("#charadesendround").html());
var inotherwstartround = Handlebars.compile($("#inotherwstartround").html());
var endofgame = Handlebars.compile($("#endofgame").html());
var charadeswaitstart = Handlebars.compile($('#charadeswaitstart').html());
var inotherwsettings2 = Handlebars.compile($('#inotherwsettings2').html());
var inotherwhowto = Handlebars.compile($('#inotherwhowto').html());

var inotherwall;

var countdown;

var otherwteamscores = { teams: [ 
	{ team:"Team 1", score:0, players: []},
	{ team:"Team 2", score:0, players: []},
	]};

var otherwnowplaying;