var Gamerof = function() {
	
	this.initialize = function() {
		var self = this;
		this.el = $('<div/>');
		players.length = 0;
		self.registerEvents();
	},
	
	this.render = function() {
		this.el.html(gamerofhtml);
        return this;
	},

	this.registerEvents = function() {
		var self = this;
		var rounds = 20;
		var evil = 0;
		this.el.on("click", "#startrof", function() {
			self.newGame(rounds);
		});
		this.el.on("click", "#nextround", function() {
			self.startRound();
		});
	},

	this.endGame = function() {
		$.jStorage.deleteKey("round");
		app.hasPlayedGame();
		$.jStorage.deleteKey("rounds");
		var hasplayed1game = $.jStorage.get('hasplayed1game');
		if (!hasplayed1game) {
			$.jStorage.set('hasplayed1game', true);
		} else if (hasplayed1game == 'shown') {
			console.log('already shown modal');
		}
		$('.todcontentwrapper').html(rofendgame);
	}

	this.startRound = function() {
		var self = this;
		var round = $.jStorage.get("round");
		var rounds = $.jStorage.get("rounds");
		if (round == rounds) {
			self.endGame();
			return;
		} else {
			$('.todcontentwrapper').html(rofstartround);
			var actiontodo = self.getAction();
			$('#rofinstructions').html(actiontodo);		
		}
		return;
	}

	this.newGame = function(rounds) {
		var self = this;
		var rounds = parseFloat(rounds);
		$.jStorage.set("rounds", rounds);
		$.jStorage.set("round", 0);
		$('#starttod').detach();
		self.populateContent();
		self.startRound();
	},

	this.getAction = function() {
		var length = rofactions.length;
		length--;
		var latestid = $.jStorage.get("latestid");
    	var generatedid = Math.floor(Math.random()*length);
    	if (latestid != generatedid) {
    		console.log("if" + generatedid);
    		var action = rofactions[generatedid];
        	$.jStorage.set("latestid", generatedid);
        	return action;
    	} else {
    		if (generatedid === length) {
    			generatedid--;
    		} else {
    			generatedid++;
    		}
    		console.log("else" + generatedid);
    		var action = rofactions[generatedid];
        	$.jStorage.set("latestid", generatedid);
        	return action;
    	}
	},

	this.populateContent = function() {
		rofactions = ["<h3>WATERFALL</h3> <br> All participans start drinking at the same time. You can stop drinking whenever you want but the player sitting next to you can not stop until you do. <br> LETS DRINK!", 
		"<h3>GIVE AWAY 2</h3> <br> Give 2 sips to a player of your choice, or split up into several",
		"<h3>GIVE AWAY 3</h3> <br> Give 3 sips to a player of your choice, or split up into several",
		"<h3>GIVE AWAY 4</h3> <br> Give 4 sips to a player of your choice, or split up into several",
		"<h3>GIVE AWAY 5</h3> <br> Give 5 sips to a player of your choice, or split up into several",
		"<h3>GIVE AWAY 6</h3> <br> Give 6 sips to a player of your choice, or split up into several",
		"<h3>DRINK 2</h3> <br> Drink 2 sips pirate!",
		"<h3>DRINK 3</h3> <br> Drink 3 sips tiger!",
		"<h3>DRINK 4</h3> <br> Drink 4 sips gorgeous!",
		"<h3>DRINK 5</h3> <br> Drink 5 sips superstar!",
		"<h3>DRINK 6</h3> <br> Drink 6 sips party player!",
		"<h3>BATTLE</h3> <br> Challenge someone, loser drinks 3 sips. You choose the challenge. Could be dancing, singing, rap or rock, scissor, paper for example.",
		"<h3>LETS GET ANGRY</h3> <br> Challenge someone in a staring contest. Look as angry as possible to make your opponent laugh. The one who laughs first loses and drinks 3 sips.",
		"<h3>THEME</h3> <br> Choose a theme, for example car brands. Each player then needs to one by one name a brand and the first one to hesitate or repeat an already named brand loses. loser drinks 3 sips.",
		"<h3>TIME TO RULE</h3> <br> Create a new rule that will remain troughout the game. Example: Everyone drinks with their left hand or the drinker must stand up. Rulebreakers are punished with 3 sips.",
		"<h3>CHEERS</h3> <br> Lift your glass and toast with your party people, have a sip (or as many as you like).",
		"<h3>WHATS THE POINT?</h3> <br> Everyone counts to three and point at the player they think need a drink. The player with the most fingers pointing towards them drinks as many sips as fingers"]
	}

	this.initialize();

};

var gamerofhtml = Handlebars.compile($('#gamerof').html());
var rofstartround = Handlebars.compile($('#rofstartround').html());
var rofendgame = Handlebars.compile($('#rofendgame').html());

var rofactions;

var players = [];