var app = {

	hasPlayedGame: function() {
		var hasplayed1game = $.jStorage.get('hasplayed1game');
		if (!hasplayed1game) {
			$.jStorage.set('hasplayed1game', true);
		} else if (hasplayed1game == 'shown') {
			console.log('already shown modal');
		}
	},

	registerEvents: function() {
	    var self = this;
	    $(window).on('hashchange', $.proxy(this.route, this));
	    var navMain = $(".navbar-collapse");
     	navMain.on("click", "a", null, function () {
         	navMain.collapse('hide');
     	});
     	$('.tab-lang').on('click', function() {
     		var hash = window.location.hash
     		if (hashes.indexOf(hash) != -1) {
				if (navigator.notification) {
					navigator.notification.confirm('This will exit the game, are you sure?', function(button) {
						if (button === 1) {
							window.location.hash = "#lang";
						}
					}, 'Attention', 'Yes,No');
				} else {
					window.location.hash = "#lang";
				}
     		} else {
				window.location.hash = "#lang";
			}
     	});
     	$('.tab-about').on('click', function() {
     		var hash = window.location.hash
     		if (hashes.indexOf(hash) != -1) {
				if (navigator.notification) {
					navigator.notification.confirm('This will exit the game, are you sure?', function(button) {
						if (button === 1) {
							window.location.hash = "#about";
						}
					}, 'Attention', 'Yes,No');
				} else {
					window.location.hash = "#about";
				}
     		} else {
				window.location.hash = "#about";
			}
     	});
     	$('.tab-svabout').on('click', function() {
     		var hash = window.location.hash
     		if (hashes.indexOf(hash) != -1) {
				if (navigator.notification) {
					navigator.notification.confirm('This will exit the game, are you sure?', function(button) {
						if (button === 1) {
							window.location.hash = "#svabout";
						}
					}, 'Attention', 'Yes,No');
				} else {
					window.location.hash = "#svabout";
				}
     		} else {
				window.location.hash = "#svabout";
			}
     	});
     	$('.tab-moreapps').on('click', function() {
     		var hash = window.location.hash
     		if (hashes.indexOf(hash) != -1) {
				if (navigator.notification) {
					navigator.notification.confirm('This will exit the game, are you sure?', function(button) {
						if (button === 1) {
							window.location.hash = "#moreapps";
						}
					}, 'Attention', 'Yes,No');
				} else {
					window.location.hash = "#moreapps";
				}
     		} else {
				window.location.hash = "#moreapps";
			}
     	});
     	$('.tab-enhome').on('click', function() {
     		var hash = window.location.hash
     		if (hashes.indexOf(hash) != -1) {
				if (navigator.notification) {
					navigator.notification.confirm('This will exit the game, are you sure?', function(button) {
						if (button === 1) {
							window.location.hash = "#starten";
						}
					}, 'Attention', 'Yes,No');
				} else {
					window.location.hash = "#starten";
				}
     		} else {
				window.location.hash = "#starten";
			}
     	});
     	$('.tab-svhome').on('click', function() {
     		var hash = window.location.hash
     		if (hashes.indexOf(hash) != -1) {
				if (navigator.notification) {
					navigator.notification.confirm('This will exit the game, are you sure?', function(button) {
						if (button === 1) {
							window.location.hash = "#startsv";
						}
					}, 'Attention', 'Yes,No');
				} else {
					window.location.hash = "#startsv";
				}
     		} else {
				window.location.hash = "#startsv";
			}
     	});
	},

	showAlert: function (message, title) {    
		if (navigator.notification) {
		    navigator.notification.alert(message, null, title, 'OK');
		} else {
		    alert(title ? (title + ": " + message) : message);
		}
	},

    onDeviceReady: function() {
        // Register the Android specific event listeners
        console.log("back button event listener registered");
        document.addEventListener("backbutton", function (e) {
        	console.log("default prevented");
            e.preventDefault();
        }, false );
        gaPlugin = window.plugins.gaPlugin;
        if( window.plugins && window.plugins.AdMob ) {
 		 var admob_ios_key = 'ca-app-pub-4402527656213004/1011306779';
   		 var admob_android_key = 'ca-app-pub-4402527656213004/1011306779';
   		 var adId = (navigator.userAgent.indexOf('Android') >=0) ? admob_android_key : admob_ios_key;
   		 var am = window.plugins.AdMob;

	    am.createBannerView( 
       	 {
       		 'publisherId': adId,
       		 'adSize': am.AD_SIZE.BANNER,
       		 'bannerAtTop': true
       	 }, 
        function() {
            am.requestAd(
                { 'isTesting':false }, 
                function(){
                    am.showAd( true );
                }, 
                function(){ console.log('failed to request ad'); }
            );
        }, 
        function(){ console.log('failed to create banner view'); }
   		 );
		} else {
 	 	console.log('AdMob plugin not available/ready.');
		}
        var beenherebefore = $.jStorage.get('beenherebefore');
        var gapermission = $.jStorage.get('gapermission');
		if (!beenherebefore) {
			console.log('Confirm Analytics');
			app.gaConfirm();
		} else if (beenherebefore && gapermission == 'true') {
			app.gaInit();
		} else {
			console.log('We are not allowed to collect data');
		}
	},

	gaConfirm: function() {
		navigator.notification.confirm('Party Games would like your permission to collect some usage statistics to help improve the app. No personal or user identifiable data will be collected.', app.gaPermissionCallback, 'Attention', 'Allow,Deny');
	},

	gaPermissionCallback: function(button) {
        if (button === 1) {
        	$.jStorage.set('gapermission', 'true');
        	$.jStorage.set('beenherebefore', 'true');
        	app.gaInit();
        } else if (button === 2) {
        	$.jStorage.set('beenherebefore', 'true');
        	$.jStorage.set('gapermission', 'false')
        }
	},

	gaInit: function() {
		gaPlugin.init(app.gaSuccessConnect, app.gaFail, "UA-46534982-1", 10);
	},

	gaSuccess: function() {
		console.log('Successfully connected to Google Analytics');
	},

	gaSuccessConnect: function() {
		console.log('Successfully initiated connection to Google Analytics');
		app.gaTrackPage();
	},

	gaFail: function() {
		console.warn("Failed to connect to Google Analytics");
	},

	gaTrackPage: function() {
		gaPlugin.trackPage(app.gaSuccess, app.gaFail, "index.html");
		console.log('Tracking mainpage');
	},

	gaTrackPageView: function(page) {
		console.log('almost there, we shall now contact GA')
		var index = "index.html";
		var trackpage = index.concat(page);
		console.log(trackpage);
		gaPlugin.trackPage(app.gaSuccess, app.gaFail, trackpage);
	},

	route: function() {
		var self = this;
		var gapermission = $.jStorage.get('gapermission');
        console.log(gapermission);
		var hash = window.location.hash;
		if (!hash) {
			page = (new Langscreen().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-lang').addClass('tab-active');
		}
		else if (hash == "#startsv") {
			page = (new svGamescreen().render().el);
			$('.swedishnav').css("visibility", "visible");
			$('.englishnav').css("visibility", "hidden");
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-svhome').addClass('tab-active');
			language = 'sv'
			try {
				beepout.release();
				beepwarn.release();
			} catch(err) {
				console.log("not yet defined");
			}
		}
		else if (hash == "#lang") {
			page = (new Langscreen().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-lang').addClass('tab-active');
		}
		else if (hash == "#starten") {
			page = (new Gamescreen().render().el);
			$('.swedishnav').css("visibility", "hidden");
			$('.englishnav').css("visibility", "visible");
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-enhome').addClass('tab-active');
			language = 'en'
			try {
				beepout.release();
				beepwarn.release();
			} catch(err) {
				console.log("not yet defined");
			}
		}
		else if (hash == "#charades") {
			page = (new Gamecharades().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-enhome').addClass('tab-active');
		}
		else if (hash == "#start") {
			page = (new Gamescreen().render().el);
			$('.englishnav').css("visibility", "visible");
			$('.swedishnav').css("visibility", "hidden");
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-enhome').addClass('tab-active');
			language = 'en'
			try {
				beepout.release();
				beepwarn.release();
			} catch(err) {
				console.log("not yet defined");
			}
		}
		else if (hash == "#tod") {
			page = (new Gametod().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-enhome').addClass('tab-active');
		}
		else if (hash == "#inotherwords") {
			page = (new Gameotherw().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-enhome').addClass('tab-active');
		}
		else if (hash == "#rof") {
			page = (new Gamerof().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-enhome').addClass('tab-active');
		}
		else if (hash == "#about") {
			page = (new Aboutscreen().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-about').addClass('tab-active');
		}
		else if (hash == "#svcharades") {
			page = (new svGamecharades().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-svhome').addClass('tab-active');
		}
		else if (hash == "#svstart") {
			page = (new svGamescreen().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-svhome').addClass('tab-active');
			language = 'sv'
			try {
				beepout.release();
				beepwarn.release();
			} catch(err) {
				console.log("not yet defined");
			}
		}
		else if (hash == "#svtod") {
			page = (new svGametod().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-svhome').addClass('tab-active');
		}
		else if (hash == "#svinotherwords") {
			page = (new svGameotherw().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-svhome').addClass('tab-active');
		}
		else if (hash == "#svrof") {
			page = (new svGamerof().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-svhome').addClass('tab-active');
		}
		else if (hash == "#svabout") {
			page = (new svAboutscreen().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-svabout').addClass('tab-active');
		} else if (hash === "#moreapps") {
			page = (new Moreappsscreen().render().el);
			$('.foot-tab').removeClass('tab-active');
     		$('.tab-moreapps').addClass('tab-active');
     	}
		if (phonegap != false && gapermission == 'true' && hash != "") {
			console.log(hash);
			app.gaTrackPageView(hash);
		}
		slider.slidePage($(page));
	},

	getPath: function() {
		// Get local path for Phonegap
		path = window.location.pathname;
		path = path.substr( path, path.length - 10 );
		return 'file://' + path;
	},

	isPhoneGap: function() {
		var is = false;
		var agent = navigator.userAgent.toLowerCase();
		var path = window.location.href;
		if (agent.indexOf("android") != -1) {
			if (path.indexOf("file://") != -1) {
				is = "android";
			}
		} else if (agent.indexOf("iphone") != -1 || agent.indexOf("ipad") != -1 || agent.indexOf("ipod") != -1) {
			if (path.indexOf("file://") != -1) {
				is = "ios";
			}
		} else if (agent.indexOf("iemobile") != -1) {
			if (path.indexOf("file://") != -1) {
				is = "wp";
			}
		}
		return is;
	},

	startFastClick: function() {
		window.addEventListener('load', function() {
    	FastClick.attach(document.body);
		}, false);
	},

	reviewmodal: function() {
		if (phonegap == "android") {
			$('#androidmodal').modal('show');
			$.jStorage.set('hasplayed1game', 'shown');
		} else if (phonegap == "ios") {
			$('#iosmodal').modal('show');
			$.jStorage.set('hasplayed1game', 'shown');
		} else {
			$('#androidmodal').modal('show');
			$.jStorage.set('hasplayed1game', 'shown');
		}
	},

	fixFixed: function() {
		/* cache dom references */  
		var iosbrowser =  this.iOSbrowser();
		if (iosbrowser === true) {
			/* bind events */
			$(document)
			.on('focus', 'input', function(e) {
			    $('body').addClass('fixfixed');
			})
			.on('blur', 'input', function(e) {
			    $('body').removeClass('fixfixed');
			});
		}
	},

	iOSbrowser: function() {
		var is = false;
		var agent = navigator.userAgent.toLowerCase();
		if (agent.indexOf("iphone") != -1 || agent.indexOf("ipad") != -1 || agent.indexOf("ipod") != -1) {
			is = true;
		}
		return is;
	},

	initialize: function() {
		var self = this;
		pgpath = app.getPath();
		phonegap = app.isPhoneGap();
		slider = new PageSlider($("#totalcontainer"));
		document.addEventListener("deviceready", app.onDeviceReady, false);
		var hasplayed1game = $.jStorage.get('hasplayed1game');
		if (hasplayed1game && hasplayed1game != 'shown') {
			app.reviewmodal();
		}
		self.startFastClick();
		self.fixFixed();
		this.registerEvents();
		self.route();
	},
};

app.initialize();

var gaPlugin;
var phonegap;
var pgpath;
var lang;
var slider;
var pushNotification;
var language = 'en';

var hashes = ["#svcharades", "#svtod", "#svrof", "#svinotherwords", "#charades", "#tod", "#rof", "#inotherwords"];