var svGamecharades = function() {
	
	this.initialize = function() {
		var self = this;
		this.el = $('<div/>');
		//console.log(pgpath);
		//console.log(phonegap);
		if (phonegap == "android") {
			beepwarn = new Media(pgpath + "content/beepwarn.mp3");
			beepout = new Media(pgpath + "content/beepout.mp3");
			//console.log("android");
		} else if (phonegap == "ios") {
			beepwarn = new Media("content/beepwarn.mp3");
			beepout = new Media("content/beepout.mp3");			
		} else if (phonegap == "wp") {
			beepwarn = new Media("app/www/content/beepwarn.mp3");
			beepout = new Media("app/www/content/beepout.mp3");	
		}
		self.cleanup();
		self.registerEvents();
	},
	
	this.render = function() {
		this.el.html(svgamecharadestemplate);
        return this;
	},

	this.registerEvents = function() {
		// Declaring all event listeners
		var self = this;
		var rounds = 10;
		var difficulty = 1;
		// Declare HTML for removal button
		var rmbutton = "<span class=\"glyphicon glyphicon-remove teamsx\"></span>"
		this.el.on("click", "#nextcharades", function() {
			if (svchteamscores.teams[0].players.length > 0 && svchteamscores.teams[1].players.length > 0) {
				$('.charadescontentwrapper').html(svcharadessettings2);
			}
			else {
				if (svchteamscores.teams[0].players.length > 0) {
					app.showAlert("Du måste lägga till spelare i lag 2");
				}
				else if (svchteamscores.teams[1].players.length > 0) {
					app.showAlert("Du måste lägga till spelare i lag 1");
				}
				else {
					app.showAlert("Du måste lägga till spelare i båda lagen!", "Error");
				}
				return;
			}
		});
		this.el.on("click", "#nextcharades2", function() {
			// Render rules
			$.jStorage.set("diff", difficulty);
			$('.charadescontentwrapper').html(svcharadeshowto);
		});
		this.el.on("click", "#startcharades", function() {
			//console.log(rounds);
			// Trigger to start & pause audio so it can be autoplayed in iOS & Android
			document.getElementById('beepwarn').play();
			document.getElementById('beepout').play();
			document.getElementById('beepout').pause();
			document.getElementById('beepwarn').pause();
			// Launch a new game
			self.newgame(rounds);
		});
		this.el.on("click", ".endround", function() {
			clearInterval(countdown);
			self.endround();
		});
		this.el.on("click", ".stopcounter", function() {
			clearInterval(countdown);
		});
		this.el.on("click", "#team1", function() {
			clearInterval(countdown);
			var t1s = svchteamscores.teams[0].score;
			t1s++;
			svchteamscores.teams[0].score = t1s;
			var round = $.jStorage.get("round")
			round++;
			$.jStorage.set("round", round);
			self.waitStart();
		});
		this.el.on("click", "#team2", function() {
			clearInterval(countdown);
			var t2s = svchteamscores.teams[1].score;
			t2s++;
			svchteamscores.teams[1].score = t2s;
			var round = $.jStorage.get("round")
			round++;
			$.jStorage.set("round", round);
			self.waitStart();
		});
		this.el.on("click", ".addteam1", function() {
			var t1addplayer = $('.team1players').val();
			if (t1addplayer.length > 0) {
				svchteamscores.teams[0].players.push({ player: t1addplayer });
				console.log(svchteamscores.teams[0].players);
				$('.t1p').append("<li class=\"teamslist\"><small>" + t1addplayer + "</small></li>");
				$('.team1players').val("");
				$('.team1players').attr("placeholder", "Lägg till fler..");
			} else {
				app.showAlert("Du måste skriva in ett namn först!");
			}
		});
		this.el.on("click", ".addteam2", function() {
			var t2addplayer = $('.team2players').val();
			if (t2addplayer.length > 0) {
				svchteamscores.teams[1].players.push({ player: t2addplayer });
				console.log(t2addplayer);
				console.log(svchteamscores.teams[1].players);
				$('.t2p').append("<li class=\"teamslist\"><small>" + t2addplayer + "</small></li>");
				$('.team2players').val("");
				$('.team2players').attr("placeholder", "Lägg till fler..");
			} else {
				app.showAlert("Du måste skriva in ett namn först!");
			}
		});
		this.el.on("keypress", ".team1players", function(event) {
        	var t1addplayer = $('.team1players').val();
        	var p = event.which;
        	if (p == 13) {
        		event.preventDefault();
				if (t1addplayer.length > 0) {
					svchteamscores.teams[0].players.push({ player: t1addplayer });
					//console.log(svchteamscores.teams[0].players);
					$('.t1p').append("<li class=\"teamslist\"><small>" + t1addplayer + "</small></li>");
					$('.team1players').val("");
					$('.team1players').attr("placeholder", "Lägg till fler..");
				} else {
					app.showAlert("Du måste skriva in ett namn först!");
				}
			}
       	});
		this.el.on("keypress", ".team2players", function(event) {
        	var t2addplayer = $('.team2players').val();
        	var p = event.which;
        	if (p == 13) { 
        		event.preventDefault();
				if (t2addplayer.length > 0) {
					svchteamscores.teams[1].players.push({ player: t2addplayer });
					//console.log(svchteamscores.teams[1].players);
					$('.t2p').append("<li class=\"teamslist\"><small>" + t2addplayer + "</small></li>");
					$('.team2players').val("");
					$('.team2players').attr("placeholder", "Lägg till fler..");
				} else {
					app.showAlert("Du måste skriva in ett namn först!");
				}
			}
       	});
		this.el.on("click", ".teamsx", function() {
			this.detach();
		});
		this.el.on("click", ".cr5", function() {
			rounds = 10;
			$('.selectrounds').text("10");
		});
		this.el.on("click", ".cr10", function() {
			rounds = 20;
			$('.selectrounds').text("20");
		});
		this.el.on("click", ".cr15", function() {
			rounds = 30;
			$('.selectrounds').text("30");
		});
		this.el.on("click", ".cr30", function() {
			rounds = 50;
			$('.selectrounds').text("50");
		});
		this.el.on("click", ".cheasy", function() {
			difficulty = 0;
			$('.selectdifficulty').text("Lätt");
		});
		this.el.on("click", ".chmedium", function() {
			difficulty = 1;
			$('.selectdifficulty').text("Medel");
		});
		this.el.on("click", ".chhard", function() {
			difficulty = 2;
			$('.selectdifficulty').text("Svår");
		});
		self.el.on('click', '#startnewround', function() {
			self.startround(svchnowplaying);
		});
		self.el.on('click', '.playagain', function() {
			self.playAgain();
		});
	},

	this.waitStart = function() {
		var self = this;
		clearInterval(countdown);
		var round = $.jStorage.get("round");
		var rounds = $.jStorage.get("rounds");
		if (round == rounds) {
			self.endgame();
		}
		else {
			$('.charadescontentwrapper').html(svcharadeswaitstart);
			var t1s = svchteamscores.teams[0].score;
			var t2s = svchteamscores.teams[1].score;
			var t1p = svchteamscores.teams[0].players;
			var t2p = svchteamscores.teams[1].players;
			//console.log(t1p);
			$.each(t1p, function(index, value) {
				//console.log(value.player);
				$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$.each(t2p, function(index, value) {
				//console.log(value.player);
				$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
			$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
			if (t1s > t2s) {
				$('.teamname1').removeClass("label-default").addClass("label-success");
			} else if (t2s > t1s) {
				$('.teamname2').removeClass("label-default").addClass("label-success");
			}
			if (round % 2 == 0) {
				var playernm = parseFloat(svchteamscores.teams[0].players.length);
				var p1 = Math.floor(Math.random()*playernm);
				svchnowplaying = svchteamscores.teams[0].players[p1].player;
				$('.playername').append("Nästa spelare är <b>" + svchnowplaying + ".</b> \n Tryck start när du är redo!");
			}
			else if (round % 2 != 0) {
				var playernm = parseFloat(svchteamscores.teams[1].players.length);
				var p1 = Math.floor(Math.random()*playernm);
				svchnowplaying = svchteamscores.teams[1].players[p1].player;
				$('.playername').append("Nästa spelare är <b>" + svchnowplaying + ".</b> \n Tryck start när du är redo!");
			}
		}

	}

	this.playAgain = function() {
		var self = this;
		var rounds = $.jStorage.get("rounds");
		svchteamscores.teams[0].score = 0;
		svchteamscores.teams[1].score = 0;
		clearInterval(countdown);
		self.newgame(rounds);
	}

	this.cleanup = function() {
		svchteamscores.teams[0].players.length = 0;
		svchteamscores.teams[1].players.length = 0;
		svchteamscores.teams[0].score = 0;
		svchteamscores.teams[1].score = 0;
		clearInterval(countdown);
	}

	this.endround = function() {
		var self = this;
		clearInterval(countdown);
		$('.charadescontentwrapper').html(svcharadesendround);
		var t1s = svchteamscores.teams[0].score;
		var t2s = svchteamscores.teams[1].score;
		var t1p = svchteamscores.teams[0].players;
		var t2p = svchteamscores.teams[1].players;
		//console.log(t1p);
		$.each(t1p, function(index, value) {
			//console.log(value.player);
			$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$.each(t2p, function(index, value) {
			//console.log(value.player);
			$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
		$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
		if (t1s > t2s) {
			$('.teamname1').removeClass("label-default").addClass("label-success");
		} else if (t2s > t1s) {
			$('.teamname2').removeClass("label-default").addClass("label-success");
		}
		$('.charadesbottomwrapper').detach();
	}

	this.endgame = function() {
		$.jStorage.deleteKey("round");
		app.hasPlayedGame();
		$('.charadescontentwrapper').html(svendofgame);
		var t1s = svchteamscores.teams[0].score;
		var t2s = svchteamscores.teams[1].score;
		var t1p = svchteamscores.teams[0].players;
		var t2p = svchteamscores.teams[1].players;
		//console.log(t1p);
		$.each(t1p, function(index, value) {
			//console.log(value.player);
			$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$.each(t2p, function(index, value) {
			//console.log(value.player);
			$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
		$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
		if (t1s > t2s) {
			$('.teamname1').removeClass("label-default").addClass("label-success");
		} else if (t2s > t1s) {
			$('.teamname2').removeClass("label-default").addClass("label-success");
		}
		$('.charadesbottomwrapper').detach();
		if (t1s > t2s) {
			$('.charadeswinningteam').html("<b>Lag 1 vann med " + t1s + " poäng mot " + t2s + ".</b><br>");
		}
		else if (t2s > t1s) {
			$('.charadeswinningteam').html("<b>Lag 2 vann med " + t2s + " poäng mot " + t1s + ".</b><br>");
		}
		else {
			$('.charadeswinningteam').html("<b>Spelet blev lika med " + t1s + " poäng.</b><br>");
		}
	}

	this.startround = function(player) {
		var self = this;
		var round = $.jStorage.get("round");
		var rounds = $.jStorage.get("rounds");
		//console.log(round + "," + rounds); 
		if (round == rounds) {
			self.endgame();
			return;
		} else {
			var charadetodisplay = self.getcharade();
			var charadesdata = [{"charade": charadetodisplay}];
			$('.charadescontentwrapper').html(svcharadesstartround);
			$('.charadeinstructions').html("<b>" + player + "</b>, gestikulera ordet <h3><b>" + charadetodisplay + "</b></h3> till ditt lag!");
			var t1s = svchteamscores.teams[0].score;
			var t2s = svchteamscores.teams[1].score;
			var t1p = svchteamscores.teams[0].players;
			var t2p = svchteamscores.teams[1].players;
			//console.log(t1p);
			$.each(t1p, function(index, value) {
				//console.log(value.player);
				$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$.each(t2p, function(index, value) {
				//console.log(value.player);
				$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
			$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
			if (t1s > t2s) {
				$('.teamname1').removeClass("label-default").addClass("label-success");
			} else if (t2s > t1s) {
				$('.teamname2').removeClass("label-default").addClass("label-success");
			}
			$('.charadesbottomwrapper').html("");
			self.timer();
		}
		return;
	}

	this.newgame = function(rounds) {
		var rounds = parseFloat(rounds);
		$.jStorage.set("rounds", rounds);
		$.jStorage.set("round", 0);
		var self = this;
		$('#startcharades').detach();
		this.populateContent();
		this.waitStart();
	},

	this.timer = function() {
		var self = this;
		clearInterval(countdown);
		var timer = 61;
		var width = 100;
		countdown = window.setInterval(function() {
			if (timer > 0 && timer != 5 && timer != 1) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Tid kvar: <b>" + timer + "s</b>");
				width = parseFloat(width)-1.667;
				//console.log(width);
				$('.timerprogress').css("width", width+"%");
				$('.endround').css('visibility', 'visible');
			} else if (timer == 5) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Tid kvar: <b>" + timer + "s</b>")
				$('.endround').css('visibility', 'visible');
				width = parseFloat(width)-1.667;
				//console.log(width);
				$('.timerprogress').css("width", width+"%");
				if (phonegap) {
					beepwarn.play();
				} else {
					document.getElementById('beepwarn').play();					
				}
				//console.log("audio?");
			} else if (timer == 1) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Tid kvar: <b>" + timer + "s</b>")
				$('.endround').css('visibility', 'visible');
				if (phonegap) {
					beepout.play();
				} else {
					document.getElementById('beepout').play();					
				}
				//console.log("audioout?");
			} else {
				clearInterval(countdown);
				self.endround();
			}
		}, 1000);
	},

	this.getcharade = function() {
		var difficulty = $.jStorage.get("diff");
        if (difficulty == 0) {
        	var length = charadeseasy.length;
        	var generatedid = Math.floor(Math.random()*length);
	        var charade = charadeseasy.splice(generatedid, 1);
	        return charade;
        } else if (difficulty == 1) {
        	var length = charadesmedium.length;
        	var generatedid = Math.floor(Math.random()*length);
	        var charade = charadesmedium.splice(generatedid, 1);
	        return charade;   	
        } else {
        	var length = charadeshard.length;
        	var generatedid = Math.floor(Math.random()*length);
	        var charade = charadeshard.splice(generatedid, 1);
	        return charade;
        }
	},


	this.populateContent = function() {
		//function reloads the variables with content
		charadesmedium = ["Kossa","Sommar","Rep","Rullskridsko","Snöboll","Sköldpadda","Bordtennis","Be","Mantel","Regn","Sadel","Brandman",
							"Zlatan Ibrahimovic","Drottningen","Zombie","Fyllo","Michael Jackson","James Bond","Pilot","Cricketspelare",
							"Rik","Pengar","Eld","DJ","Bartender","Bikini","Förlovningsring","Hörlurar","Britney Spears","Handväska",
							"Afro hår","TV","Enhörning","Klubba","Godis","Hot dog","Krokodil","Apotek","Morgonstånd","Prostituerad",
							"Turist","Partyhatt","Hawaii","Åsna","Räv","Bajs","Nyckel","Förkrossad","Uggla","Stylist","Snygg","Tjock",
							"Pyjamas","Sjuk","Motorcyckel","Studsmatta","Pamela Anderson","Fjäril","Kär","Fotsvamp","Klåda","Party",
							"Vin","Redbull Vodka","Blody Mary","Champagne","Drake","Stekare","Snattare","Rik","Trollkarl","Spåtant",
							"Superhjälte","Spårhund","Maria Montazami","Guld","Prinsessa","Golf","Fyrverkeri","Poker","Chack","USA",
							"Röda hund","Klamydia","Svamp","Nageltrång","Vinprovning","Flirt","Tarzan","Nässpray","Huvudvärkstablett",
							"Ballong","Rutschkana","Rånarluva","Polis","Påve","Jesus","Brat","Konst","Kalsong","Boxning","Hästhoppning",
							"Plånbok","Handväska","iPad","Facebook","Instagram","Selfie","Uggla","Brev","Gubbe","Vakthund","Shot","Näsblod",
							"Bråk","Förstoringsglas","Morot","Näsduk","Bankomat","Stjärna","Karusell","Bulle","Hästsvans","Catwalk",
							"Konstnär","Förkyld","Pingvin","Pungråtta","Frisör","Snickare","Tapterserare","Surfa","Elektriker","Busschaufför",
							"Tandvärk","Miley Cyrus","Bröllop","Långkalsong","Skidor","Slalom","Målvakt","Optiker","Sjuksköterska",
							"Doktor","Pirat","Receptionist","Veterinär","Plastikkirurg","Psykolog","Strippa","Bartender","Cirkus",
							"Snus","Cigarett","Fön","Taxi","Bal","Binda","Tampong","Tårta","Gunga","Träsko","Bilmekaniker","Lokförare",
							"Lokalvårdare","Biljettkontrollant","Kriminalinspektör","Kleptoman","Blottare","Klotter","Bergsklättrare"]

		charadeseasy = ["Peka","Sax","Elefant","Hoppa","Stol","Nypa","Mygga","Solglasögon","Huvud","Ballong","Drink","Robot", 
						"Kyckling","Sten","Kamera","Bok","Kanin","Arm","Krita","Gris","Apa","Bebis","Nöjd","Hoppa hage","Spindel","Fågel",
						"Docka","Vingar","Sköldpadda","Rum","Trumma","Öron","Käke","Le","Burk","Kind","Telefon","Mun","Basketboll",
						"Svans","Flygplan","iPhone","Dator","TV","Kök","Vardagsrum","Pistol","Sovrum","Tandställning","Öl","Vin","Cider",
						"Hund","Katt","Fågel","Lejon","Tiger","Val","Säl","Orm","Häst","Disk","Frisyr","Blomma","Paket","Dörr","Hud",
						"Hjärta","Stjärna","Kvadrat","Boll","Brasa","Eld","Dansa","Disco","Veva","Steka","Bita","Flirta","Rumpa","Bröst",
						"Penis","Bajs","Kissa","Ögon","Luft","Flygplan","Tåg","Bil","Cyckel","Buss","Skridsko","Konståkning","Cirkus",
						"Snubbla","Pruttar","Bryta benet","Vricka foten","Kram","Puss","Bord","Vatten","Lyfta","Bära","Gym","Muskler",
						"Nummer","Bokstav","Radio","Säng","Sova","Snarka","Död","Spy","Full","Hungrig","Ledsen","Svärd","Gitarr",
						"Piano","Trumpet","Vax","Vind","Segla","Chockad","Klubba","Påse","Ring","Nagellack","Sol","Måne","Regn",
						"Snö","Is","Trä","Äpple","Hatt","Rosett","Drake","Glass","Slott","Blind","Klocka","Snöre","Slips",
						"Knapp","Hår","High Five","Gagnam Style","Krona","Trollspö","Snor","Öronvax","Skägg","Kaffe","Löss",
						"Botox","Örhänge","Blondin","Läppstift","Mascara","Vattenpistol","Vattenballong","Ballong","Flagga",
						"Hopprep","Fläta","Trött","Tidning","Korv","Hamburgare","Pingis","Tennis","Fotboll","Längdhopp"]

		charadeshard = ["Urmakare","Barberare","Opera","Musik","Tango","Salsa","Vampyr","Harry Potter","Troll","Plugghäst","Spya","Kräk",
						"Sugen","Jultomte","Mattematiker","Lugg","Backslick","Stureplan","Rattfull","Dörrvakt","Tandläkare","Halsfluss",
						"Arg hund","Ledsen gris","Leif GW Persson","Adolf Hitler","Lastbilschaufför","Droger","P-piller","Kondom","Kyss",
						"Fotsvamp","Raket","Dålig andedräckt","Valp","Fårahede","Borat","Tandborste","Dragspel","Massage","Spa","Hissreparatör",
						"Ollon","Baka","Syslöjd","Modell","Shopaholic","Möbelsnickare","Epilator","Pyramid","Nyckelpiga","Ormgrop","Lax",
						"Regnbågsforell","Stadsminister","Kock","Tatuering","Prutt","Pilsner","Charad","Jobbig granne","Bakfull",
						"Klamydiatest", "Gynekolog","Skogsturken","Morgonstånd","Rånarliga","Lejonjakt","Vargflock","Spindelnät","Edward Blom","Urinvägsinflamation",
						"Kollektiv","Kvicksand","Jordbävning","Orkan","Snögubbe","Barnbidrag","Gunilla Persson","Trisslott","Garage",
						"Bandmedlem","Bowling","Köttdisken på ICA","Fiskbil","Näsblod","Trafikljus","Övergångsställe","Kokbok","Livmoder",
						"Hålfot","Eiffeltornet","Frihetsgudinnan","Öresundsbron","Kissa ner sig","Bordellhus","Hemkunskap","Fikasugen",
						"Parasit","Plåster","Fågelskit","Julbord","Nyårshångel","Brandlarm","Snigel","Fågelbo","Kalkon","Kulglass",
						"Ortoped","Upptäcksfärd","Paradise Hotel","Svår Charad","Eko","Stilig","Pippi","Prinskorv","Housemusik","Simhopp",
						"Marmelad","Sexfantasi","Barnkalas","Hoppborg","Retas","Busringa","Sengångare","Facebook","Chattroulette",
						"Flygplats","Vinterdäck","Pannkaka","Bageri","Bröllopstårta","Kejsarsnitt","Skräddare","Nemo","Hundvakt",
						"Recept","Kändis","Beyonce","Operah Winfrey","Victoria Secret","Bajspåse","Suspensoar","Regnbåge","Hippie",
						"Skattjakt","Pappa betalar","Fotbolls VM","Idol","Dubbeldäckare","Bromsspår","Deja Vu","Lama","Blodprov",
						"Efterfest","After work","Firmafest","Förfest","Pojkvän","Telefonsex","Gräsmatta","Badvakt","Flirta","Telefonkö",
						"Lönehelg","Miniatyr","Fyllemat","Hämtmat","Kostym","Örn","Diskmedel","Glasskrig","BFF","YOLO","Swag","Festival"]
	}

	this.initialize();

};

var svgamecharadestemplate = Handlebars.compile($("#svgamecharades").html());
var svcharadesendround = Handlebars.compile($("#svcharadesendround").html());
var svcharadesstartround = Handlebars.compile($("#svcharadesstartround").html());
var svendofgame = Handlebars.compile($("#svendofgame").html());
var svcharadeswaitstart = Handlebars.compile($('#svcharadeswaitstart').html());
var svcharadessettings2 = Handlebars.compile($('#svcharadessettings2').html());
var svcharadeshowto = Handlebars.compile($('#svcharadeshowto').html());

var countdown;

var svchteamscores = { teams: [ 
	{ team:"Team 1", score:0, players: []},
	{ team:"Team 2", score:0, players: []},
	]};

var charadeseasy;
var charadesmedium;
var charadeshard;

//var beepout = new Media(pgpath + "content/beepout.mp3");
var beepout;
var beepwarn;
var svchnowplaying;
