var svGameotherw = function() {
	
	this.initialize = function() {
		var self = this;
		this.el = $('<div/>');
		if (phonegap == "android") {
			beepwarn = new Media(pgpath + "content/beepwarn.mp3");
			beepout = new Media(pgpath + "content/beepout.mp3");
			//console.log("android");
		} else if (phonegap == "ios") {
			beepwarn = new Media("content/beepwarn.mp3");
			beepout = new Media("content/beepout.mp3");			
		} else if (phonegap == "wp") {
			beepwarn = new Media("app/www/content/beepwarn.mp3");
			beepout = new Media("app/www/content/beepout.mp3");	
		}
		self.cleanup();
		self.registerEvents();
	},
	
	this.render = function() {
		this.el.html(svgamecharadestemplate);
        return this;
	},

	this.registerEvents = function() {
		var self = this;
		var rounds = 10;
		var difficulty = 1;
		this.el.on("click", "#nextcharades", function() {
			if (svothrwteamscores.teams[0].players.length > 0 && svothrwteamscores.teams[1].players.length > 0) {
				$('.charadescontentwrapper').html(svinotherwsettings2);
			}
			else {
				if (svothrwteamscores.teams[0].players.length > 0) {
					app.showAlert("Du måste lägga till spelare i lag 2");
				}
				else if (svothrwteamscores.teams[1].players.length > 0) {
					app.showAlert("Du måste lägga till spelare i lag 1");
				}
				else {
					app.showAlert("Du måste lägga till spelare i båda lagen!", "Error");
				}
				return;
			}
		});
		this.el.on("click", "#nextcharades2", function() {
			$.jStorage.set("diff", difficulty);
			$('.charadescontentwrapper').html(svinotherwhowto);
		});
		this.el.on("click", "#startcharades", function() {
			//console.log(rounds);
			self.newgame(rounds);
		});
		this.el.on("click", ".endround", function() {
			var round = $.jStorage.get("round");
			var t1s = svothrwteamscores.teams[0].score;
			var t2s = svothrwteamscores.teams[1].score;
			if (round % 2 == 0) {
				t1s++;
				svothrwteamscores.teams[0].score = t1s;
				$('.ts1').html(t1s);
			} else {
				t2s++;
				svothrwteamscores.teams[1].score = t2s;
				$('.ts2').html(t2s);
			}
			if (t1s > t2s) {
				$('.teamname1').removeClass("label-default").addClass("label-success");
				$('.teamname2').removeClass("label-success").addClass("label-default");
			} else if (t2s > t1s) {
				$('.teamname2').removeClass("label-default").addClass("label-success");
				$('.teamname1').removeClass("label-success").addClass("label-default");
			}
			var charadetodisplay = self.getcharade();
			$('.charadeinstructions').html("<b>" + svotherwnowplaying + "</b>, beskriv <h3><b>" + charadetodisplay + "</b></h3> med andra ord!");
		});
		this.el.on("click", ".endpass", function() {
			var round = $.jStorage.get("round");
			var charadetodisplay = self.getcharade();
			$('.charadeinstructions').html("<b>" + svotherwnowplaying + "</b>, beskriv <h3><b>" + charadetodisplay + "</b></h3> med andra ord!");
		});
		this.el.on("click", "#team1", function() {
			clearInterval(countdown);
			var t1s = svothrwteamscores.teams[0].score;
			t1s++;
			svothrwteamscores.teams[0].score = t1s;
			var round = $.jStorage.get("round")
			round++;
			$.jStorage.set("round", round);
			self.waitstart();
		});
		this.el.on("click", "#team2", function() {
			clearInterval(countdown);
			var t2s = svothrwteamscores.teams[1].score;
			t2s++;
			svothrwteamscores.teams[1].score = t2s;
			var round = $.jStorage.get("round")
			round++;
			$.jStorage.set("round", round);
			self.waitstart();
		});
		this.el.on("click", ".stopcounter", function() {
			clearInterval(countdown);
		});
		this.el.on("click", ".addteam1", function() {
			var t1addplayer = $('.team1players').val();
			if (t1addplayer.length > 0) {
				svothrwteamscores.teams[0].players.push({ player: t1addplayer });
				//console.log(svothrwteamscores.teams[0].players);
				$('.t1p').append("<li class=\"teamslist\"><small>" + t1addplayer + "</small></li>");
				$('.team1players').val("");
				$('.team1players').attr("placeholder", "Lägg till fler..");
			} else {
				app.showAlert("Du måste skriva in ett namn först!");
			}
		});
		this.el.on("click", ".addteam2", function() {
			var t2addplayer = $('.team2players').val();
			if (t2addplayer.length > 0) {
				svothrwteamscores.teams[1].players.push({ player: t2addplayer });
				//console.log(svothrwteamscores.teams[1].players);
				$('.t2p').append("<li class=\"teamslist\"><small>" + t2addplayer + "</small></li>");
				$('.team2players').val("");
				$('.team2players').attr("placeholder", "Lägg till fler..");
			} else {
				app.showAlert("Du måste skriva in ett namn först!");
			}
		});
		this.el.on("keypress", ".team1players", function(event) {
        	var t1addplayer = $('.team1players').val();
        	var p = event.which;
        	if (p == 13) {
        		event.preventDefault();
				if (t1addplayer.length > 0) {
					svothrwteamscores.teams[0].players.push({ player: t1addplayer });
					//console.log(svothrwteamscores.teams[0].players);
					$('.t1p').append("<li class=\"teamslist\"><small>" + t1addplayer + "</small></li>");
					$('.team1players').val("");
					$('.team1players').attr("placeholder", "Lägg till fler..");
				} else {
					app.showAlert("Du måste skriva in ett namn först!");
				}
			}
       	});
		this.el.on("keypress", ".team2players", function(event) {
        	var t2addplayer = $('.team2players').val();
        	var p = event.which;
        	if (p == 13) { 
        		event.preventDefault();
				if (t2addplayer.length > 0) {
					svothrwteamscores.teams[1].players.push({ player: t2addplayer });
					//console.log(svothrwteamscores.teams[1].players);
					$('.t2p').append("<li class=\"teamslist\"><small>" + t2addplayer + "</small></li>");
					$('.team2players').val("");
					$('.team2players').attr("placeholder", "Lägg till fler..");
				} else {
					app.showAlert("Du måste skriva in ett namn först!");
				}
			}
       	});
		this.el.on("click", ".cr5", function() {
			rounds = 10;
			$('.selectrounds').text("10");
		});
		this.el.on("click", ".cr10", function() {
			rounds = 20;
			$('.selectrounds').text("20");
		});
		this.el.on("click", ".cr15", function() {
			rounds = 30;
			$('.selectrounds').text("30");
		});
		this.el.on("click", ".cr30", function() {
			rounds = 50;
			$('.selectrounds').text("50");
		});
		this.el.on("click", ".cheasy", function() {
			difficulty = 0;
			$('.selectdifficulty').text("Lätt");
		});
		this.el.on("click", ".chmedium", function() {
			difficulty = 1;
			$('.selectdifficulty').text("Medel");
		});
		this.el.on("click", ".chhard", function() {
			difficulty = 2;
			$('.selectdifficulty').text("Svår");
		});
		self.el.on('click', '#startnewround', function() {
			self.startround(svotherwnowplaying);
		});
		self.el.on('click', '.playagain', function() {
			self.playAgain();
		});
	},

	this.waitstart = function() {
		var self = this;
		clearInterval(countdown);
		var round = $.jStorage.get("round");
		var rounds = $.jStorage.get("rounds");
		if (round == rounds) {
			self.endgame();
		}
		else {
			$('.charadescontentwrapper').html(svcharadeswaitstart);
			var t1s = svothrwteamscores.teams[0].score;
			var t2s = svothrwteamscores.teams[1].score;
			var t1p = svothrwteamscores.teams[0].players;
			var t2p = svothrwteamscores.teams[1].players;
			//console.log(t1p);
			$.each(t1p, function(index, value) {
				//console.log(value.player);
				$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$.each(t2p, function(index, value) {
				//console.log(value.player);
				$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
			$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
			if (t1s > t2s) {
				$('.teamname1').removeClass("label-default").addClass("label-success");
			} else if (t2s > t1s) {
				$('.teamname2').removeClass("label-default").addClass("label-success");
			}
			if (round % 2 == 0) {
				var playernm = parseFloat(svothrwteamscores.teams[0].players.length);
				var p1 = Math.floor(Math.random()*playernm);
				svotherwnowplaying = svothrwteamscores.teams[0].players[p1].player;
				$('.playername').append("Nästa spelare är <b>" + svotherwnowplaying + ".</b> \n Tryck start när du är redo!");
			}
			else if (round % 2 != 0) {
				var playernm = parseFloat(svothrwteamscores.teams[1].players.length);
				var p1 = Math.floor(Math.random()*playernm);
				svotherwnowplaying = svothrwteamscores.teams[1].players[p1].player;
				$('.playername').append("Nästa spelare är <b>" + svotherwnowplaying + ".</b> \n Tryck start när du är redo!");
			}
		}

	}

	this.cleanup = function() {
		svothrwteamscores.teams[0].players.length = 0;
		svothrwteamscores.teams[1].players.length = 0;
		svothrwteamscores.teams[0].score = 0;
		svothrwteamscores.teams[1].score = 0;
		clearInterval(countdown);
	}

	this.endround = function() {
		var self = this;
		clearInterval(countdown);
		var round = $.jStorage.get("round");
		round++;
		$.jStorage.set("round", round);
		self.waitstart();
	}

	this.playAgain = function() {
		var self = this;
		var rounds = $.jStorage.get("rounds");
		svothrwteamscores.teams[0].score = 0;
		svothrwteamscores.teams[1].score = 0;
		clearInterval(countdown);
		self.newgame(rounds);
	}

	this.endgame = function() {
		$.jStorage.deleteKey("round");
		app.hasPlayedGame();
		$('.charadescontentwrapper').html(svendofgame);
		$('.charadesbottomwrapper').detach();
		var t1s = svothrwteamscores.teams[0].score;
		var t2s = svothrwteamscores.teams[1].score;
		var t1p = svothrwteamscores.teams[0].players;
		var t2p = svothrwteamscores.teams[1].players;
		//console.log(t1p);
		$.each(t1p, function(index, value) {
			//console.log(value.player);
			$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$.each(t2p, function(index, value) {
			//console.log(value.player);
			$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
		});
		$('.tn1').append("<b> <span class=\"label label-info\">" + t1s + "</b></span>");
		$('.tn2').append("<b> <span class=\"label label-info\">" + t2s + "</b></span>");
		if (t1s > t2s) {
			$('.teamname1').removeClass("label-default").addClass("label-success");
		} else if (t2s > t1s) {
			$('.teamname2').removeClass("label-default").addClass("label-success");
		}
		if (t1s > t2s) {
			$('.charadeswinningteam').html("<b>Lag 1 vann med " + t1s + " poäng mot " + t2s + ".</b><br>");
		}
		else if (t2s > t1s) {
			$('.charadeswinningteam').html("<b>Lag 2 vann med " + t2s + " poäng mot " + t1s + ".</b><br>");
		}
		else {
			$('.charadeswinningteam').html("<b>Spelet blev lika med " + t1s + " poäng.</b><br>");
		}
	}

	this.startround = function(player) {
		var self = this;
		var round = $.jStorage.get("round");
		var rounds = $.jStorage.get("rounds");
		//console.log(round + "," + rounds); 
		if (round == rounds) {
			self.endgame();
			return;
		} else {
			var charadetodisplay = self.getcharade();
			$('.charadescontentwrapper').html(svinotherwstartround);
			$('.charadeinstructions').html("<b>" + svotherwnowplaying + "</b>, beskriv <h3><b>" + charadetodisplay + "</b></h3> med andra ord!");
			var t1s = svothrwteamscores.teams[0].score;
			var t2s = svothrwteamscores.teams[1].score;
			var t1p = svothrwteamscores.teams[0].players;
			var t2p = svothrwteamscores.teams[1].players;
			//console.log(t1p);
			$.each(t1p, function(index, value) {
				//console.log(value.player);
				$('.t1p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$.each(t2p, function(index, value) {
				//console.log(value.player);
				$('.t2p').append("<li class=\"teamslist\">" + value.player + "</li>");			
			});
			$('.tn1').append("<b> <span class=\"label label-info ts1\">" + t1s + "</b></span>");
			$('.tn2').append("<b> <span class=\"label label-info ts2\">" + t2s + "</b></span>");
			if (t1s > t2s) {
				$('.teamname1').removeClass("label-default").addClass("label-success");
			} else if (t2s > t1s) {
				$('.teamname2').removeClass("label-default").addClass("label-success");
			}
			$('.charadesbottomwrapper').html("");
			self.timer();
		}
		return;
	}

	this.newgame = function(rounds) {
		var rounds = parseFloat(rounds);
		$.jStorage.set("rounds", rounds);
		$.jStorage.set("round", 0);
		var self = this;
		$('#startcharades').detach();
		self.populateContent();
		this.waitstart();
	},

	this.timer = function() {
		var self = this;
		clearInterval(countdown);
		var timer = 61;
		var width = 100;
		countdown = window.setInterval(function() {
			if (timer > 0 && timer != 5 && timer != 1) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Tid kvar: <b>" + timer + "s</b>");
				width = parseFloat(width)-1.667;
				//console.log(width);
				$('.timerprogress').css("width", width+"%");
				$('.endround').css('visibility', 'visible');
				$('.endpass').css('visibility', 'visible');
			} else if (timer == 5) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Tid kvar: <b>" + timer + "s</b>")
				$('.endround').css('visibility', 'visible');
				$('.endpass').css('visibility', 'visible');
				width = parseFloat(width)-1.667;
				//console.log(width);
				$('.timerprogress').css("width", width+"%");
				if (phonegap) {
					beepwarn.play();
				} else {
					document.getElementById('beepwarn').play();					
				}
				//console.log("audio?");
			} else if (timer == 1) {
				//console.log(timer);
				timer = timer-1;
				$('.Timer').html("Tid kvar: <b>" + timer + "s</b>")
				$('.endround').css('visibility', 'visible');
				$('.endpass').css('visibility', 'visible');
				if (phonegap) {
					beepout.play();
				} else {
					document.getElementById('beepout').play();
				}
				//console.log("audioout?");
			} else {
				clearInterval(countdown);
				self.endround();
			}
		}, 1000);
	},

	this.getcharade = function() {
        var length = svinotherwall.length;
        var generatedid = Math.floor(Math.random()*length);
	    var charade = svinotherwall.splice(generatedid, 1);
	    return charade;		
	},

		this.populateContent = function() {
		//function reloads the variables with content
		svinotherwall = ["Ko","Sommar","Rep","Rullskridsko","Snöboll","Sköldpadda","Pingis","Be","Mantel","Regn","Sadel","Brandman" ,
						"Zlatan Ibrahimovic","Drottningen","Zombie","Fyllo","Michael Jackson","James Bond","Pilot","Cricketspelare",
						"Rik","Pengar","Eld","DJ","Bartender","Bikini","förlovningsring","Hörlurar","Britney Spears","handväska",
						"Afrohår","TV","Enhörning","Klubba","Godis","Hot dog","Krokodil","Apotek","Morgonstånd","Prostituerad" ,
						"Turist","Partyhatt","Hawaii","Åsna","Räv","Bajs","Nyckel","Brustet hjärta","Uggla","Stylist","Spöke","Bitch","Snobb",
						"Harry Potter","Voldermort","Twiligt","Får","Kräkas","Stilig","Underbar","Sexig","Lime",
						"Redbull Vodka","Cosmopolitan","Dry Martini","Nagellack","Twerk","Muskler","Doggy style","Penis","Snopp","Bröllop" ,
						"London","New York","Dubai","Los Angeles","Hollywood","Sverige","Frankrike","Diamant","Porr","Fjäder","Ängel","Skägg" ,
						"Fängelse","Whiskey","Coca Cola","Saga","Droger","Påtänd","Zombie","Vampyr","Dator","Grilla","Bankrånare",
						"Pirat","Drake","Svart","Vit","Tandkräm","Farlig","Apa","Snobb","Barbie","Blind","Datum","Maskerad" ,
						"Nörd","Lägereld","Dildo","Engångsligg","Vitlök","Lök","Solskyddsmedel","Eiffeltornet","Söndag","Lördag",
						"Dublin","Skridskoåkning","Tåg","Kaka","Arbete","Ord","Barack Obama","Oskuld","Fjäril","Casino","Måne",
						"Månsken","Frisör","Högskola","Marijuana","Stånd","Bomerang","Bad boy","Vegetarisk","iPhone","Pizza",
						"Ferarri","Slott","Ingefära","Sushi","Hamburgare","Steak house","Bröstvårta","Båtrace","Leksak","Spindelmannen","Het",
						"Spanien","Italien","Varmkorv","Snattare","Snickare","Haj","Hajfena","Val","Glass","Paraply",
						"Snöstorm","Curry","Hip hop","Kanye West","Earth","Candy Crush","Brevbärare","Fyrverkeri",
						"Orm","Mysa","Ljud","Snooza","YOLO","Toppen","Pasta bolognese","Paparazzi", "Målning","Tatuering",
						"Backslick","Popcorn","Fisk","Bröstförstoring","Ond","Djävulen","Skådespelare","Bio","Hundrastare","Skinka","Frisyr",
						"Domare","Tror","Justin Bieber","Strumpor","Kök","Toalett","Modedesigner","Söt","Rullstol","Strand","Lap dance",
						"Kändis","Kompis","Gammal","Kamera","Chips","Hjärna","Brösthår","Medium","Diskmaskin","Skälla","Doggy bag",
						"Våt","Dryg","Bamba","Skadestånd","Sugen","Bortskämd","Maria Montazami","Kevin Walker","iPad","Hångel","Kram","Glas",
						"Ollon","Pung","Grotta","Adolf Hitler","Mona Lisa","Empire State Building","Rosor","Nalle Puh","Ior","Wallander",
						"Joel Kinnaman","Alexander Skarsgård","Pungråtta","Myrslok","Rabies","Samsung","Prinsesstårta","Skål","Tomtefar",
						"Julbocken i Gävle","H&M","Glenn","IFK Göteborg","Hammarby","Real Madrid","Gotland","Öresundsbron","Argentina",
						"Prag","Kalifornien","Solsidan","Överviktig","Japan","Acne","Gucci","Louis Vuitton","Findus","Christofer Columbus",
						"Milano","Klamydia","Missoni","Mjältbrand","Galna kosjukan","Rastlös","Tuggben","Bunke","Processor","Applikation",
						"Oskuld","WiFi","Ögonbryn","Pendeltåg","Middagsbråk","Vågmästare","Tidtagarur","Reservdel","Trassel","Otursdag",
						"Pappaledig","Kanada","Kvällstidning","Vladimir Lenin","Fotsvamp","Nageltrång","Pungsvett","Flatlöss","Gynekolog",
						"Laserturken","Skogsturken","Glögg","Hundbajs","Paradise Hotel","Petra Mede","Facebook","Erektion","Svärmor",
						"Rumpstek","Komiker","Leif Mannerstörm","Leif GW Persson","Internetshopping","Hämtmat","Pingvin","Vattenläcka",
						"Stömavbrott","Gruppsex","Billig","Flytande","Implantat","Läppförstoring","Botox","Kim Kardashian","Scott Disick",
						"Vaska","Skumpa","Stureplan","Onödig","Stalker","Vinnare","Frihetsgudinnan","Pilotglasögon","10 000-metersklubben",
						"Snorvalp","Snorunge","Bältros","Klåda","Analklåda","Minneslucka","Pissoar","Blixtlås","Förspel","Horig",
						"Laktosintolerant","Glutenintolerant","Förfest","Soda Stream","Mc Donalds","Bubbelbadkar","Läskunnig",
						"Raggningsreplik","Avtänd","Skallig","Kondom","P-piller","Abort","Blomsterarrangemang","Kateter","Lavemang",
						"Laxeringsmedel","Analblekning","Fax","Piraya","Fiskspa","Hundmat","Krullig","Nobelfest","Kirurg","Fotfetish",
						"Kryssning","Tröstligg","Pyjamasparty","Champagne","Läppglans","Glasstårta","Uppvärmning","Lasagne","Öronvax",
						"Vattenspruta","Simhall","Förkyld","Feberfrossa","Frost","Beck","Johan Falk","Mittbena","Kaviar","Gräsmatta",
						"Madrasskydd","Liseberg","David Batra","Carl Bildt","Tandtroll","Hagelgevär","Svampinfektion","Intrång",
						"Besöksförbud","Hjärtlös","Snubbla","Hunk","Utställning","Körkort","Ishalka","Paraplydrink","Sällskapssjuk",
						"Porrfilm","Porrstjärna","Porr","Tapetsera","Hålfotsinlägg","Lårkaka","Hälsena","Prutt","Fisa","Smygfisa","Onanera",
						"Sommarflirt","Gäspa","Fyllemat","Spade","Genväg","Hornhinna","Lutfisk","Nagelsax","Pippi","Rånarluva","Tjock-TV",
						"Slak","Blondinskämt","Förortsbrud","IQ-befriad","Rehab","Bankomat","Bambatant","Tyken","Snögubbe","Bingo Rimér",
						"Magaluf","Torrjucka","Bankomat","Marsipangris","Vattenfall","Happy Hour","Yoga","Sushi","Rovdjur","Panda",
						"Alanya","Stake","Stånd","Sergels Torg","Per Morberg","Samlag","Jakthund","Bete","Harlort","Schemalagd","Pippa"]
	}

	this.initialize();

};

var svgamecharadestemplate = Handlebars.compile($("#svgamecharades").html());
var svcharadesendround = Handlebars.compile($("#svcharadesendround").html());
var svinotherwstartround = Handlebars.compile($("#svinotherwstartround").html());
var svendofgame = Handlebars.compile($("#svendofgame").html());
var svcharadeswaitstart = Handlebars.compile($('#svcharadeswaitstart').html());
var svinotherwsettings2 = Handlebars.compile($('#svinotherwsettings2').html());
var svinotherwhowto = Handlebars.compile($('#svinotherwhowto').html());

var svinotherwall;

var countdown;

var svothrwteamscores = { teams: [ 
	{ team:"Team 1", score:0, players: []},
	{ team:"Team 2", score:0, players: []},
	]};

var svotherwnowplaying;