var svGamerof = function() {
	
	this.initialize = function() {
		var self = this;
		this.el = $('<div/>');
		players.length = 0;
		self.registerEvents();
	},
	
	this.render = function() {
		this.el.html(svgamerofhtml);
        return this;
	},

	this.registerEvents = function() {
		var self = this;
		var rounds = 20;
		var evil = 0;
		this.el.on("click", "#startrof", function() {
			self.newGame(rounds);
		});
		this.el.on("click", "#nextround", function() {
			self.startRound();
		});
	},

	this.endGame = function() {
		$.jStorage.deleteKey("round");
		app.hasPlayedGame();
		$.jStorage.deleteKey("rounds");
		$('.todcontentwrapper').html(svrofendgame);
	}

	this.startRound = function() {
		var self = this;
		var round = $.jStorage.get("round");
		var rounds = $.jStorage.get("rounds");
		if (round == rounds) {
			self.endGame();
			return;
		} else {
			$('.todcontentwrapper').html(svrofstartround);
			var actiontodo = self.getAction();
			$('#rofinstructions').html(actiontodo);		
		}
		return;
	}

	this.newGame = function(rounds) {
		var self = this;
		var rounds = parseFloat(rounds);
		$.jStorage.set("rounds", rounds);
		$.jStorage.set("round", 0);
		$('#starttod').detach();
		self.populateContent();
		self.startRound();
	},

	this.getAction = function() {
		var length = svrofactions.length;
		length--;
		var latestid = $.jStorage.get("latestid");
    	var generatedid = Math.floor(Math.random()*length);
    	if (latestid != generatedid) {
    		console.log("if" + generatedid);
    		var action = svrofactions[generatedid];
        	$.jStorage.set("latestid", generatedid);
        	return action;
    	} else {
    		if (generatedid === length) {
    			generatedid--;
    		} else {
    			generatedid++;
    		}
    		console.log("else" + generatedid);
    		var action = svrofactions[generatedid];
        	$.jStorage.set("latestid", generatedid);
        	return action;
    	}
	},

	this.populateContent = function() {
		svrofactions = ["<h3>VATTENFALL</h3> <br> Alla börjar dricka samtidigt. Du kan sluta att dricka när du vill, men personen efter dig får inte sluta innan dig. Nästa person får inte sluta innan personen före har slutat dricka. <br> KLARA FÄRDIGA DRICK!", 
					"<h3>GE BORT 2</h3> <br> Ge 2 klunkar till valfri spelare, eller dela upp till fler om du vill.",
					"<h3>GE BORT 3</h3> <br> Ge 3 klunkar till valfri spelare, eller dela upp till fler om du vill.",
					"<h3>GE BORT 4</h3> <br> Ge 4 klunkar till valfri spelare, eller dela upp till fler om du vill.",
					"<h3>GE BORT 5</h3> <br> Ge 5 klunkar till valfri spelare, eller dela upp till fler om du vill.",
					"<h3>GE BORT 6</h3> <br> Ge 6 klunkar till valfri spelare, eller dela upp till fler om du vill.",
					"<h3>DRICK 2</h3> <br> Drick 2 klunkar","<h3>DRICK 3</h3> <br> Drick 3 klunkar","<h3>DRICK 4</h3> <br> Drick 4 klunkar",
					"<h3>DRICK 5</h3> <br> Drick 5 klunkar","<h3>DRICK 6</h3> <br> Drick 6 klunkar",
					"<h3>UTMANING</h3> <br> Utmana någon, förloraren dricker 3 klunkar. Du väljer utmaning. Kan till exempel vara dans, sång, rap eller sten, sax, påse.",
					"<h3>ÄR DU ARG?</h3> <br> Utmana någon i arga leken. Se så arg ut du kan och försök att få den andra att skratta. Förlorar gör den som ler först och den får dricka 3 klunkar.",
					"<h3>TEMA</h3> <br> Välj ett tema, till exempel drinkar. Varje spelare ska sen en och en säga en drink och den som först tvekar eller säger något som redan är sagt förlorar. 3 Klunkar i straff till förloraren!",
					"<h3>NY REGEL</h3> <br> Bestäm en ny regel som gäller från och med nu och tills spelet är över. Exempel:  Alla dricker med vänster hand eller att den som dricker måste stå. Den som bryter en regel blir straffad med 3 klunkar.",
					"<h3>SKÅÅÅÅL</h3> <br>Lyft ditt glas och skåla med dina vänner!",
					"<h3>DET ÄR INTE FULT ATT PEKA</h3> <br> Alla räknar till tre och pekar på den de tycker behöver dricka mer. Personen som har flest fingrar riktade mot sig dricker lika många klunkar som fingrar."]
	}

	this.initialize();

};

var svgamerofhtml = Handlebars.compile($('#svgamerof').html());
var svrofstartround = Handlebars.compile($('#svrofstartround').html());
var svrofendgame = Handlebars.compile($('#svrofendgame').html());

var svrofactions;

var players = [];