/**
*  Sesame Street Loading View
*
*  @author William Malone (www.williammalone.com)
*/

WM.loadingView = function (GLOBAL, WM, ctx, options) {
	
	var that = WM.view(GLOBAL, WM, ctx, options),
		startImage = new Image(),
		loadingImageWhite = new Image(),
		loadingImageColor = new Image(),
		imageWhiteLoaded = false,
		imageColorLoaded = false,
		imageStartLoaded = false,
		startTouched = false,
		startImageSrc = options.startImageFilename !== undefined ? options.resourcePath + options.startImageFilename : "../../common/images/start.png",
		loadingImageWhiteSrc = options.loadingImageWhiteFilename !== undefined ? options.resourcePath + options.loadingImageWhiteFilename : "../../common/images/loading-white.png",
		loadingImageColorSrc = options.loadingImageColorFilename !== undefined ? options.resourcePath + options.loadingImageColorFilename : "../../common/images/loading-color.png";
	
	that.type = "LOADING";
	that.percentage = 0.01;
	
	that.render = function () {
	
		var renderImgWidth,
			renderImgHeight;
	
		// Added to handle audio load
		if (that.percentage > 0.98) {
			that.percentage = 0.98;
		}
	
		if (!startTouched) {
			if (imageStartLoaded) {
			
				renderImgWidth = window.innerWidth;//-1 * (startImage.width - that.ctx.canvas.width) / 2;
				renderImgHeight = window.innerHeight//-1 * (startImage.height - that.ctx.canvas.height) / 2;
				/*if (startImage.height - that.ctx.canvas.height > 0) {
					// Adjust for the iOS status bar
					renderImgHeight -= 40;
				}*/
			
				that.ctx.drawImage(
					startImage,
					0,//added x,y coordinates
					0,//added x,y coordinates
					renderImgWidth, 
					renderImgHeight
				);
			}
		
		} else {
			
			if (imageWhiteLoaded) {
				
				that.ctx.fillStyle = "#ffffff";
				that.ctx.fillRect(0, 0, that.ctx.canvas.width, that.ctx.canvas.height);
				
				//added to make loading image fit
				loadImgWidth = loadingImageWhite.width;
				loadImgHeight = loadingImageWhite.height;
				while(loadImgWidth > window.innerWidth || loadImgHeight > window.innerHeight) {
					loadImgWidth *= 0.9;
					loadImgHeight *= 0.9;
				}

				loadImgWidth *= 0.9;
				loadImgHeight *= 0.9;
				
				that.ctx.drawImage(
					loadingImageWhite,
					(window.innerWidth - loadImgWidth) / 2,
					(window.innerHeight - loadImgHeight) / 2,
					loadImgWidth,
					loadImgHeight
				);
				if (imageColorLoaded) {
					that.ctx.drawImage(
						loadingImageColor, 
						0, 
						loadingImageColor.height - loadingImageColor.height * that.percentage, 
						loadingImageColor.width, 
						loadingImageColor.height * that.percentage, 
						(window.innerWidth - loadImgWidth) / 2,
						(window.innerHeight - loadImgHeight) / 2 + loadImgHeight - loadImgHeight * that.percentage,
						loadImgWidth, 
						loadImgHeight * that.percentage
					);
				}
			}

			that.ctx.fillStyle = "#aaaaaa";
			that.ctx.textAlign = "right";
			that.ctx.font = 'bold 14px Arial';
			that.ctx.fillText(
				"LOADING ",
				(window.innerWidth - loadImgWidth) / 2 + loadImgWidth - 35,
				(window.innerHeight - loadImgHeight) / 2 + loadImgHeight + 20
			);
			that.ctx.fillText(
				GLOBAL.parseInt(that.percentage * 100, 10) + "%", 
				(window.innerWidth - loadImgWidth) / 2 + loadImgWidth,
				(window.innerHeight - loadImgHeight) / 2 + loadImgHeight + 20
			);
		}
	};
	
	that.load = function () {
		
		that.ctx.fillStyle = "#ffffff";
		that.ctx.fillRect(0, 0, that.ctx.canvas.width, that.ctx.canvas.height);
		
		startImage.onload = function () {
			imageStartLoaded = true;
			that.render();
		};
		startImage.src = startImageSrc;
		
		loadingImageWhite.onload = function () {
			imageWhiteLoaded = true;
			that.width = loadingImageWhite.width;
			that.height = loadingImageWhite.height;
			that.render();
			if (imageColorLoaded) {
				that.dispatchEvent("READY");
			}
		};
		loadingImageWhite.src = loadingImageWhiteSrc;
		
		loadingImageColor.onload = function () {
			imageColorLoaded = true;
			that.width = loadingImageColor.width;
			that.height = loadingImageColor.height;
			that.render();
			if (imageWhiteLoaded) {
				that.dispatchEvent("READY");
			}
		};
		loadingImageColor.src = loadingImageColorSrc;	
	};
	
	that.touchStart = function (point) {
	
		startTouched = true;
		that.render();
	};
	
	that.destroy = function () {
		
		
	};
	
	return that;
}