/**
*  William Malone Controller
*
*  @author William Malone (www.williammalone.com)
*/

/*global WM */

WM.controller = function (GLOBAL, element) {
					
	"use strict";

	var that = WM.dispatcher(),
	
		touchHandler = function (e) {
			var touch = e.changedTouches[0];
	
			switch (e.type) {
			case "touchstart": 
				that.dragging = true;
				that.dispatchEvent("TOUCH_START", {
					x: touch.clientX * 1024/window.innerWidth,
					y: touch.clientY * 768/window.innerHeight
				});
				break;
			case "touchmove": 
				that.dispatchEvent("TOUCH_MOVE", {
					x: touch.clientX * 1024/window.innerWidth,
					y: touch.clientY * 768/window.innerHeight
				});
				// Prevent scrolling
				e.preventDefault();
				break;        
			case "touchend": 
				that.dragging = false;
				that.dispatchEvent("TOUCH_END", {
					x: touch.clientX * 1024/window.innerWidth,
					y: touch.clientY * 768/window.innerHeight
				});
				break;
			case "touchcancel": 
				that.dragging = false;
				that.dispatchEvent("TOUCH_CANCEL", {
					x: touch.clientX * 1024/window.innerWidth,
					y: touch.clientY * 768/window.innerHeight
				});
				break;
			default: return;
			}
		},
		
		updateOrientation = function () {

			switch (GLOBAL.orientation) {
		  
			case 0: //Portrait
				that.orientation = "PORTRAIT";
				break;
		
			case -90: //Landscape (right, screen turned clockwise)
				that.orientation = "LANDSCAPE";
				break;
		
			case 90: //Landscape (left, screen turned counterclockwise)
				that.orientation = "LANDSCAPE";
				break;
		
			case 180: //Portrait (upside-down portrait)
				that.orientation = "PORTRAIT";
				break;
				
	        }
			
			that.dispatchEvent("ORIENTATION_CHANGE", {
				orientation: that.orientation
			});
	
		};
		
	that.dragging = false;
	that.orientation = "UNKNOWN";

	that.mouseDownHandler = function (e) {
		that.dragging = true;
		that.dispatchEvent("TOUCH_START", {
			x: e.clientX * 1024/window.innerWidth,
			y: e.clientY * 768/window.innerHeight
		});
	};
	
	that.mouseMoveHandler = function (e) {
		that.dispatchEvent("TOUCH_MOVE", {
			x: e.clientX * 1024/window.innerWidth,
			y: e.clientY * 768/window.innerHeight
		});
	};
	
	that.mouseUpHandler = function (e) {
		that.dragging = false;
		that.dispatchEvent("TOUCH_END", {
			x: e.clientX * 1024/window.innerWidth,
			y: e.clientY * 768/window.innerHeight
		});
	};
	
	that.mouseCancelHandler = function (e) {
		that.dragging = false;
		that.dispatchEvent("TOUCH_CANCEL", {
			x: e.clientX * 1024/window.innerWidth,
			y: e.clientY * 768/window.innerHeight
		});
	};
	
	that.onOrientationChange = function () {
		updateOrientation();
	}

	element.onmousedown = that.mouseDownHandler;
	element.onmousemove = that.mouseMoveHandler;
	element.onmouseup = that.mouseUpHandler;
	element.onmouseout = that.mouseCancelHandler;
	
	element.addEventListener("touchstart", touchHandler);
	element.addEventListener("touchmove", touchHandler);
	element.addEventListener("touchend", touchHandler);
	element.addEventListener("touchcancel", touchHandler); 
	
	// Let player detect orientation change
	//GLOBAL.onorientationchange = updateOrientation;
	
	updateOrientation();

	return that;
};