/**
*  @author William Malone (www.williammalone.com)
*/

WM.targetItem = function (GLOBAL, WM) {
	
	var that = WM.dispatcher(),
		states = {},
		currentState,
		userInteractionStart;	
		
	that.type = "TARGET";
	that.userInteracting = false;
	
	that.foundComplete = function () {
		WM.debug("FOUND COMPLETE");
	}
	
	that.setState = function (type) {
		
		// State type is not case sensitive
		type = type.toUpperCase();
		
		if (states[type] === undefined) {
			//WM.warning({
			//	name: "UnknownState",
			//	message: "State not recognized: " + type
			//});
		} else {
			currentState = type;
		}
	}
	that.addState = function (spec) {
		
		// State type is not case sensitive
		spec.type = spec.type.toUpperCase();
		
		if (spec.numFrames && spec.numFrames > 1) {
			states[spec.type] = WM.sprite(GLOBAL, WM, spec.ctx, spec);
		} else {
			states[spec.type] = WM.view(GLOBAL, WM, spec.ctx, spec);
		}
	};
	
	that.wiggle = function () {
		states[currentState].wiggle();
	};
	
	that.getBounds = function () {
		return 	{
			x: states[currentState].x,
			y: states[currentState].y,
			width: states[currentState].width,
			height: states[currentState].height
		};
	};
	
	that.update = function () {
		states[currentState].update();
	};
	
	that.render = function () {
		// TODO: not always dirty
		states[currentState].dirty = true;
		states[currentState].render();
	};
	
	that.touchStart = function (point) {
		that.userInteracting = true;
		userInteractionStart = {x: point.x, y: point.y};
		states[currentState].touchStart(point);
	};
	that.touchMove = function (point) {	
		if (that.userInteracting) {
			if (currentState === "HIDDEN" && states["DRAG"] !== undefined) {
				that.setState("DRAG");
				states[currentState].touchStart(point);
			}
		}
		states[currentState].touchMove(point);
	};
	that.touchEnd = function (point) {
		that.userInteracting = false;
		states[currentState].touchEnd(point);
	};
	that.rectangleCollisionDetection = function (rect) {
		return states[currentState].rectangleCollisionDetection(rect);
	};
	that.getDistanceDragged = function () {
		return states[currentState].getDistanceDragged();
	};
	
	return that;
}