// by mohamed magdy

var Random = (function () {
	// api || helper (method)
	Math.between = function (min, max) {
		var randomNumber = Math.round(Math.random() * (max - min));
		return randomNumber + min;
	};
	Array.prototype.random = function () {
		return this[Math.between(0, this.length-1)];
	};

	var RandomMethods = {},
			Random 				= Object.create(RandomMethods);

	Random.types 	= null;
	Random.length = null;

	RandomMethods.number = function () { return String(Math.between(0, 9)); };
	RandomMethods.smallCharacter 	 = function () { return this.ASCII(97, 122); };
	RandomMethods.capitalCharacter = function () { return this.ASCII(65, 90); };
	RandomMethods.symbol = function () {
		var symbols = "~!@#$%^&*()_-+=|\\{}[]:;<>?/";
		return symbols.split('').random();
	};

	RandomMethods.getPassword = function () {
		if (this.validation()) {
			var l = this.length, password = "";
			for (; l--;) password += this[this.types.random()]();
			return password;
		} else return;
	};

	/* private */

	RandomMethods.ASCII = function (num1, num2) {
		var codeNumber = Math.between(num1, num2);
		return String.fromCharCode(codeNumber);
	};

	RandomMethods.validation = function () {
		return Array.isArray(this.types) && typeof this.length == "number" && this.types.length > 0;
	};

	return Random;
})();