var app = angular.module('myApp', []);

app.controller('PasswordCtrl', ['$scope', function($scope){
	$scope.DATA = DATA('savePassword');
	$scope.edit = [];
	$scope.edit.root = false;

	// password length
	$scope.length = 8;
	// start basic password types
	$scope.types = {
		number: 					true,
		smallCharacter: 	true,
		capitalCharacter: false,
		symbol: 					false
	};
	// passwords array
	$scope.passwords = $scope.DATA.findAll() || [];

	$scope.guessPassword = function () {
		var types = Object.keys($scope.types);
				types = types.filter(function (i) { return $scope.types[i] });

		if ($scope.length != undefined && types.length > 0) {
			Random.types  = types;
			Random.length = $scope.length;
			$scope.password = Random.getPassword();
		}
	};

	// save password function
	$scope.savePassword = function (password) {
		if (confirm('save ' + password + ' to local database?')) {
			$scope.DATA.addNew(password);
			$scope.passwords = $scope.DATA.findAll() || [];
		}
	};

	$scope.remove = function (password) {
		if (confirm('remove ' + password + ' from local database?')) {
			$scope.DATA.remove(password);
			$scope.passwords = $scope.DATA.findAll() || [];
		}
	};

	$scope.toggleEdit = function (index, newPassword) {
		$scope.edit[index] = !$scope.edit[index];

		if (index != 'root') {
			var dataObject = $scope.DATA
			var allData = dataObject.findAll();
			allData[index] = newPassword;
			dataObject.save(allData);
			$scope.passwords = $scope.DATA.findAll() || [];
		}
	};

}]);
