/*
game.js
estrutura do jogo
@author: Fulano da Silva <fulanosilva@email.com>
@date: 11/06/2014
@modified: Zé das Cove <zedascove@email.com>
@date: 11/06/2014
*/

//VARIAVEIS GLOBAIS

//variavel STATE do jogo
var STATE = 'splash';

// cria o canvas
var canvas = document.createElement("canvas");
//pega o contexto
var ctx = canvas.getContext("2d");
//configura o tamanho
canvas.width = 480;
canvas.height = 320;

//adiciona o canvas no html
document.body.appendChild(canvas);

//variavel tempo cronometro
var tempo = 10;
//variavel contador de vida
var life = 3;
//-- carregando as imagens --

// imagem de fundo
var bgReady = false;
var bgImage = new Image();
//informa quando a imagem está carregada
bgImage.onload = function() {
	bgReady = true;
};
//informa qual imagem carregar
bgImage.src = "images/background-32.png";

// imagem do botão
var imagempronta = false;
var IMAGEM = new Image();
IMAGEM.onload = function(){
	imagempronta = true;
};
IMAGEM.src = "images/entrar02.png";


// imagem do herói
var heroReady = false;
var heroImage = new Image();
heroImage.onload = function() {
	heroReady = true;
};
heroImage.src = "images/hero.png";

// imagem do monstro/inimigo
var monsterReady = false;
var monsterImage = new Image();
monsterImage.onload = function() {
	monsterReady = true;
};
monsterImage.src = "images/monster.png";

// OBJETOS do jogo
var hero = {
	speed : 256, // movimento em pixels por segundo
	x : 0,
	y : 0,
	frames: 1 // marca qual frame uar
	
};

var monster = {
	x : 0,
	y : 0
};

//marca quantos monstros eu peguei
var monstersCaught = 0;

// trabalha com as teclas pressionadas
var keysDown = {};

//quando pressionar a tecla
addEventListener("keydown", function(e) {
	keysDown[e.keyCode] = true;
}, false);

//quando soltar a tecla
addEventListener("keyup", function(e) {
	delete keysDown[e.keyCode];
}, false);

//guarda onde foi tocado na tela
var toqueNaTela = {
	x : 0,
	y : 0
};

//prepara o canvas para ser redimencionado 
addEventListener("resize", redimensionarTela, false);

function redimensionarTela(){
	var larguraParaAltura = 480/320;
	var novaLargura = window.innerWidth;//área interna da janela 
	var novaAltura = window.innerHeight;//área interna da janela 
	var novaLarguraParaAltura = novaLargura / novaAltura;
	
	if( novaLarguraParaAltura > larguraParaAltura ){
		//ajusata a partir da lagura da tela 
		novaLargura = novaAltura * larguraParaAltura;
	}else{
		//ajusta a partir da altura da tela
		novaAltura = novaLargura / larguraParaAltura;
	}
	
	canvas.style.width = novaLargura + "px";
	//canvas.style.height = novaAltura + "px";
}

//preparar eventos de toque
addEventListener("touchstart", function(e) {
	//evita comportamento padrão
	e.preventDefault();

	//pega todos os toques da tela
	toques = e.changedTouches;

	//exibe X e Y de UM toque na página
	toqueNaTela.x = toques[0].pageX - parseInt(canvas.offsetLeft);
	toqueNaTela.y = toques[0].pageY - parseInt(canvas.offsetTop);
	
	/*exemplo para pegar a posição correta num botão:
		//pega a posição da tela 
		var proporcao = parseInt( canvas.style.width ) / 480;
		
		//verifica se clicou dentro da área de um botão 
		if(
			( ( posX >= botao.x * proporcao ) 
			&& 
			( posY >= botao.y * proporcao) )
			&&
			( ( posX <= ( botao.x + botao.largura ) * proporcao ) 
			&&
			( posY <= (botao.y + botao.altura) * proporcao ) )
		){
			//faz alguma coisa
			alert("clicou")
		}
		
	*/
}, false);

//desmarca o toque
addEventListener("touchend", function(e) {
	//evita comportamento padrão
	e.preventDefault();

	toqueNaTela.x = 0;
	toqueNaTela.y = 0;

}, false);

// restarta o jogo logo após pegar um monstro
var reset = function() {
	hero.x = canvas.width / 2;
	hero.y = canvas.height / 2;

	//joga o monstro aleatoriamente em algum lugar da tela
	monster.x = 32 + (Math.random() * ( (canvas.width - 64) - 32 ) );
	monster.y = 32 + (Math.random() * ( (canvas.height - 64) - 32 ) );
};

// atualiza os objetos do jogo
var update = function(modifier) {
	switch (STATE) {
		case 'splash' :
			//mostra a tela inicial do jogo, logo após muda o STATE do jogo para main
			var proporcao = parseInt(canvas.style.width) / 480;
			 
			if ( ( toqueNaTela.x > 64 * proporcao ) && ( toqueNaTela.y > 256 * proporcao ) &&
				( toqueNaTela.x < 256* proporcao ) && ( toqueNaTela.y < 416 * proporcao ) ){
				STATE = 'main';
				//telainicial();
			}
			
			break;
		case 'main':

			if ( ( 38 in keysDown ) && ( hero.y > 32 ) ) { // Player seta p/ cima
				hero.y -= hero.speed * modifier;
			}
			if ( ( 40 in keysDown ) && ( hero.y < 256 ) ) { // Player seta p/ baixo
				hero.y += hero.speed * modifier;
			}
			if ( ( 37 in keysDown ) && ( hero.x > 32 ) ) { // Player seta esquerda
				hero.x -= hero.speed * modifier;
			}
			if ( ( 39 in keysDown ) && ( hero.x < 416 ) ) { // Player seta direita
				hero.x += hero.speed * modifier;
			}

			//verifica onde enviar o personagem de acordo com o toque
			if (toqueNaTela.x > 0) {
				hero.x = toqueNaTela.x;
			}
			if (toqueNaTela.y > 0) {
				hero.y = toqueNaTela.y;
			}
			//tempo e vida do personagem
			if (tempo == 0) {
				
				alert("fim de jogo");
				tempo = 10;
				monstersCaught = 0;
				life --;
				
				if(life <= 0){
					//chama gameover
					STATE = gameover;
				}
			}
			if (monstersCaught == 5) {
				alert("Parabéns !!");
				tempo = 10;

			}

			// eles estão se tocando/colidindo?
			if (hero.x <= (monster.x + 32) && monster.x <= (hero.x + 32) && hero.y <= (monster.y + 32) && monster.y <= (hero.y + 32)) {++monstersCaught;
				reset();
			}
			
			

			break;
			case 'gameover':
			//inicia a tela de gameover
			
			break;
	}
};


// Prepara animação do personagem
setInterval( function() {
	hero.frames = ( hero.frames == 1 ) ? 0 : 1;
}, 100 );


// Desenha os objetos na tela
var render = function() {

	switch (STATE) {
		case 'splash' :
		
			var proporcao = parseInt(canvas.style.width) / 480;
			 
			if ( (toqueNaTela.x >= ( 160 * proporcao ) ) && ( toqueNaTela.y >= ( 200 * proporcao ) ) &&
				( toqueNaTela.x <= ( 160 + 150 ) * proporcao ) && ( toqueNaTela.y <= ( 200 + 78 ) * proporcao ) ){
				STATE = 'main';
				//telainicial();
			}
			if ( 13 in keysDown ) {
				STATE = 'main';
			}
			
			//mostra a tela inicial do jogo, logo após muda o STATE do jogo para main
			if (bgReady) {
				ctx.drawImage(bgImage, 0, 0);
			}
			if (imagempronta == true){
				ctx.drawImage(IMAGEM, 160, 200);
			}
			if (heroReady) {
				ctx.drawImage(heroImage, 150,100);
			}

			if (monsterReady) {
				ctx.drawImage(monsterImage, 300, 100);
			}
			// Descrição do jogo
			ctx.fillStyle = "black";
			ctx.font = "24px Helvetica";
			ctx.textAlign = "left";
			ctx.textBaseline = "top";
			ctx.fillText("Capture 5 monstros em 10 segundos ", 42, 145);
			ctx.fillText("para que você proteja sua vila", 42, 169 );
			
			break;
		case 'main':
			//da um loop que inicia o jogo
			if (bgReady) {
				ctx.drawImage(bgImage, 0, 0);
			}

			if (heroReady) {
				// ctx.drawImage(heroImage, hero.x, hero.y);
				ctx.drawImage(heroImage,
										hero.frames * 32, 0, // X e Y dentro da imagem
										32, 32, // altura e largura dentro da imagem
										hero.x, hero.y, // X e Y na tela (canvas)
										32, 32 ); // área da imagem no canvas
			}

			if (monsterReady) {
				ctx.drawImage(monsterImage, monster.x, monster.y);
			}

			// Pontuação
			ctx.fillStyle = "rgb(250, 250, 250)";
			ctx.font = "24px Helvetica";
			ctx.textAlign = "left";
			ctx.textBaseline = "top";
			ctx.fillText("Monstros capturados: " + monstersCaught, 32, 32);
			ctx.fillText("Vida: " + life, 32, 62);

			//cronometro
			ctx.fillStyle = "255 0 0";
			ctx.font = "24px Helvetica";
			ctx.textAlign = "right";
			ctx.textBaseline = "top";
			ctx.fillText("Tempo:" + tempo, 448, 32);

			break;
		case 'gameover':
			//inicia a tela de gameover
				// escreve gameover
				ctx.fillStyle = "black";
				ctx.font = "38px Helvetica";
				ctx.textAlign = "left";
				ctx.textBaseline = "top";
				ctx.fillText("GameOver!", 42, 175);
			break;
	}
};

//funções de tempo e cronometro
function cronometro() {
	if ( STATE == 'main' ){
		tempo = tempo - 1;
	}
	
}



// function do Loop PRINCIPAL do jogo
var main = function() {
	var now = Date.now();
	var delta = now - then;

	//atualiza tudo
	update(delta / 1000);

	//desenha tudo
	render();

	then = now;

	// desenha de acordo com o navegador
	requestAnimationFrame(main);

};


window.setInterval(cronometro, 1000);
//window.setTimeout(pausa, 100000);

// Hora do jogo começar!!!
var then = Date.now();

function telainicial() {
	//teste botão

	alert("");
	
};

//zerando posições dos objetos
reset();
//Redimenciona tela
redimensionarTela();
//chama o LOOP principal
main();

