/* =======================================================
	game.js
		Estrutura do jogo
	@author: Fulano da Silva <fulano@email.com>
	@date: 11/06/2014
	@mod_by: Quem Mudou <quem_mudou@email.com>
	@modified: 25/06/2014
====================================================== */

/*
	Proposta de Exercício
		- fazer os personagens se moverem (sprites)
		- limitar a área onde o herói pode ir
		- limitar a área onde os monstros podem ir
		- regras:
			- pegar 10 monstros por fase
			- limite de tempo: 30 segundos
		- criar telas:
			- inicial
			- jogo (gameplay)
			- gameover
			- créditos
		- música de fundo
		- escolher o nome do jogo!
		
		- NOME DO TIME
			- participantes (nome completo)
*/



window.onload = function() {


window.animationFrame = ( function() {
	return window.requestAnimationFrame			||
		   window.webkitRequestAnimationFrame	||
		   window.mozRequestAnimationFrame		||
		   window.oRequestAnimationFrame		||
		   window.msRequestAnimationFrame		||
		   function( /* function */ callback, /* DOMElement */ element ) {
				window.setTimeout( callback, 1000 / 10 );
		   };
} ) ();




/* ========================
	VARIAVEIS GLOBAIS
========================*/

// ---[ CANVAS ]--- //
// Cria o canvas
var canvas = document.createElement( "canvas" );
// Pega o contexto
var ctx = canvas.getContext( "2d" );
// Cofigura o tamanho
canvas.width  = 480;
canvas.height = 320;
// Adiciona o canvas no HTML
document.body.appendChild( canvas );


// Variavel STATE do jogo
var STATE = "splash";
// Variavel tempo cronometro
var tempo = 10;
// Variavel contador de vida
var life = 3;
// Level do jogo
var level = 1;



/* ============================
	Carregando as imagens
============================*/

// ---[ Imagem de fundo ]--- //
// Para saber se a imagem foi carregada
var bgImageReady = false;
var bgImage = new Image(); // Cria uma imagem
// Informa quando a imagem está carregada
bgImage.onload = function() {
	bgImageReady = true;
};
// Informa qual imagem carregar
bgImage.src = "images/background.png";



// ---[ Logo do Jogo ]--- //
var imgLogoJogoReady = false;
var imgLogoJogo = new Image();
imgLogoJogo.onload = function(){
	imgLogoJogoReady = true;
};
imgLogoJogo.src = "images/Logo-game03.png";


// ---[ Logo do Time ]--- //
var imgLogoTimeReady = false;
var imgLogoTime = new Image();
imgLogoTime.onload = function(){
	imgLogoTimeReady = true;
}; // FIM botaoReset.onload
imgLogoTime.src = "images/Logo-PoyoLoco01.png";


// ---[ Botão de Entrar ]--- //
var btnEntrarReady = false;
var btnEntrar = new Image();
btnEntrar.onload = function(){
	btnEntrarReady = true;
};
btnEntrar.src = "images/entrar.png";


// ---[ Botão de Creditos ]--- //
var btnCreditosReady = false;
var btnCreditos = new Image();
btnCreditos.onload = function(){
	btnCreditosReady = true;
}; // FIM botaoCreditos.onload
btnCreditos.src = "images/creditos.png";


// ---[ Botão de Reset ]--- //
var btnResetReady = false;
var btnReset = new Image();
btnReset.onload = function(){
	btnResetReady = true;
}; // FIM botaoReset.onload
btnReset.src = "images/reset.png";



// ---[ Botão de Som ]--- //
var btnSomReady = false;
var btnSom = new Image();
btnSom.onload = function() {
	btnSomReady = true;
};
btnSom.src = "images/som.png";

// ---[ Herói ]--- //
var heroReady = false;
var heroImage = new Image();
heroImage.onload = function() {
	heroReady = true;
};
heroImage.src = "images/hero-andando.png";


// ---[ Monstro/Inimigo ]--- //
var monsterReady = false;
var monsterImage = new Image();
monsterImage.onload = function() {
	monsterReady = true;
};
monsterImage.src = "images/monster-andando-todos.png";


// ---[ Obstáculos ]--- //
var imgCaixaReady = false;
var imgCaixa = new Image();
imgCaixa.onload = function() {
	imgCaixaReady = true;
}
imgCaixa.src = "images/container_sprites.png";



/* ======================
	OBJETOS do jogo
======================*/

// ---[ Redimensionando Tela ]--- //
// Prepara o canvas para ser dimensionado
addEventListener( "resize", redimensionarTela, false );

function redimensionarTela() {
	
	var larguraParaAltura	  = 480 / 320;			// dividir do tamanho maior pelo menor
	var novaLargura			  = window.innerWidth;	// área interna da janela
	var novaAltura			  = window.innerHeight; // área interna da janela
	var novaLarguraParaAltura = novaLargura / novaAltura;
	
	// Se a tela for maior que 480 x 320
	if( novaLarguraParaAltura > larguraParaAltura ) {
		// Ajusta a partir da largura da tela
		novaLargura = novaAltura * larguraParaAltura;
	
	// Se a tela for menor que 480 x 320
	} else {
		// Ajusta a partir da altura da tela
		novaAltura = novaLargura / larguraParaAltura;
	}
	
	canvas.style.width = novaLargura + "px";
	// canvas.style.height = novaAltura + "px";
	
}; // FIM redimensionarTela


// ---[ Som de Fundo ]--- //
// var som1 = new Audio( "som/bgm_rocker.ogg" );
var som1	= new Audio();
som1.src	= "som/bgm_techno.ogg";
som1.loop	= true;
som1.paused = true;
som1.load();


// ---[ Som de Efeito ]--- //
// var som2 = new Audio( "som/Plopp-jh-8598_hifi.mp3" );
var som2 = new Audio();
som2.src = "som/rm2k3_pu-MoKkAn-8376_hifi.mp3";


// ---[ Herói ]--- //
var hero = {
	speed	 : 256, // Movimento em pixels por segundo
	x		 : 0,
	y		 : 0,
	frames	 : 1,	// Marca qual frame usar
	destinoX : 0,	// para onde o personagem deve ir em X
	destinoY : 0	// para onde o personagem deve ir em Y
}; // FIM hero


// ---[ Monstros/Inimigos ]--- //
var monster = {
	x		: 0,
	y		: 0,
	framesX : 1, // frame na posição X (largura)
	framesY : 0	 // frame na posição Y (altura)
}; // FIM monster
// Marca quantos monstros eu peguei
var monstersCaught = 0;
// marca o total de monstros pegos
var monstersTotal = 0;


// ---[ Obstáculos ]--- //
// Array dos obstáculos do jogo
var CAIXAS = new Array();
function criaCaixas( level ) {

	// Zera o array anterior
	CAIXAS = new Array();

	// Gera a quantidade de caixas aleatória
	quantidadeCaixas = Math.ceil( ( ( Math.random() * ( ( level * 2 ) - 1 ) ) + 0 ) - 1 );
	
	if( quantidadeCaixas <= 2 ) {
		quantidadeCaixas = Math.ceil( ( ( Math.random() * ( ( level * 2 ) - 1 ) ) + 0 ) - 1);
	} // FIM if

	// Adiciona as caixas com posição aleatória
	for( i = 0; i < +quantidadeCaixas; i++ ) {
		if( ( ( (hero.x + 26) != (CAIXAS.x + 32) ) && 
			  ( (hero.y + 26) != (CAIXAS.y + 32) ) ) && 
			  ( ( (monster.x + 26) != (CAIXAS.x + 32) ) && 
			  ( (monster.y + 26) != (CAIXAS.y + 32) ) ) ){
					
			CAIXAS.push( {
				x : Math.ceil( ( ( Math.random() * ( 486 - 26 ) ) + 32 ) - 32 ),
				y : Math.ceil( ( ( Math.random() * ( 454 - 26 ) ) + 32 ) - 32 ),
				x : Math.ceil( ( ( Math.random() * ( 486 - 26 ) ) + 32 ) - 32 ),
				y : Math.ceil( ( ( Math.random() * ( 454 - 26 ) ) + 32 ) - 32 )
			} );
		
		} // FIM if
		
	} // FIM for
	
} // FIM criaCaixas


// ---[ Cronometro ]--- //
// Funções de tempo e cronometro
function cronometro() {
	
	if( STATE == "main" ) {
		tempo = tempo - 1;
		
		// Se a contagem for menor que 10
		if( tempo < 10 ) {
			// Acrescentar o 0 (zero) na frente
			tempo = "0" + tempo;
			// Retorna uma nova string com 2 caracteres
			tempo = tempo.substr( 0, 2 );
		} // FIM if
		
	} // FIM if
	
} // FIM cronometro


// ---[ Teclado ]--- //
// Trabalha com as teclas pressiionadas
var keysDown = {}; // Array das teclas
// Quando pressionar a tecla
addEventListener( "keydown", function( e ) { // e -> evento
	keysDown[e.keyCode] = true;
	hero.movendo = true;
}, false ); // FIM addEventListener
// Quando soltar a tecla
addEventListener( "keyup", function( e ) {
	// delete -> para andar só o tanto que for pressionado
	// se não tiver o delete, vai continuar andando infinitamente 
	// na direção que foi pressionada
	delete keysDown[e.keyCode];
	hero.movendo = false;
	
}, false ); // FIM addEventListener


// ---[ TouchScreen ]--- //
// Guarda onde foi tocado na tela
var toqueNaTela = {
	x : 0,
	y : 0
}; // FIM toqueNaTela
// Preparar eventos de toque
addEventListener( "touchstart", function( e ) {
	
	// Evita comportamento padrão
	e.preventDefault();
	// Pega todos os toques da tela
	toques = e.changedTouches;
	
	// Exibe X e Y de UM toque na página
	// alert( toques[0].pageX + ", " + toques[0].pageY );
	toqueNaTela.x = toques[0].pageX - parseInt( canvas.offsetLeft );
	toqueNaTela.y = toques[0].pageY - parseInt( canvas.offsetTop );
	
	var proporcao = parseInt( canvas.style.width ) / 480;
	// Onde o personagem deve ir
	if( hero ) {
	hero.destinoX = ( toqueNaTela.x / proporcao ) - 16;
	hero.destinoY = ( toqueNaTela.y / proporcao ) - 16;
	
	} else {
		toqueNaTela.x / proporcao;
		toqueNaTela.y / proporcao;
	} // FIM else
	
	if( STATE == "splash" ) {
		SomDeFundo( e );
	}
	
	
	hero.movendo = true;
	
	
	/*
		Exemplo para pegar a posição correta num botão:
	
		// Pega a proporção da tela
		var proporcao= parseInt( canvas.style.width ) / 480;
		
		// Verifica se clicou dentro da área de um botão
		if(
			( ( posX >= botao.x * proporcao )
			  &&
			  ( posY >= botao.y * proporcao ) )
			  &&
			( ( posX <= ( botao.x + botao.largura ) * proporcao )
			  &&
			  ( posY <= ( botao.y + botao.altura ) * proporcao ) )
		  ) {
				// Faz alguma coisa
				alert( "Clicou!" );
			 }
	*/
	
}, false ); // FIM addEventListener
// Desmarca o toque
addEventListener( "touchend", function( e ) {
	
	//Evita comportamento padrão
	e.preventDefault();
	
	// toqueNaTela.x = 0;
	// toqueNaTela.y = 0;
	
	
	hero.movendo = false;
	
}, false ); // FIM addEventListener


// ---[ Animação ]--- //
// Prepara animação dos personagens
setInterval( function() {
	
	hero.frames = ( hero.frames == 1 ) ? 0 : 1;
	monster.framesX = ( monster.framesX == 1 ) ? 0 : 1;
	
}, 100 );


// ---[ RESET ]--- //
// Restarta o jogo logo após pegar um monstro
var reset = function() {
	
	// Joga o herói para o centro do canvas
	hero.x = canvas.width / 2;
	hero.y = canvas.height / 2;
	
	// Joga o monstro aleatoriamente em algum lugar da tela
		// ( ( canvas.width - 64 ) - 32 ) -> delimita a área 
		// do canvas onde tem as árvores
	monster.x = 32 + ( Math.random() * ( ( canvas.width - 64 ) - 32 ) );
	monster.y = 32 + ( Math.random() * ( ( canvas.height - 64 ) - 32 ) );
	// Escolhe aleatoriamente o monstro
	monster.framesY = Math.ceil( ( ( Math.random() * ( 3 - 0 ) ) + 0 ) - 1 ) * 32;
	
	toqueNaTela.x = 0;
	toqueNaTela.y = 0;
	
}; // FIM reset


// ---[ Botão de Som ]--- //
function SomDeFundo( e ) {
var proporcao = parseInt( canvas.style.width ) / 480;
// ---[ Botão de Som ]--- //
// Se tocar na tela o botão de Som
	if( ( toqueNaTela.x >= ( 32 * proporcao ) ) && 
		( toqueNaTela.y >= ( 286 * proporcao ) ) &&
		( toqueNaTela.x <= ( ( 32 + 32 ) * proporcao ) ) && 
		( toqueNaTela.y <= ( ( 286 + 32 ) * proporcao ) ) // ||
		// OU se apertar o botão SHIFT do teclado
		// ( 16 in keysDown ) 
	) {
			if( som1.paused == true ) {
				// Play Som de Fundo
				som1.play();
				//alert("Clicou");
				
			} else {
				// Pause Som de Fundo
				som1.pause();
			} // FIM else
						
	} // FIM if
} // FIM SomDeFundo


// ---[ UPDATE ]--- //
// Atualiza os objetos do jogo
	// Lógica ( Controller )
var update = function( modifier ) {
	
	switch( STATE ) {
		
		case "splash":
				
				// Mostra a tela inicial do jogo, logo após muda o STATE do jogo para main
				
				// Ajustar as coordenadas do toque ao tamanho da tela
				var proporcao = parseInt( canvas.style.width ) / 480;
				
				// ---[ Botão de Entrar ]--- //
				// Se tocar na tela o botão de Entrar
				if( ( toqueNaTela.x >= ( 66.5 * proporcao ) ) && 
					( toqueNaTela.y >= ( 225 * proporcao ) ) && 
					( toqueNaTela.x <= ( ( 66.5 + 150 ) * proporcao ) ) && 
					( toqueNaTela.y <= ( ( 225 + 50 ) * proporcao ) ) || 
					// Ou se apertar o botão ENTER do teclado
					( 13 in keysDown ) ) {
						// Começa o jogo
						STATE = "main";
						tempo = 10;
						// Contador de vida
						life = 3;
						// Level do jogo
						level = 1;
						monstersTotal = 0;
						//telainicial();
				} // FIM if
				
				
				// ---[ Botão de Creditos ]--- //
				// Se tocar na tela o botão de Creditos
				if( ( toqueNaTela.x >= ( 246.5 * proporcao ) ) && 
					( toqueNaTela.y >= ( 225 * proporcao ) ) &&
					( toqueNaTela.x <= ( ( 246.5 + 187 ) * proporcao ) ) && 
					( toqueNaTela.y <= ( ( 225 + 50 ) * proporcao ) ) || 
					// Ou se apertar o botão CTRL do teclado
					( 17 in keysDown ) ) {
						// Mostra a tela dos creditos
						STATE = "creditos";
				} // FIM if
				
				
				if( 16 in keysDown ) {
					if( som1.paused == true ) {
						// Play Som de Fundo
						som1.play;
						//alert("Clicou");
						
					} else {
						// Pause Som de Fundo
						som1.pause;
					} // FIM else
				} // FIM if
				
				
				//addEventListener( "touchstart", SomDeFundo, false );
					
			break;
		
		
		case "main":
				// ---[ Herói ]--- //
				// Movimentos do herói na tela por:
				
				// ---[ Teclado ]--- //
				// ---[ Player seta p/ cima ]--- //
				if( ( 38 in keysDown ) && 
					// E delimitando a área de cima onde tem as árvores
					( hero.y > 32 ) ) {
						hero.y -= hero.speed * modifier;
						hero.movendo = true;
				} // FIM if
				
				// ---[ Player seta p/ baixo ]--- //
				if( ( 40 in keysDown ) && 
					// E delimitando a área de baixo onde tem as árvores
					( hero.y < 256 ) ) {
						hero.y += hero.speed * modifier;
						hero.movendo = true;
				} // FIM if
				
				// ---[ Player seta p/ esquerda ]--- //
				if( ( 37 in keysDown ) && 
					// E delimitando a área da esquerda onde tem as árvores
					( hero.x > 32 ) ) {
						hero.x -= hero.speed * modifier;
						hero.movendo = true;
				} // FIM if
				
				// ---[ Player seta p/ direita ]--- //
				if( ( 39 in keysDown ) && 
					// E delimitando a área da direita onde tem as árvores
					( hero.x < 416 ) ) {
						hero.x += hero.speed * modifier;
						hero.movendo = true;
				} // FIM if
				
				
				// ---[ TouchScreen ]--- //
				// Ajustar as coordenadas do toque ao tamanho da tela
				var proporcao = parseInt(canvas.style.width) / 480;
				
				// Verifica onde enviar o personagem de acordo com o toque
				// Coordenadas de acordo com a largura da tela
				if( ( ( toqueNaTela.x / proporcao ) > 0 ) && 
					( ( toqueNaTela.x / proporcao ) > 32 ) &&
					( ( toqueNaTela.x / proporcao ) < 432 ) ) {
						// hero.x = ( toqueNaTela.x * proporcao ) - 16;
						if( hero.destinoX > hero.x ) {
							hero.x += 5;
						} else {
							hero.x -= 5;
						} // FIM else
				} // FIM if
				
				
				// Coordenadas de acordo com a altura da tela
				if( ( ( toqueNaTela.y / proporcao ) > 0 ) && 
					( ( toqueNaTela.y / proporcao ) > 32 ) && 
					( ( toqueNaTela.y / proporcao ) < 272 ) ) {
						// hero.y = ( toqueNaTela.y * proporcao ) - 16;
						if( hero.destinoY > hero.y ) {
							hero.y += 5;
						} else {
							hero.y -= 5;
						} // FIM else
				} // FIM if
				
				
				// ---[ Obstáculos ]--- //
				// Verifica se o herói esta tocando/colidindo com os obstáculos
				for( var i = 0; i < CAIXAS.length; i++ ) {
					
					//alert( typeof( objetos)  );
					if( ( hero.x <= ( CAIXAS[i].x + 26 ) ) && 
						( CAIXAS[i].x <= ( hero.x + 26 ) ) && 
						( hero.y <= ( CAIXAS[i].y + 26 ) ) && 
						( CAIXAS[i].y <= ( hero.y + 26 ) ) ) {
							
							// ---[ Player seta p/ cima ]--- //
							if( 38 in keysDown ) {
								hero.y += 5;
								hero.movendo = true;
								hero.destinoY = hero.y - 25;
							} // FIM if
							// ---[ Player seta p/ baixo ]--- //
							if( 40 in keysDown ) {
								hero.y -= 5;
								hero.movendo = true;
								hero.destinoY = hero.y + 25;
							} // FIM if
							// ---[ Player seta p/ esquerda ]--- //
							if( 37 in keysDown ) {
								hero.x += 5;
								hero.movendo = true;
								hero.destinoX = hero.x - 25;
							} // FIM if
							// ---[ Player seta p/ direita ]--- //
							if( 39 in keysDown ) {
								hero.x -= 5;
								hero.movendo = true;
								hero.destinoX = hero.x + 25;
							} // FIM if
							
							
							// Verifica onde enviar o personagem de acordo com o toque
							// Coordenadas de acordo com a largura da tela
							if( ( ( toqueNaTela.x / proporcao ) > 0 ) && 
								( ( toqueNaTela.x / proporcao ) > 32 ) &&
								( ( toqueNaTela.x / proporcao ) < 432 ) ) {
									// hero.x = ( toqueNaTela.x * proporcao ) - 16;
									if( hero.destinoX > hero.x ) {
										hero.x += 5;
											hero.movendo = true;
											hero.destinoX = hero.x - 25;
									} else {
										hero.x -= 5;
											hero.movendo = true;
											hero.destinoX = hero.x + 25;
									} // FIM else
							} // FIM if
							
							
							// Coordenadas de acordo com a altura da tela
							if( ( ( toqueNaTela.y / proporcao ) > 0 ) && 
								( ( toqueNaTela.y / proporcao ) > 32 ) && 
								( ( toqueNaTela.y / proporcao ) < 272 ) ) {
									// hero.y = ( toqueNaTela.y * proporcao ) - 16;
									if( hero.destinoY > hero.y ) {
										hero.y += 5;
											hero.movendo = true;
											hero.destinoY = hero.y - 25;
									} else {
										hero.y -= 5;
											hero.movendo = true;
											hero.destinoY = hero.y + 25;
									} // FIM else
							} // FIM if
							
							
							
					} // FIM if
				} // FIM for
				
				
				// ---[ Cronometro ]--- //
				// Tempo e vida do personagem
				if( tempo == 0 ) {
					
					// alert( "Fim de jogo" );
					// Reinicia a contagem regressiva do tempo
					tempo = 10;
					// Zera a contagem de monstros
					monstersCaught = 0;
					// Perde uma vida
					life--;
					
					// Se perder todas as vidas
					if( life == 0 ) {
						// Chama gameover
						STATE = "gameover";
					} // FIM if
					
				} // FIM if
				
				
				// ---[ Monstros/Inimigos ]--- //
				// Verifica se o herói pegou um monstro
				// Eles estão se tocando/colidindo?
				if( ( hero.x <= ( monster.x + 32 ) ) &&
					( monster.x <= ( hero.x + 32 ) ) &&
					( hero.y <= ( monster.y + 32 ) ) &&
					( monster.y <= ( hero.y + 32 ) ) ) {
						// Som de efeito
						som2.play();
						// Adiciona um monstro
						++monstersCaught;
						// Total de monstros
						++monstersTotal;
						reset();
				} // FIM if
				
				
				// Verifica se pegou 5 monstros
				if( monstersCaught >= 5 ) {
					//alert("Parabéns !!");
					// Reinicia a contagem regressiva do tempo
					tempo = 10;
					// Zera a contagem de monstros
					monstersCaught = 0;
					// Aumenta um level
					level++;
					// Fase do level com obstáculos
					criaCaixas( level );
				} // FIM if
				
			break;
			
			
		case "gameover":
				
				// Inicia a tela de gameover
				
				// Ajustar as coordenadas do toque ao tamanho da tela
				var proporcao = parseInt( canvas.style.width ) / 480;
				
				// ---[ Botão de Reset ]--- //
				// Se tocar na tela o botão de Reset
				if( ( toqueNaTela.x >= ( 167.5 * proporcao ) ) && 
					( toqueNaTela.y >= ( 180 * proporcao ) ) &&
					( toqueNaTela.x <= ( ( 167.5 + 145 ) * proporcao ) ) && 
					( toqueNaTela.y <= ( ( 180 + 50 ) * proporcao ) ) || 
					// Ou se apertar o botão SPACE do teclado
					( 32 in keysDown ) ) {
						// Volta para a tela inicial
						STATE = "splash";
						//telainicial();
				} // FIM if
				
			break;
			
			
		case "creditos":
				
				// Inicia a tela dos creditos
				
				// Ajustar as coordenadas do toque ao tamanho da tela
				var proporcao = parseInt( canvas.style.width ) / 480;
				
				// ---[ Botão Reset ]--- //
				// Se tocar na tela o botão de Reset
				if( ( toqueNaTela.x >= ( 303 * proporcao ) ) && 
					( toqueNaTela.y >= ( 32 * proporcao ) ) &&
					( toqueNaTela.x <= ( ( 303 + btnReset.width ) * proporcao ) ) && 
					( toqueNaTela.y <= ( ( 32 + btnReset.height ) * proporcao ) ) || 
					// Ou se apertar o botão SPACE do teclado
					( 32 in keysDown ) ) {
						// Volta para a tela inicial
						STATE = "splash";
						//telainicial();
				} // FIM if
				
			break;
			
	} // FIM switch
	
}; // FIM update


// ---[ RENDER ]--- //
// Desenha os objetos na tela
	// render (ou draw) -> só DESENHA (VIEW)
var render = function() {

	switch( STATE ) {
		
		case "splash":
				
				// Mostra a tela inicial do jogo, logo após muda o STATE do jogo para main
				
				// ---[ Imagem de Fundo ]--- //
				if( bgImageReady == true ) {
					// Imagem na posição X e Y
					ctx.drawImage( bgImage, 0, 0 );
				} // FIM if
				
				
				// ---[ Logo do Jogo ]--- //
				if( imgLogoJogoReady == true ) {
					// Imagem na posição X e Y
					ctx.drawImage( imgLogoJogo,
								   0, 0,		// X e Y dentro da imagem
								   220, 135,	// largura e altura da imagem original
								   130, 50,		// posição X e Y na tela (canvas)
								   220, 135 );	// tamanho da imagem que aparece no canvas
				} // FIM if
				
				
				// ---[ Herói ]--- //
				if( heroReady == true ) {
					ctx.drawImage( heroImage,
								   0, 0,	 // X e Y dentro da imagem
								   32, 32,	 // largura e altura da imagem original
								   125, 185, // posição X e Y na tela (canvas)
								   32, 32 ); // tamanho da imagem que aparece no canvas
				} // FIM if
				
				
				// ---[ Monstros/Inimigos ]--- //
				if( monsterReady == true ) {
					ctx.drawImage( monsterImage,
								   0, monster.framesY, // X e Y dentro da imagem
								   30, 30,			   // largura e altura da imagem original
								   320, 185,		   // posição X e Y na tela (canvas)
								   30, 30 );		   // tamanho da imagem que aparece no canvas
				} // FIM if
				
				
				// ---[ Botão de Entrar ]--- //
				if( btnEntrarReady == true ) {
					ctx.drawImage( btnEntrar, 66.5, 225 );
				} // FIM if
				
				
				// ---[ Botão de Creditos ]--- //
				if( btnCreditosReady == true ) {
					ctx.drawImage( btnCreditos, 246.5, 225 );
				} // FIM if
				
				
				// ---[ Botão de Som ]--- //
				if( btnSomReady == true ) {
					
					// ---[ Botão Som ON ]--- //
					if( som1.paused == true ) {
						ctx.drawImage( btnSom, 
									   1 * 32, 0, // X e Y dentro da imagem
									   32, 32,	  // largura e altura da imagem original
									   32, 286,   // posição X e Y na tela (canvas)
									   32, 32 );  // tamanho da imagem que aparece no canvas
					
					// ---[ Botão Som OFF ]--- //
					} else {
						ctx.drawImage( btnSom, 
									   0 * 32, 0, // X e Y dentro da imagem
									   32, 32,	  // largura e altura da imagem original
									   32, 286,	  // posição X e Y na tela (canvas)
									   32, 32 );  // tamanho da imagem que aparece no canvas
					} // FIM else
				} // FIM if
				
			break;
			
			
		case "main":
				
				// Da um loop que inicia o jogo
				
				// ---[ Imagem de Fundo ]--- //
				if( bgImageReady == true ) {
					ctx.drawImage( bgImage, 0, 0 );
				} // FIM if
				
				
				// ---[ Herói ]--- //
				if( heroReady == true ) {
					ctx.drawImage( heroImage, 
								   hero.frames * 32, 0, // X e Y dentro da imagem
								   32, 32,				// largura e altura da imagem original
								   hero.x, hero.y,		// posição X e Y na tela (canvas)
								   32, 32 );			// tamanho da imagem que aparece no canvas
				} // FIM if
				
				
				// ---[ Monstros/Inimigos ]--- //
				if( monsterReady == true ) {
					ctx.drawImage( monsterImage,
								   monster.framesX * 30, monster.framesY, // X e Y dentro da imagem
								   30, 30,								  // largura e altura da imagem original
								   monster.x, monster.y,				  // posição X e Y na tela (canvas)
								   30, 30 );							  // tamanho da imagem que aparece no canvas
				} // FIM if
				
				
				// ---[ Obstáculos ]--- //
				if( imgCaixaReady == true ) {
					
					for( var i = 0; i < CAIXAS.length; i++ ) {
						ctx.drawImage( imgCaixa, 
									   63, 108, 
									   24, 24, 
									   CAIXAS[i].x, CAIXAS[i].y, 
									   24, 24 );
					} // FIM for
					
				} // FIM if
				
				
				// Escrever
				// ---[ Pontuação ]--- //
				ctx.fillStyle = "rgb( 250, 250, 250 )";
				ctx.font = "24px Helvetica";
				ctx.textAlign = "left";
				ctx.textBaseline = "top";
				ctx.fillText( "Monsters caught: " + monstersCaught, 32, 32 );
				ctx.fillText( "Points: " + monstersTotal, 32, 56 );
				ctx.fillText( "Life: " + life, 383, 56 );
				ctx.fillText( "Level: " + level, 32, 264 );
				// ---[ Cronometro ]--- //
				ctx.fillStyle = "rgb( 250, 250, 250 )";
				ctx.font = "24px Helvetica";
				ctx.textAlign = "right";
				ctx.textBaseline = "top";
				ctx.fillText( "Time: " + tempo, 448, 32 );
				
			break;
			
			
		case "gameover":
		
				// Inicia a tela de gameover
				
				// ---[ Imagem de Fundo ]--- //
				if( bgImageReady == true ) {
					ctx.drawImage( bgImage, 0, 0 );
				} // FIM if
				
				
				// ---[ Botão Reset ]--- //
				if( btnResetReady == true ) {
					ctx.drawImage( btnReset, 167.5, 180 );
				} // FIM if
				
				
				// Escrever
				// ---[ GameOver ]--- //
				ctx.fillStyle = "rgb( 0, 0, 0 )";
				ctx.font = "bolder 40px Helvetica";
				ctx.textAlign = "left";
				ctx.textBaseline = "top";
				ctx.fillText( "GameOver!", 132, 65 );
				// ---[ Pontuação ]--- //
				ctx.fillStyle = "rgb( 195, 0, 0 )";
				ctx.font = "bolder 28px Helvetica";
				ctx.textAlign = "left";
				ctx.textBaseline = "top";
				ctx.fillText( "Monsters caught: " + monstersTotal, 105, 135 );
				
			break;
			
			
		case "creditos":
				
				// ---[ Imagem de Fundo ]--- //
				if( bgImageReady == true ) {
					ctx.drawImage( bgImage, 0, 0 );
				} // FIM if
				
				
				// ---[ Logo do Time ]--- //
				if( imgLogoTimeReady == true ) {
					ctx.drawImage( imgLogoTime,
								   0, 0,		// X e Y dentro da imagem
								   200, 250,	// largura e altura da imagem original
								   50, 80,		// posição X e Y na tela (canvas)
								   165, 215 );	// tamanho da imagem que aparece no canvas
				} // FIM if
				
				
				// ---[ Botão Reset ]--- //
				if( btnResetReady == true ) {
					ctx.drawImage( btnReset, 303, 32 );
				} // FIM if
				
				
				// Escrever
				// ---[ Creditos ]--- //
				ctx.fillStyle = "black";
				ctx.font = "bolder 32px Helvetica";
				ctx.textAlign = "left";
				ctx.textBaseline = "top";
				ctx.fillText( "Credits", 64, 64 );
				ctx.font = "bolder 20px Helvetica";
				ctx.fillText( "Alunos do curso", 200.5, 105 );
				ctx.fillText( "Tec. Informática p/ WEB ", 200.5, 125 );
				ctx.font = "18px Helvetica";
				// ctx.fillText( "Leonardo Compri", 170.5, 110 );
				ctx.fillText( "Leonardo Compri", 220.5, 160 );
				// ctx.fillText( "Marcos Santana", 174.5, 133 );
				ctx.fillText( "Marcos Santana", 220.5, 183 );
				// ctx.fillText( "Ricardo C. Touma", 167, 156 );
				ctx.fillText( "Ricardo C. Touma", 220.5, 206 );
				// ctx.fillText( "Simone Touma", 179, 179 );
				ctx.fillText( "Simone Touma", 220.5, 229 );
				// ctx.fillText( "Profº. Luiz", 198.5, 202 );
				ctx.fillText( "Profº. Luiz", 220.5, 252 );
				
			break;
			
	} // FIM switch
	
}; // FIM render


function telainicial() {
	
	// Teste botão
	alert( "" );
	
}; // FIM telainicial


// Function do LOOP PRINCIPAL do jogo
var main = function() {
	
	var now = Date.now();
	// delta -> diferença do tempo atual e a tempo anterior
	var delta = now - then;
	
	// Atualiza tudo
	update( delta / 1000 );
	
	// Desenha tudo
	render();
	
	then = now;
	
	// Desenha de acordo com o navegador
	// requestAnimationFrame -> vai executar o main loop
	animationFrame( main );
	
}; // FIM main


window.setInterval( cronometro, 1000 );
// window.setTimeout( pausa, 100000 );

// Hora do jogo começar!!!
var then = Date.now();
// Zerando posições dos objetos
reset();
// Redimenciona o tamanho da tela
redimensionarTela();
// Chama o LOOP principal
main();


}; // FIM window.onload

