ig.module(
	'game.entities.customlib.box'
)
.requires(
	'game.entities.finalData',
	'impact.entity'
)
.defines(function(){

EntityBox = ig.Entity.extend({
	
	imgBox: null,
	imgText: null,
	
	font: null,
	
	number: 0,
	
//---------------------------------------------------------------------------------------------------------------------------------------------	
	init: function( x, y, settings ) {
		this.parent( x, y, settings);
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	setSize: function(width, height) {
		this.size.x = width;
		this.size.y = height;
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	setBoxImage: function(path) {
		this.imgBox = new ig.Image(path);
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	setFont: function(path) {
		if( path != undefined ) this.font = new ig.Font(path);
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	setNumber: function(number) {
		this.number = number;
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	getNumber: function() {
		return this.number;
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	draw: function() {
		this.parent();
		if( this.imgBox != undefined ) this.imgBox.draw( this.pos.x - this.imgBox.width / 2, this.pos.y - this.imgBox.height / 2 );
		if( this.font != undefined ) { 
			var str = this.number + '';
			var x = Math.floor(this.pos.x + this.size.x / 2 - str.length * FinalData.LETTER_SIZE / 2);
			
			this.font.draw( this.number, x, this.pos.y );
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------------------	
});
});