ig.module(
	'game.entities.item'
)
.requires(
	'game.entities.finalData',
	'game.entities.popupScore',
	'game.entities.miss',
	'game.entities.wave',
	'game.entities.starkill',
	'impact.entity'
)
.defines(function(){
	
EntityItem = ig.Entity.extend({
	engine: null,
	hole_pos: null,
	
	name: null,
	
	originTab: 0,
	tab: null,
	stayTimer: null,
	crakeFlag: false,
	
	missFlag: true,
	kind: null,
	
	stayTimeValue: 0,
//---------------------------------------------------------------------------------------------------------------------------------------------
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		switch(this.name) {
			case '1tabpenguin':
				this.animSheet = new ig.AnimationSheet(FinalData.img_black_penguin, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.tab = 1;
				this.kind = 'good';
				this.addAnim('stay', 0.1, [0]);
				this.addAnim('pushdown', 0.3, [0,0,1,1]);
				break;
			case '2tabpenguin':
				this.animSheet = new ig.AnimationSheet(FinalData.img_black_penguin, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.tab = 2;
				this.kind = 'good';
				this.addAnim('tab1', 0.1, [1]);
				this.addAnim('stay', 0.1, [0]);
				this.addAnim('pushdown', 0.1, [1,1,1,1]);
				break;
			case '3tabpenguin':
				this.animSheet = new ig.AnimationSheet(FinalData.img_black_penguin, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.tab = 3;
				this.kind = 'good';
				this.addAnim('stay', 0.1, [2]);
				this.addAnim('tab2', 0.1, [0]);
				this.addAnim('tab1', 0.1, [1]);
				this.addAnim('pushdown', 0.1, [1,1,1,1]);
				break;
			case '4tabpenguin':
				this.animSheet = new ig.AnimationSheet(FinalData.img_black_penguin, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.tab = 4;
				this.kind = 'good';
				this.addAnim('stay', 0.1, [2]);
				this.addAnim('tab3', 0.1, [3]);
				this.addAnim('tab2', 0.1, [0]);
				this.addAnim('tab1', 0.1, [1]);
				this.addAnim('pushdown', 0.1, [1,1,1,1]);
				break;

			case '2tabfish':
				this.animSheet = new ig.AnimationSheet(FinalData.img_fish, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.tab = 2;
				this.kind = 'good';
				this.addAnim('stay', 0.1, [0]);
				this.addAnim('tab1', 0.1, [2]);
				this.addAnim('pushdown', 0.1, [2,2,2,2]);
				break;
			case '3tabfish':
				this.animSheet = new ig.AnimationSheet(FinalData.img_fish, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.tab = 3;
				this.kind = 'good';
				this.addAnim('stay', 0.1, [0]);
				this.addAnim('tab2', 0.1, [1]);
				this.addAnim('tab1', 0.1, [3]);
				this.addAnim('pushdown', 0.1, [3,3,3,3]);
				break;
			
			case '1tabigloo':
				this.animSheet = new ig.AnimationSheet(FinalData.img_igloo, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.tab = 1;
				this.kind = 'good';
				this.addAnim('stay', 0.1, [0]);
				this.addAnim('pushdown', 0.1, [0,0,1,1]);
				break;
			case '2tabigloo':
				this.animSheet = new ig.AnimationSheet(FinalData.img_igloo, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.tab = 2;
				this.kind = 'good';
				this.addAnim('stay', 0.1, [0]);
				this.addAnim('tab1', 0.1, [1]);
				this.addAnim('pushdown', 0.1, [1,1,1,1]);
				break;
			
			case 'shark':
				this.animSheet = new ig.AnimationSheet(FinalData.img_shark, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.kind = 'bad';
				this.addAnim('stay', 0.1, [0]);
				this.addAnim('pushdown', 0.1, [0,0,1,1]);
				break;
			case 'snowman':
				this.animSheet = new ig.AnimationSheet(FinalData.img_snowman, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.kind = 'bad';
				this.addAnim('stay', 0.1, [0]);
				this.addAnim('pushdown', 0.1, [0,0,1,1]);
				break;
			case 'snowbear':
				this.animSheet = new ig.AnimationSheet(FinalData.img_snowbear, FinalData.PENGUIN_SIZE.x, FinalData.PENGUIN_SIZE.y);
				this.kind = 'bad';
				this.addAnim('stay', 0.1, [0]);
				this.addAnim('pushdown', 0.1, [0,0,1,1]);
				break;
		}
		this.originTab = this.tab;
	
		this.currentAnim = this.anims.stay;
		
		this.stayTimer = new ig.Timer(FinalData.INITSTAY_TIME);
	},
//---------------------------------------------------------------------------------------------------------------------------------------------
	stopItem: function() {
		if(this.stayTimer != undefined) {
			this.stayTimeValue = Math.abs(Math.floor(this.stayTimer.delta()));
			this.stayTimer = null;
		}
	},
//---------------------------------------------------------------------------------------------------------------------------------------------
	startItem: function() {
		this.stayTimer = new ig.Timer(this.stayTimeValue);
	},
//---------------------------------------------------------------------------------------------------------------------------------------------
	update: function() {
		this.parent();
		
		this.changeAnim();
	},
//-----------------------------------------------------------------------------------------------------------------------------------
	craked: function() {
		this.tab--;
		
		if(this.kind == 'good') {
			this.crakeFlag = true;
			ig.game.spawnEntity(EntityStarkill, this.pos.x - FinalData.CRAKED_INTENT.x, this.pos.y - FinalData.CRAKED_INTENT.y, {zIndex: 2, item: this} );
			ig.game.sortEntities();
		}
		
		switch(this.name) {
			case '2tabpenguin':
				this.currentAnim = this.anims.tab1;
				break;
			case '3tabpenguin':
				if(this.tab == 2) {
					this.currentAnim = this.anims.tab2;
				} else {
					this.currentAnim = this.anims.tab1;
				}
				break;
			case '4tabpenguin':
				if(this.tab == 3) {
					this.currentAnim = this.anims.tab3;
				} else if(this.tab == 2){
					this.currentAnim = this.anims.tab2;
				} else {
					this.currentAnim = this.anims.tab1;
				}
				break;
			case '2tabfish':
				this.currentAnim = this.anims.tab1;
				break;
			case '3tabfish':
				if(this.tab == 2) {
					this.currentAnim = this.anims.tab2;
				} else {
					this.currentAnim = this.anims.tab1;
				}
				break;
			case '2tabigloo':
				this.currentAnim = this.anims.tab1;
				break;
		}
		
		if(this.tab <= 0) {
			if(this.kind == 'good') {
				var score = 50 * (this.originTab);
				ig.game.spawnEntity(EntityPopupScore, this.pos.x + FinalData.POPUPSCORE_INTENT, this.pos.y, {score: '+' + score});
				this.engine.scoreBox.add(score);
				this.missFlag = false;
			} else {
				ig.game.spawnEntity(EntityPopupScore, this.pos.x + FinalData.POPUPSCORE_INTENT, this.pos.y, {faultFlag: true});
				this.engine.bad_life++;
			}
			this.currentAnim = this.anims.pushdown;
			this.stayTimer = null;
		}
		
	},
//-----------------------------------------------------------------------------------------------------------------------------------
	changeAnim: function() {
		if(this.stayTimer != undefined && this.stayTimer.delta() > 0) {
			this.currentAnim = this.anims.pushdown;
			this.stayTimer = null;
		}
		
		if(this.currentAnim == this.anims.pushdown && this.currentAnim.frame == 3) {
			this.engine.freeHole(this.hole_pos);
			ig.game.spawnEntity(EntityWave, this.pos.x - FinalData.WAVE_INTENT.x, this.pos.y + FinalData.WAVE_INTENT.y );
			this.kill();
		}
	},
//-----------------------------------------------------------------------------------------------------------------------------------
	kill: function() {
		if(this.missFlag && this.kind=='good') {
			ig.game.spawnEntity(EntityMiss, this.pos.x + FinalData.MISS_INTENT.x, this.pos.y + FinalData.MISS_INTENT.y);
			this.engine.life--;
		}
		
		this.parent();
	}
//-----------------------------------------------------------------------------------------------------------------------------------
});
});