ig.module(
	'game.entities.menu'
)
.requires(
	'impact.entity',
	'impact.font'
)
.defines(function(){

EntityMenu = ig.Entity.extend({
	currentView			: 0,
	engine				: null,
	
	arrHighScore		: [],
	
	splashTimer			: new ig.Timer(),
	highScoreFont		: new ig.Font(FinalData.img_highscore_font),
	
	imgSplash			: new ig.Image( FinalData.img_splash ),
	imgCover			: new ig.Image( FinalData.img_cover ),
	imgBackground		: new ig.Image( FinalData.img_backgroud ),
	
	imgStartGameButton	: new ig.Image( FinalData.img_start_game_button ),
	imgHelpButton		: new ig.Image( FinalData.img_help_button ),
	imgHighScoreButton	: new ig.Image( FinalData.img_highscore_button ),
	imgAboutButton		: new ig.Image( FinalData.img_about_button ),
	imgMoreGameButton	: new ig.Image( FinalData.img_moregame_button ),
	
	imgInstruction		: new ig.Image( FinalData.img_instruction ),
	imgHelp				: new ig.Image( FinalData.img_help ),
	imgAbout			: new ig.Image( FinalData.img_about ),
	imgHighScore		: new ig.Image( FinalData.img_highscore ),
//----------------------------------------------------------------------------------------------------------------------------------
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		
		this.splashTimer.set(FinalData.SPLASH_TIME);
		this.openView(FinalData.SPLASH_SCREEN_VIEW);
	},
//----------------------------------------------------------------------------------------------------------------------------------
	update: function() {
		// Update all entities and backgroundMaps
		this.parent();
		
	},
//----------------------------------------------------------------------------------------------------------------------------------
	draw: function() {
		// Draw all entities and backgroundMaps
		this.parent();
		
		this.keyCheck();

		switch(this.currentView) {
			case FinalData.SPLASH_SCREEN_VIEW:
				if( this.splashTimer.delta() > 0 ) {
					this.openView(FinalData.COVER_SCREEN_VIEW);
					this.splashTimer = null;
				}
				this.imgSplash.draw(this.pos.x, this.pos.y);
				break;
			
			case FinalData.COVER_SCREEN_VIEW:
				this.imgCover.draw( 0, this.pos.y);
				break;
			
			case FinalData.MAIN_MENU_VIEW:
				this.imgBackground.draw(0, this.pos.y);
				
				this.imgStartGameButton.draw(FinalData.MENU_ITEM_POSX, this.pos.y + FinalData.img_start_posY );
				this.imgHelpButton.draw( FinalData.MENU_ITEM_POSX, this.pos.y + FinalData.img_help_posY );
				//removed_task_menu this.imgHighScoreButton.draw( FinalData.MENU_ITEM_POSX, this.pos.y + FinalData.img_highscore_posY );
				this.imgAboutButton.draw( FinalData.MENU_ITEM_POSX, this.pos.y + FinalData.img_about_posY);
				//removed_task_menu this.imgMoreGameButton.draw( FinalData.MENU_ITEM_POSX, this.pos.y + FinalData.img_moregame_posY);
				break;
			
			case FinalData.INSTRUCTION_VIEW:
				this.imgBackground.draw(0, this.pos.y);
				this.imgInstruction.draw(0, this.pos.y);
				break;
			
			case FinalData.HELP_VIEW:
				this.imgBackground.draw(0, this.pos.y);
				this.imgHelp.draw(0, this.pos.y);
				break;
			
			case FinalData.HIGH_SCORES_VIEW:
				this.imgBackground.draw(0, this.pos.y);
				this.imgHighScore.draw(0, this.pos.y);
				this.showHighScore();
				break;
			
			case FinalData.ABOUT_VIEW:
				this.imgBackground.draw(0, this.pos.y);
				this.imgAbout.draw(0, this.pos.y);
				break;
			
			case FinalData.MOREGAME_VIEW:
				this.imgBackground.draw(0, this.pos.y);
				break;
		}
	},
//----------------------------------------------------------------------------------------------------------------------------------
	getHighScoreData: function() {
		var that = this;
		var req = $.ajax({
			url:( "game.php" + '?nocache=' + Math.random() ), 
			data: {a: 'l'},
			dataType: 'json',
			async: false,
			success: function(scores) {
				that.arrHighScore = scores;
			}
		});
	},
//----------------------------------------------------------------------------------------------------------------------------------
	openView: function(view) {
		switch(view) {
			
			case FinalData.HIGH_SCORES_VIEW:
				
				this.getHighScoreData();
				break;
			case FinalData.MOREGAME_VIEW:
				location.href = 'http://www.celanderus.com/appstore';
				break;
		}
		
		this.currentView = view;
	},
//----------------------------------------------------------------------------------------------------------------------------------
	keyCheck: function() {
		if( ig.input.pressed('mouse') ) {
			var x = ig.input.mouse.x;
			var y = ig.input.mouse.y;
			switch( this.currentView ) {
				case FinalData.COVER_SCREEN_VIEW:
					this.openView( FinalData.MAIN_MENU_VIEW );
					break;
				
				case FinalData.MAIN_MENU_VIEW:
					this.keyCheckInMainMenu(x,y);
					break;
				
				case FinalData.HELP_VIEW:
				case FinalData.HIGH_SCORES_VIEW:
				case FinalData.ABOUT_VIEW:
					this.openView(FinalData.MAIN_MENU_VIEW);
					break;
				
				case FinalData.INSTRUCTION_VIEW:
					this.engine.startGame();
					break;
			}
		}
	},
//----------------------------------------------------------------------------------------------------------------------------------
	keyCheckInMainMenu: function(x,y) {
		if( x >= FinalData.MENU_ITEM_POSX && x <= FinalData.MENU_ITEM_POSX + FinalData.MENU_ITEM_SIZE.x 
			&& y >= this.pos.y + FinalData.img_start_posY && y <= this.pos.y + FinalData.img_start_posY + FinalData.MENU_ITEM_SIZE.y ) {
			this.openView(FinalData.INSTRUCTION_VIEW);
			return;
		}
		
		if( x >= FinalData.MENU_ITEM_POSX && x <= FinalData.MENU_ITEM_POSX + FinalData.MENU_ITEM_SIZE.x 
			&& y >= this.pos.y + FinalData.img_help_posY && y <= FinalData.img_help_posY + this.pos.y + FinalData.MENU_ITEM_SIZE.y ) {
			this.openView(FinalData.HELP_VIEW);
			return;
		}
		
		//removed_task_menu if( x >= FinalData.MENU_ITEM_POSX && x <= FinalData.MENU_ITEM_POSX + FinalData.MENU_ITEM_SIZE.x 
		//removed_task_menu 	&& y >= this.pos.y + FinalData.img_highscore_posY && y <= this.pos.y + FinalData.img_highscore_posY + FinalData.MENU_ITEM_SIZE.y ) {
		//removed_task_menu 	this.openView(FinalData.HIGH_SCORES_VIEW);
		//removed_task_menu 	return;
		//removed_task_menu }

		if( x >= FinalData.MENU_ITEM_POSX && x <= FinalData.MENU_ITEM_POSX + FinalData.MENU_ITEM_SIZE.x 
			&& y >= this.pos.y + FinalData.img_about_posY && y <= this.pos.y + FinalData.img_about_posY + FinalData.MENU_ITEM_SIZE.y ) {
			this.openView(FinalData.ABOUT_VIEW);
			return;
		}
		
		//removed_task_menu if( x >= FinalData.MENU_ITEM_POSX && x <= FinalData.MENU_ITEM_POSX + FinalData.MENU_ITEM_SIZE.x 
		//removed_task_menu 	&& y >= this.pos.y + FinalData.img_moregame_posY && y <= this.pos.y + FinalData.img_moregame_posY + FinalData.MENU_ITEM_SIZE.y ) {
		//removed_task_menu 	this.openView(FinalData.MOREGAME_VIEW);
		//removed_task_menu 	return;
		//removed_task_menu }
	},
//----------------------------------------------------------------------------------------------------------------------------------
	showHighScore: function() {
		for( i = 0; i < 10; i++ ) {
			this.highScoreFont.draw( i + 1 + '.', FinalData.HIGHSCORE_INTENT.x, this.pos.y + FinalData.HIGHSCORE_LINE_SPACE * i + FinalData.HIGHSCORE_INTENT.y );
			if( this.arrHighScore[i] != undefined ) { 
				this.highScoreFont.draw( this.arrHighScore[i].name, FinalData.HIGHSCORE_INTENT.x + FinalData.HIGHSCORE_NAME_INTENT, this.pos.y + FinalData.HIGHSCORE_LINE_SPACE * i + FinalData.HIGHSCORE_INTENT.y );
				this.highScoreFont.draw( this.arrHighScore[i].score, FinalData.HIGHSCORE_INTENT.x + FinalData.HIGHSCORE_SCORE_INTENT, this.pos.y + FinalData.HIGHSCORE_LINE_SPACE * i + FinalData.HIGHSCORE_INTENT.y );
			} else {
				this.highScoreFont.draw( '..............', FinalData.HIGHSCORE_INTENT.x + FinalData.HIGHSCORE_NAME_INTENT, this.pos.y + FinalData.HIGHSCORE_LINE_SPACE * i + FinalData.HIGHSCORE_INTENT.y );
				this.highScoreFont.draw( '.....', FinalData.HIGHSCORE_INTENT.x + FinalData.HIGHSCORE_SCORE_INTENT, this.pos.y + FinalData.HIGHSCORE_LINE_SPACE * i + FinalData.HIGHSCORE_INTENT.y );
			}
		}
	},
//----------------------------------------------------------------------------------------------------------------------------------
});

});