ig.module(
	'game.entities.popupScore'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityPopupScore = ig.Entity.extend({
	score: null,
	startY: 0,

	state: null,
	moveTimer: null,
		
	faultFlag: false,
	imgFault: null,
	scoreFont: new ig.Font(FinalData.img_score_font),
//---------------------------------------------------------------------------------------------------------------------------------------------
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		
		if(this.faultFlag) {
			this.imgFault = new ig.Image(FinalData.img_fault);
		}
		this.moveTimer = new ig.Timer(FinalData.POPUP_SCORE_MOVETIME);
		this.startY = this.pos.y;
		this.state = 'move';
	},
//------------------------------------------------------------------------------------------------------------------------------------------
	setScore: function(score) {
		this.score = score;
	},
//------------------------------------------------------------------------------------------------------------------------------------------
	getScore: function() {
		return this.score;
	},
//------------------------------------------------------------------------------------------------------------------------------------------
	draw: function() {
		this.parent();
		
		if(this.score != undefined && this.score != 0) {
			this.scoreFont.draw(this.score, this.pos.x, this.pos.y);
		} 
		
		if(this.faultFlag) {
			this.imgFault.draw(this.pos.x, this.pos.y);
		}
		
		switch( this.state ) {
			case 'move':
				this.startMoving();
				break;
			case 'stop':
				this.stop();
				break;
		}
	},
//---------------------------------------------------------------------------------------------------------------------------------------------
	stop: function() {
		if( this.stopTimer.delta() > 0 ) {
			this.kill();
		}
	},
//---------------------------------------------------------------------------------------------------------------------------------------------
	startMoving: function() {

		if(this.moveTimer.delta() >= 0) {
			this.pos.y = this.startY;
			this.stopTimer = new ig.Timer(FinalData.POPUP_STAYTIME);
			this.state = 'stop';
			
		} else {
			this.pos.y = this.startY + FinalData.POPUP_MOVEHEIGHT * Math.sin(Math.PI * this.moveTimer.delta() / FinalData.POPUP_SCORE_MOVETIME);
		}

	}
//---------------------------------------------------------------------------------------------------------------------------------------------

});

});