ig.module(
	'game.entities.timeBox'
)
.requires(
	'game.entities.customlib.box'
)
.defines(function(){

EntityTimeBox = EntityBox.extend({
	
	timer: new ig.Timer(),
	
	stopFlag: false,
	stopTime: 0,
//---------------------------------------------------------------------------------------------------------------------------------------------	
	init: function( x, y, settings ) {
		this.parent( x, y, settings);
		
		this.setSize(FinalData.TIME_BOX_SIZE.x, FinalData.TIME_BOX_SIZE.y);
		this.setFont(FinalData.img_number_font);
		this.setNumber(FinalData.INIT_TIME);
		
		this.timer.set(FinalData.INIT_TIME);
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	setTime: function(time) {
		this.timer.set(time);
		this.setNumber(time);
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	getTime: function() {
		return this.number;
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	start: function() {
		this.setNumber(FinalData.INIT_TIME);
		this.timer.set(FinalData.INIT_TIME);
		
		this.stopFlag = false;
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	startTimeBox: function() {
		this.setNumber(this.stopTime);
		this.timer.set(this.stopTime);
		
		this.stopFlag = false;
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	initTimeBox: function() {
		this.setNumber(0);
		this.stopFlag = true;
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	stop: function() {
		this.stopFlag = true;
		this.stopTime = Math.abs(this.getNumber());
	},
//---------------------------------------------------------------------------------------------------------------------------------------------	
	draw: function() {
		this.parent();
		
		if( !this.stopFlag ) {
			var time = Math.floor(this.timer.delta());
			this.setNumber(time);
		}
	}
//---------------------------------------------------------------------------------------------------------------------------------------------	
});
});