var db = new Array();
db["corpos_celestes"] = $.parseJSON('{"titulo":"Corpos Celestes", "descricao":"Na astronomia, Corpo celeste é um termo que designa qualquer entidade física existente no espaço sideral. Podendo referir-se a um único objeto como a Lua, o Sol, ou um asteroide, como também a vários objetos que se mantêm unidos por forças gravitacionais, como galáxias, estrelas dupla, ou o sistema solar.", "voltar":"home", "imagem":"", "propriedades":"", "pagina":["sistema_solar","objetos_extra_solares"]}');
db["sistema_solar"] = $.parseJSON('{"titulo":"Sistema Solar", "descricao":"O Sistema Solar compreende o conjunto constituído pelo Sol e todos os corpos celestes que estão sob seu domínio gravitacional. A estrela central, maior componente do sistema (respondendo por mais de 99,85% da massa total), gera sua energia através da fusão de hidrogênio em hélio, dois de seus principais constituintes. Os quatro planetas mais próximos do Sol (Mercúrio, Vênus, Terra e Marte) possuem em comum uma crosta sólida e rochosa, razão pela qual se classificam no grupo dos planetas telúricos, ou rochosos. Mais afastados, os quatro gigantes gasosos, Júpiter, Saturno, Urano e Netuno, são os componentes de maior massa do sistema logo após o próprio Sol. Dos cinco planetas anões, Ceres é o que se localiza mais próximo do centro do Sistema Solar, enquanto todos os outros, Plutão, Haumea, Éris e Makemake, se encontram além da órbita de Netuno.", "voltar":"corpos_celestes", "imagem":"640px-The_new_Solar_System_.jpg", "propriedades":"", "pagina":["sistema_planetario"]}');
db["objetos_extra_solares"] = $.parseJSON('{"titulo":"Objetos extra-solares", "descricao":"São compostos de todos os corpos celestes que estão fora do sistema solar, como estrelas, galáxias, buracos negros e etc.", "voltar":"corpos_celestes", "imagem":"", "referencia_imagem":"", "pagina":["superaglomerado_de_galaxias"]}');
db["sistema_planetario"] = $.parseJSON('{"titulo":"Sistema planetário", "descricao":"Um sistema planetário consiste em objetos não-estelares que orbitam uma estrela, tal como planetas, Satélites Naturais, asteróides, meteoros, cometas e poeira cósmica. O sistema planetário ao qual pertence o planeta Terra é denominado Sistema Solar. Aos demais, se dá a denominação de extra-solares.", "voltar":"sistema_solar", "imagem":"600px-Artist_Concept_Planetary_System.jpg", "pagina":["asteroide","objeto_transneptuniano","nuvem_de_oort","cometa","meteoroide","sol","planetas"]}');
db["sol"] = $.parseJSON('{"titulo":"Sol", "descricao":"O Sol (do latim sol, solis) é a estrela central do Sistema Solar. Todos os outros corpos do Sistema Solar, como planetas, planetas anões, asteroides, cometas e poeira, bem como todos os satélites associados a estes corpos, giram ao seu redor. Responsável por 99,86% da massa do Sistema Solar, o Sol possui uma massa 332 900 vezes maior que a da Terra, e um volume 1 300 000 vezes maior que o do nosso planeta. A distância da Terra ao Sol é de cerca de 150 milhões de quilômetros, ou 1 unidade astronômica (UA). Na verdade, esta distância varia com o ano, de um mínimo de 147,1 milhões de quilômetros (0,9833 UA) no perélio (ou periélio) a um máximo de 152,1 milhões de quilômetros (1,017 UA) no afélio, em torno de 4 de julho. A luz solar demora aproximadamente 8 minutos e 18 segundos para chegar à Terra. Energia do Sol na forma de luz solar é armazenada em glicose por organismos vivos através da fotossíntese, processo do qual, direta ou indiretamente, dependem todos os seres vivos que habitam nosso planeta. A energia do Sol também é responsável pelos fenômenos meteorológicos e o clima na Terra. É composto primariamente de hidrogênio (74% de sua massa, ou 92% de seu volume) e hélio (24% da massa solar, 7% do volume solar), com traços de outros elementos, incluindo ferro, níquel, oxigênio, silício, enxofre, magnésio, néon, cálcio e crômio.", "voltar":"sistema_planetario", "imagem":"1.jpg", "pagina":""}');
db["planetas"] = $.parseJSON('{"titulo":"Planetas", "descricao":"Um planeta (do grego πλανήτης, forma alternativa de πλάνης \\"errante\\") é um corpo celeste que orbita uma estrela ou um remanescente de estrela, com massa suficiente para se tornar esférico pela sua própria gravidade, mas não a ponto de causar fusão termonuclear, e que tenha limpado de planetesimais a sua região vizinha (dominância orbital). O termo planeta é antigo, com ligações com a história, ciência, mitologia e religião. Os planetas eram vistos por muitas culturas antigas como divinos ou emissários de deuses. À medida que o conhecimento científico evoluiu, a percepção humana sobre os planetas mudou, incorporando diversos tipos de objetos. Em 2006, a União Astronômica Internacional (UAI) adotou oficialmente uma resolução definindo planetas dentro do Sistema Solar, a qual tem sido elogiada e criticada, permanecendo em discussão entre alguns cientistas.", "voltar":"sistema_planetario", "imagem":"600px-1e7m_comparison_Uranus_Neptune_Sirius_B_Earth_Venus.png", "pagina":["planeta_telurico","planeta_gasoso","planeta_anao"]}');
db["planeta_telurico"] = $.parseJSON('{"titulo":"Planeta telúrico", "descricao":"Um planeta telúrico (do latim Tellus um sinónimo de Terra) ou planeta sólido é um planeta rochoso assim como a Terra. Os planetas telúricos do Sistema Solar são Mercúrio, Vênus, Terra e Marte. Estão mais próximos do Sol e por isso estão situados no Sistema Solar interior e têm maior densidade que os planetas gasosos (Júpiter, Saturno, Urano e Netuno). Esta relação planetária tem a ver com a formação do sistema solar, em que os materiais mais densos tendem a se concentrar mais perto do sol e os mais leves mais longe do sol. Sua composição interna é basicamente de rochas (silicatos), ferro e outros metais pesados. Seu tamanho reduzido em comparação com os gasosos se deve ao fato de que os planetas telúricos são sólidos e densos, enquanto os gasosos são gigantes bolas de gás. Como são pequenos, sua gravidade não passa do habitual para nós (No Sistema Solar, a Terra é o planeta rochoso com maior gravidade (9,8 m/s²), seguido de Vênus (8,7 m/s²), Marte (3,7 m/s²) e Mercúrio (3,6 m/s²)).", "voltar":"planetas", "imagem":"640px-Terrestrial_planet_size_comparisons.jpg", "pagina":["mercurio","venus","terra","marte"]}');
db["planeta_gasoso"] = $.parseJSON('{"titulo":"Planeta gasoso", "descricao":"Planeta gigante de gás, planeta gigante gasoso, planeta joviano ou planeta gasoso é um planeta de grandes dimensões (quer em diametro, quer em massa) que não é principalmente composto de rocha ou outra matéria sólida. Existem quatro no sistema solar: Júpiter, Saturno, Urano e Netuno que diferenciam-se dos restantes membros do sistema solar pelas suas dimensões e também pela sua composição química e estrutural. Esses planetas são corpos compostos maioritariamente de gás (Hidrogénio, Hélio, Metano) possuindo um pequeno núcleo sólido rochoso no seu interior. A sua composição é semelhante à da nebulosa original que deu formação ao sistema solar.", "voltar":"planetas", "imagem":"466px-Gas_giants_in_the_solar_system.jpg", "pagina":["jupiter","saturno","urano","netuno"]}');
db["planeta_anao"] = $.parseJSON('{"titulo":"Planeta anão", "descricao":"Um planeta anão é muito semelhante a um planeta (porém menor), dado que orbita em volta do Sol e possui gravidade suficiente para assumir uma forma com equilíbrio hidrostático (aproximadamente esférica). Porém, não possui uma órbita desimpedida. Um exemplo é Ceres que, localizado na cintura de asteroides, possui o percurso da sua órbita repleto daqueles pequenos astros. É muito difícil a classificação dos planetas-anões. Segundo a UAI (união astronômica internacional), um planeta anão é um objeto que orbita o Sol, com uma forma redonda e que está acompanhado de outros objetos numa mesma região. Porém, observando corpos frios e que estão distantes do nosso sistema, apenas se consegue obter o seu brilho com precisão - nunca a sua forma. Este facto demonstra-nos como é delicada a classificação das classes de objetos no nosso sistema solar. Atualmente conhecem-se cinco planetas anões no sistema solar. São eles: Ceres, Plutão, Haumea, Makemake e Éris, sendo os quatro últimos do tipo plutoide, ou seja, planetas-anões que orbitam para além da órbita de Netuno, nos recônditos do sistema solar.", "voltar":"planetas", "imagem":"640px-C_Kuiper_Portugues.jpg", "pagina":["plutao","eris"]}');
db["asteroide"] = $.parseJSON('{"titulo":"Asteroide", "descricao":"Os asteroides são corpos rochosos e metálicos que possuem órbita definida ao redor do Sol. Fazem parte dos corpos menores do sistema solar. Possuem, geralmente, apenas algumas centenas de quilômetros. Historicamente, chegaram a ser igualmente denominados planetoides, planetas menores ou pequenos planetas - mas na resolução B5 de 24 de Agosto de 2006 tomada em Praga, a União Astronômica Internacional (UAI) recomenda que todos estes sinônimos deixem de ser usados, devido à sua ambiguidade. O termo \\"asteroide\\" deriva do grego \\"astér\\", estrela, e \\"oide\\", sufixo que denota semelhança. São semelhantes aos meteoroides, porém com dimensões bem maiores, possuindo formas e tamanhos indefinidos. O Minor Planet Center possui dados de mais de 1,1 milhão de planetas menores no Sistema Solar interno e externo, dos quais mais de 680 mil têm designações numeradas.4 A grande maioria desses objetos está no cinturão de asteroides. São desconhecidos quase todos os de menor tamanho, os quais acredita-se que existam cerca de 1 milhão. Estima-se que mais de quatrocentos mil possuam diâmetro superior a um quilômetro. Entretanto, se juntássemos a massa de todos os asteroides conhecidos, ela seria inferior à massa da Lua.", "voltar":"sistema_planetario", "imagem":"640px-433eros.jpg", "pagina":""}');
db["objeto_transneptuniano"] = $.parseJSON('{"titulo":"Objeto transneptuniano", "descricao":"Um objeto transnetuniano é qualquer corpo menor do sistema solar que orbita o Sol a uma distância média (semieixo maior) superior à de Netuno. A região transnetuniana é dividida em cinturão de Kuiper, disco disperso e nuvem de Oort. O primeiro objeto transnetuniano descoberto foi Plutão em 1930. O segundo objeto transnetuniano conhecido, (15760) 1992 QB1, foi descoberto em 1992. A Nuvem de Oort permanece especulativa e os corpos celestes das duas primeiras regiões são também conhecidos por alguns autores pelo acrónimo de língua inglesa KBO que significa Kuiper Belt Object (Objecto da Cintura de Kuiper). Nesta região remota do sistema solar, entre vários pequenos corpos celestes, orbitam os planetas anões Plutão, Haumea, Makemake e Éris.", "voltar":"sistema_planetario", "imagem":"Kuiper_belt_-_Oort_cloud-pt.svg.png", "pagina":""}');
db["nuvem_de_oort"] = $.parseJSON('{"titulo":"Nuvem de Oort", "descricao":"A nuvem de Oort, é uma nuvem esférica de planetesimais voláteis que se acredita localizar-se a cerca de 50 000 UA, 1 ou quase um ano-luz, do Sol. Isso significa que ela está a aproximadamente um quarto da distância a Proxima Centauri, a estrela mais próxima do Sol. O cinturão de Kuiper e o disco disperso, as outras duas regiões do Sistema Solar que contêm objetos transnetunianos, se localizam a menos de um milésimo da distância estimada da nuvem de Oort. A parte externa da nuvem de Oort define o limite cosmográfico do Sistema Solar e a região de influência gravitacional do Sol. Acredita-se que a nuvem de Oort, que recebe o seu nome graças ao astrônomo holandês Jan Oort, compreenda duas regiões distintas: uma parte externa esférica e uma parte interna em forma de disco, ou nuvem de Hills. Os objetos da nuvem de Oort são compostos principalmente por voláteis como gelo, amônia e metano.", "voltar":"sistema_planetario", "imagem":"Kuiper_belt_-_Oort_cloud-pt.svg.png", "pagina":""}');
db["cometa"] = $.parseJSON('{"titulo":"Cometa", "descricao":"Cometa é um corpo menor do sistema solar que quando se aproxima do Sol passa a exibir uma atmosfera difusa, denominada coma, e em alguns casos apresenta também uma cauda, ambas causadas pelos efeitos da radiação solar e dos ventos solares sobre o núcleo cometário. Os núcleos cometários são compostos de gelo, poeira e pequenos fragmentos rochosos, variando em tamanho de algumas centenas de metros até dezenas de quilômetros.", "voltar":"sistema_planetario", "imagem":"Lspn_comet_halley.jpg", "pagina":""}');
db["meteoroide"] = $.parseJSON('{"titulo":"Meteoroide", "descricao":"Meteoroides são fragmentos de materiais que vagueiam pelo espaço e que, segundo a Organização Internacional de Meteoros, possuem dimensões significativamente menores que um asteroide e significativamente maiores que um átomo ou molécula, distinguindo-os dos asteroides - objetos maiores, ou da poeira interestelar - objetos micrométricos ou menores. Os meteoróides derivam de corpos celestes como cometas e asteróides e podem ter origem em ejeções a de cometas que se encontram em aproximação ao sol, na colisão entre dois asteróides, ou mesmo ser um fragmento de sobra da criação do sistema solar. Ao entrar em contato com a atmosfera de um planeta, um meteoróide dá origem a um meteoro.", "voltar":"sistema_planetario", "imagem":"PIA07269-Mars_Rover_Opportunity-Iron_Meteorite.jpg", "pagina":""}');
db["exoplaneta"] = $.parseJSON('{"titulo":"Exoplaneta", "descricao":"Um exoplaneta (ou planeta extrassolar) é um planeta que orbita uma estrela que não seja o Sol e, desta forma, pertence a um sistema planetário distinto do nosso. Até 27 de março de 2014, havia 1779 exoplanetas detectados. Embora a existência de sistemas planetários há muito tem sido de aventado, até a década de 1990 nenhum planeta ao redor de estrelas da sequência principal havia sido descoberto. Todavia, desde então, algumas perturbações em torno da estrela atribuídas a exoplanetas gigantes vêm sendo descobertas com telescópios melhores. Mesmo por estimativas, as observações cada vez mais frequentes de exoplanetas gigantes reforçam a possibilidade de que alguns desses sistemas planetários possam conter planetas menores e consequentemente abrigar vida extraterrestre. A maioria dos exoplanetas possuem condições inóspitas à existência de vida tal como é concebida em nosso planeta. Os planetas detetados até agora são, em sua maioria, do tamanho ou maior do que Júpiter, e giram na maioria das vezes em órbitas muito próximas da estrela-mãe. Entretanto, os cientistas acreditam que isso se deve a limitações nas técnicas de detecção de planetas, e não porque essas condições sejam mais comuns.", "voltar":"sistema_estelar", "imagem":"Novo-exoplaneta-gigante-descoberto.jpg", "pagina":""}');
db["ana_marrom"] = $.parseJSON('{"titulo":"Anã marrom", "descricao":"Uma anã marrom é um corpo celeste de baixa luminosidade que não consegue iniciar a fusão do hidrogênio em seu núcleo. Sendo que a sua massa é superior à de um planeta, mas não tão massiva quanto a de uma estrela, as anãs marrons são consideradas estrelas fracassadas. Por causa dessa característica são vistas como o \\"elo perdido\\" entre planetas gigantes gasosos e estrelas. Propostas inicialmente na década de 1960, permaneceram anos como uma hipótese, até que em 1995 evidências fortíssimas definitivamente comprovaram sua existência.", "voltar":"sistema_estelar", "imagem":"th.jpeg", "pagina":""}');
db["estrela"] = $.parseJSON('{"titulo":"Estrela", "descricao":"Uma estrela é uma grande e luminosa esfera de plasma, mantida íntegra pela gravidade. Ao fim de sua vida, uma estrela pode conter também uma proporção de matéria degenerada. A estrela mais próxima da Terra é o Sol, que é a fonte da maior parte da energia do planeta. Outras estrelas são visíveis da Terra durante a noite, quando não são ofuscadas pela luz do Sol ou bloqueadas por fenômenos atmosféricos. Historicamente, as estrelas mais importantes da esfera celeste foram agrupadas em constelações e asterismos, e as estrelas mais brilhantes ganharam nomes próprios. Extensos catálogos de estrelas foram compostos pelos astrônomos, o que permite a existência de designações padronizadas. Pelo menos durante uma parte da sua vida, uma estrela brilha devido à fusão nuclear do hidrogênio no seu núcleo, liberando energia que atravessa o interior da estrela e irradia para o espaço sideral. Quase todos os elementos que ocorrem na natureza mais pesados que o hélio foram criados por estrelas, seja pela nucleossíntese estelar durante as suas vidas ou pela nucleossíntese de supernova quando as estrelas explodem. Os astrônomos podem determinar a massa, idade, composição química e muitas outras propriedades de uma estrela observando o seu espectro, luminosidade e movimento no espaço. A massa total de uma estrela é o principal determinante da sua evolução e possível destino. Outras características de uma estrela são determinadas pela história da sua evolução, inclusive o diâmetro, rotação, movimento e temperatura. Um diagrama da temperatura de muitas estrelas contra suas luminosidades, conhecido como Diagrama de Hertzsprung-Russell (Diagrama H-R), permite determinar a idade e o estado evolucionário de uma estrela.", "voltar":"sistema_estelar", "imagem":"tha.jpeg", "pagina":["estrela_variavel","estrela_compacta","buraco_negro"]}');
db["estrela_variavel"] = $.parseJSON('{"titulo":"Estrela variável", "descricao":"Por definição, uma estrela variável é uma estrela cuja luminosidade varia em uma escala de tempo menor que 100 anos. Enquanto a maior parte das estrelas têm luminosidade praticamente constante — como o nosso Sol, que não apresenta praticamente nenhuma variação mensurável (em torno de 0,1% em um ciclo de 11 anos) — a luminosidade de certas estrelas varia de maneira perceptível em períodos de tempo muito mais curtos.", "voltar":"estrela", "imagem":"", "pagina":["supornova"]}');
db["estrela_compacta"] = $.parseJSON('{"titulo":"Estrela compacta", "descricao":"Em astronomia, uma estrela compacta (algumas vezes chamado de objeto compacto) é uma estrela que é uma anã branca, uma estrela de nêutron, uma estrela exótica, ou um buraco negro. \\"Estrela compacta\\" é geralmente utilizado quando a natureza exata de uma estrela é desconhecida, mas evidências sugerem que ela é muita massiva e possui um pequeno raio, o que leva a uma das possibilidades supracitadas.", "voltar":"estrela", "imagem":"220px-Chandra-crab.jpg", "pagina":["estrela_de_neutrons"]}');
db["sistema_estelar"] = $.parseJSON('{"titulo":"Sistema estelar", "descricao":"Um sistema estelar normalmente é composto por um pequeno número de estrelas que orbitam entre si, conectadas por atração gravitacional. O termo sistema estelar também pode ser usado para referir-se a sistemas planetários de estrelas solitárias, similares ao Sistema Solar. Um número muito grande de estrelas que estão agrupadas gravitacionalmente, embora sejam também sistemas estelares, é normalmente chamado de aglomerado estelar.", "voltar":"galaxia", "imagem":"600px-HD188753_orbit.jpg", "pagina":["exoplaneta","estrela","ana_marrom"]}');
db["galaxia"] = $.parseJSON('{"titulo":"Galáxia", "descricao":"Uma galáxia é um grande sistema, gravitacionalmente ligado, que consiste de estrelas, remanescentes de estrelas, um meio interestelar de gás e poeira e um importante mas insuficientemente conhecido componente apelidado de matéria escura. A palavra \\"galáxia\\" deriva do grego \\"galaxias\\" (γαλαξίας), literalmente \\"leitoso\\", numa referência à nossa galáxia, a Via Láctea. Exemplos de galáxias variam desde as anãs, com até 10 milhões de estrelas, até gigantes com 100 trilhões de estrelas, todas orbitando o centro de massa da galáxia. As galáxias contêm quantidades variadas de sistemas e aglomerados estelares e de tipos de nuvens interestelares. Entre esses objetos existe um meio interestelar esparso de gás, poeira e raios cósmicos. A matéria escura parece corresponder a cerca de 90% da massa da maioria das galáxias. Dados observacionais sugerem que podem existir buracos negros supermaciços no centro de muitas, se não todas as galáxias. Acredita-se que eles sejam o impulsionador principal dos núcleos galácticos ativos – região compacta no centro de algumas galáxias que tem uma luminosidade muito maior do que a normal. A Via Láctea parece possuir pelo menos um desses objetos.", "voltar":"aglomerado_de_galaxias", "imagem":"NGC_4414_(NASA-med).jpg", "pagina":["materia_escura","nebulosa","meio_interestelar","sistema_estelar"]}');
db["aglomerado_de_galaxias"] = $.parseJSON('{"titulo":"Aglomerado de galáxias", "descricao":"Os aglomerados de galáxias ou cúmulos de galáxias são uma das maiores estruturas do Universo. Nelas inúmeras galáxias estão interagindo gravitacionalmente umas com as outras, chocando-se muitas vezes entre si mas normalmente estando equilibradas a uma certa distância. Jan Hendrik Oort foi o primeiro a demonstrar que as galáxias não estão distribuídas aleatoriamente no espaço, mas concentram-se em grupos. Mais tarde, quando a descoberta já estava assimilada pela comunidade científica, acreditou-se que os aglomerados de galáxias fossem as estruturas maiores encontradas no Universo. Entretanto, em 1953 descobriu-se os superaglomerados de galáxias, ou expressamente falando \\"aglomerados de aglomerados de galáxias\\", estruturas ainda maiores do Universo. Um dos mais impressionantes é o Aglomerado de Abell, são milhões de galáxias aparentemente infinitas.", "voltar":"superaglomerado_de_galaxias", "imagem":"490px-HCG87_HST_2001-22-d-web_print.jpg", "pagina":["galaxia"]}');
db["superaglomerado_de_galaxias"] = $.parseJSON('{"titulo":"Superaglomerado de galáxias", "descricao":"Depois de descobrir os aglomerados de galáxias, os astrônomos se perguntaram se existiam estruturas ainda maiores no Universo. Em 1953, o astrônomo francês Gérard de Vaucouleurs demonstrou que os aglomerados de galáxias também formam estruturas maiores, denominados superaglomerados de galáxias ou supercúmulos de galáxias. A maioria dos superaglomerados têm milhões de anos-luz de diâmetro e contém milhares de galáxias. A existência de superaglomerados indica que as galáxias no Universo não estão uniformemente distribuídas, a maioria delas se agrupa em grupos e aglomerados, cada grupo contém cerca de 50 galáxias e cada aglomerado, vários milhares de galáxias. Não há conhecimento de nenhum aglomerado de superaglomerados, mas sua existência é debatida. Acredita-se que o número total de superaglomerados no Universo seja em torno de 10 milhões.", "voltar":"objetos_extra_solares", "imagem":"Local_supercluster.jpg", "pagina":["aglomerado_de_galaxias"]}');
db["meio_interestelar"] = $.parseJSON('{"titulo":"Meio interestelar", "descricao":"Em astronomia o meio interestelar (ou MI) refere-se ao material que preenche o espaço entre as estrelas. Embora a maior parte da matéria das galáxias se concentrem nas estrelas, o espaço que há fora delas não é tão vazio quanto costuma-se imaginar. A importância do estudo do meio interestelar deve-se à formação de novas estrelas, que ocorre nessa região. O meio interestelar possui uma densidade muito baixa, consistindo principalmente de gás e poeira, que também podem ser distribuídos na forma de nuvens individuais chamadas de nuvens moleculares.", "voltar":"galaxia", "imagem":"640px-Heic0411a.jpg", "pagina":""}');
db["nebulosa"] = $.parseJSON('{"titulo":"Nebulosa", "descricao":"As nebulosas são nuvens de poeira, hidrogênio, hélio e plasma. Originalmente, nebulosa era o nome de qualquer corpo celeste difuso, incluindo galáxias além da Via Láctea. A Galáxia de Andrômeda, por exemplo, era atribuída como Nebulosa de Andrômeda (e galáxias espirais em geral como \\"nebulosas espirais\\") antes da verdadeira natureza das galáxias serem confirmadas no início do século 20 por Vesto Melvin Slipher, Edwin Hubble e outros. A maioria das nebulosas são de tamanho vasto, abrangendo tamanhos de até centenas de anos luz de diâmetro. Embora mais densas que o espaço que as acercam, a maioria das nebulosas são muito menos densas que qualquer vácuo criado em ambiente terrestre - uma nuvem nebular de tamanho da Terra pesaria apenas alguns quilogramas. Nebulosas são muitas vezes regiões de formações estrelares, como a Nebulosa da Águia. Essa nebulosa é retratada em uma das imagens mais famosas da NASA, os \\"Pilares da Criação\\". Nessas regiões a formação de gás, poeira e outros materiais amontoam-se parar formar massas maiores, nas quais atraem mais massas, e eventualmente se tornarão maciças o suficiente para se tornarem estrelas. Os materiais remanescentes são acreditados formarem planetas, e outros objetos de sistemas planetários.", "voltar":"galaxia", "imagem":"616px-Different_Slant_on_Orion_(495636660).jpg", "pagina":""}');
db["materia_escura"] = $.parseJSON('{"titulo":"Matéria escura", "descricao":"Na cosmologia, matéria escura (ou matéria negra) é uma forma postulada de matéria que só interage gravitacionalmente (ou interage muito pouco de outra forma). Sua presença pode ser inferida a partir de efeitos gravitacionais sobre a matéria visível, como estrelas e galáxias. No modelo cosmológico mais aceito, o ΛCDM, que tem obtido grande sucesso na descrição da formação da estrutura em grande escala do universo, a componente de matéria escura é fria, isto é, não-relativística. Nesse contexto, a matéria escura compõe cerca de 23% da densidade de energia do universo. O restante seria constituído de energia escura, 73% e a matéria bariônica, 4%.", "voltar":"galaxia", "imagem":"640px-WMAP_2008.png", "pagina":""}');
db["estrela_de_neutrons"] = $.parseJSON('{"titulo":"Estrela de nêutrons", "descricao":"As estrelas de nêutrons ou neutrões são corpos celestes supermassivos, ultracompactos e com gravidade extremamente alta. A partir de estudos teóricos e observações astronômicas, sabe-se que a densidade no centro destas estrelas é enorme. Devido à alta gravidade superficial, os feixes de luz que passam próximos a algumas estrelas de nêutrons são desviados, ocasionando distorções visuais, muitas vezes aberrações cromáticas ou o efeito chamado de lente gravitacional. Estrelas de nêutrons são um dos possíveis estágios finais na vida de uma estrela. Elas são criadas quando estrelas com massa maior a oito vezes a do Sol esgotam sua energia nuclear e passam por uma explosão de supernova. Essa explosão ejeta as camadas mais externas da estrela, formando um remanescente de supernova. Instantes antes da explosão, a região central da estrela se contrai com a gravidade, fazendo com que elétrons sejam empurrados para os núcleos dos átomos e se combinem com prótons formando nêutrons, sendo a razão do nome \\"estrela de nêutrons\\".", "voltar":"estrela_compacta", "imagem":"384px-1997NeutronStar.jpg", "pagina":["pulsar"]}');
db["buraco_negro"] = $.parseJSON('{"titulo":"Buraco negro", "descricao":"De acordo com a Teoria Geral da Relatividade, um buraco negro é uma região do espaço da qual nada, nem mesmo objetos que se movam na velocidade da luz, podem escapar. Este é o resultado da deformação do espaço-tempo, causada após o colapso gravitacional de uma estrela, por uma matéria astronomicamente maciça e, ao mesmo tempo, infinitamente compacta e que, logo depois, desaparecerá dando lugar ao que a Física chama de Singularidade, o coração de um buraco negro, onde o tempo para e o espaço deixa de existir. Um buraco negro começa a partir de uma superfície denominada horizonte de eventos, que marca a região a partir da qual não se pode mais voltar. O adjetivo negro em buraco negro se deve ao fato deste não refletir a nenhuma parte da luz que venha atingir seu horizonte de eventos, atuando assim como se fosse um corpo negro perfeito em termodinâmica. Acredita-se, também, com base na mecânica quântica, que buracos negros emitam radiação térmica, da mesma forma que os corpos negros da termodinâmica a temperaturas finitas. Esta temperatura, entretanto, é inversamente proporcional à massa do buraco negro, de modo que observar a radiação térmica proveniente destes objetos torna-se difícil quando estes possuem massas comparáveis às das estrelas. Apesar de os buracos negros serem praticamente invisíveis, estes podem ser detectados por meio da interação com a matéria em sua vizinhança. Um buraco negro pode, por exemplo, ser localizado por meio da observação do movimento de estrelas em uma dada região do espaço. Outra possibilidade da localização de buracos negros diz respeito à detecção da grande quantidade de radiação emitida quando a matéria proveniente de uma estrela companheira é espirala para dentro do buraco negro, aquecendo-se a altas temperaturas.", "voltar":"estrela", "imagem":"600px-BlackHole.jpg", "pagina":""}');
db["pulsar"] = $.parseJSON('{"titulo":"Pulsar", "descricao":"Pulsares são estrelas de nêutrons muito pequenas e muito densas. Os pulsares podem apresentar um campo gravitacional até 1 bilhão de vezes maior que o campo gravitacional terrestre. Eles provavelmente são os restos de estrelas que entraram em colapso, fenômeno também conhecido como supernova. Foram observados pela primeira vez pela astrônoma Jocelyn Bell Burnell. À medida que uma estrela vai perdendo energia, sua matéria é comprimida em direção ao seu centro, ficando cada vez mais densa. Quanto mais a matéria da estrela se move em direção ao seu centro, mais rapidamente ela gira. Qualquer estrela possui um campo magnético que em geral é fraco, mas quando o núcleo de uma estrela é comprimido até se tornar uma estrela de nêutrons, o seu campo magnético também sofre compressão, com isso as linhas de campo magnético ficam mais densas, dessa forma tornam o campo magnético muito intenso, esse forte campo junto com a alta velocidade de rotação passa a produzir fortes correntes elétricas na superfície da estrela de nêutrons. Os prótons e elétrons ligados de maneira \\"fraca\\" à superfície dessas estrelas são impulsionados para fora e fluem, pelas linhas do campo magnético, até os pólos norte e sul da estrela. O eixo eletromagnético da estrela de nêutrons não necessita estar alinhado com o eixo de rotação. Quando isso acontece, temos o pulsar.", "voltar":"estrela_de_neutrons", "imagem":"220px-Chandra-crab.jpg", "pagina":""}');
db["mercurio"] = $.parseJSON('{"titulo":"Mercúrio", "descricao":"Mercúrio é o menor e mais interno planeta do Sistema Solar, orbitando o Sol a cada 87,969 dias terrestres. Sua órbita tem a maior excentricidade e seu eixo apresenta a menor inclinação em relação ao plano da órbita dentre todos os planetas do Sistema Solar. Mercúrio completa três rotações em torno de seu eixo a cada duas órbitas. O periélio da órbita de Mercúrio apresenta uma precessão de 43 segundos de arco por século, um fenômeno explicado somente no século XX pela Teoria da Relatividade Geral formulada por Albert Einstein. Sua aparência é brilhosa quando observado da Terra, tendo uma magnitude aparente que varia de −2,6 a 5,7, embora não seja facilmente observado pois sua separação angular do Sol é de apenas 28,3º. Uma vez que Mercúrio normalmente se perde no intenso brilho solar, exceto em eclipses solares, só pode ser observado a olho nu durante o crepúsculo matutino ou vespertino. Comparado a outros planetas, pouco se sabe a respeito de Mercúrio, pois telescópios em solo terrestre revelam apenas um crescente iluminado com detalhes limitados. As duas primeiras espaçonaves a explorar o planeta foram a Mariner 10, que mapeou aproximadamente 45% da superfície do planeta entre 1974 e 1975, e a MESSENGER, que mapeou outros 30% da superfície durante um sobrevoo em 14 de janeiro de 2008. O último sobrevoo ocorreu em setembro de 2009 e a nave entrou em órbita do planeta em 18 de março de 2011, quando começou a mapear o restante do planeta, numa missão com duração nominal de um ano terrestre. Mercúrio tem uma aparência similar à da Lua com crateras de impacto e planícies lisas, não possuindo satélites naturais nem uma atmosfera substancial. Entretanto, diferentemente da Lua, possui uma grande quantidade de ferro no núcleo que gera um campo magnético, cuja intensidade é cerca de 1% da intensidade do campo magnético da Terra. É um planeta excepcionalmente denso devido ao tamanho relativo de seu núcleo. A temperatura em sua superfície varia de 100 a 700 K (−173 °C a 427 °C). O ponto subsolar é a região mais quente e o fundo das crateras perto dos polos as regiões mais frias.", "voltar":"planeta_telurico", "imagem":"640px-Mercury_in_color_-_Prockter07.jpg", "pagina":""}');
db["venus"] = $.parseJSON('{"titulo":"Vênus", "descricao":"Vênus é o segundo planeta do Sistema Solar em ordem de distância a partir do Sol, orbitando-o a cada 224,7 dias. Recebeu seu nome em homenagem à deusa romana do amor e da beleza Vénus, equivalente a Afrodite. Depois da Lua, é o objeto mais brilhante do céu noturno, atingindo uma magnitude aparente de -4,6, o suficiente para produzir sombras. Como Vénus se encontra mais próximo do Sol do que a Terra, ele pode ser visto aproximadamente na mesma direção do Sol (sua maior elongação é de 47,8°). Vénus atinge seu brilho máximo algumas horas antes da alvorada ou depois do ocaso, sendo por isso conhecido como a estrela da manhã (Estrela d\'Alva) ou estrela da tarde (Vésper); também é chamado Estrela do Pastor. Vénus é considerado um planeta do tipo terrestre ou telúrico, chamado com frequência de planeta irmão da Terra, já que ambos são similares quanto ao tamanho, massa e composição. Vénus é coberto por uma camada opaca de nuvens de ácido sulfúrico altamente reflexivas, impedindo que a sua superfície seja vista do espaço na luz visível. Ele possui a mais densa atmosfera entre todos os planetas terrestres do Sistema Solar, constituída principalmente de dióxido de carbono. Vénus não possui um ciclo do carbono para fixar o carbono em rochas ou outros componentes da superfície, nem parece ter qualquer vida orgânica para absorvê-lo como biomassa. Acredita-se que no passado Vénus possuía oceanos como os da Terra, que se evaporaram quando a temperatura se elevou, restando uma paisagem desértica, seca e poeirenta, com muitas pedras em forma de placas. A água provavelmente se dissociou e, devido à inexistência de um campo magnético, o hidrogênio foi arrastado para o espaço interplanetário pelo vento solar. A pressão atmosférica na superfície do planeta é 92 vezes a da Terra.", "voltar":"planeta_telurico", "imagem":"Venus-real.jpg", "pagina":""}');
db["terra"] = $.parseJSON('{"titulo":"Terra", "descricao":"A Terra é o terceiro planeta mais próximo do Sol, o mais denso e o quinto maior dos oito planetas do Sistema Solar. É também o maior dos quatro planetas telúricos. É por vezes designada como Mundo ou Planeta Azul. Lar de milhões de espécies de seres vivos, incluindo os humanos, a Terra é o único corpo celeste onde é conhecida a existência de vida. O planeta formou-se há 4,56 bilhões de anos, e a vida surgiu na sua superfície um bilhão de anos depois. Desde então, a biosfera terrestre alterou significativamente a atmosfera e outros fatores abióticos do planeta, permitindo a proliferação de organismos aeróbicos, bem como a formação de uma camada de ozônio, a qual, em conjunto com o campo magnético terrestre, bloqueia radiação solar prejudicial, permitindo a vida no planeta.18 As propriedades físicas do planeta, bem como suas história geológica e órbita, permitiram que a vida persistisse durante este período. Acredita-se que a Terra poderá suportar vida durante pelo menos outros 500 milhões de anos. A sua superfície exterior está dividida em vários segmentos rígidos, chamados placas tectônicas, que migram sobre a superfície terrestre ao longo de milhões de anos. Cerca de 71% da superfície da Terra está coberta por oceanos de água salgada, com o restante consistindo de continentes e ilhas, os quais contêm muitos lagos e outros corpos de água que contribuem para a hidrosfera. Não se conhece a existência de água no estado líquido em equilíbrio, necessária à manutenção da vida como a conhecemos, na superfície de qualquer outro planeta. Os polos geográficos da Terra encontram-se maioritariamente cobertos por mantos de gelo ou por banquisas. O interior da Terra permanece ativo, com um manto espesso e relativamente sólido, um núcleo externo líquido que gera um campo magnético, e um núcleo interno sólido, composto sobretudo por ferro. A Terra interage com outros objetos no espaço, em particular com o Sol e a Lua. No presente, a Terra orbita o Sol uma vez por cada 366,26 rotações sobre o seu próprio eixo, o que equivale a 365,26 dias solares ou um ano sideral. O eixo de rotação da Terra possui uma inclinação de 23,4° em relação à perpendicular ao seu plano orbital, produzindo variações sazonais na superfície do planeta com período igual a um ano tropical (365,24 dias solares). A Lua é o único satélite natural conhecido da Terra, tendo começado a orbitá-la há 4,53 bilhões de anos. É responsável pelas marés, estabiliza a inclinação axial da Terra e abranda gradualmente a rotação do planeta. Entre aproximadamente 4,1 e 3,8 bilhões de anos atrás, durante o intenso bombardeio tardio, impactos de asteroides causaram mudanças significativas na superfície terrestre. Os recursos minerais da Terra em conjunto com os produtos da biosfera, fornecem recursos que são utilizados para suportar uma população humana global. Estes habitantes da Terra estão agrupados em cerca de 200 estados soberanos, que interagem entre si por meio da diplomacia, viagens, comércio e ação militar. As culturas humanas desenvolveram várias crenças sobre o planeta, incluindo a sua personificação em uma deidade, a crença numa Terra plana, ou em que a Terra é o centro do universo, e uma perspectiva moderna do mundo como um ambiente integrado que requer proteção.", "voltar":"planeta_telurico", "imagem":"480px-Blue_Marble_Western_Hemisphere.jpg", "pagina":["lua"]}');
db["marte"] = $.parseJSON('{"titulo":"Marte", "descricao":"Marte é o quarto planeta a partir do Sol, o segundo menor do Sistema Solar. Batizado em homenagem ao deus romano da guerra, muitas vezes é descrito como o \\"Planeta Vermelho\\", porque o óxido de ferro predominante em sua superfície lhe dá uma aparência avermelhada. Marte é um planeta rochoso com uma atmosfera fina, com características de superfície que lembram tanto as crateras de impacto da Lua quanto vulcões, vales, desertos e calotas polares da Terra. O período de rotação e os ciclos sazonais de Marte são também semelhantes aos da Terra, assim como é a inclinação que produz as suas estações do ano. Marte é o lar do Monte Olimpo, a segunda montanha mais alta conhecida no Sistema Solar (a mais alta em um planeta), e do Valles Marineris, um desfiladeiro gigantesco. A suave Bacia Polar Norte, no hemisfério norte marciano, cobre cerca de 40% do planeta e pode ser uma enorme marca de impacto. Marte tem duas luas conhecidas, Fobos e Deimos, que são pequenas e de forma irregular. Estas luas podem ser asteroides capturados, semelhante ao 5261 Eureka, um asteroide troiano marciano.", "voltar":"planeta_telurico", "imagem":"480px-Mars_Valles_Marineris_EDIT.jpg", "pagina":""}');
db["lua"] = $.parseJSON('{"titulo":"Lua", "descricao":"A Lua é o único satélite natural da Terra e o quinto maior do Sistema Solar. É o maior satélite natural de um planeta no sistema solar em relação ao tamanho do seu corpo primário, tendo 27% do diâmetro e 60% da densidade da Terra, o que representa 1⁄81 da sua massa. Entre os satélites cuja densidade é conhecida, a Lua é o segundo mais denso, atrás de Io. Estima-se que a formação da Lua tenha ocorrido há cerca de 4,5 bilhões de anos, relativamente pouco tempo após a formação da Terra. Embora no passado tenham sido propostas várias hipóteses para a sua origem, a explicação mais consensual atualmente é a de que a Lua tenha sido formada a partir dos detritos de um impacto de proporções gigantescas entre a Terra e um outro corpo do tamanho de Marte. A Lua encontra-se em rotação sincronizada com a Terra, mostrando sempre a mesma face visível, marcada por mares vulcânicos escuros entre montanhas cristalinas e proeminentes crateras de impacto. É o mais brilhante objeto no céu a seguir ao Sol, embora a sua superfície seja na realidade escura, com uma refletância pouco acima da do asfalto. A sua proeminência no céu e o seu ciclo regular de fases tornaram a Lua, desde a antiguidade, uma importante referência cultural na língua, em calendários, na arte e na mitologia. A influência da gravidade da Lua está na origem das marés oceânicas e ao aumento do dia sideral da Terra. A sua atual distância orbital, cerca de trinta vezes o diâmetro da Terra, faz com que no céu o satélite pareça ter o mesmo tamanho do Sol, permitindo-lhe cobri-lo por completo durante um eclipse solar total.", "voltar":"terra", "imagem":"505px-FullMoon2010.jpg", "pagina":""}');
db["jupiter"] = $.parseJSON('{"titulo":"Júpiter", "descricao":"Júpiter é o maior planeta do Sistema Solar, tanto em diâmetro quanto em massa e é o quinto mais próximo do Sol. Possui menos de um milésimo da massa solar, contudo tem 2,5 vezes a massa de todos os outros planetas em conjunto. É um planeta gasoso junto com Saturno, Urano e Netuno. Estes quatro planetas são por vezes chamados de planetas jupiterianos ou planetas jovianos. Júpiter é um dos quatro gigantes gasosos, isto é, não é composto primariamente de matéria sólida. Júpiter é composto principalmente de hidrogênio e hélio. O planeta também pode possuir um núcleo composto por elementos mais pesados. Por causa de sua rotação rápida, de cerca de dez horas, ele possui o formato de uma esfera oblata. Sua atmosfera é dividida em diversas faixas, em várias latitudes, resultando em turbulência e tempestades onde as faixas se encontram. Uma dessas tempestades é a Grande Mancha Vermelha, uma das características visíveis de Júpiter mais conhecidas e proeminentes, cuja existência data do século XVII, com ventos de até 500 km/h e possuindo um diâmetro transversal duas vezes maior do que a Terra.", "voltar":"planeta_gasoso", "imagem":"480px-Jupiter.jpg", "pagina":""}');
db["saturno"] = $.parseJSON('{"titulo":"Saturno", "descricao":"Saturno é o sexto planeta a partir do Sol e o segundo maior do Sistema Solar atrás de Júpiter. Nomeado pelo deus romano da agricultura, seu símbolo astronômico (♄) representa a foice da divindade.7 Saturno é um planeta gasoso com um raio aproximadamente nove vezes maior que o da Terra. Apesar de ter apenas um oitavo da densidade da Terra, sua massa é 95 vezes maior. O interior de Saturno é provavelmente formado por um núcleo de ferro, níquel e rocha (composto de silício e oxigênio), cercado por uma profunda camada de hidrogênio metálico, uma camada intermediária de hidrogênio e hélio líquido e uma exterior gasosa. O planeta possui um tom amarelo claro por causa dos cristais de amônia em sua atmosfera superior. Acredita-se que correntes elétricas dentro da camada de hidrogênio metálico criam seu campo magnético planetário, que é mais fraco que o da Terra porém com um momento magnético 580 vezes maior por causa de seu tamanho. A força do campo magnético de Saturno é por volta de um vigésimo do de Júpiter. Sua atmosfera exterior é suave e com poucos contrastes, apesar características de longa duração podendo aparecer. O vento pode chegar a uma velocidade de 1800 km/h, mais rápidos que os de Júpiter, porém menores que os de Netuno. Saturno possui um proeminente sistema de anéis que consiste em nove anéis principais contínuos e três arcos descontínuos, compostos principalmente de partículas de gelo com uma quantidade menor de detritos rochosos e poeira. Saturno tem 62 satélites conhecidos,16 dos quais possuem um nome oficial. Isso não inclui centenas de \\"pequenos satélites\\" compreendendo os anéis. Titã, seu maior satélite e o segundo maior do Sistema Solar, é maior que o planeta Mercúrio e o único satélite que possui uma atmosfera substancial.", "voltar":"planeta_gasoso", "imagem":"Saturn_during_Equinox.jpg", "pagina":""}');
db["urano"] = $.parseJSON('{"titulo":"Urano", "descricao":"Urano é o sétimo planeta a partir do Sol, o terceiro maior e o quarto mais massivo dos oito planetas do Sistema Solar. Foi nomeado em homenagem ao deus grego do céu, Urano, o pai de Cronos (Saturno) e o avô de Zeus (Júpiter). Embora seja visível a olho nu em boas condições de visualização, não foi reconhecido pelos astrônomos antigos como um planeta devido a seu pequeno brilho e lenta órbita. William Herschel anunciou sua descoberta em 13 de março de 1781, expandindo as fronteiras do Sistema Solar pela primeira vez na história moderna. Urano foi também o primeiro planeta a ser descoberto por meio de um telescópio. Urano tem uma composição similar à de Netuno, e ambos possuem uma composição química diferente da dos maiores gigantes gasosos, Júpiter e Saturno. Como tal, os astrônomos algumas vezes os colocam em uma categoria separada, os \\"gigantes de gelo\\". A atmosfera de Urano, embora similar às de Júpiter e Saturno em sua composição primária de hidrogênio e hélio, contém mais \\"gelos\\" tais como água, amônia e metano, assim como traços de hidrocarbonetos. É a mais fria atmosfera planetária no Sistema Solar, com uma temperatura mínima de 49 K (–224 °C). Tem uma complexa estrutura de nuvens em camadas, e acredita-se que a água forma as nuvens mais baixas, e o metano as mais exteriores. Em contraste, seu interior é formado principalmente por gelo e rochas.", "voltar":"planeta_gasoso", "imagem":"480px-Uranus2.jpg", "pagina":""}');
db["netuno"] = $.parseJSON('{"titulo":"Netuno", "descricao":"Netuno é o oitavo planeta do Sistema Solar, o último a partir do Sol desde a reclassificação de Plutão para a categoria de planeta anão, em 2006. Pertencente ao grupo dos gigantes gasosos, possui um tamanho ligeiramente menor que o de Urano, mas maior massa, equivalente a 17 massas terrestres. Netuno orbita o Sol a uma distância média de 30,1 unidades astronômicas. O planeta é formado por um pequeno núcleo rochoso ao redor do qual encontra-se uma camada formada possivelmente por água, amônia e metano sobre a qual situa-se sua turbulenta atmosfera constituída predominantemente de hidrogênio e hélio. De fato notáveis eventos climáticos ocorrem em Netuno, inclusive a formação de diversas camadas de nuvens, tempestades ciclônicas visíveis, como a já extinta Grande Mancha Escura, além dos ventos mais rápidos do Sistema Solar, que atingem mais de 2 000 km/h. A radiação solar recebida por Netuno não seria suficiente para fornecer tamanha energia à turbulenta atmosfera, pelo que descobriu-se que o calor irradiado do centro do planeta possui um papel importante na manutenção destes eventos meteorológicos extremos. A pequena quantidade de metano nas camadas altas da atmosfera é, em parte, responsável pela coloração azul do planeta.", "voltar":"planeta_gasoso", "imagem":"Neptune_Full.jpg", "pagina":""}');
db["plutao"] = $.parseJSON('{"titulo":"Plutão", "descricao":"Plutão, formalmente designado 134340 Plutão, é um planeta anão do Sistema Solar e o décimo objeto mais massivo observado diretamente orbitando o Sol. Originalmente classificado como um planeta, Plutão é atualmente o maior membro do cinturão de Kuiper. Como outros membros do cinturão de Kuiper, Plutão é composto primariamente de rocha e gelo e é relativamente pequeno, com aproximadamente um quinto da massa da Lua e um terço de seu volume. Ele tem uma órbita altamente inclinada e excêntrica que o leva de 30 a 49 UA do Sol. Isso faz Plutão ficar periodicamente mais perto do Sol do que Netuno. Atualmente Plutão está a 32,32 UA do Sol. Até 2006, Plutão foi considerado o nono planeta do Sistema Solar. No final da década de 1970, com a descoberta de 2060 Chiron e o reconhecimento da sua pequena massa, sua classificação como um planeta começou a ser questionada. No início do século XXI, vários outros objetos similares a Plutão foram descobertos no Sistema Solar externo, incluindo Éris, que é 27% mais massivo do que ele. Em 24 de agosto de 2006, a União Astronômica Internacional (UAI) criou uma definição de planeta formal, que fez Plutão deixar de ser planeta e ganhar a nova classificação de planeta anão, juntamente com Éris e Ceres. Depois da reclassificação, Plutão foi adicionado à lista de corpos menores do Sistema Solar e recebeu a identificação 134340. Porém, há cientistas que afirmam que Plutão não deveria ser considerado planeta anão, mas voltar a ser classificado como planeta.", "voltar":"planeta_anao", "imagem":"plutao25b45d1.jpg", "pagina":""}');
db["eris"] = $.parseJSON('{"titulo":"Éris", "descricao":"Éris, conhecido oficialmente como 136199 Eris, é um planeta anão e um plutoide nos confins do sistema solar, numa região conhecida como disco disperso. Talvez seja o maior planeta anão do sistema solar e quando foi descoberto, ficou desde logo informalmente conhecido como o \\"décimo planeta\\", porque na época seu diâmetro estimado era maior do que o diâmetro do ex-planeta Plutão.", "voltar":"planeta_anao", "imagem":"Eris_and_dysnomia2.jpg", "pagina":""}');
db["supornova"] = $.parseJSON('{"titulo":"Supernova", "descricao":"Supernova é o nome dado aos corpos celestes surgidos após as explosões de estrelas (estimativa) com mais de 10 massas solares, que produzem objetos extremamente brilhantes, os quais declinam até se tornarem invisíveis, passadas algumas semanas ou meses. Em apenas alguns dias o seu brilho pode intensificar-se em 1 bilhão de vezes a partir de seu estado original, tornando a estrela tão brilhante quanto uma galáxia, mas, com o passar do tempo, sua temperatura e brilho diminuem até chegarem a um grau inferior aos primeiros.", "voltar":"estrela_variavel", "imagem":"600px-Keplers_supernova.jpg", "pagina":""}');
//#######################################
db["sondas_espaciais"] = $.parseJSON('{"titulo":"Sondas espaciais", "descricao":"Sonda espacial é uma nave espacial não tripulada, utilizada para a exploração remota de outros planetas, satélites, asteroides ou cometas. Normalmente as sondas tem recursos de telemetria, que permitem estudar à distância suas características físico-químicas, tirar fotografias e por vezes também o seu meio ambiente. Algumas sondas, como Landers ou Rovers, pousam na superfície dos astros celestes, para estudos de sua geologia e do seu clima. As primeiras sondas para estudar outros astros foram lançadas no fim da década de 1950 pela extinta União Soviética e Estados Unidos, logo no início da exploração espacial, e que ajudaram muito a desvendar os mistérios do Universo. Recentemente, a União Europeia, Japão, República Popular da China e Índia também já lançaram as suas sondas.", "voltar":"home", "imagem":"", "pagina":["voyager_1","voyager_2","mars_reconnaissance_orbiter","messenger","venus_express","genesis","rosetta","mars_science_laboratory","new_horizons"]}');
db["voyager_1"] = $.parseJSON('{"titulo":"Voyager 1", "descricao":"Voyager 1 é uma sonda espacial norte-americana lançada ao espaço em 5 de setembro de 1977 para estudar o Sistema Solar exterior e, posteriormente, o espaço interestelar. Em operação há mais de 36 anos, a sonda espacial recebe comandos de rotina e transmite dados para a Terra até hoje. A sonda encontra-se atualmente fora do Sistema Solar, informação que foi oficialmente confirmada pela NASA no dia 12 de setembro de 2013. Inserida no programa Voyager, que previa o desenvolvimento de duas sondas de exploração inter-planetária (Voyager 1 e 2), ela tinha como objetivo a realização de um \\"Grand Tour\\" espacial, aproveitando o posicionamento favorável dos gigantes gasosos do Sistema Solar. Originalmente, porém, o Grand Tour foi desenhado para permitir visitas a apenas Júpiter e Saturno. Sua missão inicial e primária encerrou-se em 20 de novembro de 1980, após seu encontro com o sistema joviano em 1979 e o sistema saturniano em 1980.", "voltar":"sondas_espaciais", "imagem":"614px-Voyager.jpg", "pagina":""}');
db["voyager_2"] = $.parseJSON('{"titulo":"Voyager 2", "descricao":"Voyager 2 é uma nave robótica norte-americana lançada pela NASA a 20 de Agosto de 1977 da Estação da Força Aérea de Cabo Canaveral, na Flórida. Aproximou-se dos quatro planetas gigantes do Sistema Solar, produzindo valiosíssimos resultados científicos e as melhores fotografias daqueles corpos e dos seus satélites obtidas até então. Tornou-se o quarto artefato humano a ultrapassar a órbita de Plutão em 1989, e em 2005 encontrava-se a uma distância de cerca de 75 UAs da Terra. Utilizou uma técnica de auxílio à navegação que utiliza a atração gravítica dos planetas aos quais se aproxima. Esta técnica permite às sondas receberem uma aceleração e uma alteração de direção por forma a serem colocadas numa nova direção que as leve a um novo destino. Desta forma, as sondas podem ser construídas de forma mais leve (não necessitam de tanto combustível para aceleração e mudanças de direção) mas implica uma grande precisão nas aproximações aos planetas a visitar.", "voltar":"sondas_espaciais", "imagem":"614px-Voyager.jpg", "pagina":""}');
db["mars_reconnaissance_orbiter"] = $.parseJSON('{"titulo":"Mars Reconnaissance Orbiter", "descricao":"Mars Reconnaissance Orbiter é uma sonda norte-americana que tem a finalidade de procurar evidências de existência de água, no passado remoto de Marte. Trata-se de uma sonda enviada pela NASA, sob os cuidados do Laboratório de Jato-propulsão, que está encarregado de gerenciar esta sonda. A sonda foi lançada em 10 de agosto de 2005, as 11:43 da manhã, da Estação da Força Aérea de Cabo Canaveral, situada no estado da Flórida, por um foguete da Lockheed Martin, modelo Atlas V 401.", "voltar":"sondas_espaciais", "imagem":"Mars_Reconnaissance_Orbiter.jpg", "pagina":""}');
db["messenger"] = $.parseJSON('{"titulo":"MESSENGER", "descricao":"A sonda MESSENGER é uma missão não tripulada da NASA, gerenciada pelo Jet Propulsion Laboratory - JPL, destinada a estudar as características e o ambiente do planeta Mercúrio. Especificamente, os objetivos científicos da missão são os de caracterizar a composição química da superfície de Mercúrio, a sua história geológica, a natureza do seu campo magnético, o tamanho e o estado do núcleo planetário, pesquisar seus polos e a natureza da sua exosfera e da sua magnetosfera, numa missão orbital de um ano terrestre de duração. MESSENGER é um acrônimo em inglês de MErcury Surface, Space ENvironment, GEochemistry and Ranging (\\"Superfície, Ambiente Espacial, Geoquímica e Amplitude de Órbita de Mercúrio\\"). Este acrônimo foi escolhido porque Mercúrio era o mensageiro dos deuses, de acordo com a mitologia romana. A sonda MESSENGER foi lançada ao espaço em 3 de Agosto de 2004, a bordo de um foguete Boeing Delta II, do Cabo Canaveral, na Flórida, Estados Unidos.", "voltar":"sondas_espaciais", "imagem":"609px-Messenger.jpg", "pagina":""}');
db["venus_express"] = $.parseJSON('{"titulo":"Venus Express", "descricao":"A Venus Express é a primeira missão da Agência Espacial Europeia (ESA) ao planeta Vénus. A missão foi proposta em 2001 como forma de reutilização do desenho da Mars Express. Contudo, algumas características da missão levaram a mudanças no desenho, principalmente em áreas de controlo termal, comunicações e electricidade. A missão Venus Express também utiliza instrumentos desenvolvidos para a missão da sonda Rosetta. O objectivo da missão é fazer observações globais da atmosfera venusiana, das características da superfície e da interacção do ambiente do planeta com o vento solar. A missão foi lançada no dia 9 de novembro de 2005 pelo foguete Soyuz e entrou em órbita de Vénus no dia 11 de abril de 2006, depois de aproximadamente 150 dias de viagem. Em 11 de Abril de 2006, a sonda deu sua primeira volta em torno do planeta, a chamada órbita de captura, que foi uma elipse em torno de Vénus cujo apocentro se encontrava a 330 000 quilómetros e o pericentro a menos de 400 quilómetros. Menos de um mês depois da inserção em órbita, e depois de voar dezasseis vezes em torno de Vénus, a nave espacial chegou à sua órbita operacional final a 7 de Maio de 2006.", "voltar":"sondas_espaciais", "imagem":"Venus_Express_in_orbit.jpg", "pagina":""}');
db["genesis"] = $.parseJSON('{"titulo":"Genesis", "descricao":"A sonda espacial Genesis é uma missão não-tripulada da NASA, gerenciada pelo Jet Propulsion Laboratory - JPL, consistindo na primeira tentativa de se coletar amostras de vento solar e foi a primeira sonda a retornar amostras do espaço, além da órbita da Lua. A sonda foi lançada em 8 de Agosto de 2001, e aterrissando violentamente em 8 de Setembro de 2004, devido a uma falha na abertura de seu pára-quedas. A queda acabou contaminando muitas de suas amostras, mas processos laboratoriais subsequentes foram capazes de isolar as amostras e foi anunciado em abril de 2005, que alguns dos objetivos científicos da missão foram atingidos.", "voltar":"sondas_espaciais", "imagem":"574px-Genesis_in_collection_mode.jpg", "pagina":""}');
db["rosetta"] = $.parseJSON('{"titulo":"Rosetta", "descricao":"Rosetta é uma sonda espacial construída e lançada pela Agência Espacial Europeia (ESA) com a missão de encontrar-se no espaço e fazer um estudo detalhado do cometa 67P/Churyumov-Gerasimenko, que viaja entre as órbitas da Terra e de Júpiter. Ela integra o conjunto de missões Horizon 2000 da agência espacial e é a primeira sonda construída para orbitar e pousar num cometa. Lançada em 2 de março de 2004 da base de Kourou, na Guiana Francesa, no topo de um foguete Ariane 5 G+, a sonda atingiu seu alvo na metade de 2014. A nave compreende duas partes, a sonda espacial Rosetta, que carrega 11 instrumentos, e o pousador-robótico Philae, que transporta mais dez. A missão orbitará o cometa 67P por 17 meses e foi construída para fazer o mais detalhado estudo de um cometa jamais tentado. A sonda recebeu este nome em homenagem à Pedra da Rosetta, que após sua descoberta em 1799 auxiliou no entendimento dos hieróglifos egípcios. O módulo pousador é batizado com o nome da ilha de Philae, no rio Nilo, onde foi descoberto um obelisco que também contribuiu para decifrar os hieróglifos de Rosetta.", "voltar":"sondas_espaciais", "imagem":"Rosetta_spacecraft_(transparent_bg).png", "pagina":""}');
db["new_horizons"] = $.parseJSON('{"titulo":"New Horizons", "descricao":"New Horizons é uma missão não-tripulada da NASA para estudar o planeta-anão Plutão e o Cinturão de Kuiper. Ela deverá ser a primeira espaçonave a sobrevoar Plutão e suas pequenas luas Caronte, Nix, Hydra, Cérbero e Estige, com uma data estimada de chegada ao sistema Plutão-Caronte em 14 de julho de 2015, após cerca de nove anos e meio de viagem interplanetária. O principal objetivo desta missão é o de caracterizar globalmente a geologia e a morfologia de Plutão e suas luas, além de mapear suas superfícies. Também vai procurar estudar a atmosfera neutra de Plutão e sua taxa de fuga. Outros objetivos secundários incluem o estudo das variações da superfície e da atmosfera de Plutão e de Caronte ao longo do tempo. Serão obtidas imagens de alta-definição em estéreo de determinadas áreas dos dois corpos celestes, para caracterizar a sua atmosfera superior, a ionosfera, as partículas energéticas do meio ambiente e a sua interação com o vento solar. Além disso, a sonda vai procurar pela existência de alguma atmosfera em torno de Caronte e caracterizar a ação das partículas energéticas entre Plutão e Caronte. Também irá procurar por satélites ainda não descobertos e por possíveis anéis que envolvam o planeta-anão e seu satélite, antes de ser direcionado para o Cinturão de Kuiper e de lá para o espaço interestelar.", "voltar":"sondas_espaciais", "imagem":"Encounter_01_lg.jpg", "pagina":""}');
db["mars_science_laboratory"] = $.parseJSON('{"titulo":"Mars Science Laboratory", "descricao":"Mars Science Laboratory (MSL) é a designação de uma sonda espacial da NASA, lançada em 26 de novembro de 2011, levando em seu interior um rover batizado como Curiosity (em português, Curiosidade), um jipe robô semelhante aos veículos Spirit e Opportunity, utilizados na missão espacial Mars Exploration Rover para a exploração do planeta. O pouso na superfície de Marte, mais precisamente na cratera Gale, ocorreu em 6 de agosto de 2012. Os principais objetivos do Curiosity incluem investigar a possibilidade da existência de vida em Marte (isto é, sua habitabilidade planetária), estudar o clima, a areologia e coletar dados para o envio de uma futura missão tripulada a Marte. O Curiosity transporta os mais avançados instrumentos científicos já utilizados em Marte, possibilitando a esta missão realizar análises do solo marciano nunca antes registradas. A comunidade internacional foi a responsável pelo fornecimento da maioria dos seus instrumentos, não tendo sido portanto um projeto exclusivo dos Estados Unidos.", "voltar":"sondas_espaciais", "imagem":"MSL_final_assembly_2011-7372.jpg", "pagina":""}');
//#######################################
db["acontecimentos_historicos"] = $.parseJSON('{"titulo":"Acontecimentos históricos", "descricao":"Nessa página você encontra alguns fatos históricos da astronomia.", "voltar":"home", "imagem":"", "pagina":["corrida_espacial","a_revolucao_de_copernico","laika","sputnik_i","apollo_11"]}');
db["corrida_espacial"] = $.parseJSON('{"titulo":"Corrida espacial", "descricao":"Corrida espacial foi uma disputa ocorrida na segunda metade do século XX entre a União Soviética (URSS) e os Estados Unidos pela supremacia na exploração e tecnologia espacial. Entre 1957 e 1975, a rivalidade entre as duas superpotências durante a Guerra Fria focou-se em atingir pioneirismos na exploração do espaço, que eram vistos como necessários para a segurança nacional e símbolos da superioridade tecnológica e ideológica de cada país. A corrida espacial envolveu esforços pioneiros no lançamento de satélites artificiais, vôo espacial humano sub-orbital e orbital em torno da Terra e viagens tripuladas à Lua. A competição efetivamente começou com o lançamento do satélite artificial soviético Sputnik 1 em 4 de outubro de 1957 e concluiu-se com o projeto cooperativo Apollo-Soyuz em julho de 1975. O Projeto de Teste Apollo-Soyuz passou então a simbolizar uma flexibilização parcial das relações tensas entre a URSS ( União da República Socialistas Sovieticas ) e os Estados Unidos. A corrida espacial teve suas origens na corrida armamentista que ocorreu logo após o fim da Segunda Guerra Mundial, quando tanto a União Soviética quanto os Estados Unidos capturaram a tecnologia e especialistas de foguetes avançados alemães. A corrida espacial provocou um aumento sem precedentes nos gastos com educação e pesquisa pura, o que acelerou os avanços científicos e levou a tecnologias benéficas para a população. Algumas sondas e missões famosas incluem Sputnik 1, Explorer 1, Vostok 1, Mariner 2, Ranger 7, Luna 9, Apollo 8 e Apollo 11.", "voltar":"acontecimentos_historicos", "imagem":"", "pagina":""}');
db["a_revolucao_de_copernico"] = $.parseJSON('{"titulo":"A Revolução de Copérnico", "descricao":"A renascença chegou na astronomia através dos estudos de Nicolau Copérnico, que propôs um modelo heliocêntrico do Universo. Seu trabalho foi defendido, ampliado e corrigido, pelas ideias de Galileu Galilei e Johannes Kepler. Kepler, usando observações a olho nu feitas pelo astrônomo Tycho Brahe, descobriu as leis do movimento planetário que carregam seu nome (embora ele as tenha publicado misturadas com outras ideias, e não dava a importância que damos a elas hoje). Galileu foi um dos primeiros a observar o céu noturno com um telescópio, e após construir um telescópio refrator 20x, descobriu as quatro maiores luas de Júpiter em 1610. Essa foi a primeira observação conhecida de satélites orbitando outro planeta. Ele também observou que nossa Lua apresentava crateras, e observou (e explicou corretamente) as manchas solares. Isso somado ao fa(c)to de Galileu ter notado que Vênus exibia um completo conjunto de fases, similar as fases da Lua, foi visto como incompatível com o modelo geocêntrico defendido pela igreja, o que levou a muita controvérsia.", "voltar":"acontecimentos_historicos", "imagem":"Nikolaus_Kopernikus.jpg", "pagina":""}');
db["laika"] = $.parseJSON('{"titulo":"Laika", "descricao":"Laika (em russo Лайка, 1954 — 1957) foi uma cadela russa que se tornou conhecida por ser o primeiro ser vivo terrestre a orbitar o planeta Terra. Ela foi lançada ao espaço a bordo da nave soviética Sputnik 2, em 3 de novembro de 1957, um mês depois do lançamento do satélite Sputnik 1, o primeiro objeto artificial a entrar em órbita. Laika é o nome russo para várias raças de cães similares ao husky, oriundas da Sibéria. A sua raça verdadeira é desconhecida, mas considera-se que ela teria sido um cruzamento entre um husky ou outra raça nórdica com um terrier da raça Laika. Laika morreu entre cinco e sete horas depois do lançamento, bem antes do planejado. A causa de sua morte, que só foi revelada décadas depois do voo, foi, provavelmente, uma combinação de estresse sofrido e o superaquecimento, talvez ocasionado por uma falha no sistema de controle térmico da nave. Apesar do acidente, essa experiência demonstrou ser possível para um animal suportar as condições de microgravidade, abrindo caminho assim para participação humana em voos espaciais.", "voltar":"acontecimentos_historicos", "imagem":"Stamps_of_Hungary,_001-07_(cropped).jpg", "pagina":""}');
db["sputnik_i"] = $.parseJSON('{"titulo":"Sputnik I", "descricao":"Sputnik 1 foi a primeira missão do Programa Sputnik, que enviou o primeiro satélite artificial da Terra. A missão foi lançada pela URSS em 4 de outubro de 1957 do Cosmódromo de Baikonur. O Sputnik era uma esfera de aproximadamente 50cm e pesando 83,6 kg. Ele não tinha nenhuma função, a não ser transmitir um sinal de rádio, \\"beep\\", que podia ser sintonizado por qualquer radio-amador. O satélite orbitou a Terra por três meses antes de cair. Seu foguete lançador, chamado R.7, pesava 4 toneladas e entrou em órbita também. Ele foi projetado originalmente para lançar ogivas nucleares. O Sputnik 1 foi o primeiro satélite artificial a ser lançado pela antiga União Soviética e o primeiro satélite a ser lançado também pela humanidade. Seu lançamento abriu, simbolicamente falando, a \\"porta\\" para o começo da corrida espacial entre Estados Unidos e URSS.", "voltar":"acontecimentos_historicos", "imagem":"638px-Sputnik.jpg", "pagina":""}');
db["apollo_11"] = $.parseJSON('{"titulo":"Apollo 11", "descricao":"Apollo 11 foi a quinta missão tripulada do Programa Apollo e a primeira a realizar uma alunagem, no dia 20 de julho de 1969. Tripulada pelos astronautas Neil Armstrong, Edwin \'Buzz\' Aldrin e Michael Collins, a missão cumpriu a meta proposta pelo Presidente John F. Kennedy em 25 de maio de 1961, quando, perante o Congresso dos Estados Unidos, afirmou que: \\"Eu acredito que esta nação deve comprometer-se em alcançar a meta, antes do final desta década, de pousar um homem na Lua e trazê-lo de volta à Terra em segurança\\" — Pres. Kennedy, 25 de maio de 1961. Composta pelo módulo de comando Columbia, o módulo lunar Eagle e o módulo de serviço, a Apollo 11, com seus três tripulantes a bordo, foi lançada de Cabo Canaveral, na Flórida, às 13:32 UTC de 16 de julho, na ponta de um foguete Saturno V, sob o olhar de centenas de milhares de espectadores que enchiam estradas, praias e campos em redor do Centro Espacial Kennedy e de milhões de espectadores pela televisão em todo o mundo, para a histórica missão de oito dias de duração, que culminou com as duas horas e quarenta e cinco minutos de caminhada de Armstrong e Aldrin na Lua.", "voltar":"acontecimentos_historicos", "imagem":"Apollo_11_insignia.png", "pagina":""}');
//########################################################
db["calendario_astronomico_2015"] = $.parseJSON('{"titulo":"Calendário astrônomico 2015", "descricao":"Esse calendário astrônomico contém datas notáveis ​​eventos celestes, incluindo as fases da lua, chuvas de meteoros, eclipses, ocultações, oposições, conjunções e outros eventos interessantes.", "voltar":"home", "imagem":"", "pagina":["dezembro","novembro","outubro","setembro","agosto","julho","junho","maio","abril","marco","fevereiro","janeiro"]}');
db["fevereiro"] = $.parseJSON('{"titulo":"Fevereiro", "descricao":"<b>Fevereiro</b> - Alvorecer em Ceres - A sonda da NASA, Dawn irá encontrar o planeta anão conhecido como Ceres em algum momento de Fevereiro de 2015. Ceres é o maior objeto no cinturão de asteróides entre Marte e Júpiter. Devido ao seu tamanho e forma, foi oficialmente classificado como um planeta anão, o que o coloca na mesma categoria de Plutão. Ceres é 590 milhas (950 km) de diâmetro e é grande o suficiente para ter uma forma redonda. Dawn vai passar vários meses estudando Ceres e enviar de volta o primeiro close-up de imagens de um planeta anão do nosso Sistema Solar.<br>\
<b>03 de fevereiro</b> - Lua Cheia - A Lua estará  estará iluminada, visto da Terra. Esta fase ocorre a 23:09 UTC.<br>\
<b>06 de fevereiro</b> - Júpiter em oposição - O planeta gigante vai ser a sua maior aproximação à Terra e seu rosto será totalmente iluminada pelo sol. Esta é a melhor hora para ver e fotografar Júpiter e suas luas.<br>\
<b>18 fevereiro</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 23:47 UTC.<br>\
<b>22 de fevereiro</b> - Conjunção de Vênus e Marte - Os dois planetas brilhantes serão visíveis dentro de apenas meio grau um do outro no céu noturno. Olhe para o oeste, logo após pôr do sol.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["janeiro"] = $.parseJSON('{"titulo":"Janeiro", "descricao":"<b>03 e 04 de janeiro</b>  - Chuva de Meteoros Quadrantids - A chuva de meteoros Quadrantids é uma chuva de meteoros acima da média, com até 40 meteoros por hora no pico. Com pico em 3 de janeiro e/ou 4, mas alguns meteoros podem ser visíveis a partir de janeiro 1-5. Melhor visualização será a partir de um local escuro depois da meia-noite. A lua quase cheia causará problemas este ano, escondendo-se todos, mas os mais brilhantes meteoros. Procure por meteoros que irradia da constelação de Bootes.<br>\
<b>05 de janeiro</b> - Lua Cheia - A Lua estará iluminada, visto da Terra. Esta fase ocorre a 04:53 UTC.<br>\
<b>20 de janeiro</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 13:14 UTC.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["marco"] = $.parseJSON('{"titulo":"Março", "descricao":"<b>05 de março</b> - Lua Cheia - A Lua estará iluminada, visto da Terra. Esta fase ocorre a 18:05 UTC.<br>\
<b>20 de março</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 09:36 UTC.<br>\
<b>20 de março</b> - Eclipse solar total - O caminho da totalidade começará no Oceano Atlântico central e se moverá para o norte através da Groenlândia e no norte da Sibéria.<br>\
<b>20 de março</b> - Equinócio de Outono - O equinócio de março ocorre às 22:45 UTC. O Sol vai brilhar diretamente sobre o equador e haverá quantidades quase iguais de dia e noite em todo o mundo. Este é também o primeiro dia da primavera (equinócio vernal) no hemisfério norte e o primeiro dia de outono (equinócio de outono) no hemisfério sul.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["abril"] = $.parseJSON('{"titulo":"Abril", "descricao":"<b>04 de abril</b> - Lua Cheia - A Lua estará iluminada, visto da Terra. Esta fase ocorre a 12:05 UTC.<br>\
<b>04 de abril</b> - Eclipse Lunar Total - O eclipse será visível em quase toda a América do Norte, América do Sul, leste da Ásia e Austrália.<br>\
<b>18 de abril</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 18:57 UTC.<br>\
<b>21 e 22 de abril</b> - Chuva de Meteoros Lyrids - Os Lyrids é uma chuva de meteoros média, produz normalmente cerca de 20 meteoros por hora em seu pico. Esses meteoros pode produzir trilhas de poeira brilhante que duram vários segundos. O chuveiro atinge o auge em 21 de abril e 22, embora alguns meteoros podem ser visíveis a partir de abril 16-25. Uma fina, lua crescente irá definir no início da noite deixando o céu escuro por isso será um bom show. Procure por meteoros que irradiam da constelação de Lyra depois da meia-noite.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["maio"] = $.parseJSON('{"titulo":"Maio", "descricao":"<b>04 Maio</b> - Lua Cheia. - A Lua estará iluminada, visto da Terra. Esta fase ocorre a 03:42 UTC.<br>\
<b>05 e 6 de maio</b> - Chuva de Meteoros Eta Aquarids - Os Aquarids Eta são um banho de luz, geralmente produzindo cerca de 10 meteoros por hora em seu pico. O chuva de pico geralmente ocorre em 5 de maio e 6, porém vendo deve ser bom em qualquer manhã de 4 de maio - 7. O ponto radiante para esta chuva estará na constelação de Aquário. A lua quase cheia será um problema este ano, escondendo a maioria dos meteoros mais fracos em seu brilho. Melhor visualização geralmente é para o leste após a meia-noite, longe das luzes da cidade.<br>\
<b>18 Maio</b> - Lua Nova. A Lua será diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 04:13 UTC.<br>\
<b>23 de maio</b> - Saturno em oposição - O planeta dos anéis será a sua maior aproximação à Terra e seu rosto será totalmente iluminada pelo sol. Esta é a melhor hora para ver e fotografar Saturno e suas luas.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["junho"] = $.parseJSON('{"titulo":"Junho", "descricao":"<b>02 de junho</b> - Lua Cheia - A Lua estará iluminada, visto da Terra. Esta fase ocorre a 16:19 UTC.<br>\
<b>16 de junho</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 14:05 UTC.<br>\
<b>21 de junho</b> - Solstício de inverno - O solstício de inverno ocorre às 16:38 UTC. O Pólo Norte da Terra estará inclinado em direção ao Sol, que terá atingido a sua posição mais ao norte no céu e estará diretamente sobre o Trópico de Câncer em 23.44 graus de latitude norte. Este é o primeiro dia do verão (solstício de verão) no hemisfério norte eo primeiro dia do inverno (solstício de inverno) no hemisfério sul.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["julho"] = $.parseJSON('{"titulo":"Julho", "descricao":"<b>02 de julho</b> - Lua Cheia - A Lua estará iluminada, visto da Terra. Esta fase ocorre a 02:20 UTC.<br>\
<b>14 de julho</b> - New Horizons chega a Plutão - sonda New Horizons da NASA está programada para chegar a Plutão depois de uma viagem de 9 anos e meio. Lançado em 19 de janeiro de 2006, esta será a primeira nave espacial a visitar Plutão. Novos Horizontes nos dará os primeiros close-up vista para o planeta anão e suas luas. Depois de passar Plutão, a sonda irá continuar no cinturão de Kuiper para examinar alguns dos outros corpos gelados na borda do Sistema Solar.<br>\
<b>16 de julho</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 01:24 UTC.<br>\
<b>28 e 29 de Julho</b> - Chuva de Meteoros Aquarids Southern Delta - Os Aquarids Delta pode produzir cerca de 20 meteoros por hora em seu pico. A chuva atinge o auge em 28 de julho e 29, mas alguns meteoros também pode ser visto a partir de 18 julho - 18 agosto. O ponto radiante para esta chuva estará na constelação de Aquário. A lua quase cheia será um problema este ano, escondendo a maioria dos meteoros mais fracos. Melhor visualização geralmente é para o leste após a meia-noite.<br>\
<b>31 de julho</b> - Lua Cheia - A Lua estará iluminada, visto da Terra. Esta fase ocorre a 10:43 UTC. Como esta é a segunda lua cheia no mesmo mês, ela é conhecida como uma lua azul. Este calendário de eventos raros só acontece uma vez a cada poucos anos, dando origem ao termo, \\"uma vez em uma lua azul\\".", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["agosto"] = $.parseJSON('{"titulo":"Agosto", "descricao":"<b>12 e 13 de agosto</b> - Chuva de meteoros Perseidas - Perseidas é uma das melhores chuvas de meteoros para observar, produzindo até 60 meteoros por hora em seu pico. A chuva de pico geralmente ocorre em 13 de agosto e 14, mas você pode ser capaz de ver alguns meteoros qualquer tempo a partir de 23 julho - 22 agosto. O ponto radiante para este chuveiro será na constelação de Perseu. Uma fina, lua crescente vai compartilhar o céu este ano, mas não deve causar problemas para o que deveria ser um excelente show. Encontre um local longe das luzes da cidade e olhar para o nordeste depois da meia-noite.<br>\
<b>14 de agosto</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 14:53 UTC.<br>\
<b>29 de agosto</b> - Lua Cheia - A Lua estará iluminada, visto da Terra. Esta fase ocorre a 18:35 UTC.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["setembro"] = $.parseJSON('{"titulo":"Setembro", "descricao":"<b>01 de setembro</b> - Netuno em oposição - O planeta azul vai ser a sua maior aproximação à Terra. Esta é a melhor hora para ver Netuno, embora ela só vai aparecer como um pequeno ponto azul.<br>\
<b>13 de setembro</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 06:41 UTC.<br>\
<b>13 de setembro</b> - Eclipse solar parcial - O eclipse parcial será visível apenas no sul da África, Madagascar, e na Antártida.<br>\
<b>23 de setembro</b> - Equinócio de primavera - O equinócio de primavera ocorre a 08:21 UTC. O Sol vai brilhar diretamente sobre o equador e haverá quantidades quase iguais de dia e noite em todo o mundo. Este é também o primeiro dia de outono (equinócio de outono) no hemisfério norte eo primeiro dia da primavera (equinócio vernal) no hemisfério sul.<br>\
<b>28 de setembro</b> - Lua Cheia - A Lua estará iluminada, visto da Terra.Esta fase ocorre a 02:50 UTC.<br>\
<b>28 de setembro</b> - Eclipse Lunar Total - O eclipse será visível em quase toda a América do Norte e do Sul, Europa, África e Ásia ocidental.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["outubro"] = $.parseJSON('{"titulo":"Outubro", "descricao":"<b>11 de outubro</b> - Urano em Oposição - O planeta azul-verde estará em sua maior aproximação da Terra e seu rosto será totalmente iluminada pelo sol. Esta é a melhor hora para ver Urano. Devido à sua distância, ela só vai aparecer como um ponto azul-verde pequeno.<br>\
<b>13 de outubro</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 00:06 UTC.<br>\
<b>21 e 22 de outubro </b>- Chuva de Meteoros Orionids - Os Orionids é uma chuva de meteoros média produzindo cerca de 20 meteoros por hora em seu pico. Esta chuva geralmente tem pico no dia 21, mas é altamente irregular. Um bom espetáculo pode ser experimentada em qualquer manhã de outubro de 20 - 24, e alguns meteoros pode ser visto a qualquer momento a partir de outubro 17-25. Melhor visualização será para o leste após a meia-noite. Certifique-se de encontrar um local escuro longe das luzes da cidade.<br>\
<b>26 de outubro</b> - Conjunção de Vênus e Júpiter - Os dois planetas brilhantes serão visíveis dentro de um grau do outro no céu da manhã. Olhe para o leste pouco antes do nascer do sol.<br>\
<b>27 de outubro</b> - Lua Cheia - A Lua estará iluminada, visto da Terra. Esta fase ocorre a 12:05 UTC.<br>\
<b>28 de outubro</b> - Conjunção de Vênus, Marte, Júpiter - Os três planetas formam um triângulo no céu da manhã. Olhe para o leste pouco antes do nascer do sol.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["novembro"] = $.parseJSON('{"titulo":"Novembro", "descricao":"<b>11 de novembro</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 17:47 UTC.<br>\
<b>17 e 18 de novembro</b> - Chuva de Meteoros Leónidas - As Leónidas é uma das maiores chuvas de meteoros para observar, produzindo uma média de 40 meteoros por hora em seu pico. O chuveiro em si tem um ano de pico cíclico a cada 33 anos, onde centenas de meteoros pode ser visto a cada hora. A última delas ocorreu em 2001. O chuveiro atinge o auge em 17 de novembro e 18, mas você pode ver alguns meteoros de novembro 13-20. Olhe para a chuva irradiando a partir da constelação de Leão após a meia noite.<br>\
<b>25 de novembro</b> - Lua Cheia - A Lua estará iluminada, visto da Terra.Esta fase ocorre a 22:44 UTC.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
db["dezembro"] = $.parseJSON('{"titulo":"Dezembro", "descricao":"<b>07 de dezembro</b> - Conjunção da Lua e de Vênus - A lua crescente estará a 2 graus do brilhante planeta Vênus no céu da manhã. Olhe para o leste pouco antes do nascer do sol.<br>\
<b>11 de dezembro</b> - Lua Nova - A Lua estará diretamente entre a Terra e o Sol e não será visível da Terra. Esta fase ocorre a 10:29 UTC.<br>\
<b>13 e 14 de dezembro</b> - Chuva de Meteoros Geminids - Considerado por muitos como a melhor chuva de meteoros para se observar, os Geminids são conhecidos pela produção de até 60 meteoros por hora em seu pico. O pico da chuva ocorre geralmente em torno de dezembro 13 e 14, embora alguns meteoros deve ser visível a partir de dezembro 06-19. O ponto radiante para este chuveiro estará na constelação de Gêmeos. Uma fina, lua crescente irá definir no início da noite, deixando o céu escuro do que deverá ser um show incrível. Melhor visualização geralmente é para o leste após a meia-noite a partir de um local escuro.<br>\
<b>22 de dezembro</b> - Solstício de verão - O solstício de verão ocorre a 04:48 UTC. O Pólo Sul da Terra ser inclinado em direção ao Sol, que terá atingido a sua posição mais austral do céu e o sol estará diretamente sobre o Trópico de Capricórnio em 23.44 graus de latitude sul. Este é o primeiro dia do inverno (solstício de inverno) no hemisfério norte eo primeiro dia do verão (solstício de verão) no hemisfério sul.<br>\
<b>25 de dezembro</b> - Lua Cheia - A Lua estará iluminada, visto da Terra.Esta fase ocorre a 11:11 UTC.", "voltar":"calendario_astronomico_2015", "imagem":"", "pagina":""}');
//############################################################
db["curiosidades"] = $.parseJSON('{"titulo":"23 Curiosidades astronômicas", "descricao":"<b>1</b> - A Terra pesa 5 980 000 000 000 000 000 000 000 kg;<br>\
<b>2</b> - Se estás a tentar decorar o nome das estrelas, começa por esta: Torcularis Septentrionalis. Não a consegues pronunciar, mas também não consegues esquecer;<br>\
<b>3</b> - Um carro a 160km/h demoraria 221 000 milhões de anos a chegar ao centro da Via Láctea;<br>\
<b>4</b> - O Universo expande-se cerca de 1,6 biliões de km por hora;<br>\
<b>5</b> - Os astronautas não podem chorar. Não que seja lei, mas porque não existe gravidade para que as lágrimas possam escorrer;<br>\
<b>6</b> - As interferências nas televisões são provocadas pelas ondas do Big Bang no início do Universo;<br>\
<b>7</b> - A constelação do Cruzeiro do Sul tem 54 estrelas, das quais só consegues ver 5 à vista desarmada;<br>\
<b>8</b> - O maior vulcão conhecido situa-se em Marte, o Monte Olimpo, 3 vezes mais alto que o nosso Monte Evereste;<br>\
<b>9</b> - A Lua afasta-se da Terra cerca de 3cm por ano;<br>\
<b>10</b> - As estrelas anãs são tão densas, que um dado feito desse material pesaria tanto como um carro;<br>\
<b>11</b> - A estrela Eta Carinae emite cerca de 5 milhões de vezes mais energia que o Sol;<br>\
<b>12</b> - Todos os anos caem cerca de 150 toneladas de meteoritos e fragmentos na Terra. Trata-se de uma média de 410kg por dia;<br>\
<b>13</b> - Em 1846 foi anunciada a descoberta de uma 2ª lua em órbita da Terra. Mais recentemente, entre 1966 e 1969, foram anunciadas mais 10 luas. Todas acabaram por não se demonstrar verdadeiras;<br>\
<b>14</b> - As estrelas não cintilam. O que vemos, é a interferência da atmosfera terrestre na luz que chega até nós;<br>\
<b>15</b> - Planeta é uma palavra grega que significa viajante. Deram esse nome aos planetas pois estes se deslocavam em relação às estrelas “fixas”;<br>\
<b>16</b> - O Telescópio Espacial Hubble é capaz de fotografar os olhos de uma mosca a 13 700km de distância, teoria ainda não demonstrada devido à inexistência de moscas no espaço;<br>\
<b>17</b> - A ventania em Neptuno chega a atingir os 2 100km/h;<br>\
<b>18</b> - O impacto da alunagem da Apollo 12 fez com que a superfície lunar vibrasse durante 55 minutos;<br>\
<b>19</b> - Não conseguimos ver uma única estrela em tempo real, e a maioria vemos mesmo com milhares de anos de atraso. Até o nosso Sol demora 8 minutos e 20 segundos a chegar a nós, pelo que se explodisse, demoraríamos esses 8 minutos para nos apercebermos. E algumas estrelas que observamos no céu podem já não existir…<br>\
<b>20</b> - Já agora, 45% dos americanos desconhecem que o Sol é uma estrela;<br>\
<b>21</b> - O primeiro pé a pousar na Lua (de Neil Armstrong) calçava o número 41;<br>\
<b>22</b> - O buraco negro mais pequeno já descoberto, tem apenas 24km de diâmetro. Não te iludas: na verdade estes micro buracos negros exercem uma força de atracção muito mais forte que os grandes, ou seja, quanto mais pequenos, mais devastadores;<br>\
<b>23</b> - O teu corpo junto do buraco negro da curiosidade acima, seria transformado num simples fio de esparguete.", "voltar":"home", "imagem":"", "pagina":""}');
//######################################################################
db["personalidades_importantes"] = $.parseJSON('{"titulo":"Personalidades importantes", "descricao":"Se conhecemos tanto do universo hoje é graças a astronomos que dedicaram suas vidas a essa incrível profissão, então conheça melhor os astronomos que mudaram nosso jeito de ver o mundo.", "voltar":"home", "imagem":"", "pagina":["eratostenes","al_sufi","nicolau_copernico","galileu_galilei","carl_sagan","stephen_hawking","albert_einstein","isaac_newton"]}');
db["eratostenes"] = $.parseJSON('{"titulo":"Eratóstenes", "descricao":"Eratóstenes de Cirene foi um matemático, gramático, poeta, geógrafo, bibliotecário e astrônomo da Grécia Antiga, conhecido por calcular a circunferência da Terra. Nasceu em Cirene, Grécia, e morreu em Alexandria. Estudou em Cirene, em Atenas e em Alexandria. Os contemporâneos chamavam-no de \\"Beta\\" porque o consideravam o segundo melhor do mundo em vários aspectos.", "voltar":"personalidades_importantes", "imagem":"Portrait_of_Eratosthenes.png", "pagina":""}');
db["al_sufi"] = $.parseJSON('{"titulo":"Al Sufi", "descricao":"Abd al-Rahman al-Sufi (7 de dezembro de 903 — 25 de maio de 986) foi um astrónomo da Pérsia, também conhecido como Azophi. Escreveu o Livro das Estrelas Fixas em 964, onde fez o registo mais antigo da visão das Nuvens de Magalhães, visível do sul do Yemen. A obra permitiu à astronomia moderna fazer comparações últeis para a pesquisa das variações do brilho das estrelas.", "voltar":"personalidades_importantes", "imagem":"Al-Sufi.jpg", "pagina":""}');
db["nicolau_copernico"] = $.parseJSON('{"titulo":"Nicolau Copérnico", "descricao":"Nicolau Copérnico (Toruń, 19 de Fevereiro de 1473 — Frauenburgo, 24 de Maio de 1543) foi um astrônomo e matemático polaco que desenvolveu a teoria heliocêntrica do Sistema Solar. Foi também cónego da Igreja Católica, governador e administrador, jurista, astrólogo e médico. Sua teoria do Heliocentrismo, que colocou o Sol como o centro do Sistema Solar, contrariando a então vigente Teoria Geocêntrica (que considerava a Terra como o centro), é considerada como uma das mais importantes hipóteses científicas de todos os tempos, tendo constituído o ponto de partida da astronomia moderna.", "voltar":"personalidades_importantes", "imagem":"Nikolaus_Kopernikus.jpg", "pagina":""}');
db["galileu_galilei"] = $.parseJSON('{"titulo":"Galileu Galilei", "descricao":"Galileu Galilei (em italiano: Galileo Galilei; Pisa, 15 de fevereiro de 1564 — Florença, 8 de janeiro de 1642 ) foi um físico, matemático, astrônomo e filósofo italiano. Galileu Galilei foi personalidade fundamental na revolução científica. Foi o mais velho dos sete filhos do alaudista Vincenzo Galilei e de Giulia Ammannati. Viveu a maior parte de sua vida em Pisa e em Florença, na época integrantes do Grão-Ducado da Toscana. Galileu Galilei desenvolveu os primeiros estudos sistemáticos do movimento uniformemente acelerado e do movimento do pêndulo. Descobriu a lei dos corpos e enunciou o princípio da inércia e o conceito de referencial inercial, ideias precursoras da mecânica newtoniana. Galileu melhorou significativamente o telescópio refrator e com ele descobriu as manchas solares, as montanhas da Lua, as fases de Vénus, quatro dos satélites de Júpiter, os anéis de Saturno, as estrelas da Via Láctea. Estas descobertas contribuíram decisivamente na defesa do heliocentrismo. Contudo a principal contribuição de Galileu foi para o método científico, pois a ciência assentava numa metodologia aristotélica. O físico desenvolveu ainda vários instrumentos como a balança hidrostática, um tipo de compasso geométrico que permitia medir ângulos e áreas, o termómetro de Galileu e o precursor do relógio de pêndulo. O método empírico, defendido por Galileu, constitui um corte com o método aristotélico mais abstrato utilizado nessa época, devido a este Galileu é considerado como o \\"pai da ciência moderna\\".", "voltar":"personalidades_importantes", "imagem":"Galileo.arp.300pix.jpg", "pagina":""}');
db["carl_sagan"] = $.parseJSON('{"titulo":"Carl Sagan", "descricao":"Carl Edward Sagan (Nova Iorque, 9 de novembro de 1934 — Seattle, 20 de dezembro de 1996) foi um cientista, astrobiólogo, astrônomo, astrofísico, cosmólogo, escritor e divulgador científico norte-americano. Sagan é autor de mais de 600 publicações científicas, e também autor de mais de 20 livros de ciência e ficção científica. Foi durante a vida um grande defensor do ceticismo e do uso do método científico, promoveu a busca por inteligência extraterrestre através do projeto SETI e instituiu o envio de mensagens a bordo de sondas espaciais, destinados a informar possíveis civilizações extraterrestres sobre a existência humana. Mediante suas observações da atmosfera de Vênus, foi um dos primeiros cientistas a estudar o efeito estufa em escala planetária. Também fundou a organização não-governamental Sociedade Planetária e foi pioneiro no ramo da ciência exobiologia.", "voltar":"personalidades_importantes", "imagem":"Carl_Sagan_Planetary_Society.JPG", "pagina":""}');
db["stephen_hawking"] = $.parseJSON('{"titulo":"Stephen Hawking", "descricao":"Stephen Hawking (nascido em 1942) fez muitas descobertas significativas no campo da cosmologia. Ele propôs que, como o universo tem um começo, provavelmente também terá um fim. Hawking acredita que o mundo não tem nenhum limite ou fronteira. Apesar de ser visto como uma das mentes mais brilhantes desde Einstein, muitos dos livros de Hawking são adaptados e direcionados para o público em geral, já que ele procura educar as pessoas sobre o universo.", "voltar":"personalidades_importantes", "imagem":"112.jpg", "pagina":""}');
db["albert_einstein"] = $.parseJSON('{"titulo":"Albert Einstein", "descricao":"Albert Einstein (Ulm, 14 de março de 1879 — Princeton, 18 de abril de 1955) foi um físico teórico alemão, radicado nos Estados Unidos a partir de 1933, que desenvolveu a teoria da relatividade geral, um dos dois pilares da física moderna (ao lado da mecânica quântica). Embora mais conhecido por sua fórmula de equivalência massa-energia, E = mc^2 (que foi chamada de \\"a equação mais famosa do mundo\\"), foi laureado com o Prêmio Nobel de Física de 1921 \\"por suas contribuições à física teórica e, especialmente, por sua descoberta da lei do efeito fotoelétrico\\", que foi fundamental no estabelecimento da teoria quântica. No início de sua carreira, Einstein acreditava que a mecânica newtoniana não era mais suficiente para reconciliar as leis da mecânica clássica com as leis do campo eletromagnético. Isto o levou ao desenvolvimento da teoria da relatividade especial. Einstein percebeu, no entanto, que o princípio da relatividade também poderia ser estendido para campos gravitacionais, e com a sua posterior teoria da gravitação, de 1916, publicou um artigo sobre a teoria da relatividade geral. Continuou a lidar com problemas da mecânica estatística e teoria quântica, o que levou às suas explicações sobre a teoria das partículas e o movimento browniano. Também investigou as propriedades térmicas da luz, o que lançou as bases da teoria dos fótons da luz. Em 1917, aplicou a teoria da relatividade geral para modelar a estrutura do universo como um todo.", "voltar":"personalidades_importantes", "imagem":"Einstein_1921_by_F_Schmutzer_-_restoration.jpg", "pagina":""}');
db["isaac_newton"] = $.parseJSON('{"titulo":"Isaac Newton", "descricao":"Isaac Newton (Woolsthorpe-by-Colsterworth, 25 de dezembro de 1642 (Calendário Juliano, equivalente a 4 de Janeiro de 1643 no Calendário Gregoriano) — Londres, 31 de março de 1727) foi um cientista inglês, mais reconhecido como físico e matemático, embora tenha sido também astrônomo, alquimista, filósofo natural e teólogo. Sua obra, Philosophiae Naturalis Principia Mathematica, é considerada uma das mais influentes na história da ciência. Publicada em 1687, esta obra descreve a lei da gravitação universal e as três leis de Newton, que fundamentaram a mecânica clássica. Ao demonstrar a consistência que havia entre o sistema por si idealizado e as leis de Kepler do movimento dos planetas, foi o primeiro a demonstrar que os movimentos de objetos, tanto na Terra como em outros corpos celestes, são governados pelo mesmo conjunto de leis naturais. O poder unificador e profético de suas leis era centrado na revolução científica, no avanço do heliocentrismo e na difundida noção de que a investigação racional pode revelar o funcionamento mais intrínseco da natureza. Newton construiu o primeiro telescópio refletor operacional e desenvolveu a teoria das cores baseada na observação que um prisma decompõe a luz branca em várias cores do espectro visível. Ele também formulou uma lei empírica de resfriamento e estudou a velocidade do som.", "voltar":"personalidades_importantes", "imagem":"GodfreyKneller-IsaacNewton-1689.jpg", "pagina":""}');