//////////////////////////////////////////////////////////////////////////////
//
// TextInput
//

function TextInput(ctrl, listener) {
    var ref = this;
    this.listener = listener;
    this.ctrl = ctrl;
    this.text = this.ctrl.value;
    this.lang = "";
    this.autoComplete = false;
    this.isPasted = false;
    this.ctrl.onpaste = function() { ref.isPasted = true; return true; }
    this.pos = 0;
    this.change = null;

    if ("setSelectionRange" in this.ctrl) {
        this.ctrl.getSelectionEnd = function() { return this.selectionEnd; }
    }
    else if (document.selection) {
        this.ctrl.getSelectionEnd = TextInput.getSelectionEndIE;
        this.ctrl.setSelectionRange = TextInput.setSelectionRangeIE;
    }
    else {
        this.ctrl.getSelectionEnd = function() { return -1; }
        this.ctrl.setSelectionRange = function() {}
    }

    util.attachEvent(this.ctrl, "keyup", function(e) { ref.update() });
    util.attachEvent(this.ctrl, "onblur", function(e) { ref.onblur() });
    window.setInterval(function() { ref.update() }, 100);
}

TextInput.URL = "http://predictor.yandex.net/suggest.json";

TextInput.prototype.setValue = function(value) {
    this.ctrl.value = this.text = value;
    this.setChange(null);
}

TextInput.prototype.setLang = function(value) {
    this.lang = value;
    this.setChange(null);
}

TextInput.prototype.setAutoComplete = function(value) {
    this.autoComplete = value;
}

TextInput.prototype.update = function(reason) {
    var pos = this.ctrl.getSelectionEnd();
    if (pos >= 0)
        this.pos = pos;

    var text = this.ctrl.value;
    if (text == this.text)
        return;

    this.setChange(null);
    this.text = text;
    if (!reason && this.isPasted) {
        reason = "paste";
        this.isPasted = false;
    }
    if (!reason && this.autoComplete) {
        if (this.isComplete())
            reason = "complete";
        else
            this.check();
    }
    this.listener.onChange(reason || "");
}

TextInput.prototype.isComplete = function() {
    var text = this.ctrl.value;
    if (this.pos <= 0 || this.pos != text.length)
        return false;
    var lastChar = text.substr(text.length - 1);
    if (/\w|-/.test(lastChar) || util.isAlpha(lastChar))
        return false;
    return true;
}

TextInput.prototype.check = function() {
    var tok = this.getToken("w", this.pos);
    if (!tok.text)
        return;
    var endPos = tok.pos + tok.text.length;
    var pos = tok.pos;
    for (var i = 0; i < 2; ++i) {
        tok = this.getToken("s", pos);
        if (tok.pos <= 0)
            break;
        pos = tok.pos;
        tok = this.getToken("w", pos);
        if (!tok.text)
            break;
        pos = tok.pos;
    }

    this.complete(pos, endPos);
}

TextInput.prototype.getToken = function(type, pos) {
    var ok = (type == "w");
    var t = this.text;
    var end = pos;
    while (end < t.length && util.isAlpha(t.charAt(end)) == ok)
        ++end;
    while (pos > 0 && util.isAlpha(t.charAt(pos - 1)) == ok)
        --pos;
    return { text: t.substr(pos, end - pos), pos: pos };
}

TextInput.prototype.complete = function(pos, endPos) {
    if (!(this.lang in this.listener.advanced.suggest)) {
        return;
    }

    if (!TextInput.URL)
        return;

    var ref = this;
    var words = this.text.substr(pos, endPos - pos);
    var args = { q: words, lang: this.lang };
    var state = { text: this.text, endPos: endPos };
    var query = { args: args, url: TextInput.URL + "/complete", method: "GET",
        callback: function(result, err) { ref.onResponse(query, result, err) },
        state: state
    };
    json.sendQuery(query);
}

TextInput.prototype.onResponse = function(query, result, err) {
    if (err)
        return;
    if (query.state.text != this.ctrl.value)
        return;
    if (result.text) {
        result.endPos = query.state.endPos;
        this.setChange(result);
    }
    if (result.endOfWord)
    {
    	// it turned out that translation with 'auto' option was causing refreshing of the field ('blinking')
        // this.listener.onComplete();
        this.listener.onChange("complete");
    }
}

TextInput.prototype.onblur = function(e) {
    this.onChange("complete");
}

TextInput.prototype.setChange = function(change) {
    this.change = change;
}

TextInput.prototype.getCursorPos = function() {
    return this.pos;
}

TextInput.prototype.setCursorPos = function(pos) {
    if (pos >= 0 && pos <= this.ctrl.value.length) {
        this.ctrl.setSelectionRange(pos, pos);
        this.pos = pos;
    }
}

TextInput.getSelectionEndIE = function() {
    var sel = document.selection.createRange();
    if (!sel || sel.parentElement() != this)
        return -1;
    var r = this.createTextRange();
    var start = r.duplicate();
    r.moveToBookmark(sel.getBookmark());
    r.setEndPoint("StartToStart", start);
    return r.text.length;
}

TextInput.setSelectionRangeIE = function(start, end) {
    var r = this.createTextRange();
    r.move("character", start);
    r.select();
}
