function Tr(params, mobile) {
    var ref = this, d = document;
    this.params = params;
    this.mobile = mobile;
    this.rid = 0;
    this.url = "http://translate.yandex.net/api/v1/tr.json";
    this.DIC_URL = 'http://dictionary.yandex.net/dicservice.json';
    if ("dicUrl" in params)
        this.DIC_URL = params.dicUrl;
    this.dicOptions = (params.family ? 1 : 0) + (mobile ? 2 : 0);
    this.formTrUrl = d.forms["tr-url"];
    this.initLang = this.formTrUrl["lang"].value;
    this.langCtrl = new LangCtrl(this.formTrUrl, params);
    this.langCtrl.onChange = function() { ref.langChanged(true) }
    this.task = {};
    this.state = Tr.STATE_NEQ;
    this.trRunning = false;
    this.dictRunning = false;
    this.dictData = null;
    this.ie = navigator.userAgent.indexOf("MSIE") >= 0;
    this.loadCookies();
    this.advanced = {
        suggest: util.newSet(params.langs.pdct),
        dict: util.newSet(params.langs.dict)
    };

    this.srcText = d.getElementById("srcText");
    if (this.mobile) {
        this.input = new TextInput(this.srcText, this);
        this.input.setAutoComplete(true);
    }
    else {
        this.input = SuggestApp.init(this.srcText, this);
    }
    this.dstText = new DstText(this, 'dstTextBox');
    this.dictPanel = new DictionaryPanel();

    if (!this.mobile && window.clipboardData) {
        d.getElementById("cmdCopy").style.visibility = "visible";
        d.getElementById("cmdPaste").style.visibility = "visible";
    }
    this.srcText.onscroll = function() { ref.syncScroll(0) }
    this.dstText.output.onscroll = function() { ref.syncScroll(1) }
    this.active = { ctrl: null, time: 0 };

    if (!this.mobile) {
        var handleFocus = function(e) { ref.handleFocus(e); }
        util.attachEvent(this.srcText, 'focus', handleFocus);
        util.attachEvent(this.srcText, 'blur', handleFocus);
        util.attachEvent(this.dstText.output, 'focus', handleFocus);
        util.attachEvent(this.dstText.output, 'blur', handleFocus);
    }
    this.focus();

    d.getElementById("cmdSubmit").onclick = function() { ref.translate("submit"); ref.focus(); }
    d.getElementById("cmdClear").onclick = function() { ref.clear(); }
    if (!this.mobile) {
        d.getElementById("cmdCopy").onclick = function() { ref.copy(); }
        d.getElementById("cmdPaste").onclick = function() { ref.paste(); }
    }
    var flip = d.getElementById("flip");
    flip && (flip.onclick = function() { ref.invertDir(true); return false; })

    this.chk = [];
    if (!this.mobile)
        this.initOptions(["chkSync", "chkEnter", "chkAutoDir", "chkSuggest", "chkDict"]);

    this.input.setLang(this.langCtrl.getSrcLang());
    this.handleAdvancedOptions();
    this.onChange("init");
}

Tr.STATE_NEQ = 0;
Tr.STATE_EQ = 1;
Tr.STATE_TR = 2;
Tr.MAX_TEXT_LEN = 10000;
Tr.MAX_DICT_WORDS_COUNT = 3;
Tr.BLOCK_LEN = navigator.userAgent.indexOf("MSIE") >= 0 ? 300 : 600;
Tr.SYNC_LEN = 1000;
Tr.DOMAINS = util.newSet((
  ",ac,ad,ae,aero,af,ag,ai,al,am,an,ao,aq,ar,arpa,as,asia,at,au,aw,ax,az,"
+ "ba,bb,bd,be,bf,bg,bh,bi,biz,bj,bm,bn,bo,br,bs,bt,bv,bw,by,bz,"
+ "ca,cat,cc,cd,cf,cg,ch,ci,ck,cl,cm,cn,co,com,coop,cr,cu,cv,cx,cy,cz,"
+ "de,dj,dk,dm,do,dz,ec,edu,ee,eg,er,es,et,eu,fi,fj,fk,fm,fo,fr,"
+ "ga,gb,gd,ge,gf,gg,gh,gi,gl,gm,gn,gov,gp,gq,gr,gs,gt,gu,gw,gy,"
+ "hk,hm,hn,hr,ht,hu,id,ie,il,im,in,info,int,io,iq,ir,is,it,je,jm,jo,jobs,jp,"
+ "ke,kg,kh,ki,km,kn,kp,kr,kw,ky,kz,la,lb,lc,li,lk,lr,ls,lt,lu,lv,ly,"
+ "ma,mc,md,me,mg,mh,mil,mk,ml,mm,mn,mo,mobi,mp,mq,mr,ms,mt,mu,museum,mv,mw,mx,my,mz,"
+ "na,name,nc,ne,net,nf,ng,ni,nl,no,np,nr,nu,nz,om,org,"
+ "pa,pe,pf,pg,ph,pk,pl,pm,pn,pr,pro,ps,pt,pw,py,qa,re,ro,rs,ru,rw,"
+ "sa,sb,sc,sd,se,sg,sh,si,sj,sk,sl,sm,sn,so,sr,st,su,sv,sy,sz,"
+ "tc,td,tel,tf,tg,th,tj,tk,tl,tm,tn,to,tp,tr,travel,tt,tv,tw,tz,"
+ "ua,ug,uk,us,uy,uz,va,vc,ve,vg,vi,vn,vu,wf,ws,xn--p1ai,ye,yt,za,zm,zw").split(","));
Tr.reUrl = /^(http:\/\/)?((?:\w+(?:\-*\w)*\.)+(\w+\-*\w+)|([\u0410-\u044f]+\.)+рф|(\d{1,3}\.){3}\d{1,3})([\/?].*)?$/i;
Tr.OPT_SYNC     = 0x01;
Tr.OPT_ENTER    = 0x02;
Tr.OPT_DIR      = 0x04;
Tr.OPT_SUGGEST  = 0x08;
Tr.OPT_DICT     = 0x10;
Tr.OPT_DEFS     = 0x1F;
Tr.OPT_COUNT    = 5;

Tr.isUrl = function(s) {
    return !/\s/.test(s) && Tr.reUrl.test(s) && (RegExp.$3.toLowerCase() in Tr.DOMAINS);
}

Tr.parseDirs = function(s) {
    var dirs = {};
    var arr = s.split(",");
    for (var i = 0; i < arr.length; ++i) {
        var dir = arr[i].split("-");
        dirs[dir[0] + "-" + dir[1]] = 1;
        dirs[dir[1] + "-" + dir[0]] = 1;
    }
    return dirs;
}

Tr.prototype.clearResult = function() {
    this.dstText.setValue('');
    this.dictPanel.hide();
    this.task = {};
}

Tr.prototype.setUrl = function(url) {
    this.dstText.setUrl(url);
    this.dictPanel.hide();
    this.task = {};
}

Tr.prototype.setState = function(newState) {
    if (this.state == newState)
        return;

    this.state = newState;

    this.onStateChanged && this.onStateChanged(newState);
}

Tr.prototype.clear = function() {
    this.input.setValue("");
    this.clearResult();
    this.focus();
}

Tr.prototype.copy = function() {
    window.clipboardData.setData("text", this.dstText.getValue());
    this.focus();
}

Tr.prototype.paste = function() {
    this.clearResult();
    this.oldText = "";
    var value = (window.clipboardData.getData("text") || "");
    if (value) {
        this.input.setValue(value);
        this.onChange("paste");
    }
    this.focus();
}

Tr.prototype.invertDir = function(autoTranslate) {
    this.langCtrl.invertDir();
    this.langChanged(autoTranslate);
}

Tr.prototype.translate = function(reason) {
    var text = util.trim(this.srcText.value);
    var lang = this.langCtrl.getValue();
    if (!text) {
        this.clearResult();
        return;
    }
    var dstText = this.dstText;
    if (reason == "sync") {
        dstText = new TextBuf();

        if (text.length > Tr.SYNC_LEN)
            return;
        if (text == this.task.text && lang == this.task.lang)
            return;
    }
    else {
        this.clearResult();
        if (Tr.isUrl(text)) {
            this.formTrUrl.url.value = text;
            this.formTrUrl.dir.value = (this.isOn(Tr.OPT_DIR) ? "auto" : "");
            this.formTrUrl.submit();
            return;
        }
    }
    if (text.length > Tr.MAX_TEXT_LEN) {
        var msg = this.getStr("textTooLong").replace("{0}", Tr.MAX_TEXT_LEN);
        alert(msg);
        text = this.truncateText(text, Tr.MAX_TEXT_LEN);
    }
    var chunks = [text];
    if (text.length > Tr.BLOCK_LEN)
        chunks = Breaker.breakText(text, Tr.BLOCK_LEN);
    var tid = this.params.sid + "-" + (this.rid++);
    this.task = { text: text, lang: lang
      , reason: reason, chunks: chunks, index: 0, id: tid, dstText: dstText };
    this.setState(Tr.STATE_TR);
    this.translateNext();
}

Tr.prototype.truncateText = function(text, maxLen) {
    if (text.length <= maxLen)
        return '';

    var sep = " \t\r\n";
    var len = maxLen;
    for (; len > 0; --len) {
        var ch = text.charAt(len - 1);
        if (sep.indexOf(ch) >= 0)
            break;
    }
    return text.substr(0, len).replace(/\s+$/g, "");
}

Tr.prototype.translateNext = function() {
    var task = this.task;
    while (task.index < task.chunks.length) {
        var text = task.chunks[task.index++];
        if (text.length > Tr.BLOCK_LEN) {
            this.dstText.setValue(this.dstText.getValue() + text);
            continue;
        }
        this.sendQuery(text);
        return;
    }

    if (task.dstText != this.dstText) {
        this.dstText.setValue(task.dstText.getValue());
    }

    var state = (util.trim(this.srcText.value) == task.text ? Tr.STATE_EQ : Tr.STATE_NEQ);
    this.syncScroll(0);
    this.setState(state);
}

Tr.prototype.sendQuery = function(text) {
    var uiLang = document.documentElement.lang;
    var ref = this;
    var task = this.task;
    var args = { lang: task.lang, text: text, srv: "tr-text"
      , id: task.id + "-" + (task.index - 1), reason: task.reason };
    var query = { args: args, url: this.url + "/translate", method: "GET", task: task
      , callback: function(result, error) { ref.onResponse(query, result, error) } };

    this.dictData = null;

    if (this.canShowDict()) {
        text = util.trim(text).replace(/\s+/g, ' ');

        if (text && !/[\n\r]/.test(text) && text.split(' ').length <= Tr.MAX_DICT_WORDS_COUNT) {
            this.dictRunning = true;
            json.sendQuery({
                args: {
                    ui: uiLang,
                    lang: task.lang,
                    text: text,
                    flags: this.dicOptions
                },
                url: this.DIC_URL + "/lookup",
                callback: function (result, error) {
                    ref.onDictResponse(query, result, error);
                }
            });
        }
    }

    this.trRunning = true;
    json.sendQuery(query);
};

Tr.prototype.handleTranslationResponse = function () {
    if (this.dictRunning || this.trRunning) {
        return;
    }

    if (this.dictData == null) {
        this.dictPanel.hide();
    }
    else {
        this.dictPanel.show(this.dictData);
    }
};

Tr.prototype.onDictResponse = function (query, result, err) {
    if (err)
        return;

    this.dictRunning    = false;
    this.dictData       = result;
    this.dictData.query = query.args;
    this.handleTranslationResponse();
};

Tr.prototype.onResponse = function(query, result, err) {
    if (query.task != this.task)
        return;

    var isSync = (this.task.reason == "sync");
    if (err) {
        var msg = err.message;
        if (err.type == "TimeoutError")
            msg = this.getStr("timeoutError");
        if (!isSync) {
            this.setState(Tr.STATE_NEQ);
            alert(msg);
        }
        return;
    }

    this.trRunning = false;
    this.handleTranslationResponse();
    this.task.dstText.setValue(this.task.dstText.getValue() + result.text[0]);
    this.translateNext();
}

Tr.prototype.onChange = function(reason) {
    var s = util.trim(this.srcText.value);
    if (!s) {
        this.clearResult();
        this.setState(Tr.STATE_EQ);
        return;
    }
    if (this.state != Tr.STATE_TR)
        this.setState(Tr.STATE_NEQ);
    if (this.isOn(Tr.OPT_DIR))
        this.updateLang();
    var auto = "";
    if (reason == "paste" || reason == "init")
        auto = reason;
    else if (reason == "complete")
        auto = "sync";
    if (Tr.isUrl(s)) {
        this.setUrl(s);
        this.setState(Tr.STATE_EQ);
        return;
    }
    if (auto)
        this.translate(auto);
}

Tr.prototype.onEnter = function() {
    this.translate("enter");
}

Tr.prototype.onComplete = function() {
    var s = util.trim(this.srcText.value);
    if (!Tr.isUrl(s))
        this.translate("auto");
}

Tr.prototype.langChanged = function(autoTranslate) {
    this.saveCookies();
    this.focus();

    var srcLang = this.langCtrl.getSrcLang();
    if (!this.mobile)
        VirtualKeyboard.setLanguage(srcLang);
    this.input.setLang(srcLang);
    this.handleAdvancedOptions();

    var s = util.trim(this.srcText.value);
    if (autoTranslate && !Tr.isUrl(s))
        this.translate("lang");
}

Tr.prototype.updateLang = function() {
    var lang = this.langCtrl.getValue().split("-");
    if (lang.length != 2)
        return;
    var invLang = lang[1] + "-" + lang[0];
    if (!this.isLangSupported(invLang))
        return;
    var mainLang = Abc.check(this.srcText.value, lang);
    if (mainLang == lang[1])
        this.invertDir(false);
}

Tr.prototype.isLangSupported = function(lang) {
    return this.langCtrl.checkDir(lang);
}

Tr.prototype.getStr = function(id) {
    var span = document.getElementById(id);
    if (!span)
        return "";
    return span.firstChild.nodeValue;
}

Tr.prototype.syncScroll = function(index) {
    if (index == 1 && this.active.ctrl == this.srcText)
        return; // MT-559
    var now = util.time();
    var from = index ? this.dstText.output : this.srcText;
    var to = index ? this.srcText : this.dstText.output;
    if (to != this.active.ctrl || now >= this.active.time + 200) {
        to.scrollTop = from.scrollTop;
        this.active.ctrl = from;
        this.active.time = now;
    }
}

Tr.prototype.handleFocus = function(evt) {
    var focused = (evt.type == 'focus'), target = evt.target;
    if (focused)
        this.active.ctrl = target;

    // search for decorator
    do {
        target = target.parentNode;
    }
    while (target.className.indexOf('yt-flex-box') == -1)

    target.className = target.className.replace(/(-focused-)(true|false)/, '$1' + focused);
};

Tr.prototype.loadCookies = function() {
    var cookies = util.getCookies("tr2");
    this.options = Tr.OPT_DEFS;
    if (!this.initLang)
        this.langCtrl.setValue(cookies["l"] || "");

    var o = cookies["o"] || "";
    if (o.indexOf("/") > 0) {
        var f = o.split("/");
        var mask = (1 << parseInt(f[1])) - 1;
        this.options = (Tr.OPT_DEFS & ~mask) | parseInt(f[0]);
    }
}

Tr.prototype.saveCookies = function() {
    var cookies = { l: this.langCtrl.getValue() };
    if (this.options != Tr.OPT_DEFS)
        cookies["o"] = this.options + "/" + Tr.OPT_COUNT;
    util.setCookies("tr2", cookies);
}

Tr.prototype.isOn = function(option) {
    return (this.options & option) != 0;
}

Tr.prototype.initOptions = function(opts) {
    var
        opt,
        ref = this,
        i   = 0;

    for (; i < opts.length; i++) {
        this.chk[i] = opt = document.getElementById(opts[i]);

        opt.onclick = function() { ref.optionChanged(this); };
        opt.checked = (this.options & (1 << i)) != 0;
    }

    this.input.setAutoComplete(this.isOn(Tr.OPT_SYNC));
}

Tr.prototype.optionChanged = function(target) {
    this.options = 0;
    for (var i = 0; i < this.chk.length; ++i) {
        if (this.chk[i].checked)
            this.options |= 1 << i;
    }

    if (target.id == 'chkDict') {
        if (this.canShowDict()) {
            this.translate('enter');
        }
        else {
            this.dictPanel.hide();
        }
    }

    this.input.setAutoComplete(this.isOn(Tr.OPT_SYNC));
    this.saveCookies();
    this.focus();
}

Tr.prototype.focus = function() {
    if (this.mobile)
        return;
    if (this.ie) {
        var pos = this.input.getCursorPos();
        this.input.setCursorPos(pos);
    }
    this.srcText.focus();
};

Tr.prototype.hasAdvancedOptions = function (type) {
    var lang = this.langCtrl.getValue();
    if (type == "suggest")
        return lang.split('-')[0] in this.advanced.suggest;
    return lang in this.advanced[type];
};

Tr.prototype.handleAdvancedOptions = function () {
    if (this.mobile)
        return;
    document.getElementById('ctrlSuggest').style.display = this.hasAdvancedOptions('suggest') ? 'block' : 'none';
    document.getElementById('ctrlDict').style.display = this.hasAdvancedOptions('dict') ? 'block' : 'none';
};

Tr.prototype.canApplyEnter = function(e) {
    var shift = e.shiftKey || e.altKey || e.ctrlKey;
    return this.isOn(Tr.OPT_ENTER) ? shift : true;
};

Tr.prototype.canSyncTranslate = function () {
    return this.isOn(Tr.OPT_SYNC);
};

Tr.prototype.canAutoComplete = function () {
    return this.hasAdvancedOptions('suggest') && this.isOn(Tr.OPT_SYNC);
};

Tr.prototype.canSuggest = function () {
    return this.hasAdvancedOptions('suggest') && this.isOn(Tr.OPT_SUGGEST);
};

Tr.prototype.canShowDict = function () {
    return this.hasAdvancedOptions('dict') && this.isOn(Tr.OPT_DICT);
};

Tr.setCtrlAHandler = function(node) {
    util.attachEvent(node, 'keydown', function (e) {
        if ((e.ctrlKey || e.metaKey) && e.keyCode == 65) {
            if (window.getSelection) {
                var range = document.createRange();
                range.selectNode(node);
                window.getSelection().addRange(range);
            }
            else if (document.selection) {
                var range = document.body.createTextRange();
                range.moveToElementText(node);
                range.select();
            }
            else {
                return;
            }
            util.cancelEvent(e);
            node.focus();
        }
    });
}

function TextBuf() {
    this.value = '';
}

TextBuf.prototype = {
    getValue: function() { return this.value; },
    setValue: function(value) { this.value = value; }
};

/**
 * @class   Wrapper for output text box and dummy object
 *          for destination text of translation task.
 */
function DstText(ref, outputId) {
    this.ref    = ref;
    this.value  = '';
    this.panel  = document.getElementById("trPanel");
    this.output = document.getElementById(outputId);
    Tr.setCtrlAHandler(this.output);
}

DstText.prototype = {
    getValue: function () {
        return this.value;
    },
    setValue: function (value) {
        this.value  = value;
        this.output.innerHTML = util.htmlEncode(value).replace(/\n/g, '<br/>');
        this.show(value != "");
    },
    setUrl: function (url) {
        var ref = this.ref;
        this.value = url;
        this.output.innerHTML = '';
        var a = util.createElement("A", { href: "#" });
        a.appendChild(document.createTextNode(url));
        util.attachEvent(a, "click", function(e) { ref.translate("url"); util.cancelEvent(e); });
        this.output.appendChild(a);
        this.show(true);
    },
    show: function (value) {
        this.panel && (this.panel.style.display = value ? "block" : "none");
    }
};

/**
 * Set of dictionary panel routine
 */
function DictionaryPanel() {
    this.box = document.getElementById('dictPanel');
    Tr.setCtrlAHandler(this.box);
    this.refLingvo = document.getElementById("refLingvo");
    this.hidden = false;
}

DictionaryPanel.prototype = {
    /**
     * Determines whether panel is hidden
     */
    isHidden: function () {
        return this.hidden;
    },

    /**
     * Shows dictionary for currently input term
     *
     * @param {Object} data dictionary data to be displayed
     */
    show: function (data) {
        if (data.def.length == 0) {
            this.setHidden(true);
            return;
        }

        var panel   = document.getElementById('dictArticles'),
            defs    = data.def,
            buff    = [];

        buff.push('<div class="yt-dict-title">' + util.htmlEncode(defs[0].text) + '</div>');

        // Parts of speech
        for (var i = 0; i < defs.length; i++) {
            var trs = defs[i].tr;

            buff.push('<div class="yt-dict-article">');
            if (defs[i].pos) {
                buff.push('<div class="yt-dict-article-header">');
                buff.push('<span class="yt-dict-pos">/' + util.htmlEncode(defs[i].pos) + '/</span></div>');
            }
            var className = "yt-dict-meanings";
            if (trs.length >= 10)
                className += " yt-dict-meanings-long";
            if (trs.length <= 1)
                className += " yt-dict-1-meaning";
            buff.push('<ol class="' + className + '" yt-normal-list="">');

            // Meanings
            for (var j = 0; j < trs.length; j++) {
                buff.push('<li>' + util.htmlEncode(trs[j].text));

                // synonyms if exist
                var syns = trs[j].syn;

                if (syns && syns.length) {
                    for (var k = 0; k < syns.length; k++) {
                        buff.push(', ' + util.htmlEncode(syns[k].text));
                    }
                }

                // meanings if exist
                var means = trs[j].mean;

                if (means && means.length) {
                    var advBuff = [];

                    for (var k = 0; k < means.length; k++) {
                        advBuff.push(util.htmlEncode(means[k].text));
                    }

                    buff.push('<div class="yt-dict-article-adv-meanings">');
                    buff.push('(' + advBuff.join(', ') + ')');
                    buff.push('</div>');
                }

                // examples if exist
                var exams = trs[j].ex;

                if (exams && exams.length) {
                    for (var k = 0; k < exams.length; k++) {
                        var examTr     = exams[k].tr;
                        var advBuff    = [];

                        // example translations
                        for (var m = 0; m < examTr.length; m++) {
                            advBuff.push(util.htmlEncode(examTr[m].text));
                        }

                        buff.push('<div class="yt-dict-article-example">');
                        buff.push('<span class="yt-dict-article-ex-item">' + util.htmlEncode(exams[k].text) + '</span>');
                        buff.push(advBuff.length > 0 ? ' &mdash; ' + advBuff.join(', ') : '');
                        buff.push('</div>');
                    }
                }

                buff.push('</li>');
            }

            buff.push('</ol>');
            buff.push('</div>');
        }

        panel.innerHTML = buff.join('');

        if (this.refLingvo) {
            var link = data.link ? data.link[0] : null;
            if (link)
                this.refLingvo.setAttribute("href", link.href);
            this.refLingvo.style.display = (link ? "inline" : "none");
        }

        this.setHidden(false);
    },

    /**
     * Hides panel
     */
    hide: function () {
        if (this.hidden) {
            return;
        }

        this.setHidden(true);
    },

    /**
     * Toggles hidden state of dictionary panel
     *
     * @param {Boolean} hidden new state of panel visibility
     */
    setHidden: function (hidden) {
        this.hidden = hidden;
        this.box.className = this.box.className.replace(/(-hidden-)(true|false)/, '$1' + hidden);
        this.box.scrollTop = this.box.scrollLeft = 0;
    }
};

var htmlFix = {
    resizeTAreas: function (){
        var MIN_WINDOW_HEIGHT = 400;
        var OCCUPIED_HEIGHT = 295;
        var winHeight = $(window).height();
        if (winHeight > MIN_WINDOW_HEIGHT){
            $('.yt-flex-box').height(winHeight - OCCUPIED_HEIGHT);
        } else {
            $('.yt-flex-box').height(MIN_WINDOW_HEIGHT - OCCUPIED_HEIGHT);
        }
    }
};
