// Generated by CoffeeScript 1.7.1
(function() {
  require.config({
    baseUrl: typeof APP_BASE_URL === 'undefined' ? './app' : APP_BASE_URL,
    paths: {
      text: '../vendor/require/text',
      underscore: '../vendor/underscore/underscore',
      backbone: '../vendor/backbone/backbone',
      epoxy: '../vendor/backbone/epoxy',
      indexeddb: '../vendor/backbone/indexeddb',
      localstorage: '../vendor/backbone/localstorage',
      i18n: '../vendor/i18next/i18next',
      zepto: '../vendor/zepto/zepto',
      moment: '../vendor/moment/moment'
    },
    map: {
      '*': {
        jquery: 'zepto'
      }
    }
  });

  define(['underscore', 'zepto', 'i18n', 'backbone', 'config/i18n', 'views/main', 'config/router', 'widgets/layer_manager', 'widgets/status', 'text!templates/main/index.html', 'components/logger', 'components/view', 'epoxy', 'components/cache'], function(_, $, i18n, Backbone, conf_i18n, main, router, LayerManager, Status, main_template_raw, Logger, View, epoxy, Cache) {
    var App;
    App = (function() {
      function App() {
        this.layers = new LayerManager($('#app-layer-container'));
        this.status = new Status($('#app-status'));
        this.events = _.extend({}, Backbone.Events);
        this.router = router;
        this.cache = new Cache();
        _.delay((function() {
          return require(['services/movement'], function(movementService) {
            return movementService.processAllInfinite();
          });
        }), 500);
        i18n.init(conf_i18n, (function(_this) {
          return function() {
            return router.start();
          };
        })(this));
      }

      return App;

    })();
    return new App();
  });

}).call(this);