// Generated by CoffeeScript 1.7.1
(function() {
  define(['backbone'], function(Backbone) {
    var Cache;
    return Cache = (function() {
      function Cache() {
        this.events = _.extend({}, Backbone.Events);
        this.data = {};
        this.pendings = [];
        this.events.on('set', (function(_this) {
          return function(name, value) {
            var idx;
            idx = _this.pendings.indexOf(name);
            if (idx >= 0) {
              return _this.pendings.splice(idx, 1);
            }
          };
        })(this));
      }

      Cache.prototype.insertPending = function(name) {
        return this.pendings.push(name);
      };

      Cache.prototype.isPending = function(name) {
        return this.pendings.indexOf(name) >= 0;
      };

      Cache.prototype.get = function(name, callback) {
        if (callback == null) {
          callback = null;
        }
        this.events.trigger('get', name, callback);
        if (this.has(name)) {
          if (callback) {
            return callback(this.data[name]);
          } else {
            return this.data[name];
          }
        } else {
          if (callback) {
            if (this.isPending(name)) {
              return this.events.on("set:" + name, function(value) {
                return callback(value);
              });
            } else {
              return callback(void 0);
            }
          }
        }
      };

      Cache.prototype.set = function(name, value, expiry_time) {
        if (expiry_time == null) {
          expiry_time = 5000;
        }
        this.data[name] = value;
        this.events.trigger("set:" + name, value, expiry_time);
        this.events.trigger('set', name, value, expiry_time);
        return setTimeout((function(_this) {
          return function() {
            return delete _this.data[name];
          };
        })(this), expiry_time);
      };

      Cache.prototype.has = function(name) {
        if (name in this.data) {
          return true;
        } else {
          return false;
        }
      };

      return Cache;

    })();
  });

}).call(this);