// Generated by CoffeeScript 1.7.1
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  define(['zepto', 'underscore', 'backbone'], function($, _, Backbone) {
    var Router, router;
    Router = (function(_super) {
      __extends(Router, _super);

      function Router() {
        return Router.__super__.constructor.apply(this, arguments);
      }

      Router.prototype.routes = {
        'index': 'expense',
        'income': 'income',
        'expense': 'expense',
        'graph': 'graph',
        'drawer': 'drawer',
        'configuration': 'configuration',
        'insert/:type': 'insert',
        'parcel/update/:id': 'parcel_update',
        '*actions': 'expense'
      };

      Router.prototype.start = function() {
        $(window).on('hashchange', (function(_this) {
          return function() {
            return _this.navigate(window.location.hash, {
              trigger: true
            });
          };
        })(this));
        return this.startHistory();
      };

      Router.prototype.startHistory = function() {
        return Backbone.history.start({
          pushState: false,
          root: 'expense'
        });
      };

      Router.prototype.back = function() {
        if (window.history.length > 1) {
          return window.history.go(-1);
        } else {
          return this.navigate('index', {
            trigger: true
          });
        }
      };

      return Router;

    })(Backbone.Router);
    router = new Router;
    router.on('route:income', function() {
      return require(['views/parcel/index'], function(IndexView) {
        return IndexView.instance('income').render();
      });
    });
    router.on('route:expense', function() {
      return require(['views/parcel/index'], function(IndexView) {
        return IndexView.instance('expense').render();
      });
    });
    router.on('route:graph', function() {
      return require(['views/graph/index'], function(graphView) {
        return graphView.render();
      });
    });
    router.on('route:insert', function(type) {
      return require(['views/movement/insert'], function(insertView) {
        return insertView.render(type);
      });
    });
    router.on('route:parcel_update', function(id) {
      return require(['views/parcel/update'], function(updateView) {
        return updateView.render(id);
      });
    });
    router.on('route:configuration', function(type) {
      return require(['views/configuration/index'], function(configurationView) {
        return configurationView.render();
      });
    });
    return router;
  });

}).call(this);