// Generated by CoffeeScript 1.7.1
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  define(['components/model', 'services/date', 'services/currency', 'collections/parcel'], function(Model, dateService, currencyService, ParcelCollection) {
    var Movement;
    Movement = (function(_super) {
      __extends(Movement, _super);

      function Movement() {
        return Movement.__super__.constructor.apply(this, arguments);
      }

      Movement.prototype.database = require('config/database');

      Movement.prototype.storeName = 'movements';

      Movement.prototype.defaults = {
        id: '',
        movement_type: 'expense',
        parcel_count: '',
        repeated: 0,
        cycle_type: 'month',
        cycle_interval: '1',
        expiration_day: '',
        create_date: '',
        update_date: '',
        status: '1',
        start_date: dateService.format('YYYY-MM-DD'),
        value: '',
        description: ''
      };

      Movement.prototype.computeds = {
        repeated_display: function() {
          if (this.get('repeated')) {
            return '';
          } else {
            return 'none';
          }
        },
        is_monthly: {
          deps: ['cycle_type'],
          get: function() {
            return this.get('cycle_type') === 'month';
          }
        },
        repeated_boolean: {
          deps: ['repeated'],
          get: function() {
            return !!this.get('repeated');
          },
          set: function(value) {
            if (value) {
              return {
                repeated: 1
              };
            } else {
              return {
                repeated: 0
              };
            }
          }
        },
        is_infinite: function() {
          var parcel_count, repeated;
          repeated = Number(this.get('repeated'));
          parcel_count = Number(this.get('parcel_count'));
          return repeated && (parcel_count === 0 || isNaN(parcel_count));
        }
      };

      Movement.prototype.fetchParcels = function(params2) {
        var k, params;
        if (!this.parcelCollection) {
          this.parcelCollection = new ParcelCollection;
        }
        params = {
          conditions: {
            'movement_id': this.get('id')
          }
        };
        for (k in params2) {
          if (typeof params[k] === 'undefined') {
            params[k] = params2[k];
          }
        }
        return this.parcelCollection.fetch(params);
      };

      Movement.prototype.getParcelCollection = function() {
        if (this.parcelCollection) {
          return this.parcelCollection;
        }
        throw new Error('You need to fetchParcels');
      };

      Movement.prototype.validate = function(attrs) {
        var errors, i18n, start_date_obj;
        i18n = require('i18n');
        errors = {};
        if (!attrs.description) {
          errors.description = i18n.t('validate.description_required');
        }
        if (!attrs.value || !Number(attrs.value)) {
          errors.value = i18n.t('validate.value_is_required');
        }
        if (attrs.cycle_type && (attrs.cycle_type !== 'day' && attrs.cycle_type !== 'week' && attrs.cycle_type !== 'month')) {
          errors.value = i18n.t('validate.invalid_type_of_repeat_cycle');
        }
        if (attrs.repeated || attrs.parcel_count > 1) {
          if (!attrs.expiration_day && attrs.cycle_type === 'month') {
            errors.value = i18n.t('validate.expiration_day_is_required');
          }
          if (!attrs.cycle_interval) {
            errors.value = i18n.t('validate.repetition_interval_is_required');
          }
        }
        if (attrs.start_date) {
          start_date_obj = dateService.createFromFormat('YYYY-MM-DD', attrs.start_date);
          if (!start_date_obj) {
            errors.start_date = i18n.t('validate.invalid_start_date');
          }
        }
        if (!_.isEmpty(errors)) {
          return errors;
        }
      };

      return Movement;

    })(Model);
    return Movement;
  });

}).call(this);