// Generated by CoffeeScript 1.7.1
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  define(['components/model', 'services/date', 'services/currency'], function(Model, dateService, currencyService) {
    var Parcel;
    Parcel = (function(_super) {
      __extends(Parcel, _super);

      function Parcel() {
        return Parcel.__super__.constructor.apply(this, arguments);
      }

      Parcel.prototype.database = require('config/database');

      Parcel.prototype.storeName = 'parcels';

      Parcel.prototype.defaults = {
        id: '',
        movement_id: '',
        movement_type: '',
        description: '',
        parcel_number: '',
        value: '',
        date: '',
        paid: false,
        status: '1',
        create_date: '',
        update_date: ''
      };

      Parcel.prototype.computeds = {
        color: function() {
          if (this.get('paid')) {
            return '#666666';
          }
          if (this.get('movement_type') === 'income') {
            return '#2EB944';
          } else {
            return '#E22A00';
          }
        },
        date_obj: {
          get: function() {
            return dateService.createFromFormat('YYYY-MM-DD', this.get('date'));
          },
          set: function(value) {
            return {
              date: dateService.format('YYYY-MM-DD', value)
            };
          }
        },
        date_formatted: function() {
          return dateService.format('LL', this.get('date_obj'));
        },
        value_formatted: function() {
          return currencyService.format(this.get('value'));
        },
        route_update: function() {
          return "#parcel/update/" + (this.get('id'));
        }
      };

      Parcel.prototype.fetchMovement = function(callbacks) {
        var cache, key;
        cache = require('app').cache;
        key = "movement_model_" + (this.get('movement_id'));
        if (cache.has(key) || cache.isPending(key)) {
          cache.get(key, function(value) {
            return callbacks.success(value);
          });
          return true;
        }
        cache.insertPending(key);
        return require(['models/movement'], (function(_this) {
          return function(Movement) {
            var movement;
            movement = new Movement({
              id: _this.get('movement_id')
            });
            return movement.fetch({
              success: function(model) {
                cache.set(key, model);
                return callbacks.success.apply(this, arguments);
              },
              error: function() {
                return callbacks.error.apply(this, arguments);
              }
            });
          };
        })(this));
      };

      Parcel.prototype.validate = function(attrs) {
        var date_obj, errors, i18n;
        i18n = require('i18n');
        errors = {};
        if (!attrs.description) {
          errors.description = i18n.t('validate.description_required');
        }
        if (!attrs.value || !Number(attrs.value)) {
          errors.value = i18n.t('validate.value_is_required');
        }
        if (!attrs.date) {
          errors.description = i18n.t('validate.date_required');
        } else {
          date_obj = dateService.createFromFormat('YYYY-MM-DD', attrs.date);
          if (!date_obj) {
            errors.start_date = i18n.t('validate.invalid_date');
          }
        }
        if (!_.isEmpty(errors)) {
          return errors;
        }
      };

      return Parcel;

    })(Model);
    return Parcel;
  });

}).call(this);