// Generated by CoffeeScript 1.7.1
(function() {
  define(['services/configuration'], function(configurationService) {
    var CurrencyService;
    CurrencyService = (function() {
      function CurrencyService() {}

      CurrencyService.prototype.getPreffix = function() {
        return configurationService.getCurrency();
      };

      CurrencyService.prototype.getComma = function() {
        return configurationService.getDecimalSeparator();
      };

      CurrencyService.prototype.getThousands = function() {
        return configurationService.getThousandsSeparator();
      };

      CurrencyService.prototype.formatThousands = function(number, separator) {
        var result;
        separator = separator || this.getThousands();
        number = String(number);
        result = number.split('').reverse().join('').replace(/([0-9]{3})/g, '$1' + separator);
        result = result.replace(new RegExp('\\' + separator + '$'), '').split('').reverse().join('');
        return result;
      };

      CurrencyService.prototype.format = function(value) {
        var aux, number_result;
        number_result = Number(value).toFixed(2).replace('.', this.getComma());
        aux = number_result.split(this.getComma());
        aux[0] = this.formatThousands(aux[0]);
        number_result = aux.join(this.getComma());
        return this.getPreffix() + " " + number_result;
      };

      return CurrencyService;

    })();
    return new CurrencyService;
  });

}).call(this);