// Generated by CoffeeScript 1.7.1
(function() {
  define(['moment', 'i18n'], function(moment, i18n) {
    var DateService;
    DateService = (function() {
      function DateService() {}

      DateService.prototype.createFromFormat = function(format, str) {
        return moment(str, format).toDate();
      };

      DateService.prototype.format = function(format, date) {
        if (!date) {
          date = new Date();
        }
        moment.lang(i18n.lng());
        return moment(date).format(format);
      };

      DateService.prototype.addMonth = function(dateObj, months) {
        var actualDay, bestDay;
        if (months == null) {
          months = 1;
        }
        months = Number(months);
        actualDay = this.getDay(dateObj);
        dateObj.setDate(1);
        dateObj.setMonth(dateObj.getMonth() + months);
        bestDay = Math.min(actualDay, this.getLastDay(dateObj));
        dateObj.setDate(bestDay);
        return dateObj;
      };

      DateService.prototype.addDay = function(dateObj, days) {
        if (days == null) {
          days = 1;
        }
        days = Number(days);
        dateObj.setDate(dateObj.getDate() + days);
        return dateObj;
      };

      DateService.prototype.setDay = function(dateObj, day) {
        var bestDay;
        day = Number(day);
        bestDay = Math.min(day, this.getLastDay(dateObj));
        return dateObj.setDate(bestDay);
      };

      DateService.prototype.getDay = function(dateObj) {
        return dateObj.getDate();
      };

      DateService.prototype.getLastDay = function(dateObj) {
        var d;
        d = new Date(dateObj.getYear(), dateObj.getMonth() + 1, 0);
        return d.getDate();
      };

      return DateService;

    })();
    return new DateService;
  });

}).call(this);