// Generated by CoffeeScript 1.7.1
(function() {
  define(['backbone', 'underscore', 'collections/movement', 'collections/parcel', 'models/parcel', 'services/date'], function(Backbone, _, MovementCollection, parcelCollection, Parcel, dateService) {
    var MONTHS_PRE_REGISTER, MovementService, logger;
    MONTHS_PRE_REGISTER = 6;
    logger = require('components/logger');
    MovementService = (function() {
      function MovementService() {}

      MovementService.prototype.createMovement = function(movement, callbacks) {
        if (callbacks == null) {
          callbacks = {};
        }
        return movement.save(movement.toJSON(), {
          success: (function(_this) {
            return function() {
              var currentDate, i, isInfinite, parcelCount, parcelError, parcelSuccess, _fn, _i, _results;
              currentDate = dateService.createFromFormat('YYYY-MM-DD', movement.get('start_date'));
              isInfinite = movement.get('is_infinite');
              if (isInfinite) {
                parcelCount = MONTHS_PRE_REGISTER;
              } else {
                parcelCount = Number(movement.get('parcel_count')) ? Number(movement.get('parcel_count')) : 1;
              }
              parcelSuccess = null;
              parcelError = null;
              if (callbacks.success) {
                parcelSuccess = _.after(parcelCount, callbacks.success);
              }
              if (callbacks.errors) {
                parcelError = _.after(parcelCount, callbacks.errors);
              }
              _fn = function(currentDate, i) {
                return _this.createParcelFromMovement(movement, {
                  'parcel_number': i,
                  'date': dateService.format('YYYY-MM-DD', currentDate)
                }, {
                  success: function() {
                    if (parcelSuccess) {
                      return parcelSuccess();
                    }
                  },
                  error: function() {
                    if (parcelError) {
                      return parcelError();
                    }
                  }
                });
              };
              _results = [];
              for (i = _i = 1; 1 <= parcelCount ? _i <= parcelCount : _i >= parcelCount; i = 1 <= parcelCount ? ++_i : --_i) {
                _fn(currentDate, i);
                if (parcelCount > 0) {
                  if (movement.get('cycle_type') === 'day') {
                    dateService.addDay(currentDate, Number(movement.get('cycle_interval')));
                  }
                  if (movement.get('cycle_type') === 'week') {
                    dateService.addDay(currentDate, Number(movement.get('cycle_interval')) * 7);
                  }
                  if (movement.get('cycle_type') === 'month') {
                    dateService.addMonth(currentDate, Number(movement.get('cycle_interval')));
                    _results.push(dateService.setDay(currentDate, Number(movement.get('expiration_day'))));
                  } else {
                    _results.push(void 0);
                  }
                } else {
                  _results.push(void 0);
                }
              }
              return _results;
            };
          })(this),
          error: function() {
            if (callbacks.error) {
              return callbacks.error();
            }
          }
        });
      };

      MovementService.prototype.processAllInfinite = function(callbacks) {
        var collection;
        if (callbacks == null) {
          callbacks = {};
        }
        collection = new MovementCollection();
        logger.info('processAllInfinite');
        return collection.fetch({
          conditions: {
            repeated: 1
          },
          success: (function(_this) {
            return function() {
              var model, models, triggerError, triggerSuccess, _i, _len, _results;
              models = collection.filter(function(m) {
                return m.get('is_infinite');
              });
              logger.info("Found " + models.length + " models");
              if (models.length === 0) {
                if (callbacks.success) {
                  return callbacks.success();
                }
              } else {
                triggerSuccess = _.after(models.length, function() {
                  if (callbacks.success) {
                    return callbacks.success.apply(this, arguments);
                  }
                });
                triggerError = function() {
                  if (callbacks.error) {
                    return callbacks.error.apply(this, arguments);
                  }
                };
                _results = [];
                for (_i = 0, _len = models.length; _i < _len; _i++) {
                  model = models[_i];
                  _results.push(_this.processInfinite(model, {
                    success: triggerSuccess,
                    error: triggerError
                  }));
                }
                return _results;
              }
            };
          })(this),
          error: function() {
            logger.warning("Error on fetch: ", arguments);
            if (callbacks.error) {
              return callbacks.error.apply(this, arguments);
            }
          }
        });
      };

      MovementService.prototype.processInfinite = function(movement, callbacks) {
        if (!movement) {
          throw new Error('movement is required');
        }
        return movement.fetchParcels({
          success: (function(_this) {
            return function() {
              var count, currentDate, lastDate, lastParcel, nextDate, params, parcel_number, parcels, queue, todayDate, triggerError, triggerSuccess, _i, _len, _results;
              parcels = movement.getParcelCollection().models;
              lastParcel = parcels.pop();
              if (lastParcel) {
                parcels.push(lastParcel);
                lastDate = lastParcel.get('date_obj');
                todayDate = new Date();
                nextDate = dateService.addMonth(todayDate, 1);
                currentDate = new Date(lastDate.getTime());
                if (movement.get('cycle_type') === 'day') {
                  dateService.addDay(currentDate, Number(movement.get('cycle_interval')) || 1);
                }
                if (movement.get('cycle_type') === 'week') {
                  dateService.addDay(currentDate, Number(movement.get('cycle_interval')) * 7);
                }
                if (movement.get('cycle_type') === 'month') {
                  currentDate = dateService.addMonth(currentDate, 1);
                  dateService.setDay(currentDate, movement.get('expiration_day'));
                  dateService.setDay(nextDate, movement.get('expiration_day'));
                }
                queue = [];
                count = 0;
                parcel_number = Number(lastParcel.get('parcel_number')) + 1;
                while (currentDate <= nextDate) {
                  (function(currentDate) {
                    return queue.push({
                      'date': dateService.format('YYYY-MM-DD', currentDate),
                      'parcel_number': parcel_number
                    });
                  })(currentDate);
                  if (movement.get('cycle_type') === 'day') {
                    dateService.addDay(currentDate, movement.get('cycle_interval'));
                  }
                  if (movement.get('cycle_type') === 'week') {
                    dateService.addDay(currentDate, movement.get('cycle_interval') * 7);
                  }
                  if (movement.get('cycle_type') === 'month') {
                    currentDate = dateService.addMonth(currentDate, 1);
                    dateService.setDay(currentDate, movement.get('expiration_day'));
                    parcel_number += 1;
                  }
                }
                triggerSuccess = _.after(queue.length, function() {
                  if (callbacks.success) {
                    return callbacks.success.apply(this, arguments);
                  }
                });
                triggerError = function() {
                  if (callbacks.error) {
                    return callbacks.error.apply(this, arguments);
                  }
                };
                if (queue.length > 0) {
                  _results = [];
                  for (_i = 0, _len = queue.length; _i < _len; _i++) {
                    params = queue[_i];
                    _results.push(_this.createParcelFromMovement(movement, params, {
                      success: triggerSuccess,
                      error: triggerError
                    }));
                  }
                  return _results;
                } else {
                  if (callbacks.success) {
                    return callbacks.success.apply(_this, arguments);
                  }
                }
              } else {
                movement.destroy();
                if (callbacks.success) {
                  return callbacks.success.apply(_this, arguments);
                }
              }
            };
          })(this),
          error: function() {
            if (callbacks.error) {
              return callbacks.error();
            }
          }
        });
      };

      MovementService.prototype.createParcelFromMovement = function(movement, params, callbacks) {
        var parcel;
        parcel = new Parcel({
          movement_id: movement.get('id'),
          movement_type: movement.get('movement_type'),
          description: movement.get('description'),
          parcel_number: params['parcel_number'],
          date: params['date'],
          value: movement.get('value'),
          create_date: dateService.format('YYYY-MM-DD HH:mm:ss'),
          update_date: dateService.format('YYYY-MM-DD HH:mm:ss')
        });
        return parcel.save(parcel.toJSON(), {
          success: function() {
            require('app').events.trigger("create:parcel", parcel);
            if (callbacks.success) {
              return callbacks.success.apply(this, arguments);
            }
          },
          error: function() {
            if (callbacks.error) {
              return callbacks.error.apply(this, arguments);
            }
          }
        });
      };

      return MovementService;

    })();
    return new MovementService();
  });

}).call(this);