// Generated by CoffeeScript 1.7.1
(function() {
  define(['backbone', 'underscore', 'collections/movement', 'collections/parcel', 'models/parcel', 'models/movement', 'services/date'], function(Backbone, _, MovementCollection, ParcelCollection, Parcel, Movement, dateService) {
    var ParcelService;
    ParcelService = (function() {
      function ParcelService() {}

      ParcelService.prototype._saveFrom = function(model_target, model_copied, callbacks) {
        var date1, date2, day1, day2, name, set, _i, _len, _ref;
        _ref = ['description', 'value', 'paid'];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          name = _ref[_i];
          if (model_copied.hasChanged(name)) {
            if (String(model_target.get(name)) !== String(model_copied.get(name))) {
              set = {};
              set[name] = model_copied.get(name);
              model_target.set(set);
            }
          }
        }
        if (!model_target.get('paid')) {
          if (model_copied.hasChanged('date')) {
            date1 = model_target.get('date_obj');
            date2 = model_copied.get('date_obj');
            day1 = dateService.getDay(date1);
            day2 = dateService.getDay(date2);
            if (day1 !== day2) {
              dateService.setDay(date1, day2);
              model_target.set({
                'date_obj': date1
              });
            }
          }
        }
        return this._saveParcel(model_target, callbacks);
      };

      ParcelService.prototype._saveMovementFromParcel = function(model_copied, callbacks) {
        var model_target;
        model_target = new Movement({
          id: model_copied.get('movement_id')
        });
        return model_target.fetch({
          success: function() {
            var day_copied, name, set, _i, _len, _ref;
            _ref = ['description', 'value'];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              name = _ref[_i];
              if (model_copied.hasChanged(name)) {
                if (model_target.get(name) !== model_copied.get(name)) {
                  set = {};
                  set[name] = model_copied.get(name);
                  model_target.set(set);
                }
              }
            }
            if (model_copied.hasChanged('date')) {
              day_copied = model_copied.get('date_obj').getDay();
              if (model_target.get('expiration_day') !== day_copied) {
                model_target.set({
                  'expiration_day': day_copied
                });
              }
            }
            return model_target.save(model_target.toJSON(), callbacks);
          }
        });
      };

      ParcelService.prototype._saveParcel = function(model, callbacks) {
        return model.save(model.toJSON(), {
          success: function() {
            require('app').events.trigger("update:parcel", model);
            if (callbacks && callbacks.success) {
              return callbacks.success.apply(this, arguments);
            }
          },
          error: function() {
            if (callbacks && callbacks.error) {
              return callbacks.error.apply(this, arguments);
            }
          }
        });
      };

      ParcelService.prototype.saveOne = function(model, callbacks) {
        return this._saveParcel(model, callbacks);
      };

      ParcelService.prototype._saveByCond = function(model, callbacks, condition) {
        var collection;
        if (callbacks == null) {
          callbacks = {};
        }
        collection = new ParcelCollection();
        return collection.fetch({
          conditions: {
            'movement_id': model.get('movement_id')
          },
          success: (function(_this) {
            return function() {
              var models, triggerSuccess;
              models = collection.filter(function(m) {
                return condition(m);
              });
              if (callbacks && callbacks.success) {
                triggerSuccess = _.after(models.length, callbacks.success);
              } else {
                triggerSuccess = null;
              }
              _.each(models, function(m) {
                if (m.get('id') === model.get('id')) {
                  return null;
                } else {
                  return _this._saveFrom(m, model, {
                    success: triggerSuccess,
                    error: callbacks.error
                  });
                }
              });
              return _this._saveMovementFromParcel(model, {
                success: function() {
                  return _this._saveParcel(model, {
                    success: triggerSuccess,
                    error: callbacks.error
                  });
                },
                error: callbacks.error
              });
            };
          })(this)
        });
      };

      ParcelService.prototype.saveNext = function(model, callbacks) {
        if (callbacks == null) {
          callbacks = {};
        }
        return this._refreshModelChanged(model, {
          success: (function(_this) {
            return function() {
              return _this._saveByCond(model, callbacks, function(m) {
                return m.get('parcel_number') >= model.get('parcel_number');
              });
            };
          })(this),
          error: function() {
            if (callbacks.error) {
              return callbacks.error();
            }
          }
        });
      };

      ParcelService.prototype.saveAll = function(model, callbacks) {
        return this._refreshModelChanged(model, {
          success: (function(_this) {
            return function() {
              return _this._saveByCond(model, callbacks, function(m) {
                return true;
              });
            };
          })(this),
          error: function() {
            if (callbacks.error) {
              return callbacks.error();
            }
          }
        });
      };

      ParcelService.prototype._refreshModelChanged = function(model, callbacks) {
        var model2;
        if (callbacks == null) {
          callbacks = {};
        }
        if (model.get('id')) {
          model2 = new Parcel({
            id: model.get('id')
          });
          return model2.fetch({
            success: function() {
              var k;
              for (k in model.attributes) {
                if (String(model.get(k)) !== String(model2.get(k))) {
                  model.changed[k] = model.get(k);
                  model._previousAttributes = model2.get(k);
                }
              }
              if (callbacks.success) {
                return callbacks.success();
              }
            },
            error: function() {
              if (callbacks.error) {
                return callbacks.error();
              }
            }
          });
        } else {
          if (callbacks.success) {
            return callbacks.success();
          }
        }
      };

      ParcelService.prototype._removeMovementFromParcel = function(model_copied, callbacks) {
        var model_target;
        model_target = new Movement({
          id: model_copied.get('movement_id')
        });
        return model_target.fetch({
          success: function() {
            return model_target.destroy(callbacks);
          }
        });
      };

      ParcelService.prototype._removeParcel = function(model, callbacks) {
        require('app').events.trigger("delete:parcel", model);
        return model.destroy(callbacks);
      };

      ParcelService.prototype.removeOne = function(model, callbacks) {
        return this._removeParcel(model, callbacks);
      };

      ParcelService.prototype._removeByCond = function(model, callbacks, removeMovement, condition) {
        var collection;
        if (callbacks == null) {
          callbacks = {};
        }
        collection = new ParcelCollection();
        return collection.fetch({
          conditions: {
            'movement_id': model.get('movement_id')
          },
          success: (function(_this) {
            return function() {
              var models, triggerSuccess;
              models = collection.filter(function(m) {
                return condition(m);
              });
              if (callbacks && callbacks.success) {
                triggerSuccess = _.after(models.length, callbacks.success);
              } else {
                triggerSuccess = null;
              }
              _.each(models, function(m) {
                if (m.get('id') === model.get('id')) {
                  return null;
                } else {
                  return _this._removeParcel(m, {
                    success: triggerSuccess,
                    error: callbacks.error
                  });
                }
              });
              if (removeMovement) {
                return _this._removeMovementFromParcel(model, {
                  success: function() {
                    return _this._removeParcel(model, {
                      success: triggerSuccess,
                      error: callbacks.error
                    });
                  },
                  error: callbacks.error
                });
              } else {
                return _this._removeParcel(model, {
                  success: triggerSuccess,
                  error: callbacks.error
                });
              }
            };
          })(this)
        });
      };

      ParcelService.prototype.removeNext = function(model, callbacks) {
        return this._removeByCond(model, callbacks, false, (function(_this) {
          return function(m) {
            return m.get('parcel_number') >= model.get('parcel_number');
          };
        })(this));
      };

      ParcelService.prototype.removeAll = function(model, callbacks) {
        return this._removeByCond(model, callbacks, true, (function(_this) {
          return function(m) {
            return true;
          };
        })(this));
      };

      return ParcelService;

    })();
    return new ParcelService();
  });

}).call(this);