// Generated by CoffeeScript 1.7.1
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  define(['zepto', 'underscore', 'components/view', 'i18n', 'services/configuration'], function($, _, View, i18n, configurationService) {
    var IndexView;
    IndexView = (function(_super) {
      __extends(IndexView, _super);

      function IndexView() {
        return IndexView.__super__.constructor.apply(this, arguments);
      }

      IndexView.prototype.getEl = function() {
        var app;
        app = require('app');
        if (!app.layers.exist(this.el)) {
          this.el = app.layers.add();
        }
        app.layers.go(this.el);
        return this.$el = this.el;
      };

      IndexView.prototype.render = function() {
        var Toolbar, app;
        app = require('app');
        Toolbar = require('widgets/toolbar');
        return require(['text!templates/configuration/index.html'], (function(_this) {
          return function(template_raw) {
            var FormView, form, model, template;
            template = _.template(template_raw);
            _this.getEl();
            _this.el.html(template({
              'i18n': i18n
            }));
            _this.$el = _this.el;
            _this.el.removeClass('loading');
            FormView = View.extend({
              el: "#form-configuration",
              bindings: "data-bind"
            });
            model = configurationService.getModel();
            form = new FormView({
              model: model
            });
            _this.toolbar = new Toolbar(_this.el.find('menu[type=toolbar]').first());
            return _this.toolbar.set([
              {
                'save': function() {
                  var errors, field, _results;
                  _this.el.find('input').trigger('change');
                  errors = model.validate(model.toJSON());
                  if (errors) {
                    _results = [];
                    for (field in errors) {
                      app.status.show(errors[field]);
                      break;
                    }
                    return _results;
                  } else {
                    form.removeBindings();
                    model.save();
                    app.status.show(i18n.t('edited_successfully'));
                    _this.remove();
                    return app.router.navigate('expense', {
                      trigger: true
                    });
                  }
                }
              }
            ]);
          };
        })(this));
      };

      return IndexView;

    })(View);
    return new IndexView();
  });

}).call(this);