// Generated by CoffeeScript 1.7.1
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  define(['zepto', 'underscore', 'components/view', 'i18n', 'models/movement', 'collections/movement', 'services/movement'], function($, _, View, i18n, Movement, movementCollection, movementService) {
    var InsertView;
    InsertView = (function(_super) {
      __extends(InsertView, _super);

      function InsertView() {
        this.el = null;
        this.toolbar = null;
      }

      InsertView.prototype.render = function(movement_type) {
        var Toolbar, app;
        if (movement_type == null) {
          movement_type = 'income';
        }
        app = require('app');
        Toolbar = require('widgets/toolbar');
        return require(['text!templates/movement/insert.html', 'widgets/currency_input'], (function(_this) {
          return function(template_raw, CurrencyInput) {
            var FormView, currencyInput, form, model, template;
            template = _.template(template_raw);
            if (!app.layers.exist(_this.el)) {
              _this.el = app.layers.add();
            }
            _this.el.html(template({
              'i18n': i18n
            }));
            _this.el.removeClass('loading');
            _this.$el = _this.el;
            FormView = View.extend({
              el: "#form-movement-insert",
              bindings: "data-bind"
            });
            model = new Movement();
            model.set({
              'movement_type': movement_type
            });
            form = new FormView({
              model: model
            });
            currencyInput = new CurrencyInput(_this.el.find('.input-currency'));
            currencyInput.on('change', function(newvalue) {
              return model.set({
                value: newvalue
              });
            });
            _this.toolbar = new Toolbar(_this.el.find('menu[type=toolbar]').first());
            return _this.toolbar.set([
              {
                'save': function() {
                  var errors, field, _results;
                  _this.el.find('input').trigger('change');
                  errors = model.validate(model.toJSON());
                  if (errors) {
                    _results = [];
                    for (field in errors) {
                      app.status.show(errors[field]);
                      break;
                    }
                    return _results;
                  } else {
                    app.status.show(i18n.t('successfully_added'));
                    _this.remove();
                    movementService.createMovement(model);
                    if (model.get('movement_type') === 'income') {
                      return app.router.navigate('income', {
                        trigger: true
                      });
                    } else {
                      return app.router.navigate('expense', {
                        trigger: true
                      });
                    }
                  }
                }
              }
            ]);
          };
        })(this));
      };

      return InsertView;

    })(View);
    return new InsertView();
  });

}).call(this);