// Generated by CoffeeScript 1.7.1
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  define(['zepto', 'underscore', 'components/view', 'i18n', 'views/main', 'collections/parcel', 'services/currency', 'components/model', 'services/date', 'services/configuration'], function($, _, View, i18n, main, ParcelCollection, currencyService, Model, dateService, configurationService) {
    var IndexView;
    IndexView = (function(_super) {
      __extends(IndexView, _super);

      IndexView.instances = {};

      IndexView.prototype.bindings = "data-bind";

      function IndexView(options) {
        var $el;
        this.collection = new ParcelCollection();
        this.movement_type = options.movement_type;
        IndexView.__super__.constructor.call(this, options);
        $el = this.el = null;
      }

      IndexView.instance = function(movement_type) {
        if (!(movement_type in this.instances)) {
          this.instances[movement_type] = new IndexView({
            movement_type: movement_type
          });
        }
        return this.instances[movement_type];
      };

      IndexView.prototype.existEl = function() {
        return !((this.el == null) || (!main.layers.exist(this.el)));
      };

      IndexView.prototype.getEl = function() {
        if (!this.existEl()) {
          this.el = main.layers.add();
        }
        this.goToLayer();
        return this.el;
      };

      IndexView.prototype.goToLayer = function() {
        require('app').layers.reset();
        return main.layers.go(this.el);
      };

      IndexView.prototype.firstRender = function() {
        var app, collection, conditionFnc, date_limit, date_start, doFetch, doRefreshSum, movement_type, resetTime;
        main.render();
        movement_type = this.movement_type;
        this.el = this.getEl();
        app = require('app');
        main.toolbar.set(["insert/" + this.movement_type]);
        if (!$('li#' + this.movement_type).is(':target')) {
          $('li#' + this.movement_type + ' a').click();
        }
        collection = this.collection;
        this.sumModel = new (Model.extend({
          defaults: {
            sum: null,
            empty: false
          },
          computeds: {
            sum_display: {
              deps: ['sum'],
              get: function() {
                if (this.get('sum') === null) {
                  return '';
                } else {
                  return currencyService.format(this.get('sum'));
                }
              }
            },
            color: function() {
              if (movement_type === 'income') {
                return '#2EB944';
              } else {
                return '#E22A00';
              }
            }
          }
        }));
        doRefreshSum = (function(_this) {
          return function() {
            var model, sum, _i, _len, _ref;
            sum = 0;
            _ref = _this.collection.models;
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              model = _ref[_i];
              if (!model.get('paid')) {
                sum += model.get('value');
              }
            }
            _this.sumModel.set({
              'sum': sum
            });
            return _this.sumModel.set({
              'empty': _this.collection.models.length === 0
            });
          };
        })(this);
        doRefreshSum = _.throttle(doRefreshSum, 300);
        resetTime = function(date) {
          var date2;
          date2 = new Date(date);
          date2.setHours(0);
          date2.setMinutes(0);
          date2.setSeconds(0);
          return date2;
        };
        date_start = new Date();
        date_start.setDate(date_start.getDate() - 1);
        date_start = resetTime(date_start);
        date_limit = new Date();
        date_limit.setDate(date_limit.getDate() + 31);
        date_limit = resetTime(date_limit);
        conditionFnc = function(model) {
          var date2;
          date2 = resetTime(model.get('date_obj'));
          return date2 >= date_start && date2 <= date_limit;
        };
        doFetch = (function(_this) {
          return function() {
            var date_limit_str, date_start_str;
            date_start_str = dateService.format('YYYY-MM-DD', date_start);
            date_limit_str = dateService.format('YYYY-MM-DD', date_limit);
            return _this.collection.fetch({
              conditions: {
                'date': [date_start_str, date_limit_str]
              },
              success: function() {
                _this.collection.set(_this.collection.where({
                  'movement_type': _this.movement_type
                }));
                return doRefreshSum();
              }
            });
          };
        })(this);
        doFetch();
        doFetch = _.throttle(doFetch, 300);
        app.events.on('create:parcel', (function(_this) {
          return function(parcel) {
            if (parcel.get('movement_type') === _this.movement_type) {
              if (conditionFnc(parcel)) {
                _this.collection.add([parcel]);
                return doRefreshSum();
              }
            }
          };
        })(this));
        app.events.on('update:parcel', (function(_this) {
          return function(parcel) {
            var results;
            if (parcel.get('movement_type') === _this.movement_type) {
              if (conditionFnc(parcel)) {
                results = _this.collection.where({
                  id: parcel.get('id')
                });
                _this.collection.remove(results);
                _this.collection.add([parcel]);
                return doRefreshSum();
              }
            }
          };
        })(this));
        app.events.on('delete:parcel', (function(_this) {
          return function(parcel) {
            var results;
            if (parcel.get('movement_type') === _this.movement_type) {
              results = _this.collection.where({
                id: parcel.get('id')
              });
              _this.collection.remove(results);
              return doRefreshSum();
            }
          };
        })(this));
        return require(['text!templates/parcel/index.html', 'text!templates/parcel/item.html'], (function(_this) {
          return function(template_raw, item_template_raw) {
            var ItemView, ListView, item_template, template;
            template = _.template(template_raw);
            item_template = _.template(item_template_raw);
            _this.el.html(template({
              i18n: i18n
            }));
            _this.el.removeClass('loading');
            ItemView = View.extend({
              tagName: "li",
              bindings: "data-bind",
              initialize: function(options) {
                $(this.el).html(item_template());
                this.model.set('_parcel_count', null);
                this.model.set('_show_parcel', false);
                return this.model.fetchMovement({
                  success: (function(_this) {
                    return function(movement) {
                      _this.model.set('_parcel_count', movement.get('parcel_count'));
                      if (Number(movement.get('parcel_count')) > 0) {
                        return _this.model.set('_show_parcel', true);
                      }
                    };
                  })(this)
                });
              }
            });
            movement_type = _this.movement_type;
            ListView = View.extend({
              el: _this.el.find(".parcel-list"),
              itemView: ItemView,
              bindings: "data-bind",
              model: _this.sumModel,
              initialize: function() {
                return this.collection = collection;
              }
            });
            _this.listView = new ListView();
            return configurationService.on('sync', function() {
              return _this.listView.applyBindings();
            });
          };
        })(this));
      };

      IndexView.prototype.render = function() {
        if (!this.existEl()) {
          this.firstRender();
        }
        return this.goToLayer();
      };

      return IndexView;

    })(View);
    return IndexView;
  });

}).call(this);