// Generated by CoffeeScript 1.7.1
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  define(['zepto', 'underscore', 'components/view', 'i18n', 'models/parcel', 'services/parcel', 'models/movement', 'widgets/action_menu'], function($, _, View, i18n, Parcel, parcelService, Movement, ActionMenu) {
    var UpdateView;
    UpdateView = (function(_super) {
      __extends(UpdateView, _super);

      function UpdateView() {
        var sthis;
        UpdateView.__super__.constructor.call(this);
        this.el = null;
        this.toolbar = null;
        this.movement = null;
        this.model = null;
        sthis = this;
        this.events = {
          'click button.btn-exclude': function() {
            return sthis.exclude();
          }
        };
      }

      UpdateView.prototype.render = function(id) {
        var Toolbar, app;
        app = require('app');
        Toolbar = require('widgets/toolbar');
        return require(['text!templates/parcel/update.html', 'widgets/currency_input'], (function(_this) {
          return function(template_raw, CurrencyInput) {
            var template;
            template = _.template(template_raw);
            _this.model = new Parcel({
              id: id
            });
            return _this.model.fetch({
              success: function() {
                var FormView, currencyInput, form;
                if (!app.layers.exist(_this.el)) {
                  _this.el = app.layers.add();
                }
                _this.$el = _this.el;
                _this.el.html(template({
                  'i18n': i18n,
                  'model': _this.model
                }));
                _this.toolbar = new Toolbar(_this.el.find('menu[type=toolbar]').first());
                _this.toolbar.set([
                  {
                    'save': function() {
                      var errors, field, _results;
                      _this.el.find('input').trigger('change');
                      errors = _this.model.validate(_this.model.toJSON());
                      if (errors) {
                        _results = [];
                        for (field in errors) {
                          app.status.show(errors[field]);
                          break;
                        }
                        return _results;
                      } else {
                        return _this.getUpdateMenu({
                          updateOne: function() {
                            return parcelService.saveOne(_this.model);
                          },
                          updateNext: function() {
                            return parcelService.saveNext(_this.model);
                          },
                          updateAll: function() {
                            return parcelService.saveAll(_this.model);
                          },
                          afterUpdate: function() {
                            app = require('app');
                            app.status.show(i18n.t('edited_successfully'));
                            _this.remove();
                            if (_this.model.get('movement_type') === 'income') {
                              return app.router.navigate('income', {
                                trigger: true
                              });
                            } else {
                              return app.router.navigate('expense', {
                                trigger: true
                              });
                            }
                          }
                        }, function(am) {
                          return am.show();
                        });
                      }
                    }
                  }
                ]);
                _this.delegateEvents();
                _this.el.removeClass('loading');
                FormView = View.extend({
                  el: "#form-parcel-update",
                  bindings: "data-bind"
                });
                form = new FormView({
                  model: _this.model
                });
                _this.needMultiple(_this.model, function() {
                  return null;
                });
                currencyInput = new CurrencyInput(_this.el.find('.input-currency'), _this.model.get('value'));
                return currencyInput.on('change', function(newvalue) {
                  return _this.model.set({
                    value: newvalue
                  });
                });
              }
            });
          };
        })(this));
      };

      UpdateView.prototype.exclude = function() {
        var menu;
        return menu = this.getDeleteMenu({
          deleteOne: (function(_this) {
            return function() {
              return parcelService.removeOne(_this.model);
            };
          })(this),
          deleteNext: (function(_this) {
            return function() {
              return parcelService.removeNext(_this.model);
            };
          })(this),
          deleteAll: (function(_this) {
            return function() {
              return parcelService.removeAll(_this.model);
            };
          })(this),
          afterDelete: (function(_this) {
            return function() {
              var app;
              app = require('app');
              app.status.show(i18n.t('deleted_successfully'));
              if (_this.model.get('movement_type') === 'income') {
                return app.router.navigate('income', {
                  trigger: true
                });
              } else {
                return app.router.navigate('expense', {
                  trigger: true
                });
              }
            };
          })(this)
        }, function(am) {
          return am.show();
        });
      };

      UpdateView.prototype.getUpdateMenu = function(callbacks, callback) {
        return this.needMultiple(this.model, (function(_this) {
          return function(need) {
            var am, options;
            if (need) {
              options = [];
              options.push({
                label: i18n.t('update_only_this_parcel'),
                action: function() {
                  callbacks.updateOne();
                  return callbacks.afterUpdate();
                }
              });
              if (_this.movement.get('is_infinite') || (_this.movement.get('repeated') && Number(_this.model.get('parcel_number')) < Number(_this.movement.get('parcel_count')))) {
                options.push({
                  label: i18n.t('update_this_and_all_future'),
                  action: function() {
                    callbacks.updateNext();
                    return callbacks.afterUpdate();
                  }
                });
              }
              if (Number(_this.model.get('parcel_number')) > 1) {
                options.push({
                  label: i18n.t('update_all_including_previous'),
                  action: function() {
                    callbacks.updateAll();
                    return callbacks.afterUpdate();
                  }
                });
              }
              if (options.length === 1) {
                callbacks.updateOne();
                callbacks.afterUpdate();
                return null;
              }
              am = new ActionMenu(i18n.t('select_an_option'), options);
              return callback(am);
            } else {
              callbacks.updateOne();
              return callbacks.afterUpdate();
            }
          };
        })(this));
      };

      UpdateView.prototype.getDeleteMenu = function(callbacks, callback) {
        return this.needMultiple(this.model, (function(_this) {
          return function(need) {
            var am, options;
            options = [];
            window.z = _this;
            options.push({
              label: i18n.t('delete_only_this_parcel'),
              action: function() {
                callbacks.deleteOne();
                return callbacks.afterDelete();
              }
            });
            if (_this.movement.get('is_infinite') || (_this.movement.get('repeated') && Number(_this.model.get('parcel_number')) < Number(_this.movement.get('parcel_count')))) {
              options.push({
                label: i18n.t('delete_this_and_all_future'),
                action: function() {
                  callbacks.deleteNext();
                  return callbacks.afterDelete();
                }
              });
            }
            if (Number(_this.model.get('parcel_number')) > 1) {
              options.push({
                label: i18n.t('delete_all_including_previous'),
                action: function() {
                  callbacks.deleteAll();
                  return callbacks.afterDelete();
                }
              });
            }
            am = new ActionMenu(i18n.t('select_an_option'), options);
            return callback(am);
          };
        })(this));
      };

      UpdateView.prototype.needMultiple = function(parcel, callback) {
        var doSuccess;
        doSuccess = (function(_this) {
          return function() {
            if (_this.movement.get('repeated')) {
              return callback(true);
            } else {
              return callback(false);
            }
          };
        })(this);
        if (!this.movement) {
          this.movement = new Movement({
            id: parcel.get('movement_id')
          });
          return this.movement.fetch({
            success: function() {
              return doSuccess();
            }
          });
        } else {
          return doSuccess();
        }
      };

      return UpdateView;

    })(View);
    return new UpdateView();
  });

}).call(this);