// Generated by CoffeeScript 1.7.1
(function() {
  define(['zepto', 'i18n'], function($, i18n) {
    var ActionMenu, Option;
    ActionMenu = (function() {
      function ActionMenu(title, options) {
        var params, _fn, _i, _len;
        this.title = title;
        this.options = [];
        _fn = (function(_this) {
          return function(params) {
            var option;
            option = new Option(params);
            option.on('click', function() {
              return _this.close();
            });
            return _this.options.push(option);
          };
        })(this);
        for (_i = 0, _len = options.length; _i < _len; _i++) {
          params = options[_i];
          _fn(params);
        }
        this.options.push(new Option({
          label: i18n.t('cancel'),
          action: (function(_this) {
            return function() {
              return _this.close();
            };
          })(this)
        }));
        this.el = this.createEl();
      }

      ActionMenu.prototype.createEl = function() {
        var el, header, menu, option, _i, _len, _ref;
        el = $('<form onsubmit="return false;"></form>');
        el.attr('role', 'dialog');
        el.attr('data-type', 'action');
        header = $('<header></header>');
        header.html(this.title);
        el.append(header);
        menu = $('<menu></menu>');
        menu.attr('type', 'toolbar');
        _ref = this.options;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          option = _ref[_i];
          menu.append(option.el);
        }
        el.append(menu);
        return el;
      };

      ActionMenu.prototype.show = function() {
        return $('body').append(this.el);
      };

      ActionMenu.prototype.close = function() {
        return this.el.remove();
      };

      return ActionMenu;

    })();
    Option = (function() {
      function Option(params) {
        this.action = params.action;
        this.label = params.label;
        this.el = this.createEl();
        this.el.on('click', (function(_this) {
          return function() {
            return _this.action();
          };
        })(this));
      }

      Option.prototype.on = function(ev, callback) {
        return this.el.on(ev, callback);
      };

      Option.prototype.createEl = function() {
        var el;
        el = $('<button></button>');
        el.html(this.label);
        return el;
      };

      return Option;

    })();
    return ActionMenu;
  });

}).call(this);