// Generated by CoffeeScript 1.7.1
(function() {
  define(function() {
    var CurrencyInput;
    CurrencyInput = (function() {
      function CurrencyInput(el, value) {
        this.el_decimal = el.find('.side-decimal input');
        this.el_integer = el.find('.side-integer input');
        this.events = _.extend({}, Backbone.Events);
        this.bind_all();
        if (value) {
          this.setValue(value);
        }
      }

      CurrencyInput.prototype.bind_all = function() {
        this.el_integer.on('focus', (function(_this) {
          return function() {
            return _this.el_decimal.focus();
          };
        })(this));
        this.el_decimal.on('focus', (function(_this) {
          return function() {
            var err;
            try {
              _this.el_decimal.get(0).selectionStart = _this.el_decimal.val().length;
              return _this.el_decimal.get(0).selectionEnd = _this.el_decimal.val().length;
            } catch (_error) {
              err = _error;
              return console.log(err);
            }
          };
        })(this));
        this.el_decimal.on('click', (function(_this) {
          return function() {
            var err;
            try {
              _this.el_decimal.get(0).selectionStart = _this.el_decimal.val().length;
              return _this.el_decimal.get(0).selectionEnd = _this.el_decimal.val().length;
            } catch (_error) {
              err = _error;
              return console.log(err);
            }
          };
        })(this));
        return this.el_decimal.on('keypress', (function(_this) {
          return function(event) {
            var char, err, integer_piece, integer_value, value;
            value = _this.el_decimal.val();
            if (Number(event.keyCode) === 8) {
              if (value.length <= 2) {
                integer_value = _this.el_integer.val();
                if (integer_value.length > 0) {
                  setTimeout(function() {
                    var decimal_piece, integer;
                    decimal_piece = _this.el_integer.val().substr(-1);
                    integer = _this.el_integer.val().substring(0, _this.el_integer.val().length - 1);
                    _this.el_integer.val(String(integer));
                    return _this.el_decimal.val(String(decimal_piece) + _this.el_decimal.val());
                  }, 1);
                }
              }
            } else {
              char = String.fromCharCode(event.charCode);
              if (/[0-9]/.test(char)) {
                if (value.length >= 2) {
                  integer_piece = value.substring(0, 1);
                  _this.el_integer.val(_this.el_integer.val() + integer_piece);
                  setTimeout(function() {
                    return _this.el_decimal.val(_this.el_decimal.val().substr(-2));
                  }, 1);
                }
              } else {
                if (event.keyCode !== 9) {
                  event.preventDefault();
                }
              }
            }
            try {
              _this.el_decimal.get(0).selectionStart = _this.el_decimal.val().length;
              _this.el_decimal.get(0).selectionEnd = _this.el_decimal.val().length;
            } catch (_error) {
              err = _error;
              console.log(err);
            }
            return setTimeout(function() {
              return _this.triggerChange();
            }, 100);
          };
        })(this));
      };

      CurrencyInput.prototype.triggerChange = function() {
        var decimal, integer, value;
        integer = this.el_integer.val() || 0;
        decimal = this.el_decimal.val() || 0;
        value = '';
        if (decimal) {
          value = [Number(integer), Number(decimal)].join('.');
        } else {
          value = Number(integer);
        }
        return this.events.trigger('change', Number(value));
      };

      CurrencyInput.prototype.setValue = function(value) {
        var aux, decimal;
        aux = String(Number(value)).split('.');
        this.el_integer.val(aux.shift());
        if (aux.length > 0) {
          decimal = aux.shift();
          if (String(decimal).length === 1) {
            decimal = String(decimal) + '0';
          }
        } else {
          decimal = '00';
        }
        return this.el_decimal.val(decimal);
      };

      CurrencyInput.prototype.on = function(event, callback) {
        return this.events.on(event, callback);
      };

      return CurrencyInput;

    })();
    return CurrencyInput;
  });

}).call(this);