// Generated by CoffeeScript 1.7.1
(function() {
  define(['zepto', 'i18n'], function($, i18n) {
    var TabItem, TabManager;
    TabManager = (function() {
      function TabManager(el) {
        this.el = el;
        this.items = [];
      }

      TabManager.prototype.add = function(label, route) {
        return this.items.push(new TabItem(label, route));
      };

      TabManager.prototype.list = function() {
        return this.items;
      };

      TabManager.prototype.render = function() {
        var tab, _i, _len, _ref, _results;
        _ref = this.list();
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          tab = _ref[_i];
          _results.push(this.el.append(tab.get_element()));
        }
        return _results;
      };

      TabManager.prototype.show = function() {
        return this.el.removeClass('inactive');
      };

      TabManager.prototype.hide = function() {
        return this.el.addClass('inactive');
      };

      return TabManager;

    })();
    TabItem = (function() {
      function TabItem(label, route) {
        this.label = label;
        this.route = route;
        this._element = null;
      }

      TabItem.prototype.get_element = function() {
        if (!this._element) {
          this._element = $('<li></li>').attr('role', 'tab').attr('id', this.route);
          this._element.append($('<a></a>').html(this.label).attr('href', "#" + this.route));
        }
        return this._element;
      };

      return TabItem;

    })();
    return TabManager;
  });

}).call(this);