// Generated by CoffeeScript 1.7.1
(function() {
  var __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  define(['zepto', 'underscore', 'backbone', 'i18n'], function($, _, Backbone, i18n) {
    var Toolbar, ToolbarButton;
    Toolbar = (function(_super) {
      __extends(Toolbar, _super);

      function Toolbar(el) {
        this.el = el;
        this.buttons = [];
      }

      Toolbar.prototype.set = function(buttons) {
        this.reset();
        _.each(buttons, (function(_this) {
          return function(button) {
            return _this.buttons.push(new ToolbarButton(button));
          };
        })(this));
        return this.render();
      };

      Toolbar.prototype.reset = function() {
        this.el.children().each(function() {
          return $(this).remove();
        });
        return this.buttons = [];
      };

      Toolbar.prototype.render = function() {
        return _.each(this.buttons, (function(_this) {
          return function(button) {
            return _this.el.append(button.el);
          };
        })(this));
      };

      return Toolbar;

    })(Backbone.View);
    ToolbarButton = (function(_super) {
      __extends(ToolbarButton, _super);

      function ToolbarButton(params) {
        if (params === 'insert/income') {
          params = {
            type: 'add',
            label: i18n.t('save'),
            href: '#insert/income'
          };
        }
        if (params === 'insert/expense') {
          params = {
            type: 'add',
            label: i18n.t('save'),
            href: '#insert/expense'
          };
        }
        if (params.save != null) {
          params = {
            type: 'save',
            label: i18n.t('save'),
            callback: params['save']
          };
        }
        if (params.href) {
          this.el = $(document.createElement('a'));
          this.el.attr('href', params.href);
        } else {
          this.el = $(document.createElement('button'));
          this.el.click(function() {
            return params.callback();
          });
        }
        this.el_label = $(document.createElement('span')).html(params.label);
        if (params.type === 'add') {
          this.el_label.addClass('icon').addClass('icon-add');
        }
        this.el.append(this.el_label);
      }

      return ToolbarButton;

    })(Backbone.View);
    return Toolbar;
  });

}).call(this);