
var Module;
if (typeof Module === 'undefined') Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');
if (!Module.expectedDataFileDownloads) {
  Module.expectedDataFileDownloads = 0;
  Module.finishedDataFileDownloads = 0;
}
Module.expectedDataFileDownloads++;
(function() {
    function fetchRemotePackage(packageName, callback, errback) {
      var xhr = new XMLHttpRequest();
      xhr.open('GET', packageName, true);
      xhr.responseType = 'arraybuffer';
      xhr.onprogress = function(event) {
        var url = packageName;
        if (event.loaded && event.total) {
          if (!xhr.addedTotal) {
            xhr.addedTotal = true;
            if (!Module.dataFileDownloads) Module.dataFileDownloads = {};
            Module.dataFileDownloads[url] = {
              loaded: event.loaded,
              total: event.total
            };
          } else {
            Module.dataFileDownloads[url].loaded = event.loaded;
          }
          var total = 0;
          var loaded = 0;
          var num = 0;
          for (var download in Module.dataFileDownloads) {
          var data = Module.dataFileDownloads[download];
            total += data.total;
            loaded += data.loaded;
            num++;
          }
          total = Math.ceil(total * Module.expectedDataFileDownloads/num);
          if (Module['setStatus']) Module['setStatus']('Downloading data... (' + loaded + '/' + total + ')');
        } else if (!Module.dataFileDownloads) {
          if (Module['setStatus']) Module['setStatus']('Downloading data...');
        }
      };
      xhr.onload = function(event) {
        var packageData = xhr.response;
        callback(packageData);
      };
      xhr.send(null);
    };
    function handleError(error) {
      console.error('package error:', error);
    };
      var fetched = null, fetchedCallback = null;
      fetchRemotePackage('petals3d.data', function(data) {
        if (fetchedCallback) {
          fetchedCallback(data);
          fetchedCallback = null;
        } else {
          fetched = data;
        }
      }, handleError);
  function runWithFS() {
function assert(check, msg) {
  if (!check) throw msg + new Error().stack;
}
Module['FS_createPath']('/', 'data', true, true);
    function DataRequest(start, end, crunched, audio) {
      this.start = start;
      this.end = end;
      this.crunched = crunched;
      this.audio = audio;
    }
    DataRequest.prototype = {
      requests: {},
      open: function(mode, name) {
        this.name = name;
        this.requests[name] = this;
        Module['addRunDependency']('fp ' + this.name);
      },
      send: function() {},
      onload: function() {
        var byteArray = this.byteArray.subarray(this.start, this.end);
          this.finish(byteArray);
      },
      finish: function(byteArray) {
        var that = this;
        Module['FS_createPreloadedFile'](this.name, null, byteArray, true, true, function() {
          Module['removeRunDependency']('fp ' + that.name);
        }, function() {
          if (that.audio) {
            Module['removeRunDependency']('fp ' + that.name); // workaround for chromium bug 124926 (still no audio with this, but at least we don't hang)
          } else {
            Module.printErr('Preloading file ' + that.name + ' failed');
          }
        }, false, true); // canOwn this data in the filesystem, it is a slide into the heap that will never change
        this.requests[this.name] = null;
      },
    };
      new DataRequest(0, 203, 0, 0).open('GET', '/data/about.txt');
    new DataRequest(203, 714, 0, 0).open('GET', '/data/blur.fsh');
    new DataRequest(714, 1169, 0, 0).open('GET', '/data/blur.vsh');
    new DataRequest(1169, 1503, 0, 0).open('GET', '/data/btn_back.ini');
    new DataRequest(1503, 9952, 0, 1).open('GET', '/data/deselect.ogg');
    new DataRequest(9952, 15630, 0, 1).open('GET', '/data/deselect2.ogg');
    new DataRequest(15630, 16122, 0, 0).open('GET', '/data/gameplay.ini');
    new DataRequest(16122, 16968, 0, 0).open('GET', '/data/gameplay_message.ini');
    new DataRequest(16968, 17644, 0, 0).open('GET', '/data/gameplay_results.ini');
    new DataRequest(17644, 39849, 0, 1).open('GET', '/data/growing_01.ogg');
    new DataRequest(39849, 57602, 0, 1).open('GET', '/data/growing_02.ogg');
    new DataRequest(57602, 73997, 0, 1).open('GET', '/data/growing_03.ogg');
    new DataRequest(73997, 89893, 0, 1).open('GET', '/data/growing_04.ogg');
    new DataRequest(89893, 90122, 0, 0).open('GET', '/data/help.txt');
    new DataRequest(90122, 90323, 0, 0).open('GET', '/data/help_de.txt');
    new DataRequest(90323, 92537, 0, 0).open('GET', '/data/menu.ini');
    new DataRequest(92537, 93268, 0, 0).open('GET', '/data/menu_about.ini');
    new DataRequest(93268, 96611, 0, 0).open('GET', '/data/menu_atlas.png');
    new DataRequest(96611, 98086, 0, 0).open('GET', '/data/menu_difficulty.ini');
    new DataRequest(98086, 99525, 0, 0).open('GET', '/data/menu_duration.ini');
    new DataRequest(99525, 100626, 0, 0).open('GET', '/data/menu_gamemode.ini');
    new DataRequest(100626, 101353, 0, 0).open('GET', '/data/menu_help.ini');
    new DataRequest(101353, 105762, 0, 0).open('GET', '/data/menu_highscores.ini');
    new DataRequest(105762, 106048, 0, 0).open('GET', '/data/menu_highscores_best_td_common.ini');
    new DataRequest(106048, 106212, 0, 0).open('GET', '/data/menu_highscores_best_th_top_common.ini');
    new DataRequest(106212, 106497, 0, 0).open('GET', '/data/menu_highscores_highest_td_common.ini');
    new DataRequest(106497, 106660, 0, 0).open('GET', '/data/menu_highscores_highest_th_top_common.ini');
    new DataRequest(106660, 106856, 0, 0).open('GET', '/data/menu_highscores_th_common.ini');
    new DataRequest(106856, 107341, 0, 0).open('GET', '/data/pause_screen.ini');
    new DataRequest(107341, 107404, 0, 0).open('GET', '/data/rect.fsh');
    new DataRequest(107404, 107575, 0, 0).open('GET', '/data/rect.vsh');
    new DataRequest(107575, 107617, 0, 0).open('GET', '/data/resources.ini');
    new DataRequest(107617, 111860, 0, 1).open('GET', '/data/select1.ogg');
    new DataRequest(111860, 116326, 0, 1).open('GET', '/data/select2.ogg');
    new DataRequest(116326, 124658, 0, 1).open('GET', '/data/select3.ogg');
    new DataRequest(124658, 125504, 0, 0).open('GET', '/data/shader.fsh');
    new DataRequest(125504, 125881, 0, 0).open('GET', '/data/shader.vsh');
    new DataRequest(125881, 126016, 0, 0).open('GET', '/data/shader2d.fsh');
    new DataRequest(126016, 126250, 0, 0).open('GET', '/data/shader2d.vsh');
    new DataRequest(126250, 126316, 0, 0).open('GET', '/data/shadowmapping.fsh');
    new DataRequest(126316, 126467, 0, 0).open('GET', '/data/shadowmapping.vsh');
    new DataRequest(126467, 128287, 0, 0).open('GET', '/data/staengel.mtl');
    new DataRequest(128287, 344907, 0, 0).open('GET', '/data/staengel.obj');
    new DataRequest(344907, 344975, 0, 0).open('GET', '/data/start.ini');
    new DataRequest(344975, 346247, 0, 0).open('GET', '/data/strings.ini');
    new DataRequest(346247, 347588, 0, 0).open('GET', '/data/strings_de.ini');
    new DataRequest(347588, 351966, 0, 1).open('GET', '/data/tap.ogg');
    new DataRequest(351966, 352323, 0, 0).open('GET', '/data/text.fsh');
    new DataRequest(352323, 352616, 0, 0).open('GET', '/data/text.vsh');
    new DataRequest(352616, 753248, 0, 1).open('GET', '/data/woodland.ogg');
    var PACKAGE_PATH = window['encodeURIComponent'](window.location.pathname.toString().substring(0, window.location.pathname.toString().lastIndexOf('/')) + '/');
    var PACKAGE_NAME = 'petals3d.data';
    var REMOTE_PACKAGE_NAME = 'petals3d.data';
    var PACKAGE_UUID = 'd73b5f86-e0f6-433b-b952-163875ad8c46';
    function processPackageData(arrayBuffer) {
      Module.finishedDataFileDownloads++;
      assert(arrayBuffer, 'Loading data file failed.');
      var byteArray = new Uint8Array(arrayBuffer);
      var curr;
      // copy the entire loaded file into a spot in the heap. Files will refer to slices in that. They cannot be freed though.
      var ptr = Module['_malloc'](byteArray.length);
      Module['HEAPU8'].set(byteArray, ptr);
      DataRequest.prototype.byteArray = Module['HEAPU8'].subarray(ptr, ptr+byteArray.length);
          DataRequest.prototype.requests["/data/about.txt"].onload();
          DataRequest.prototype.requests["/data/blur.fsh"].onload();
          DataRequest.prototype.requests["/data/blur.vsh"].onload();
          DataRequest.prototype.requests["/data/btn_back.ini"].onload();
          DataRequest.prototype.requests["/data/deselect.ogg"].onload();
          DataRequest.prototype.requests["/data/deselect2.ogg"].onload();
          DataRequest.prototype.requests["/data/gameplay.ini"].onload();
          DataRequest.prototype.requests["/data/gameplay_message.ini"].onload();
          DataRequest.prototype.requests["/data/gameplay_results.ini"].onload();
          DataRequest.prototype.requests["/data/growing_01.ogg"].onload();
          DataRequest.prototype.requests["/data/growing_02.ogg"].onload();
          DataRequest.prototype.requests["/data/growing_03.ogg"].onload();
          DataRequest.prototype.requests["/data/growing_04.ogg"].onload();
          DataRequest.prototype.requests["/data/help.txt"].onload();
          DataRequest.prototype.requests["/data/help_de.txt"].onload();
          DataRequest.prototype.requests["/data/menu.ini"].onload();
          DataRequest.prototype.requests["/data/menu_about.ini"].onload();
          DataRequest.prototype.requests["/data/menu_atlas.png"].onload();
          DataRequest.prototype.requests["/data/menu_difficulty.ini"].onload();
          DataRequest.prototype.requests["/data/menu_duration.ini"].onload();
          DataRequest.prototype.requests["/data/menu_gamemode.ini"].onload();
          DataRequest.prototype.requests["/data/menu_help.ini"].onload();
          DataRequest.prototype.requests["/data/menu_highscores.ini"].onload();
          DataRequest.prototype.requests["/data/menu_highscores_best_td_common.ini"].onload();
          DataRequest.prototype.requests["/data/menu_highscores_best_th_top_common.ini"].onload();
          DataRequest.prototype.requests["/data/menu_highscores_highest_td_common.ini"].onload();
          DataRequest.prototype.requests["/data/menu_highscores_highest_th_top_common.ini"].onload();
          DataRequest.prototype.requests["/data/menu_highscores_th_common.ini"].onload();
          DataRequest.prototype.requests["/data/pause_screen.ini"].onload();
          DataRequest.prototype.requests["/data/rect.fsh"].onload();
          DataRequest.prototype.requests["/data/rect.vsh"].onload();
          DataRequest.prototype.requests["/data/resources.ini"].onload();
          DataRequest.prototype.requests["/data/select1.ogg"].onload();
          DataRequest.prototype.requests["/data/select2.ogg"].onload();
          DataRequest.prototype.requests["/data/select3.ogg"].onload();
          DataRequest.prototype.requests["/data/shader.fsh"].onload();
          DataRequest.prototype.requests["/data/shader.vsh"].onload();
          DataRequest.prototype.requests["/data/shader2d.fsh"].onload();
          DataRequest.prototype.requests["/data/shader2d.vsh"].onload();
          DataRequest.prototype.requests["/data/shadowmapping.fsh"].onload();
          DataRequest.prototype.requests["/data/shadowmapping.vsh"].onload();
          DataRequest.prototype.requests["/data/staengel.mtl"].onload();
          DataRequest.prototype.requests["/data/staengel.obj"].onload();
          DataRequest.prototype.requests["/data/start.ini"].onload();
          DataRequest.prototype.requests["/data/strings.ini"].onload();
          DataRequest.prototype.requests["/data/strings_de.ini"].onload();
          DataRequest.prototype.requests["/data/tap.ogg"].onload();
          DataRequest.prototype.requests["/data/text.fsh"].onload();
          DataRequest.prototype.requests["/data/text.vsh"].onload();
          DataRequest.prototype.requests["/data/woodland.ogg"].onload();
          Module['removeRunDependency']('datafile_petals3d.data');
    };
    Module['addRunDependency']('datafile_petals3d.data');
    if (!Module.preloadResults) Module.preloadResults = {};
      Module.preloadResults[PACKAGE_NAME] = {fromCache: false};
      if (fetched) {
        processPackageData(fetched);
        fetched = null;
      } else {
        fetchedCallback = processPackageData;
      }
  }
  if (Module['calledRun']) {
    runWithFS();
  } else {
    if (!Module['preRun']) Module['preRun'] = [];
    Module["preRun"].push(runWithFS); // FS is not initialized yet, wait for it
  }
})();
// Note: For maximum-speed code, see "Optimizing Code" on the Emscripten wiki, https://github.com/kripken/emscripten/wiki/Optimizing-Code
// Note: Some Emscripten settings may limit the speed of the generated code.
// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');
// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}
// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  Module['print'] = function print(x) {
    process['stdout'].write(x + '\n');
  };
  Module['printErr'] = function printErr(x) {
    process['stderr'].write(x + '\n');
  };
  var nodeFS = require('fs');
  var nodePath = require('path');
  Module['read'] = function read(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };
  Module['readBinary'] = function readBinary(filename) { return Module['read'](filename, true) };
  Module['load'] = function load(f) {
    globalEval(read(f));
  };
  Module['arguments'] = process['argv'].slice(2);
  module['exports'] = Module;
}
else if (ENVIRONMENT_IS_SHELL) {
  Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm
  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function read() { throw 'no read() available (jsc?)' };
  }
  Module['readBinary'] = function readBinary(f) {
    return read(f, 'binary');
  };
  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  this['Module'] = Module;
  eval("if (typeof gc === 'function' && gc.toString().indexOf('[native code]') > 0) var gc = undefined"); // wipe out the SpiderMonkey shell 'gc' function, which can confuse closure (uses it as a minified name, and it is then initted to a non-falsey value unexpectedly)
}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function read(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };
  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  if (typeof console !== 'undefined') {
    Module['print'] = function print(x) {
      console.log(x);
    };
    Module['printErr'] = function printErr(x) {
      console.log(x);
    };
  } else {
    // Probably a worker, and without console.log. We can do very little here...
    var TRY_USE_DUMP = false;
    Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
  }
  if (ENVIRONMENT_IS_WEB) {
    this['Module'] = Module;
  } else {
    Module['load'] = importScripts;
  }
}
else {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}
function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
  Module['load'] = function load(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
// *** Environment setup code ***
// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];
// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];
// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// === Auto-generated preamble library stuff ===
//========================================
// Runtime code shared with compiler
//========================================
var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      return '(((' +target + ')+' + (quantum-1) + ')&' + -quantum + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (isArrayType(type)) return true;
  if (/<?{ ?[^}]* ?}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type) {
    switch (type) {
      case 'i1': case 'i8': return 1;
      case 'i16': return 2;
      case 'i32': return 4;
      case 'i64': return 8;
      case 'float': return 4;
      case 'double': return 8;
      default: {
        if (type[type.length-1] === '*') {
          return Runtime.QUANTUM_SIZE; // A pointer
        } else if (type[0] === 'i') {
          var bits = parseInt(type.substr(1));
          assert(bits % 8 === 0);
          return bits/8;
        } else {
          return 0;
        }
      }
    }
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  STACK_ALIGN: 8,
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (type == 'i64' || type == 'double' || vararg) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    var index = 0;
    type.flatIndexes = type.fields.map(function(field) {
      index++;
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = Runtime.getAlignSize(field, size);
      } else if (Runtime.isStructType(field)) {
        if (field[1] === '0') {
          // this is [0 x something]. When inside another structure like here, it must be at the end,
          // and it adds no size
          // XXX this happens in java-nbody for example... assert(index === type.fields.length, 'zero-length in the middle!');
          size = 0;
          if (Types.types[field]) {
            alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
          } else {
            alignSize = type.alignSize || QUANTUM_SIZE;
          }
        } else {
          size = Types.types[field].flatSize;
          alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
        }
      } else if (field[0] == 'b') {
        // bN, large number field, like a [N x i8]
        size = field.substr(1)|0;
        alignSize = 1;
      } else if (field[0] === '<') {
        // vector type
        size = alignSize = Types.types[field].flatSize; // fully aligned
      } else if (field[0] === 'i') {
        // illegal integer field, that could not be legalized because it is an internal structure field
        // it is ok to have such fields, if we just use them as markers of field size and nothing more complex
        size = alignSize = parseInt(field.substr(1))/8;
        assert(size % 1 === 0, 'cannot handle non-byte-size field ' + field);
      } else {
        assert(false, 'invalid type for calculateStructAlignment');
      }
      if (type.packed) alignSize = 1;
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    if (type.name_[0] === '[') {
      // arrays have 2 elements, so we get the proper difference. then we scale here. that way we avoid
      // allocating a potentially huge array for [999999 x i8] etc.
      type.flatSize = parseInt(type.name_.substr(1))*type.flatSize/2;
    }
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2*(1 + i);
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  getAsmConst: function (code, numArgs) {
    // code is a constant string on the heap, so we can cache these
    if (!Runtime.asmConstCache) Runtime.asmConstCache = {};
    var func = Runtime.asmConstCache[code];
    if (func) return func;
    var args = [];
    for (var i = 0; i < numArgs; i++) {
      args.push(String.fromCharCode(36) + i); // $0, $1 etc
    }
    return Runtime.asmConstCache[code] = eval('(function(' + args.join(',') + '){ ' + Pointer_stringify(code) + ' })'); // new Function does not allow upvars in node
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function dynCall_wrapper() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xFF;
      if (buffer.length == 0) {
        if ((code & 0x80) == 0x00) {        // 0xxxxxxx
          return String.fromCharCode(code);
        }
        buffer.push(code);
        if ((code & 0xE0) == 0xC0) {        // 110xxxxx
          needed = 1;
        } else if ((code & 0xF0) == 0xE0) { // 1110xxxx
          needed = 2;
        } else {                            // 11110xxx
          needed = 3;
        }
        return '';
      }
      if (needed) {
        buffer.push(code);
        needed--;
        if (needed > 0) return '';
      }
      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var c4 = buffer[3];
      var ret;
      if (buffer.length == 2) {
        ret = String.fromCharCode(((c1 & 0x1F) << 6)  | (c2 & 0x3F));
      } else if (buffer.length == 3) {
        ret = String.fromCharCode(((c1 & 0x0F) << 12) | ((c2 & 0x3F) << 6)  | (c3 & 0x3F));
      } else {
        // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
        var codePoint = ((c1 & 0x07) << 18) | ((c2 & 0x3F) << 12) |
                        ((c3 & 0x3F) << 6)  | (c4 & 0x3F);
        ret = String.fromCharCode(
          Math.floor((codePoint - 0x10000) / 0x400) + 0xD800,
          (codePoint - 0x10000) % 0x400 + 0xDC00);
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function processJSString(string) {
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = (((STACKTOP)+7)&-8); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = (((STATICTOP)+7)&-8); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = (((DYNAMICTOP)+7)&-8); if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 8))*(quantum ? quantum : 8); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+((low>>>0)))+((+((high>>>0)))*(+4294967296))) : ((+((low>>>0)))+((+((high|0)))*(+4294967296)))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}
//========================================
// Runtime essentials
//========================================
var __THREW__ = 0; // Used in checking for thrown exceptions.
var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;
var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}
var globalScope = this;
// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays; note that arrays are 8-bit).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;
// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = Module['_' + ident]; // closure exported function
    if (!func) func = eval('_' + ident); // explicit lookup
  } catch(e) {
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}
// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      value = intArrayFromString(value);
      type = 'array';
    }
    if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}
// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;
// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;
// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;
var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;
// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }
  var singleType = typeof types === 'string' ? types : null;
  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }
  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)|0)]=0;
    }
    return ret;
  }
  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }
  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];
    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }
    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later
    setValue(ret+i, curr, type);
    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }
  return ret;
}
Module['allocate'] = allocate;
function Pointer_stringify(ptr, /* optional */ length) {
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = false;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))|0)];
    if (t >= 128) hasUtf = true;
    else if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;
  var ret = '';
  if (!hasUtf) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  var utf8 = new Runtime.UTF8Processor();
  for (i = 0; i < length; i++) {
    t = HEAPU8[(((ptr)+(i))|0)];
    ret += utf8.processCChar(t);
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;
// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF16ToString(ptr) {
  var i = 0;
  var str = '';
  while (1) {
    var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
    if (codeUnit == 0)
      return str;
    ++i;
    // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
    str += String.fromCharCode(codeUnit);
  }
}
Module['UTF16ToString'] = UTF16ToString;
// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr', 
// null-terminated and encoded in UTF16LE form. The copy will require at most (str.length*2+1)*2 bytes of space in the HEAP.
function stringToUTF16(str, outPtr) {
  for(var i = 0; i < str.length; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[(((outPtr)+(i*2))>>1)]=codeUnit
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[(((outPtr)+(str.length*2))>>1)]=0
}
Module['stringToUTF16'] = stringToUTF16;
// Given a pointer 'ptr' to a null-terminated UTF32LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.
function UTF32ToString(ptr) {
  var i = 0;
  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}
Module['UTF32ToString'] = UTF32ToString;
// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr', 
// null-terminated and encoded in UTF32LE form. The copy will require at most (str.length+1)*4 bytes of space in the HEAP,
// but can use less, since str.length does not return the number of characters in the string, but the number of UTF-16 code units in the string.
function stringToUTF32(str, outPtr) {
  var iChar = 0;
  for(var iCodeUnit = 0; iCodeUnit < str.length; ++iCodeUnit) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    var codeUnit = str.charCodeAt(iCodeUnit); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++iCodeUnit);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[(((outPtr)+(iChar*4))>>2)]=codeUnit
    ++iChar;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[(((outPtr)+(iChar*4))>>2)]=0
}
Module['stringToUTF32'] = stringToUTF32;
function demangle(func) {
  try {
    if (typeof func === 'number') func = Pointer_stringify(func);
    if (func[0] !== '_') return func;
    if (func[1] !== '_') return func; // C function
    if (func[2] !== 'Z') return func;
    switch (func[3]) {
      case 'n': return 'operator new()';
      case 'd': return 'operator delete()';
    }
    var i = 3;
    // params, etc.
    var basicTypes = {
      'v': 'void',
      'b': 'bool',
      'c': 'char',
      's': 'short',
      'i': 'int',
      'l': 'long',
      'f': 'float',
      'd': 'double',
      'w': 'wchar_t',
      'a': 'signed char',
      'h': 'unsigned char',
      't': 'unsigned short',
      'j': 'unsigned int',
      'm': 'unsigned long',
      'x': 'long long',
      'y': 'unsigned long long',
      'z': '...'
    };
    function dump(x) {
      //return;
      if (x) Module.print(x);
      Module.print(func);
      var pre = '';
      for (var a = 0; a < i; a++) pre += ' ';
      Module.print (pre + '^');
    }
    var subs = [];
    function parseNested() {
      i++;
      if (func[i] === 'K') i++; // ignore const
      var parts = [];
      while (func[i] !== 'E') {
        if (func[i] === 'S') { // substitution
          i++;
          var next = func.indexOf('_', i);
          var num = func.substring(i, next) || 0;
          parts.push(subs[num] || '?');
          i = next+1;
          continue;
        }
        if (func[i] === 'C') { // constructor
          parts.push(parts[parts.length-1]);
          i += 2;
          continue;
        }
        var size = parseInt(func.substr(i));
        var pre = size.toString().length;
        if (!size || !pre) { i--; break; } // counter i++ below us
        var curr = func.substr(i + pre, size);
        parts.push(curr);
        subs.push(curr);
        i += pre + size;
      }
      i++; // skip E
      return parts;
    }
    var first = true;
    function parse(rawList, limit, allowVoid) { // main parser
      limit = limit || Infinity;
      var ret = '', list = [];
      function flushList() {
        return '(' + list.join(', ') + ')';
      }
      var name;
      if (func[i] === 'N') {
        // namespaced N-E
        name = parseNested().join('::');
        limit--;
        if (limit === 0) return rawList ? [name] : name;
      } else {
        // not namespaced
        if (func[i] === 'K' || (first && func[i] === 'L')) i++; // ignore const and first 'L'
        var size = parseInt(func.substr(i));
        if (size) {
          var pre = size.toString().length;
          name = func.substr(i + pre, size);
          i += pre + size;
        }
      }
      first = false;
      if (func[i] === 'I') {
        i++;
        var iList = parse(true);
        var iRet = parse(true, 1, true);
        ret += iRet[0] + ' ' + name + '<' + iList.join(', ') + '>';
      } else {
        ret = name;
      }
      paramLoop: while (i < func.length && limit-- > 0) {
        //dump('paramLoop');
        var c = func[i++];
        if (c in basicTypes) {
          list.push(basicTypes[c]);
        } else {
          switch (c) {
            case 'P': list.push(parse(true, 1, true)[0] + '*'); break; // pointer
            case 'R': list.push(parse(true, 1, true)[0] + '&'); break; // reference
            case 'L': { // literal
              i++; // skip basic type
              var end = func.indexOf('E', i);
              var size = end - i;
              list.push(func.substr(i, size));
              i += size + 2; // size + 'EE'
              break;
            }
            case 'A': { // array
              var size = parseInt(func.substr(i));
              i += size.toString().length;
              if (func[i] !== '_') throw '?';
              i++; // skip _
              list.push(parse(true, 1, true)[0] + ' [' + size + ']');
              break;
            }
            case 'E': break paramLoop;
            default: ret += '?' + c; break paramLoop;
          }
        }
      }
      if (!allowVoid && list.length === 1 && list[0] === 'void') list = []; // avoid (void)
      return rawList ? list : ret + flushList();
    }
    return parse();
  } catch(e) {
    return func;
  }
}
function demangleAll(text) {
  return text.replace(/__Z[\w\d_]+/g, function(x) { var y = demangle(x); return x === y ? x : (x + ' [' + y + ']') });
}
function stackTrace() {
  var stack = new Error().stack;
  return stack ? demangleAll(stack) : '(no stack trace available)'; // Stack trace is not available at least on IE10 and Safari 6.
}
// Memory management
var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return (x+4095)&-4096;
}
var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk
function enlargeMemory() {
  abort('Cannot enlarge memory arrays in asm.js. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value ' + TOTAL_MEMORY + ', or (2) set Module.TOTAL_MEMORY before the program runs.');
}
var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 16777216;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;
// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'Cannot fallback to non-typed array case: Code is too specialized');
var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');
Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;
function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}
var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited
var runtimeInitialized = false;
function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}
function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
}
function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}
function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module['addOnPreRun'] = Module.addOnPreRun = addOnPreRun;
function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module['addOnInit'] = Module.addOnInit = addOnInit;
function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module['addOnPreMain'] = Module.addOnPreMain = addOnPreMain;
function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module['addOnExit'] = Module.addOnExit = addOnExit;
function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module['addOnPostRun'] = Module.addOnPostRun = addOnPostRun;
// Tools
// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;
function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;
// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))|0)]=chr
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;
function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;
function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=str.charCodeAt(i)
  }
  if (!dontAddNull) HEAP8[(((buffer)+(str.length))|0)]=0
}
Module['writeAsciiToMemory'] = writeAsciiToMemory;
function unSign(value, bits, ignore, sig) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore, sig) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}
if (!Math['imul']) Math['imul'] = function imul(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];
var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled
function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}
Module['removeRunDependency'] = removeRunDependency;
Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data
var memoryInitializer = null;
// === Body ===
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 200584;
var _stdout;
var _stdout=_stdout=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var _stdin;
var _stdin=_stdin=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var _stderr;
var _stderr=_stderr=allocate([0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
/* global initializers */ __ATINIT__.push({ func: function() { runPostSets() } },{ func: function() { __GLOBAL__I_a() } },{ func: function() { __GLOBAL__I_a532() } },{ func: function() { __GLOBAL__I_a781() } });
var ___fsmu8;
var ___dso_handle;
var __ZTVN10__cxxabiv120__si_class_type_infoE;
__ZTVN10__cxxabiv120__si_class_type_infoE=allocate([0,0,0,0,96,100,0,0,60,2,0,0,30,1,0,0,136,0,0,0,8,2,0,0,6,0,0,0,8,0,0,0,6,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var __ZTVN10__cxxabiv119__pointer_type_infoE;
__ZTVN10__cxxabiv119__pointer_type_infoE=allocate([0,0,0,0,128,100,0,0,60,2,0,0,140,0,0,0,136,0,0,0,8,2,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var __ZTVN10__cxxabiv117__class_type_infoE;
__ZTVN10__cxxabiv117__class_type_infoE=allocate([0,0,0,0,160,100,0,0,60,2,0,0,54,2,0,0,136,0,0,0,8,2,0,0,6,0,0,0,22,0,0,0,4,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
var __ZN8TimestepC1Ef;
var __ZN7IniFileC1EP6FileIO;
var __ZN7IniFileD1Ev;
var __ZN12DirectFileIOC1ERKNSt3__112basic_stringIcNS0_11char_traitsIcEENS0_9allocatorIcEEEE;
var __ZN14StorageManagerC1EPKc;
var __ZN14StorageManagerD1Ev;
var __ZN4I18NC1EP6FileIOPKcS3_;
var __ZN4I18ND1Ev;
var __ZN4GameC1EP13PlatformAudioP6FileIOPKcbS5_;
var __ZN5MixerC1EP6FileIOP13PlatformAudio;
var __ZN7Vector3C1Ev;
var __ZN5OOBJJC1EP6FileIONSt3__112basic_stringIcNS2_11char_traitsIcEENS2_9allocatorIcEEEE;
var __ZN5OOBJJD1Ev;
var __ZN6Petals4GameC1EPNS_12GameListenerEiNS_8GameModeENS_10DifficultyENS_8DurationE;
var __ZN10HighscoresC1EP14StorageManager;
var __ZN10HighscoresD1Ev;
var __ZN13PanningCameraC1Ev;
var __ZN13PanningCameraD1Ev;
var __ZN13AttractCameraC1Ev;
var __ZN13AttractCameraD1Ev;
var __ZN11LightCameraC1EP5Light;
var __ZN11LightCameraD1Ev;
var __ZN19InterpolatingCameraC1EP6CameraS1_;
var __ZN19InterpolatingCameraD1Ev;
var __ZN5LightC1EN3glm6detail5tvec3IfEE;
var __ZN5LightD1Ev;
var __ZN8RendererC1EP6FileIO;
var __ZN8RendererD1Ev;
var __ZN11PerformanceC1Ev;
var __ZN12TextRendererC1EP4FontNSt3__112basic_stringIcNS2_11char_traitsIcEENS2_9allocatorIcEEEE;
var __ZN12TextRendererD1Ev;
var __ZN4MenuC1EP6FileIORKNSt3__112basic_stringIcNS2_11char_traitsIcEENS2_9allocatorIcEEEEP13ActionHandlerP4I18N;
var __ZN4MenuD1Ev;
var __ZN19SceneGraphTraversalC1EP17SceneGraphVisitor;
var __ZN26SceneGraphTransformVisitorC1EP27SceneGraphTransformReceiverb;
var __ZN26SceneGraphTransformVisitorD1Ev;
var __ZN10SceneGraphC1EPS_;
var __ZN10SceneGraphD1Ev;
var __ZN12TextureAtlasC1Ev;
var __ZN12TextureAtlasD1Ev;
var __ZN6ActionC1EP14SceneGraphNodeRKNSt3__112basic_stringIcNS2_11char_traitsIcEENS2_9allocatorIcEEEE;
var __ZN6ActionD1Ev;
var __ZN10TransitionC1Ev;
var __ZN10TransitionD1Ev;
var __ZN6ShaderC1ENS_4TypeEPKcj;
var __ZN7ProgramC1EP6ShaderS1_;
var __ZN7TextureC1Ev;
var __ZN7TextureD1Ev;
var __ZN12VertexBufferC1Ev;
var __ZN12VertexBufferD1Ev;
var __ZN11FramebufferC1Eii;
var __ZN11FramebufferD1Ev;
var __ZN17VertexAccumulatorC1Ev;
var __ZN17VertexAccumulatorD1Ev;
var __ZN10ExpressionC1Ef;
var __ZN10ExpressionC1ENSt3__18functionIFfvEEE;
var __ZN10ExpressionC1ENSt3__112basic_stringIcNS0_11char_traitsIcEENS0_9allocatorIcEEEE;
var __ZN10ExpressionC1E14ExpressionTypeRKS_S2_;
var __ZN10ExpressionD1Ev;
var __ZNSt13runtime_errorC1EPKc;
var __ZNSt13runtime_errorD1Ev;
var __ZNSt12length_errorD1Ev;
var __ZNSt12out_of_rangeD1Ev;
var __ZNSt3__16localeC1Ev;
var __ZNSt3__16localeC1ERKS0_;
var __ZNSt3__16localeD1Ev;
var __ZNSt8bad_castC1Ev;
var __ZNSt8bad_castD1Ev;
/* memory initializer */ allocate([0,0,0,0,0,0,36,64,0,0,0,0,0,0,89,64,0,0,0,0,0,136,195,64,0,0,0,0,132,215,151,65,0,128,224,55,121,195,65,67,23,110,5,181,181,184,147,70,245,249,63,233,3,79,56,77,50,29,48,249,72,119,130,90,60,191,115,127,221,79,21,117,74,117,108,0,0,0,0,0,105,110,118,97,108,105,100,0,74,117,110,0,0,0,0,0,100,101,115,101,108,101,99,116,46,111,103,103,0,0,0,0,104,115,122,32,61,61,32,49,48,56,0,0,0,0,0,0,65,112,114,0,0,0,0,0,66,77,80,32,82,76,69,0,77,97,114,0,0,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,108,111,99,97,108,101,32,102,111,114,32,115,116,97,110,100,97,114,100,32,105,110,112,117,116,0,0,0,115,116,100,58,58,98,97,100,95,99,97,115,116,0,0,0,109,111,110,111,99,104,114,111,109,101,0,0,0,0,0,0,70,101,98,0,0,0,0,0,98,97,100,32,66,77,80,0,74,97,110,0,0,0,0,0,109,117,108,116,105,112,108,101,32,73,72,68,82,0,0,0,115,101,116,95,109,101,110,117,95,110,111,119,40,112,97,117,115,101,95,115,99,114,101,101,110,41,0,0,0,0,0,0,117,110,107,110,111,119,110,32,66,77,80,0,0,0,0,0,68,101,99,101,109,98,101,114,0,0,0,0,0,0,0,0,99,111,108,111,114,58,97,0,110,111,116,32,66,77,80,0,104,101,105,103,104,116,0,0,78,111,118,101,109,98,101,114,0,0,0,0,0,0,0,0,108,105,103,104,116,112,111,115,0,0,0,0,0,0,0,0,105,108,108,101,103,97,108,32,99,111,100,101,32,105,110,32,114,97,115,116,101,114,0,0,79,99,116,111,98,101,114,0,114,111,117,110,100,0,0,0,109,97,112,95,75,100,32,0,116,111,111,32,109,97,110,121,32,99,111,100,101,115,0,0,83,101,112,116,101,109,98,101,114,0,0,0,0,0,0,0,110,111,32,99,108,101,97,114,32,99,111,100,101,0,0,0,65,117,103,117,115,116,0,0,117,110,107,110,111,119,110,32,99,111,100,101,0,0,0,0,74,117,108,121,0,0,0,0,109,105,115,115,105,110,103,32,99,111,108,111,114,32,116,97,98,108,101,0,0,0,0,0,74,117,110,101,0,0,0,0,98,97,100,32,73,109,97,103,101,32,68,101,115,99,114,105,112,116,111,114,0,0,0,0,77,97,121,0,0,0,0,0,85,110,98,97,108,97,110,99,101,100,32,112,97,114,101,110,116,104,101,115,105,115,0,0,119,114,111,110,103,32,99,111,108,111,114,32,102,111,114,109,97,116,0,0,0,0,0,0,65,112,114,105,108,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,98,105,116,32,100,101,112,116,104,0,0,0,77,97,114,99,104,0,0,0,119,114,111,110,103,32,99,104,97,110,110,101,108,32,99,111,117,110,116,0,0,0,0,0,70,101,98,114,117,97,114,121,0,0,0,0,0,0,0,0,99,111,108,111,114,58,98,0,119,114,111,110,103,32,118,101,114,115,105,111,110,0,0,0,119,105,100,116,104,0,0,0,74,97,110,117,97,114,121,0,110,111,116,32,80,83,68,0,110,111,114,109,97,108,0,0,98,97,115,105,99,95,115,116,114,105,110,103,0,0,0,0,115,104,97,112,101,0,0,0,80,73,67,84,0,0,0,0,75,115,32,0,0,0,0,0,49,46,48,46,57,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,0,0,0,0,83,128,246,52,0,0,0,0,88,46,89,46,90,0,0,0,115,101,108,101,99,116,51,46,111,103,103,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,0,0,0,0,98,97,100,32,102,111,114,109,97,116,0,0,0,0,0,0,116,100,95,98,101,115,116,95,37,99,95,37,99,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,0,0,0,0,115,101,108,101,99,116,50,46,111,103,103,0,0,0,0,0,48,0,0,0,0,0,0,0,103,114,111,119,105,110,103,95,48,49,46,111,103,103,0,0,83,0,0,0,101,0,0,0,112,0,0,0,0,0,0,0,114,101,113,95,99,111,109,112,32,62,61,32,49,32,38,38,32,114,101,113,95,99,111,109,112,32,60,61,32,52,0,0,37,100,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,0,0,0,0,98,97,100,32,102,105,108,101,0,0,0,0,0,0,0,0,85,110,101,120,112,101,99,116,101,100,32,99,108,111,115,105,110,103,32,98,114,97,99,107,101,116,0,0,0,0,0,0,116,100,95,104,105,103,104,95,37,99,95,37,99,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,0,0,0,0,112,111,119,0,0,0,0,0,98,97,100,32,112,97,108,101,116,116,101,0,0,0,0,0,104,101,97,100,101,114,95,37,100,95,112,116,115,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,98,97,100,32,99,111,109,112,114,101,115,115,105,111,110,0,110,111,116,32,71,73,70,0,116,104,95,98,101,115,116,95,37,99,0,0,0,0,0,0,77,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,110,111,32,112,114,101,115,101,116,32,100,105,99,116,0,0,99,111,108,111,114,58,103,0,104,101,97,100,101,114,95,37,100,95,109,105,110,0,0,0,108,111,97,100,101,100,0,0,65,0,0,0,112,0,0,0,114,0,0,0,0,0,0,0,98,97,100,32,122,108,105,98,32,104,101,97,100,101,114,0,112,111,115,105,116,105,111,110,0,0,0,0,0,0,0,0,116,104,95,104,105,103,104,95,37,99,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,0,0,0,0,116,104,114,101,101,0,0,0,114,101,97,100,32,112,97,115,116,32,98,117,102,102,101,114,0,0,0,0,0,0,0,0,75,100,32,0,0,0,0,0,108,111,97,100,95,104,105,103,104,115,99,111,114,101,115,0,70,0,0,0,101,0,0,0,98,0,0,0,0,0,0,0,122,108,105,98,32,99,111,114,114,117,112,116,0,0,0,0,108,111,97,100,95,116,101,120,116,0,0,0,0,0,0,0,114,101,116,117,114,110,32,119,105,110,100,111,119,46,105,110,110,101,114,72,101,105,103,104,116,59,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,0,0,0,0,97,45,62,110,117,109,95,98,105,116,115,32,61,61,32,48,0,0,0,0,0,0,0,0,108,111,110,103,95,37,100,95,115,101,116,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,115,105,122,101,115,91,105,93,32,60,61,32,40,49,32,60,60,32,105,41,0,0,0,0,115,101,108,101,99,116,49,46,111,103,103,0,0,0,0,0,109,101,100,105,117,109,95,37,100,95,115,101,116,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,98,97,100,32,99,111,100,101,108,101,110,103,116,104,115,0,115,104,111,114,116,95,37,100,95,115,101,116,0,0,0,0,99,32,61,61,32,49,56,0,79,0,0,0,99,0,0,0,116,0,0,0,111,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,73,110,118,97,108,105,100,32,99,104,97,114,97,99,116,101,114,0,0,0,0,0,0,0,108,111,110,103,95,37,100,95,109,105,110,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,116,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,97,98,115,0,0,0,0,0,99,32,62,61,32,48,32,38,38,32,99,32,60,32,49,57,0,0,0,0,0,0,0,0,109,101,100,105,117,109,95,37,100,95,109,105,110,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,117,0,0,0,115,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,122,45,62,99,111,100,101,95,98,117,102,102,101,114,32,60,32,40,49,85,32,60,60,32,122,45,62,110,117,109,95,98,105,116,115,41,0,0,0,0,43,88,32,0,0,0,0,0,115,104,111,114,116,95,37,100,95,109,105,110,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,99,111,108,111,114,58,114,0,116,101,120,116,95,108,111,110,103,0,0,0,0,0,0,0,46,105,110,105,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,122,45,62,115,105,122,101,91,98,93,32,61,61,32,115,0,109,118,112,0,0,0,0,0,116,101,120,116,95,109,101,100,105,117,109,0,0,0,0,0,116,119,111,0,0,0,0,0,111,117,116,112,117,116,32,98,117,102,102,101,114,32,108,105,109,105,116,0,0,0,0,0,75,97,32,0,0,0,0,0,116,101,120,116,95,115,104,111,114,116,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,105,0,0,0,108,0,0,0,0,0,0,0,98,97,100,32,100,105,115,116,0,0,0,0,0,0,0,0,80,97,114,115,101,114,32,101,114,114,111,114,32,97,116,32,0,0,0,0,0,0,0,0,108,111,97,100,95,100,117,114,97,116,105,111,110,95,108,97,98,101,108,115,0,0,0,0,114,101,116,117,114,110,32,119,105,110,100,111,119,46,105,110,110,101,114,87,105,100,116,104,59,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,99,0,0,0,104,0,0,0,0,0,0,0,98,97,100,32,104,117,102,102,109,97,110,32,99,111,100,101,0,0,0,0,0,0,0,0,112,108,97,121,95,115,111,117,110,100,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,114,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,35,63,82,65,68,73,65,78,67,69,10,0,0,0,0,0,116,97,112,46,111,103,103,0,108,111,110,103,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,105,110,118,97,108,105,100,32,100,101,99,111,100,101,100,32,115,99,97,110,108,105,110,101,32,108,101,110,103,116,104,0,115,104,111,114,116,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,100,97,116,97,32,108,97,121,111,117,116,0,68,117,112,108,105,99,97,116,101,32,100,101,99,105,109,97,108,32,112,111,105,110,116,0,115,101,116,95,100,117,114,97,116,105,111,110,0,0,0,0,80,77,0,0,0,0,0,0,117,110,115,117,112,112,111,114,116,101,100,32,102,111,114,109,97,116,0,0,0,0,0,0,115,105,110,0,0,0,0,0,98,101,115,116,95,116,105,109,101,0,0,0,0,0,0,0,65,77,0,0,0,0,0,0,110,111,116,32,72,68,82,0,45,89,32,0,0,0,0,0,104,105,103,104,101,115,116,95,115,99,111,114,101,0,0,0,98,97,100,32,99,111,100,101,32,108,101,110,103,116,104,115,0,0,0,0,0,0,0,0,115,99,97,108,101,0,0,0,115,101,116,95,103,97,109,101,109,111,100,101,0,0,0,0,80,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,98,97,100,32,68,72,84,32,104,101,97,100,101,114,0,0,115,99,97,108,101,0,0,0,104,97,114,100,0,0,0,0,65,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,111,110,101,0,0,0,0,0,98,97,100,32,68,81,84,32,116,97,98,108,101,0,0,0,105,108,108,117,109,32,0,0,109,101,100,105,117,109,0,0,98,97,100,32,68,81,84,32,116,121,112,101,0,0,0,0,101,97,115,121,0,0,0,0,114,101,116,117,114,110,32,69,109,76,111,115,115,111,46,105,115,67,111,110,116,101,120,116,76,111,115,116,40,41,59,0,98,97,100,32,68,82,73,32,108,101,110,0,0,0,0,0,115,101,116,95,100,105,102,102,105,99,117,108,116,121,0,0,112,114,111,103,114,101,115,115,105,118,101,32,106,112,101,103,0,0,0,0,0,0,0,0,119,111,111,100,108,97,110,100,46,111,103,103,0,0,0,0,115,116,97,114,116,95,103,97,109,101,112,108,97,121,0,0,101,120,112,101,99,116,101,100,32,109,97,114,107,101,114,0,104,97,115,95,98,97,99,107,95,98,117,116,116,111,110,0,112,97,117,115,101,100,0,0,98,97,100,32,84,81,0,0,32,32,32,32,32,32,32,32,32,0,0,0,0,0,0,0,97,116,97,110,50,0,0,0,98,97,100,32,86,0,0,0,98,97,100,32,72,0,0,0,70,79,82,77,65,84,61,51,50,45,98,105,116,95,114,108,101,95,114,103,98,101,0,0,101,114,114,111,114,95,109,101,115,115,97,103,101,0,0,0,104,0,0,0,0,0,0,0,98,97,100,32,99,111,109,112,111,110,101,110,116,32,73,68,0,0,0,0,0,0,0,0,116,105,109,101,95,108,97,98,101,108,0,0,0,0,0,0,115,99,114,101,101,110,0,0,98,97,100,32,99,111,109,112,111,110,101,110,116,32,99,111,117,110,116,0,0,0,0,0,111,102,102,115,101,116,0,0,115,99,111,114,101,95,108,97,98,101,108,0,0,0,0,0,99,111,117,110,116,0,0,0,48,32,119,105,100,116,104,0,100,101,115,101,108,101,99,116,46,111,103,103,0,0,0,0,73,110,118,97,108,105,100,32,101,120,112,114,101,115,115,105,111,110,32,116,121,112,101,0,110,111,32,104,101,97,100,101,114,32,104,101,105,103,104,116,0,0,0,0,0,0,0,0,46,102,115,104,0,0,0,0,115,101,108,101,99,116,51,46,111,103,103,0,0,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,67,97,108,108,97,98,108,101,32,117,115,101,100,32,97,115,32,118,97,108,117,101,0,0,111,110,108,121,32,56,45,98,105,116,0,0,0,0,0,0,108,111,99,97,108,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,0,0,0,46,118,115,104,0,0,0,0,115,101,108,101,99,116,50,46,111,103,103,0,0,0,0,0,71,111,116,32,49,32,97,114,103,117,109,101,110,116,44,32,101,120,112,101,99,116,101,100,32,50,0,0,0,0,0,0,98,97,100,32,83,79,70,32,108,101,110,0,0,0,0,0,99,111,108,111,114,58,97,0,103,114,111,119,105,110,103,95,48,52,46,111,103,103,0,0,115,101,108,101,99,116,49,46,111,103,103,0,0,0,0,0,71,111,116,32,49,32,97,114,103,117,109,101,110,116,44,32,101,120,112,101,99,116,101,100,32,48,0,0,0,0,0,0,110,111,32,83,79,70,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,99,111,108,111,114,58,98,0,100,101,115,101,108,101,99,116,50,46,111,103,103,0,0,0,37,73,58,37,77,58,37,83,32,37,112,0,0,0,0,0,71,111,116,32,50,32,97,114,103,117,109,101,110,116,115,44,32,101,120,112,101,99,116,101,100,32,49,0,0,0,0,0,115,101,116,95,109,101,110,117,40,103,97,109,101,112,108,97,121,95,114,101,115,117,108,116,115,41,0,0,0,0,0,0,110,111,32,83,79,73,0,0,99,111,108,111,114,58,103,0,39,0,0,0,0,0,0,0,115,116,114,105,110,103,115,46,105,110,105,0,0,0,0,0,37,0,0,0,97,0,0,0,32,0,0,0,37,0,0,0,98,0,0,0,32,0,0,0,37,0,0,0,100,0,0,0,32,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,89,0,0,0,0,0,0,0,0,0,0,0,71,111,116,32,50,32,97,114,103,117,109,101,110,116,115,44,32,101,120,112,101,99,116,101,100,32,48,0,0,0,0,0,98,101,115,116,95,116,105,109,101,95,37,115,0,0,0,0,98,97,100,32,112,110,103,32,115,105,103,0,0,0,0,0,99,111,108,111,114,58,114,0,115,116,100,58,58,101,120,99,101,112,116,105,111,110,0,0,37,97,32,37,98,32,37,100,32,37,72,58,37,77,58,37,83,32,37,89,0,0,0,0,71,111,116,32,48,32,97,114,103,117,109,101,110,116,115,44,32,101,120,112,101,99,116,101,100,32,50,0,0,0,0,0,105,109,103,95,110,43,49,32,61,61,32,111,117,116,95,110,0,0,0,0,0,0,0,0,104,101,105,103,104,116,0,0,35,63,82,65,68,73,65,78,67,69,0,0,0,0,0,0,98,101,115,116,95,115,99,111,114,101,95,37,100,0,0,0,115,116,97,114,116,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,0,0,0,0,105,49,56,110,0,0,0,0,105,110,118,97,108,105,100,32,102,105,108,116,101,114,0,0,119,105,100,116,104,0,0,0,104,101,105,103,104,116,0,0,110,111,95,110,101,119,95,104,105,103,104,95,115,99,111,114,101,0,0,0,0,0,0,0,109,111,117,115,101,0,0,0,37,72,58,37,77,58,37,83,0,0,0,0,0,0,0,0,71,111,116,32,48,32,97,114,103,117,109,101,110,116,115,44,32,101,120,112,101,99,116,101,100,32,49,0,0,0,0,0,108,111,115,105,110,103,46,111,103,103,0,0,0,0,0,0,110,111,116,32,101,110,111,117,103,104,32,112,105,120,101,108,115,0,0,0,0,0,0,0,112,111,115,0,0,0,0,0,97,116,108,97,115,58,104,0,116,101,120,99,111,111,114,100,0,0,0,0,0,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,78,111,116,32,97,32,99,97,108,108,97,98,108,101,58,32,0,0,0,0,0,0,0,0,105,109,112,108,105,99,105,116,58,119,105,100,116,104,0,0,99,121,97,110,0,0,0,0,111,117,116,95,110,32,61,61,32,115,45,62,105,109,103,95,110,32,124,124,32,111,117,116,95,110,32,61,61,32,115,45,62,105,109,103,95,110,43,49,0,0,0,0,0,0,0,0,97,116,108,97,115,58,119,0,78,105,32,0,0,0,0,0,33,99,45,62,115,112,97,114,115,101,0,0,0,0,0,0,110,101,119,95,104,105,103,104,95,115,99,111,114,101,0,0,37,109,47,37,100,47,37,121,0,0,0,0,0,0,0,0,67,97,110,110,111,116,32,102,105,110,100,32,99,97,108,108,97,98,108,101,58,32,0,0,111,117,116,95,110,32,61,61,32,50,32,124,124,32,111,117,116,95,110,32,61,61,32,52,0,0,0,0,0,0,0,0,97,116,108,97,115,58,121,0,99,45,62,115,111,114,116,101,100,95,99,111,100,101,119,111,114,100,115,32,124,124,32,99,45,62,99,111,100,101,119,111,114,100,115,0,0,0,0,0,10,0,0,0,0,0,0,0,83,121,109,98,111,108,32,108,111,111,107,117,112,32,102,97,105,108,117,114,101,58,32,0,47,85,115,101,114,115,47,116,104,112,47,115,114,99,47,112,101,116,97,108,115,51,100,47,101,120,116,101,114,110,97,108,47,115,116,98,95,105,109,97,103,101,46,99,0,0,0,0,99,101,110,116,101,114,0,0,97,116,108,97,115,58,120,0,33,99,45,62,115,112,97,114,115,101,32,124,124,32,122,32,60,32,99,45,62,115,111,114,116,101,100,95,101,110,116,114,105,101,115,0,0,0,0,0,119,105,110,110,105,110,103,46,111,103,103,0,0,0,0,0,102,0,0,0,97,0,0,0,108,0,0,0,115,0,0,0,101,0,0,0,0,0,0,0,66,105,110,100,105,110,103,32,108,111,111,112,32,100,101,116,101,99,116,101,100,58,32,0,115,45,62,105,109,103,95,111,117,116,95,110,32,61,61,32,52,0,0,0,0,0,0,0,122,32,60,32,99,45,62,115,111,114,116,101,100,95,101,110,116,114,105,101,115,0,0,0,116,114,97,110,115,105,116,105,111,110,58,105,110,0,0,0,103,114,111,119,105,110,103,95,48,51,46,111,103,103,0,0,116,105,109,101,95,116,97,107,101,110,95,37,115,0,0,0,37,112,0,0,0,0,0,0,110,111,32,73,68,65,84,0,102,97,108,115,101,0,0,0,40,110,32,38,32,51,41,32,61,61,32,48,0,0,0,0,102,105,110,97,108,95,115,99,111,114,101,95,37,100,0,0,83,111,117,114,99,101,83,97,110,115,80,114,111,83,101,109,105,66,111,108,100,0,0,0,111,117,116,111,102,100,97,116,97,0,0,0,0,0,0,0,116,0,0,0,114,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,83,116,114,105,110,103,58,32,39,0,0,0,0,0,0,0,115,99,111,114,101,95,37,100,47,37,100,0,0,0,0,0,116,97,110,0,0,0,0,0,115,99,111,114,101,95,37,100,0,0,0,0,0,0,0,0,111,117,116,111,102,109,101,109,0,0,0,0,0,0,0,0,116,114,117,101,0,0,0,0,102,45,62,97,108,108,111,99,46,97,108,108,111,99,95,98,117,102,102,101,114,95,108,101,110,103,116,104,95,105,110,95,98,121,116,101,115,32,61,61,32,102,45,62,116,101,109,112,95,111,102,102,115,101,116,0,102,45,62,98,121,116,101,115,95,105,110,95,115,101,103,32,61,61,32,48,0,0,0,0,115,101,116,95,109,101,110,117,40,103,97,109,101,112,108,97,121,95,109,101,115,115,97,103,101,41,0,0,0,0,0,0,110,111,32,80,76,84,69,0,117,110,107,110,111,119,110,32,105,109,97,103,101,32,116,121,112,101,0,0,0,0,0,0,58,32,0,0,0,0,0,0,37,48,50,100,58,37,48,50,100,32,47,32,37,48,50,100,58,37,48,50,100,0,0,0,97,118,97,105,108,97,98,108,101,91,121,93,32,61,61,32,48,0,0,0,0,0,0,0,119,111,111,100,108,97,110,100,46,111,103,103,0,0,0,0,121,0,0,0,0,0,0,0,10,10,0,0,0,0,0,0,116,82,78,83,32,119,105,116,104,32,97,108,112,104,97,0,58,121,0,0,0,0,0,0,119,105,100,116,104,0,0,0,114,98,0,0,0,0,0,0,48,0,0,0,0,0,0,0,114,101,115,111,117,114,99,101,115,46,105,110,105,0,0,0,98,97,100,32,116,82,78,83,32,108,101,110,0,0,0,0,58,120,0,0,0,0,0,0,109,101,110,117,95,97,116,108,97,115,46,112,110,103,0,0,99,111,108,111,114,0,0,0,99,45,62,115,111,114,116,101,100,95,101,110,116,114,105,101,115,32,61,61,32,48,0,0,73,110,118,97,108,105,100,32,111,112,101,114,97,116,111,114,0,0,0,0,0,0,0,0,111,114,97,110,103,101,0,0,116,82,78,83,32,98,101,102,111,114,101,32,80,76,84,69,0,0,0,0,0,0,0,0,112,114,111,106,101,99,116,105,111,110,0,0,0,0,0,0,105,111,115,95,98,97,115,101,58,58,99,108,101,97,114,0,78,115,32,0,0,0,0,0,103,114,111,119,105,110,103,95,37,48,50,100,46,111,103,103,0,0,0,0,0,0,0,0,69,120,116,114,97,32,99,104,97,114,97,99,116,101,114,115,0,0,0,0,0,0,0,0,116,82,78,83,32,97,102,116,101,114,32,73,68,65,84,0,116,101,120,116,0,0,0,0,108,101,110,32,33,61,32,78,79,95,67,79,68,69,0,0,47,0,0,0,0,0,0,0,99,45,62,115,111,114,116,101,100,95,99,111,100,101,119,111,114,100,115,91,120,93,32,61,61,32,99,111,100,101,0,0,73,110,118,97,108,105,100,32,116,111,107,101,110,0,0,0,105,110,118,97,108,105,100,32,80,76,84,69,0,0,0,0,114,101,115,111,117,114,99,101,0,0,0,0,0,0,0,0,116,114,97,110,115,105,116,105,111,110,0,0,0,0,0,0,95,0,0,0,0,0,0,0,103,97,114,100,101,110,0,0,107,32,61,61,32,99,45,62,115,111,114,116,101,100,95,101,110,116,114,105,101,115,0,0,69,109,112,116,121,32,98,114,97,99,107,101,116,115,0,0,102,105,114,115,116,32,110,111,116,32,73,72,68,82,0,0,112,97,114,101,110,116,0,0,115,101,116,95,112,114,111,112,101,114,116,121,0,0,0,0,117,115,101,109,116,108,32,0,104,105,100,100,101,110,95,116,114,97,110,115,102,111,114,109,95,111,114,105,103,105,110,0,40,105,110,116,41,32,102,108,111,111,114,40,112,111,119,40,40,102,108,111,97,116,41,32,114,44,32,100,105,109,41,41,32,60,61,32,101,110,116,114,105,101,115,0,0,0,0,0,103,114,111,119,105,110,103,95,48,50,46,111,103,103,0,0,80,97,114,115,101,114,32,101,114,114,111,114,0,0,0,0,48,45,112,105,120,101,108,32,105,109,97,103,101,0,0,0,109,111,117,115,101,58,114,101,108,101,97,115,101,100,0,0,112,114,105,110,116,95,100,101,98,117,103,95,118,97,108,117,101,0,0,0,0,0,0,0,67,0,0,0,0,0,0,0,115,104,97,100,101,114,0,0,101,114,114,111,114,95,37,115,95,37,115,95,97,110,100,95,37,115,0,0,0,0,0,0,109,116,108,108,105,98,32,0,103,114,111,117,110,100,0,0,78,111,116,32,97,110,32,111,112,101,114,97,116,111,114,0,98,97,100,32,105,110,116,101,114,108,97,99,101,32,109,101,116,104,111,100,0,0,0,0,109,111,117,115,101,58,109,111,118,101,100,0,0,0,0,0,112,114,105,110,116,95,100,101,98,117,103,0,0,0,0,0,118,101,99,116,111,114,0,0,115,104,97,100,111,119,109,97,112,112,105,110,103,0,0,0,58,10,0,0,0,0,0,0,58,32,0,0,0,0,0,0,112,111,119,40,40,102,108,111,97,116,41,32,114,43,49,44,32,100,105,109,41,32,62,32,101,110,116,114,105,101,115,0,102,45,62,98,121,116,101,115,95,105,110,95,115,101,103,32,62,32,48,0,0,0,0,0,83,121,110,116,97,120,32,101,114,114,111,114,0,0,0,0,99,111,115,0,0,0,0,0,115,116,97,101,110,103,101,108,95,37,99,0,0,0,0,0,98,97,100,32,102,105,108,116,101,114,32,109,101,116,104,111,100,0,0,0,0,0,0,0,109,111,117,115,101,58,112,114,101,115,115,101,100,0,0,0,115,101,116,95,109,101,110,117,0,0,0,0,0,0,0,0,37,46,48,76,102,0,0,0,115,112,101,99,117,108,97,114,0,0,0,0,0,0,0,0,114,101,100,0,0,0,0,0,118,116,32,0,0,0,0,0,47,0,0,0,0,0,0,0,102,45,62,116,101,109,112,95,111,102,102,115,101,116,32,61,61,32,102,45,62,97,108,108,111,99,46,97,108,108,111,99,95,98,117,102,102,101,114,95,108,101,110,103,116,104,95,105,110,95,98,121,116,101,115,0,99,111,108,111,114,0,0,0,60,110,97,116,105,118,101,32,109,101,116,104,111,100,32,40,102,108,111,97,116,44,32,102,108,111,97,116,41,62,0,0,98,97,100,32,99,111,109,112,32,109,101,116,104,111,100,0,116,114,97,110,115,105,116,105,111,110,58,100,111,110,101,0,109,111,110,101,121,95,103,101,116,32,101,114,114,111,114,0,100,105,102,102,117,115,101,0,121,101,108,108,111,119,0,0,118,110,32,0,0,0,0,0,112,114,101,99,105,115,105,111,110,32,109,101,100,105,117,109,112,32,102,108,111,97,116,59,10,0,0,0,0,0,0,0,98,108,97,116,116,95,37,99,95,37,100,0,0,0,0,0,47,85,115,101,114,115,47,116,104,112,47,115,114,99,47,112,101,116,97,108,115,51,100,47,101,120,116,101,114,110,97,108,47,115,116,98,95,118,111,114,98,105,115,46,99,0,0,0,112,101,116,97,108,115,51,100,46,115,97,118,0,0,0,0,120,0,0,0,0,0,0,0,60,110,97,116,105,118,101,32,109,101,116,104,111,100,32,40,102,108,111,97,116,41,62,0,98,97,100,32,99,116,121,112,101,0,0,0,0,0,0,0,112,101,116,97,108,99,111,108,111,114,95,37,100,0,0,0,83,97,116,0,0,0,0,0,105,111,115,116,114,101,97,109,0,0,0,0,0,0,0,0,70,114,105,0,0,0,0,0,97,116,108,97,115,58,104,0,95,0,0,0,0,0,0,0,115,101,116,95,109,101,110,117,95,110,111,119,0,0,0,0,37,76,102,0,0,0,0,0,97,109,98,105,101,110,116,0,84,104,117,0,0,0,0,0,105,109,112,108,105,99,105,116,58,104,101,105,103,104,116,0,98,114,111,119,110,0,0,0,87,101,100,0,0,0,0,0,84,117,101,0,0,0,0,0,37,48,50,100,58,37,48,50,100,0,0,0,0,0,0,0,77,111,110,0,0,0,0,0,98,117,102,95,99,32,61,61,32,50,0,0,0,0,0,0,116,114,97,110,115,105,116,105,111,110,58,111,117,116,0,0,83,117,110,0,0,0,0,0,83,97,116,117,114,100,97,121,0,0,0,0,0,0,0,0,70,114,105,100,97,121,0,0,60,110,97,116,105,118,101,32,109,101,116,104,111,100,32,40,41,62,0,0,0,0,0,0,84,104,117,114,115,100,97,121,0,0,0,0,0,0,0,0,87,101,100,110,101,115,100,97,121,0,0,0,0,0,0,0,56,98,105,116,32,111,110,108,121,0,0,0,0,0,0,0,119,98,0,0,0,0,0,0,97,116,108,97,115,58,119,0,84,117,101,115,100,97,121,0,114,101,108,0,0,0,0,0,115,104,97,100,111,119,109,97,112,0,0,0,0,0,0,0,77,111,110,100,97,121,0,0,99,111,114,101,0,0,0,0,118,116,120,99,111,111,114,100,0,0,0,0,0,0,0,0,83,117,110,100,97,121,0,0,107,101,114,110,95,37,100,0,83,0,0,0,97,0,0,0,116,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,0,0,0,0,37,100,47,37,100,47,37,100,0,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,0,0,0,0,114,98,0,0,0,0,0,0,111,118,101,114,115,104,111,111,116,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,112,117,114,112,108,101,0,0,116,111,111,32,108,97,114,103,101,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,0,0,0,0,117,110,115,112,101,99,105,102,105,101,100,32,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,32,101,114,114,111,114,0,0,0,0,0,97,116,108,97,115,58,121,0,83,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,112,114,101,115,115,101,100,0,109,115,118,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,117,0,0,0,114,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,37,100,47,47,37,100,0,0,100,114,111,112,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,114,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,115,116,97,101,110,103,101,108,46,111,98,106,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,110,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,100,101,115,101,108,101,99,116,50,46,111,103,103,0,0,0,98,97,100,32,83,79,83,0,77,0,0,0,111,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,98,97,100,32,65,67,32,104,117,102,102,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,98,97,100,32,68,67,32,104,117,102,102,0,0,0,0,0,101,97,115,101,73,110,66,97,99,107,0,0,0,0,0,0,98,97,100,32,83,79,83,32,108,101,110,0,0,0,0,0,68,101,99,0,0,0,0,0,98,97,100,32,73,72,68,82,32,108,101,110,0,0,0,0,98,97,100,32,83,79,83,32,99,111,109,112,111,110,101,110,116,32,99,111,117,110,116,0,78,111,118,0,0,0,0,0,97,116,108,97,115,58,120,0,40,40,40,106,45,62,99,111,100,101,95,98,117,102,102,101,114,41,32,62,62,32,40,51,50,32,45,32,104,45,62,115,105,122,101,91,99,93,41,41,32,38,32,98,109,97,115,107,91,104,45,62,115,105,122,101,91,99,93,93,41,32,61,61,32,104,45,62,99,111,100,101,91,99,93,0,0,0,0,0,112,111,115,0,0,0,0,0,79,99,116,0,0,0,0,0,109,111,100,101,108,0,0,0,98,97,100,32,114,101,113,95,99,111,109,112,0,0,0,0,83,101,112,0,0,0,0,0,115,112,105,107,121,0,0,0,110,101,119,109,116,108,32,0,98,97,100,32,109,97,115,107,115,0,0,0,0,0,0,0,65,117,103,0,0,0,0,0,98,97,100,32,98,112,112,0,115,101,116,95,109,101,110,117,40,103,97,109,101,112,108,97,121,41,0,0,0,0,0,0,101,110,0,0,0,0,0,0,100,97,116,97,47,37,115,0,102,105,108,108,95,98,105,116,115,0,0,0,0,0,0,0,98,109,112,95,108,111,97,100,0,0,0,0,0,0,0,0,100,101,99,111,100,101,0,0,99,111,100,101,98,111,111,107,95,100,101,99,111,100,101,95,100,101,105,110,116,101,114,108,101,97,118,101,95,114,101,112,101,97,116,0,0,0,0,0,99,111,110,118,101,114,116,95,99,104,97,110,110,101,108,115,95,115,104,111,114,116,95,105,110,116,101,114,108,101,97,118,101,100,0,0,0,0,0,0,99,111,100,101,98,111,111,107,95,100,101,99,111,100,101,95,115,99,97,108,97,114,95,114,97,119,0,0,0,0,0,0,118,111,114,98,105,115,95,100,101,99,111,100,101,95,112,97,99,107,101,116,95,114,101,115,116,0,0,0,0,0,0,0,112,97,114,115,101,95,117,110,99,111,109,112,114,101,115,115,101,100,95,98,108,111,99,107,0,0,0,0,0,0,0,0,105,109,100,99,116,95,115,116,101,112,51,95,105,116,101,114,48,95,108,111,111,112,0,0,99,111,109,112,117,116,101,95,115,111,114,116,101,100,95,104,117,102,102,109,97,110,0,0,118,111,114,98,105,115,95,100,101,99,111,100,101,95,105,110,105,116,105,97,108,0,0,0,99,111,109,112,117,116,101,95,104,117,102,102,109,97,110,95,99,111,100,101,115,0,0,0,99,111,100,101,98,111,111,107,95,100,101,99,111,100,101,95,115,116,97,114,116,0,0,0,99,114,101,97,116,101,95,112,110,103,95,105,109,97,103,101,95,114,97,119,0,0,0,0,99,111,109,112,117,116,101,95,116,114,97,110,115,112,97,114,101,110,99,121,0,0,0,0,99,111,109,112,117,116,101,95,99,111,100,101,119,111,114,100,115,0,0,0,0,0,0,0,122,104,117,102,102,109,97,110,95,100,101,99,111,100,101,0,105,110,99,108,117,100,101,95,105,110,95,115,111,114,116,0,103,101,116,56,95,112,97,99,107,101,116,95,114,97,119,0,122,98,117,105,108,100,95,104,117,102,102,109,97,110,0,0,115,116,98,105,95,100,101,95,105,112,104,111,110,101,0,0,108,111,111,107,117,112,49,95,118,97,108,117,101,115,0,0,99,111,110,118,101,114,116,95,102,111,114,109,97,116,0,0,115,116,97,114,116,95,100,101,99,111,100,101,114,0,0,0,110,101,120,116,95,115,101,103,109,101,110,116,0,0,0,0,103,101,116,95,119,105,110,100,111,119,0,0,0,0,0,0,0,0,0,0,72,54,0,0,14,1,0,0,54,1,0,0,84,0,0,0,128,0,0,0,234,1,0,0,108,0,0,0,42,0,0,0,90,0,0,0,212,0,0,0,0,0,0,0,0,0,0,0,88,54,0,0,56,0,0,0,82,0,0,0,10,0,0,0,122,0,0,0,204,0,0,0,110,1,0,0,74,2,0,0,80,0,0,0,110,0,0,0,0,0,0,0,0,0,0,0,104,54,0,0,98,1,0,0,76,1,0,0,124,0,0,0,90,0,0,0,90,2,0,0,80,1,0,0,2,0,0,0,24,0,0,0,142,0,0,0,0,0,0,0,0,0,0,0,120,54,0,0,84,1,0,0,76,0,0,0,150,0,0,0,118,0,0,0,206,1,0,0,76,2,0,0,6,0,0,0,6,0,0,0,108,0,0,0,0,0,0,0,0,0,0,0,136,54,0,0,16,1,0,0,222,0,0,0,154,0,0,0,112,0,0,0,30,0,0,0,52,0,0,0,2,0,0,0,4,0,0,0,214,0,0,0,0,0,0,0,0,0,0,0,152,54,0,0,166,0,0,0,38,2,0,0,202,0,0,0,10,0,0,0,12,2,0,0,66,0,0,0,110,0,0,0,74,0,0,0,66,0,0,0,0,0,0,0,0,0,0,0,168,54,0,0,162,0,0,0,2,1,0,0,34,0,0,0,32,0,0,0,180,1,0,0,162,1,0,0,12,0,0,0,46,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,184,54,0,0,70,2,0,0,102,1,0,0,180,0,0,0,82,0,0,0,46,2,0,0,196,1,0,0,132,0,0,0,36,0,0,0,94,0,0,0,0,0,0,0,0,0,0,0,200,54,0,0,112,0,0,0,38,1,0,0,112,0,0,0,154,0,0,0,212,1,0,0,152,0,0,0,212,0,0,0,64,0,0,0,118,0,0,0,0,0,0,0,0,0,0,0,216,54,0,0,210,1,0,0,226,1,0,0,218,0,0,0,80,0,0,0,102,0,0,0,34,0,0,0,200,0,0,0,56,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,232,54,0,0,72,1,0,0,166,1,0,0,44,0,0,0,52,0,0,0,154,1,0,0,120,1,0,0,20,2,0,0,38,0,0,0,162,0,0,0,0,0,0,0,0,0,0,0,248,54,0,0,68,2,0,0,52,1,0,0,50,0,0,0,54,0,0,0,160,1,0,0,34,2,0,0,72,2,0,0,72,0,0,0,58,0,0,0,0,0,0,0,0,0,0,0,8,55,0,0,90,1,0,0,14,2,0,0,138,0,0,0,14,0,0,0,242,0,0,0,130,1,0,0,12,0,0,0,76,0,0,0,182,0,0,0,0,0,0,0,0,0,0,0,24,55,0,0,128,0,0,0,2,2,0,0,134,0,0,0,174,0,0,0,230,1,0,0,106,0,0,0,22,0,0,0,40,0,0,0,146,0,0,0,0,0,0,0,0,0,0,0,40,55,0,0,228,1,0,0,182,1,0,0,136,0,0,0,22,0,0,0,236,1,0,0,12,1,0,0,6,1,0,0,42,0,0,0,24,0,0,0,0,0,0,0,0,0,0,0,56,55,0,0,68,0,0,0,40,2,0,0,220,0,0,0,138,0,0,0,96,2,0,0,16,0,0,0,6,0,0,0,20,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,72,55,0,0,78,0,0,0,232,0,0,0,224,0,0,0,86,0,0,0,114,1,0,0,188,0,0,0,18,0,0,0,10,0,0,0,114,0,0,0,0,0,0,0,0,0,0,0,88,55,0,0,54,0,0,0,80,0,0,0,190,0,0,0,96,0,0,0,188,1,0,0,206,0,0,0,198,0,0,0,8,0,0,0,68,0,0,0,0,0,0,0,0,0,0,0,104,55,0,0,66,1,0,0,158,1,0,0,192,0,0,0,62,0,0,0,178,1,0,0,72,0,0,0,2,0,0,0,98,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,120,55,0,0,46,0,0,0,146,0,0,0,122,0,0,0,6,0,0,0,222,1,0,0,84,0,0,0,16,0,0,0,84,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,136,55,0,0,8,0,0,0,138,0,0,0,26,0,0,0,4,0,0,0,212,0,0,0,32,1,0,0,14,0,0,0,34,0,0,0,14,0,0,0,0,0,0,0,90,90,78,55,73,110,105,70,105,108,101,53,112,97,114,115,101,69,80,75,99,80,49,52,73,110,105,70,105,108,101,72,97,110,100,108,101,114,69,78,75,51,36,95,48,99,108,69,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,53,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,53,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,85,108,82,75,83,66,95,69,95,0,0,0,0,0,0,90,90,78,52,77,101,110,117,56,111,110,65,99,116,105,111,110,69,80,54,65,99,116,105,111,110,69,78,75,51,36,95,49,99,108,69,118,69,85,108,118,69,95,0,0,0,0,0,90,78,56,82,101,110,100,101,114,101,114,52,108,111,97,100,69,80,54,70,105,108,101,73,79,80,55,84,101,120,116,117,114,101,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,52,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,52,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,48,0,90,78,56,69,120,112,114,101,115,115,111,54,101,97,115,105,110,103,69,118,69,51,36,95,49,95,48,0,0,0,0,0,90,78,56,69,120,112,114,101,115,115,111,54,101,97,115,105,110,103,69,118,69,51,36,95,48,0,0,0,0,0,0,0,90,78,55,73,110,105,70,105,108,101,53,112,97,114,115,101,69,80,75,99,80,49,52,73,110,105,70,105,108,101,72,97,110,100,108,101,114,69,51,36,95,48,0,0,0,0,0,0,90,78,54,70,105,108,101,73,79,49,49,115,116,114,101,97,109,76,105,110,101,115,69,82,75,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,48,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,48,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,78,83,48,95,56,102,117,110,99,116,105,111,110,73,70,118,83,54,95,69,69,69,98,98,69,51,36,95,48,0,0,90,78,54,65,99,116,105,111,110,67,49,69,80,49,52,83,99,101,110,101,71,114,97,112,104,78,111,100,101,82,75,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,50,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,50,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,48,0,0,0,0,90,78,53,79,79,66,74,74,67,49,69,80,54,70,105,108,101,73,79,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,50,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,50,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,49,0,0,0,0,0,0,0,0,90,78,53,79,77,65,84,74].concat([67,49,69,80,54,70,105,108,101,73,79,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,50,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,50,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,48,0,0,0,0,0,0,0,0,90,78,52,77,101,110,117,67,49,69,80,54,70,105,108,101,73,79,82,75,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,50,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,50,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,80,49,51,65,99,116,105,111,110,72,97,110,100,108,101,114,80,52,73,49,56,78,69,51,36,95,48,0,90,78,52,77,101,110,117,56,111,110,65,99,116,105,111,110,69,80,54,65,99,116,105,111,110,69,51,36,95,49,0,0,90,78,52,73,49,56,78,67,49,69,80,54,70,105,108,101,73,79,80,75,99,83,51,95,69,51,36,95,48,0,0,0,90,78,52,71,97,109,101,56,111,110,65,99,116,105,111,110,69,80,54,65,99,116,105,111,110,69,51,36,95,50,0,0,90,78,52,71,97,109,101,54,114,101,110,100,101,114,69,118,69,51,36,95,49,0,0,0,90,78,52,71,97,109,101,49,57,111,110,95,118,97,108,105,100,97,116,105,111,110,95,101,114,114,111,114,69,78,83,116,51,95,95,49,52,108,105,115,116,73,78,54,80,101,116,97,108,115,49,53,86,97,108,105,100,97,116,105,111,110,69,114,114,111,114,69,78,83,48,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,69,69,69,51,36,95,48,0,90,78,50,48,83,68,76,77,105,120,101,114,65,117,100,105,111,67,111,110,116,101,120,116,55,112,114,101,108,111,97,100,69,80,54,70,105,108,101,73,79,82,75,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,50,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,50,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,48,0,0,0,0,0,0,0,0,90,78,49,52,83,99,101,110,101,71,114,97,112,104,78,111,100,101,57,115,101,116,65,99,116,105,111,110,69,82,75,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,48,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,48,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,83,56,95,69,51,36,95,48,0,90,78,49,48,83,99,101,110,101,71,114,97,112,104,67,49,69,80,83,95,69,51,36,95,49,0,0,0,0,0,0,0,90,76,49,51,98,117,105,108,100,95,112,114,111,103,114,97,109,80,54,70,105,108,101,73,79,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,49,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,49,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,50,95,48,0,0,0,0,0,0,0,0,90,76,49,51,98,117,105,108,100,95,112,114,111,103,114,97,109,80,54,70,105,108,101,73,79,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,49,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,49,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,49,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,90,78,55,73,110,105,70,105,108,101,53,112,97,114,115,101,69,80,75,99,80,49,52,73,110,105,70,105,108,101,72,97,110,100,108,101,114,69,78,75,51,36,95,48,99,108,69,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,85,108,82,75,83,68,95,69,95,78,83,66,95,73,83,71,95,69,69,70,118,83,70,95,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,90,78,52,77,101,110,117,56,111,110,65,99,116,105,111,110,69,80,54,65,99,116,105,111,110,69,78,75,51,36,95,49,99,108,69,118,69,85,108,118,69,95,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,54,95,69,69,70,118,118,69,69,69,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,56,82,101,110,100,101,114,101,114,52,108,111,97,100,69,80,54,70,105,108,101,73,79,80,55,84,101,120,116,117,114,101,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,48,78,83,65,95,73,83,68,95,69,69,70,118,80,99,106,69,69,69,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,56,69,120,112,114,101,115,115,111,54,101,97,115,105,110,103,69,118,69,51,36,95,49,95,48,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,70,102,102,69,69,69,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,56,69,120,112,114,101,115,115,111,54,101,97,115,105,110,103,69,118,69,51,36,95,48,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,70,102,102,69,69,69,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,55,73,110,105,70,105,108,101,53,112,97,114,115,101,69,80,75,99,80,49,52,73,110,105,70,105,108,101,72,97,110,100,108,101,114,69,51,36,95,48,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,55,95,69,69,70,118,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,56,95,73,99,69,69,69,69,69,69,69,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,54,70,105,108,101,73,79,49,49,115,116,114,101,97,109,76,105,110,101,115,69,82,75,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,78,83,95,56,102,117,110,99,116,105,111,110,73,70,118,83,56,95,69,69,69,98,98,69,51,36,95,48,78,83,54,95,73,83,69,95,69,69,70,118,80,99,106,69,69,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,54,65,99,116,105,111,110,67,49,69,80,49,52,83,99,101,110,101,71,114,97,112,104,78,111,100,101,82,75,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,48,78,83,56,95,73,83,68,95,69,69,70,118,83,67,95,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,53,79,79,66,74,74,67,49,69,80,54,70,105,108,101,73,79,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,49,78,83,56,95,73,83,66,95,69,69,70,118,83,65,95,69,69,69,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,53,79,77,65,84,74,67,49,69,80,54,70,105,108,101,73,79,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,48,78,83,56,95,73,83,66,95,69,69,70,118,83,65,95,69,69,69,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,52,77,101,110,117,67,49,69,80,54,70,105,108,101,73,79,82,75,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,80,49,51,65,99,116,105,111,110,72,97,110,100,108,101,114,80,52,73,49,56,78,69,51,36,95,48,78,83,56,95,73,83,72,95,69,69,70,118,118,69,69,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,52,77,101,110,117,56,111,110,65,99,116,105,111,110,69,80,54,65,99,116,105,111,110,69,51,36,95,49,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,53,95,69,69,70,118,118,69,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,52,73,49,56,78,67,49,69,80,54,70,105,108,101,73,79,80,75,99,83,54,95,69,51,36,95,48,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,55,95,69,69,70,118,83,54,95,83,54,95,83,54,95,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,52,71,97,109,101,56,111,110,65,99,116,105,111,110,69,80,54,65,99,116,105,111,110,69,51,36,95,50,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,53,95,69,69,70,118,80,99,106,69,69,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,52,71,97,109,101,54,114,101,110,100,101,114,69,118,69,51,36,95,49,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,70,118,118,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,52,71,97,109,101,49,57,111,110,95,118,97,108,105,100,97,116,105,111,110,95,101,114,114,111,114,69,78,83,95,52,108,105,115,116,73,78,54,80,101,116,97,108,115,49,53,86,97,108,105,100,97,116,105,111,110,69,114,114,111,114,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,53,95,69,69,69,69,69,51,36,95,48,78,83,54,95,73,83,57,95,69,69,70,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,54,95,73,99,69,69,69,69,80,75,99,69,69,69,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,50,48,83,68,76,77,105,120,101,114,65,117,100,105,111,67,111,110,116,101,120,116,55,112,114,101,108,111,97,100,69,80,54,70,105,108,101,73,79,82,75,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,48,78,83,56,95,73,83,68,95,69,69,70,118,80,99,106,69,69,69,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,49,52,83,99,101,110,101,71,114,97,112,104,78,111,100,101,57,115,101,116,65,99,116,105,111,110,69,82,75,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,83,65,95,69,51,36,95,48,78,83,54,95,73,83,66,95,69,69,70,118,83,65,95,69,69,69,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,49,48,83,99,101,110,101,71,114,97,112,104,67,49,69,80,83,50,95,69,51,36,95,49,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,52,95,69,69,70,102,118,69,69,69,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,76,49,51,98,117,105,108,100,95,112,114,111,103,114,97,109,80,54,70,105,108,101,73,79,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,50,95,48,78,83,55,95,73,83,65,95,69,69,70,118,80,99,106,69,69,69,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,76,49,51,98,117,105,108,100,95,112,114,111,103,114,97,109,80,54,70,105,108,101,73,79,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,51,36,95,49,78,83,55,95,73,83,65,95,69,69,70,118,80,99,106,69,69,69,0,0,0,0,0,0,0,56,37,0,0,0,0,0,0,184,37,0,0,0,0,0,0,232,37,0,0,0,0,0,0,80,38,0,0,0,0,0,0,112,38,0,0,0,0,0,0,144,38,0,0,0,0,0,0,192,38,0,0,0,0,0,0,56,39,0,0,0,0,0,0,160,39,0,0,0,0,0,0,0,40,0,0,0,0,0,0,96,40,0,0,0,0,0,0,208,40,0,0,0,0,0,0,240,40,0,0,0,0,0,0,16,41,0,0,0,0,0,0,48,41,0,0,0,0,0,0,72,41,0,0,0,0,0,0,168,41,0,0,0,0,0,0,32,42,0,0,0,0,0,0,136,42,0,0,0,0,0,0,168,42,0,0,0,0,0,0,16,43,0,0,0,0,0,0,112,43,0,0,232,99,0,0,0,0,0,0,0,0,0,0,24,44,0,0,224,99,0,0,0,0,0,0,0,0,0,0,120,44,0,0,240,99,0,0,0,0,0,0,0,0,0,0,8,45,0,0,24,100,0,0,0,0,0,0,0,0,0,0,88,45,0,0,24,100,0,0,0,0,0,0,0,0,0,0,168,45,0,0,0,100,0,0,0,0,0,0,0,0,0,0,56,46,0,0,240,99,0,0,0,0,0,0,0,0,0,0,216,46,0,0,232,99,0,0,0,0,0,0,0,0,0,0,104,47,0,0,0,100,0,0,0,0,0,0,0,0,0,0,232,47,0,0,0,100,0,0,0,0,0,0,0,0,0,0,104,48,0,0,224,99,0,0,0,0,0,0,0,0,0,0,0,49,0,0,224,99,0,0,0,0,0,0,0,0,0,0,88,49,0,0,248,99,0,0,0,0,0,0,0,0,0,0,184,49,0,0,240,99,0,0,0,0,0,0,0,0,0,0,16,50,0,0,224,99,0,0,0,0,0,0,0,0,0,0,96,50,0,0,32,100,0,0,0,0,0,0,0,0,0,0,24,51,0,0,240,99,0,0,0,0,0,0,0,0,0,0,176,51,0,0,232,99,0,0,0,0,0,0,0,0,0,0,64,52,0,0,8,100,0,0,0,0,0,0,0,0,0,0,144,52,0,0,240,99,0,0,0,0,0,0,0,0,0,0,24,53,0,0,240,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,0,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,0,0,0,0,0,0,37,0,0,0,89,0,0,0,45,0,0,0,37,0,0,0,109,0,0,0,45,0,0,0,37,0,0,0,100,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,0,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,72,58,37,77,58,37,83,37,72,58,37,77,0,0,0,37,73,58,37,77,58,37,83,32,37,112,0,0,0,0,0,37,89,45,37,109,45,37,100,37,109,47,37,100,47,37,121,37,72,58,37,77,58,37,83,37,0,0,0,0,0,0,0,37,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,42,47,43,45,44,0,0,0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4,0,1,0,0,128,0,0,0,86,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,4,0,0,0,16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,4,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,137,80,78,71,13,10,26,10,118,111,114,98,105,115,0,0,88,88,88,88,32,99,104,117,110,107,32,110,111,116,32,107,110,111,119,110,0,0,0,0,0,0,0,0,152,93,0,0,64,0,0,0,248,0,0,0,222,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,93,0,0,194,1,0,0,104,1,0,0,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,93,0,0,158,0,0,0,58,2,0,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,93,0,0,32,0,0,0,48,0,0,0,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,93,0,0,32,0,0,0,20,0,0,0,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,93,0,0,32,0,0,0,38,0,0,0,186,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,94,0,0,118,1,0,0,176,0,0,0,110,0,0,0,2,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,94,0,0,78,2,0,0,152,1,0,0,110,0,0,0,4,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,94,0,0,134,1,0,0,156,1,0,0,110,0,0,0,8,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,94,0,0,96,1,0,0,58,1,0,0,110,0,0,0,6,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,95,0,0,66,2,0,0,194,0,0,0,110,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,95,0,0,100,1,0,0,238,0,0,0,110,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,95,0,0,90,0,0,0,240,0,0,0,110,0,0,0,206,0,0,0,4,0,0,0,36,0,0,0,6,0,0,0,22,0,0,0,60,0,0,0,2,0,0,0,248,255,255,255,96,95,0,0,30,0,0,0,78,0,0,0,60,0,0,0,16,0,0,0,2,0,0,0,54,0,0,0,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,95,0,0,50,2,0,0,18,2,0,0,110,0,0,0,28,0,0,0,18,0,0,0,64,0,0,0,28,0,0,0,20,0,0,0,2,0,0,0,4,0,0,0,248,255,255,255,136,95,0,0,120,0,0,0,178,0,0,0,198,0,0,0,210,0,0,0,168,0,0,0,82,0,0,0,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,95,0,0,170,0,0,0,96,0,0,0,110,0,0,0,86,0,0,0,76,0,0,0,20,0,0,0,106,0,0,0,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,95,0,0,216,0,0,0,48,2,0,0,110,0,0,0,80,0,0,0,144,0,0,0,28,0,0,0,140,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,95,0,0,56,2,0,0,4,0,0,0,110,0,0,0,28,0,0,0,34,0,0,0,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,95,0,0,104,0,0,0,10,0,0,0,110,0,0,0,46,0,0,0,12,0,0,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,96,0,0,244,1,0,0,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,96,0,0,62,0,0,0,56,1,0,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,96,0,0,14,0,0,0,126,1,0,0,110,0,0,0,20,0,0,0,6,0,0,0,14,0,0,0,4,0,0,0,12,0,0,0,4,0,0,0,2,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,96,0,0,210,0,0,0,80,2,0,0,110,0,0,0,24,0,0,0,18,0,0,0,42,0,0,0,26,0,0,0,40,0,0,0,8,0,0,0,6,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,96,0,0,92,0,0,0,44,0,0,0,110,0,0,0,54,0,0,0,52,0,0,0,38,0,0,0,48,0,0,0,34,0,0,0,24,0,0,0,46,0,0,0,58,0,0,0,56,0,0,0,44,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,96,0,0,116,0,0,0,6,0,0,0,110,0,0,0,76,0,0,0,8,0,0,0,68,0,0,0,70,0,0,0,62,0,0,0,72,0,0,0,66,0,0,0,32,0,0,0,74,0,0,0,30,0,0,0,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,96,0,0,164,0,0,0,192,0,0,0,110,0,0,0,16,0,0,0,18,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,96,0,0,58,0,0,0,132,1,0,0,110,0,0,0,24,0,0,0,26,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,96,0,0,24,0,0,0,150,1,0,0,110,0,0,0,4,0,0,0,10,0,0,0,22,0,0,0,204,0,0,0,172,0,0,0,32,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,96,0,0,142,1,0,0,40,1,0,0,110,0,0,0,12,0,0,0,16,0,0,0,26,0,0,0,56,0,0,0,8,0,0,0,28,0,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,97,0,0,142,1,0,0,40,0,0,0,110,0,0,0,2,0,0,0,6,0,0,0,8,0,0,0,170,0,0,0,104,0,0,0,20,0,0,0,216,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,97,0,0,142,1,0,0,220,0,0,0,110,0,0,0,14,0,0,0,8,0,0,0,30,0,0,0,52,0,0,0,152,0,0,0,18,0,0,0,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,97,0,0,142,1,0,0,74,0,0,0,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,97,0,0,126,0,0,0,88,1,0,0,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,97,0,0,142,1,0,0,172,0,0,0,110,0,0,0,24,0,0,0,6,0,0,0,2,0,0,0,8,0,0,0,30,0,0,0,34,0,0,0,68,0,0,0,4,0,0,0,16,0,0,0,10,0,0,0,10,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,97,0,0,84,2,0,0,86,0,0,0,110,0,0,0,58,0,0,0,8,0,0,0,50,0,0,0,44,0,0,0,22,0,0,0,4,0,0,0,30,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,97,0,0,150,0,0,0,4,2,0,0,130,0,0,0,42,0,0,0,16,0,0,0,40,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,97,0,0,4,1,0,0,46,1,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,97,0,0,142,1,0,0,180,0,0,0,110,0,0,0,14,0,0,0,8,0,0,0,30,0,0,0,52,0,0,0,152,0,0,0,18,0,0,0,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,97,0,0,142,1,0,0,42,2,0,0,110,0,0,0,14,0,0,0,8,0,0,0,30,0,0,0,52,0,0,0,152,0,0,0,18,0,0,0,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,97,0,0,28,1,0,0,24,1,0,0,38,0,0,0,26,0,0,0,14,0,0,0,20,0,0,0,156,0,0,0,174,0,0,0,42,0,0,0,42,0,0,0,40,0,0,0,18,0,0,0,52,0,0,0,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,0,0,22,0,0,0,250,0,0,0,150,0,0,0,48,0,0,0,28,0,0,0,14,0,0,0,88,0,0,0,148,0,0,0,22,0,0,0,6,0,0,0,12,0,0,0,92,0,0,0,20,0,0,0,62,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,48,98,0,0,98,0,0,0,224,1,0,0,252,255,255,255,252,255,255,255,48,98,0,0,62,1,0,0,26,1,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,72,98,0,0,248,1,0,0,36,2,0,0,252,255,255,255,252,255,255,255,72,98,0,0,236,0,0,0,200,1,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,96,98,0,0,184,0,0,0,88,2,0,0,248,255,255,255,248,255,255,255,96,98,0,0,242,1,0,0,32,2,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,120,98,0,0,230,0,0,0,208,1,0,0,248,255,255,255,248,255,255,255,120,98,0,0,44,1,0,0,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,98,0,0,204,1,0,0,144,1,0,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,98,0,0,74,1,0,0,26,2,0,0,8,0,0,0,26,0,0,0,14,0,0,0,20,0,0,0,96,0,0,0,174,0,0,0,42,0,0,0,42,0,0,0,40,0,0,0,18,0,0,0,38,0,0,0,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,98,0,0,82,1,0,0,136,1,0,0,88,0,0,0,48,0,0,0,28,0,0,0,14,0,0,0,158,0,0,0,148,0,0,0,22,0,0,0,6,0,0,0,12,0,0,0,92,0,0,0,50,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,98,0,0,6,2,0,0,60,1,0,0,110,0,0,0,116,0,0,0,200,0,0,0,114,0,0,0,176,0,0,0,16,0,0,0,72,0,0,0,90,0,0,0,46,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,99,0,0,226,0,0,0,122,0,0,0,110,0,0,0,188,0,0,0,196,0,0,0,162,0,0,0,190,0,0,0,194,0,0,0,58,0,0,0,194,0,0,0,136,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,99,0,0,22,2,0,0,246,0,0,0,110,0,0,0,18,0,0,0,102,0,0,0,18,0,0,0,116,0,0,0,214,0,0,0,168,0,0,0,166,0,0,0,142,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,99,0,0,168,0,0,0,124,1,0,0,110,0,0,0,176,0,0,0,184,0,0,0,70,0,0,0,182,0,0,0,60,0,0,0,40,0,0,0,132,0,0,0,180,0,0,0,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,99,0,0,186,0,0,0,28,2,0,0,144,0,0,0,26,0,0,0,14,0,0,0,20,0,0,0,156,0,0,0,174,0,0,0,42,0,0,0,126,0,0,0,140,0,0,0,26,0,0,0,52,0,0,0,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,99,0,0,28,0,0,0,252,1,0,0,160,0,0,0,48,0,0,0,28,0,0,0,14,0,0,0,88,0,0,0,148,0,0,0,22,0,0,0,20,0,0,0,38,0,0,0,14,0,0,0,20,0,0,0,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,99,0,0,208,0,0,0,50,1,0,0,208,0,0,0,76,0,0,0,190,0,0,0,200,0,0,0,30,0,0,0,52,0,0,0,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,99,0,0,30,2,0,0,186,1,0,0,4,0,0,0,66,0,0,0,198,1,0,0,36,0,0,0,2,0,0,0,48,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,99,0,0,106,1,0,0,64,1,0,0,74,0,0,0,26,0,0,0,246,1,0,0,220,1,0,0,4,0,0,0,12,0,0,0,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,100,0,0,152,0,0,0,238,1,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,100,0,0,60,2,0,0,182,0,0,0,136,0,0,0,8,2,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,100,0,0,60,2,0,0,214,0,0,0,136,0,0,0,8,2,0,0,6,0,0,0,2,0,0,0,10,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,100,0,0,60,2,0,0,134,0,0,0,136,0,0,0,8,2,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,100,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,100,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,100,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,100,0,0,36,1,0,0,24,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,0,0,174,1,0,0,146,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,101,0,0,164,1,0,0,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,101,0,0,146,0,0,0,82,0,0,0,252,255,255,255,40,101,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,101,0,0,84,0,0,0,186,0,0,0,188,0,0,0,166,0,0,0,2,0,0,0,8,0,0,0,224,0,0,0,160,0,0,0,130,0,0,0,78,0,0,0,252,255,255,255,72,101,0,0,56,0,0,0,248,255,255,255,72,101,0,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,101,0,0,172,0,0,0,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,101,0,0,156,0,0,0,50,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,101,0,0,50,0,0,0,202,0,0,0,62,0,0,0,52,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,101,0,0,112,1,0,0,118,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,101,0,0,178,0,0,0,78,1,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,101,0,0,0,2,0,0,196,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,101,0,0,0,2,0,0,124,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,101,0,0,78,0,0,0,218,0,0,0,94,2,0,0,2,0,0,0,216,0,0,0,104,0,0,0,204,0,0,0,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,0,0,0,2,0,0,234,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,102,0,0,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,102,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,102,0,0,112,1,0,0,22,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,102,0,0,0,2,0,0,148,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,102,0,0,98,0,0,0,44,0,0,0,148,1,0,0,206,0,0,0,156,0,0,0,52,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,102,0,0,102,0,0,0,10,1,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,102,0,0,24,0,0,0,16,2,0,0,8,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,102,0,0,48,0,0,0,100,0,0,0,18,0,0,0,10,0,0,0,148,0,0,0,104,0,0,0,204,0,0,0,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,102,0,0,94,0,0,0,108,1,0,0,86,2,0,0,4,0,0,0,148,0,0,0,104,0,0,0,204,0,0,0,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,102,0,0,232,1,0,0,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,102,0,0,254,0,0,0,10,2,0,0,18,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,102,0,0,68,0,0,0,94,0,0,0,68,1,0,0,2,0,0,0,126,0,0,0,104,0,0,0,204,0,0,0,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,102,0,0,120,0,0,0,190,1,0,0,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,118,0,0,0,0,0,0,0,90,78,54,66,117,102,102,101,114,67,49,69,80,54,70,105,108,101,73,79,78,83,116,51,95,95,49,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,50,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,50,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,85,108,80,99,106,69,95,0,0,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,83,116,56,98,97,100,95,99,97,115,116,0,0,0,0,0,83,116,49,51,114,117,110,116,105,109,101,95,101,114,114,111,114,0,0,0,0,0,0,0,83,116,49,50,111,117,116,95,111,102,95,114,97,110,103,101,0,0,0,0,0,0,0,0,83,116,49,50,108,101,110,103,116,104,95,101,114,114,111,114,0,0,0,0,0,0,0,0,83,116,49,49,108,111,103,105,99,95,101,114,114,111,114,0,80,70,102,102,102,69,0,0,80,70,102,102,69,0,0,0,78,83,116,51,95,95,49,57,116,105,109,101,95,98,97,115,101,69,0,0,0,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,119,69,69,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,99,69,69,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,119,69,69,0,0,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,99,69,69,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,119,69,69,0,0,0,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,99,69,69,0,0,0,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,119,69,69,0,0,0,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,99,69,69,0,0,0,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,55,102,97,105,108,117,114,101,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55])
.concat([99,111,108,108,97,116,101,73,119,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,99,69,69,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,119,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,99,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,115,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,105,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,102,97,99,101,116,69,0,0,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,95,95,105,109,112,69,0,0,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,119,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,99,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,119,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,99,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,57,95,95,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,69,0,0,0,78,83,116,51,95,95,49,49,55,98,97,100,95,102,117,110,99,116,105,111,110,95,99,97,108,108,69,0,0,0,0,0,78,83,116,51,95,95,49,49,55,95,95,119,105,100,101,110,95,102,114,111,109,95,117,116,102,56,73,76,106,51,50,69,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,49,54,95,95,110,97,114,114,111,119,95,116,111,95,117,116,102,56,73,76,106,51,50,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,101,114,114,111,114,95,99,97,116,101,103,111,114,121,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,95,95,115,104,97,114,101,100,95,99,111,117,110,116,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,112,117,116,95,98,97,115,101,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,103,101,116,95,98,97,115,101,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,51,109,101,115,115,97,103,101,115,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,0,78,83,116,51,95,95,49,49,50,115,121,115,116,101,109,95,101,114,114,111,114,69,0,0,78,83,116,51,95,95,49,49,50,99,111,100,101,99,118,116,95,98,97,115,101,69,0,0,78,83,116,51,95,95,49,49,50,95,95,100,111,95,109,101,115,115,97,103,101,69,0,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,119,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,99,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,119,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,99,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,119,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,99,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,49,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,48,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,49,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,48,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,95,98,97,115,101,69,0,0,0,0,78,83,116,51,95,95,49,49,48,99,116,121,112,101,95,98,97,115,101,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,116,105,109,101,95,112,117,116,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,119,69,69,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,99,69,69,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,90,78,54,66,117,102,102,101,114,67,49,69,80,54,70,105,108,101,73,79,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,85,108,80,99,106,69,95,78,83,56,95,73,83,67,95,69,69,70,118,83,66,95,106,69,69,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,80,70,102,102,102,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,83,50,95,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,102,117,110,99,73,80,70,102,102,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,83,50,95,69,69,0,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,98,97,115,101,73,70,118,118,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,98,97,115,101,73,70,118,82,75,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,69,69,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,98,97,115,101,73,70,118,80,99,106,69,69,69,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,98,97,115,101,73,70,118,80,75,99,83,51,95,83,51,95,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,98,97,115,101,73,70,118,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,69,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,98,97,115,101,73,70,102,118,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,98,97,115,101,73,70,102,102,102,69,69,69,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,98,97,115,101,73,70,102,102,69,69,69,0,0,0,0,0,0,0,78,83,116,51,95,95,49,49,48,95,95,102,117,110,99,116,105,111,110,54,95,95,98,97,115,101,73,70,78,83,95,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,80,75,99,69,69,69,0,0,0,0,78,54,80,101,116,97,108,115,49,50,71,97,109,101,76,105,115,116,101,110,101,114,69,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,49,57,65,116,108,97,115,73,110,105,70,105,108,101,72,97,110,100,108,101,114,69,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,51,95,95,102,117,110,100,97,109,101,110,116,97,108,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,102,117,110,99,116,105,111,110,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,70,102,102,102,69,0,0,0,70,102,102,69,0,0,0,0,68,110,0,0,0,0,0,0,56,83,116,111,114,97,98,108,101,0,0,0,0,0,0,0,56,82,101,110,100,101,114,101,114,0,0,0,0,0,0,0,56,69,120,112,114,101,115,115,111,0,0,0,0,0,0,0,55,80,114,111,103,114,97,109,0,0,0,0,0,0,0,0,54,83,104,97,100,101,114,0,54,70,105,108,101,73,79,0,54,67,97,109,101,114,97,0,53,77,105,120,101,114,0,0,52,77,101,110,117,0,0,0,52,71,97,109,101,0,0,0,50,55,83,99,101,110,101,71,114,97,112,104,84,114,97,110,115,102,111,114,109,82,101,99,101,105,118,101,114,0,0,0,50,54,83,99,101,110,101,71,114,97,112,104,84,114,97,110,115,102,111,114,109,86,105,115,105,116,111,114,0,0,0,0,50,52,83,99,101,110,101,71,114,97,112,104,73,110,105,70,105,108,101,72,97,110,100,108,101,114,0,0,0,0,0,0,50,48,83,68,76,77,105,120,101,114,65,117,100,105,111,67,111,110,116,101,120,116,0,0,50,48,76,105,103,104,116,82,101,110,100,101,114,67,111,110,116,101,120,116,51,68,0,0,50,48,76,97,109,98,100,97,73,110,105,70,105,108,101,72,97,110,100,108,101,114,0,0,50,48,73,109,97,103,101,82,101,110,100,101,114,67,111,110,116,101,120,116,50,68,0,0,50,48,67,105,114,99,108,101,49,68,69,118,101,110,116,72,97,110,100,108,101,114,0,0,49,57,84,101,120,116,82,101,110,100,101,114,67,111,110,116,101,120,116,50,68,0,0,0,49,57,73,110,116,101,114,112,111,108,97,116,105,110,103,67,97,109,101,114,97,0,0,0,49,57,66,108,117,114,82,101,110,100,101,114,67,111,110,116,101,120,116,50,68,0,0,0,49,56,83,99,101,110,101,71,114,97,112,104,69,120,112,114,101,115,115,111,0,0,0,0,49,55,83,99,101,110,101,71,114,97,112,104,86,105,115,105,116,111,114,0,0,0,0,0,49,54,83,99,101,110,101,71,114,97,112,104,80,105,99,107,101,114,0,0,0,0,0,0,49,53,82,101,110,100,101,114,67,111,110,116,101,120,116,51,68,0,0,0,0,0,0,0,49,53,82,101,110,100,101,114,67,111,110,116,101,120,116,50,68,0,0,0,0,0,0,0,49,52,83,116,111,114,97,98,108,101,83,116,114,117,99,116,0,0,0,0,0,0,0,0,49,52,83,99,101,110,101,71,114,97,112,104,78,111,100,101,0,0,0,0,0,0,0,0,49,52,77,101,110,117,84,114,97,110,115,105,116,105,111,110,0,0,0,0,0,0,0,0,49,52,73,110,105,70,105,108,101,72,97,110,100,108,101,114,0,0,0,0,0,0,0,0,49,51,80,108,97,116,102,111,114,109,65,117,100,105,111,0,49,51,80,97,110,110,105,110,103,67,97,109,101,114,97,0,49,51,65,116,116,114,97,99,116,67,97,109,101,114,97,0,49,51,65,99,116,105,111,110,72,97,110,100,108,101,114,0,49,50,86,101,114,116,101,120,66,117,102,102,101,114,0,0,49,50,68,105,114,101,99,116,70,105,108,101,73,79,0,0,49,49,76,105,103,104,116,67,97,109,101,114,97,0,0,0,49,48,84,114,97,110,115,105,116,105,111,110,0,0,0,0,184,69,0,0,32,74,0,0,0,0,0,0,40,74,0,0,0,0,0,0,136,74,0,0,0,0,0,0,152,74,0,0,0,0,0,0,168,74,0,0,144,93,0,0,0,0,0,0,0,0,0,0,184,74,0,0,144,93,0,0,0,0,0,0,0,0,0,0,200,74,0,0,144,93,0,0,0,0,0,0,0,0,0,0,224,74,0,0,232,93,0,0,0,0,0,0,0,0,0,0,248,74,0,0,232,93,0,0,0,0,0,0,0,0,0,0,16,75,0,0,144,93,0,0,0,0,0,0,0,0,0,0,32,75,0,0,0,0,0,0,192,100,0,0,0,0,0,0,40,75,0,0,0,0,0,0,200,100,0,0,0,0,0,0,48,75,0,0,224,69,0,0,72,75,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,216,98,0,0,0,0,0,0,224,69,0,0,144,75,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,224,98,0,0,0,0,0,0,224,69,0,0,216,75,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,232,98,0,0,0,0,0,0,224,69,0,0,32,76,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,240,98,0,0,0,0,0,0,0,0,0,0,104,76,0,0,16,96,0,0,0,0,0,0,0,0,0,0,152,76,0,0,16,96,0,0,0,0,0,0,224,69,0,0,200,76,0,0,0,0,0,0,1,0,0,0,24,98,0,0,0,0,0,0,224,69,0,0,224,76,0,0,0,0,0,0,1,0,0,0,24,98,0,0,0,0,0,0,224,69,0,0,248,76,0,0,0,0,0,0,1,0,0,0,32,98,0,0,0,0,0,0,224,69,0,0,16,77,0,0,0,0,0,0,1,0,0,0,32,98,0,0,0,0,0,0,224,69,0,0,40,77,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,136,99,0,0,0,8,0,0,224,69,0,0,112,77,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,136,99,0,0,0,8,0,0,224,69,0,0,184,77,0,0,0,0,0,0,3,0,0,0,72,97,0,0,2,0,0,0,24,94,0,0,2,0,0,0,168,97,0,0,0,8,0,0,224,69,0,0,0,78,0,0,0,0,0,0,3,0,0,0,72,97,0,0,2,0,0,0,24,94,0,0,2,0,0,0,176,97,0,0,0,8,0,0,0,0,0,0,72,78,0,0,72,97,0,0,0,0,0,0,0,0,0,0,96,78,0,0,72,97,0,0,0,0,0,0,224,69,0,0,120,78,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,40,98,0,0,2,0,0,0,224,69,0,0,144,78,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,40,98,0,0,2,0,0,0,0,0,0,0,168,78,0,0,0,0,0,0,192,78,0,0,144,98,0,0,0,0,0,0,224,69,0,0,224,78,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,192,94,0,0,0,0,0,0,224,69,0,0,40,79,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,216,94,0,0,0,0,0,0,224,69,0,0,112,79,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,240,94,0,0,0,0,0,0,224,69,0,0,184,79,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,8,95,0,0,0,0,0,0,0,0,0,0,0,80,0,0,72,97,0,0,0,0,0,0,0,0,0,0,24,80,0,0,72,97,0,0,0,0,0,0,224,69,0,0,48,80,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,160,98,0,0,2,0,0,0,224,69,0,0,88,80,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,160,98,0,0,2,0,0,0,224,69,0,0,128,80,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,160,98,0,0,2,0,0,0,224,69,0,0,168,80,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,160,98,0,0,2,0,0,0,0,0,0,0,208,80,0,0,16,98,0,0,0,0,0,0,0,0,0,0,232,80,0,0,72,97,0,0,0,0,0,0,224,69,0,0,0,81,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,128,99,0,0,2,0,0,0,224,69,0,0,24,81,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,128,99,0,0,2,0,0,0,0,0,0,0,48,81,0,0,0,0,0,0,88,81,0,0,0,0,0,0,128,81,0,0,168,98,0,0,0,0,0,0,0,0,0,0,160,81,0,0,144,93,0,0,0,0,0,0,0,0,0,0,192,81,0,0,40,97,0,0,0,0,0,0,0,0,0,0,232,81,0,0,40,97,0,0,0,0,0,0,0,0,0,0,16,82,0,0,0,0,0,0,72,82,0,0,0,0,0,0,128,82,0,0,0,0,0,0,160,82,0,0,0,0,0,0,192,82,0,0,0,0,0,0,224,82,0,0,0,0,0,0,0,83,0,0,224,69,0,0,24,83,0,0,0,0,0,0,1,0,0,0,160,94,0,0,3,244,255,255,224,69,0,0,72,83,0,0,0,0,0,0,1,0,0,0,176,94,0,0,3,244,255,255,224,69,0,0,120,83,0,0,0,0,0,0,1,0,0,0,160,94,0,0,3,244,255,255,224,69,0,0,168,83,0,0,0,0,0,0,1,0,0,0,176,94,0,0,3,244,255,255,0,0,0,0,216,83,0,0,184,93,0,0,0,0,0,0,0,0,0,0,240,83,0,0,0,0,0,0,8,84,0,0,8,98,0,0,0,0,0,0,0,0,0,0,32,84,0,0,248,97,0,0,0,0,0,0,0,0,0,0,64,84,0,0,0,98,0,0,0,0,0,0,0,0,0,0,96,84,0,0,0,0,0,0,128,84,0,0,0,0,0,0,160,84,0,0,0,0,0,0,192,84,0,0,224,69,0,0,224,84,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,120,99,0,0,2,0,0,0,224,69,0,0,0,85,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,120,99,0,0,2,0,0,0,224,69,0,0,32,85,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,120,99,0,0,2,0,0,0,224,69,0,0,64,85,0,0,0,0,0,0,2,0,0,0,72,97,0,0,2,0,0,0,120,99,0,0,2,0,0,0,0,0,0,0,96,85,0,0,0,0,0,0,120,85,0,0,0,0,0,0,144,85,0,0,0,0,0,0,168,85,0,0,248,97,0,0,0,0,0,0,0,0,0,0,192,85,0,0,0,98,0,0,0,0,0,0,0,0,0,0,216,85,0,0,240,99,0,0,0,0,0,0,0,0,0,0,96,86,0,0,16,100,0,0,0,0,0,0,0,0,0,0,160,86,0,0,24,100,0,0,0,0,0,0,0,0,0,0,224,86,0,0,0,0,0,0,8,87,0,0,0,0,0,0,104,87,0,0,0,0,0,0,144,87,0,0,0,0,0,0,192,87,0,0,0,0,0,0,32,88,0,0,0,0,0,0,72,88,0,0,0,0,0,0,112,88,0,0,0,0,0,0,152,88,0,0,0,0,0,0,248,88,0,0,0,0,0,0,16,89,0,0,120,102,0,0,0,0,0,0,0,0,0,0,56,89,0,0,176,100,0,0,0,0,0,0,0,0,0,0,96,89,0,0,160,100,0,0,0,0,0,0,0,0,0,0,136,89,0,0,160,100,0,0,0,0,0,0,0,0,0,0,176,89,0,0,176,100,0,0,0,0,0,0,0,0,0,0,216,89,0,0,144,100,0,0,0,0,0,0,0,0,0,0,0,90,0,0,176,100,0,0,0,0,0,0,0,0,0,0,40,90,0,0,176,100,0,0,0,0,0,0,0,0,0,0,80,90,0,0,136,93,0,0,0,0,0,0,16,70,0,0,120,90,0,0,16,70,0,0,128,90,0,0,184,69,0,0,136,90,0,0,0,0,0,0,144,90,0,0,0,0,0,0,160,90,0,0,112,101,0,0,0,0,0,0,0,0,0,0,176,90,0,0,0,0,0,0,192,90,0,0,0,0,0,0,208,90,0,0,0,0,0,0,216,90,0,0,0,0,0,0,224,90,0,0,216,101,0,0,0,0,0,0,0,0,0,0,232,90,0,0,224,69,0,0,240,90,0,0,0,0,0,0,2,0,0,0,216,101,0,0,2,0,0,0,168,102,0,0,2,4,0,0,224,69,0,0,248,90,0,0,0,0,0,0,3,0,0,0,40,100,0,0,2,0,0,0,216,101,0,0,2,4,0,0,168,102,0,0,2,8,0,0,0,0,0,0,0,91,0,0,0,0,0,0,32,91,0,0,32,102,0,0,0,0,0,0,0,0,0,0,64,91,0,0,120,102,0,0,0,0,0,0,0,0,0,0,96,91,0,0,128,102,0,0,0,0,0,0,0,0,0,0,120,91,0,0,56,102,0,0,0,0,0,0,0,0,0,0,144,91,0,0,120,102,0,0,0,0,0,0,0,0,0,0,168,91,0,0,64,102,0,0,0,0,0,0,0,0,0,0,192,91,0,0,0,0,0,0,216,91,0,0,200,101,0,0,0,0,0,0,0,0,0,0,240,91,0,0,16,101,0,0,0,0,0,0,0,0,0,0,8,92,0,0,200,101,0,0,0,0,0,0,0,0,0,0,32,92,0,0,240,100,0,0,0,0,0,0,0,0,0,0,56,92,0,0,0,0,0,0,80,92,0,0,112,101,0,0,0,0,0,0,0,0,0,0,104,92,0,0,0,0,0,0,128,92,0,0,0,0,0,0,152,92,0,0,216,100,0,0,0,0,0,0,0,0,0,0,176,92,0,0,216,101,0,0,0,0,0,0,0,0,0,0,200,92,0,0,216,102,0,0,0,0,0,0,0,0,0,0,224,92,0,0,0,0,0,0,248,92,0,0,0,0,0,0,8,93,0,0,16,101,0,0,0,0,0,0,0,0,0,0,24,93,0,0,16,101,0,0,0,0,0,0,0,0,0,0,40,93,0,0,0,0,0,0,56,93,0,0,0,0,0,0,72,93,0,0,8,101,0,0,0,0,0,0,0,0,0,0,88,93,0,0,16,101,0,0,0,0,0,0,0,0,0,0,104,93,0,0,216,101,0,0,0,0,0,0,48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102,65,66,67,68,69,70,120,88,43,45,112,80,105,73,110,78,0,0,0,0,0,0,0,0,5,0,0,0,15,0,0,0,30,0,0,0,10,0,0,0,20,0,0,0,50,0,0,0,5,0,0,0,10,0,0,0,2,0,0,0,8,0,0,0,1,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,7,0,0,0,9,0,0,0,13,0,0,0,17,0,0,0,25,0,0,0,33,0,0,0,49,0,0,0,65,0,0,0,97,0,0,0,129,0,0,0,193,0,0,0,1,1,0,0,129,1,0,0,1,2,0,0,1,3,0,0,1,4,0,0,1,6,0,0,1,8,0,0,1,12,0,0,1,16,0,0,1,24,0,0,1,32,0,0,1,48,0,0,1,64,0,0,1,96,0,0,0,0,0,0,0,0,0,0,0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,0,0,0,0,0,1,0,0,0,3,0,0,0,7,0,0,0,15,0,0,0,31,0,0,0,63,0,0,0,127,0,0,0,255,0,0,0,255,1,0,0,255,3,0,0,255,7,0,0,255,15,0,0,255,31,0,0,255,63,0,0,255,127,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,17,23,25,25,25,25,25,25,25,22,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,17,23,25,25,24,19,12,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,15,23,22,20,11,2,0,0,0,0,0,0,0,0,0,0,0,0,2,12,20,22,23,14,4,0,0,0,0,0,0,0,0,0,0,0,0,0,13,22,25,25,25,25,25,25,25,25,25,25,25,25,20,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,21,25,25,25,25,25,25,20,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,22,25,25,25,25,25,24,21,16,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,21,25,25,25,25,25,24,17,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,15,22,25,25,25,25,25,25,25,25,25,25,25,25,25,21,13,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,10,17,21,24,25,25,25,25,25,21,12,0,0,0,0,0,0,0,0,0,4,19,30,40,48,50,50,50,50,50,50,50,47,39,29,17,0,0,0,0,0,0,0,0,0,0,0,8,21,32,41,47,50,50,48,43,34,24,11,0,0,0,0,0,0,0,0,0,0,0,0,0,8,26,38,48,48,44,34,24,15,5,0,0,0,0,0,0,0,0,5,15,25,35,45,48,46,37,24,6,0,0,0,0,0,0,0,0,0,0,0,19,35,46,50,50,50,50,50,50,50,50,50,50,50,50,44,32,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,33,45,50,50,50,50,50,50,44,32,17,0,0,0,0,0,0,0,0,0,0,0,0,4,22,36,47,50,50,50,50,50,48,45,40,33,24,13,0,0,0,0,0,0,0,0,0,0,0,0,17,33,45,50,50,50,50,50,49,40,27,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,24,38,47,50,50,50,50,50,50,50,50,50,50,50,50,50,45,35,19,2,0,0,0,0,0,0,0,0,0,0,1,14,25,34,41,46,49,50,50,50,50,50,44,33,17,0,0,0,0,0,0,0,0,18,35,49,61,72,76,76,76,76,76,76,75,71,60,47,33,0,0,0,0,0,0,0,0,0,0,12,28,42,54,65,71,74,75,72,66,57,45,31,15,0,0,0,0,0,0,0,0,0,0,0,2,23,43,59,73,73,67,57,48,38,28,17,2,0,0,0,0,4,18,29,39,48,58,68,73,70,58,42,21,0,0,0,0,0,0,0,0,0,0,12,33,53,69,76,76,76,76,76,76,76,76,76,76,76,75,67,51,31,8,0,0,0,0,0,0,0,0,0,0,0,0,14,35,53,69,75,76,76,76,76,75,67,51,33,11,0,0,0,0,0,0,0,0,0,0,0,18,38,56,69,76,76,76,76,75,73,69,64,56,46,33,20,3,0,0,0,0,0,0,0,0,0,12,33,53,66,73,73,73,73,73,72,61,44,25,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,40,56,70,76,76,76,76,76,76,76,76,76,76,76,76,75,67,53,36,16,0,0,0,0,0,0,0,0,0,4,21,36,47,57,65,70,73,75,76,76,76,75,67,51,33,12,0,0,0,0,0,0,0,28,45,63,79,92,101,101,101,101,101,101,101,91,77,60,43,0,0,0,0,0,0,0,0,0,10,28,46,62,76,87,95,99,99,97,89,79,65,49,31,14,0,0,0,0,0,0,0,0,0,0,14,35,57,77,95,99,90,81,71,61,51,38,20,2,0,0,5,22,40,51,62,72,81,91,99,93,76,55,34,13,0,0,0,0,0,0,0,0,0,21,45,69,89,99,99,99,99,99,99,99,99,99,99,99,98,85,64,41,16,0,0,0,0,0,0,0,0,0,0,0,0,24,45,69,87,101,101,101,101,101,100,87,65,44,19,0,0,0,0,0,0,0,0,0,0,4,28,50,73,90,99,99,99,99,99,98,93,87,79,68,54,38,21,2,0,0,0,0,0,0,0,0,21,45,69,87,98,99,99,99,99,96,79,58,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,31,52,73,90,99,99,99,99,99,99,99,99,99,99,99,99,98,87,69,48,26,0,0,0,0,0,0,0,0,4,22,38,56,69,80,89,94,98,99,99,99,99,98,87,66,45,21,0,0,0,0,0,0,0,32,50,68,88,106,124,129,129,129,129,129,121,103,86,66,48,0,0,0,0,0,0,0,0,2,22,43,62,80,96,109,119,124,124,121,112,99,83,67,48,28,7,0,0,0,0,0,0,0,0,6,27,48,69,90,112,124,114,104,93,84,74,56,35,15,0,0,17,38,58,74,84,95,105,114,124,110,89,68,47,26,5,0,0,0,0,0,0,0,0,25,50,76,101,124,124,124,124,124,124,124,124,124,124,124,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,98,123,124,124,124,124,118,96,71,48,22,0,0,0,0,0,0,0,0,0,0,7,32,55,81,103,124,124,124,124,124,121,117,111,101,88,73,55,36,17,0,0,0,0,0,0,0,0,25,50,76,98,123,124,124,124,124,114,90,66,42,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,103,124,124,124,124,124,124,124,124,124,124,124,124,121,98,76,53,30,0,0,0,0,0,0,0,0,18,38,56,74,90,103,112,119,121,124,124,124,124,121,98,73,50,25,0,0,0,0,0,0,0,33,50,68,88,106,124,147,154,154,154,144,121,104,86,66,48,0,0,0,0,0,0,0,0,11,33,55,76,96,114,132,144,150,152,146,136,117,101,81,61,39,17,0,0,0,0,0,0,0,0,17,40,61,82,103,123,146,138,129,117,107,92,69,45,23,0,0,25,48,72,92,108,117,129,139,145,121,101,81,59,38,16,0,0,0,0,0,0,0,0,25,50,76,101,129,152,152,152,152,152,152,152,152,152,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,152,152,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,152,152,152,152,148,143,136,123,107,89,71,50,29,7,0,0,0,0,0,0,0,23,48,72,95,119,144,152,152,145,119,97,73,49,25,1,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,129,152,152,152,152,152,152,152,152,152,152,147,121,99,76,53,30,0,0,0,0,0,0,0,8,30,52,72,91,109,124,137,144,149,152,152,152,149,121,99,73,50,25,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,18,40,63,86,108,130,150,165,175,175,169,154,136,114,92,69,47,24,0,0,0,0,0,0,0,7,29,51,73,95,115,137,158,161,152,141,121,98,73,48,25,0,2,27,50,75,98,121,142,152,162,157,136,114,93,71,50,28,6,0,0,0,0,0,0,0,25,50,76,101,129,154,177,177,173,167,167,167,167,167,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,170,147,119,96,71,48,22,4,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,167,171,175,173,167,158,143,123,104,83,61,39,16,0,0,0,0,0,0,0,17,41,65,89,113,138,161,176,152,129,103,79,55,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,129,154,167,167,167,167,167,169,177,177,172,147,121,99,76,53,30,0,0,0,0,0,0,0,19,41,63,84,106,124,144,159,168,173,176,170,167,149,121,99,73,50,25,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,22,45,68,91,115,139,162,184,198,200,188,168,145,121,99,74,50,27,0,0,0,0,0,0,0,19,40,63,84,106,129,150,171,174,153,132,109,87,66,43,20,0,0,23,44,67,89,110,132,154,175,170,148,129,105,82,61,39,17,0,0,0,0,0,0,0,25,50,76,101,129,154,180,177,154,142,142,142,142,142,142,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,9,21,31,50,76,99,124,149,175,170,147,119,96,71,48,36,27,16,5,0,0,0,0,0,0,0,7,33,55,81,104,129,142,144,147,156,170,188,177,158,138,114,93,69,47,24,1,0,0,0,0,0,0,11,35,59,82,106,132,155,178,158,134,109,86,62,38,14,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,104,129,142,142,142,142,142,142,146,164,188,172,147,121,99,76,53,30,0,0,0,0,0,0,3,27,49,73,95,117,140,161,179,184,168,155,147,144,142,121,99,73,50,25,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,22,45,68,93,116,142,165,188,210,212,195,172,147,121,99,76,50,27,0,0,0,0,0,0,8,30,51,73,95,117,140,162,184,163,140,118,97,75,54,32,11,0,0,13,33,55,76,98,119,143,164,182,161,139,116,93,72,50,29,6,0,0,0,0,0,0,25,50,76,101,129,154,180,175,149,121,116,116,116,116,116,115,94,70,45,19,0,0,0,0,0,0,0,0,3,18,31,42,54,63,76,99,124,149,175,170,147,119,96,74,68,59,49,38,26,12,0,0,0,0,0,0,6,32,54,79,100,116,116,116,121,136,154,174,192,170,147,121,100,77,53,30,6,0,0,0,0,0,0,4,28,52,75,99,123,148,172,164,141,116,93,68,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,11,34,57,79,101,116,116,116,116,116,116,116,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,8,32,56,80,103,129,150,173,192,170,150,134,121,116,116,115,96,72,49,24,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,20,43,67,90,113,137,158,176,186,187,179,163,142,118,96,73,50,27,0,0,0,0,0,0,18,41,63,84,106,130,152,173,174,152,130,106,84,63,42,21,0,0,0,0,22,44,64,86,108,132,154,175,172,150,129,105,83,61,39,16,0,0,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,91,91,91,91,91,80,60,38,14,0,0,0,0,0,0,0,6,22,38,52,64,75,86,94,101,124,149,175,170,147,119,104,98,91,82,72,59,47,33,19,4,0,0,0,0,2,26,47,69,84,91,91,93,100,118,140,163,186,176,154,130,106,81,58,34,10,0,0,0,0,0,0,0,22,45,69,93,116,142,165,171,147,121,98,75,51,27,3,0,0,0,0,0,0,0,0,0,0,0,0,7,28,49,69,84,91,91,91,91,91,91,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,12,36,60,84,108,134,157,180,184,160,138,114,98,91,91,91,80,62,41,19,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,15,37,60,82,103,123,143,155,162,162,157,145,129,108,88,65,44,21,0,0,0,0,0,5,28,50,73,95,117,141,163,184,163,141,117,96,74,51,30,8,0,0,0,0,9,31,53,75,98,119,144,165,183,161,139,115,93,71,49,26,3,0,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,66,66,66,65,58,44,25,4,0,0,0,0,0,0,6,22,40,56,72,86,98,108,117,124,132,150,175,171,148,134,129,121,114,105,92,80,67,53,38,22,6,0,0,0,0,14,33,50,61,66,66,68,86,109,134,157,181,181,157,134,109,84,60,37,12,0,0,0,0,0,0,0,15,39,62,86,110,135,159,178,154,132,106,81,57,34,10,0,0,0,0,0,0,0,0,0,0,0,0,0,17,35,50,61,66,66,66,66,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,38,63,86,111,137,160,185,178,154,132,106,83,68,66,65,59,45,27,8,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,7,29,49,70,89,107,121,132,137,138,134,123,109,92,75,55,34,13,0,0,0,0,0,15,38,60,82,105,129,151,173,176,153,132,107,86,64,41,19,0,0,0,0,0,0,21,42,65,87,109,134,155,178,172,149,124,103,81,58,36,13,0,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,40,40,40,35,24,8,0,0,0,0,0,0,2,21,40,58,74,91,106,118,132,141,149,155,165,184,182,165,157,153,147,138,129,114,101,87,72,56,40,24,6,0,0,0,0,15,29,37,40,40,58,81,106,132,154,179,183,160,137,109,86,63,38,15,0,0,0,0,0,0,0,9,32,56,80,104,129,152,176,160,137,112,88,64,41,16,0,0,0,0,0,0,0,0,0,0,0,0,0,1,16,29,37,40,40,40,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,40,63,88,111,139,162,187,177,152,129,101,78,54,40,40,36,25,10,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,0,17,36,55,72,87,98,107,111,111,109,101,90,76,58,41,21,2,0,0,0,0,1,24,47,70,92,115,138,161,183,167,144,121,98,75,53,31,9,0,0,0,0,0,0,11,32,55,77,99,121,146,169,181,159,137,113,90,68,45,22,0,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,17,17,13,4,0,0,0,0,0,0,0,15,36,55,74,92,109,124,141,154,164,173,179,186,198,199,187,182,177,170,161,149,136,121,107,91,74,58,40,21,0,0,0,0,0,6,14,17,33,55,80,104,129,154,177,185,162,137,111,86,63,38,15,0,0,0,0,0,0,0,2,26,49,73,98,121,146,170,167,144,118,94,71,47,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,14,17,17,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,40,63,88,111,139,162,187,175,152,124,101,76,53,27,17,13,4,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,0,2,21,37,53,66,76,83,86,86,85,78,69,56,40,24,7,0,0,0,0,0,10,33,56,79,101,124,148,171,181,159,136,112,89,66,43,20,0,0,0,0,0,0,0,0,22,45,68,90,114,137,160,183,169,146,121,99,77,53,30,8,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,6,28,49,69,90,109,129,146,161,175,187,196,187,181,177,177,177,180,185,193,182,170,157,143,124,110,92,75,52,31,6,0,0,0,0,0,0,7,33,55,81,104,129,154,177,184,160,137,110,86,63,38,15,0,0,0,0,0,0,0,0])
.concat([19,43,67,91,114,139,163,173,150,124,101,77,54,30,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,40,63,88,111,139,162,187,175,152,124,101,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,0,10,29,47,59,65,66,66,66,66,66,66,66,61,50,33,14,0,0,0,0,0,18,41,64,87,109,134,156,180,173,150,124,103,80,57,35,12,0,0,0,0,0,0,0,0,13,36,59,82,106,129,152,175,178,154,132,107,85,61,38,16,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,16,39,61,82,103,123,144,162,180,195,188,174,164,157,152,152,152,155,161,170,181,191,177,161,146,129,106,83,58,35,10,0,0,0,0,0,0,8,33,56,81,104,132,154,177,182,160,134,109,86,60,38,13,0,0,0,0,0,0,0,0,13,36,61,85,108,134,157,180,156,132,107,84,60,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,40,63,88,111,139,162,187,175,152,124,101,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,0,21,42,63,81,91,91,91,91,91,91,91,91,84,67,47,26,4,0,0,0,3,26,49,73,96,118,143,165,188,166,143,118,95,72,49,26,3,0,0,0,0,0,0,0,0,5,28,51,73,98,121,145,168,186,163,140,115,93,69,47,24,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,2,25,48,70,93,115,137,158,178,197,188,170,154,142,134,129,124,129,132,138,148,160,172,173,155,137,117,99,79,56,33,8,0,0,0,0,0,0,10,33,58,81,106,132,155,180,180,157,134,107,83,60,35,12,0,0,0,0,0,0,0,0,6,30,54,78,101,124,150,174,163,139,114,90,67,43,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,38,63,86,111,137,160,185,177,152,129,101,78,53,30,5,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,4,27,50,74,97,115,116,116,116,116,116,116,116,101,79,55,32,9,0,0,0,9,33,56,80,103,129,151,173,182,159,137,111,88,65,41,18,0,0,0,0,0,0,0,0,0,0,20,44,67,91,114,139,162,185,171,148,124,101,77,54,31,7,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,9,32,56,78,101,124,147,170,191,194,172,154,136,119,108,102,101,101,106,114,124,139,152,157,139,119,101,83,65,45,24,2,0,0,0,0,0,0,11,35,59,83,106,132,157,180,180,155,132,106,81,58,34,10,0,0,0,0,0,0,0,0,0,24,48,72,95,118,144,168,169,145,119,97,73,49,25,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,12,37,60,86,109,136,160,183,177,152,129,101,78,53,30,5,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,144,144,144,144,144,144,129,104,81,55,33,10,0,0,0,16,40,63,87,110,134,158,181,176,152,129,104,81,57,35,11,0,0,0,0,0,0,0,0,0,0,13,37,60,84,107,132,155,178,178,155,132,108,85,61,37,13,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,14,37,61,85,109,134,155,179,202,184,161,139,117,99,86,78,76,78,82,91,103,116,132,141,121,103,85,67,49,30,12,0,0,0,0,0,0,0,12,35,60,83,109,134,158,182,177,154,129,104,80,56,33,8,0,0,0,0,0,0,0,0,0,17,41,65,88,112,137,161,176,152,129,103,80,56,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,11,35,60,83,106,134,157,182,177,154,129,104,79,55,31,7,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,170,170,170,170,154,129,104,81,55,33,10,0,0,0,22,46,69,93,116,141,165,188,170,147,121,98,75,51,27,4,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,150,173,186,162,139,114,91,67,43,19,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,17,40,65,88,112,138,161,185,201,177,154,132,106,84,65,54,50,53,59,70,83,98,112,123,105,87,69,51,32,14,0,0,0,0,0,0,0,0,12,38,60,85,109,134,160,182,175,152,129,101,78,55,30,7,0,0,0,0,0,0,0,0,0,10,34,58,82,106,132,155,178,159,135,109,86,62,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,10,33,58,81,106,132,155,180,180,154,132,104,81,55,33,7,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,193,193,177,154,129,104,81,55,33,10,0,0,3,27,51,75,98,121,147,171,190,165,142,116,93,70,46,22,0,0,0,0,0,0,0,0,0,0,0,1,25,48,72,96,119,144,168,192,168,144,119,96,73,49,25,1,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,17,43,66,91,114,141,165,188,198,175,151,124,101,77,53,31,27,29,37,49,63,78,93,98,87,71,52,34,16,0,0,0,0,0,0,0,0,0,14,38,62,86,109,137,160,183,175,150,124,101,76,53,29,5,0,0,0,0,0,0,0,0,0,4,28,52,75,99,123,148,172,165,141,116,93,69,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,7,32,55,81,104,132,154,178,180,157,132,106,82,58,33,10,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,8,32,56,80,103,129,152,176,185,160,137,112,88,65,40,17,0,0,0,0,0,0,0,0,0,0,0,0,19,43,67,90,114,139,162,187,174,150,124,101,78,54,30,6,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,17,43,66,91,114,142,165,190,198,175,150,124,101,77,54,35,21,7,15,29,44,60,70,75,67,53,36,18,0,0,0,0,0,0,0,0,0,0,15,38,63,86,111,137,160,185,172,149,121,99,76,50,27,3,0,0,0,0,0,0,0,0,0,0,21,45,69,93,116,142,165,172,147,121,99,75,51,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,6,30,54,78,101,129,152,177,182,157,134,106,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,12,36,60,83,108,134,157,181,181,157,134,107,83,60,35,12,0,0,0,0,0,0,0,0,0,0,0,0,14,37,62,86,109,135,160,183,179,155,132,106,81,58,34,10,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,17,42,66,90,114,139,163,187,201,178,155,132,108,87,69,55,41,29,17,9,25,39,48,50,45,33,19,1,0,0,0,0,0,0,0,0,0,0,15,38,63,86,111,137,162,185,172,149,121,99,73,50,25,2,0,0,0,0,0,0,0,0,0,0,15,39,62,86,110,135,158,178,154,132,106,81,57,34,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,5,28,53,77,101,124,152,175,182,157,134,106,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,16,40,64,88,111,137,160,185,177,153,129,104,80,56,32,8,0,0,0,0,0,0,0,0,0,0,0,0,10,34,58,81,106,132,155,180,183,160,136,109,86,63,37,14,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,16,39,63,86,110,136,159,181,204,185,163,143,121,105,89,75,62,50,40,29,19,16,23,25,21,13,0,0,0,0,0,0,0,0,0,0,0,0,15,38,63,86,111,137,162,185,172,149,121,99,73,50,25,15,11,3,0,0,0,0,0,0,0,0,8,32,56,80,103,129,152,176,160,137,112,88,64,41,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,4,11,15,27,52,76,99,124,149,175,182,157,134,106,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,19,43,67,91,114,141,165,189,173,149,124,101,76,52,28,4,0,0,0,0,0,0,0,0,0,0,0,0,6,30,54,78,101,129,152,175,187,162,139,114,88,65,41,17,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,11,35,58,81,104,129,150,172,194,196,176,157,140,123,109,95,83,72,62,50,40,29,18,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,38,63,86,109,137,160,183,172,149,124,101,77,54,42,39,33,24,9,0,0,0,0,0,0,0,1,25,49,73,97,121,145,169,167,144,119,95,71,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,11,24,34,39,42,56,79,102,129,152,175,181,157,134,106,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,22,45,70,93,117,144,167,192,172,147,121,96,73,49,25,0,0,0,0,0,0,0,0,0,0,0,0,0,2,26,50,75,99,121,149,173,190,165,142,116,91,68,43,20,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,4,28,50,73,96,117,139,160,179,197,191,175,159,144,130,116,105,95,83,73,62,51,40,28,15,2,0,0,0,0,0,0,0,0,0,0,0,0,12,37,60,83,108,134,157,180,177,154,132,108,88,74,66,63,57,45,27,9,0,0,0,0,0,0,0,19,43,66,91,114,139,163,173,150,124,101,77,54,30,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,9,28,45,58,64,67,75,90,110,134,155,180,178,154,130,104,81,57,32,9,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,23,48,72,96,119,147,170,193,170,144,119,95,71,47,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,73,96,121,147,171,193,168,144,119,93,71,45,22,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,19,41,63,84,105,124,144,162,180,196,193,179,165,152,140,129,116,106,96,84,73,62,50,36,22,8,0,0,0,0,0,0,0,0,0,0,0,9,33,57,80,104,129,152,173,185,164,143,123,107,97,91,88,79,63,41,20,0,0,0,0,0,0,0,12,36,60,84,108,132,156,180,156,134,108,84,61,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,20,42,63,79,88,91,98,109,124,145,165,188,172,147,124,101,77,53,29,5,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,25,48,73,98,121,148,172,190,167,142,116,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,46,70,93,119,144,168,193,170,147,119,96,72,48,23,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,8,30,51,71,90,109,129,146,161,176,189,198,186,173,162,150,140,130,117,106,95,83,70,56,42,27,10,0,0,0,0,0,0,0,0,0,0,4,28,51,73,97,118,141,161,177,177,159,143,130,119,115,113,96,73,49,26,0,0,0,0,0,0,0,6,30,53,77,101,124,150,174,163,139,114,90,67,43,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,1,27,51,74,97,114,115,121,132,144,161,179,175,159,139,116,93,71,47,24,1,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,2,27,50,75,99,124,149,173,190,167,142,114,91,66,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,44,68,93,116,144,167,192,172,147,121,96,73,48,25,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,17,37,56,74,92,109,124,143,155,168,180,191,195,183,173,162,152,140,129,117,104,90,76,61,46,28,10,0,0,0,0,0,0,0,0,0,0,20,42,64,86,107,124,143,155,163,177,163,153,144,142,121,99,76,50,27,0,0,0,0,0,0,0,0,23,47,71,95,118,144,167,170,146,121,97,73,49,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,2,27,53,76,101,124,142,145,154,164,175,162,154,141,123,105,83,62,39,16,0,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,2,27,50,76,99,124,150,175,190,165,142,114,91,66,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,68,91,116,142,167,190,172,149,121,99,73,50,25,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,3,22,40,58,74,91,107,119,135,147,158,170,181,191,195,184,173,163,152,139,124,110,96,80,62,45,26,7,0,0,0,0,0,0,0,0,0,11,32,53,72,91,107,119,132,143,163,186,176,169,149,121,99,76,50,27,0,0,0,0,0,0,0,0,16,40,64,88,111,137,160,176,152,129,103,80,56,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,2,27,53,76,101,124,152,170,176,186,161,141,132,118,105,89,69,50,29,7,0,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,2,27,50,76,99,124,152,175,188,165,139,114,88,66,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,91,115,142,167,190,173,149,121,99,73,50,25,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,6,22,40,56,72,86,99,112,124,137,148,158,169,180,192,196,184,173,159,146,132,114,98,80,61,41,21,1,0,0,0,0,0,0,0,0,11,32,53,73,91,107,121,134,143,164,184,174,167,149,121,99,76,50,27,0,0,0,0,0,0,0,0,10,34,58,81,106,130,155,178,159,135,109,86,62,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,2,27,53,76,101,124,152,168,175,186,162,141,132,119,105,89,70,50,29,7,0,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,2,27,50,76,99,124,152,175,188,165,139,114,88,66,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,91,115,142,167,190,173,149,121,99,73,50,25,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,6,22,38,52,65,79,90,101,114,124,136,147,158,170,183,196,194,180,166,150,134,114,95,75,55,34,13,0,0,0,0,0,0,0,0,20,43,64,87,107,124,143,156,164,177,162,150,144,139,121,99,76,50,27,0,0,0,0,0,0,0,0,3,27,51,75,98,121,147,171,165,142,116,93,69,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,2,27,53,76,101,124,139,144,153,163,177,163,155,141,123,105,83,62,40,17,0,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,2,27,50,76,99,124,150,175,190,165,142,114,91,66,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,68,91,116,142,167,190,172,149,121,99,73,50,25,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,19,32,45,57,69,81,91,103,113,124,137,149,163,177,192,200,184,168,149,130,109,89,67,46,24,2,0,0,0,0,0,0,4,28,51,74,97,118,141,161,177,177,159,143,129,118,114,110,95,73,49,26,0,0,0,0,0,0,0,0,0,20,45,69,92,116,141,165,172,147,123,99,76,52,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,1,26,51,73,95,111,114,119,130,144,161,179,176,159,139,116,93,71,47,24,1,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,2,26,50,75,99,123,149,173,190,167,142,115,91,66,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,44,68,93,116,144,167,193,172,147,121,96,73,48,25,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,24,36,47,58,70,80,91,103,115,129,143,157,173,191,202,183,164,144,121,100,78,56,33,10,0,0,0,0,0,0,9,33,57,80,104,129,152,174,185,163,143,123,107,95,89,88,78,61,40,19,0,0,0,0,0,0,0,0,0,14,38,62,86,109,135,158,178,155,132,106,82,58,34,11,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,19,41,61,79,88,90,96,108,124,144,165,188,172,148,124,101,77,53,29,5,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,25,48,73,97,121,147,172,190,167,143,116,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,46,70,93,119,144,169,193,170,147,119,96,72,48,23,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,14,25,37,47,57,69,81,93,107,121,139,157,174,194,198,177,155,134,109,86,63,40,17,0,0,0,0,0,0,12,37,60,83,108,134,157,180,177,154,132,108,88,73,65,63,57,44,27,7,0,0,0,0,0,0,0,0,0,8,32,56,79,103,129,152,175,161,137,113,89,65,41,17,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,9,27,45,57,63,65,74,90,109,134,155,180,178,154,130,104,81,57,32,9,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,23,47,71,96,119,147,170,193,170,144,119,96,71,47,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,73,96,121,147,171,193,167,144,119,93,71,45,22,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,5,14,15,15,6,0,4,14,24,36,48,59,73,87,103,119,141,161,182,205,187,163,141,116,93,69,45,21,0,0,0,0,0,0,15,38,63,86,109,137,160,183,172,149,124,101,77,54,40,37,33,23,9,0,0,0,0,0,0,0,0,0,0,1,25,49,73,97,121,145,168,167,144,119,95,71,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,9,24,33,38,41,56,79,102,129,152,175,181,157,134,106,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,21,45,70,93,116,144,167,191,172,147,121,98,73,49,25,1,0,0,0,0,0,0,0,0,0,0,0,0,3,26,51,75,99,123,149,173,190,165,142,116,91,68,43,20,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,15,28,37,40,37,29,16,2,0,3,14,27,39,53,69,86,106,129,151,173,197,193,169,145,119,96,73,48,25,0,0,0,0,0,0,15,38,63,86,111,137,162,185,172,149,121,99,73,50,26,12,9,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,66,90,114,139,162,174,150,124,101,78,54,30,6,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,1,9,12,27,52,76,99,124,149,175,182,157,134,106,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,18,42,67,91,114,140,165,188,175,150,124,101,76,53,28,4,0,0,0,0,0,0,0,0,0,0,0,0,6,30,55,78,102,129,152,175,187,162,139,113,88,65,40,17,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,13,33,49,61,66,61,50,36,21,9,0,0,5,19,34,52,73,97,119,144,168,193,195,172,147,121,98,73,50,25,0,0,0,0,0,0,15,38,63,86,111,137,162,185,172,149,121,99,73,50,26,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,36,59,83,107,132,155,180,157,134,109,84,61,37,13,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,5,28,53,76,101,124,152,175,182,157,134,106,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,15,39,63,87,111,137,160,185,178,154,129,104,80,56,32,8,0,0,0,0,0,0,0,0,0,0,0,0,10,34,58,82,106,132,155,180,183,159,135,109,86,62,37,14,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,7,27,47,67,83,91,84,70,56,42,30,19,11,6,5,21,45,69,93,116,144,167,193,196,172,148,121,99,73,50,25,0,0,0,0,0,0,15,38,63,86,111,137,160,185,172,149,121,99,75,50,27,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,30,53,77,101,124,149,173,163,139,114,91,67,43,19,0,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,6,30,54,78,101,129,152,177,182,157,134,106,83,58,35,10,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,11,35,60,83,107,134,156,180,181,157,134,108,83,60,36,12,0,0,0,0,0,0,0,0,0,0,0,0,14,38,63,86,109,136,160,183,178,154,132,106,81,58,33,9,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,21,41,61,81,101,114,105,90,76,64,52,42,35,30,30,33,49,72,96,119,144,168,193,194,170,147,121,96,73,48,25,0,0,0,0,0,0,14,38,62,86,109,137,160,183,175,150,124,101,76,53,29,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,46,70,94,118,143,167,170,147,121,98,73,50,26,2,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,7,32,55,81,104,130,154,178,180,157,132,106,82,58,33,10,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,7,31,55,78,103,129,152,175,185,161,137,113,88,65,41,17,0,0,0,0,0,0,0,0,0,0,0,0,20,43,68,91,114,139,163,188,173,149,124,101,77,53,29,5,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,14,34,54,74,95,114,136,123,110,97,85,74,65,58,55,54,57,65,82,103,124,150,173,196,189,165,142,116,93,70,46,22,0,0,0,0,0,0,12,38,60,85,109,134,160,182,175,152,129,101,78,55,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,64,88,111,137,160,176,152,129,103,80,57,33,8,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,10,33,58,81,106,132,155,180,180,154,132,104,81,56,33,8,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,2,26,50,74,98,121,146,170,190,166,142,117,93,70,46,22,0,0,0,0,0,0,0,0,0,0,0,1,25,49,73,96,119,144,168,191,167,144,119,96,72,48,24,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,7,28,48,68,88,108,129,149,145,132,118,107,97,88,83,78,78,81,88,99,116,137,158,180,203,181,159,137,111,89,65,42,18,0,0,0,0,0,0,12,35,60,83,109,134,158,182,177,154,129,104,80,55,33,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,33,57,81,105,130,154,178,160,136,110,86,63,39,15,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,11,35,59,83,106,134,157,182,177,154,129,104,80,55,32,7,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,0,21,45,68,92,116,140,164,187,171,147,121,98,75,52,28,5,0,0,0,0,0,0,0,0,0,0,8,31,54,78,101,124,150,174,184,162,138,114,90,66,43,19,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,0,20,41,62,81,101,121,143,163,166,153,141,130,119,112,106,104,104,106,111,119,135,152,170,191,192,171,149,129,104,81,58,35,12,0,0,0,0,0,0,11,35,59,83,106,132,157,180,180,155,132,106,81,58,34,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,27,51,75,98,121,147,171,166,142,116,93,70,46,22,0,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,12,37,60,86,109,136,160,183,177,152,129,101,78,54,30,6,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,0,15,39,62,86,109,134,157,180,176,153,130,106,82,59,36,12,0,0,0,0,0,0,0,0,0,0,14,38,61,85,108,134,155,179,177,155,132,106,83,60,36,12,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,3,26,51,73,95,115,137,157,177,187,174,163,153,144,137,134,132,132,132,137,144,155,170,186,197,178,158,138,116,95,73,50,28,5,0,0,0,0,0,0,10,33,58,81,106,132,155,180,180,157,132,106,83,60,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,69,92,116,141,165,172,148,123,100,76,52,28,4,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,38,63,86,111,137,160,185,177,152,129,101,78,53,30,5,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,0,8,32,55,79,102,124,150,172,184,160,137,112,90,65,43,19,0,0,0,0,0,0,0,0,0,0,21,45,68,92,114,139,163,186,170,147,121,100,76,53,30,6,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,5,27,53,76,101,123,141,155,169,181,194,186,176,167,161,157,154,154,157,160,166,177,189,193,179,162,144,123,104,83,62,40,18,0,0,0,0,0,0,0,8,33,56,81,104,132,154,179,182,160,134,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,38,62,85,109,134,158,179,155,132,106,83,59,35,11,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,40,63,88,111,139,162,187,175,152,124,101,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,0,1,25,48,71,94,116,141,163,187,167,144,119,96,73,50,27,4,0,0,0,0,0,0,0,0,6,29,52,75,98,121,147,169,184,161,139,114,92,69,45,23,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,0,0,0,0,0,0,0,1,24,48,69,89,105,119,136,148,161,171,180,188,191,185,181,180,180,180,184,190,192,183,172,159,144,129,109,89,70,50,29,7,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,184,160,137,109,86,63,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,56,79,102,129,152,175,161,137,113,90,65,41,17,0,0,0,0,0,0,0,0,0,0,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,40,63,88,111,139,162,187,175,152,124,101,76,53,27,5,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,200,177,154,129,104,81,55,33,10,0,0,0,0,17,40,63,86,109,134,155,179,174,152,129,105,81,59,36,13,0,0,0,0,0,0,0,0,15,38,61,83,106,130,153,176,176,153,132,106,83,61,37,15,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,20,17,17,13,4,0,0,0,0,16,36,55,71,86,99,113,124,138,148,157,164,170,176,180,186,198,193,181,174,168,160,150,138,123,108,91,74,55,36,16,0,0,0,0,0,0,8,15,17,33,55,80,104,129,154,177,185,160,137,111,86,63,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,49,72,96,119,145,168,168,144,119,96,72,48,24,0,0,0,0,0,0,8,15,17,17,17,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,40,63,88,111,139,162,187,175,152,124,101,76,53,27,17,13,5,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,0,4,13,17,17,27,50,76,99,121,149,172,195,200,175,152,129,104,80,55,33,9,0,0,0,0,8,32,54,77,100,123,147,169,183,160,137,114,90,68,45,22,0,0,0,0,0,0,0,2,24,46,69,92,115,139,162,184,167,145,121,98,75,52,29,6,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,45,43,43,43,37,26,10,0,0,0,2,19,36,51,65,79,92,104,114,124,134,140,147,152,155,165,184,178,159,150,144,137,129,115,103,89,73,56,38,21,2,0,0,0,0,0,15,30,39,43,43,58,81,106,132,154,179,183,160,137,109,86,63,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,42,66,90,114,139,162,175,151,124,102,78,54,31,7,0,0,0,1,17,31,40,43,43,43,43,66,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,40,63,88,111,139,162,187,177,152,129,101,78,54,43,43,37,27,11,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,0,11,26,36,42,42,36,53,77,101,124,149,172,195,198,175,152,124,101,78,55,30,7,0,0,0,0,0,23,46,69,91,114,137,160,181,168,145,121,99,76,55,32,10,0,0,0,0,0,0,12,33,56,79,101,124,147,171,180,157,135,112,89,66,44,20,0,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,71,68,68,68,68,61,46,26,5,0,0,0,1,17,31,45,58,71,82,92,101,109,116,121,129,132,150,175,170,147,124,119,113,104,93,82,69,55,38,22,4,0,0,0,0,0,14,33,50,62,68,68,69,86,109,134,157,181,181,157,134,109,84,60,37,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,36,59,83,107,132,155,180,157,134,109,85,61,37,13,0,0,0,17,35,51,63,68,68,68,68,68,88,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,15,38,63,86,111,137,160,185,178,154,132,106,83,69,68,68,61,47,29,8,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,8,27,46,59,67,67,60,58,81,104,129,152,175,198,195,172,149,124,101,78,53,30,7,0,0,0,0,0,14,36,59,81,104,124,149,172,177,155,132,109,87,65,42,21,0,0,0,0,0,0,22,44,66,89,110,135,156,179,170,147,124,101,79,57,34,12,0,0,0,0,0,25,50,76,101,129,154,180,175,149,121,96,91,91,91,91,91,80,60,38,14,0,0,0,0,0,12,25,38,49,59,69,78,85,92,98,101,124,149,175,170,147,119,96,89,81,72,61,49,35,20,4,0,0,0,0,0,2,26,47,69,84,91,92,93,100,118,141,164,187,176,153,130,106,81,58,34,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,29,53,77,101,124,149,173,163,139,115,91,67,44,20,0,0,7,28,49,69,84,91,91,91,91,91,91,111,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,12,36,60,84,108,134,157,180,184,160,138,114,99,93,91,91,81,62,42,19,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,0,19,40,61,80,90,90,83,83,91,112,135,157,180,203,190,167,144,119,96,73,50,26,3,0,0,0,0,0,4,27,49,71,93,116,139,161,182,165,144,119,98,75,53,32,10,0,0,0,0,12,33,55,76,99,121,145,166,181,160,138,114,92,69,47,24,2,0,0,0,0,0,25,50,76,101,129,154,180,175,149,121,116,116,116,116,116,115,94,70,45,19,0,0,0,0,0,0,4,16,27,37,46,54,61,68,76,99,124,149,175,170,147,119,96,71,57,49,39,27,14,0,0,0,0,0,0,0,7,32,55,80,101,116,116,119,124,136,154,174,191,169,147,121,100,77,53,30,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,46,70,94,117,143,166,170,147,121,98,73,50,27,3,0,12,34,57,80,101,116,116,116,116,116,116,116,137,160,185,172,147,121,99,76,53,30,0,0,0,0,0,0,8,32,56,80,103,129,150,173,192,170,150,134,121,119,116,115,97,72,49,24,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,3,25,48,72,94,114,114,109,106,112,124,145,166,188,206,183,161,139,114,92,69,45,22,0,0,0,0,0,0,0,16,39,62,83,105,129,149,172,175,154,132,108,87,65,44,22,1,0,0,3,23,45,66,88,109,132,155,177,170,148,124,103,82,59,38,15,0,0,0,0,0,0,25,50,76,101,129,154,180,178,155,144,144,144,144,144,144,121,96,71,45,20,0,0,0,0,0,0,0,0,4,15,23,31,37,50,76,99,124,149,175,170,147,119,96,71,48,26,16,5,0,0,0,0,0,0,0,0,7,33,55,81,104,129,144,144,149,157,171,188,177,158,138,114,92,69,47,24,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,64,88,111,137,160,176,152,129,104,80,57,33,9,0,12,35,58,81,104,129,144,144,144,144,144,144,147,165,188,172,147,121,99,76,53,30,0,0,0,0,0,0,3,27,49,73,95,117,140,161,179,184,168,156,147,144,144,121,99,73,50,25,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,9,32,54,78,101,123,139,136,134,137,146,161,179,198,194,173,153,132,107,85,63,40,17,0,0,0,0,0,0,0,6,29,50,72,93,115,139,161,182,164,143,119,98,76,56,34,13,0,0,14,36,57,79,100,121,144,165,181,158,137,114,92,71,48,27,5,0,0,0,0,0,0,25,50,76,101,129,154,175,175,175,170,170,170,170,170,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,8,27,50,76,99,124,149,175,170,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,170,173,175,171,167,157,143,123,103,82,61,39,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,33,57,81,105,129,153,175,160,137,111,87,63,40,16,0,12,35,58,81,104,129,154,170,170,170,170,170,171,175,175,172,147,121,99,76,53,30,0,0,0,0,0,0,0,18,41,63,84,105,124,144,158,168,172,175,172,170,149,121,99,73,50,25,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,15,38,61,84,106,132,154,160,160,161,169,180,195,196,179,161,141,119,98,76,55,32,10,0,0,0,0,0,0,0,0,17,39,61,82,105,124,148,170,177,154,134,110,89,67,45,22,0,0,22,46,68,90,112,135,156,178,168,147,124,103,81,59,37,15,0,0,0,0,0,0,0,25,50,76,101,129,149,149,149,149,149,149,149,149,149,149,121,96,71,45,20,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,149,149,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,149,149,149,149,147,143,135,121,107,89,69,49,28,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,27,50,75,98,121,147,149,149,142,116,93,70,46,21,0,12,35,58,81,104,129,149,149,149,149,149,149,149,149,149,149,147,121,99,76,53,30,0,0,0,0,0,0,0,8,30,51,72,91,107,123,137,144,147,149,149,149,149,121,99,73,50,25,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,21,44,67,90,113,137,160,183,185,185,192,194,187,176,162,145,124,107,86,65,45,23,1,0,0,0,0,0,0,0,0,6,28,49,71,92,113,136,157,157,147,138,121,96,73,48,25,0,2,25,50,73,99,124,138,148,158,155,135,112,91,70,48,25,4,0,0,0,0,0,0,0,25,50,75,101,121,121,121,121,121,121,121,121,121,121,121,119,96,70,45,20,0,0,0,0,0,0,0,0,0,0,0,2,27,50,75,98,121,121,121,121,121,117,96,70,48,22,0,0,0,0,0,0,0,0,0,0,7,32,55,80,103,121,121,121,121,121,121,116,110,100,88,71,55,36,16,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,0,0,0,0,20,44,68,92,115,121,121,121,121,119,96,73,48,22,0,12,35,58,80,103,121,121,121,121,121,121,121,121,121,121,121,121,119,98,75,53,30,0,0,0,0,0,0,0,0,17,38,56,73,89,101,112,118,121,121,121,121,121,119,98,73,50,25,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,3,27,50,73,96,119,143,166,172,175,175,173,170,163,155,143,129,110,92,73,53,33,12,0,0,0,0,0,0,0,0,0,0,16,38,58,80,100,121,144,135,123,114,104,88,68,45,22,0,0,22,47,68,90,104,114,124,135,143,121,99,79,57,36,15,0,0,0,0,0,0,0,0,21,45,69,89,99,99,99,99,99,99,99,99,99,99,99,98,85,64,41,16,0,0,0,0,0,0,0,0,0,0,0,0,23,44,67,85,96,96,96,96,96,95,83,63,42,18,0,0,0,0,0,0,0,0,0,0,4,28,50,72,90,99,99,99,99,98,96,93,87,78,67,53,37,20,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,37,59,80,94,96,96,96,96,96,83,65,42,18,0,8,30,51,73,90,99,99,99,99,99,99,99,99,99,99,99,99,98,87,69,47,25,0,0,0,0,0,0,0,0,2,21,38,54,68,80,88,93,96,99,99,99,99,98,85,66,44,21,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,7,30,53,78,101,124,139,144,147,149,149,149,146,140,132,119,107,92,76,58,39,20,0,0,0,0,0,0,0,0,0,0,0,4,25,46,67,88,109,119,110,100,90,81,69,55,34,14,0,0,14,36,55,71,81,91,101,110,121,108,87,66,45,24,2,0,0,0,0,0,0,0,0,12,33,53,67,73,73,73,73,73,73,73,73,73,73,73,73,65,49,29,7,0,0,0,0,0,0,0,0,0,0,0,0,13,32,51,65,73,73,73,73,73,73,65,49,31,9,0,0,0,0,0,0,0,0,0,0,0,18,38,56,68,73,73,73,73,73,71,68,63,56,45,33,18,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,26,44,60,70,71,71,71,71,70,63,49,30,8,0,0,21,40,56,68,73,73,73,73,73,73,73,73,73,73,73,73,73,66,53,34,15,0,0,0,0,0,0,0,0,0,4,20,34,46,57,64,69,72,73,73,73,73,73,65,51,32,12,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,5,28,50,73,94,106,114,119,121,121,121,121,119,114,108,98,86,73,58,40,24,6,0,0,0,0,0,0,0,0,0,0,0,0,13,33,55,76,91,96,87,77,67,57,47,36,19,1,0,0,1,21,36,48,58,67,78,88,96,90,74,54,32,11,0,0,0,0,0,0,0,0,0,0,17,33,44,48,48,48,48,48,48,48,48,48,48,48,48,42,30,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,31,43,48,48,48,48,48,47,42,30,15,0,0,0,0,0,0,0,0,0,0,0,0,4,20,35,45,48,48,48,48,48,47,44,39,33,23,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,25,38,45,45,45,45,45,45,40,29,13,0,0,0,6,22,35,45,48,48,48,48,48,48,48,48,48,48,48,48,48,43,33,19,0,0,0,0,0,0,0,0,0,0,0,0,13,24,33,40,45,48,48,48,48,48,48,43,31,15,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,180,162,144,121,104,86,66,48,0,0,20,40,58,74,83,89,93,96,99,99,98,95,91,84,75,65,52,38,22,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,40,57,68,70,64,54,44,34,24,14,0,0,0,0,0,2,14,25,34,45,55,64,71,67,56,38,19,0,0,0,0,0,0,0,0,0,0,0,0,11,19,22,22,22,22,22,22,22,22,22,22,22,22,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,19,22,22,22,22,22,22,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,20,22,22,22,22,22,22,19,15,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,14,19,20,20,20,20,20,16,7,0,0,0,0,0,2,13,20,22,22,22,22,22,22,22,22,22,22,22,22,22,19,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,10,16,20,22,22,22,22,22,22,19,9,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,165,175,162,144,121,104,86,66,48,0,0,7,24,40,51,59,65,69,73,73,73,73,70,66,61,53,42,32,19,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,36,43,45,41,31,21,11,1,0,0,0,0,0,0,0,0,2,12,22,31,41,45,43,34,20,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,50,68,88,106,124,147,149,149,149,144,121,104,86,66,48,0,0,0,6,20,28,35,41,45,48,48,48,48,46,43,37,30,21,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,12,18,20,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,16,20,18,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,50,68,88,106,121,121,121,121,121,121,119,103,86,65,48,0,0,0,0,0,4,11,16,20,22,22,22,22,22,18,13,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,44,61,78,90,96,96,96,96,96,96,96,88,76,58,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,32,46,59,67,71,71,71,71,71,71,70,66,57,44,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,26,37,43,45,45,45,45,45,45,45,42,36,25,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,13,18,20,20,20,20,20,20,20,17,12,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,18,24,25,25,25,25,25,20,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,11,16,21,24,25,29,30,27,25,22,19,13,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,8,13,17,21,23,25,25,25,25,25,22,18,14,8,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,10,16,21,25,27,27,27,25,21,16,11,10,10,10,10,10,10,10,10,10,9,3,0,0,0,0,0,0,0,13,22,25,25,25,25,25,25,25,24,19,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,24,19,8,0,0,0,0,0,0,0,0,0,0,0,3,12,18,22,25,25,22,17,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,27,41,49,50,50,50,50,50,44,32,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,19,28,35,41,45,49,50,53,53,52,50,47,43,37,32,24,15,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,11,20,26,32,38,42,45,48,50,50,50,50,48,46,43,38,33,27,19,11,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,16,25,33,40,45,48,50,50,50,49,45,40,35,35,35,35,35,35,35,35,35,35,34,26,14,0,0,0,0,0,19,35,45,50,50,50,50,50,50,50,50,42,30,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,35,45,50,50,50,50,50,50,50,50,42,29,11,0,0,0,0,0,0,0,0,0,14,25,35,42,47,48,48,47,41,33,24,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,45,62,72,73,73,73,73,73,66,51,31,12,0,0,0,0,0,0,0,0,0,0,0,0,11,22,32,42,51,59,64,70,73,76,78,78,76,75,71,67,61,55,46,38,27,16,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,16,25,34,42,50,56,62,66,70,73,73,76,76,73,73,71,68,62,57,50,42,33,23,13,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,28,38,48,57,64,69,73,76,76,76,73,69,64,58,58,58,58,58,58,58,58,58,58,56,48,33,14,0,0,0,14,35,53,69,76,76,76,76,76,76,76,74,64,47,27,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,35,53,69,76,76,76,76,76,76,76,74,63,45,27,5,0,0,0,0,0,0,3,19,33,47,57,66,72,73,73,72,65,56,45,32,17,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,38,59,81,97,99,99,99,99,98,87,66,43,21,0,0,0,0,0,0,0,0,0,0,5,18,31,44,55,65,73,82,88,93,97,99,101,104,101,99,96,91,85,78,69,59,48,38,24,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,17,28,38,49,57,65,73,80,86,91,93,98,99,99,101,99,98,94,91,86,81,73,65,56,46,36,23,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,21,36,48,59,71,79,86,93,96,99,99,99,96,93,87,83,83,83,83,83,83,83,83,83,83,81,67,50,28,6,0,0,24,45,69,89,98,99,99,99,99,99,99,97,83,62,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,45,69,89,98,99,99,99,99,99,99,97,81,59,38,14,0,0,0,0,0,1,19,37,53,67,80,90,97,99,99,96,89,79,65,51,34,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,68,92,116,124,124,124,124,121,98,73,48,25,0,0,0,0,0,0,0,0,0,9,24,39,52,65,76,88,97,106,112,118,121,124,129,129,124,123,119,114,109,101,92,82,71,58,45,31,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,26,39,50,61,72,81,90,98,104,109,115,119,121,124,124,124,124,121,119,116,110,105,97,89,79,69,57,45,31,17,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,23,40,55,69,82,92,102,109,116,121,124,124,124,121,116,110,106,106,106,106,106,106,106,106,106,106,101,83,60,35,13,0,2,27,50,76,101,123,124,124,124,124,124,124,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,101,123,124,124,124,124,124,124,116,91,65,43,17,0,0,0,0,0,13,33,52,69,87,101,113,121,124,124,119,112,99,83,67,50,31,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,27,51,74,98,121,147,152,152,143,118,94,71,47,23,0,0,0,0,0,0,0,0,10,28,43,58,73,86,99,109,121,130,137,144,147,152,152,153,152,149,146,140,134,124,115,104,92,79,65,50,35,17,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,20,35,48,61,73,83,94,104,113,121,129,136,142,144,149,149,152,152,152,149,146,142,137,130,121,112,101,91,79,66,52,37,22,5,0,0,0,0,0,0,0,0,0,0,0,0,4,22,40,58,74,89,103,115,124,135,141,147,149,152,149,147,142,136,134,134,134,134,134,134,134,134,134,134,111,88,63,38,15,0,2,27,50,76,101,124,152,152,152,152,152,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,101,124,152,152,152,152,152,144,116,91,66,43,17,0,0,0,0,3,24,44,65,84,103,119,136,146,152,152,145,134,117,101,82,63,42,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,33,57,81,105,130,152,176,160,137,111,88,65,41,17,0,0,0,0,0,0,0,10,28,44,62,78,92,107,119,134,144,153,161,167,172,175,177,178,177,173,170,163,156,148,138,129,113,99,85,69,53,35,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,25,40,55,69,81,95,106,116,129,137,145,153,160,165,169,172,175,176,177,175,173,170,165,160,153,145,136,124,113,100,87,72,57,40,23,6,0,0,0,0,0,0,0,0,0,0,0,18,38,56,74,92,109,123,137,148,157,164,170,173,175,173,170,165,158,157,157,157,157,157,157,157,157,157,139,111,88,63,38,15,0,2,27,50,76,101,124,152,177,177,177,167,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,101,124,152,177,177,177,167,144,116,91,66,43,17,0,0,0,0,9,31,53,74,96,116,138,155,169,176,175,167,154,136,114,93,72,50,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,64,87,111,137,160,177,154,132,106,81,58,34,10,0,0,0,0,0,0,6,25,44,62,79,96,112,129,141,155,166,176,184,191,196,198,195,195,197,198,194,188,180,171,160,148,135,119,103,87,69,53,34,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,28,44,60,74,90,103,115,129,140,150,160,168,177,172,165,162,157,157,155,157,157,160,162,168,174,176,168,158,147,136,121,107,92,75,58,40,23,4,0,0,0,0,0,0,0,0,0,10,31,52,72,91,110,129,144,158,170,180,183,175,170,167,168,173,181,183,182,182,182,182,182,182,182,182,162,139,111,88,63,38,15,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,12,35,57,78,101,124,147,169,189,200,200,186,167,144,121,99,76,54,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,46,70,93,117,142,165,171,147,121,98,75,52,28,4,0,0,0,0,0,0,21,41,60,79,96,114,132,148,163,176,188,199,193,184,178,173,172,170,172,175,181,189,199,194,182,169,155,139,121,105,87,69,50,30,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,29,46,63,80,95,109,124,138,150,163,173,173,164,155,148,142,137,134,132,132,132,132,136,139,144,151,159,168,179,169,156,143,129,110,93,76,58,40,21,2,0,0,0,0,0,0,0,0,21,42,64,86,105,124,145,162,177,191,175,163,152,145,144,144,151,161,173,189,206,199,181,171,170,170,170,162,139,111,88,63,38,15,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,12,35,58,81,103,124,149,172,194,211,210,192,170,147,121,99,78,55,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,28,53,77,100,124,149,172,164,141,116,93,69,45,21,0,0,0,0,0,0,14,34,55,75,94,113,134,150,167,182,196,195,182,171,161,154,149,147,147,147,152,157,166,177,189,203,189,174,159,141,121,103,84,65,45,24,4,0,0,0,0,0,0,0,0,0,0,0,0,0,10,28,47,64,82,98,114,130,146,160,172,173,162,150,140,132,121,116,111,107,105,104,104,106,109,113,118,124,136,146,156,170,177,162,148,130,112,93,74,56,36,16,0,0,0,0,0,0,0,8,31,54,75,98,118,141,161,179,193,174,157,141,129,119,116,119,129,139,155,171,190,188,164,147,144,144,144,144,139,111,88,63,38,15,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,11,33,55,78,99,121,144,163,179,187,186,177,161,141,118,97,75,52,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,59,83,106,132,155,178,158,134,109,86,62,39,15,0,0,0,0,0,5,27,48,68,88,109,130,148,168,184,201,193,176,161,149,139,132,124,119,119,121,129,135,144,156,170,184,202,193,175,157,139,118,99,79,57,38,15,0,0,0,0,0,0,0,0,0,0,0,0,8,26,45,64,82,99,116,136,150,165,180,166,153,140,129,116,107,99,93,86,83,81,78,80,81,85,89,94,102,111,121,136,148,163,179,166,148,130,110,91,71,51,30,9,0,0,0,0,0,0,16,40,62,85,108,132,154,174,194,180,159,140,121,107,98,93,96,105,119,137,156,177,185,160,137,119,119,119,119,119,109,87,62,37,14,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,6,28,49,70,91,110,130,145,157,162,162,155,144,129,108,88,67,46,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,41,65,90,113,138,162,176,152,129,103,80,56,32,8,0,0,0,0,0,15,37,59,81,101,121,144,164,182,202,192,175,157,143,129,115,106,99,96,96,98,102,110,121,136,150,168,184,203,192,173,154,134,112,92,70,48,27,5,0,0,0,0,0,0,0,0,0,0,2,23,43,62,80,98,117,136,154,170,176,161,146,132,117,105,95,85,76,69,63,59,55,55,55,57,60,65,71,79,89,100,114,129,144,161,179,164,146,124,106,86,65,43,21,0,0,0,0,0,0,22,46,69,93,116,140,163,186,192,169,147,124,105,87,74,69,73,85,101,121,144,165,188,170,150,129,105,93,93,93,90,76,55,32,10,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,6,9,10,10,10,8,4,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,19,39,59,78,94,110,123,134,137,137,132,121,109,92,76,56,37,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,48,72,96,119,144,168,169,145,119,98,73,49,26,2,0,0,0,0,3,26,48,70,91,113,137,157,178,198,196,177,158,139,121,106,92,82,75,71,71,73,78,88,99,114,132,150,169,188,207,188,167,147,124,103,81,59,38,15,0,0,0,0,0,0,0,0,0,0,17,37,57,77,96,116,136,154,171,175,157,141,124,109,97,83,72,61,53,45,38,34,31,30,30,32,35,41,48,56,66,79,92,109,124,144,162,181,162,141,119,99,77,55,33,11,0,0,0,0,2,26,51,75,99,121,147,171,195,186,162,139,114,91,71,53,45,50,67,88,110,134,157,181,183,161,138,114,90,68,68,66,57,40,20,0,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,24,30,34,35,35,35,32,28,22,15,5,0,0,0,0,0,0,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,7,26,44,62,77,90,100,107,110,109,106,99,88,74,59,42,24,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,31,54,78,102,124,151,174,163,139,114,91,67,43,20,0,0,0,0,0,12,35,57,80,103,124,147,169,191,205,183,163,143,121,103,87,72,59,51,47,45,49,55,66,80,96,114,135,154,174,195,201,180,158,137,114,92,69,47,24,1,0,0,0,0,0,0,0,0,9,31,52,72,92,112,134,152,171,175,157,139,121,105,90,75,62,49,39,29,29,34,35,35,34,29,21,22,25,25,33,45,58,73,89,107,124,146,165,176,155,134,110,89,67,44,21,0,0,0,0,5,29,53,78,101,129,152,176,200,182,157,134,108,84,61,37,21,33,56,80,103,129,152,177,191,168,144,119,96,71,47,44,36,23,6,0,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,49,55,59,60,60,60,57,53,46,38,28,16,5,0,0,0,0,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,0,11,28,43,57,68,77,83,86,86,82,76,66,55,42,26,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,38,61,85,109,134,157,180,156,132,108,85,61,36,13,0,0,0,0,0,20,44,66,89,112,136,158,180,202,194,172,149,129,107,88,69,53,38,28,22,22,25,33,46,62,80,99,119,141,162,183,205,191,170,147,123,101,78,55,33,9,0,0,0,0,0,0,0,0,22,44,65,86,107,129,148,168,177,158,139,119,103,85,71,55,41,28,39,47,54,58,60,60,59,53,45,46,50,50,50,50,50,54,71,91,109,132,152,172,167,146,123,100,77,54,31,8,0,0,0,5,30,55,78,104,129,154,178,203,180,157,132,106,81,57,33,7,27,53,76,101,124,152,175,196,172,147,121,98,73,48,25,13,2,0,0,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,64,73,79,83,86,86,85,81,77,69,61,50,38,25,11,0,0,0,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,3,21,38,54,65,68,68,68,68,68,68,68,68,64,52,36,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,44,67,91,115,139,163,173,150,124,101,78,54,30,7,0,0,0,0,4,27,51,73,98,121,144,167,189,205,183,161,138,116,94,74,53,35,18,5,0,0,1,12,27,46,65,86,107,129,152,173,196,201,179,155,134,109,86,63,39,16,0,0,0,0,0,0,0,12,34,56,78,99,121,143,163,181,161,141,121,103,85,67,51,36,37,49,61,70,78,83,85,86,83,76,66,68,73,73,73,73,73,67,55,74,95,116,139,161,179,156,134,109,87,63,40,16,0,0,0,5,30,54,78,103,129,153,177,202,180,157,132,106,81,58,33,9,28,53,78,101,129,152,177,198,172,149,121,99,73,48,25,0,0,0,0,0,2,27,50,76,101,124,152,177,200,193,167,142,116,91,76,87,96,103,108,109,111,109,106,101,93,83,72,59,45,30,13,0,0,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,12,33,53,72,88,93,93,93,93,93,93,93,93,86,70,50,29,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,27,51,73,98,121,146,170,167,144,119,95,72,48,24,0,0,0,0,0,10,33,57,81,104,129,152,175,198,197,175,152,129,106,82,62,40,19,0,0,0,0,0,0,11,31,52,73,96,117,141,164,188,210,188,163,141,116,93,69,46,23,0,0,0,0,0,0,0,23,46,69,90,112,134,155,177,167,146,124,105,87,68,49,33,44,58,72,83,93,101,106,109,109,106,100,88,90,99,99,99,99,99,89,69,61,81,104,129,150,173,166,144,118,95,71,47,24,0,0,0,4,27,53,76,101,124,150,174,198,183,159,136,110,86,63,41,29,38,59,82,106,132,154,178,194,170,146,119,96,72,48,23,0,0,0,0,0,2,27,50,76,101,124,152,177,200,190,167,142,116,91,98,109,118,129,134,137,137,136,132,124,115,105,93,80,65,47,31,13,0,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,105,119,119,119,119,119,119,119,118,101,80,57,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,33,57,80,104,129,152,176,160,137,112,88,65,41,17,0,0,0,0,0,15,39,63,86,110,136,158,182,205,191,168,144,119,97,73,51,28,7,0,0,0,0,0,0,0,19,41,64,86,109,134,157,180,204,194,170,147,121,99,75,51,28,3,0,0,0,0,0,11,33,56,79,101,124,146,168,175,154,132,110,91,71,51,33,47,63,79,92,105,116,124,132,137,137,132,121,109,103,124,124,124,124,124,101,76,53,71,93,116,141,164,175,152,129,102,78,54,30,6,0,0,0,24,49,72,96,119,144,168,190,188,164,141,117,95,76,59,53,57,72,91,113,137,160,183,188,165,141,116,93,68,45,20,0,0,0,0,0,2,27,50,76,101,124,152,177,200,190,166,142,114,107,119,134,143,152,157,162,162,160,155,149,139,129,114,99,83,65,47,29,9,0,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,147,147,147,147,147,147,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,63,86,110,136,159,178,154,132,106,82,59,35,11,0,0,0,0,0,20,43,68,91,114,139,163,188,209,185,162,138,114,90,66,43,20,0,0,0,0,0,0,0,0,9,33,56,79,102,129,151,175,198,200,176,152,129,104,80,56,32,8,0,0,0,0,0,21,44,66,90,112,136,158,181,163,141,118,97,76,56,36,47,64,82,98,113,129,140,150,157,161,162,156,144,129,111,136,152,152,149,121,98,74,50,61,84,108,134,157,181,159,134,109,84,60,35,11,0,0,0,19,43,65,90,113,136,158,179,196,173,152,130,109,92,81,77,80,90,106,124,147,169,191,179,156,134,110,87,63,40,16,0,0,0,0,0,2,27,50,76,101,124,152,177,200,190,165,139,114,129,143,155,166,175,182,186,187,184,180,172,162,150,136,117,101,82,63,43,23,3,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,172,172,172,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,46,70,93,116,142,165,172,147,123,99,75,53,28,4,0,0,0,0,0,23,47,71,95,119,144,168,192,205,181,157,134,108,85,61,37,13,0,0,0,0,0,0,0,0,2,26,49,73,97,121,147,170,194,205,180,157,134,108,83,60,35,11,0,0,0,0,6,30,53,76,100,123,146,169,174,152,129,106,84,63,42,44,63,82,99,117,134,148,162,173,181,177,177,179,164,144,121,143,167,168,144,117,93,69,45,53,77,101,124,150,174,163,139,114,90,65,40,16,0,0,0,12,35,57,80,102,123,145,165,184,184,164,144,129,114,105,101,103,112,124,141,161,180,186,166,146,123,101,78,56,33,9,0,0,0,0,0,2,27,50,76,101,124,152,177,200,188,165,139,134,149,163,177,182,178,177,178,182,189,199,195,183,170,154,137,117,98,78,57,36,14,0,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,195,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,28,52,76,99,123,148,172,165,142,116,93,69,46,22,0,0,0,0,0,1,25,50,73,98,121,147,172,195,203,177,154,129,104,80,56,32,8,0,0,0,0,0,0,0,0,0,22,45,70,93,116,142,167,190,208,184,160,137,111,86,63,38,14,0,0,0,0,14,38,61,85,109,134,156,179,163,140,116,94,72,50,37,58,79,98,117,136,154,169,181,167,158,152,152,155,164,158,142,152,174,163,139,114,88,64,40,46,70,95,119,145,170,169,144,117,93,68,43,19,0,0,0,3,25,47,69,90,110,132,150,168,184,179,162,148,137,129,124,129,135,146,160,177,186,171,152,134,112,90,69,46,24,1,0,0,0,0,0,2,27,50,76,101,124,152,177,200,194,172,155,155,168,175,166,158,154,152,154,159,166,178,191,204,189,171,153,134,112,91,69,47,25,3,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,35,59,83,106,132,155,178,159,135,110,86,63,40,16,0,0,0,0,0,2,27,50,76,99,124,150,175,198,200,175,152,124,101,78,53,30,5,0,0,0,0,0,0,0,0,0,18,42,66,91,114,139,165,188,211,187,162,139,114,88,63,40,15,0,0,0,0,21,45,69,93,116,142,165,178,154,132,106,83,61,39,50,72,92,113,134,154,171,179,162,146,135,129,124,132,143,159,167,172,183,159,134,109,83,59,35,41,65,91,114,142,165,172,147,121,96,71,47,22,0,0,0,0,15,36,56,76,95,114,134,148,167,191,181,170,160,153,152,152,158,167,179,179,167,152,136,116,98,78,57,36,14,0,0,0,0,0,0,2,27,50,76,101,124,152,177,200,208,190,179,178,167,154,144,135,129,129,129,135,144,157,173,191,206,187,167,147,124,103,81,57,36,12,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,41,65,89,112,137,161,176,152,129,104,80,56,33,9,0,0,0,0,0,4,27,53,76,101,124,152,175,200,200,175,149,124,99,76,50,27,2,0,0,0,0,0,0,0,0,0,16,40,64,88,112,139,162,187,211,187,165,139,114,88,66,40,16,0,0,0,4,28,52,76,100,124,150,173,169,146,121,98,73,50,40,62,84,106,129,148,169,181,161,143,124,110,102,101,107,123,143,163,185,178,154,129,103,79,55,30,38,63,88,111,139,162,175,149,121,98,73,48,22,0,0,0,0,5,25,44,63,82,99,114,137,162,175,165,167,175,177,175,176,178,173,166,157,146,134,117,99,82,64,44,24,3,0,0,0,0,0,0,2,27,50,76,101,124,152,177,200,211,193,177,161,146,132,119,109,103,101,104,110,121,137,155,175,196,201,180,158,136,113,90,67,44,20,0,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,72,95,118,144,167,170,146,121,98,74,50,27,3,0,0,0,0,0,5,30,53,78,101,129,152,176,200,198,175,149,124,99,76,50,27,2,0,0,0,0,0,0,0,0,0,15,39,63,88,111,139,162,187,210,189,165,139,114,91,66,40,17,0,0,0,9,33,57,81,106,132,155,180,162,139,113,89,65,42,50,73,96,118,141,163,183,165,146,124,107,91,78,76,87,106,129,154,180,173,149,123,98,74,50,25,35,60,86,111,137,162,175,149,121,99,73,48,22,0,0,0,0,16,38,59,79,98,116,135,150,169,157,140,144,151,155,157,157,154,149,143,135,123,112,98,82,65,47,29,10,0,0,0,0,0,0,0,2,27,50,76,101,124,152,177,200,198,178,159,143,124,110,98,87,79,76,79,88,101,119,141,162,184,206,191,169,146,121,98,75,52,28,4,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,54,78,101,124,150,174,163,139,114,91,67,43,20,0,0,0,0,0,0,5,29,53,78,101,129,152,176,200,198,175,149,124,99,76,50,27,2,0,0,0,0,0,0,0,0,0,15,40,63,88,111,139,162,187,210,188,165,139,114,89,66,40,17,0,0,0,13,38,62,87,111,137,162,181,157,132,106,83,58,36,59,83,106,130,153,175,175,154,132,109,90,72,56,58,83,106,134,157,182,168,144,118,93,69,45,20,35,60,83,109,137,162,175,149,121,99,73,48,22,0,0,0,3,26,49,71,92,112,134,152,169,161,141,121,119,129,132,134,132,130,124,119,111,101,91,78,64,47,31,13,0,0,0,0,0,0,0,0,2,27,50,76,101,124,152,177,200,193,168,144,123,106,91,76,64,55,51,55,67,86,106,129,152,174,197,200,177,153,132,106,81,58,34,10,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,37,61,84,108,132,156,180,157,134,108,85,61,37,14,0,0,0,0,0,0,4,27,53,76,101,124,152,175,200,200,175,152,124,101,76,52,28,4,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,212,187,164,139,114,88,65,40,15,0,0,0,17,42,66,91,116,142,166,175,152,124,101,77,53,44,68,92,115,139,163,186,165,143,118,97,74,55,38,62,86,111,137,162,186,163,139,114,89,64,40,16,35,60,86,111,137,162,175,149,121,99,73,48,22,0,0,0,9,33,57,80,103,124,148,167,175,152,129,105,97,102,106,106,106,104,101,95,89,80,69,57,44,29,14,7,0,0,0,0,0,0,0,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,72,56,42,32,27,33,51,73,96,119,143,166,190,207,183,160,137,111,87,63,39,14,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,67,91,114,139,163,174,151,124,101,78,54,31,8,0,0,0,0,0,0,2,27,50,75,99,123,149,172,198,201,177,152,129,102,78,55,31,6,0,0,0,0,0,0,0,0,0,20,43,68,91,116,142,165,190,210,185,162,137,111,88,63,40,15,0,0,0,20,45,69,93,119,145,170,172,148,121,98,73,48,51,75,98,121,147,172,180,157,134,109,86,63,40,42,66,91,116,142,166,183,159,134,109,84,60,35,14,39,63,88,114,139,165,172,147,121,96,72,47,22,0,0,0,14,39,62,86,110,135,158,181,173,149,121,99,73,78,81,83,81,80,77,72,65,57,55,52,49,44,37,30,21,9,0,0,0,0,0,0,2,27,50,76,101,124,152])
.concat([177,200,193,167,144,116,93,68,43,22,9,2,18,41,65,88,112,137,160,185,208,189,165,141,115,91,67,43,19,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,26,50,73,97,121,145,169,167,144,119,96,72,48,24,1,0,0,0,0,0,0,0,25,48,73,96,121,147,170,194,203,180,155,132,106,83,58,35,10,0,0,0,0,0,0,0,0,0,23,47,71,95,119,144,168,192,206,182,159,134,109,86,60,37,12,0,0,0,22,47,71,96,121,148,173,170,144,119,93,69,45,56,80,104,130,154,179,174,150,124,101,77,53,29,46,70,96,119,146,170,178,154,129,104,79,55,30,19,44,68,93,116,143,167,169,144,118,93,68,44,20,0,0,0,15,40,65,88,114,139,164,188,175,150,129,104,89,83,81,81,81,81,81,81,81,81,78,76,73,67,61,52,42,31,18,4,0,0,0,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,11,35,59,83,106,132,157,181,205,193,168,144,119,93,70,45,21,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,56,80,103,129,152,175,161,138,113,89,65,41,18,0,0,0,0,0,0,0,0,22,45,70,93,116,143,167,190,207,183,160,136,110,87,63,40,16,0,0,0,0,0,0,0,0,5,28,52,76,99,123,147,172,196,202,178,154,132,106,81,57,34,9,0,0,0,24,48,73,99,124,149,175,167,144,116,91,66,41,59,83,109,134,160,184,170,145,119,96,70,46,26,51,75,99,124,150,175,173,149,124,99,75,50,25,27,51,74,98,121,147,172,163,139,114,89,65,41,16,0,0,0,15,40,63,88,114,139,163,187,181,160,139,121,113,109,106,106,106,106,106,106,106,104,104,101,96,91,84,75,64,52,38,22,4,0,0,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,6,31,55,79,104,129,154,178,203,195,170,147,121,96,72,48,22,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,39,62,86,109,135,158,178,155,132,106,83,59,35,11,0,0,0,0,0,0,0,0,18,42,65,90,114,139,162,185,208,188,165,141,116,93,69,46,23,0,0,0,0,0,0,0,0,12,36,59,82,105,130,153,177,201,197,173,150,124,101,78,53,29,5,0,0,0,25,49,73,99,124,152,177,167,142,116,91,66,40,60,86,111,138,162,187,167,143,116,91,66,41,30,55,79,104,130,154,179,167,144,119,93,70,45,20,38,60,83,106,132,155,178,157,134,109,84,60,35,11,0,0,0,14,38,62,86,110,135,158,181,193,173,157,145,137,134,132,132,132,132,132,132,132,132,129,124,119,114,106,97,85,72,56,38,21,1,0,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,4,29,53,78,101,129,152,177,202,198,172,149,121,96,73,48,22,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,45,69,93,116,141,164,172,148,124,100,76,53,29,5,0,0,0,0,0,0,0,0,13,36,61,84,108,134,155,180,203,194,171,147,123,100,77,55,32,10,0,0,0,0,0,0,0,22,44,66,90,112,137,160,183,206,190,167,144,119,96,72,48,25,1,0,0,0,25,50,73,99,124,152,177,167,142,114,91,66,40,63,86,111,139,165,190,167,142,114,91,66,40,39,59,83,109,134,159,183,162,139,113,88,64,40,31,50,72,93,116,140,163,172,149,124,101,77,53,29,6,0,0,0,9,33,57,80,103,124,147,166,182,191,178,167,160,157,157,157,157,157,157,157,157,154,152,150,145,139,130,118,105,91,73,55,36,14,0,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,2,27,53,76,101,129,152,177,200,198,172,149,121,96,73,48,22,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,28,52,75,98,121,147,171,165,142,117,93,70,46,22,0,0,0,0,0,0,0,0,0,8,31,55,78,101,124,149,172,195,200,178,155,132,109,86,65,43,22,2,0,0,0,0,0,13,33,54,76,98,121,145,167,190,206,183,160,137,112,90,66,42,19,0,0,0,0,25,48,73,99,124,152,175,167,144,116,91,66,40,63,86,111,139,164,188,167,143,116,93,68,45,58,74,92,112,139,163,185,160,137,109,83,59,34,48,65,85,106,129,150,173,163,139,115,92,69,45,22,0,0,0,0,3,26,48,71,92,112,132,148,164,184,197,190,184,182,180,180,180,180,180,180,180,180,177,173,168,161,152,140,124,108,89,69,48,25,4,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,5,29,53,78,101,129,152,177,203,196,172,147,121,96,73,48,22,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,34,58,82,106,130,154,177,160,136,111,87,63,40,16,0,0,0,0,0,0,0,0,0,2,24,48,71,94,116,141,163,186,208,187,164,141,118,97,76,56,37,19,5,0,0,0,12,28,47,67,88,109,132,154,176,199,196,174,152,129,105,82,59,36,12,0,0,0,0,22,48,73,98,121,149,175,170,144,118,93,68,43,60,86,109,137,160,185,171,147,121,99,77,69,78,92,109,129,148,169,185,160,136,109,83,59,57,68,83,100,119,141,163,173,152,129,106,83,59,37,14,0,0,0,0,2,21,38,58,78,96,113,130,152,177,173,170,174,177,180,180,180,180,180,180,180,183,188,196,192,184,174,161,143,123,103,80,58,35,12,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,7,32,56,80,104,130,154,180,203,193,170,145,119,95,71,47,22,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,41,64,88,111,137,160,176,153,129,105,81,57,33,9,0,0,0,0,0,0,0,0,0,0,16,41,63,86,108,132,154,175,197,197,174,153,132,109,90,71,54,38,27,20,20,23,32,46,62,81,100,121,143,164,186,208,187,165,143,119,96,74,51,28,5,0,0,0,0,22,47,71,96,121,147,172,172,147,121,96,71,47,57,81,106,132,155,180,178,155,134,112,98,93,100,112,129,146,164,171,182,162,139,114,92,81,81,89,103,117,137,156,176,159,139,116,95,72,49,27,4,0,0,0,0,15,36,55,74,91,109,124,139,156,168,152,145,150,152,154,154,154,154,154,154,157,160,164,173,186,202,194,178,157,137,113,90,66,42,19,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,12,36,60,84,108,134,157,182,206,190,166,142,116,92,68,44,20,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,47,71,95,117,143,167,170,147,121,98,74,51,27,3,0,0,0,0,0,0,0,0,0,0,8,31,54,76,98,119,143,164,185,205,186,165,145,124,105,88,73,59,50,45,45,47,55,67,81,98,116,136,155,177,197,196,174,154,132,109,87,65,42,19,0,0,0,0,0,19,43,68,93,116,144,168,175,151,124,101,77,52,52,76,100,123,147,171,189,167,148,134,121,119,123,135,148,164,148,147,166,170,148,129,112,106,106,112,123,138,155,173,164,144,124,103,82,61,38,16,0,0,0,0,5,27,48,69,89,109,129,144,159,170,152,134,121,124,129,132,132,132,132,132,132,132,136,142,152,168,186,206,190,167,144,119,96,72,47,23,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,21,43,66,90,114,138,162,186,209,185,161,138,112,88,65,40,16,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,30,53,77,101,124,150,173,164,140,115,92,68,44,20,0,0,0,0,0,0,0,0,0,0,0,0,22,44,65,87,108,132,152,172,191,199,179,160,141,123,107,93,82,74,70,68,72,78,88,100,116,134,152,170,190,202,182,162,141,119,98,76,55,32,10,0,0,0,0,0,16,40,65,90,114,139,164,180,156,132,106,82,58,45,68,91,114,137,158,178,184,168,155,147,147,148,156,167,150,132,135,159,182,164,148,137,132,132,137,146,158,173,164,147,129,109,89,69,48,26,5,0,0,0,0,14,37,59,81,103,123,144,162,179,156,136,116,98,101,103,104,104,104,104,104,104,106,110,117,134,152,173,196,197,172,149,121,99,73,50,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,21,15,18,34,54,75,98,121,145,168,192,202,178,155,132,107,83,60,35,11,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,17,0,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,36,60,84,107,132,155,180,157,134,109,85,62,38,14,0,0,0,0,0,0,0,0,0,0,0,0,11,32,54,75,96,116,138,157,177,195,194,177,159,143,129,114,105,98,93,93,96,101,109,121,136,152,168,186,204,186,167,148,129,107,86,65,44,22,0,0,0,0,0,0,11,36,60,84,109,134,159,183,163,139,114,90,66,44,58,80,101,121,143,160,174,184,178,172,170,173,163,148,132,114,124,148,168,182,169,160,157,157,160,169,173,160,145,130,110,92,74,55,34,13,0,0,0,0,0,21,45,69,91,114,137,158,178,169,147,123,101,81,77,78,80,81,81,81,81,81,83,87,98,118,142,167,190,198,175,149,121,99,73,50,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,54,45,40,41,52,69,88,109,132,154,176,200,193,171,147,123,100,77,53,29,6,0,2,25,50,76,101,124,152,177,200,193,167,144,116,91,66,43,25,13,0,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,66,90,114,139,162,175,152,129,102,79,55,31,8,0,0,0,0,0,0,0,0,0,0,0,0,0,21,42,62,83,103,121,143,161,179,194,193,177,162,149,138,129,121,119,116,119,124,134,144,156,170,186,202,186,170,152,134,113,92,73,52,32,11,0,0,0,0,0,0,6,30,54,78,103,129,152,176,171,147,121,99,76,54,46,67,87,107,123,140,152,160,165,165,161,153,141,129,112,96,113,134,150,163,172,176,177,175,169,161,152,139,124,109,92,74,58,38,19,0,0,0,0,0,2,26,50,74,98,121,147,169,190,165,142,116,92,69,53,55,55,55,55,55,55,55,58,65,90,114,139,165,190,195,170,147,121,98,73,49,25,0,2,27,50,76,101,124,152,177,200,193,167,144,117,101,88,77,69,65,65,74,87,103,123,144,165,187,205,183,161,139,115,92,69,46,22,0,0,2,25,50,76,101,124,152,176,200,193,167,144,116,91,67,59,47,29,11,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,49,73,96,119,144,168,168,144,119,96,73,49,25,1,0,0,0,0,0,0,0,0,0,0,0,0,0,8,28,49,69,88,107,124,143,159,175,189,197,183,171,161,153,147,144,144,147,150,157,166,177,190,196,182,167,152,136,116,98,79,59,39,19,0,0,0,0,0,0,0,0,24,48,72,95,119,144,167,179,156,134,109,88,66,45,52,71,89,105,117,129,137,141,142,137,129,118,106,92,78,98,114,129,140,147,152,152,150,145,138,129,116,104,90,74,58,40,22,4,0,0,0,0,0,4,29,53,77,101,124,152,175,190,165,142,116,92,70,55,47,42,40,40,41,45,52,63,78,97,119,143,167,190,187,164,141,116,93,70,45,21,0,2,27,50,76,101,124,152,177,200,196,173,154,137,121,109,100,93,90,90,96,107,121,141,159,178,198,192,172,150,129,105,83,60,37,15,0,0,2,25,50,76,99,124,152,175,200,193,167,144,116,93,88,82,65,45,23,0,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,56,79,103,129,152,175,162,139,114,90,66,42,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,34,53,72,89,107,123,141,155,170,181,192,193,184,176,172,170,170,170,174,180,188,196,187,175,162,148,134,116,99,82,63,45,25,5,0,0,0,0,0,0,0,0,16,40,64,87,111,136,157,180,167,145,121,100,79,59,39,53,69,83,95,105,111,114,114,111,105,96,84,72,62,79,94,106,115,121,124,129,124,119,114,105,95,83,69,55,39,22,4,0,0,0,0,0,0,4,29,53,77,101,124,152,175,194,170,147,124,104,88,77,70,66,63,63,66,69,75,84,97,112,132,153,175,196,175,154,132,109,86,63,40,16,0,2,27,50,76,101,124,152,177,200,203,188,172,157,144,132,123,116,114,114,119,130,143,157,175,193,198,179,159,138,116,95,72,50,28,5,0,0,0,25,50,73,98,121,148,172,196,196,172,149,124,112,114,100,77,54,29,5,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,38,62,85,109,134,157,179,155,132,107,83,60,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,37,55,73,89,105,119,136,148,160,169,177,184,189,196,194,193,195,198,188,181,173,165,154,141,129,112,98,82,64,47,29,10,0,0,0,0,0,0,0,0,0,8,32,55,78,100,123,147,169,179,157,136,114,94,74,56,38,49,62,73,81,86,88,88,87,81,73,63,51,44,59,72,83,92,98,101,101,99,96,90,81,72,61,49,35,20,4,0,0,0,0,0,0,0,2,26,50,75,98,121,147,170,194,180,159,139,121,109,100,93,91,88,88,88,93,98,106,117,132,148,166,186,180,162,141,119,98,76,55,32,9,0,2,27,50,76,101,124,152,177,200,184,169,162,170,165,155,148,142,139,140,144,152,163,177,193,198,182,164,144,123,103,83,62,39,17,0,0,0,0,21,46,70,93,118,144,167,191,204,182,162,146,139,132,106,81,58,34,9,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,69,92,116,141,163,173,149,124,101,77,53,30,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,21,38,55,71,86,100,114,124,137,146,154,160,165,179,196,217,203,181,165,157,150,141,132,119,107,92,78,63,46,30,12,4,4,0,0,0,0,0,0,0,0,0,22,45,67,90,112,135,156,177,170,150,130,109,91,74,57,43,40,50,57,63,66,66,63,58,50,40,29,25,39,50,61,69,73,76,76,76,72,66,59,50,39,28,14,0,0,0,0,0,0,0,0,0,0,22,46,69,92,115,139,161,180,193,174,157,143,132,123,116,114,111,111,114,116,121,129,139,152,166,182,179,162,146,129,107,86,65,44,22,0,0,2,27,50,76,101,124,152,177,197,174,150,137,150,166,179,172,167,165,165,168,176,186,197,193,179,164,146,129,109,89,69,48,28,6,0,0,0,0,17,41,65,89,112,137,160,182,204,197,181,169,160,137,110,86,62,38,13,0,0,17,40,60,83,106,132,154,177,200,195,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,51,75,98,121,147,170,166,142,118,94,70,47,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,20,36,52,66,80,92,103,113,121,130,136,143,163,184,207,196,173,148,134,124,117,108,97,86,73,58,44,28,18,23,29,30,24,14,0,0,0,0,0,0,0,12,33,56,79,99,121,143,163,183,164,146,129,109,92,77,63,51,40,33,38,40,40,38,34,27,18,16,22,31,39,49,60,66,61,50,50,47,42,35,27,17,6,0,0,0,0,0,0,0,0,0,0,0,15,38,61,83,105,124,146,162,178,190,177,164,155,148,144,139,139,139,139,142,147,153,162,173,182,171,158,144,129,110,92,73,52,32,11,0,0,2,27,50,76,101,124,152,177,182,168,144,119,132,146,161,173,184,190,190,193,196,191,182,172,159,144,129,110,92,74,55,35,14,0,0,0,0,0,11,34,57,81,104,124,148,170,186,195,199,188,164,140,114,90,66,42,17,0,0,17,40,60,83,106,132,154,175,175,175,172,152,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,33,57,81,105,130,153,176,160,137,111,88,64,41,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,17,32,46,58,71,81,90,98,106,110,130,153,173,194,197,174,152,132,110,94,86,75,64,52,43,40,40,42,46,52,52,47,34,17,0,0,0,0,0,0,0,23,44,65,87,107,129,148,168,180,162,144,129,112,98,84,73,63,55,48,42,38,35,35,35,37,41,46,54,62,72,83,91,84,67,46,24,18,11,3,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,50,72,91,110,129,144,158,169,178,185,177,171,167,165,162,162,163,165,170,176,178,170,161,150,138,123,109,92,76,58,38,19,0,0,0,2,27,50,76,101,124,152,160,160,160,139,114,112,124,140,152,162,169,173,175,172,167,160,150,139,123,109,92,76,58,40,20,1,0,0,0,0,0,3,26,49,71,92,114,136,152,164,172,175,175,168,144,119,93,70,46,22,0,0,17,40,60,83,106,132,149,149,149,149,149,149,129,104,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,64,88,111,137,160,177,153,130,106,81,57,34,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,25,37,48,58,68,75,81,97,117,140,161,181,200,186,165,146,130,112,97,86,77,72,67,65,64,66,70,77,78,68,53,33,12,0,0,0,0,0,0,10,31,52,73,92,112,134,152,170,180,164,148,134,118,107,96,86,78,72,67,63,60,58,59,61,65,70,77,85,95,105,114,103,80,56,33,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,57,74,92,109,123,136,146,155,161,165,170,172,172,175,173,172,169,165,160,154,147,138,129,116,103,90,74,58,40,23,5,0,0,0,2,27,50,76,101,124,134,134,134,134,134,109,92,105,117,130,139,145,149,149,147,144,137,129,115,103,90,74,58,40,23,6,0,0,0,0,0,0,0,15,38,59,80,99,116,132,141,147,149,149,147,143,121,98,73,48,25,0,0,17,40,60,83,106,121,121,121,121,121,121,121,121,103,80,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,46,70,94,117,142,166,171,147,121,98,75,51,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,15,25,35,44,51,64,84,105,124,146,166,184,199,182,164,147,134,119,109,101,96,92,90,88,91,95,101,102,87,66,44,20,0,0,0,0,0,0,0,18,38,58,78,96,114,135,152,168,182,167,154,141,130,118,109,101,96,91,86,83,83,83,86,89,94,101,109,117,129,137,112,89,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,23,40,58,74,89,103,114,123,132,138,142,146,149,149,149,149,147,145,142,137,132,123,114,105,95,83,70,56,40,24,6,0,0,0,0,0,25,48,72,94,106,106,106,106,106,106,99,79,84,96,105,114,119,121,121,121,117,111,103,93,82,69,55,40,22,6,0,0,0,0,0,0,0,0,4,25,45,64,82,96,107,116,121,121,121,121,116,110,93,70,46,23,0,0,14,36,55,75,92,99,99,99,99,99,99,99,99,90,73,52,31,9,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,53,77,101,124,149,173,164,141,116,93,69,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,12,20,30,51,72,92,110,132,150,168,185,198,182,167,154,143,134,124,119,116,114,114,116,119,124,119,97,73,49,25,3,0,0,0,0,0,0,3,23,43,62,80,98,116,134,149,163,177,174,163,152,143,134,124,119,114,111,109,109,109,110,114,118,124,134,141,152,146,121,98,75,53,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,24,40,55,69,81,91,100,107,113,116,119,121,121,121,121,121,119,116,112,106,100,92,83,73,62,49,36,22,6,0,0,0,0,0,0,17,38,58,74,81,81,81,81,81,81,77,64,62,73,82,90,95,98,99,96,93,88,80,71,60,48,34,20,4,0,0,0,0,0,0,0,0,0,0,11,28,46,62,74,85,92,96,99,99,96,93,87,76,59,38,16,0,0,5,25,42,58,69,73,73,73,73,73,73,73,73,68,56,40,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,36,59,83,107,132,155,179,158,134,109,86,62,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,58,77,96,114,134,150,166,181,196,187,175,164,156,150,144,142,141,139,142,144,149,129,102,78,56,32,8,0,0,0,0,0,0,0,8,26,44,62,80,96,112,129,143,156,167,179,175,165,158,151,145,141,138,137,134,136,137,139,144,150,157,165,174,155,132,108,85,62,38,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,21,35,48,59,69,77,84,88,93,96,98,99,99,99,98,96,92,88,83,77,69,60,50,40,28,16,2,0,0,0,0,0,0,0,5,22,39,51,55,55,55,55,55,55,53,43,40,50,59,65,70,73,73,73,69,64,57,48,38,27,14,0,0,0,0,0,0,0,0,0,0,0,0,0,11,27,41,53,61,68,72,73,73,72,69,63,55,42,24,5,0,0,0,10,24,37,45,48,48,48,48,48,48,48,48,45,35,22,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,42,65,90,114,138,162,175,152,129,103,80,56,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,24,43,62,80,98,114,132,148,162,175,187,197,188,180,174,170,167,165,165,166,168,156,134,108,85,61,37,14,0,0,0,0,0,0,0,0,10,28,46,62,78,93,107,121,135,146,155,165,173,180,175,170,165,162,160,160,160,162,165,168,173,175,166,157,147,136,116,91,66,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,27,37,46,54,61,65,69,73,73,73,73,73,73,71,69,65,59,53,46,38,29,19,7,0,0,0,0,0,0,0,0,0,0,6,20,28,32,33,33,33,33,33,30,22,17,27,35,41,46,48,48,48,45,40,33,25,16,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,20,30,38,44,48,48,48,48,45,40,32,21,6,0,0,0,0,0,3,14,20,22,22,22,22,22,22,22,22,20,13,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,49,72,96,119,144,168,168,145,119,97,73,49,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,27,45,62,80,96,112,129,141,154,165,174,182,188,192,194,190,190,190,190,186,162,139,114,90,67,43,20,0,0,0,0,0,0,0,0,0,10,27,43,58,73,86,99,110,121,134,142,149,156,162,167,170,172,173,175,173,170,167,163,157,151,144,135,123,113,100,83,61,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,14,23,30,36,41,45,48,49,50,50,50,49,47,44,40,35,30,23,15,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,7,7,7,7,7,6,0,0,4,11,17,22,22,22,22,20,16,9,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,14,19,22,22,22,22,20,15,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,31,55,78,102,129,151,175,162,139,114,90,67,43,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,28,45,62,78,92,106,119,132,142,151,158,164,168,171,172,173,172,170,167,162,144,119,96,73,49,24,0,0,0,0,0,0,0,0,0,0,8,24,38,52,66,78,89,100,109,117,124,132,137,142,144,147,149,149,149,147,144,139,134,129,119,110,101,90,79,67,49,28,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,13,17,21,25,25,25,25,25,25,23,21,17,12,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,38,62,85,109,134,157,175,155,132,108,84,61,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,27,43,58,72,86,98,109,118,129,135,140,144,147,149,149,148,147,143,139,132,121,98,73,50,25,0,0,0,0,0,0,0,0,0,0,0,4,17,31,44,56,67,77,86,93,101,106,111,116,119,121,121,121,121,119,116,114,109,102,95,87,78,68,57,45,31,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,44,68,91,115,140,149,149,149,124,101,77,54,30,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,23,38,52,64,75,86,95,103,109,114,118,121,121,121,121,119,116,113,107,99,87,66,44,21,0,0,0,0,0,0,0,0,0,0,0,0,0,11,22,33,44,53,62,70,77,83,88,91,93,96,96,96,96,96,93,88,84,78,71,64,55,45,34,23,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,70,93,117,121,121,121,121,117,95,71,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,17,31,42,54,63,72,79,85,90,93,96,96,96,96,96,93,88,83,76,66,51,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,21,31,39,46,53,58,63,67,70,71,73,73,72,71,68,65,60,54,48,41,32,23,12,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,63,82,95,96,96,96,96,95,82,63,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,21,31,41,49,56,62,65,70,71,73,73,73,71,68,65,59,53,44,32,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,16,23,29,34,39,43,45,48,48,48,48,46,44,40,36,31,24,17,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,28,47,62,70,71,71,71,71,70,62,47,28,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,18,25,32,38,42,45,48,48,48,48,46,44,40,35,29,21,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,10,14,17,21,22,22,22,22,22,20,16,12,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,28,39,45,45,45,45,45,45,39,28,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,8,13,17,20,22,22,22,22,22,19,16,11,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,15,20,20,20,20,20,20,15,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,25,25,25,25,25,25,25,25,21,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,12,18,22,25,25,25,23,19,14,7,0,0,6,7,7,7,7,7,7,4,0,0,0,0,0,0,0,0,4,7,7,7,7,7,7,6,1,0,0,7,14,19,23,25,25,25,22,18,12,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,21,25,25,25,25,25,25,25,23,16,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,21,25,25,25,25,25,25,25,24,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,12,17,21,24,25,25,23,22,18,13,7,0,0,0,0,0,0,0,0,14,24,27,27,27,27,27,27,27,27,22,11,0,0,0,0,0,0,0,0,7,19,26,27,27,27,27,27,27,27,23,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,30,43,50,50,50,50,50,50,50,50,44,33,17,0,0,0,0,0,0,0,0,0,0,0,0,8,19,28,36,43,47,50,50,50,48,44,38,30,21,24,31,33,33,33,33,33,32,28,18,4,0,0,0,0,6,20,28,32,33,33,33,33,33,32,25,13,21,30,38,44,48,50,50,50,47,42,36,28,18,7,0,0,0,0,0,0,0,0,0,0,0,17,33,45,50,50,50,50,50,50,50,48,39,24,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,33,45,50,50,50,50,50,50,50,49,41,27,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,20,29,36,42,46,49,50,50,48,47,43,38,32,24,14,2,0,0,0,0,19,33,45,50,50,50,50,50,50,50,50,43,30,15,0,0,0,0,0,0,9,26,40,49,50,50,50,50,50,50,50,45,33,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,29,49,64,75,76,76,76,76,76,76,75,67,51,33,12,0,0,0,0,0,0,0,0,0,3,17,29,41,51,59,66,71,73,76,73,72,68,61,53,42,45,56,58,58,58,58,58,58,51,40,22,2,0,0,5,24,41,52,58,58,58,58,58,58,56,48,33,44,54,61,68,73,73,75,73,71,66,59,50,40,29,16,2,0,0,0,0,0,0,0,0,12,33,51,66,73,73,73,73,73,73,73,70,59,42,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,33,53,66,73,73,73,73,73,73,73,72,62,45,25,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,18,31,42,53,61,67,71,73,76,76,73,72,68,62,56,48,36,21,3,0,0,13,35,53,69,76,76,76,76,76,76,76,75,66,49,29,8,0,0,0,0,2,23,44,61,73,76,76,76,76,76,76,75,69,53,33,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,41,64,83,98,99,99,99,99,99,99,98,87,66,43,21,0,0,0,0,0,0,0,0,8,23,38,51,63,73,83,90,95,99,99,99,96,91,85,75,64,65,80,83,83,83,83,83,83,74,56,37,15,0,0,17,39,58,75,83,83,83,83,83,83,81,67,54,66,76,85,92,96,99,99,99,95,90,82,73,62,50,36,22,5,0,0,0,0,0,0,0,21,45,66,87,98,99,99,99,99,99,99,93,77,55,31,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,45,69,87,98,99,99,99,99,99,99,97,81,59,36,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,22,38,52,65,75,85,92,96,99,101,101,99,96,93,87,80,71,55,36,16,0,0,22,45,67,89,101,101,101,101,101,101,101,99,85,64,41,18,0,0,0,0,10,33,56,79,95,101,101,101,101,101,101,101,87,67,44,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,118,124,124,124,124,124,124,121,98,73,48,25,0,0,0,0,0,0,0,10,26,42,58,72,84,96,106,114,119,124,124,124,121,116,108,98,87,81,99,106,106,106,106,106,106,92,69,45,23,0,0,25,48,72,94,106,106,106,106,106,106,103,83,75,88,99,108,116,121,124,124,123,119,114,106,96,84,71,56,40,22,6,0,0,0,0,0,0,25,50,73,98,123,124,124,124,124,124,124,109,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,76,98,123,124,124,124,124,124,124,116,91,65,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,24,40,58,73,87,98,109,116,121,124,129,129,124,121,116,111,103,90,70,47,25,0,0,25,50,73,98,123,124,124,124,124,124,124,118,96,73,49,26,2,0,0,0,17,41,64,88,112,124,124,124,124,124,124,121,98,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,152,152,152,152,149,121,99,73,48,25,0,0,0,0,0,0,8,26,44,61,77,92,106,118,130,139,145,149,152,149,147,141,132,119,108,94,111,134,134,134,134,134,121,99,73,48,25,0,2,27,50,76,101,124,134,134,134,134,134,114,91,97,109,121,132,140,147,150,152,149,145,139,130,117,105,91,74,58,40,22,2,0,0,0,0,0,25,50,73,99,124,152,152,152,152,152,137,109,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,152,152,152,152,142,116,91,66,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,21,40,58,76,92,107,121,134,141,147,152,154,153,152,147,143,137,121,99,76,50,27,0,0,23,48,70,93,116,141,152,152,152,152,152,129,104,81,57,34,11,0,0,0,24,48,72,95,119,144,152,152,152,152,141,116,93,70,46,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,170,177,177,175,149,121,99,73,48,25,0,0,0,0,0,5,24,43,61,78,96,112,129,141,153,162,169,173,175,175,170,164,154,143,130,114,116,142,160,160,160,149,121,99,73,48,25,0,2,27,50,76,101,124,152,160,160,160,144,118,104,118,132,144,155,164,170,175,175,173,169,162,152,140,124,109,92,74,56,37,17,0,0,0,0,0,25,50,73,99,124,152,177,177,177,162,137,109,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,177,177,167,142,116,91,66,40,17,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,0,0,0,0,0,0,14,34,55,74,92,110,129,143,156,165,172,176,178,178,176,173,164,141,116,94,71,48,25,0,0,16,39,62,84,107,132,155,177,177,177,160,137,112,89,65,42,19,0,0,8,32,55,78,102,129,151,174,177,177,156,134,109,85,62,39,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,0,0,18,39,58,78,96,114,132,148,161,174,185,192,197,191,190,190,187,177,163,149,134,121,147,171,185,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,185,172,147,121,123,139,153,165,177,187,190,190,194,198,192,184,173,161,146,129,109,91,71,50,30,8,0,0,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,24,47,67,88,109,129,146,163,177,189,197,189,182,180,180,181,158,135,111,88,65,42,19,0,0,7,30,53,75,98,121,146,168,191,191,168,145,119,97,73,50,27,4,0,15,39,62,85,109,134,158,181,195,172,148,124,101,77,54,31,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,0,11,31,52,73,92,112,132,150,166,182,196,195,183,174,167,165,165,167,172,179,169,153,142,155,177,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,199,176,153,134,145,159,174,176,169,165,165,165,169,177,187,201,195,180,164,146,124,105,85,63,41,20,0,0,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,34,57,79,100,121,143,163,181,198,193,178,166,157,154,154,157,152,129,105,82,59,36,12,0,0,0,21,44,66,90,113,137,160,182,199,176,153,129,105,82,58,35,12,0,22,46,69,93,116,142,165,188,187,163,140,116,93,69,46,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,0,22,44,65,86,107,129,148,167,184,201,191,175,161,150,143,139,139,142,148,156,166,173,167,174,190,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,186,168,160,165,176,164,154,145,139,139,141,145,154,166,181,198,198,180,161,140,118,97,75,53,31,8,0,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,42,65,87,109,134,155,177,197,196,177,159,144,134,129,129,132,139,121,98,76,52,30,6,0,0,0,12,34,57,81,104,129,150,173,196,184,161,137,113,90,67,43,20,5,29,53,77,100,123,148,172,196,179,155,132,108,85,61,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,10,33,55,76,98,119,143,163,182,201,191,173,155,141,129,118,114,114,116,123,134,145,158,173,189,208,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,202,190,185,170,155,143,132,121,114,111,114,121,132,146,164,181,202,194,174,153,132,108,85,63,40,16,0,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,48,72,94,116,142,163,187,206,185,163,143,123,109,101,101,106,114,112,92,69,46,23,0,0,0,0,3,25,49,72,95,117,141,164,188,192,169,146,121,98,75,51,28,12,36,60,84,107,132,155,179,195,171,147,123,100,77,53,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,8,10,10,10,9,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,19,42,65,88,109,132,155,176,196,196,175,157,137,119,105,95,89,89,93,100,110,123,139,155,175,198,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,204,184,168,152,136,121,108,98,91,88,91,98,110,129,148,167,189,207,186,163,141,117,94,71,48,24,0,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,4,9,12,12,12,11,8,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,52,76,99,121,147,170,194,199,176,153,132,108,88,77,77,82,90,90,78,59,38,16,0,0,0,0,0,16,39,62,86,108,132,155,179,200,177,154,132,106,83,59,36,20,43,67,91,114,139,163,186,187,163,139,115,92,69,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,15,22,28,33,35,35,35,34,29,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,4,27,51,73,97,119,143,166,188,206,183,162,141,119,101,85,72,65,65,69,77,89,103,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,194,171,150,132,115,99,86,74,66,63,67,76,92,112,135,156,179,201,196,173,149,124,101,78,55,31,7,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,10,0,0,0,10,18,20,20,20,20,20,20,20,20,16,6,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,23,29,34,36,38,38,36,33,27,20,11,0,0,0,0,0,0,0,0,0,0,0,0,8,32,55,78,102,129,152,175,198,194,171,147,121,99,77,55,52,58,65,65,57,42,25,6,0,0,0,0,0,8,30,53,77,99,121,147,170,192,185,162,139,114,91,68,44,27,50,74,98,121,146,170,193,179,155,132,107,84,61,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,17,29,38,46,53,57,60,60,60,58,54,48,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,10,34,58,81,105,129,152,175,198,196,173,151,129,106,86,67,51,40,40,45,55,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,96,80,66,53,42,38,43,58,79,100,123,147,170,193,204,180,156,134,108,84,61,36,12,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,10,0,1,18,33,43,45,45,45,45,45,45,45,45,40,28,12,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,46,54,58,61,63,63,60,57,52,44,34,23,9,0,0,0,0,0,0,0,0,5,16,25,33,55,81,104,129,154,177,201,193,170,144,119,96,72,49,33,34,40,40,34,22,8,0,0,0,0,0,0,0,21,44,67,90,113,137,161,183,193,170,147,121,99,76,53,33,57,81,105,129,153,177,193,171,147,121,99,76,53,29,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,26,39,50,61,70,77,82,85,86,86,83,78,72,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,15,40,64,88,111,137,160,183,207,189,165,142,117,95,73,52,32,17,15,22,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,46,31,20,14,24,46,68,91,115,139,163,187,210,186,162,139,114,88,65,41,16,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,10,0,17,37,54,67,71,71,71,71,71,71,71,70,63,47,28,6,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,61,70,77,83,86,88,86,86,81,76,67,56,43,29,13,0,0,0,0,0,0,7,24,38,49,53,55,81,104,132,154,177,203,193,170,144,119,93,71,58,58,58,56,48,33,16,0,0,0,0,0,0,0,0,12,35,58,81,104,129,152,174,197,178,155,132,107,84,61,41,65,89,112,137,160,184,185,162,139,114,91,68,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,32,47,60,73,84,93,101,106,109,111,109,107,102,95,84,93,119,144,170,193,198,175,149,121,99,73,48,25,0,0,20,44,69,92,116,142,165,189,206,183,159,135,110,86,63,41,18,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,14,38,61,85,109,134,158,183,206,190,167,143,116,93,68,44,20,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,10,13,33,52,72,88,96,96,96,96,96,96,96,96,83,63,40,16,0,0,0,25,50,76,99,124,152,177,200,190,165,142,114,90,72,82,93,101,106,111,111,111,109,106,99,89,78,64,47,31,13,0,0,0,0,0,21,41,58,73,78,80,81,104,132,154,177,203,193,170,144,119,93,83,83,83,83,81,69,50,30,7,0,0,0,0,0,0,0,3,26,49,72,95,118,143,165,188,186,163,140,115,92,69,48,72,96,119,144,167,191,177,154,132,106,83,60,36,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,35,51,67,81,94,106,116,124,132,137,137,137,134,124,116,106,94,116,144,167,193,198,175,149,121,99,73,48,25,0,0,22,47,72,96,119,147,170,194,203,179,154,132,105,81,57,33,9,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,8,32,57,81,106,132,154,180,203,194,170,146,119,95,71,46,22,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,10,29,49,68,87,107,121,121,121,121,121,121,121,117,95,70,45,20,0,0,0,25,50,76,99,124,152,177,200,190,165,139,114,88,92,105,116,124,134,137,139,139,137,132,121,112,98,83,65,47,28,8,0,0,0,7,30,52,74,94,104,106,106,109,132,154,177,203,193,170,144,119,109,109,109,109,109,103,84,61,38,13,0,0,0,0,0,0,0,0,17,41,63,86,109,134,156,179,194,171,148,124,100,77,55,79,102,129,151,174,192,169,146,121,98,75,52,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,34,51,69,85,101,115,129,140,149,155,160,162,161,157,150,140,129,115,116,142,167,190,198,175,149,121,99,73,48,25,0,0,25,50,73,99,121,149,172,197,200,176,152,124,101,77,53,29,4,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,5,30,53,78,103,129,152,177,203,196,172,147,121,96,73,48,22,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,25,45,64,83,103,123,144,147,147,147,147,147,132,112,91,68,43,18,0,0,0,25,50,76,99,124,152,177,200,188,165,139,114,99,113,129,140,150,157,162,165,165,161,155,147,135,117,101,83,63,42,21,0,0,0,10,33,55,81,104,129,132,134,137,138,156,179,203,193,171,148,137,137,137,137,137,137,111,88,63,40,15,0,0,0,0,0,0,0,0,8,32,54,77,100,123,147,170,193,179,156,134,108,85,63,86,109,135,158,181,184,161,138,114,90,67,44,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,31,50,69,87,103,119,137,150,163,172,180,185,187,185,181,173,163,150,137,121,142,165,190,198,175,149,121,99,73,48,25,0,2,25,50,76,99,124,149,175,200,200,175,149,124,99,75,50,27,2,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,3,27,53,76,101,129,152,177,200,198,172,149,121,96,73,48,22,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,41,60,80,99,118,139,159,172,172,172,154,136,114,95,76,56,34,12,0,0,0,25,50,76,99,124,152,177,200,187,162,139,111,119,135,148,162,173,181,186,190,189,185,179,169,155,137,117,98,76,55,33,11,0,0,10,33,55,81,104,129,154,160,161,162,172,190,211,202,182,167,162,162,162,162,162,137,111,88,63,40,15,0,0,0,0,0,0,0,0,0,23,45,68,91,114,138,161,184,188,164,141,116,93,70,94,118,142,165,188,176,153,130,106,82,59,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,24,45,65,85,103,121,141,157,171,184,196,195,186,180,177,177,180,184,171,157,141,146,167,191,198,175,149,121,99,73,48,25,0,2,25,50,76,99,124,152,175,200,200,175,149,124,99,73,50,25,0,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,4,28,53,76,101,129,152,177,201,198,172,149,121,96,73,48,22,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,37,56,76,95,114,136,155,175,194,176,157,138,117,98,79,60,41,22,1,0,0,0,25,50,76,99,124,152,177,200,187,162,137,123,140,155,170,183,182,180,182,186,194,205,203,190,173,154,134,110,88,66,43,20,0,0,10,33,55,81,104,129,154,177,186,188,194,208,224,216,201,191,187,187,187,185,162,137,111,88,63,40,15,0,0,0,0,0,0,0,0,0,13,36,59,82,106,129,152,175,196,172,149,124,101,77,101,124,150,173,192,168,145,121,98,74,51,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,37,58,79,99,119,139,157,175,191,200,186,173,163,156,152,154,155,161,168,175,165,165,180,201,198,175,149,121,99,73,48,25,0,2,25,50,76,99,124,149,175,199,200,175,150,124,101,76,50,27,2,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,5,30,54,78,104,129,154,177,203,195,170,147,121,96,72,48,22,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,53,72,91,110,132,152,171,190,179,161,141,121,101,82,63,44,24,6,0,0,0,0,25,50,76,99,124,152,177,200,188,164,143,143,159,175,169,160,157,154,157,162,171,184,200,208,188,167,145,121,98,75,52,28,4,0,10,33,55,81,104,129,154,170,170,170,178,193,214,205,188,173,170,170,170,170,162,137,111,88,63,40,15,0,0,0,0,0,0,0,0,0,4,27,50,73,96,119,143,166,189,180,156,134,108,85,107,132,155,180,184,160,137,113,90,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,48,71,92,113,135,155,174,193,200,182,166,152,140,132,129,129,132,137,146,156,170,184,198,215,198,175,149,121,99,73,48,25,0,0,25,49,73,98,121,149,172,197,200,177,152,129,102,78,54,30,5,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,9,34,57,81,106,132,155,180,204,193,167,144,118,93,70,45,21,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,68,87,107,129,147,166,186,182,163,144,123,105,85,67,47,28,9,0,0,0,0,0,25,50,76,99,124,152,177,200,197,177,166,164,172,158,146,137,132,132,132,139,149,166,183,203,200,177,155,132,106,83,59,35,11,0,10,33,55,81,104,129,144,144,144,145,160,180,205,195,173,152,144,144,144,144,144,137,111,88,63,40,15,0,0,0,0,0,0,0,0,0,0,18,41,64,87,109,134,157,180,187,163,139,114,91,114,139,162,186,176,152,129,105,81,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,37,59,82,104,124,148,169,189,203,184,165,148,132,116,107,101,101,106,112,121,136,148,164,182,203,198,175,149,121,99,73,48,25,0,0,22,47,71,96,119,147,170,194,203,180,155,132,106,82,58,34,10,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,16,40,63,86,111,136,160,183,207,188,164,140,114,91,67,43,18,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,64,83,103,123,143,162,182,186,166,147,129,107,89,69,50,31,12,0,0,0,0,0,0,25,50,76,99,124,152,177,200,213,197,184,168,152,137,123,113,106,104,106,114,130,148,169,190,209,186,162,139,113,89,65,41,16,0,9,32,55,80,101,116,116,116,116,132,154,177,203,193,170,144,119,116,116,116,116,116,108,87,62,40,14,0,0,0,0,0,0,0,0,0,0,9,32,55,78,101,124,148,171,194,170,147,121,98,119,145,169,192,168,144,119,97,73,50,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,47,69,92,114,138,160,182,203,190,169,149,130,110,95,83,77,78,81,89,99,114,130,148,171,196,198,175,149,121,99,73,48,25,0,0,20,44,68,92,116,142,165,190,208,184,160,137,111,88,65,41,19,2,6,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,3,8,27,48,71,93,116,141,165,189,206,183,159,136,110,86,63,38,14,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,80,99,118,139,159,179,189,170,150,132,110,92,73,53,34,15,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,203,182,166,149,134,116,101,90,81,78,82,93,112,136,158,181,205,191,167,144,117,93,69,45,20,0,4,26,47,69,84,91,91,91,104,132,154,177,203,193,170,144,119,93,91,91,91,91,88,74,54,33,9,0,0,0,0,0,0,0,0,0,0,0,23,46,69,92,115,139,162,185,178,154,130,106,129,152,175,184,160,137,112,89,65,42,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,54,77,101,124,147,170,193,202,179,157,136,114,94,76,62,53,53,58,66,79,94,119,147,170,195,198,175,149,121,99,73,48,25,0,0,16,40,65,88,112,137,160,184,208,190,166,143,119,96,74,53,35,27,29,40,54,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,44,33,27,29,43,61,81,103,124,149,172,196,198,175,152,129,104,80,57,33,9,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,95,114,136,155,174,192,173,154,134,114,94,76,56,37,18,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,194,169,148,130,112,96,81,67,57,54,59,79,102,124,151,175,199,196,172,147,121,96,72,48,22,0,0,14,33,50,61,66,66,81,104,132,154,177,203,193,170,144,119,93,71,66,66,66,64,55,38,21,0,0,0,0,0,0,0,0,0,0,0,0,14,37,60,83,106,130,153,176,185,161,138,114,134,157,181,176,152,129,104,81,57,34,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,37,61,85,108,134,155,180,203,192,169,146,123,100,79,60,42,29,28,34,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,11,35,59,82,106,132,154,177,200,197,174,152,130,107,87,69,57,52,53,62,74,89,105,123,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,78,65,57,53,53,63,78,96,115,138,160,181,204,189,166,144,119,97,73,50,27,3,0,0,25,50,73,99,124,152,177,203,187,162,137,109,91,110,132,152,170,190,176,157,137,117,98,78,60,40,21,2,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,94,77,61,47,33,29,48,72,96,121,147,170,195,198,175,149,121,99,73,48,22,0,0,0,15,29,37,40,55,81,104,132,154,177,203,193,170,144,119,93,71,48,40,40,39,32,19,4,0,0,0,0,0,0,0,0,0,0,0,0,5,28,51,74,97,119,144,167,190,168,145,121,139,163,188,168,144,119,96,73,49,26,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,42,66,90,114,139,162,187,209,186,162,138,114,90,68,46,25,7,4,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,5,29,53,75,99,121,146,169,191,207,184,163,143,121,104,90,80,76,78,84,95,109,123,141,159,179,201,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,168,146,129,112,99,88,81,77,78,84,96,112,132,150,171,192,200,179,157,135,111,88,65,42,19,0,0,0,25,50,73,99,124,152,177,203,187,162,137,109,107,129,147,166,186,179,160,141,119,101,82,62,44,24,5,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,42,26,12,20,44,68,93,117,144,168,193,200,175,149,121,99,73,48,22,0,0,0,0,6,12,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,15,14,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,42,65,88,111,136,158,180,176,153,132,146,170,182,160,136,111,88,65,41,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,71,93,119,144,167,192,204,180,156,132,108,83,60,36,13,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,21,45,68,90,113,137,158,180,201,197,177,157,141,123,112,104,101,101,107,116,130,144,159,177,195,212,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,200,179,162,147,134,121,111,105,101,101,107,117,132,148,166,184,205,187,166,146,121,100,79,56,33,10,0,0,0,25,50,73,99,124,152,177,203,187,162,137,109,121,143,162,182,191,167,144,123,104,85,65,47,28,8,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,33,56,79,101,124,148,172,186,166,157,163,179,174,152,129,103,80,57,33,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,73,96,121,147,172,195,201,177,152,129,103,78,55,31,6,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,13,36,58,81,103,124,147,167,186,206,193,175,159,146,136,129,124,129,132,140,150,164,179,181,192,209,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,213,197,181,167,155,144,137,130,129,129,132,140,152,166,184,200,191,172,154,132,110,90,67,46,24,1,0,0,0,25,50,73,99,124,152,177,203,187,162,137,117,139,159,179,198,191,166,144,121,99,79,57,36,15,0,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,47,70,93,116,139,163,186,188,182,185,189,166,144,118,95,72,49,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,74,99,124,149,174,198,200,175,151,124,101,76,51,27,2,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,3,25,48,69,91,112,134,153,171,188,203,194,179,169,160,154,152,152,156,163,173,170,156,158,174,196,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,198,179,164,165,177,168,160,154,152,152,155,163,174,186,202,190,174,157,138,117,98,77,56,34,13,0,0,0,0,25,50,73,99,124,152,177,203,188,162,137,136,155,174,194,203,199,178,157,136,113,92,71,50,28,7,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,38,61,84,107,132,154,177,200,205,205,181,158,136,110,87,64,41,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,152,175,200,200,175,149,124,99,73,50,25,1,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,0,15,36,57,78,98,116,136,154,169,183,195,201,190,183,178,177,177,180,179,166,152,136,143,165,190,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,189,167,144,143,158,172,184,179,177,177,180,186,196,195,183,170,155,139,119,103,83,64,43,22,1,0,0,0,0,25,50,73,99,124,152,177,203,194,172,156,156,171,190,180,178,186,191,170,149,129,105,84,63,42,21,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,52,75,98,121,145,168,191,213,197,173,150,129,102,79,56,33,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,152,175,200,200,175,149,124,99,75,50,26,2,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,0,3,23,43,63,82,99,117,136,149,162,172,180,185,187,187,185,179,170,158,146,132,116,142,166,190,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,188,165,139,121,138,152,164,174,181,186,187,185,180,172,162,150,136,119,103,85,67,49,29,9,0,0,0,0,0,25,50,73,99,124,152,177,203,208,191,181,180,189,175,158,153,168,188,184,163,141,118,98,76,55,34,13,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,42,66,89,112,136,159,182,204,189,165,142,118,94,71,48,24,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,75,99,124,149,173,198,200,176,152,124,101,76,52,28,4,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,0,0,9,29,47,65,83,99,113,129,139,148,155,160,162,162,160,155,147,137,124,110,116,142,167,190,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,190,165,141,114,116,130,141,150,157,162,162,160,155,149,139,129,114,100,85,67,51,33,14,0,0,0,0,0,0,25,50,73,99,124,152,177,203,226,212,204,196,177,158,139,132,154,174,196,176,155,134,110,90,69,48,26,5,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,33,57,80,103,124,152,177,200,181,157,134,110,86,63,40,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,73,96,121,147,172,195,202,178,154,129,104,80,56,32,7,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,0,0,0,12,30,47,64,79,92,105,115,124,132,136,138,139,137,132,121,113,101,93,116,144,168,193,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,190,167,142,114,95,107,117,129,134,137,139,137,132,124,115,105,93,80,65,50,33,15,0,0,0,0,0,0,0,25,50,73,99,124,152,177,203,228,217,198,179,161,141,121,117,141,162,184,189,167,146,124,103,82,61,40,19,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,38,61,85,108,134,157,181,196,172,149,124,102,78,55,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,70,93,118,144,167,192,205,181,157,134,109,85,61,37,14,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,13,29,45,59,72,83,92,100,106,109,111,111,110,106,99,90,80,93,119,144,170,193,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,190,167,142,116,91,84,94,102,109,111,111,111,106,101,93,83,72,59,46,31,15,0,0,0,0,0,0,0,0,25,50,73,99,124,152,177,203,220,200,182,163,144,123,105,105,129,149,171,192,181,160,139,116,95,74,53,32,11,0,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,20,22,20,15,28,48,71,93,116,140,163,188,187,163,140,116,93,70,47,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,42,67,91,114,139,163,187,210,187,163,139,115,92,69,47,26,15,17,29,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,11,25,38,50,61,69,77,82,86,86,86,86,82,76,68,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,72,79,84,86,86,86,83,77,70,61,50,39,26,12,0,0,0,0,0,0,0,0,0,25,50,73,99,124,152,177,203,203,184,166,146,129,107,89,92,114,137,158,180,195,173,152,132,109,88,67,45,24,3,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,34,44,48,45,40,45,62,83,104,124,149,172,195,178,155,132,107,85,62,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,38,62,85,109,134,157,181,204,193,170,147,124,101,80,60,46,40,41,50,64,80,98,119,147,170,195,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,4,16,28,37,46,53,57,60,63,63,60,57,52,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,48,55,60,62,63,60,58,53,46,38,28,17,5,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,152,177,203,192,169,150,130,110,91,72,80,101,123,146,167,189,186,165,144,121,101,80,59,38,17,0,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,53,67,73,68,64,68,80,98,117,139,160,182,189,166,145,121,98,76,53,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,56,79,102,129,150,173,196,202,180,157,136,114,95,80,69,64,65,73,84,99,114,134,152,173,197,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,5,14,22,28,32,35,38,38,36,33,28,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,30,35,38,38,36,33,29,22,15,5,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,152,177,203,187,162,137,112,94,74,56,67,89,110,134,154,176,198,179,158,137,114,93,72,51,30,9,0,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,1,24,47,69,88,96,91,88,91,99,114,134,152,172,194,178,156,134,110,88,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,49,72,95,117,141,164,186,207,191,170,150,132,114,101,93,88,90,96,106,118,135,152,168,186,206,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,8,12,12,12,12,9,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,11,12,12,12,9,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,39,55,76,98,118,141,163,185,192,171,150,129,107,86,64,43,22,1,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,6,30,55,79,102,121,115,112,115,121,136,150,168,186,186,165,144,121,99,78,55,33,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,41,63,86,108,132,153,174,194,203,184,166,150,136,123,116,114,114,119,129,140,154,170,182,189,204,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,42,64,85,106,129,150,172,194,184,163,143,119,99,78,57,36,14,0,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,12,36,60,85,109,134,142,139,142,147,156,170,186,189,171,152,132,109,88,66,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,53,75,97,117,139,160,179,197,202,184,170,157,147,142,139,141,144,152,162,174,163,157,168,187,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,200,193,167,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,152,177,203,187,162,137,109,86,60,35,29,50,72,93,115,138,160,181,198,177,155,135,112,91,70,49,28,7,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,203,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,17,41,65,90,114,139,163,165,165,170,178,189,188,173,155,136,116,96,75,54,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,41,63,84,104,124,144,162,179,193,204,191,180,172,167,165,165,169,176,174,159,143,134,154,178,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,170,195,198,175,149,121,99,73,48,25,0,2,27,50,76,101,124,152,177,198,193,167,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,152,177,200,187,162,137,109,86,60,35,17,38,59,81,103,124,147,169,190,190,169,148,124,105,83,62,41,20,0,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,177,200,193,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,23,47,71,96,119,144,168,187,190,194,189,180,168,154,137,118,100,81,61,41,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,29,50,70,90,108,129,143,158,171,182,190,196,196,191,190,189,179,167,154,140,123,124,150,174,182,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,170,172,172,172,149,121,99,73,48,25,0,2,27,50,76,101,124,152,172,172,172,167,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,152,175,175,175,162,137,109,86,60,35,10,25,47,69,90,112,135,156,175,175,175,161,140,117,97,76,55,33,10,0,0,25,50,76,99,124,152,175,175,175,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,175,175,175,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,154,175,175,175,170,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,4,28,52,77,101,124,150,172,173,172,170,165,158,147,134,117,101,83,65,47,27,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,36,55,73,91,107,123,138,149,160,167,172,175,175,172,166,157,146,134,119,105,121,147,160,160,160,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,71,93,119,147,149,149,149,149,149,121,99,73,48,25,0,2,27,50,76,101,124,149,149,149,149,149,144,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,149,149,149,149,149,137,109,86,60,35,10,13,34,55,77,99,121,144,149,149,149,149,149,132,110,89,65,43,18,0,0,25,50,76,99,124,149,149,149,149,149,142,116,91,66,40,17,0,17,43,66,91,116,144,149,149,149,149,149,121,99,73,48,22,0,0,0,0,0,10,33,55,81,104,132,149,149,149,149,149,144,119,93,71,48,22,0,0,0,0,0,0,0,0,0,0,0,7,32,55,81,106,132,144,148,149,149,147,142,136,124,112,99,83,67,49,31,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,20,38,56,73,89,103,115,129,137,143,147,149,149,147,142,135,123,112,98,93,116,134,134,134,134,134,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,70,93,117,121,121,121,121,121,121,119,98,73,48,25,0,2,27,50,75,101,121,121,121,121,121,121,121,115,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,98,121,121,121,121,121,121,121,108,86,60,35,10,0,21,43,64,86,107,121,121,121,121,121,121,121,117,93,68,43,20,0,0,25,50,75,98,121,121,121,121,121,121,121,115,91,65,40,17,0,17,43,65,91,115,121,121,121,121,121,121,119,98,73,48,22,0,0,0,0,0,10,32,55,80,103,121,121,121,121,121,121,121,117,93,70,48,22,0,0,0,0,0,0,0,0,0,0,0,6,31,53,77,99,111,118,121,121,121,121,116,110,101,91,79,64,49,31,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,21,38,54,68,82,93,103,111,116,121,121,121,121,116,109,100,90,78,86,104,106,106,106,106,106,106,92,69,45,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,63,82,95,96,96,96,96,96,96,96,85,65,42,20,0,0,23,44,67,87,96,96,96,96,96,96,96,94,82,61,37,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,45,66,87,98,99,99,99,99,99,99,93,77,55,31,6,0,9,30,52,73,92,99,99,99,99,99,99,99,98,85,64,41,16,0,0,21,45,69,87,98,99,99,99,99,99,99,97,81,59,36,14,0,14,38,59,81,97,99,99,99,99,99,99,98,87,66,43,19,0,0,0,0,0,6,28,49,72,88,96,96,96,96,96,96,96,95,82,63,42,18,0,0,0,0,0,0,0,0,0,0,0,0,23,45,64,80,88,94,96,99,98,96,93,87,79,69,57,44,29,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,19,33,48,59,71,80,87,93,96,99,99,96,93,86,78,67,56,69,80,81,81,81,81,81,80,73,56,35,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,28,47,62,70,71,71,71,71,71,71,70,64,49,30,11,0,0,13,32,51,65,71,71,71,71,71,71,71,70,62,46,26,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,33,51,66,73,73,73,73,73,73,73,70,59,42,21,0,0,0,17,38,56,69,73,73,73,73,73,73,73,73,65,49,29,7,0,0,12,33,53,66,73,73,73,73,73,73,73,72,62,45,25,5,0,5,27,45,62,72,73,73,73,73,73])
.concat([73,73,66,51,31,9,0,0,0,0,0,0,17,36,54,66,71,71,71,71,71,71,71,70,62,47,30,8,0,0,0,0,0,0,0,0,0,0,0,0,10,29,46,57,65,70,73,73,73,73,69,64,57,47,37,24,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,27,38,48,57,63,68,72,73,73,72,68,62,55,45,34,47,55,55,55,55,55,55,55,50,38,20,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,28,41,47,48,48,48,48,48,48,48,42,31,15,0,0,0,0,17,33,43,48,48,48,48,48,48,48,47,40,28,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,31,43,48,48,48,48,48,48,48,46,38,24,6,0,0,0,2,20,35,45,48,48,48,48,48,48,48,47,42,30,13,0,0,0,0,17,33,43,48,48,48,48,48,48,48,47,40,27,10,0,0,0,11,27,40,47,48,48,48,48,48,48,48,43,31,15,0,0,0,0,0,0,0,2,18,33,42,45,45,45,45,45,45,45,45,39,28,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,24,34,41,46,48,48,48,48,45,40,33,24,14,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,15,25,33,40,44,48,48,48,48,44,39,32,23,14,26,32,33,33,33,33,33,32,28,18,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,17,22,22,22,22,22,22,22,22,19,9,0,0,0,0,0,0,11,19,22,22,22,22,22,22,22,22,17,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,22,22,22,22,22,22,22,21,15,3,0,0,0,0,0,0,13,20,22,22,22,22,22,22,22,22,17,8,0,0,0,0,0,0,11,19,22,22,22,22,22,22,22,22,16,6,0,0,0,0,0,6,16,22,22,22,22,22,22,22,22,19,9,0,0,0,0,0,0,0,0,0,0,10,17,20,20,20,20,20,20,20,20,15,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,10,17,22,23,25,25,22,20,16,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,9,15,20,22,22,22,22,20,15,8,0,0,2,7,7,7,7,7,7,7,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,5,5,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,5,4,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,10,16,20,24,26,29,30,28,25,23,19,14,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,13,20,24,28,30,28,24,20,13,5,0,0,0,0,0,0,0,0,0,0,0,0,0,8,21,28,30,30,30,30,29,24,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,25,25,25,25,21,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,12,18,22,25,27,30,30,26,24,20,15,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,12,18,22,25,27,30,30,27,25,21,17,11,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,14,20,25,28,30,29,25,22,16,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,20,27,34,40,45,48,50,53,53,52,50,47,43,37,30,23,13,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,17,28,37,45,49,52,53,52,49,44,37,28,17,5,0,0,0,0,0,0,0,0,0,0,9,28,42,51,53,53,53,53,52,45,32,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,21,36,46,50,50,50,50,50,50,50,50,45,35,19,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,14,22,30,36,43,47,50,51,53,53,50,48,44,38,32,23,13,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,12,21,29,36,42,46,50,51,53,53,50,49,46,41,35,28,20,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,20,30,38,45,49,52,53,53,50,46,41,33,23,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,23,33,43,51,58,64,69,73,76,76,78,76,76,72,68,61,54,45,36,25,14,1,0,0,0,0,0,0,0,0,0,0,0,0,11,26,39,50,60,68,73,76,78,76,73,68,60,50,38,25,10,0,0,0,0,0,0,0,0,3,24,45,62,75,78,78,78,78,77,67,51,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,55,70,76,76,76,76,76,76,76,75,69,53,35,15,0,0,0,0,0,0,0,0,0,0,0,0,0,3,15,25,37,45,53,61,66,71,74,76,78,78,76,73,69,62,55,46,36,24,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,23,34,44,53,60,66,71,74,76,78,78,76,73,70,65,59,51,43,32,22,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,16,29,41,53,61,69,73,76,78,78,75,70,64,56,45,33,19,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,21,33,45,55,65,73,81,88,93,96,99,101,104,101,99,96,91,85,77,67,57,47,35,21,8,0,0,0,0,0,0,0,0,0,0,13,30,45,59,72,83,91,98,101,104,101,98,91,82,72,59,45,28,12,0,0,0,0,0,0,0,14,36,57,79,98,104,104,104,104,101,84,64,40,15,0,0,0,0,0,0,0,0,0,0,0,0,4,26,50,71,89,99,99,99,99,99,99,99,98,87,69,45,24,1,0,0,0,0,0,0,0,0,0,0,0,10,24,36,48,58,68,77,84,90,94,98,101,104,102,99,96,93,85,78,67,57,45,33,19,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,19,33,45,56,67,75,83,90,94,98,101,103,103,100,98,93,88,82,74,65,54,44,31,17,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,20,36,50,63,74,84,92,98,101,104,101,99,94,87,78,66,53,37,21,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,27,42,55,67,78,88,97,105,111,116,121,124,124,129,124,124,119,115,108,100,90,80,69,55,42,28,12,0,0,0,0,0,0,0,0,11,30,47,64,80,93,105,115,121,124,129,124,121,114,105,93,79,64,46,29,10,0,0,0,0,0,3,25,47,69,90,112,129,129,129,129,116,91,68,43,17,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,101,124,124,124,124,124,124,124,123,98,76,53,27,5,0,0,0,0,0,0,0,0,0,0,15,30,45,57,70,81,91,100,108,114,119,121,124,129,129,124,121,116,109,100,90,79,67,53,40,25,9,0,0,0,0,0,0,0,0,0,0,0,0,9,25,41,54,67,79,89,99,107,114,119,121,124,129,129,124,121,118,113,106,98,88,76,65,52,38,22,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,21,38,55,70,84,97,107,116,121,124,129,129,123,118,110,99,87,72,55,38,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,31,47,62,75,88,100,110,121,130,137,142,147,150,152,154,152,150,146,139,134,123,113,101,90,76,62,47,31,13,0,0,0,0,0,0,7,26,46,65,82,99,114,129,139,147,152,154,152,147,139,129,114,98,82,64,45,25,5,0,0,0,0,14,37,58,80,101,123,146,154,152,130,107,86,63,40,15,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,152,152,152,152,152,149,121,99,76,50,27,5,0,0,0,0,0,0,0,0,1,17,35,50,65,79,91,103,114,123,132,139,144,149,152,152,152,151,147,141,134,123,112,100,88,74,60,44,28,11,0,0,0,0,0,0,0,0,0,0,10,28,44,60,74,88,100,112,121,132,139,144,149,152,152,152,152,147,144,138,130,121,109,99,86,72,57,42,24,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,37,55,73,89,105,117,132,140,147,152,154,152,149,143,135,121,107,91,73,54,34,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,33,49,67,81,96,109,121,134,144,152,160,166,170,175,177,178,176,173,170,163,155,146,136,123,110,96,81,65,47,31,12,0,0,0,0,0,20,41,61,81,99,117,136,149,161,170,175,172,175,170,161,148,134,116,98,79,59,40,18,0,0,0,4,25,48,70,91,113,136,157,162,140,117,96,74,52,30,8,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,152,175,177,177,171,147,121,99,75,50,27,4,0,0,0,0,0,0,0,1,19,35,53,69,83,99,112,124,137,147,155,162,168,172,175,177,177,175,170,164,156,146,135,121,108,94,79,62,46,28,8,0,0,0,0,0,0,0,0,10,28,46,62,79,94,108,121,135,146,154,162,168,172,175,177,177,175,172,167,161,153,144,132,119,106,92,76,60,42,24,6,0,0,0,0,0,0,0,0,0,0,0,0,0,10,31,52,71,90,107,124,140,153,163,170,175,178,176,173,166,156,143,124,107,89,69,48,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,33,51,67,85,101,116,132,144,156,166,176,184,190,195,198,198,195,197,198,193,187,179,169,157,145,132,116,99,83,65,47,24,2,0,0,0,9,31,53,74,95,115,136,154,170,172,160,150,147,150,160,172,168,152,134,114,94,73,52,30,8,0,0,15,37,59,81,103,124,148,169,150,129,106,84,63,41,19,0,0,0,0,0,0,0,0,0,0,0,0,0,6,30,53,76,101,124,149,173,198,193,170,147,121,96,73,50,26,2,0,0,0,0,0,0,0,17,35,53,71,87,103,118,134,147,158,170,178,186,192,197,198,195,196,198,195,188,179,168,156,143,130,112,98,80,62,42,21,0,0,0,0,0,0,0,6,26,45,62,80,98,114,130,144,157,167,177,186,192,197,198,195,196,198,196,191,184,176,166,155,141,129,110,94,77,60,42,22,3,0,0,0,0,0,0,0,0,0,0,0,0,22,44,65,86,106,124,144,160,174,184,173,165,165,165,170,181,177,162,144,123,103,81,59,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,30,49,67,85,103,119,137,152,165,178,189,199,193,185,178,175,172,172,172,173,177,184,192,191,179,166,152,136,117,101,80,56,31,8,0,0,0,19,42,64,87,108,130,150,170,171,154,137,124,121,124,138,154,172,168,149,129,107,86,63,40,18,0,5,27,48,71,92,114,137,159,162,139,116,95,73,51,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,5,29,53,76,99,124,149,172,196,193,170,147,119,96,73,48,25,2,0,0,0,0,0,0,12,32,51,69,87,105,121,139,154,167,181,192,200,190,182,176,172,172,172,173,177,184,193,190,177,163,148,134,116,98,75,51,28,3,0,0,0,0,0,0,21,41,60,80,98,116,134,150,165,178,190,201,191,183,176,172,172,172,173,177,184,193,199,188,175,162,146,132,112,94,76,57,38,18,0,0,0,0,0,0,0,0,0,0,0,10,33,55,78,99,121,141,161,179,180,164,150,142,139,139,147,161,179,179,159,138,114,92,69,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,24,45,64,83,101,119,139,155,170,186,198,193,181,171,162,155,150,147,147,147,149,154,160,170,181,194,182,164,146,129,106,81,58,32,7,0,0,4,28,51,73,97,119,143,164,177,156,137,117,103,97,104,117,138,158,179,163,141,117,96,73,49,26,3,16,38,59,82,104,124,148,170,150,129,105,83,62,40,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,51,76,99,121,149,172,195,193,168,144,119,96,72,48,25,2,0,0,0,0,0,5,26,46,67,85,104,123,141,158,173,188,201,190,178,168,159,152,149,147,147,149,154,161,171,182,196,180,161,143,123,101,78,53,27,4,0,0,0,0,0,13,34,55,76,95,114,134,152,168,184,198,194,180,169,160,152,149,147,147,149,154,161,171,182,196,196,181,166,148,132,110,92,72,52,31,10,0,0,0,0,0,0,0,0,0,0,18,41,65,88,110,135,155,176,185,164,146,130,117,113,114,124,143,164,187,171,148,124,100,77,53,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,58,79,99,117,137,156,173,189,202,187,173,160,148,139,132,124,121,119,121,124,130,138,148,160,173,166,148,130,110,92,74,51,28,6,0,0,11,35,58,81,105,130,152,175,167,145,121,101,83,73,83,103,123,146,169,174,152,129,104,81,57,33,10,28,49,71,93,115,138,160,161,139,115,93,72,50,28,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,50,76,99,121,149,172,195,190,167,144,119,93,71,48,23,0,0,0,0,0,0,18,40,60,80,100,119,139,159,175,193,200,184,170,156,145,136,129,121,121,121,124,130,139,149,161,175,163,145,124,107,89,69,48,25,1,0,0,0,0,4,25,47,69,89,110,130,150,170,186,203,189,173,159,147,137,129,123,121,121,124,132,138,149,162,177,193,200,184,166,147,129,107,86,65,45,22,0,0,0,0,0,0,0,0,0,0,24,48,72,96,119,144,166,189,173,150,130,110,95,88,91,107,132,154,177,180,155,132,106,81,57,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,29,50,72,92,113,134,154,172,191,202,184,168,152,139,124,115,106,101,96,96,96,99,105,114,124,139,153,150,132,112,94,76,57,39,18,0,0,0,16,40,64,88,112,137,160,183,159,137,111,88,67,49,69,90,112,137,160,183,160,137,111,88,63,40,17,39,61,82,105,129,149,171,148,129,104,82,61,39,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,50,73,98,121,147,170,194,190,167,144,116,93,71,45,22,0,0,0,0,0,8,30,51,73,94,114,136,155,174,193,200,182,165,149,136,121,112,104,99,96,96,99,106,115,129,141,155,146,129,109,91,73,55,36,15,0,0,0,0,0,14,37,58,81,103,123,145,165,184,204,189,171,155,139,124,113,104,99,96,96,99,106,114,129,143,159,175,194,200,181,162,143,119,99,79,56,33,12,0,0,0,0,0,0,0,0,4,29,53,78,101,129,152,175,189,165,141,117,95,74,63,75,98,121,148,173,184,160,135,109,83,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,40,62,83,105,129,148,167,188,205,186,168,150,134,117,104,92,83,77,73,71,72,75,81,91,104,117,134,134,114,96,78,60,41,23,4,0,0,0,20,45,69,93,116,143,166,178,154,130,105,81,57,35,58,82,106,132,155,179,165,142,116,93,68,44,29,50,72,94,116,139,161,160,137,115,92,71,49,28,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,49,73,96,119,147,170,193,188,165,142,116,93,68,45,22,0,0,0,0,0,20,41,63,85,106,129,149,170,190,203,184,165,148,130,114,100,89,80,75,71,71,75,82,93,106,119,137,130,110,92,74,56,38,20,2,0,0,0,0,2,24,47,70,92,114,137,158,179,200,194,174,155,137,118,103,90,81,75,71,71,75,82,92,107,121,141,159,179,199,197,177,155,135,112,89,66,45,22,0,0,0,0,0,0,0,0,7,32,55,81,106,132,156,180,185,160,135,110,86,62,46,71,96,119,147,172,186,162,137,109,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,28,50,73,95,116,139,161,181,202,191,171,152,134,114,98,83,71,60,53,48,46,48,51,59,70,83,98,114,116,98,80,62,44,24,7,0,0,0,0,23,48,73,96,121,147,170,175,150,124,101,76,52,28,53,77,101,124,152,175,170,146,121,96,71,48,40,62,83,105,129,150,170,148,124,104,81,59,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,48,72,96,119,144,167,193,187,165,142,114,91,68,44,20,0,0,0,0,6,29,51,74,97,117,141,163,183,204,189,169,149,130,110,94,80,67,57,50,48,48,52,60,72,86,101,117,112,94,76,58,40,22,4,0,0,0,0,0,11,33,57,80,103,124,148,171,192,202,181,160,139,119,101,84,70,58,50,47,48,52,60,72,87,105,123,144,165,185,207,189,167,146,121,100,77,54,31,8,0,0,0,0,0,0,0,7,33,58,81,106,134,160,182,182,157,134,106,83,58,53,75,98,121,149,173,183,160,134,109,83,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,37,59,82,105,129,150,172,194,199,179,158,137,116,98,80,64,49,37,29,24,22,23,27,37,49,64,79,93,94,82,63,45,27,8,0,0,0,0,1,25,50,75,99,124,149,173,172,149,121,98,73,49,25,50,73,99,121,149,173,173,149,121,99,73,50,51,73,95,117,140,162,158,137,113,92,70,48,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,47,71,93,116,144,167,190,187,162,139,114,91,67,43,20,0,0,0,0,16,39,61,83,106,130,153,174,196,198,177,155,135,114,94,76,60,46,34,26,22,22,28,38,51,66,82,95,93,78,60,42,23,5,0,0,0,0,0,0,19,42,65,89,112,136,159,181,204,191,169,147,124,104,85,65,49,36,27,22,22,28,38,52,69,89,109,130,152,173,196,202,179,156,134,109,86,63,40,16,0,0,0,0,0,0,0,7,33,58,81,106,134,157,182,183,160,134,109,83,58,67,86,107,132,155,178,178,154,130,105,80,56,32,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,69,92,114,138,161,183,205,189,167,145,123,101,82,62,45,29,15,5,0,0,0,4,15,29,45,60,69,70,62,46,29,10,0,0,0,0,0,2,25,50,76,99,124,152,175,172,147,121,96,71,48,22,48,73,96,121,149,172,175,149,124,99,73,50,63,85,107,130,152,169,147,124,101,81,58,37,21,22,22,22,21,16,9,1,0,0,0,0,0,0,0,0,0,0,0,22,45,71,93,116,142,167,190,185,162,139,112,88,66,42,17,0,0,0,0,23,46,69,93,116,139,162,185,207,188,165,144,121,99,80,60,42,26,12,3,0,0,5,17,31,47,63,70,69,59,42,25,7,0,0,0,0,0,0,2,25,49,73,97,121,145,168,191,204,181,158,136,112,90,70,50,31,15,3,0,0,5,18,35,54,74,95,117,140,163,186,208,188,165,142,117,94,70,46,23,0,0,0,0,0,0,0,6,31,55,80,104,132,155,180,185,160,137,111,88,69,85,101,121,143,164,186,167,146,121,98,75,51,27,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,53,76,99,121,147,170,192,203,180,157,135,111,90,69,48,28,10,0,0,0,0,0,0,0,10,26,39,47,47,41,28,12,0,0,0,0,0,0,2,25,50,76,99,124,152,175,172,147,121,96,71,46,22,48,71,96,121,147,172,175,152,124,99,76,53,74,96,118,141,163,157,136,113,90,69,47,40,45,48,48,48,45,40,33,23,13,0,0,0,0,0,0,0,0,0,0,22,45,68,91,116,142,165,188,185,162,137,111,88,65,40,17,0,0,0,6,30,53,77,100,124,147,172,194,201,178,155,134,109,87,66,45,26,7,0,0,0,0,0,0,13,28,41,47,46,39,25,8,0,0,0,0,0,0,0,8,32,56,80,103,129,152,176,200,196,172,149,124,101,79,57,36,15,0,0,0,0,0,0,19,41,62,83,106,132,154,176,200,197,173,150,124,101,77,53,30,5,0,0,0,0,0,0,4,28,52,77,101,124,151,174,190,166,142,117,94,88,103,119,139,157,176,177,156,135,110,89,67,44,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,35,59,83,106,132,154,178,201,195,171,148,124,101,79,57,34,14,0,0,3,5,5,5,5,5,5,6,16,22,22,17,7,5,4,1,0,0,0,0,2,25,50,76,99,124,152,175,172,147,121,96,72,48,24,48,73,96,121,149,172,175,149,124,99,73,64,86,107,132,153,167,146,123,101,79,57,57,64,70,73,73,73,69,64,56,46,34,21,6,0,0,0,0,0,0,0,0,20,43,68,91,114,141,165,187,182,160,137,111,86,63,40,16,0,0,0,11,36,60,83,107,132,155,179,202,193,169,147,121,99,76,55,32,11,0,0,0,0,0,0,0,0,8,17,22,22,16,5,0,0,0,0,0,0,0,0,13,37,62,86,109,136,159,183,207,189,165,142,116,93,70,47,24,2,0,0,0,0,0,0,6,29,51,74,98,121,146,169,193,204,180,156,134,107,83,59,35,10,0,0,0,0,0,0,0,23,48,72,96,119,144,168,191,173,150,124,102,108,123,139,156,173,180,162,143,121,99,78,56,34,11,14,15,15,15,15,15,15,14,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,65,88,111,137,160,184,208,188,164,141,116,93,70,47,24,2,8,21,28,30,30,30,30,30,30,30,30,30,30,30,30,30,30,25,16,2,0,0,0,25,50,73,98,121,149,172,173,149,123,99,73,50,26,50,75,99,124,149,175,172,147,121,98,73,75,97,119,143,164,156,135,112,90,67,69,80,88,93,96,99,96,93,87,79,67,55,41,24,8,0,0,0,0,0,0,0,20,43,66,91,114,139,162,186,182,160,137,109,86,63,38,15,0,0,0,16,41,65,88,112,138,161,185,209,187,163,139,114,91,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,42,66,90,114,140,165,188,207,183,160,136,109,86,62,39,15,0,0,0,0,0,0,0,0,20,43,66,90,114,139,163,188,210,185,162,138,111,88,63,39,15,0,0,0,0,0,0,0,17,41,65,89,112,137,160,183,181,158,136,114,129,144,159,175,180,164,146,129,107,87,66,45,23,32,39,40,40,40,40,40,40,39,32,19,3,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,69,93,116,142,165,190,206,183,159,135,109,86,63,39,16,9,28,42,53,55,55,55,55,55,55,55,55,55,55,55,55,55,55,49,36,20,1,0,0,22,47,71,96,119,145,170,175,152,129,101,78,53,30,55,78,102,129,152,176,168,144,119,95,70,87,108,132,154,167,145,121,100,79,77,90,102,111,117,121,121,121,116,110,100,89,75,60,42,25,6,0,0,0,0,0,0,17,41,66,88,111,139,162,185,181,157,134,109,86,60,38,15,0,0,0,20,45,70,93,116,143,166,190,206,182,157,134,109,85,61,37,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,45,70,93,119,144,169,193,203,178,154,132,105,80,56,32,8,0,0,0,0,0,0,0,0,12,37,61,85,109,134,160,183,208,190,166,142,116,91,67,43,18,0,0,0,0,0,0,0,11,34,57,80,104,129,151,173,190,167,146,136,149,163,178,177,161,146,129,109,92,72,52,32,37,52,62,63,63,63,63,63,63,62,52,37,19,0,0,0,0,0,0,0,0,0,0,0,0,0,23,48,72,96,119,147,170,195,203,178,154,132,105,81,57,33,9,23,45,62,75,78,78,78,78,78,78,78,78,78,78,78,78,78,78,69,55,34,14,0,0,19,43,68,91,115,141,164,180,155,132,106,83,59,38,61,85,107,134,157,180,163,139,114,91,76,98,119,143,165,155,134,110,89,80,96,110,124,136,143,147,149,147,142,135,121,109,94,78,60,42,22,2,0,0,0,0,0,17,40,64,88,111,137,160,185,180,157,134,106,83,60,36,12,0,0,0,23,48,72,96,119,147,170,195,202,178,154,129,104,80,56,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,48,73,96,121,147,172,196,200,175,152,124,101,76,52,27,3,0,0,0,0,0,0,0,0,7,32,56,81,106,132,155,180,205,194,170,144,119,93,70,45,20,0,0,0,0,0,0,0,3,25,49,72,95,117,140,163,186,179,164,160,170,184,172,158,143,124,109,92,74,56,38,31,53,73,86,88,88,88,88,88,88,86,73,52,32,8,0,0,0,0,0,0,0,0,0,0,0,2,25,50,75,99,123,149,173,198,200,175,152,124,101,77,53,29,7,32,57,78,98,104,104,104,104,104,104,104,104,104,104,104,104,104,103,88,68,45,22,0,0,14,38,62,86,109,135,157,181,161,139,114,91,71,55,72,93,115,139,163,180,157,134,109,85,88,109,132,155,165,144,121,99,79,98,115,132,147,158,167,172,173,171,166,157,145,130,112,94,76,56,36,15,0,0,0,0,0,15,40,63,86,109,137,160,182,180,155,132,106,83,59,35,12,0,0,2,25,50,75,99,123,149,173,198,200,175,152,124,101,76,52,28,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,75,99,124,151,175,199,198,173,149,121,98,73,48,25,0,0,0,0,0,0,0,0,0,4,28,53,78,101,129,152,177,203,196,172,147,121,96,71,48,22,0,0,0,0,0,0,4,21,37,53,69,84,107,130,153,176,198,188,185,182,167,153,138,121,107,91,74,56,38,22,40,63,87,109,114,114,114,114,114,114,109,86,62,37,14,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,152,175,200,198,175,149,124,99,74,50,26,10,35,60,83,109,132,132,132,132,132,132,132,132,132,132,132,132,132,121,96,73,48,25,0,0,8,32,56,79,102,124,149,172,170,148,124,105,88,80,89,107,129,149,172,171,148,124,101,78,99,121,144,166,154,132,109,88,94,114,134,152,167,174,163,154,152,155,164,177,165,148,130,110,91,70,49,28,5,0,0,0,0,15,38,63,86,109,134,160,182,177,154,132,105,81,58,35,10,0,0,2,27,50,76,99,124,152,175,200,198,175,149,121,99,73,50,25,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,50,76,99,124,152,177,200,198,172,147,121,96,71,47,22,0,0,0,0,0,0,0,0,0,2,27,50,76,101,124,152,177,200,198,175,149,121,96,73,48,22,0,0,0,0,0,3,21,38,55,72,88,103,117,134,152,176,201,210,188,165,148,134,117,103,88,72,56,40,22,24,47,71,94,118,139,139,139,139,139,137,111,88,63,40,14,0,0,0,0,0,0,0,0,0,0,0,4,29,53,77,101,124,152,176,200,198,173,149,121,99,73,50,25,10,35,60,83,109,137,154,154,154,154,154,154,154,154,154,154,154,149,121,96,73,48,25,0,0,1,24,48,71,93,116,139,160,181,161,141,123,109,104,109,123,143,162,179,159,137,114,92,89,110,134,155,165,143,119,98,86,107,129,149,168,173,155,140,130,124,132,143,158,175,165,146,124,104,82,60,38,16,0,0,0,0,14,38,60,83,109,134,157,180,177,154,129,104,81,58,33,10,0,0,4,27,53,77,101,124,152,177,200,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,52,76,101,129,152,177,203,198,172,147,119,96,71,45,22,0,0,0,0,0,0,0,0,0,0,25,50,75,99,124,152,175,200,198,175,149,121,99,73,48,22,0,0,0,0,0,19,37,56,73,91,107,121,139,153,168,185,205,210,185,160,135,114,98,83,68,53,38,22,8,31,54,78,102,124,150,165,165,165,152,129,104,80,57,33,9,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,101,129,152,177,200,198,173,149,121,99,73,50,25,10,35,60,83,109,137,160,180,180,180,180,180,180,180,180,180,172,149,121,96,73,48,25,0,0,0,16,39,61,82,104,124,146,166,175,159,144,134,132,134,144,159,177,164,145,123,103,81,100,121,145,166,153,132,108,87,96,118,141,163,179,158,138,119,106,101,107,121,141,161,180,160,138,115,93,70,48,24,0,0,0,0,12,35,60,83,106,134,157,180,175,152,129,104,78,55,33,9,0,0,4,27,53,78,101,129,152,177,200,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,52,76,101,124,152,177,202,198,172,147,121,96,71,45,22,0,0,0,0,0,0,0,0,0,1,25,50,76,99,124,152,175,200,198,175,149,121,99,73,48,22,0,0,0,0,13,34,54,73,91,109,124,143,158,173,188,184,180,187,191,169,150,130,109,90,71,53,35,17,18,41,64,86,109,134,157,181,190,167,144,119,96,73,49,26,2,0,0,0,0,0,0,0,0,0,0,0,2,27,51,76,101,124,152,175,200,198,175,149,124,99,75,50,26,10,35,60,83,109,137,160,185,185,185,185,185,185,192,205,198,172,149,121,96,73,48,25,0,0,0,6,28,49,71,91,110,130,148,163,177,165,157,154,157,166,177,163,146,130,109,89,90,112,135,156,164,141,118,97,81,105,129,152,174,168,145,121,103,85,77,87,105,124,148,171,171,148,124,101,78,55,32,8,0,0,0,12,35,58,83,106,132,154,178,175,152,129,101,78,55,30,7,0,0,2,27,50,76,101,124,152,175,200,198,175,149,121,99,73,50,25,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,25,50,76,99,124,152,177,200,198,172,147,121,96,72,48,23,0,0,0,0,0,0,0,0,0,2,27,52,76,101,129,152,177,201,198,174,149,121,96,73,48,22,0,0,0,6,27,48,69,89,107,124,144,161,177,193,177,161,157,166,185,184,164,145,124,106,87,69,51,33,28,50,73,96,118,143,165,188,181,158,136,111,88,65,41,18,0,0,0,0,0,0,0,0,0,0,0,0,2,26,50,76,99,124,149,173,198,200,176,152,124,101,77,53,29,10,35,60,83,109,137,160,162,162,162,162,162,162,173,191,198,172,149,121,96,73,48,25,0,0,0,0,16,36,57,76,94,112,130,144,155,163,168,170,168,163,155,143,129,110,93,80,101,123,146,167,153,130,107,86,88,112,137,160,183,160,137,112,89,69,53,72,92,115,139,163,180,157,134,109,85,62,38,13,0,0,0,10,34,58,81,104,132,154,177,173,149,124,101,78,53,30,7,0,0,2,25,50,76,99,124,149,173,198,200,175,152,124,101,76,52,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,74,99,123,149,174,198,199,175,149,124,99,75,50,26,1,0,0,0,0,0,0,0,0,5,30,54,78,104,129,154,178,203,195,171,147,119,96,71,47,22,0,0,0,16,39,61,82,103,123,143,162,179,195,177,161,143,132,150,170,190,179,161,143,123,104,85,69,51,39,61,82,106,130,152,175,195,172,149,124,102,79,56,33,10,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,73,96,121,147,170,195,203,178,154,132,105,81,57,32,10,35,60,83,109,137,137,137,137,137,137,137,138,159,181,198,172,149,121,96,73,48,25,0,0,0,0,2,22,42,60,77,94,108,121,132,139,144,147,144,139,132,119,107,92,76,91,113,136,157,163,141,117,96,74,93,117,143,167,178,154,130,104,81,57,38,61,84,108,134,157,180,163,139,114,91,67,42,18,0,0,0,10,33,57,81,104,129,152,177,172,149,124,99,76,53,28,5,0,0,0,24,48,73,96,121,147,170,195,202,178,154,129,104,80,56,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,48,71,96,121,147,172,195,201,177,152,129,103,78,54,30,5,0,0,0,0,0,0,0,0,9,34,58,82,106,134,157,181,206,193,168,144,117,93,68,45,20,0,0,3,27,49,71,94,116,138,158,178,197,179,161,143,123,114,136,155,175,195,177,159,141,121,103,87,69,53,72,93,115,139,162,184,184,162,139,115,93,70,47,24,1,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,70,93,118,144,167,191,206,183,158,134,109,86,62,38,15,33,58,80,101,109,109,109,109,109,109,109,132,157,180,198,172,149,121,96,73,48,25,0,0,0,0,0,7,24,42,58,74,88,99,108,114,118,119,118,114,108,98,87,73,80,103,124,147,169,152,130,106,84,73,98,121,147,172,175,150,124,99,76,52,30,55,78,103,129,152,177,168,144,119,93,70,45,21,0,0,0,7,32,55,78,102,129,152,175,172,147,121,99,76,52,27,5,0,0,0,21,45,70,93,118,144,167,191,206,182,157,134,109,85,61,37,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,69,93,116,144,167,191,206,180,157,134,107,83,59,35,11,0,0,0,0,0,0,0,0,16,39,63,87,111,137,160,185,209,188,165,140,114,91,65,42,17,0,0,12,36,59,81,104,129,150,172,193,185,165,144,124,105,99,119,140,159,179,193,175,157,139,121,105,88,72,84,105,129,150,172,194,173,150,129,105,82,60,37,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,41,65,90,114,139,162,186,210,188,163,140,115,92,69,45,23,25,48,65,81,86,86,86,86,86,86,104,132,157,180,198,172,149,121,96,73,48,25,0,0,0,0,0,0,8,24,40,54,66,76,85,91,93,93,93,91,85,76,65,70,91,114,137,158,162,140,117,95,73,75,99,124,149,175,172,147,121,96,73,48,27,51,76,100,124,149,175,172,147,121,96,73,48,22,0,0,0,7,30,55,78,101,124,152,152,152,147,121,97,73,50,27,2,0,0,0,17,41,65,89,114,139,162,186,210,187,163,139,114,91,67,45,21,0,0,0,0,0,0,0,0,0,0,4,12,15,15,7,0,0,0,0,0,0,0,0,16,40,65,88,113,139,162,187,210,186,162,139,113,90,65,42,19,0,0,0,0,0,0,0,0,23,46,69,93,116,142,166,190,208,184,160,137,110,86,62,37,13,0,0,18,42,66,90,114,138,161,183,197,174,152,130,109,89,85,105,123,144,162,181,191,175,157,141,123,106,91,97,117,140,162,184,183,162,139,116,95,72,49,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,37,61,85,109,134,156,180,203,194,170,147,123,99,78,55,33,14,33,48,58,60,60,60,60,60,81,104,132,157,180,198,172,149,121,96,73,48,25,0,0,0,0,0,0,0,6,19,32,44,53,61,66,68,71,68,66,61,53,59,81,103,124,148,170,150,129,106,83,62,76,101,124,152,177,170,147,119,96,71,46,25,49,73,99,121,149,175,174,149,121,99,73,48,25,0,0,0,6,30,53,76,101,123,124,124,124,124,119,96,73,50,25,2,0,0,0,12,36,61,85,109,134,156,180,204,193,169,146,121,98,75,53,31,9,0,0,0,0,0,0,0,0,13,26,36,40,38,29,16,0,0,0,0,0,0,0,11,36,60,84,108,134,156,180,204,192,168,145,119,97,74,51,29,6,0,0,0,0,0,0,10,32,55,78,101,124,149,172,196,201,177,154,132,106,81,57,33,8,0,0,22,47,71,96,119,145,169,192,189,165,142,118,95,74,71,89,107,129,146,164,182,193,175,159,143,124,109,110,132,153,174,192,171,150,129,105,83,62,39,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,55,78,101,124,149,172,196,201,178,155,134,109,88,66,45,26,14,25,33,35,35,35,35,55,81,104,132,157,180,198,172,149,121,96,73,48,25,0,0,0,0,0,0,0,0,0,11,21,30,37,42,45,45,45,42,36,49,71,92,114,138,160,161,139,116,95,72,53,76,101,129,152,177,170,147,119,93,71,45,25,48,73,99,121,149,175,175,149,121,99,73,48,25,0,0,0,1,26,48,69,89,98,99,99,99,99,98,85,66,44,21,0,0,0,0,7,31,55,78,101,124,149,173,196,200,177,154,132,108,86,64,43,23,4,0,0,0,0,0,0,13,30,47,60,65,62,50,35,17,0,0,0,0,0,0,6,30,54,77,101,124,150,173,196,200,176,153,130,106,83,62,41,20,1,0,0,0,0,4,23,44,65,88,109,134,157,180,204,194,171,147,121,98,75,51,27,3,0,0,25,50,74,99,124,149,175,198,185,160,137,111,87,63,54,73,91,110,130,148,164,182,194,177,161,146,130,124,146,166,187,179,158,137,115,93,72,50,28,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,48,71,94,117,141,163,186,208,188,165,144,121,99,80,60,43,28,15,8,10,10,10,30,55,81,104,132,157,180,198,172,149,121,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,7,14,18,20,20,20,18,39,61,82,104,124,149,171,149,129,105,83,61,52,76,101,129,152,177,170,147,119,96,71,46,25,49,73,99,121,149,175,173,149,121,99,73,48,25,0,0,0,0,16,36,55,69,75,76,76,76,76,75,66,51,33,12,0,0,0,0,0,24,48,71,94,117,141,164,187,209,186,163,141,118,98,77,58,40,24,11,3,0,1,7,18,32,47,65,81,91,86,69,51,33,15,0,0,0,0,0,0,24,47,71,94,117,142,164,188,208,185,163,140,116,95,74,54,35,19,7,1,1,8,22,38,58,78,99,121,144,166,189,208,185,162,139,115,92,68,45,20,0,0,0,25,50,76,100,124,152,177,200,185,160,134,109,83,58,38,56,75,94,110,130,148,164,181,196,180,164,148,143,159,180,186,166,145,123,103,81,59,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,41,63,85,108,132,154,176,197,198,177,155,136,114,94,78,62,48,38,32,27,25,25,30,55,81,104,132,157,180,198,172,149,121,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,29,50,72,93,115,138,161,160,138,115,93,72,49,50,75,99,124,149,175,172,147,121,96,73,48,27,51,76,100,124,150,175,172,147,121,96,73,48,22,0,0,0,13,31,47,64,78,89,96,99,99,95,88,76,62,46,28,9,0,0,0,0,16,41,63,85,108,132,154,177,198,196,174,154,132,110,92,74,58,45,34,27,25,26,31,40,52,67,82,99,114,103,85,67,49,31,13,0,0,0,0,0,16,39,62,85,109,134,155,178,200,196,173,152,130,109,89,71,54,40,30,25,26,31,42,56,73,92,112,134,155,178,199,197,175,153,130,106,83,60,36,13,0,0,0,25,50,76,99,124,152,176,200,185,161,137,111,87,63,40,40,58,76,94,110,130,146,162,179,195,184,170,167,177,193,172,152,132,110,89,68,48,26,18,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,53,76,98,119,143,164,185,206,189,170,150,132,112,96,83,71,62,56,52,50,50,54,60,81,104,132,157,180,198,172,149,121,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,40,62,83,105,129,150,170,148,124,104,82,61,38,48,73,97,121,147,171,175,150,124,100,76,52,31,55,78,103,129,152,177,168,144,119,93,70,45,21,0,0,5,26,46,65,82,98,110,119,124,124,119,109,96,80,62,43,23,2,0,0,0,8,31,53,76,98,119,144,165,186,206,187,167,146,129,109,92,78,66,57,52,50,50,55,62,73,86,101,117,136,121,101,84,66,47,30,12,0,0,0,0,8,31,53,76,99,121,145,167,188,206,186,165,144,123,105,89])
.concat([74,62,54,50,50,55,64,76,91,109,129,148,168,189,206,186,164,141,118,97,74,51,28,5,0,0,0,25,50,73,98,121,149,173,197,189,166,142,117,95,73,55,41,40,58,76,92,110,129,144,161,177,196,192,193,197,183,160,137,116,96,80,69,57,49,42,35,24,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,44,65,87,108,132,152,172,192,203,184,166,148,132,116,104,93,85,80,76,73,75,78,83,91,105,132,157,180,198,172,149,121,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,51,73,95,116,139,161,158,137,114,92,71,49,27,45,69,93,117,142,167,178,154,130,104,81,57,38,61,84,108,134,157,181,163,139,114,91,66,42,17,0,0,16,38,58,80,99,117,134,145,151,150,144,132,114,96,76,55,33,12,0,0,0,0,22,44,65,87,108,132,152,172,193,201,181,162,144,129,112,99,89,81,76,73,75,78,85,95,107,121,137,154,139,119,101,83,64,46,28,7,0,0,0,0,21,44,66,89,110,134,154,175,196,198,179,159,143,123,108,95,85,78,73,75,78,86,97,110,124,144,162,182,202,193,172,152,130,107,86,63,41,19,0,0,0,0,21,46,70,93,118,144,167,191,196,173,152,130,108,89,75,64,58,58,61,75,92,109,124,143,164,189,211,216,208,183,160,139,124,113,101,90,81,72,65,57,44,25,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,32,54,75,96,116,138,157,177,195,200,182,166,152,138,124,116,109,103,101,99,99,101,106,114,124,140,160,182,198,172,149,121,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,41,63,84,106,129,150,170,147,124,103,81,59,38,16,40,64,88,112,137,160,183,160,137,112,89,67,52,71,92,115,139,163,180,157,134,109,85,61,37,13,0,0,24,46,69,91,112,134,153,167,175,175,165,150,132,108,88,65,43,20,0,0,0,0,11,32,54,76,97,117,139,158,177,196,197,179,162,148,134,121,111,105,101,99,99,102,108,116,129,141,155,171,155,137,117,99,82,62,40,16,0,0,0,0,11,33,55,77,98,119,141,161,181,200,195,177,159,144,130,116,108,101,99,99,102,109,118,132,146,162,180,197,197,177,158,139,116,95,74,53,30,8,0,0,0,0,16,40,64,88,112,137,160,181,203,184,163,144,124,109,96,88,83,82,85,92,101,112,124,141,161,186,205,200,202,193,173,160,148,136,123,112,103,96,89,78,61,39,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,42,62,82,103,121,141,161,177,193,201,186,172,160,149,140,134,129,124,124,124,124,132,138,148,160,175,192,198,172,149,121,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,30,53,74,96,117,140,162,158,136,113,91,70,48,26,11,35,57,81,105,129,152,174,168,145,121,101,84,76,87,105,124,148,171,171,148,124,101,78,55,32,8,0,5,29,52,75,98,121,145,167,186,199,198,183,163,141,117,95,72,49,25,0,0,0,0,0,21,42,63,83,103,123,143,161,179,195,198,181,167,155,145,137,130,124,124,124,129,134,140,150,163,176,189,171,154,136,116,94,72,47,22,0,0,0,0,0,22,43,64,86,105,124,146,165,182,199,195,179,164,152,140,132,129,124,124,129,134,143,153,166,181,197,197,180,162,143,121,103,82,62,41,19,0,0,0,0,0,10,33,57,80,103,124,148,169,189,198,179,161,145,130,118,111,107,106,109,116,124,136,147,161,175,195,182,175,178,190,194,181,169,157,146,137,129,119,113,93,69,47,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,28,48,69,87,106,124,143,159,174,189,201,192,182,172,163,158,154,152,149,150,152,155,161,170,181,194,193,179,165,149,121,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,41,64,86,107,130,152,169,146,123,101,80,58,37,15,4,27,50,73,96,118,141,163,178,157,137,118,105,101,106,121,141,161,181,160,138,115,92,70,47,24,0,0,9,32,55,79,101,124,150,175,197,220,216,193,170,147,121,99,73,50,27,0,0,0,0,0,8,28,49,69,88,107,124,144,161,176,191,202,189,177,167,160,154,152,149,150,152,157,163,173,184,196,183,167,152,134,114,93,70,47,22,0,0,0,0,0,9,30,51,71,91,110,130,148,164,180,195,198,184,173,163,156,152,149,149,152,157,164,175,187,201,193,178,162,144,124,107,88,69,48,28,6,0,0,0,0,0,2,25,47,70,91,113,135,155,173,191,197,179,165,153,143,137,134,134,136,140,147,157,169,181,190,177,162,152,156,169,181,194,190,180,169,160,151,144,119,96,71,47,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,34,53,72,89,107,123,139,155,167,180,190,200,195,187,181,177,175,175,175,176,180,184,193,194,183,172,159,146,130,114,93,71,47,24,0,0,0,0,0,0,0,0,0,0,0,0,0,9,31,53,75,97,118,141,163,157,136,112,90,69,47,25,4,0,18,41,64,86,107,130,150,169,172,154,139,129,124,130,141,157,175,166,146,124,104,82,60,38,15,0,0,9,32,55,79,101,124,150,174,197,219,216,193,170,147,121,99,73,50,27,0,0,0,0,0,0,15,35,54,73,91,107,124,141,157,170,182,193,199,190,183,178,175,175,175,176,180,187,195,189,177,163,148,132,116,98,80,61,39,16,0,0,0,0,0,0,17,37,56,76,94,112,130,146,161,174,187,198,195,186,180,175,175,175,176,181,188,197,196,184,172,158,143,129,109,91,73,53,34,14,0,0,0,0,0,0,0,14,37,58,79,99,118,139,156,171,186,198,186,175,166,160,157,157,160,163,170,180,190,181,170,156,143,129,136,148,161,172,183,194,191,182,161,137,113,89,65,42,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,37,55,71,89,105,119,134,146,158,168,176,184,189,193,197,198,198,198,195,191,186,179,171,161,150,138,124,110,94,78,61,39,17,0,0,0,0,0,0,0,0,0,0,0,0,0,21,42,64,87,108,132,153,167,146,123,100,79,57,35,14,0,0,8,30,52,74,94,114,134,152,167,173,162,153,152,154,163,175,165,150,132,110,91,71,49,28,5,0,0,5,29,52,75,98,121,144,166,186,197,196,182,163,141,116,94,71,48,24,0,0,0,0,0,0,0,19,38,56,73,90,106,121,136,148,160,171,179,186,191,195,198,198,198,195,191,184,177,167,155,143,129,112,96,80,62,45,27,6,0,0,0,0,0,0,2,22,40,58,76,94,110,124,140,154,165,175,183,189,193,197,198,198,196,193,188,182,173,163,152,138,123,107,91,74,55,38,19,0,0,0,0,0,0,0,0,3,24,44,65,84,101,119,137,152,164,175,184,191,190,185,182,182,184,188,186,179,170,160,148,136,121,107,113,124,139,149,161,170,179,177,154,130,106,81,58,35,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,21,37,53,70,85,99,112,124,136,145,153,160,165,170,172,175,175,172,170,167,162,155,147,139,129,116,104,90,76,60,44,25,6,0,0,0,0,0,0,0,0,0,0,0,0,9,32,54,75,98,119,143,164,156,135,110,89,67,46,24,2,0,0,0,19,40,60,80,98,116,134,147,159,167,172,175,172,167,158,146,132,112,95,76,57,36,15,0,0,0,0,24,46,68,90,112,134,152,165,174,173,164,148,130,108,87,65,42,20,0,0,0,0,0,0,0,4,21,38,55,72,87,101,114,129,138,147,155,162,167,170,173,175,173,170,167,161,154,145,135,121,107,93,78,62,46,28,10,0,0,0,0,0,0,0,0,6,24,42,58,75,91,105,118,132,143,152,160,165,170,172,175,175,172,168,164,158,150,141,130,116,103,89,73,56,38,21,3,0,0,0,0,0,0,0,0,0,10,30,49,67,85,101,116,132,143,153,161,167,170,174,175,173,170,167,162,155,147,137,124,114,100,87,92,104,115,129,139,147,156,163,147,121,98,74,51,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,19,36,50,65,79,90,101,112,121,130,137,142,145,149,149,149,149,147,144,138,132,124,115,105,95,82,70,56,42,26,10,0,0,0,0,0,0,0,0,0,0,0,0,0,16,41,65,87,109,132,149,149,145,121,99,78,56,34,13,0,0,0,0,5,26,45,64,82,98,112,124,137,144,149,149,148,144,136,123,110,95,78,60,42,22,2,0,0,0,0,15,37,58,79,98,116,132,144,149,149,143,130,112,95,75,54,33,12,0,0,0,0,0,0,0,0,3,21,37,52,67,80,93,104,115,123,132,139,144,147,149,149,149,147,144,138,132,121,112,99,88,74,59,44,28,12,0,0,0,0,0,0,0,0,0,0,6,24,40,56,71,85,97,109,119,129,136,142,145,149,149,149,148,144,141,135,129,117,107,96,82,69,54,38,21,4,0,0,0,0,0,0,0,0,0,0,0,15,33,49,67,82,96,108,119,132,138,144,147,149,149,149,147,144,139,132,123,114,104,92,80,67,71,82,93,105,115,123,134,140,139,114,91,67,44,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,16,30,45,57,69,80,90,98,106,111,116,119,121,121,121,121,119,116,113,107,100,93,82,72,61,49,36,21,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,68,91,115,121,121,121,121,110,88,66,45,23,1,0,0,0,0,0,11,29,46,63,78,91,103,113,119,121,121,121,118,111,101,90,76,60,44,26,7,0,0,0,0,0,5,25,45,64,82,97,109,118,121,121,117,108,94,78,61,42,22,2,0,0,0,0,0,0,0,0,0,2,18,32,46,59,71,82,92,100,107,113,116,121,121,121,121,121,116,113,106,98,89,79,66,53,39,25,9,0,0,0,0,0,0,0,0,0,0,0,0,6,22,37,50,64,75,87,96,105,110,116,119,121,121,121,121,119,115,109,103,94,84,73,62,48,34,19,3,0,0,0,0,0,0,0,0,0,0,0,0,0,15,32,47,62,74,87,97,106,113,117,121,121,121,121,121,117,113,107,100,91,81,70,58,46,49,61,72,82,92,100,109,116,121,107,84,60,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,23,36,47,57,66,74,81,87,91,95,96,99,99,96,96,93,89,83,77,69,60,50,39,28,15,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,38,59,81,97,99,99,99,99,93,76,55,33,12,0,0,0,0,0,0,0,12,28,44,57,70,80,89,94,98,99,98,93,88,79,69,56,42,26,8,0,0,0,0,0,0,0,12,30,47,63,76,88,94,98,98,93,86,75,60,44,27,8,0,0,0,0,0,0,0,0,0,0,0,0,12,25,38,49,59,69,77,83,89,93,96,98,99,98,96,93,89,82,75,66,56,45,33,19,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,16,30,42,54,64,73,80,86,91,96,96,99,99,96,94,91,86,80,71,63,51,40,27,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,27,41,53,64,74,82,88,93,96,99,99,98,96,93,89,83,76,68,58,48,37,25,28,38,49,60,68,77,85,92,98,92,74,51,28,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,24,34,43,51,58,63,68,71,73,73,73,73,72,69,65,60,54,46,38,28,17,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,47,62,72,73,73,73,73,70,59,42,21,0,0,0,0,0,0,0,0,0,9,24,37,48,58,65,71,73,73,73,70,65,57,47,35,22,7,0,0,0,0,0,0,0,0,0,13,29,43,55,65,70,73,73,70,63,53,41,26,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,16,27,37,45,53,60,65,69,73,73,73,73,73,69,65,59,53,44,34,23,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,21,32,41,50,57,63,68,71,73,73,73,73,71,67,62,56,49,40,30,19,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,20,31,42,52,59,65,70,73,73,73,73,73,69,65,60,53,45,36,27,15,4,5,16,28,37,46,54,62,69,73,69,56,40,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,12,20,28,34,39,43,47,48,48,48,48,48,45,41,36,30,23,15,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,28,40,47,48,48,48,48,46,38,24,6,0,0,0,0,0,0,0,0,0,0,3,15,26,35,41,46,48,48,48,46,41,34,24,14,1,0,0,0,0,0,0,0,0,0,0,0,10,22,32,41,47,48,48,46,40,31,21,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,14,22,30,36,41,45,48,48,48,48,48,45,41,35,29,21,12,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,18,27,33,39,43,47,48,48,48,48,46,43,38,32,25,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,20,28,35,41,45,48,48,48,48,48,45,41,36,30,22,14,4,0,0,0,0,5,14,23,31,38,45,48,45,37,22,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,9,15,19,22,23,25,25,24,22,20,16,11,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,19,24,25,25,25,25,23,16,4,0,0,0,0,0,0,0,0,0,0,0,0,0,3,11,17,22,25,25,24,21,17,10,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,17,22,22,22,22,16,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,11,17,20,22,25,25,25,22,20,17,11,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,9,15,19,22,24,25,25,23,22,18,14,8,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,11,16,20,22,25,25,25,22,20,17,11,6,0,0,0,0,0,0,0,0,0,0,8,14,21,22,23,15,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,15,21,27,27,27,27,21,14,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,14,18,22,25,27,26,24,21,17,11,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,12,18,22,25,28,30,29,26,23,19,14,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,25,21,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,14,20,24,27,30,30,27,24,20,16,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,12,18,22,25,28,30,29,27,24,20,15,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,13,22,25,25,25,25,25,25,25,25,20,11,0,0,0,0,0,0,0,0,0,0,9,19,24,25,25,25,25,25,25,25,20,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,25,36,45,50,53,53,50,44,36,25,12,0,0,0,0,0,0,0,0,0,0,0,0,1,12,22,30,38,43,47,50,53,51,48,46,41,35,28,20,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,21,29,36,42,47,50,53,53,53,50,48,44,38,32,23,15,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,19,33,45,50,50,50,50,50,50,50,50,45,33,19,0,0,0,0,0,0,0,0,0,0,0,0,0,3,13,23,32,38,44,49,50,53,53,50,49,45,40,33,24,14,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,28,36,42,47,50,52,53,53,50,48,45,39,33,25,16,5,0,0,0,0,0,0,0,0,0,0,2,19,35,45,50,50,50,50,50,50,50,50,43,32,15,0,0,0,0,0,0,0,0,13,29,42,49,50,50,50,50,50,50,50,44,33,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,32,46,58,68,74,77,77,74,68,57,45,31,15,0,0,0,0,0,0,0,0,0,0,11,23,34,45,54,62,68,73,73,78,76,73,70,66,60,52,44,33,21,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,22,33,44,53,60,67,72,75,76,78,77,76,72,68,62,55,46,37,27,16,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,35,53,69,75,76,76,76,76,76,76,75,67,53,33,14,0,0,0,0,0,0,0,0,0,0,0,12,24,36,46,55,62,69,73,76,78,78,76,73,70,63,56,47,36,24,12,0,0,0,0,0,0,0,0,0,0,0,0,0,7,20,31,42,51,60,66,71,75,76,78,77,76,73,69,63,57,48,38,27,14,0,0,0,0,0,0,0,0,0,14,36,55,69,76,76,76,76,76,76,76,75,66,51,31,11,0,0,0,0,0,0,7,27,47,63,74,76,76,76,76,76,76,75,67,51,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,33,49,65,79,90,98,101,101,98,90,79,64,49,31,13,0,0,0,0,0,0,0,3,18,32,45,57,67,78,86,93,97,99,103,101,99,96,91,84,76,66,55,43,28,13,0,0,0,0,0,0,0,0,0,0,0,0,0,15,30,43,55,66,75,83,90,95,99,101,104,101,99,96,91,85,77,69,59,48,37,24,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,45,69,87,98,99,99,99,99,99,99,98,87,69,45,24,0,0,0,0,0,0,0,0,0,3,18,32,45,57,68,77,85,92,96,100,103,102,100,97,93,86,78,69,57,46,32,19,4,0,0,0,0,0,0,0,0,0,0,14,28,41,53,64,74,82,90,95,99,101,104,101,99,96,93,86,79,71,59,48,34,20,4,0,0,0,0,0,0,1,24,48,69,89,98,99,99,99,99,99,99,98,85,64,43,19,0,0,0,0,0,0,16,38,62,81,97,99,99,99,99,99,99,98,87,66,43,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,29,48,67,83,99,112,121,124,124,121,110,98,82,65,47,27,6,0,0,0,0,0,6,22,38,52,66,79,90,101,109,116,121,124,129,129,124,119,114,108,99,89,76,63,47,31,13,0,0,0,0,0,0,0,0,0,0,1,19,35,50,64,76,88,98,107,114,119,123,124,129,124,124,119,115,109,101,92,81,71,58,45,32,17,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,98,123,124,124,124,124,124,124,121,98,76,50,27,0,0,0,0,0,0,0,0,4,21,37,52,66,79,90,100,109,116,121,124,129,129,124,121,116,110,101,91,79,67,53,38,23,6,0,0,0,0,0,0,0,5,20,35,49,62,74,87,97,106,114,119,123,124,129,129,124,121,116,110,102,93,82,69,55,38,22,4,0,0,0,0,0,5,27,53,76,101,123,124,124,124,124,124,124,118,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,124,124,124,124,124,124,121,98,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,39,61,81,99,117,134,145,152,152,145,134,116,98,79,58,38,16,0,0,0,0,6,24,41,57,72,87,100,113,124,135,143,147,152,154,152,150,147,140,132,121,110,98,83,67,49,31,12,0,0,0,0,0,0,0,0,0,19,37,53,69,85,98,110,121,132,139,144,149,152,154,152,150,147,140,134,124,114,104,92,80,66,52,37,20,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,152,152,152,152,149,121,99,76,50,27,0,0,0,0,0,0,0,4,22,38,56,72,86,100,112,123,134,141,147,151,152,152,152,147,142,135,124,113,100,87,73,58,41,24,6,0,0,0,0,0,8,24,40,55,69,83,96,108,119,130,139,144,149,152,154,152,150,147,142,136,124,115,103,89,74,56,40,21,2,0,0,0,0,5,27,53,76,101,124,152,152,152,152,152,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,152,152,152,152,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,25,49,70,92,113,134,153,166,175,175,166,150,132,110,90,69,46,24,1,0,0,5,24,42,60,76,92,107,121,136,148,158,167,173,177,178,177,175,171,164,156,146,134,117,101,83,65,45,26,5,0,0,0,0,0,0,0,15,35,53,71,87,104,118,134,145,154,162,168,173,176,178,177,174,170,163,156,147,138,124,113,100,86,71,55,37,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,177,177,172,149,121,99,76,50,27,0,0,0,0,0,0,0,20,38,56,74,90,107,119,135,146,156,164,170,175,177,177,175,171,165,157,147,135,121,107,92,76,58,41,20,0,0,0,0,2,23,42,58,74,89,104,116,132,143,153,162,168,173,175,178,177,175,170,165,158,149,138,123,109,92,74,56,36,15,0,0,0,0,5,27,53,76,101,124,152,175,177,177,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,177,177,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,54,77,99,121,145,166,186,199,198,184,165,144,119,98,75,52,29,6,0,0,17,40,59,76,94,110,129,143,157,170,181,191,188,185,185,185,191,195,188,179,167,154,137,119,99,80,59,38,16,0,0,0,0,0,0,8,29,50,69,88,105,123,139,154,166,177,186,192,197,198,195,196,198,194,188,180,171,160,148,136,119,105,89,73,54,32,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,0,0,0,0,15,35,54,73,91,109,124,141,155,168,179,188,194,189,187,187,188,191,189,180,169,156,143,129,110,94,74,52,29,4,0,0,0,13,37,59,78,93,109,123,139,152,164,175,185,190,185,182,182,183,188,194,189,181,171,159,144,129,109,91,71,50,28,6,0,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,33,57,80,103,129,152,174,197,219,217,195,172,149,124,101,78,55,30,7,0,1,25,48,72,94,112,132,148,163,177,189,178,168,162,160,160,160,167,177,189,202,189,173,155,136,114,92,71,49,26,4,0,0,0,0,0,21,42,64,84,103,123,143,159,174,188,199,190,181,175,172,172,172,173,177,183,191,193,182,170,155,141,123,107,88,65,41,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,0,0,0,7,28,49,69,89,107,124,144,161,176,190,189,179,171,165,162,162,162,168,175,184,190,177,162,146,130,106,81,58,32,7,0,0,0,19,44,69,91,112,130,144,159,173,186,184,174,166,160,157,157,160,163,171,181,196,193,179,163,146,124,105,83,62,39,17,0,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,33,57,81,104,129,152,175,197,220,217,195,172,149,124,101,78,55,30,7,0,2,27,50,76,101,123,141,157,174,181,167,155,145,138,134,134,137,144,154,170,186,204,189,170,148,124,104,81,58,35,12,0,0,0,0,9,32,54,76,98,117,139,159,177,193,195,180,167,158,152,148,147,147,149,154,160,168,179,190,190,175,155,137,115,91,65,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,0,0,0,19,41,62,83,103,123,143,161,179,195,182,169,157,147,142,137,137,139,144,153,163,175,172,154,136,116,98,76,55,30,5,0,0,0,20,45,70,93,116,136,155,174,189,176,163,152,143,137,134,134,134,139,149,161,177,195,198,180,161,140,117,95,72,49,26,3,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,55,78,100,121,146,167,186,200,199,185,165,144,119,98,75,52,29,6,0,0,24,45,69,89,105,121,139,155,162,146,134,121,113,108,106,111,119,135,152,170,190,203,181,159,137,112,89,65,41,19,0,0,0,0,18,41,64,87,109,132,154,174,193,195,177,161,146,136,129,121,119,121,124,130,137,146,157,169,179,160,141,119,101,81,61,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,0,0,8,31,53,74,95,116,139,158,178,197,182,164,148,136,123,116,111,111,114,119,130,141,155,156,137,117,99,82,63,44,22,0,0,0,0,15,39,60,81,99,119,139,159,170,155,143,130,118,111,106,106,109,115,124,141,159,178,199,195,173,152,129,105,81,57,33,9,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,26,49,71,92,113,136,154,167,176,176,167,152,134,112,90,69,47,24,1,0,0,14,35,53,70,87,103,119,137,143,124,110,98,89,83,83,87,98,116,136,157,179,202,191,167,144,118,94,71,47,23,0,0,0,1,25,49,73,97,119,143,166,188,203,181,160,141,124,112,102,98,96,96,99,105,113,121,136,148,161,144,123,105,85,66,47,26,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,0,0,19,41,63,86,107,130,152,172,192,184,165,146,130,112,100,92,88,86,89,97,107,119,136,140,119,101,83,65,47,29,10,0,0,0,0,5,26,46,65,84,103,123,143,150,136,119,107,96,87,83,81,85,92,105,123,144,165,188,207,184,160,137,112,88,63,39,14,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,40,61,82,100,117,136,146,152,152,146,134,117,99,80,59,38,17,0,0,0,0,19,35,51,68,85,101,117,123,107,91,76,65,58,58,64,81,101,123,148,171,195,196,172,147,121,98,73,50,25,0,0,0,6,31,55,79,103,129,152,175,198,193,170,147,124,105,90,80,73,71,71,75,81,90,100,113,129,141,129,109,89,70,51,31,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,0,5,28,51,73,96,117,141,163,184,191,171,150,130,110,93,79,69,63,61,65,74,86,99,116,121,104,85,67,49,31,13,0,0,0,0,0,0,11,30,49,69,88,107,124,132,114,99,86,73,64,59,58,61,72,88,109,132,156,180,204,191,167,142,116,91,67,42,17,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,29,49,67,85,99,113,121,129,129,121,112,99,83,65,47,28,6,0,0,0,0,1,17,33,49,65,82,99,102,89,72,56,43,34,33,47,70,93,116,144,167,192,198,174,149,121,99,73,50,25,0,0,0,10,34,58,83,108,134,157,182,206,188,162,139,114,91,71,57,50,47,48,51,58,67,79,92,106,121,112,93,74,55,36,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,0,13,36,59,82,106,129,152,174,196,180,158,137,115,95,76,59,46,39,38,42,53,65,82,99,102,87,69,51,33,15,0,0,0,0,0,0,0,0,15,34,53,72,91,110,112,95,80,65,52,41,34,33,38,54,77,101,124,150,175,200,195,170,144,119,93,68,43,20,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,34,51,67,80,91,98,101,101,98,90,80,65,49,32,14,0,0,0,0,0,0,0,15,31,47,63,76,78,69,53,37,21,9,20,44,68,91,116,142,167,190,197,172,149,121,99,73,50,25,0,0,0,10,35,60,85,109,137,160,185,210,185,160,137,109,86,60,36,25,22,23,27,35,45,57,72,86,98,95,78,58,40,20,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,0,20,45,67,90,114,138,161,184,193,170,147,124,103,81,61,42,24,15,12,19,31,46,63,76,78,69,53,35,17,0,0,0,0,0,0,0,0,0,0,18,37,56,74,89,90,76,60,45,31,19,10,8,23,48,73,98,121,149,175,200,195,170,144,119,93,68,43,20,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,33,48,59,69,75,78,78,75,69,58,47,32,15,0,0,0,0,0,0,0,0,0,13,29,42,51,53,47,34,19,2,13,33,54,75,98,121,145,168,193,192,168,144,119,96,72,48,24,0,0,0,10,35,60,86,109,137,161,185,210,186,162,137,111,88,67,50,37,27,17,8,12,24,37,52,65,73,73,59,44,24,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,3,27,51,74,98,121,146,169,192,185,161,139,115,92,70,48,33,37,38,38,36,33,29,42,51,53,47,34,19,1,0,0,0,0,0,0,0,0,0,0,2,22,40,55,64,65,56,42,26,11,7,11,18,30,53,76,100,124,150,175,200,191,167,144,116,91,68,43,17,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,27,37,45,52,53,53,51,45,37,26,13,0,0,0,0,0,0,0,0,0,0,0,9,19,26,27,23,13,0,9,28,48,67,88,108,132,153,176,199,181,160,137,114,90,67,43,20,0,0,0,10,35,59,83,109,134,159,183,207,190,167,144,119,101,83,71,59,49,40,31,21,11,17,32,44,50,49,40,26,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,9,33,57,80,104,129,152,176,200,177,154,132,106,83,60,51,57,60,63,61,60,57,52,45,38,30,24,14,0,0,0,0,0,0,0,0,0,0,0,0,0,4,21,34,42,42,35,26,27,30,32,35,41,50,65,85,108,132,155,179,204,184,161,138,112,88,64,39,15,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,16,23,27,30,30,27,22,15,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,7,25,44,63,82,101,121,143,164,186,190,170,148,124,104,81,59,36,13,0,0,0,7,32,56,80,105,130,154,177,201,199,177,155,137,119,105,92,81,72,63,53,44,34,25,15,20,25,24,17,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,14,38,62,86,109,136,159,183,196,172,147,123,99,75,66,74,81,86,86,86,85,81,77,69,61,50,39,26,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,17,26,41,50,53,55,56,60,65,73,84,99,119,141,164,187,194,173,152,129,105,81,58,34,10,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,23,42,60,79,98,116,137,157,177,196,176,156,136,114,92,71,49,27,5,0,0,0,3,27,51,75,98,121,146,167,190,210,191,171,155,139,124,114,105,95,86,76,66,57,48,38,29,18,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,18,42,66,90,114,139,163,188,191,167,143,117,93,78,88,98,105,109,111,111,109,106,100,93,83,72,59,45,30,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,43,60,74,78,78,81,83,89,96,106,118,137,155,174,194,177,159,139,117,96,73,49,27,4,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,6,7,5,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,38,58,76,94,113,134,152,171,191,180,161,143,121,101,81,59,38,16,0,0,0,0,0,20,44,67,90,112,135,156,177,196,207,189,173,161,148,137,129,117,108,98,89,80,70,61,50,40,29,16,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,21,45,70,93,118,144,167,192,188,163,139,114,90,99,110,121,130,135,137,137,134,132,123,115,105,93,80,64,47,30,12,0,0,0,0,0,0,0,0,0,0,0,0,4,29,53,76,95,101,103,104,107,112,119,129,140,155,171,188,175,160,143,123,103,83,62,40,17,0,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,15,22,28,30,30,29,25,18,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,35,54,74,92,110,130,150,168,187,182,164,146,124,106,87,67,46,26,5,0,0,0,0,0,12,34,56,79,100,121,143,162,179,196,208,194,181,170,160,151,141,132,121,112,102,93,83,73,62,50,38,24,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,23,48,72,96,119,147,170,195,185,161,137,111,106,119,134,145,153,160,162,162,160,155,148,139,129,114,99,82,65,47,27,7,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,129,129,132,134,137,144,152,162,174,177,166,154,141,123,107,89,69,48,28,6,0,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,26,37,45,52,55,55,53,49,41,31,19,6,0,0,0,0,0,0,0,0,0,0,0,0,0,8,28,49,69,89,108,129,146,166,184,184,165,147,129,109,91,72,52,33,12,0,0,0,0,0,0,1,23,45,67,87,106,124,144,162,177,191,203,204,192,183,174,164,155,145,136,124,116,106,96,84,72,58,44,28,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,2,25,50,74,99,121,149,172,198,182,160,134,109,124,141,155,166,176,183,187,186,183,178,171,162,149,136,117,99,82,62,41,21,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,134,154,155,157,162,167,175,184,172,155,144,134,118,105,89,71,53,34,14,0,0,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,33,47,58,68,75,78,78,77,71,63,52,38,22,6,0,0,0,0,0,0,0,0,0,0,0,0,19,41,62,83,103,123,144,163,182,187,168,149,130,110,92,74,56,37,18,0,0,0,0,0,0,0,0,11,32,52,72,91,109,124,143,157,170,182,192,202,205,196,187,177,168,158,149,139,129,117,105,92,78,63,46,28,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,2,25,50,76,99,124,152,175,200,182,157,134,129,144,161,175,168,164,162,165,167,174,184,194,183,169,154,136,116,96,75,54,32,10,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,134,160,180,182,185,191,197,188,162,139,121,110,98,87,74,59,44,26,10,0,0,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,34,51,67,80,91,98,103,104,101,94,85,72,56,40,22,3,0,0,0,0,0,0,0,0,0,0,8,30,52,74,96,117,138,158,178,192,172,153,134,113,94,76,58,40,22,2,0,0,0,0,0,0,0,0,0,18,38,56,73,91,107,121,137,148,160,170,180,189,199,209,200,190,181,172,162,152,140,129,112,98,82,64,46,27,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,2,27,50,76,99,124,152,175,200,183,157,134,144,162,164,154,145,139,137,139,144,152,163,177,193,188,170,152,132,108,87,65,42,20,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,134,160,172,175,178,182,187,191,167,150,140,132,119,108,94,78,62,44,26,7,0,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,29,49,67,83,99,113,121,129,129,124,117,105,91,73,55,36,16,0,0,0,0,0,0,0,0,0,0,16,39,63,84,106,130,152,172,193,180,159,138,117,98,78,60,41,23,5,0,0,0,0,0,0,0,0,0,0,2,21,38,55,72,87,101,114,124,137,147,157,166,177,187,196,206,204,195,184,174,161,148,134,116,98,80,61,41,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,2,27,50,76,101,124,152,175,200,191,170,157,163,157,144,132,121,114,111,113,118,129,143,159,177,197,185,164,143,119,97,74,52,28,4,0,0,0,0,0,0,0,0,0,7,33,58,83,109])
.concat([134,147,149,150,153,157,163,170,179,172,163,154,144,130,114,96,80,62,42,21,1,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,40,62,81,101,117,135,146,152,154,149,139,123,107,88,69,48,27,6,0,0,0,0,0,0,0,0,1,24,47,70,93,116,140,162,184,190,167,146,124,103,83,63,44,25,6,0,0,0,0,0,0,0,0,0,0,0,0,3,21,38,53,67,80,92,103,114,123,135,144,154,164,174,183,194,204,206,195,182,168,152,135,115,96,76,55,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,2,27,50,76,101,124,152,175,200,206,190,173,155,139,121,109,98,90,86,89,96,107,123,143,163,184,198,175,152,130,106,82,59,35,12,0,0,0,0,0,0,0,0,0,7,32,57,83,106,121,121,121,124,129,134,139,147,157,170,184,175,163,149,134,114,96,76,56,35,13,0,0,5,27,53,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,190,198,172,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,48,70,92,114,135,154,167,176,177,172,159,141,121,100,80,58,36,14,0,0,0,0,0,0,0,0,6,31,54,78,101,124,148,172,195,180,157,136,112,90,70,48,29,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,18,33,47,59,71,81,91,101,110,121,132,141,152,161,172,182,195,209,202,186,170,152,132,110,89,66,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,2,27,50,76,99,124,152,175,199,197,177,157,139,119,103,88,75,66,63,65,73,88,107,129,152,174,197,184,160,137,113,88,65,41,17,0,0,0,0,0,0,0,0,0,3,28,51,74,90,96,96,99,101,104,109,115,123,136,150,166,184,184,168,152,132,112,90,69,46,24,1,0,3,27,52,76,101,124,152,175,200,195,170,147,119,96,71,48,22,0,0,0,0,0,0,20,43,68,91,116,142,167,191,197,172,147,121,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,30,53,76,99,121,145,167,187,199,201,193,174,154,134,109,88,66,43,20,0,0,0,0,0,0,0,0,10,35,58,83,106,132,155,180,196,172,149,124,101,80,57,36,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,25,37,48,58,69,78,88,98,108,117,129,139,149,161,174,189,206,204,186,165,145,121,99,77,54,31,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,1,25,50,73,98,121,149,172,197,187,164,143,121,103,85,68,54,43,38,41,54,73,96,118,143,167,191,190,166,143,117,93,70,45,21,0,0,0,0,0,0,0,0,0,0,17,38,56,67,71,71,73,76,80,85,91,101,114,132,149,169,191,186,167,146,124,101,79,56,33,9,0,2,27,50,76,99,124,150,175,198,195,172,147,121,96,73,48,25,0,0,0,0,0,0,21,45,69,93,116,144,167,193,195,171,147,121,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,78,101,124,149,172,195,218,225,206,185,163,141,116,94,72,48,25,0,0,0,0,0,0,0,0,12,35,60,86,109,134,160,182,182,167,144,119,94,71,48,25,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,4,15,25,36,46,56,65,75,85,95,105,115,129,139,154,170,188,208,200,178,156,134,109,85,61,38,14,0,0,0,0,0,0,0,0,2,11,19,17,15,5,0,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,22,48,72,96,119,147,170,194,185,162,137,111,88,68,50,33,21,13,19,41,65,89,113,138,162,185,195,170,147,121,96,73,48,23,0,0,0,0,0,0,0,3,9,12,10,20,34,43,46,48,49,52,56,61,69,80,94,114,136,157,181,201,180,158,136,111,87,64,40,16,0,2,26,50,73,99,121,148,172,196,198,172,149,121,99,75,50,27,2,0,0,0,0,0,24,47,71,96,119,145,170,193,193,169,144,119,95,71,47,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,76,99,121,146,168,189,202,205,208,191,168,145,121,99,76,52,29,0,0,0,0,0,0,0,0,12,35,60,86,109,137,157,157,157,157,142,116,91,68,43,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,18,25,30,26,15,4,14,24,33,43,53,63,73,82,93,105,118,136,154,173,195,211,188,164,141,116,91,68,43,19,0,0,0,0,0,0,0,9,23,34,42,42,37,26,11,0,0,2,27,50,76,99,124,149,175,198,198,172,149,121,99,76,50,27,0,0,20,45,69,93,116,142,166,190,188,165,139,114,91,67,43,19,0,0,12,37,60,86,109,137,160,185,198,172,149,121,98,73,48,25,0,0,0,0,0,0,9,24,34,38,35,27,14,20,22,22,25,27,32,37,46,60,79,101,124,150,174,198,191,167,144,117,93,69,45,21,0,0,24,48,72,96,119,146,170,193,199,175,152,124,101,78,54,30,6,0,0,0,0,4,28,51,75,99,121,148,172,196,190,167,142,116,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,26,49,72,93,115,137,156,170,178,180,185,195,172,149,121,99,76,53,30,0,0,0,0,0,0,0,0,11,35,59,83,106,132,132,132,132,132,132,116,93,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,26,41,50,53,49,37,22,6,1,11,21,31,40,50,61,72,85,99,117,139,162,184,208,194,170,147,119,96,71,47,22,0,0,0,0,0,0,14,28,43,57,66,68,61,46,28,9,0,5,28,53,76,101,124,149,175,198,198,172,149,121,99,75,50,27,0,0,17,40,65,88,113,139,162,186,192,168,144,119,96,72,48,24,0,0,11,35,60,83,109,134,160,182,198,174,149,121,99,73,50,25,0,0,0,0,0,7,27,45,57,63,60,48,32,16,0,0,0,2,7,14,25,46,71,95,119,144,170,195,197,172,148,121,97,73,48,22,0,0,21,45,69,93,116,142,165,190,203,178,155,132,106,83,59,36,13,0,0,0,0,11,34,57,80,104,129,152,175,200,187,162,139,114,90,66,42,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,42,63,83,103,121,137,148,154,157,165,181,172,149,121,99,76,53,30,0,0,0,0,0,0,0,0,7,32,54,78,96,104,104,104,104,104,104,101,86,64,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,5,24,43,60,74,78,71,56,41,26,12,0,0,8,17,27,38,50,65,83,106,130,153,178,202,198,173,149,121,96,73,48,22,0,0,0,0,6,20,34,48,62,77,90,93,80,62,42,22,4,7,31,55,78,101,129,152,175,200,195,172,147,121,99,73,50,25,0,0,12,36,61,84,108,132,155,180,197,173,150,124,101,78,55,32,9,0,13,37,61,86,109,137,160,185,197,172,149,121,97,73,48,25,0,0,0,0,2,22,42,62,79,88,82,67,51,35,20,7,0,0,0,0,18,43,68,93,116,144,170,195,200,175,149,121,99,73,48,22,0,0,17,41,65,88,113,138,161,185,207,183,160,137,114,90,67,45,24,5,0,0,5,22,44,65,88,111,135,158,181,205,182,158,135,109,86,62,38,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,31,51,71,87,103,115,124,132,132,150,173,170,147,121,99,76,53,30,0,0,0,0,0,0,0,0,0,22,43,62,74,78,78,78,78,78,78,77,68,51,30,9,0,0,0,0,0,0,0,0,0,0,0,0,3,21,40,58,78,96,103,91,75,60,46,33,21,12,5,1,5,16,30,51,75,99,124,150,175,200,198,175,149,121,99,73,48,22,0,0,0,11,25,40,54,69,83,97,110,116,96,76,56,38,25,22,37,60,83,106,132,155,178,202,192,168,144,119,96,72,48,24,0,0,7,30,54,78,101,124,149,172,196,180,156,134,109,86,64,42,21,7,21,43,66,90,114,139,163,186,193,169,145,119,96,71,47,22,0,0,0,0,17,36,57,77,97,111,101,85,69,55,41,29,20,16,15,19,29,48,72,96,119,147,170,195,199,175,149,121,99,73,48,22,0,0,13,36,60,83,107,132,155,179,202,191,168,145,121,99,78,57,40,27,22,23,27,38,57,76,98,119,143,166,188,199,176,152,129,104,80,57,33,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,37,55,70,83,93,101,104,124,149,173,167,144,119,98,75,51,27,0,0,0,0,0,0,0,0,0,19,37,54,69,81,90,96,96,93,86,75,62,46,28,9,0,0,0,0,0,0,0,0,0,0,0,0,19,37,56,74,93,112,129,110,95,80,67,55,44,35,29,25,25,28,36,54,77,101,124,152,175,200,196,172,147,121,96,73,48,22,0,0,9,28,45,60,74,88,103,117,132,130,109,91,73,58,50,48,54,69,91,113,137,160,183,207,188,164,141,116,93,69,45,21,0,0,1,24,48,71,93,116,141,164,187,188,164,142,118,96,76,56,40,32,38,55,75,98,119,144,168,191,188,163,140,115,91,68,44,19,0,0,0,12,31,51,72,92,112,132,119,105,89,75,62,51,45,40,40,43,51,64,83,104,129,152,175,199,195,171,147,121,96,72,47,22,0,0,7,30,54,78,101,124,147,171,193,199,177,155,134,112,92,74,59,51,48,48,52,59,74,91,110,132,153,175,197,191,168,145,121,98,75,51,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,21,36,50,62,71,88,109,132,155,177,162,139,116,93,70,47,24,0,0,0,0,0,0,0,0,13,33,53,72,89,104,114,119,121,117,109,96,80,63,44,24,3,0,0,0,0,0,0,0,0,0,0,16,35,53,72,91,109,130,146,130,114,101,88,76,67,59,54,50,50,53,59,70,88,109,134,156,180,204,190,167,143,117,93,69,45,20,0,0,20,42,63,80,94,109,123,138,152,144,124,107,92,81,74,73,77,87,103,123,146,168,191,204,181,159,136,111,88,64,41,17,0,0,0,16,40,62,85,108,132,154,176,197,174,153,132,109,91,74,62,56,60,71,89,109,132,153,176,198,180,156,134,109,86,62,38,14,0,0,6,26,46,66,86,106,129,147,140,123,109,96,84,75,69,66,65,68,73,84,99,116,139,160,183,206,188,165,142,116,92,68,44,19,0,0,1,24,47,70,93,115,139,162,183,205,188,167,146,129,109,94,82,75,73,73,76,82,93,109,124,146,165,187,203,181,160,137,113,90,67,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,24,35,48,64,81,99,119,141,162,176,154,132,109,87,65,42,19,0,0,0,0,0,0,0,2,24,46,67,88,107,123,138,147,147,143,132,116,98,79,57,36,14,0,0,0,0,0,0,0,0,0,11,31,51,69,88,107,124,146,164,150,136,121,109,99,90,83,78,75,73,77,81,90,105,121,144,165,187,205,182,160,137,111,88,64,40,16,0,4,26,51,73,97,114,130,144,158,172,161,143,129,113,104,98,97,101,108,121,139,158,179,200,196,173,151,129,104,81,58,35,11,0,0,0,8,32,54,75,98,119,144,164,186,186,165,145,124,109,95,85,81,83,92,105,123,144,164,186,191,170,147,124,101,78,56,32,8,0,0,17,40,61,81,100,121,141,161,159,144,130,116,106,98,93,88,88,91,96,106,117,136,154,172,194,199,178,156,134,109,85,61,38,14,0,0,0,16,39,61,83,106,129,150,172,192,201,181,162,144,129,114,106,100,96,96,100,106,114,129,144,161,179,199,190,170,148,124,104,81,59,36,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,21,35,46,56,67,82,98,114,134,153,173,165,145,121,101,79,57,35,13,0,0,0,0,0,0,0,9,33,57,79,100,121,143,160,170,172,166,152,134,112,90,68,45,22,0,0,0,0,0,0,0,0,0,20,43,66,85,104,123,143,161,180,170,156,144,132,121,113,106,101,99,99,101,106,113,124,141,159,178,198,192,171,149,129,103,80,57,34,10,0,4,27,52,75,100,121,143,163,178,192,179,162,148,137,129,121,121,124,132,143,157,173,192,203,184,163,141,118,96,73,51,28,5,0,0,0,0,21,43,65,88,108,132,152,171,191,179,162,144,130,116,109,106,106,114,124,143,159,178,197,178,157,137,114,91,70,48,24,1,0,0,24,48,73,95,116,137,156,176,179,165,152,140,130,121,116,114,114,116,121,130,140,154,170,188,204,186,165,145,121,99,76,54,31,7,0,0,0,7,30,51,73,95,116,138,158,179,197,197,180,163,149,138,130,124,121,121,124,132,138,149,163,179,197,195,177,156,136,114,92,71,49,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,55,67,78,88,101,115,132,150,167,172,153,134,112,91,70,49,27,5,0,0,0,0,0,0,0,14,39,63,86,109,134,156,177,194,198,186,167,147,121,99,76,52,29,4,0,0,0,0,0,0,0,2,25,50,75,99,119,141,159,177,197,191,178,166,155,146,138,132,129,124,124,124,132,137,147,160,176,193,197,177,158,137,115,93,71,49,25,2,0,0,23,46,67,88,107,129,148,166,184,197,181,170,160,152,149,149,150,156,165,177,192,205,188,170,150,130,107,86,64,42,20,0,0,0,0,0,11,32,54,75,96,116,137,157,175,191,179,164,150,140,134,132,134,138,148,161,177,195,181,163,144,123,101,81,58,37,15,0,0,0,25,50,73,98,121,141,157,173,188,186,173,163,154,147,142,141,139,142,146,152,162,174,188,201,186,170,152,132,109,88,66,44,22,0,0,0,0,0,19,40,62,83,103,123,144,163,180,196,198,184,171,161,155,150,149,149,150,155,161,171,183,197,195,179,161,141,121,101,81,59,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,28,49,69,88,99,109,121,136,150,166,175,157,139,118,99,79,59,38,17,0,0,0,0,0,0,0,0,17,40,66,89,114,139,164,188,211,222,200,177,153,129,103,78,55,30,7,0,0,0,0,0,0,0,1,24,49,73,96,116,134,149,164,178,191,199,188,178,169,162,155,152,149,149,152,155,160,169,181,194,194,179,161,143,123,103,81,59,38,16,0,0,0,13,33,54,74,93,112,132,150,166,180,194,192,184,177,175,175,175,180,187,198,198,186,170,154,136,115,95,74,54,32,10,0,0,0,0,0,0,21,41,62,82,101,121,139,157,172,186,184,172,163,157,157,157,161,170,181,192,179,163,146,129,108,89,69,47,26,4,0,0,0,20,44,67,87,105,121,139,154,168,181,192,185,176,170,167,165,165,165,170,175,184,195,193,181,167,152,136,115,96,76,54,33,11,0,0,0,0,0,7,28,49,70,89,109,129,146,162,177,189,200,194,185,178,175,175,175,175,179,185,194,199,188,175,160,144,124,107,87,67,47,26,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,32,55,78,101,121,132,144,155,169,172,157,141,121,104,86,67,47,27,6,0,0,0,0,0,0,0,0,17,40,66,90,114,139,164,188,212,223,201,177,154,129,104,78,55,30,7,0,0,0,0,0,0,0,0,18,41,63,80,98,114,130,144,157,170,181,191,200,192,185,180,175,175,175,175,178,184,192,197,186,173,159,144,124,107,88,68,48,27,5,0,0,0,0,20,41,59,78,96,113,132,146,160,172,181,188,194,198,198,199,197,192,186,177,165,152,136,117,99,81,62,41,20,0,0,0,0,0,0,0,8,28,48,67,85,103,121,138,152,165,177,185,187,182,180,182,185,189,181,171,158,144,129,110,92,74,54,34,14,0,0,0,0,12,32,51,69,87,103,118,134,147,159,170,180,186,191,190,190,190,190,194,192,187,180,171,160,147,132,116,98,80,61,41,20,0,0,0,0,0,0,0,15,36,55,74,92,109,129,143,155,168,178,185,191,195,198,198,198,198,195,190,184,177,166,154,141,124,107,91,72,53,33,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,54,77,98,119,143,164,175,165,153,139,121,105,89,71,53,33,14,0,0,0,0,0,0,0,0,0,15,39,63,86,110,135,157,179,196,200,188,169,147,123,100,77,52,29,4,0,0,0,0,0,0,0,0,7,27,46,62,78,94,109,121,136,148,158,168,176,183,189,193,197,198,198,197,194,189,183,174,164,153,139,123,107,91,72,53,33,13,0,0,0,0,0,6,25,44,62,78,95,110,124,139,149,158,165,170,173,175,175,172,168,163,155,144,132,116,100,83,65,47,28,7,0,0,0,0,0,0,0,0,14,33,51,69,86,101,117,132,144,154,162,168,172,175,173,170,165,158,148,137,123,109,92,76,58,40,20,0,0,0,0,0,0,17,35,51,68,83,98,112,124,138,147,155,162,167,170,172,175,175,172,168,163,156,148,138,124,112,97,81,64,45,26,6,0,0,0,0,0,0,0,2,21,40,58,74,91,107,121,135,146,155,162,167,171,173,175,175,173,170,167,161,154,144,134,119,105,89,73,55,38,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,24,46,68,90,110,134,155,155,145,132,117,103,89,72,55,38,20,1,0,0,0,0,0,0,0,0,0,10,33,57,80,101,123,144,161,172,175,168,154,136,113,91,69,46,23,0,0,0,0,0,0,0,0,0,0,11,28,44,59,74,88,101,114,124,137,145,153,160,165,170,172,175,175,172,170,165,160,152,142,132,117,104,89,73,55,37,18,0,0,0,0,0,0,0,9,28,44,60,76,91,105,115,129,135,142,145,149,149,149,148,144,139,132,121,109,96,82,65,49,31,13,0,0,0,0,0,0,0,0,0,0,17,35,51,67,83,98,109,121,132,139,144,148,149,149,147,142,135,124,115,103,89,74,58,40,24,5,0,0,0,0,0,0,0,17,33,49,64,78,91,103,114,124,132,139,144,147,149,149,149,147,144,139,134,124,114,104,91,77,62,46,28,10,0,0,0,0,0,0,0,0,0,6,22,40,56,72,87,99,112,121,132,138,143,147,149,149,149,149,147,142,137,132,121,110,98,85,71,55,38,21,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,37,59,81,101,123,143,134,121,110,98,85,71,55,38,22,4,0,0,0,0,0,0,0,0,0,0,3,25,47,69,89,109,124,140,148,149,145,134,117,99,80,58,37,15,0,0,0,0,0,0,0,0,0,0,0,9,25,40,54,67,80,92,103,113,121,132,137,142,145,149,149,149,149,147,142,137,129,118,108,97,83,69,54,38,21,3,0,0,0,0,0,0,0,0,10,26,42,57,70,82,93,102,109,115,119,121,121,121,121,119,114,107,98,88,76,62,47,31,15,0,0,0,0,0,0,0,0,0,0,0,0,17,33,49,63,76,88,98,107,114,119,121,121,121,121,116,110,102,92,81,69,55,40,24,6,0,0,0,0,0,0,0,0,0,14,30,43,57,70,81,91,101,107,114,116,121,121,121,121,121,119,114,109,101,92,82,70,57,43,28,11,0,0,0,0,0,0,0,0,0,0,0,4,22,38,52,66,79,89,99,106,112,116,119,121,121,121,121,119,116,111,106,98,88,77,64,51,36,21,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,28,50,72,93,114,119,110,100,90,78,65,51,37,21,4,0,0,0,0,0,0,0,0,0,0,0,0,14,35,55,73,91,105,116,121,121,119,110,98,82,64,45,25,4,0,0,0,0,0,0,0,0,0,0,0,0,5,20,33,46,58,70,80,90,98,106,111,116,119,121,121,121,121,119,116,111,104,96,86,75,63,50,35,20,3,0,0,0,0,0,0,0,0,0,0,8,22,36,49,59,71,78,85,91,95,96,99,99,96,93,90,83,75,65,54,41,28,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,28,43,55,66,75,83,90,93,96,99,99,96,93,87,79,70,59,48,35,20,5,0,0,0,0,0,0,0,0,0,0,0,9,23,36,48,59,68,77,84,90,93,96,97,99,99,96,93,90,85,77,69,59,48,36,23,8,0,0,0,0,0,0,0,0,0,0,0,0,0,3,18,32,45,56,66,75,82,88,93,96,97,99,99,96,95,92,88,81,74,65,55,43,31,17,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,41,62,81,96,96,88,79,69,57,45,32,18,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,38,55,71,83,92,96,98,96,89,77,63,47,30,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,25,37,47,57,66,74,81,87,91,95,96,99,99,97,95,92,87,80,73,64,53,41,28,15,0,0,0,0,0,0,0,0,0,0,0,0,0,2,16,27,38,48,55,62,67,70,73,73,73,73,70,65,59,52,42,32,21,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,22,33,44,53,60,66,70,73,73,73,73,69,64,57,48,38,27,14,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,27,37,46,54,61,65,69,73,73,73,73,73,71,67,61,55,46,37,27,15,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,23,33,43,51,58,64,68,71,73,73,73,73,71,68,63,57,51,42,33,22,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,29,47,62,72,73,65,57,47,36,25,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,20,36,49,60,68,72,73,70,65,55,43,28,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,15,25,35,43,51,57,64,68,71,73,73,73,73,71,68,63,57,50,41,31,20,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,15,24,32,38,42,46,48,48,48,48,45,41,36,29,20,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,21,29,36,42,46,48,48,48,48,45,40,33,25,15,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,14,23,30,36,41,45,48,48,48,48,48,46,42,37,31,23,15,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,11,20,28,35,39,44,46,48,48,48,48,46,43,39,34,27,20,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,28,40,47,48,42,34,24,14,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,15,27,36,43,47,48,45,40,32,21,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,12,20,28,33,39,43,47,48,48,48,48,47,44,39,33,27,18,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,13,18,22,22,22,22,22,21,17,12,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,12,18,22,24,25,25,23,20,15,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,12,17,20,22,24,25,25,24,22,17,13,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,10,15,19,22,22,22,22,22,22,19,14,10,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,24,25,20,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,12,18,22,22,20,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,9,15,19,22,23,25,25,24,22,19,14,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,5,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,5,4,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,5,5,5,4,0,0,0,0,0,4,5,5,5,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,14,19,24,27,30,30,27,25,21,16,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,13,19,23,27,30,30,27,24,20,14,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,13,20,24,27,30,30,27,23,19,13,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,18,26,27,27,27,27,27,22,11,0,9,19,26,27,27,27,27,27,20,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,14,19,22,25,27,27,27,25,23,19,14,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,23,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,20,9,0,0,0,0,0,1,14,22,25,25,25,25,25,25,25,25,20,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,13,23,31,38,44,48,51,53,53,52,50,46,40,33,24,15,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,20,28,36,43,48,50,53,53,50,48,44,38,30,21,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,20,30,37,44,48,50,53,53,50,48,43,36,29,19,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,26,41,51,53,53,53,53,52,46,32,17,29,42,51,53,53,53,53,52,44,31,13,0,0,0,0,0,0,0,0,0,0,0,0,0,3,13,23,31,37,43,47,50,51,53,52,50,48,43,38,30,22,13,2,0,0,0,0,0,0,0,0,0,0,0,0,0,6,24,39,48,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,43,30,13,0,0,0,4,20,35,45,50,50,50,50,50,50,50,50,43,32,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,23,34,46,55,62,68,73,76,78,78,76,73,70,64,57,48,37,25,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,19,31,42,52,60,67,73,76,78,78,76,73,68,61,53,44,33,22,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,18,31,42,53,61,68,73,76,78,78,76,72,67,61,51,41,30,17,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,43,62,75,78,78,78,78,78,68,51,32,47,63,76,78,78,78,78,77,65,49,28,5,0,0,0,0,0,0,0,0,0,0,0,12,24,34,45,54,61,67,71,75,76,78,77,75,72,67,61,53,45,34,23,10,0,0,0,0,0,0,0,0,0,0,0,0,21,42,59,71,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,64,49,29,7,0,0,18,38,56,68,73,73,73,73,73,73,73,73,65,51,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,30,44,56,67,77,85,92,96,99,102,104,101,98,93,87,79,70,58,46,32,17,1,0,0,0,0,0,0,0,0,0,0,0,0,10,25,40,52,64,74,83,91,96,99,102,103,100,96,91,85,76,65,55,42,28,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,23,38,51,64,74,84,91,96,99,103,102,99,96,90,83,73,63,50,37,22,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,32,56,78,98,104,104,104,104,102,86,64,42,59,80,99,104,104,104,104,100,82,61,37,12,0,0,0,0,0,0,0,0,0,5,19,33,45,57,67,77,85,91,96,99,101,104,101,99,96,91,85,76,67,56,44,30,16,1,0,0,0,0,0,0,0,0,0,6,31,55,77,95,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,83,64,41,16,0,4,28,50,73,90,99,99,99,99,99,99,99,98,85,66,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,33,50,64,78,89,100,109,116,121,124,129,129,124,121,116,110,101,92,81,67,52,35,19,1,0,0,0,0,0,0,0,0,0,0,12,28,44,59,74,86,97,106,114,119,124,129,129,124,121,115,107,99,88,76,62,49,32,15,0,0,0,0,0,0,0,0,0,0,0,0,0,8,24,42,58,72,86,97,107,114,121,124,129,129,124,119,114,106,96,84,72,56,40,22,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,37,60,86,109,129,129,129,129,119,93,68,45,64,88,111,129,129,129,129,114,88,66,40,15,0,0,0,0,0,0,0,0,10,25,40,54,67,79,90,100,109,115,119,124,124,129,129,124,119,115,108,99,89,78,64,51,35,19,1,0,0,0,0,0,0,0,0,10,35,60,86,111,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,118,93,71,45,20,0,7,32,55,81,103,124,124,124,124,124,124,124,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,33,51,69,84,98,112,121,134,140,147,150,152,152,152,147,143,135,124,114,101,87,71,53,36,17,0,0,0,0,0,0,0,0,0,9,28,46,63,80,94,107,119,132,139,145,150,152,152,150,147,140,132,121,109,97,83,67,51,33,15,0,0,0,0,0,0,0,0,0,0,0,6,24,42,60,76,92,107,119,132,139,147,150,152,152,150,146,139,130,117,105,91,75,58,40,22,4,0,0,0,0,0,0,0,0,0,0,0,0,0,15,40,63,88,111,138,154,154,142,116,91,67,43,67,91,114,141,154,154,137,111,87,63,39,14,0,0,0,0,0,0,0,12,29,44,59,74,88,100,112,121,134,140,146,150,152,154,152,150,146,140,134,121,110,98,85,69,53,35,18,0,0,0,0,0,0,0,0,10,35,60,86,111,137,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,147,119,93,71,45,20,0,7,33,55,81,104,129,152,152,152,152,152,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,29,49,67,85,103,117,134,146,155,163,170,175,177,178,175,172,165,157,148,136,121,105,87,71,52,32,11,0,0,0,0,0,0,0,5,24,44,62,80,98,114,129,141,153,162,168,174,177,177,174,170,163,154,144,132,117,101,85,67,49,31,12,0,0,0,0,0,0,0,0,0,0,20,40,59,76,94,110,129,141,153,163,170,174,177,177,174,169,162,152,140,124,109,92,74,57,38,19,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,67,91,114,141,165,162,139,113,88,64,45,70,93,118,144,167,158,134,109,83,60,36,12,0,0,0,0,0,0,13,30,47,63,78,93,107,121,135,146,156,163,170,174,177,178,177,175,170,163,155,145,134,118,103,87,69,52,33,14,0,0,0,0,0,0,0,10,35,60,86,111,137,162,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,172,147,119,93,71,45,20,0,7,33,55,81,104,129,154,177,177,177,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,43,64,83,103,121,139,154,167,179,188,179,173,170,170,172,177,186,180,170,156,141,123,105,86,66,45,23,2,0,0,0,0,0,0,17,38,58,79,97,116,134,148,163,175,185,188,181,178,177,180,185,186,177,165,152,137,119,101,83,65,46,26,6,0,0,0,0,0,0,0,0,14,34,55,74,93,112,130,146,162,174,186,190,183,180,180,184,191,184,173,161,146,129,110,92,72,53,32,11,0,0,0,0,0,0,0,0,0,0,0,0,22,45,70,93,117,144,167,160,136,109,86,61,49,73,97,121,147,170,155,132,106,81,58,33,9,0,0,0,0,0,11,31,47,64,82,97,112,129,143,155,167,178,187,187,182,182,182,184,190,194,187,178,166,154,139,121,103,86,67,47,27,6,0,0,0,0,0,0,10,35,60,86,111,137,162,187,193,193,193,193,193,193,193,193,193,193,193,193,193,193,202,203,203,203,198,172,147,119,93,71,45,20,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,33,55,76,98,117,138,157,173,188,181,166,156,148,144,144,147,153,163,176,191,175,159,141,121,99,79,57,34,13,0,0,0,0,0,7,30,51,72,92,112,134,152,168,183,191,177,165,157,154,152,155,162,172,184,186,171,155,139,119,99,80,60,39,18,0,0,0,0,0,0,0,5,27,48,69,89,109,129,148,166,181,192,178,167,160,156,157,160,169,179,193,180,164,146,129,107,87,66,45,24,3,0,0,0,0,0,0,0,0,0,0,0,25,48,73,97,121,147,170,157,132,106,83,58,52,77,101,124,150,175,152,129,103,78,55,30,6,0,0,0,0,0,23,44,65,82,98,116,132,148,162,177,189,179,170,162,157,157,157,160,165,174,186,198,187,173,157,139,119,100,81,59,39,17,0,0,0,0,0,0,10,35,60,86,111,137,162,167,167,167,167,167,167,167,167,167,167,167,167,167,167,168,181,200,222,207,186,165,144,119,93,71,45,20,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,42,65,88,109,132,153,172,191,180,162,146,134,124,119,119,121,132,143,158,175,193,175,155,135,111,89,67,44,21,0,0,0,0,0,18,40,63,84,106,129,148,167,186,189,172,156,144,135,129,129,132,139,150,164,180,190,173,155,136,114,93,73,51,30,8,0,0,0,0,0,0,15,37,59,81,101,123,144,163,182,191,173,158,145,136,132,132,137,146,159,175,193,180,161,143,121,99,79,57,35,13,0,0,0,0,0,0,0,0,1,4,5,27,52,76,100,124,149,174,154,129,104,80,55,55,80,104,129,154,175,149,124,100,76,52,27,3,0,0,0,0,4,29,52,74,98,116,134,152,166,182,184,170,158,147,139,134,132,132,136,142,152,164,180,197,191,173,155,135,113,92,71,49,27,5,0,0,0,0,0,10,35,60,86,111,137,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,145,165,189,214,194,172,152,130,108,87,64,41,17,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,27,50,73,97,119,144,165,186,186,165,146,124,110,100,94,93,98,108,121,141,159,179,189,167,145,121,98,75,52,28,4,0,0,0,4,27,50,73,95,117,140,161,182,194,173,155,137,121,110,104,101,107,116,130,146,163,181,189,169,149,129,106,84,63,40,19,0,0,0,0,0,3,26,48,70,92,114,137,158,178,196,175,157,139,121,112,106,106,113,124,141,159,177,196,176,155,135,112,90,67,46,24,0,0,0,0,0,0,2,15,25,30,30,30,55,78,103,129,152,175,152,124,101,77,53,58,83,106,132,157,171,147,121,97,73,49,30,26,16,4,0,0,4,29,52,75,99,117,137,154,170,180,165,150,137,123,114,108,105,106,111,118,130,146,162,181,200,188,167,147,124,103,81,58,36,13,0,0,0,0,0,9,34,59,84,105,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,117,139,163,188,201,179,158,137,115,94,73,52,30,8,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,56,80,104,129,152,175,198,176,153,132,109,91,78,70,70,75,87,105,124,146,169,190,177,154,130,106,81,57,34,9,0,0,0,12,35,59,81,105,129,150,173,195,181,159,139,117,101,88,79,78,83,95,110,129,147,167,187,183,162,141,117,96,73,50,28,4,0,0,0,0,11,34,57,80,103,124,148,170,191,184,163,141,121,103,89,81,81,90,105,123,144,165,186,189,168,146,121,100,78,55,32,9,0,0,0,0,0,19,36,47,53,53,53,58,81,106,132,155,172,148,121,99,73,53,62,86,110,137,160,168,144,118,93,70,53,53,48,36,21,1,0,0,24,46,66,83,101,117,136,154,162,146,132,116,101,91,84,81,82,87,97,110,129,148,167,188,200,179,157,135,111,89,66,43,20,0,0,0,0,0,4,27,50,71,85,88,88,88,88,88,88,88,88,88,88,88,88,88,88,109,132,153,174,196,187,166,145,123,101,81,59,38,17,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,35,60,83,109,134,157,182,193,169,146,121,97,75,57,46,45,53,71,90,113,137,160,183,183,160,136,109,86,61,37,13,0,0,0,17,41,65,89,113,137,160,183,194,171,148,124,104,84,67,56,54,61,75,92,112,134,154,177,195,173,152,129,106,82,59,36,12,0,0,0,0,19,43,65,89,112,136,158,181,196,174,152,130,107,86,68,57,58,70,88,109,132,154,176,199,179,156,134,109,86,63,41,16,0,0,0,0,12,34,55,69,78,78,78,78,85,109,134,160,170,145,119,96,78,78,78,90,114,139,163,165,142,115,91,78,78,78,71,55,36,14,0,0,12,32,49,67,83,99,117,136,146,129,110,96,82,69,60,55,58,63,76,93,112,135,156,178,200,188,165,142,118,95,72,49,25,2,0,0,0,0,0,15,35,51,61,63,63,63,63,63,63,63,63,63,63,63,63,81,103,123,146,166,187,195,174,153,132,109,88,67,45,24,3,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,38,60,86,111,137,162,185,190,167,142,116,91,68,44,23,21,36,58,81,106,130,154,178,187,162,139,111,88,63,40,15,0,0,0,22,46,70,94,118,144,167,191,188,163,139,115,93,70,50,33,29,41,58,78,98,121,144,166,189,183,160,137,114,90,67,44,20,0,0,0,2,25,49,73,96,119,144,167,190,189,165,143,118,96,74,52,34,36,55,75,98,121,144,168,191,188,165,141,117,93,70,47,23,0,0,0,0,20,45,68,88,103,104,104,104,104,111,137,162,167,142,116,104,104,104,104,104,116,142,167,162,139,112,104,104,104,103,90,68,47,22,0,0,0,15,31,49,65,82,99,116,129,109,92,76,62,47,36,31,33,42,60,80,101,124,148,172,194,194,171,147,123,99,76,53,29,6,0,0,0,0,0,0,16,30,38,40,40,40,40,40,40,40,40,40,40,52,74,95,116,138,159,180,201,181,160,139,116,95,74,53,32,11,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,38,60,86,111,137,162,185,190,165,142,114,91,67,42,19,5,29,53,78,101,129,152,177,187,163,139,114,88,63,40,15,0,0,1,25,50,74,98,121,147,172,196,183,159,134,109,86,62,38,16,6,23,44,65,88,111,135,158,182,192,168,145,121,98,74,51,27,3,0,0,7,32,56,79,103,129,151,175,198,182,158,135,110,87,64,41,19,21,43,66,89,113,137,160,184,196,172,148,124,101,77,54,29,5,0,0,0,22,48,73,96,121,132,132,132,132,132,140,165,165,143,132,132,132,132,132,132,132,145,170,162,138,132,132,132,132,121,99,73,50,25,0,0,0,0,15,31,47,65,82,98,103,92,74,58,43,28,14,7,9,27,49,72,96,118,143,167,190,198,175,152,129])
.concat([101,78,55,30,7,0,0,0,0,0,0,0,7,13,15,15,15,15,15,15,15,15,24,45,66,87,108,130,152,172,194,189,167,146,124,103,82,61,40,18,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,36,60,85,109,135,160,183,192,167,144,119,95,73,53,35,21,31,55,78,103,129,152,177,184,160,137,111,86,63,38,14,0,0,2,27,50,76,99,124,152,175,199,180,157,132,106,81,57,33,9,0,11,33,57,80,103,129,152,175,199,176,152,129,104,80,57,33,9,0,0,12,36,61,84,109,134,157,181,200,176,152,129,104,80,57,33,9,12,35,59,82,106,132,155,179,202,179,155,132,106,82,58,34,10,0,0,0,22,48,73,96,121,149,157,157,157,157,160,175,175,161,157,157,157,157,157,157,157,162,179,173,159,157,157,157,149,121,99,73,50,25,0,0,0,0,0,13,31,47,64,77,80,73,58,40,24,9,0,0,0,22,45,68,93,116,142,165,188,200,175,152,129,104,78,55,32,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,37,58,79,100,121,144,165,186,196,174,154,132,110,89,68,47,26,5,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,33,57,81,106,130,154,177,197,174,151,129,107,87,69,55,42,39,62,84,108,132,156,180,178,155,132,106,83,59,35,11,0,0,2,27,50,76,101,124,152,175,200,180,157,132,104,81,55,32,7,0,2,26,50,73,98,121,146,170,194,182,158,134,109,85,61,37,13,0,0,17,41,65,89,113,139,162,186,196,172,147,121,99,75,51,27,3,5,29,53,77,101,124,150,174,198,184,160,137,111,86,63,39,14,0,0,0,22,48,73,96,121,149,172,180,180,180,182,194,187,182,180,180,180,180,180,180,180,184,197,186,181,180,180,175,149,121,99,73,50,25,0,0,0,0,0,0,13,29,45,53,55,50,39,22,6,0,0,0,0,22,46,69,93,116,142,165,189,198,175,152,129,101,78,55,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,30,51,72,93,114,137,158,179,200,182,161,140,117,97,76,55,33,12,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,28,52,76,99,121,146,168,189,183,163,143,121,103,89,76,64,54,73,93,116,140,163,186,169,146,121,99,77,53,29,5,0,0,2,27,50,76,99,124,152,175,200,180,157,132,106,81,58,34,9,0,3,20,45,68,93,116,142,167,190,187,162,139,114,89,65,41,17,0,0,20,44,69,93,116,142,167,190,192,168,144,119,94,70,46,22,0,0,24,48,72,96,121,147,170,194,188,164,140,114,91,66,42,17,0,0,0,22,48,73,96,121,149,157,157,157,157,170,184,165,157,157,157,157,157,157,157,158,171,181,163,157,157,157,157,149,121,99,73,50,25,0,0,0,0,0,0,0,10,22,28,30,26,17,5,0,0,0,0,6,28,51,73,96,119,144,167,191,194,170,147,121,99,76,53,29,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,22,43,64,86,107,129,150,171,192,189,169,147,124,105,83,62,41,20,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,67,90,112,135,155,175,194,176,157,141,123,109,97,86,75,86,106,129,150,172,177,156,136,112,90,67,45,22,0,0,0,2,25,50,74,98,121,149,172,197,183,160,135,110,86,62,40,20,17,24,37,54,72,92,114,139,165,187,191,167,142,116,92,68,44,20,0,0,22,47,72,96,119,147,170,194,190,165,142,114,91,66,43,18,0,0,20,45,69,93,116,144,167,192,192,167,144,117,93,70,45,20,0,0,0,22,48,73,96,121,132,132,132,132,134,157,173,150,132,132,132,132,132,132,132,136,160,170,147,132,132,132,132,132,121,99,73,50,25,0,0,0,0,0,0,0,0,0,3,5,2,0,0,0,0,0,0,16,38,59,81,104,129,150,173,196,188,164,142,117,95,72,49,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,36,57,78,99,119,143,164,185,197,176,155,134,112,90,70,48,28,6,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,36,57,79,100,121,141,159,177,193,175,158,144,132,118,108,98,101,119,141,162,180,162,143,121,100,79,57,35,13,0,0,0,0,22,47,72,96,119,144,168,192,188,164,140,116,94,72,54,43,40,46,57,72,89,107,129,147,169,190,193,170,144,119,93,71,45,22,0,1,25,49,73,98,121,149,172,197,187,163,139,113,88,64,40,15,0,0,17,43,66,91,114,142,165,190,195,170,147,119,96,71,47,22,0,0,0,20,45,68,88,103,104,104,104,108,134,157,170,147,121,104,104,104,104,104,111,137,160,167,144,118,104,104,104,104,103,90,68,47,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,28,49,70,91,113,136,157,180,200,179,156,135,111,88,65,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,28,50,71,92,113,136,156,177,198,183,163,141,119,98,77,56,35,14,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,24,46,67,86,105,123,143,160,175,191,179,165,153,141,132,121,117,137,155,175,162,144,129,107,87,67,46,24,3,0,0,0,0,19,43,67,91,114,139,162,186,195,172,149,129,107,88,75,67,66,70,79,92,107,123,143,161,181,201,195,172,147,121,96,71,48,22,0,2,27,50,76,99,124,150,175,198,186,162,137,111,86,63,38,14,0,0,15,40,64,88,114,139,165,188,197,172,148,121,97,73,48,25,0,0,0,13,34,55,72,80,81,81,86,111,137,160,167,144,118,93,81,81,81,88,114,139,163,165,142,115,91,81,81,81,80,73,56,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,22,41,62,82,103,123,146,167,189,190,169,147,124,102,80,58,36,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,42,63,84,105,129,148,170,191,191,170,148,129,105,84,64,43,21,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,32,52,71,89,107,123,141,156,171,192,187,174,164,154,145,139,154,171,160,144,129,109,91,72,53,33,13,0,0,0,0,0,14,37,61,84,108,132,154,177,198,182,162,141,123,108,98,91,90,93,101,112,124,143,159,177,189,204,198,172,147,121,96,73,48,22,0,2,27,50,76,101,124,152,175,200,185,162,137,109,86,60,38,12,0,0,15,40,63,88,111,139,163,187,198,174,149,121,99,73,50,25,0,0,0,0,20,36,49,55,55,66,90,114,139,163,165,141,114,91,67,55,68,92,116,142,166,162,139,111,88,64,55,55,55,50,38,22,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,36,56,75,95,115,137,157,178,199,179,158,137,114,92,71,49,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,14,35,56,77,98,118,141,163,184,198,177,156,136,113,92,71,50,28,7,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,19,37,55,73,89,105,121,138,160,185,185,190,186,177,168,162,171,167,144,124,109,92,74,56,39,22,4,0,0,0,0,0,7,30,53,76,98,121,144,165,185,196,175,159,143,132,121,116,114,116,124,135,147,161,158,155,170,190,198,172,149,121,96,73,48,22,0,4,28,53,76,101,124,152,177,200,185,160,137,109,86,60,35,12,0,0,15,38,63,87,111,139,162,187,198,175,149,121,99,73,50,25,0,0,0,11,24,34,38,38,44,68,93,116,142,167,162,137,111,88,64,47,71,96,119,144,170,160,135,109,86,61,38,37,33,26,16,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,33,51,70,89,109,129,149,170,189,187,166,146,124,103,82,61,39,17,0,0,0,0,0,0,0,0,0,0,0,0,0,6,27,48,69,90,112,134,155,176,197,185,164,143,121,99,79,57,36,15,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,37,55,71,87,103,116,130,143,162,166,162,168,177,187,191,188,192,169,146,132,118,105,90,74,56,40,21,2,0,0,0,0,0,21,44,66,88,109,132,152,170,188,193,177,164,153,146,142,142,142,148,157,169,159,141,135,160,183,198,172,147,121,96,73,48,22,0,5,30,53,78,101,129,152,177,202,185,160,137,109,86,60,35,12,0,0,13,38,63,86,111,139,162,187,198,175,149,121,99,73,50,25,0,0,9,29,45,58,63,63,63,72,96,119,146,170,160,134,109,85,63,63,74,98,121,147,172,155,132,106,82,63,63,63,56,42,25,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,30,48,67,85,104,123,143,163,182,194,174,154,134,112,91,71,49,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,20,41,62,83,104,124,147,168,189,192,171,150,129,107,86,64,44,23,1,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,34,53,71,89,105,121,137,152,163,162,146,137,145,154,163,173,183,195,182,166,154,140,124,109,92,74,56,36,17,0,0,0,0,0,11,33,55,76,96,116,136,154,167,181,191,186,176,170,167,165,167,172,171,157,141,123,135,160,185,195,171,147,121,96,71,48,22,0,4,27,53,76,101,124,152,177,200,185,162,137,109,86,60,36,12,0,0,15,38,63,88,111,139,162,187,198,175,149,121,99,73,50,25,0,0,20,42,63,79,88,88,88,88,99,121,149,172,155,132,106,88,88,88,88,101,124,152,175,152,129,103,88,88,88,88,78,59,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,28,46,64,83,100,119,139,158,177,196,179,160,140,119,99,79,59,38,17,0,0,0,0,0,0,0,0,0,0,0,0,0,12,33,55,76,97,117,140,161,182,200,179,158,137,114,93,72,51,30,9,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,28,48,69,87,105,123,141,157,171,162,144,129,112,121,132,141,152,162,173,187,187,174,159,144,129,109,91,71,50,30,8,0,0,0,0,0,21,42,62,82,99,117,134,148,160,168,175,180,182,182,178,172,162,150,137,121,111,137,162,185,193,169,144,119,93,71,45,22,0,2,27,50,76,101,124,152,175,200,185,162,137,111,86,60,38,12,0,0,15,40,63,88,112,139,165,187,198,172,149,121,99,73,50,25,0,1,26,51,73,97,111,111,111,111,111,124,152,175,152,129,111,111,111,111,111,111,130,154,175,149,124,111,111,111,111,110,92,69,46,21,0,0,0,0,0,0,0,0,0,0,0,0,0,10,27,45,62,80,98,116,136,154,173,192,184,165,146,124,106,86,66,46,26,5,0,0,0,0,0,0,0,0,0,0,0,0,5,26,47,68,89,110,132,154,174,196,186,165,144,121,100,79,58,38,17,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,40,62,82,103,121,143,161,177,165,146,129,109,92,98,108,117,129,140,153,166,181,194,179,162,144,124,105,84,63,41,19,0,0,0,0,0,8,28,47,65,83,98,112,124,137,145,152,155,157,157,154,148,140,130,116,101,114,139,164,187,191,167,142,116,92,68,43,20,0,2,25,50,75,99,124,149,173,198,187,162,137,111,88,63,39,15,0,0,17,40,65,89,114,139,165,189,195,172,147,121,96,73,48,23,0,2,27,53,76,101,124,139,139,139,139,139,157,179,155,139,139,139,139,139,139,139,140,160,176,153,139,139,139,139,139,121,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,10,26,44,62,79,96,114,134,152,170,188,187,168,150,132,110,92,72,52,33,13,0,0,0,0,0,0,0,0,0,0,0,0,0,19,40,61,82,103,123,146,167,188,194,172,152,130,108,87,66,45,24,2,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,29,51,73,95,116,137,158,177,173,152,132,110,91,73,75,85,95,106,117,132,146,162,180,197,179,161,139,117,96,73,51,29,6,0,0,0,0,0,12,31,47,64,79,91,103,113,119,124,132,134,134,130,123,116,106,95,93,116,142,167,190,188,163,139,114,90,66,41,17,0,0,24,48,73,96,121,147,172,196,188,165,139,114,89,65,40,17,0,0,19,43,67,91,116,142,167,190,193,170,145,119,94,71,45,22,0,2,27,53,76,101,124,152,165,165,165,165,174,190,172,165,165,165,165,165,165,165,165,175,188,171,165,165,165,165,147,121,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,10,26,44,60,78,96,112,132,150,168,186,190,171,154,136,114,96,77,58,38,19,0,0,0,0,0,0,0,0,0,0,0,0,0,11,32,53,74,95,116,139,160,181,201,180,159,138,116,95,74,52,31,10,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,37,61,83,106,129,150,172,186,163,140,117,96,76,56,53,63,73,84,98,110,129,145,164,184,194,173,152,130,106,83,61,37,14,0,0,0,0,0,0,13,29,45,58,70,81,90,97,101,106,106,106,106,101,93,84,73,98,121,147,170,194,183,160,136,109,86,62,37,13,0,0,22,46,71,93,119,144,168,193,190,167,142,116,92,68,44,20,0,0,22,46,70,94,119,144,168,193,190,166,142,116,92,68,44,20,0,2,27,53,76,101,124,152,175,175,175,177,190,188,176,175,175,175,175,175,175,175,179,191,185,176,175,175,175,172,147,121,96,71,48,22,0,0,0,0,0,0,0,0,0,0,10,28,44,60,78,95,112,132,148,166,184,191,174,155,137,117,99,81,62,43,24,5,0,0,0,0,0,0,0,0,0,0,0,0,3,24,46,67,88,109,132,152,173,194,188,167,146,123,101,81,59,38,17,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,44,68,91,115,139,162,183,179,155,132,107,85,62,42,31,40,51,64,77,92,109,130,150,173,195,184,162,139,114,91,67,43,19,0,0,0,0,0,0,0,10,24,37,48,58,66,73,78,81,83,83,81,77,69,62,80,103,129,152,176,199,178,154,132,106,81,58,33,9,0,0,19,43,68,91,116,142,165,189,193,170,144,119,96,72,48,24,0,1,26,50,73,98,121,147,172,195,187,162,139,114,88,65,40,17,0,2,27,53,76,101,124,149,149,149,149,154,173,171,153,149,149,149,149,149,149,149,157,175,167,152,149,149,149,149,147,121,96,71,48,22,0,0,0,0,0,0,0,0,0,12,28,44,62,78,95,112,130,148,166,182,193,175,158,139,121,103,83,65,47,28,10,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,59,81,101,123,145,166,187,195,174,153,132,109,88,67,46,25,4,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,73,96,121,147,170,193,175,151,124,101,78,53,30,8,17,29,43,57,74,95,116,141,165,188,193,169,145,119,96,72,48,23,0,0,0,0,0,0,0,6,18,28,32,35,42,49,53,56,58,58,55,52,46,64,87,110,135,158,181,196,172,147,123,100,76,53,28,5,0,0,15,39,64,87,111,137,160,184,197,173,149,124,101,76,53,28,5,7,31,55,78,102,129,152,175,199,182,157,134,109,85,61,37,13,0,2,27,52,75,101,121,121,121,121,121,142,167,163,139,121,121,121,121,121,121,121,147,170,160,135,121,121,121,121,121,117,96,70,47,22,0,0,0,0,0,0,0,0,12,28,46,62,78,96,112,132,148,165,182,194,177,159,141,121,105,87,69,50,32,13,0,0,0,0,0,0,0,0,0,0,0,0,0,10,31,52,73,94,115,137,158,179,201,181,161,139,117,96,75,54,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,150,174,198,175,149,121,99,73,50,25,1,0,9,23,41,62,86,110,137,160,185,198,173,149,121,99,73,50,25,0,0,0,0,0,0,4,22,39,50,55,53,43,29,29,32,33,33,32,30,51,73,95,118,143,165,189,188,164,141,116,93,70,46,22,0,0,0,10,34,59,83,106,132,155,178,202,178,155,132,106,82,59,36,12,14,37,61,84,108,134,156,180,200,176,152,129,104,80,57,32,8,0,0,23,47,67,87,96,96,96,96,118,144,168,160,137,111,96,96,96,96,98,121,147,172,157,132,106,96,96,96,96,95,83,63,42,18,0,0,0,0,0,0,0,12,30,46,62,80,96,112,132,148,166,182,195,177,161,143,123,105,88,71,53,34,17,17,17,17,17,17,14,6,0,0,0,0,0,0,2,23,44,65,87,107,130,150,172,193,189,168,147,124,104,82,61,40,19,15,15,15,15,15,15,15,15,15,15,11,2,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,25,15,15,15,15,15,15,15,15,15,15,15,15,11,3,0,0,0,0,0,0,2,27,50,76,99,124,152,175,198,175,151,124,101,76,52,29,10,0,0,12,37,60,86,109,136,160,185,198,175,149,121,99,73,50,25,0,0,0,0,0,3,21,40,56,73,81,77,64,46,31,20,15,18,28,44,64,84,106,129,152,174,197,180,156,134,109,86,63,40,16,0,0,0,5,29,53,77,101,124,148,172,196,184,160,137,113,90,67,44,22,24,46,69,92,115,139,162,186,193,170,146,121,98,74,51,27,3,0,0,13,34,51,65,71,71,73,97,121,147,171,157,134,107,83,71,71,77,101,124,152,175,154,129,104,80,71,71,71,70,63,47,30,8,0,0,0,0,0,0,13,30,47,64,80,96,114,132,149,166,182,196,179,161,143,124,107,89,72,55,43,43,43,43,43,43,43,43,38,27,13,0,0,0,0,0,15,37,58,79,100,121,144,165,186,196,175,154,134,110,90,69,48,40,40,40,40,40,40,40,40,40,40,40,40,35,24,8,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,50,40,40,40,40,40,40,40,40,40,40,40,40,40,35,25,11,0,0,0,0,0,2,25,50,75,99,124,149,173,197,178,154,132,106,83,62,44,31,25,24,30,45,65,90,113,137,162,185,196,172,149,121,99,73,50,25,0,0,0,0,1,19,37,56,74,92,106,98,81,65,52,44,40,42,50,63,79,98,117,140,162,183,191,170,147,123,101,78,55,32,8,0,0,0,0,23,47,70,93,116,141,164,187,192,168,145,121,98,76,56,37,38,58,79,100,123,147,170,193,185,162,139,115,92,68,45,20,0,0,0,0,17,31,43,48,52,76,101,124,149,175,154,130,104,81,56,55,80,104,129,154,175,151,124,101,76,53,48,48,47,41,28,13,0,0,0,0,0,0,15,31,47,64,82,98,114,134,150,166,184,197,179,161,144,124,107,91,73,68,68,68,68,68,68,68,68,68,68,61,47,30,10,0,0,0,8,29,50,72,92,114,136,157,178,199,183,162,141,118,98,76,66,66,66,66,66,66,66,66,66,66,66,66,66,65,58,44,25,5,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,73,66,66,66,66,66,66,66,66,66,66,66,66,66,65,58,45,27,8,0,0,0,0,0,23,47,72,96,119,144,168,191,184,161,139,116,96,78,64,54,48,48,53,63,78,99,119,144,168,191,191,167,144,119,94,71,47,22,0,0,0,0,17,35,53,72,91,109,129,116,99,86,74,68,64,67,73,83,97,114,134,153,174,195,180,158,137,114,91,69,47,24,0,0,0,0,0,16,40,62,85,109,132,155,178,199,177,155,134,110,90,71,60,61,73,92,112,135,156,179,197,175,153,132,106,83,60,37,14,0,0,0,0,0,11,19,30,55,78,103,129,152,175,152,124,101,78,53,58,83,106,132,157,172,147,121,98,73,50,25,22,22,18,8,0,0,0,0,0,0,15,33,49,65,82,99,116,134,150,168,184,198,179,162,144,124,109,91,91,91,91,91,91,91,91,91,91,91,91,91,81,64,42,21,0,0,0,21,43,64,86,107,129,150,171,192,190,169,148,129,105,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,80,61,39,16,0,7,33,55,81,104,129,154,177,203,195,172,147,121,96,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,80,62,41,19,0,0,0,0,0,19,42,66,90,113,137,160,181,194,172,152,132,112,98,86,77,73,73,76,84,97,114,134,154,177,198,181,158,137,112,89,65,42,18,0,0,0,14,33,51,69,88,107,124,144,136,119,107,98,91,88,91,96,105,116,134,150,168,187,188,167,147,124,103,81,59,37,14,0,0,0,0,0,8,32,54,77,99,121,145,167,188,187,166,145,123,105,91,84,85,92,107,124,147,167,189,186,165,143,119,98,75,52,29,6,0,0,0,0,0,0,9,34,58,81,106,132,155,172,149,121,99,75,50,61,86,109,135,160,170,144,119,96,71,47,22,0,0,0,0,0,0,0,0,0,11,31,49,67,83,99,116,136,152,168,184,202,187,165,144,129,109,111,114,116,116,116,116,116,116,116,116,116,116,116,115,97,75,50,27,0,0,14,36,57,78,99,119,143,163,184,205,183,158,135,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,113,96,72,47,22,0,7,33,55,81,104,129,154,177,203,195,172,147,121,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,113,96,72,49,24,0,0,0,0,0,12,36,59,81,104,129,148,169,189,185,166,150,134,118,108,101,98,96,100,107,117,132,150,168,188,189,169,148,124,103,81,58,35,12,0,0,4,28,48,67,86,105,123,143,161,155,141,132,121,116,114,114,119,129,139,152,168,184,191,173,154,134,112,90,70,48,27,5,0,0,0,0,0,0,23,45,66,89,110,134,154,174,194,179,160,141,124,114,109,109,115,129,144,162,181,193,173,153,132,108,87,65,42,21,0,0,0,0,0,0,0,12,37,61,85,109,134,160,170,146,119,96,72,47,64,88,112,138,162,167,142,116,93,68,44,20,0,0,0,0,0,0,0,0,0,20,43,64,83,101,117,136,152,170,186,202,208,185,163,139,134,137,139,139,142,144,144,144,144,144,144,144,144,144,144,121,99,76,50,27,0,0,24,48,70,91,112,135,155,177,198,209,184,161,143,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,121,99,73,48,22,0,7,33,55,81,104,129,154,177,203,197,175,154,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,121,99,73,50,25,0,0,0,0,0,4,27,49,71,92,114,135,154,172,189,184,167,154,141,132,124,121,121,124,132,140,153,168,184,190,173,155,135,114,92,71,49,26,3,0,0,11,34,58,82,103,121,141,159,177,175,163,153,146,142,139,142,144,152,161,172,186,191,175,157,139,117,98,79,57,36,15,0,0,0,0,0,0,0,12,34,56,78,98,119,141,160,179,195,177,161,148,139,134,134,139,149,162,179,195,177,158,139,117,97,76,54,32,10,0,0,0,0,0,0,0,15,40,64,88,111,137,162,167,142,116,93,68,44,67,91,115,141,165,163,139,114,90,65,41,17,0,0,0,0,0,0,0,0,0,25,48,71,96,118,137,154,170,186,204,220,214,194,173,161,160,162,162,165,167,167,170,170,170,170,170,170,170,170,149,121,99,76,50,27,0,2,27,53,76,101,124,148,170,191,212,217,196,177,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,149,121,99,73,48,22,0,7,33,55,81,104,129,154,177,203,206,188,173,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,149,121,99,73,50,25,0,0,0,0,0,0,16,38,59,80,99,117,137,155,170,183,187,174,164,155,150,147,147,149,155,163,173,186,184,171,155,139,119,99,80,58,38,15,0,0,0,12,35,60,86,109,130,146,162,176,189,185,176,169,165,165,165,168,174,183,194,186,172,157,141,121,103,84,64,45,24,3,0,0,0,0,0,0,0,2,23,44,65,86,105,124,144,162,178,192,180,170,162,160,160,163,171,182,191,177,161,143,123,103,83,63,42,21,0,0,0,0,0,0,0,0,18,43,67,91,115,141,165,163,139,114,90,66,45,70,93,119,144,168,160,137,110,86,63,38,14,0,0,0,0,0,0,0,0,0,25,48,71,96,119,144,170,188,200,200,200,200,200,195,186,185,185,187,190,191,193,193,193,193,193,193,193,193,172,149,121,99,76,50,27,0,2,27,53,76,101,129,154,180,200,200,200,200,199,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,175,149,121,99,73,48,22,0,7,33,55,81,104,129,154,177,200,200,200,196,193,193,193,193,193,193,193,193,193,193,193,193,193,193,172,149,121,99,73,50,25,0,0,0,0,0,0,5,26,45,65,83,101,117,136,149,162,172,181,187,180,175,172,172,175,178,185,182,173,163,150,137,119,103,85,65,45,25,4,0,0,0,8,33,55,76,94,110,129,143,155,167,178,187,193,190,190,190,193,191,184,175,164,152,137,121,103,87,69,50,30,10,0,0,0,0,0,0,0,0,0,10,31,52,71,90,109,124,144,158,172,182,190,186,183,184,187,189,181,170,157,143,124,107,89,69,50,29,8,0,0,0,0,0,0,0,0,21,45,70,93,118,144,167,160,137,111,86,63,49,73,96,121,147,171,157,134,107,83,59,35,11,0,0,0,0,0,0,0,0,0,25,48,71,96,119,144,170,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,172,149,121,99,76,50,27,0,2,27,53,76,101,129,154,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,149,121,99,73,48,22,0,7,33,55,81,104,129,154,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,172,149,121,99,73,50,25,0,0,0,0,0,0,0,11,30,49,67,83,99,114,129,139,149,158,164,169,172,175,175,172,170,165,158,150,140,130,116,101,85,67,49,31,12,0,0,0,0,0,21,42,60,76,92,107,119,135,146,155,163,168,172,175,173,171,167,160,152,143,132,116,101,85,69,51,33,15,0,0,0,0,0,0,0,0,0,0,0,17,36,56,73,91,107,123,138,149,160,167,171,173,173,170,166,159,149,137,121,107,89,72,54,35,15,0,0,0,0,0,0,0,0,0,24,48,73,96,121,147,149,149,134,108,83,60,52,76,99,124,149,149,149,132,104,81,56,32,8,0,0,0,0,0,0,0,0,0,25,48,71,96,119,144,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,76,50,27,0,2,27,53,76,101,129,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,73,48,22,0,7,33,55,81,104,129,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,73,50,25,0,0,0,0,0,0,0,0,15,33,49,65,80,93,106,116,124,135,141,145,148,149,149,149,146,142,136,129,117,107,95,82,67,51,33,15,0,0,0,0,0,0,7,24,42,58,72,87,100,112,121,134,139,144,149,149,149,147,144,137,129,119,108,96,82,67,51,35,17,0,0,0,0,0,0,0,0,0,0,0,0,2,21,38,56,73,89,103,116,129,137,144,147,149,149,147,143,136,124,115,101,87,72,55,37,19,0,0,0,0,0,0,0,0,0,2,25,50,73,98,121,121,121,121,121,104,80,57,53,75,101,121,121,121,121,121,101,78,53,29,5,0,0,0,0,0,0,0,0,0,25,48,70,96,117,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,75,50,27,0,2,27,53,75,101,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,48,22,0,7,32,55,80,103,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,50,25,0,0,0,0,0,0,0,0,0,15,31,45,60,72,83,94,103,109,115,119,121,121,121,121,119,116,110,103,95,84,74,62,47,32,15,0,0,0,0,0,0,0,0,7,23,38,52,66,79,90,99,108,114,119,121,121,121,121,116,112,105,96,86,75,62,48,33,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,38,55,69,82,93,104,112,117,121,121,121,121,116,111,103,92,81,68,53,37,21,3,0,0,0,0,0,0,0,0,0,0,21,45,66,87,98,99,99,99,99,90,73,50,48,69,89,99,99,99,99,99,89,71,48,24,1,0,0,0,0,0,0,0,0,0,21,43,64,85,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,69,45,24,0,0,24,48,69,89,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,43,19,0,4,28,50,73,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,45,21,0,0,0,0,0,0,0,0,0,0,12,26,39,50,62,71,79,86,91,95,97,99,99,97,95,91,86,80,72,63,51,40,27,13,0,0,0,0,0,0,0,0,0,0,4,19,32,45,57,67,77,85,91,94,96,99,99,96,93,88,81,73,64,53,41,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,20,35,48,61,71,81,88,93,96,99,99,96,93,87,80,71,59,47,33,18,3,0,0,0,0,0,0,0,0,0,0,0,12,33,51,66,73,73,73,73,73,68,56,38,36,53,67,73,73,73,73,73,67,55,36,14,0,0,0,0,0,0,0,0,0,0,12,31,49,65,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,53,33,14,0,0,14,36,53,67,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,31,9,0,0,18,38,56,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,33,12,0,0,0,0,0,0,0,0,0,0,0,5,18,29,39,49,56,62,67,71,73,73,73,73,71,68,63,57,49,40,30,19,7,0,0,0,0,0,0,0,0,0,0,0,0,0,11,24,36,45,54,61,67,71,73,73,73,73,70,65,58,51,42,31,20,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,28,39,49,57,65,70,73,73,73,73,69,64,57,48,38,26,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,31,43,48,48,48,48,48,45,35,20,19,33,44,48,48,48,48,48,44,34,19,0,0,0,0,0,0,0,0,0,0,0,0,15,30,42,47,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,33,17,0,0,0,0,19,33,44,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,31,15,0,0,0,4,20,35,45,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,31,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,16,25,32,38,43,46,48,48,48,48,47,43,39,33,26,17,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,13,22,31,37,42,46,48,48,48,48,45,41,35,28,19,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,16,26,34,41,45,48,48,48,48,45,40,33,26,16,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,22,22,22,22,22,20,13,0,0,11,19,22,22,22,22,22,19,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,18,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,19,11,0,0,0,0,0,0,11,19,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,19,9,0,0,0,0,0,0,13,20,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,19,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,8,14,19,22,24,25,25,24,22,19,14,9,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,13,18,22,24,25,25,22,20,16,11,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,11,16,21,23,25,25,22,20,16,10,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,25,23,16,5,0,0,0,0,0,0,0,0,0,4,15,23,25,25,25,25,25,25,25,25,20,12,0,0,0,0,0,0,4,16,23,25,25,25,25,25,25,25,25,22,15,2,0,0,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,25,22,14,1,0,0,0,0,0,0,13,22,25,25,25,25,25,25,25,24,19,8,0,0,0,0,0,0,1,14,22,25,25,25,25,25,25,24,18,7,0,0,0,0,0,0,4,16,23,25,25,25,25,25,25,25,21,12,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,25,23,15,4,0,0,0,0,0,0,0,0,0,0,0,1,14,22,25,25,25,25,25,25,25,25,20,12,0,0,0,0,0,0,12,21,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,20,11,0,0,0,0,0,0,0,0,0,1,13,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,23,15,2,0,0,0,0,0,0,0,0,17,33,44,50,50,50,50,50,50,50,50,48,39,26,8,0,0,0,0,0,0,0,6,24,38,48,50,50,50,50,50,50,50,50,43,32,15,0,0,0,0,6,22,38,48,50,50,50,50,50,50,50,50,47,36,22,4,0,0,0,0,0,2,19,35,45,50,50,50,50,50,50,50,50,46,36,21,2,0,0,0,0,19,34,45,50,50,50,50,50,50,50,49,41,29,11,0,0,0,0,2,21,36,47,50,50,50,50,50,50,49,40,26,8,0,0,0,0,6,24,38,48,50,50,50,50,50,50,50,44,32,15,0,0,0,2,19,35,45,50,50,50,50,50,50,50,50,48,38,24,6,0,0,0,0,0,0,0,0,0,2,21,35,46,50,50,50,50,50,50,50,50,44,33,17,0,0,0,0,17,33,45,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,44,32,15,0,0,0,0,0,0,0,0,19,35,46,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,47,36,22,4,0,0,0,0,0,0,14,33,53,66,73,73,73,73,73,73,73,73,70,59,42,23,2,0,0,0,0,0,0,21,42,58,70,73,73,73,73,73,73,73,73,65,51,31,12,0,0,0,21,40,58,70,73,73,73,73,73,73,73,73,69,56,40,19,0,0,0,0,0,15,36,55,67,73,73,73,73,73,73,73,73,68,55,38,16,0,0,0,14,36,55,68,73,73,73,73,73,73,73,72,62,46,27,5,0,0,0,16,38,56,69,73,73,73,73,73,73,72,61,44,23,2,0,0,0,18,40,58,70,73,73,73,73,73,73,73,66,51,31,9,0,0,14,33,53,66,73,73,73,73,73,73,73,73,70,58,42,21,0,0,0,0,0,0,0,0,0,17,38,55,68,73,73,73,73,73,73,73,73,66,51,33,12,0,0,12,33,53,67,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,31,9,0,0,0,0,0,0,14,36,53,69,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,71,56,38,16,0,0,0,0,0,0,24,45,69,87,98,99,99,99,99,99,99,99,93,77,56,34,12,0,0,0,0,0,10,32,54,75,92,99,99,99,99,99,99,99,98,85,66,43,21,0,0,6,31,52,75,93,99,99,99,99,99,99,99,99,92,74,52,30,8,0,0,0,4,27,48,71,89,99,99,99,99,99,99,99,99,90,71,50,26,4,0,0,24,48,71,90,99,99,99,99,99,99,99,97,82,61,38,14,0,0,2,26,50,73,92,99,99,99,99,99,99,96,79,57,34,11,0,0,5,28,52,75,93,99,99,99,99,99,99,98,87,66,43,19,0,0,24,45,69,87,98,99,99,99,99,99,99,99,92,75,54,32,8,0,0,0,0,0,0,0,4,28,50,72,90,99,99,99,99,99,99,99,98,87,66,45,21,0,0,21,45,69,89,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,43,19,0,0,0,0,0,0,24,48,69,89,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,92,73,50,26,1,0,0,0,0,2,27,50,76,98,123,124,124,124,124,124,124,124,110,88,66,44,21,0,0,0,0,0,20,42,64,86,108,124,124,124,124,124,124,124,121,96,73,48,25,0,0,10,35,60,83,109,124,124,124,124,124,124,124,124,107,86,63,41,20,0,0,0,15,38,59,81,104,124,124,124,124,124,124,124,124,103,78,55,30,7,0,2,27,53,78,103,124,124,124,124,124,124,124,116,93,68,43,18,0,0,8,32,57,81,106,124,124,124,124,124,124,114,90,65,41,16,0,0,10,34,60,84,109,124,124,124,124,124,124,121,98,73,48,22,0,2,27,50,76,98,123,124,124,124,124,124,124,124,108,85,62,38,16,0,0,0,0,0,0,0,11,34,57,81,104,124,124,124,124,124,124,124,121,98,73,50,25,0,0,25,50,76,101,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,121,98,73,48,22,0,0,0,0,0,2,27,53,78,101,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,106,81,55,30,5,0,0,0,0,1,25,48,71,93,115,138,152,152,152,152,152,144,119,98,75,53,31,9,0,0,0,8,30,52,74,96,118,141,152,152,152,152,152,136,113,91,69,45,22,0,0,8,32,56,79,100,121,144,152,152,152,152,152,141,118,96,74,53,30,9,0,4,25,48,70,92,114,137,152,152,152,152,152,140,117,96,74,52,28,5,0,0,25,49,73,98,121,148,152,152,152,152,147,121,97,72,47,22,0,0,14,38,62,87,111,137,152,152,152,152,145,119,96,71,46,22,0,0,14,39,64,88,114,139,152,152,152,152,146,119,96,70,46,21,0,1,25,49,72,95,118,142,152,152,152,152,152,139,114,92,69,45,22,0,0,0,0,0,0,0,17,41,64,87,110,135,152,152,152,152,152,141,116,93])
.concat([71,48,24,0,0,25,50,76,101,129,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,149,121,99,73,48,22,0,0,0,0,0,4,29,53,78,104,129,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,132,106,81,55,30,5,0,0,0,0,0,17,39,61,82,104,129,149,171,177,177,175,153,132,107,85,63,41,19,0,0,0,17,39,62,84,106,129,152,173,177,177,168,146,123,101,80,58,37,15,0,0,1,23,45,66,88,109,132,154,174,177,177,174,152,130,107,86,64,41,20,0,15,37,58,81,103,124,148,170,177,177,171,150,129,106,84,63,41,20,0,0,0,19,44,68,93,117,144,168,177,177,176,152,124,101,76,52,27,2,0,20,44,69,93,116,143,167,177,177,175,152,124,101,77,53,28,4,0,18,43,68,93,116,144,167,177,177,165,142,115,91,66,41,17,0,0,19,42,65,88,111,135,158,177,177,177,169,146,121,98,75,52,28,6,0,0,0,0,0,1,24,48,70,93,116,142,164,177,177,177,156,134,109,86,64,41,17,0,0,25,50,76,101,129,152,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,175,149,121,99,73,48,22,0,0,0,0,0,5,30,55,81,104,132,157,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,157,132,106,81,55,30,5,0,0,0,0,0,6,28,50,72,93,115,138,160,182,203,185,163,140,117,95,73,51,29,6,0,5,27,49,71,93,116,139,161,183,200,179,157,136,113,91,69,47,25,4,0,0,0,12,33,55,76,98,118,141,163,184,203,186,163,141,118,97,75,53,31,9,25,47,70,91,113,137,158,181,203,181,160,138,115,94,73,51,30,8,0,0,0,14,39,64,88,113,139,163,188,203,180,156,132,106,80,56,31,6,1,25,50,74,98,123,149,173,197,203,181,157,134,107,83,58,34,9,0,22,47,72,97,121,147,172,196,185,161,137,111,86,61,37,12,0,0,12,34,57,81,103,129,151,173,196,199,176,152,129,105,82,59,35,12,0,0,0,0,0,8,31,54,77,101,124,148,171,194,196,172,149,124,102,79,56,33,10,0,0,25,50,76,101,129,152,177,193,193,193,193,193,193,193,193,193,202,203,203,203,200,193,193,193,193,193,193,193,193,193,175,149,121,99,73,48,22,0,0,0,0,0,7,32,57,81,106,134,157,182,200,200,194,193,193,193,193,193,193,193,193,193,193,193,182,157,132,106,81,55,30,5,0,0,0,0,0,0,17,39,61,83,105,129,149,171,192,195,172,150,129,105,82,61,38,16,0,15,37,59,81,103,124,149,171,193,190,169,147,123,101,80,58,37,15,0,0,0,0,0,21,42,64,86,107,130,150,172,194,196,174,153,132,107,86,64,42,20,36,58,80,101,124,147,169,191,191,169,148,124,104,82,61,39,18,0,0,0,0,10,34,59,83,109,134,159,183,208,185,160,137,109,85,60,35,10,7,31,56,80,105,130,155,179,203,212,188,163,139,113,88,64,40,16,2,27,52,76,101,124,152,176,201,181,157,132,106,81,57,32,7,0,0,4,27,50,73,96,119,144,166,189,205,182,160,137,111,89,65,42,19,0,0,0,0,0,14,37,61,84,107,132,155,178,201,188,165,142,117,95,72,49,26,3,0,0,25,50,76,101,129,152,167,167,167,167,167,167,167,167,167,168,181,198,217,197,179,168,167,167,167,167,167,167,167,167,167,149,121,99,73,48,22,0,0,0,0,0,7,33,58,83,109,134,160,185,204,184,170,167,167,167,167,167,167,167,167,167,167,167,167,157,132,106,81,55,30,5,0,0,0,0,0,0,7,29,50,72,93,115,139,161,182,204,182,160,138,114,92,70,48,26,4,24,47,69,91,113,137,158,180,201,179,157,136,113,91,70,48,25,4,0,0,0,0,0,9,31,52,73,95,116,139,160,181,203,186,164,141,118,97,74,53,31,47,69,91,113,136,158,180,200,179,157,136,113,91,71,49,28,6,0,0,0,0,5,29,54,78,103,129,154,178,203,189,165,139,114,89,64,40,15,13,37,62,86,110,137,160,184,209,217,193,168,144,119,94,70,46,21,6,31,56,80,106,132,156,180,201,176,152,129,101,77,52,27,3,0,0,0,20,43,65,89,112,137,159,182,205,189,166,143,118,95,72,49,25,3,0,0,0,0,20,44,67,90,114,138,161,184,204,180,158,135,110,88,65,41,19,0,0,0,25,50,76,101,129,142,142,142,142,142,142,142,142,142,142,145,164,188,209,185,163,144,142,142,142,142,142,142,142,142,142,142,121,99,73,48,22,0,0,0,0,0,10,35,60,84,109,137,160,185,194,170,148,142,142,142,142,142,142,142,142,142,142,142,142,142,132,106,81,55,30,5,0,0,0,0,0,0,0,17,40,62,83,105,129,149,172,194,192,170,147,124,102,80,58,36,14,34,56,79,101,123,146,168,190,190,169,147,124,101,80,58,37,15,0,0,0,0,0,0,0,19,40,62,82,104,124,148,170,190,196,174,153,132,108,86,64,42,57,79,101,123,147,169,190,188,167,146,123,101,80,58,37,15,0,0,0,0,0,0,24,49,73,98,123,149,173,198,193,168,144,117,93,68,44,19,19,43,67,92,116,142,166,191,203,204,199,175,150,124,100,76,51,27,10,35,60,85,109,136,160,185,196,172,147,121,96,72,47,22,0,0,0,0,12,35,58,81,105,129,152,175,197,196,172,150,124,101,79,56,32,9,0,0,0,4,27,51,74,97,119,144,168,191,196,173,150,129,103,80,57,34,11,0,0,0,24,49,74,98,114,114,114,114,114,114,114,114,114,114,114,137,160,185,208,182,160,134,114,114,114,114,114,114,114,114,114,114,113,96,72,47,22,0,0,0,0,0,11,35,60,86,111,137,162,187,190,167,142,114,114,114,114,114,114,114,114,114,114,114,114,114,114,101,79,54,29,4,0,0,0,0,0,0,0,7,29,50,72,94,116,139,161,182,202,180,157,136,112,90,67,46,23,44,66,88,110,134,156,178,200,179,157,136,113,91,70,48,26,4,0,0,0,0,0,0,0,6,28,49,71,92,113,136,157,179,200,186,164,142,119,97,75,54,69,90,113,136,157,180,198,177,155,134,110,90,68,47,25,4,0,0,0,0,0,0,20,44,69,93,118,144,168,193,197,173,148,121,98,73,48,23,24,49,73,98,121,147,172,189,179,179,190,180,155,132,106,81,57,33,14,40,64,89,114,139,165,189,191,167,142,116,92,67,42,18,0,0,0,0,5,28,51,74,97,119,144,167,190,202,179,156,134,109,85,62,39,16,0,0,0,11,34,57,80,103,129,152,174,197,189,166,143,119,96,73,50,27,4,0,0,0,18,41,63,81,88,88,88,88,88,88,88,88,88,88,109,137,160,185,208,182,160,134,106,88,88,88,88,88,88,88,88,88,88,79,61,39,16,0,0,0,0,0,12,38,63,88,111,139,164,188,189,165,139,114,88,88,88,88,88,88,88,88,88,88,88,88,88,83,67,46,23,0,0,0,0,0,0,0,0,0,18,40,62,83,105,129,150,172,194,189,167,145,121,99,78,55,33,54,76,98,119,144,165,188,190,169,147,124,102,80,58,37,15,0,0,0,0,0,0,0,0,0,16,38,58,80,101,123,146,166,188,197,175,153,132,108,87,65,79,101,123,146,168,190,186,164,144,121,99,78,56,35,13,0,0,0,0,0,0,0,15,40,64,89,114,139,164,188,202,177,152,129,101,77,52,27,30,54,79,103,129,153,178,171,155,155,172,186,162,137,111,88,63,39,19,44,68,93,117,144,168,193,187,162,138,111,88,63,38,13,0,0,0,0,0,20,44,67,90,113,137,160,183,206,186,163,139,115,92,69,46,22,0,0,0,17,41,64,87,110,135,157,181,204,181,159,136,111,89,65,42,20,0,0,0,0,7,27,45,58,63,63,63,63,63,63,63,63,63,83,109,137,160,185,208,182,160,134,106,81,63,63,63,63,63,63,63,63,63,57,44,25,5,0,0,0,0,0,14,39,63,88,114,139,165,190,187,162,137,111,86,66,66,66,66,66,66,66,66,66,66,66,66,61,49,31,11,0,0,0,0,0,0,0,0,0,7,29,51,73,95,116,139,161,183,199,177,155,132,109,87,65,42,63,86,108,132,153,175,197,180,157,136,113,91,70,48,26,4,0,0,0,0,0,0,0,0,0,4,25,47,69,89,110,134,155,177,197,186,165,144,119,98,76,90,112,136,157,179,196,174,153,132,108,87,66,45,23,2,0,0,0,0,0,0,0,10,35,60,84,109,135,160,183,206,181,157,132,106,81,56,32,36,61,85,109,135,160,183,160,137,137,162,186,167,144,117,93,69,45,23,48,73,98,121,148,173,197,182,157,134,107,83,58,33,8,0,0,0,0,0,13,36,59,82,106,129,152,176,199,192,169,147,121,98,76,53,29,6,0,1,24,47,70,93,116,141,164,188,197,174,152,129,104,81,58,35,12,0,0,0,0,0,10,25,36,40,40,40,40,40,40,40,40,58,83,109,137,160,185,208,182,160,134,106,81,55,40,40,40,40,40,40,40,40,35,24,8,0,0,0,0,0,0,15,40,66,91,114,142,167,192,185,160,136,109,83,60,40,40,40,40,40,40,40,40,40,40,40,37,29,15,0,0,0,0,0,0,0,0,0,0,0,19,40,62,84,106,129,150,172,194,187,164,143,118,96,74,51,73,95,117,141,163,185,190,169,147,124,103,81,58,37,15,0,0,0,0,0,0,0,0,0,0,0,14,34,56,78,99,119,143,164,186,198,175,154,132,109,87,100,121,146,167,190,183,163,141,118,97,75,54,32,11,0,0,0,0,0,0,0,0,5,30,55,80,104,130,154,179,203,185,160,137,109,86,60,36,42,66,91,115,140,165,180,155,132,134,157,182,173,149,123,99,75,50,27,52,77,101,129,152,177,201,178,153,129,102,78,53,28,4,0,0,0,0,0,6,29,52,75,98,121,145,168,191,199,176,153,130,106,82,59,36,12,0,7,30,54,77,100,123,147,171,194,190,167,144,119,97,73,51,28,4,0,0,0,0,0,0,3,11,15,15,15,15,15,15,15,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,15,15,15,15,15,15,15,11,2,0,0,0,0,0,0,0,17,42,67,91,116,144,167,193,182,157,134,106,83,58,48,48,48,45,41,35,28,20,15,15,15,12,6,0,0,0,0,0,0,0,0,0,0,0,0,8,30,51,73,95,116,139,162,183,196,174,152,129,105,83,60,82,104,129,150,172,195,180,158,136,113,91,70,48,27,5,0,0,0,0,0,0,0,0,0,0,0,2,23,44,65,87,108,130,152,173,195,187,165,143,119,98,110,134,156,178,194,172,150,129,107,86,64,42,21,0,0,0,0,0,0,0,0,0,0,25,50,75,99,124,150,174,198,190,165,140,114,90,65,40,48,72,96,121,147,171,175,151,124,129,153,178,179,155,132,105,80,56,32,56,81,106,132,157,181,197,173,148,121,98,73,49,24,0,0,0,0,0,0,0,21,45,68,91,114,138,161,184,206,183,160,137,112,89,66,43,19,0,14,37,61,83,106,132,155,177,200,183,160,137,113,90,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,43,68,93,118,144,170,195,180,156,132,105,81,71,73,73,71,69,65,59,52,43,32,21,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,41,63,84,106,129,150,172,195,183,160,138,114,92,69,91,114,137,160,182,190,169,147,124,103,81,59,37,15,0,0,0,0,0,0,0,0,0,0,0,0,0,11,32,54,75,96,117,140,161,182,198,177,154,132,109,121,144,166,188,181,161,139,116,95,73,51,31,8,0,0,0,0,0,0,0,0,0,0,20,45,70,94,119,144,169,193,194,169,144,118,93,69,44,54,78,102,129,152,176,170,147,119,123,149,174,185,160,137,110,86,62,38,60,85,109,137,160,185,192,168,144,117,93,69,44,19,0,0,0,0,0,0,0,14,37,61,83,106,132,153,176,200,189,167,144,119,96,73,49,26,3,20,44,67,90,114,138,161,184,198,175,152,129,105,82,59,36,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,70,93,119,147,170,195,179,154,129,103,90,95,96,96,96,93,89,83,75,65,55,42,28,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,30,51,73,95,117,140,162,183,192,169,147,123,101,79,100,123,146,169,191,180,158,137,113,91,70,48,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,41,63,84,105,129,149,171,192,188,165,144,121,132,153,176,191,170,148,124,104,83,62,40,19,0,0,0,0,0,0,0,0,0,0,0,15,40,65,90,114,140,165,189,198,173,149,121,98,73,48,59,84,108,134,158,183,165,142,116,119,144,170,191,166,142,116,92,68,44,65,90,114,140,165,190,188,163,139,114,88,64,39,14,0,0,0,0,0,0,0,7,30,53,76,99,121,146,169,192,196,173,150,124,102,79,56,33,9,27,50,73,97,119,144,167,191,191,168,145,121,98,75,52,28,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,45,71,96,121,147,172,198,177,152,124,106,114,119,121,121,121,117,114,106,98,88,76,63,48,31,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,41,63,84,106,129,152,173,195,178,156,134,110,89,110,134,156,178,190,169,147,124,103,81,59,37,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,29,50,72,93,115,137,158,180,199,177,155,134,140,163,186,180,158,137,114,92,71,49,28,7,0,0,0,0,0,0,0,0,0,0,0,11,35,60,85,109,136,160,184,202,178,152,129,101,78,53,65,90,114,139,163,185,160,137,111,114,139,165,189,172,147,121,98,73,49,69,93,118,144,169,194,183,159,134,109,84,59,34,10,0,0,0,0,0,0,0,0,23,45,69,92,114,139,162,184,203,180,156,134,109,86,63,40,16,33,57,80,103,129,151,174,197,184,160,138,114,90,67,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,48,73,98,121,149,174,198,175,149,124,132,139,144,149,149,147,144,139,132,121,110,98,83,67,49,31,13,0,0,0,0,0,0,0,0,0,0,0,0,0,8,30,52,74,96,117,140,162,184,188,165,144,119,98,121,144,166,188,180,158,137,114,91,70,48,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,39,61,81,103,124,147,168,189,188,170,157,160,175,189,167,146,123,103,81,59,38,16,0,0,0,0,0,0,0,0,0,0,0,0,6,31,55,80,105,132,155,179,204,182,157,132,106,81,57,71,96,119,145,170,180,156,132,106,109,135,160,184,178,154,129,103,80,55,73,98,121,149,173,198,178,154,130,104,79,55,30,5,0,0,0,0,0,0,0,0,15,38,61,85,107,132,155,177,200,186,163,140,116,93,69,46,23,40,64,87,109,134,157,181,199,176,153,130,106,83,60,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,49,73,99,124,150,175,200,179,157,147,154,163,169,172,175,172,168,162,155,145,134,117,101,85,67,49,29,8,0,0,0,0,0,0,0,0,0,0,0,0,0,20,41,63,84,107,130,152,173,195,175,153,132,108,132,154,176,191,169,147,124,103,81,59,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,48,70,91,112,135,156,177,199,190,183,184,194,177,156,135,112,90,69,48,26,4,0,0,0,0,0,0,0,0,0,0,0,0,1,26,51,75,100,124,150,175,199,186,161,137,110,86,61,77,101,124,151,175,176,152,124,101,104,130,154,178,184,160,135,109,85,61,78,101,129,152,178,198,174,149,124,99,75,50,25,0,0,0,0,0,0,0,0,0,8,31,54,77,100,123,147,170,193,193,170,147,121,99,76,53,30,47,70,93,116,141,164,187,192,169,146,121,98,76,53,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,76,101,124,152,177,202,191,178,172,176,175,175,175,179,185,192,186,178,167,154,139,119,103,83,63,42,21,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,53,74,96,117,140,163,184,185,163,140,118,141,163,186,180,158,137,114,92,70,48,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,36,57,79,100,121,144,165,187,210,208,209,187,165,144,121,99,79,57,36,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,46,70,96,119,145,170,194,190,165,141,114,90,65,83,106,132,157,181,171,147,121,96,99,123,149,173,189,165,141,115,91,67,81,106,132,157,182,193,169,144,119,94,70,45,20,0,0,0,0,0,0,0,0,0,0,24,46,69,93,116,139,163,186,200,176,154,132,106,83,60,36,53,77,100,123,147,170,194,184,161,139,114,91,69,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,52,77,101,129,153,174,188,177,166,158,152,149,149,152,155,162,173,185,200,188,173,157,139,117,98,76,55,33,11,0,0,0,0,0,0,0,0,0,0,0,0,0,20,41,64,86,107,130,152,173,195,172,150,139,152,173,191,169,147,124,103,81,59,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,25,47,69,89,110,134,160,185,208,228,203,180,155,132,109,88,67,45,24,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,41,65,91,114,141,165,189,194,170,144,119,93,70,88,113,139,162,187,165,141,115,91,93,117,144,167,192,171,147,121,97,73,86,110,137,161,186,189,165,140,114,90,65,40,16,0,0,0,0,0,0,0,0,0,0,16,39,62,85,108,132,155,178,201,183,160,137,113,90,67,44,61,83,106,132,154,177,200,177,154,132,107,84,61,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,53,78,103,124,140,154,167,155,144,134,129,121,121,124,132,139,150,165,181,199,192,173,154,134,110,89,66,44,21,0,0,0,0,0,0,0,0,0,0,0,0,0,9,31,53,74,96,118,141,163,184,186,169,162,169,186,180,158,137,114,92,70,48,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,38,58,80,101,123,145,166,188,209,208,205,182,160,138,115,94,73,51,31,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,36,61,86,110,137,160,184,199,174,150,124,99,74,96,119,145,168,184,160,135,109,85,88,112,137,162,186,176,153,129,104,80,91,115,142,166,190,184,160,136,109,86,61,36,11,0,0,0,0,0,0,0,0,0,0,9,32,55,78,101,124,148,171,194,190,167,144,119,97,73,50,68,91,114,139,161,184,192,170,147,121,100,77,53,31,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,71,91,105,117,132,146,132,119,109,101,98,98,100,106,116,130,146,164,183,204,189,167,146,121,99,76,53,29,6,0,0,0,0,0,0,0,0,0,0,0,0,0,20,42,64,86,107,130,152,174,196,192,187,192,191,170,147,124,103,81,59,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,28,49,71,92,113,136,157,179,193,184,183,193,192,171,150,129,106,86,64,43,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,31,56,81,106,132,155,180,203,178,154,129,103,78,101,124,150,175,178,154,129,104,80,82,106,132,156,181,183,159,134,109,85,93,119,144,170,195,180,155,132,106,80,56,31,6,0,0,0,0,0,0,0,0,0,0,1,24,48,70,93,116,141,163,187,197,174,151,129,103,80,57,74,98,121,145,168,192,185,162,139,115,93,69,46,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,55,70,83,97,110,121,110,98,87,78,73,73,76,82,94,109,129,148,170,192,202,179,156,134,108,84,61,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,9,31,53,75,97,118,141,163,185,207,213,202,180,158,137,114,92,71,49,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,40,62,83,105,124,148,170,190,175,161,160,173,193,183,163,141,118,98,76,55,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,51,76,101,124,151,175,200,182,157,132,106,81,106,132,155,180,173,148,121,98,74,77,101,124,151,175,188,164,139,114,90,98,121,149,173,198,175,151,124,101,76,51,26,1,0,0,0,0,0,0,0,0,0,0,0,17,40,63,86,109,134,156,180,202,181,157,134,110,87,64,81,104,129,152,175,198,178,155,132,108,85,62,39,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,21,36,50,63,76,90,99,89,76,64,54,49,48,52,61,74,92,113,136,159,182,206,188,164,140,114,91,66,42,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,42,64,86,108,132,153,174,196,213,191,170,148,124,103,81,59,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,31,53,74,95,116,139,160,181,183,161,139,137,160,181,196,174,153,132,109,88,67,46,24,3,0,0,0,0,0,0,0,0,0,0,0,0,0,22,47,71,96,119,146,170,195,186,161,137,110,86,110,137,160,185,167,143,116,93,69,70,95,119,144,169,194,169,144,119,95,101,129,152,177,195,170,146,119,96,71,47,22,0,0,0,0,0,0,0,0,0,0,0,0,10,33,56,79,101,124,149,172,195,188,164,141,116,93,70,87,110,135,158,181,194,171,147,124,101,77,54,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,29,42,55,68,73,67,55,42,32,25,24,28,40,58,79,102,124,151,175,199,194,170,146,119,94,70,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,32,54,75,97,118,141,165,188,208,185,160,137,114,92,71,49,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,43,64,86,107,130,150,172,194,173,150,129,124,148,170,192,187,165,144,121,100,79,58,37,15,0,0,0,0,0,0,0,0,0,0,0,0,0,17,42,67,91,115,141,165,190,190,165,139,114,91,115,141,165,186,162,137,111,87,63,65,90,114,139,163,188,174,150,124,100,106,132,157,181,190,165,142,116,91,67,42,17,0,0,0,0,0,0,0,0,0,0,0,0,3,25,49,72,94,117,142,164,188,194,170,147,121,99,76,93,116,141,164,188,186,163,140,116,93,70,47,24,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,21,34,45,48,45,34,21,8,0,0,5,24,47,71,96,119,146,170,195,198,174,149,121,98,73,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,42,66,88,114,139,165,187,208,185,160,137,109,86,60,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,34,55,76,98,118,141,163,184,185,163,140,117,114,137,159,181,199,178,156,136,113,91,70,49,28,6,0,0,0,0,0,0,0,0,0,0,0,0,12,37,62,86,111,137,160,185,193,168,144,116,96,119,146,170,181,156,132,106,81,57,59,83,108,134,158,183,180,155,132,106,109,136,160,185,185,161,137,111,86,62,37,12,0,0,0,0,0,0,0,0,0,0,0,0,0,18,41,64,87,110,134,157,180,200,176,153,130,106,82,99,121,147,170,194,179,156,134,109,86,63,40,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,21,29,33,30,21,22,20,12,0,0,0,0,0,17,43,67,91,116,144,170,193,200,175,149,121,99,73,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,208,185,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,24,46,67,89,110,132,154,175,196,174,153,130,107,103,124,148,170,191,190,169,147,124,104,82,61,40,18,0,0,0,0,0,0,0,0,0,0,0,0,7,32,57,81,106,132,155,180,197,172,147,121,101,124,152,176,175,151,124,101,76,52,54,78,102,129,152,176,184,160,137,110,114,139,164,189,181,156,132,106,81,57,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,11,34,57,80,103,124,150,173,196,183,160,137,111,89,106,132,154,176,195,172,149,124,101,78,56,33,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,26,41,53,58,53,42,26,11,0,0,0,0,0,0,17,43,66,91,116,144,170,193,200,175,149,121,99,73,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,208,185,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,37,58,79,100,121,144,166,187,187,164,143,118,97,92,114,137,160,180,202,180,160,138,116,95,73,52,31,9,0,0,0,0,0,0,0,0,0,0,0,2,27,52,77,101,124,152,175,200,176,152,124,106,132,156,181,170,145,119,95,70,46,48,72,96,121,147,171,190,165,141,115,116,143,167,193,176,152,124,101,77,52,28,3,0,0,0,0,0,0,0,0,0,0,0,0,0,4,26,49,73,96,118,143,165,188,189,166,143,118,95,112,137,160,183,188,164,141,117,94,71,48,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,41,60,75,81,75,62,45,29,16,2,0,0,0,0,22,46,70,94,119,144,170,195,198,173,149,121,97,73,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,208,185,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,28,49,70,91,113,136,156,178,198,177,154,132,108,87,81,103,124,148,169,191,192,172,150,129,107,86,64,42,21,0,0,0,0,0,0,0,0,0,0,0,0,22,47,72,96,121,147,171,196,180,155,132,111,137,161,186,163,139,114,90,65,40,42,66,91,115,141,165,189,170,146,119,119,147,171,196,172,147,121,97,73,48,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,42,65,88,111,136,158,181,196,172,149,124,101,118,143,166,189,180,157,134,109,87,64,41,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,35,55,76,96,106,96,80,64,50,36,24,16,12,14,21,36,55,78,101,124,150,174,198,193,169,144,119,93,70,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,208,185,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,40,61,82,104,124,147,169,190,188,165,144,121,98,76,70,91,113,137,157,179,202,184,162,141,118,97,76,55,33,12,0,0,0,0,0,0,0,0,0,0,0,18,42,67,91,116,142,166,191,183,160,134,116,142,166,183,158,134,108,83,59,35,36,61,85,109,136,160,184,175,151,124,124,149,175,191,167,142,116,92,68,43,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,57,81,104,129,151,174,197,179,155,132,109,124,149,172,196,172,150,124,102,80,57,33,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,9,29,49,70,90,110,132,116,99,85,71,57,47,41,38,39,44,55,71,90,110,135,157,181,204,186,163,139,114,90,65,41,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,208,185,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,30,51,73,95,115,138,160,181,198,177,154,132,109,88,66,58,80,101,123,146,167,189,196,174,154,132,109,88,67,46,24,3,0,0,0,0,0,0,0,0,0,0,13,38,62,86,111,137,161,186,188,162,138,121,147,171,177,152,129,102,78,54,29,30,55,80,104,129,154,178,180,156,132,129,153,178,187,162,138,111,88,63,38,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,50,73,97,119,144,167,189,186,163,139,115,134,156,179,188,165,142,118,95,72,49,26,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,2,23,43,64,84,105,124,146,136,119,106,92,80,71,65,63,63,68,76,90,105,124,146,167,190,199,177,154,132,106,83,59,35,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,208,185,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,42,64,85,107,129,150,172,192,187,165,143,119,98,76,55,47,69,90,112,135,156,178,199,187,165,144,121,100,79,58,37,15,0,0,0,0,0,0,0,0,0,0,8,33,57,82,106,132,157,181,191,167,142,129,152,176,172,147,121,97,73,48,24,25,49,73,98,121,148,173,185,161,137,132,157,181,182,157,134,107,83,58,34,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,43,66,90,112,137,160,182,192,170,147,121,139,163,186,181,158,135,111,88,65,42,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,15,37,58,78,98,118,140,161,155,141,129,113,103,94,90,88,88,92,99,110,124,143,161,181,202,187,166,144,121,98,74,51,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,208,185,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,33,55,76,97,118,141,162,183,197,175,154,132,108,87,65,44,36,57,79,100,121,145,166,188,198,178,156,135,113,91,70,49,28,6,0,0,0,0,0,0,0,0,0,3,28,53,77,101,129,152,176,195,172,150,142,158,182,166,142,116,91,67,43,18,19,43,68,93,116,143,167,191,168,146,144,163,186,178,152,129,102,78,54,29,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,36,59,81,105,129,152,175,198,176,155,137,148,170,192,173,151,129,103,81,57,34,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,23,47,69,92,113,135,155,175,175,162,148,137,124,118,114,111,112,116,121,134,146,161,177,195,193,173,153,132,109,87,64,41,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,208,185,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,24,45,67,88,109,132,153,174,196,186,164,143,119,97,75,54,32,24,46,67,89,110,134,155,177,198,190,169,147,124,104,82,61,40,19,0,0,0,0,0,0,0,0,0,0,23,48,73,96,121,147,172,196,186,171,167,176,184,160,137,110,86,61,37,12,13,38,62,87,111,137,161,186,182,169,168,179,197,173,148,121,98,73,49,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,28,51,74,98,121,144,168,191,188,170,162,167,182,189,166,144,119,96,73,50,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,25,50,76,99,124,143,159,174,189,182,170,158,151,144,139,139,139,142,147,156,166,181,196,192,177,158,139,117,97,75,53,31,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,208,185,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,57,79,100,121,144,165,186,196,174,153,132,108,86,65,42,21,13,34,55,78,99,121,144,165,187,202,181,160,138,115,95,73,51,31,9,0,0,0,0,0,0,0,0,0,18,43,68,92,116,142,167,191,205,195,193,198,179,155,132,105,80,56,31,7,8,32,57,81,106,132,155,180,203,194,193,200,193,168,144,117,93,69,44,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,44,67,90,113,137,160,183,206,193,188,190,201,182,159,137,112,89,65,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,208,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,21,45,67,89,106,123,139,154,167,181,192,182,174,168,165,165,165,167,172,178,189,198,186,172,157,141,121,103,83,62,41,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,187,200,185,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,6,27,48,70,91,112,135,156,177,198,184,164,141,118,97,75,54,31,9,0,23,44,66,88,109,132,154,175,197,192,172,150,129,107,86,64,43,21,0,0,0,0,0,0,0,0,0,14,38,63,87,111,137,162,187,200,200,200,198,173,149,124,99,75,50,25,1,2,26,51,75,100,124,150,174,198,200,200,200,188,163,139,114,88,64,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,60,83,106,130,153,176,199,200,200,200,197,175,152,129,105,81,58,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,185,200,182,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,13,33,53,71,87,103,118,134,147,159,170,180,186,192,190,188,189,190,196,191,184,175,165,152,138,121,103,85,67,48,28,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,165,175,175,175,160,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,17,39,61,81,103,124,146,168,175,175,174,153,130,107,86,64,42,20,0,0,11,32,55,75,98,119,141,164,175,175,175,163,141,118,98,76,55,33,11,0,0,0,0,0,0,0,0,9,33,58,83,106,134,157,175,175,175,175,175,168,144,118,93,69,45,20,0,0,20,45,70,94,119,144,168,175,175,175,175,175,159,134,109,84,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,53,75,98,121,145,168,175,175,175,175,175,167,144,119,98,74,51,28,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,160,175,175,175,160,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,19,36,53,69,83,98,112,124,138,147,156,162,167,172,175,175,175,172,167,161,153,144,132,116,101,86,69,51,32,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,149,149,149,149,149,137,109,86,60,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,25,48,72,93,115,138,149,149,149,149,149,141,117,96,74,53,31,8,0,0,0,21,43,64,86,108,130,149,149,149,149,149,149,132,109,88,65,43,18,0,0,0,0,0,0,0,0,4,29,53,78,101,129,149,149,149,149,149,149,149,138,112,88,64,39,14,0,0,15,40,64,88,113,139,149,149,149,149,149,149,149,129,104,79,55,30,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,114,138,149,149,149,149,149,149,149,137,113,90,67,44,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,58,83,109,137,149,149,149,149,149,134,106,81,55,30,5,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,33,49,64,77,90,103,114,123,132,139,144,147,149,149,149,147,144,137,130,119,108,96,82,67,51,33,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,65,88,113,121,121,121,121,121,121,121,108,86,60,37,12,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,75,98,121,121,121,121,121,121,121,121,106,84,63,41,20,0,0,0,0,9,31,53,74,96,117,121,121,121,121,121,121,121,117,93,68,45,20,0,0,0,0,0,0,0,0,0,24,48,73,98,119,121,121,121,121,121,121,121,121,106,83,58,33,9,0,0,9,33,58,83,107,121,121,121,121,121,121,121,121,121,98,75,50,26,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,37,61,84,106,121,121,121,121,121,121,121,121,121,106,82,59,36,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,32,58,83,108,121,121,121,121,121,121,121,106,80,55,30,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,29,43,57,69,81,91,100,107,114,116,121,121,121,121,121,117,112,106,97,87,74,62,48,32,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,59,79,96,99,99,99,99,99,99,99,93,77,55,33,9,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,69,89,98,99,99,99,99,99,99,99,90,74,51,30,8,0,0,0,0,0,20,41,63,83,97,99,99,99,99,99,99,99,98,83,64,41,19,0,0,0,0,0,0,0,0,0,19,43,65,85,98,99,99,99,99,99,99,99,99,92,73,50,27,3,0,0,3,28,51,73,92,99,99,99,99,99,99,99,99,98,87,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,52,74,92,99,99,99,99,99,99,99,99,99,90,73,51,28,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,28,52,75,93,99,99,99,99,99,99,99,92,73,50,26,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,22,35,47,58,68,77,83,89,93,96,96,99,99,96,93,88,81,73,64,53,41,27,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,25,45,61,72,73,73,73,73,73,73,73,70,59,42,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,33,53,67,73,73,73,73,73,73,73,73,69,56,38,18,0,0,0,0,0,0,8,29,47,64,72,73,73,73,73,73,73,73,73,64,49,29,9,0,0,0,0,0,0,0,0,0,9,31,49,65,73,73,73,73,73,73,73,73,73,69,56,38,16,0,0,0,0,17,38,56,69,73,73,73,73,73,73,73,73,73,66,51,31,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,40,56,69,73,73,73,73,73,73,73,73,73,68,56,38,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,40,58,70,73,73,73,73,73,73,73,69,56,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,13,25,35,45,53,59,65,68,71,73,73,73,72,68,64,57,50,41,30,19,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,27,39,47,48,48,48,48,48,48,48,46,38,24,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,33,44,48,48,48,48,48,48,48,48,45,35,20,4,0,0,0,0,0,0,0,13,28,41,47,48,48,48,48,48,48,48,47,41,30,13,0,0,0,0,0,0,0,0,0,0,0,15,30,42,48,48,48,48,48,48,48,48,48,45,35,20,2,0,0,0,0,2,20,35,45,48,48,48,48,48,48,48,48,48,43,31,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,35,45,48,48,48,48,48,48,48,48,48,45,35,20,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,37,46,48,48,48,48,48,48,48,45,35,20,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,13,22,29,35,40,44,48,48,48,48,48,45,40,34,27,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,16,22,22,22,22,22,22,22,22,21,15,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,19,22,22,22,22,22,22,22,22,20,13,2,0,0,0,0,0,0,0,0,0,7,17,22,22,22,22,22,22,22,22,22,17,8,0,0,0,0,0,0,0,0,0,0,0,0,0,8,18,22,22,22,22,22,22,22,22,22,20,13,0,0,0,0,0,0,0,0,13,20,22,22,22,22,22,22,22,22,22,19,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,20,22,22,22,22,22,22,22,22,22,20,13,0,0,0,0,0,0,0,0,0,0,0])
.concat([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,21,22,22,22,22,22,22,22,20,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,11,16,19,22,22,22,22,22,20,15,10,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,22,21,17,14,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,22,21,18,14,10,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,22,25,25,25,25,25,25,25,25,20,9,0,0,0,0,0,0,0,0,0,5,17,24,25,25,25,25,25,25,25,20,11,0,0,0,0,0,1,13,22,25,25,25,25,25,25,25,24,20,9,0,0,0,0,0,0,0,0,9,19,24,25,25,25,25,25,25,25,25,20,11,0,0,0,0,0,0,0,1,13,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,24,22,20,17,13,8,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,18,24,25,25,25,25,25,25,25,25,24,18,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,19,34,45,50,50,50,50,50,50,50,50,50,50,50,50,50,50,48,48,45,42,38,33,27,19,10,0,0,0,0,0,0,0,0,0,0,0,0,2,19,34,45,50,50,50,50,50,50,50,50,50,50,50,50,50,50,48,48,45,43,39,34,28,21,13,3,0,0,0,0,0,0,0,0,0,0,0,19,34,45,50,50,50,50,50,50,50,50,42,30,13,0,0,0,0,0,0,0,8,26,39,48,50,50,50,50,50,50,50,44,32,15,0,0,0,2,20,34,45,50,50,50,50,50,50,50,50,42,29,13,0,0,0,0,0,0,13,29,42,49,50,50,50,50,50,50,50,50,43,32,15,0,0,0,0,0,2,20,35,45,50,50,50,50,50,50,50,50,50,50,50,50,50,50,48,47,45,42,37,32,27,20,12,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,27,40,49,50,50,50,50,50,50,50,50,49,40,27,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,36,55,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,70,67,63,57,51,43,33,23,11,0,0,0,0,0,0,0,0,0,0,16,36,55,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,71,68,63,59,52,45,36,25,14,2,0,0,0,0,0,0,0,0,14,36,55,68,73,73,73,73,73,73,73,73,65,49,30,9,0,0,0,0,0,0,23,44,61,71,73,73,73,73,73,73,73,65,49,31,9,0,0,16,38,55,68,73,73,73,73,73,73,73,73,64,47,29,7,0,0,0,0,11,29,47,64,72,73,73,73,73,73,73,73,73,65,49,31,9,0,0,0,0,16,38,55,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,72,70,66,62,57,51,44,35,24,14,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,45,62,72,73,73,73,73,73,73,73,73,72,61,45,26,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,26,48,71,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,97,95,91,87,81,75,66,56,45,32,19,4,0,0,0,0,0,0,0,1,26,48,71,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,97,96,92,88,83,77,68,59,48,36,23,8,0,0,0,0,0,0,1,24,48,71,90,99,99,99,99,99,99,99,98,85,64,42,21,0,0,0,0,0,9,33,57,79,95,99,99,99,99,99,99,98,85,64,43,19,0,1,26,50,71,90,99,99,99,99,99,99,99,98,83,62,41,16,0,0,0,7,26,45,64,83,97,99,99,99,99,99,99,99,98,85,64,43,19,0,0,0,4,26,50,71,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,96,93,91,86,81,75,67,58,47,35,22,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,37,59,81,96,99,99,99,99,99,99,99,99,96,80,59,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,103,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,121,119,116,111,106,98,90,79,67,53,38,22,6,0,0,0,0,0,0,5,30,53,78,103,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,121,119,116,113,107,100,92,81,71,57,43,28,12,0,0,0,0,0,5,27,53,78,103,124,124,124,124,124,124,124,119,98,76,55,33,12,0,0,0,0,12,38,63,88,111,124,124,124,124,124,124,121,96,71,48,22,0,5,30,55,78,103,124,124,124,124,124,124,124,118,93,68,45,20,0,0,3,22,42,60,80,99,117,124,124,124,124,124,124,124,121,96,73,48,22,0,0,0,7,30,55,78,103,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,121,119,116,111,106,99,90,81,69,57,43,28,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,114,124,124,124,124,124,124,124,124,114,91,67,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,152,152,152,152,152,152,152,152,152,152,152,152,152,152,149,147,142,137,132,121,112,101,88,74,58,40,24,5,0,0,0,0,0,5,30,53,78,104,129,152,152,152,152,152,152,152,152,152,152,152,152,152,152,149,147,144,139,132,124,115,104,92,78,62,46,28,10,0,0,0,0,5,27,53,78,104,129,152,152,152,152,152,152,134,110,89,67,45,24,2,0,0,0,12,38,63,88,111,139,152,152,152,152,149,121,96,71,48,22,0,5,30,55,78,104,129,152,152,152,152,152,144,119,93,68,45,20,0,0,18,38,57,76,95,114,135,152,152,152,152,152,148,129,109,89,67,45,20,0,0,0,7,30,55,78,104,129,152,152,152,152,152,152,152,152,152,152,152,152,152,151,149,146,142,137,132,121,114,103,90,78,62,46,28,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,76,99,121,146,152,152,152,152,152,152,145,121,98,75,53,29,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,177,177,177,177,177,177,177,177,177,177,177,177,175,175,171,167,162,155,147,136,121,109,93,76,58,40,20,0,0,0,0,0,5,30,53,78,104,129,154,177,177,177,177,177,177,177,177,177,177,177,177,176,175,172,167,163,157,148,139,129,113,98,82,64,45,26,6,0,0,0,5,27,53,78,104,129,154,177,177,177,177,167,145,123,100,79,57,36,14,0,0,0,12,38,63,88,111,139,165,177,177,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,177,177,177,170,144,119,93,68,45,20,0,15,33,53,72,91,110,132,150,170,177,177,171,152,132,112,92,74,55,34,13,0,0,0,7,30,55,78,104,129,154,177,177,177,177,177,177,177,177,177,177,177,177,175,173,170,166,161,155,147,138,124,112,97,80,63,44,24,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,37,61,83,106,132,154,176,177,177,177,177,176,153,130,106,83,60,36,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,203,203,199,188,185,185,185,185,185,185,185,187,190,194,191,186,179,170,158,144,130,110,94,74,55,34,12,0,0,0,0,5,30,53,78,104,129,154,180,203,203,199,188,185,185,185,185,185,185,185,186,188,193,192,187,180,172,161,148,134,116,98,80,60,41,20,0,0,0,5,27,53,78,104,129,154,180,203,203,201,179,157,136,113,91,69,48,26,4,0,0,12,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,11,30,49,69,87,107,124,146,165,184,193,174,155,136,116,97,78,58,40,20,0,0,0,0,7,30,55,78,104,129,154,177,203,203,197,184,180,180,180,180,180,180,182,182,186,191,190,185,179,170,160,147,134,116,98,79,58,38,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,69,91,114,138,161,184,189,180,182,192,184,160,137,114,90,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,200,181,164,160,160,160,160,160,160,160,162,165,170,176,186,197,191,179,164,148,130,109,89,68,46,24,2,0,0,0,5,30,53,78,104,129,154,180,205,200,181,164,160,160,160,160,160,160,160,162,165,168,175,183,194,195,182,168,153,136,115,95,75,53,32,9,0,0,5,27,53,78,104,129,154,180,205,228,213,191,170,148,124,103,81,59,38,16,0,0,12,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,26,45,64,83,103,121,143,161,181,197,178,159,140,119,100,82,62,43,24,5,0,0,0,0,7,30,55,78,104,129,154,177,203,202,179,163,157,157,157,157,157,157,157,158,162,167,174,184,196,192,181,167,152,134,112,92,71,49,28,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,76,98,121,146,169,189,170,158,160,175,191,168,145,121,98,75,52,29,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,168,146,134,134,134,134,134,134,137,137,141,146,153,164,175,191,199,182,165,144,123,101,80,57,34,12,0,0,0,5,30,53,78,104,129,154,180,205,193,168,146,134,134,134,134,134,134,137,137,139,144,151,160,172,185,202,188,170,150,130,108,87,65,43,20,0,0,5,27,53,78,104,129,154,180,205,219,211,203,181,160,138,115,93,72,50,28,6,0,12,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,22,42,61,80,99,117,139,158,177,196,181,163,144,123,104,85,66,47,28,9,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,132,132,132,132,132,132,132,134,137,143,152,162,175,191,202,186,167,147,124,104,82,59,36,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,38,61,84,106,132,153,176,180,157,136,140,163,186,176,152,130,106,83,60,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,106,106,106,106,108,109,111,114,121,130,141,155,173,191,199,179,158,136,112,90,67,43,20,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,106,106,106,106,106,109,110,114,119,129,138,150,166,184,204,185,165,144,121,98,75,52,29,6,0,5,27,53,78,104,129,154,180,205,196,187,186,194,172,150,129,105,84,62,40,19,0,12,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,38,57,76,95,114,136,154,173,192,186,166,148,129,108,89,69,51,31,12,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,104,104,104,104,104,104,107,111,117,129,141,157,175,195,201,181,159,137,113,90,67,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,68,91,114,139,161,184,174,151,129,134,157,180,184,160,138,114,91,68,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,83,83,83,83,83,86,90,97,106,119,137,157,178,200,191,169,146,121,98,74,50,27,2,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,83,83,83,83,83,86,89,94,103,115,132,150,170,191,198,177,154,132,107,83,60,36,12,0,5,27,53,78,104,129,154,180,197,179,164,163,175,184,163,140,117,96,74,53,31,9,12,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,53,72,92,110,132,150,170,189,189,170,150,132,112,92,73,54,35,16,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,78,78,78,78,80,83,87,95,105,121,141,162,183,205,190,167,144,119,96,72,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,76,99,121,146,168,191,168,144,119,129,151,174,192,168,145,121,98,75,53,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,58,58,58,58,61,65,73,84,101,121,145,167,191,200,176,152,129,104,80,55,31,7,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,58,58,58,58,60,64,71,81,95,114,137,159,181,204,186,162,139,114,90,66,42,17,0,5,27,53,78,104,129,154,180,188,166,143,141,161,183,174,153,132,108,87,64,42,21,12,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,49,69,88,107,129,146,166,184,193,173,155,136,115,96,77,58,38,20,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,53,53,53,55,58,63,72,86,106,129,152,175,199,196,172,148,121,99,75,50,27,2,0,0,0,0,0,0,0,0,0,0,0,0,15,37,61,84,107,132,154,176,185,162,139,114,119,144,168,191,176,153,130,106,83,60,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,33,33,33,37,41,50,67,89,112,137,160,184,206,182,157,134,108,83,59,35,10,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,33,33,33,35,40,47,60,80,102,124,151,174,198,192,168,144,118,93,70,45,21,0,5,27,53,78,104,129,154,180,190,165,139,129,149,172,187,165,143,119,98,76,55,33,12,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,65,84,103,123,143,162,181,197,177,158,139,118,99,80,62,42,23,4,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,48,27,28,30,33,39,52,75,98,121,147,170,195,198,175,149,124,99,76,50,27,2,0,0,0,0,0,0,0,0,0,0,0,0,22,45,69,91,114,138,161,184,179,155,132,108,114,139,162,185,184,161,138,114,90,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,17,7,9,12,17,33,57,82,106,132,157,182,205,185,160,137,109,86,60,35,12,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,17,7,8,11,16,25,48,72,96,119,147,170,195,196,172,147,121,96,73,48,22,0,5,27,53,78,104,129,154,180,190,167,142,115,139,161,183,177,155,134,110,89,67,45,24,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,80,99,118,139,158,177,196,181,162,143,123,103,84,65,46,27,7,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,48,22,3,5,8,24,48,72,96,119,147,170,195,196,172,149,121,99,75,50,27,2,0,0,0,0,0,0,0,0,0,0,0,7,30,53,76,99,121,146,169,192,173,150,124,101,108,132,155,179,191,168,145,121,98,76,53,29,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,17,0,0,0,6,30,55,80,104,132,157,180,205,187,162,137,111,86,60,38,12,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,17,0,0,0,0,20,44,68,93,116,144,170,193,198,172,149,121,97,73,48,22,0,5,27,53,78,104,129,154,180,193,167,144,116,129,150,173,189,167,146,123,100,79,57,36,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,76,96,114,136,154,173,193,184,166,146,129,107,88,69,50,30,11,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,48,22,17,20,23,33,53,76,98,121,147,172,195,190,167,144,119,96,72,48,24,1,0,0,0,0,0,0,0,0,0,0,0,15,38,61,84,106,132,153,176,190,167,144,119,96,101,124,150,172,196,176,153,130,106,83,60,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,17,0,0,0,11,33,58,82,106,132,157,182,205,185,160,137,109,86,60,35,12,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,17,0,0,0,0,20,45,69,93,116,144,170,193,198,172,149,121,97,73,48,22,0,5,27,53,78,104,129,154,180,195,170,145,119,116,139,162,184,179,157,136,113,91,70,48,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,92,110,132,150,170,189,188,170,150,132,110,92,72,53,34,15,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,48,43,43,44,48,54,67,86,107,130,153,176,199,180,158,136,113,90,66,43,19,0,0,0,0,0,0,0,0,0,0,0,0,22,45,69,91,114,139,161,184,184,160,137,112,90,95,117,143,165,189,184,160,138,114,91,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,17,17,20,23,31,46,65,89,112,137,160,184,206,182,157,134,109,83,58,35,10,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,17,0,0,1,8,26,49,73,96,121,147,170,195,195,171,147,121,96,72,48,22,0,5,27,53,78,104,129,154,180,198,172,147,121,105,129,152,174,191,170,148,124,103,81,59,38,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,107,129,146,166,185,193,173,154,136,114,95,76,57,38,19,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,66,66,68,68,72,78,87,101,119,141,162,184,186,167,146,124,103,81,58,36,13,0,0,0,0,0,0,0,0,0,0,0,7,30,53,76,99,121,146,169,192,177,153,132,106,83,88,111,137,159,182,192,168,146,121,98,75,53,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,43,43,45,48,54,65,80,100,121,144,168,191,201,177,153,129,104,80,55,31,7,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,20,22,22,26,32,43,60,81,104,129,152,175,199,191,167,144,116,93,69,45,20,0,5,27,53,78,104,129,154,180,199,175,149,123,99,116,140,163,186,182,161,138,115,93,72,50,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,103,123,143,162,181,200,183,160,139,117,99,80,61,42,22,3,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,91,91,91,91,93,96,101,109,121,139,155,174,184,170,152,134,112,91,71,49,26,4,0,0,0,0,0,0,0,0,0,0,0,15,38,61,84,107,132,154,176,193,171,147,123,99,77,81,105,129,152,176,198,176,153,130,106,83,61,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,68,68,68,69,73,78,87,99,116,136,155,178,200,192,169,146,121,98,74,50,27,2,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,45,45,47,48,51,56,65,78,95,115,138,160,183,206,184,160,137,112,88,65,41,16,0,5,27,53,78,104,129,154,180,201,177,152,124,101,106,130,153,174,194,172,150,129,106,84,62,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,119,139,158,177,197,208,184,161,139,117,96,75,54,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,116,116,116,116,116,119,121,129,134,144,157,173,172,162,150,135,116,98,79,57,37,16,0,0,0,0,0,0,0,0,0,0,0,0,23,45,69,91,114,139,161,184,186,163,139,116,93,70,75,98,121,144,168,191,184,161,138,114,91,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,93,93,93,93,93,93,98,102,109,121,136,152,170,190,200,180,158,137,113,90,67,44,20,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,71,71,71,72,73,75,80,88,98,112,132,150,171,192,197,174,152,130,106,82,59,35,11,0,5,27,53,78,104,129,154,180,203,178,154,129,103,95,117,141,163,184,184,163,140,117,96,74,63,88,111,139,165,190,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,136,154,173,193,212,215,194,172,152,132,108,88,66,45,24,3,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,197,174,154,144,144,144,144,144,144,146,147,152,158,166,172,157,149,140,129,114,98,82,63,44,24,4,0,0,0,0,0,0,0,0,0,0,0,7,30,53,76,99,121,146,169,192,179,156,134,109,85,63,68,90,114,138,161,184,191,168,145,121,98,76,53,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,119,119,119,119,119,119,119,121,129,135,144,156,171,188,201,184,165,146,123,103,81,58,35,12,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,96,96,96,96,96,98,101,104,111,121,134,150,166,185,203,183,163,141,118,96,73,50,28,4,0,5,27,53,78,104,129,154,180,205,180,155,132,104,84,106,129,150,172,194,174,153,132,108,87,65,86,111,139,163,187,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,146,134,152,170,189,198,195,196,206,185,164,144,121,100,79,58,37,16,0,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,208,188,174,170,170,170,170,170,170,170,172,176,182,185,162,138,124,116,105,94,83,72,59,45,30,12,0,0,0,0,0,0,0,0,0,0,0,15,38,61,84,106,132,154,177,196,172,149,124,102,78,56,61,83,106,132,154,176,199,176,153,132,106,83,60,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,196,172,152,144,144,144,144,144,144,147,147,152,158,166,178,191,196,182,166,148,130,110,90,69,47,24,3,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,121,121,121,121,121,121,121,124,130,136,144,155,168,184,202,186,168,148,129,107,84,63,41,18,0,0,5,27,53,78,104,129,154,180,205,182,157,132,106,81,93,115,138,160,181,187,165,143,121,99,76,86,111,138,162,187,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,200,179,163,157,168,185,193,177,170,174,188,198,177,156,135,113,91,71,50,28,7,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,212,195,181,177,177,177,177,177,177,177,180,180,183,188,166,147,139,134,124,116,106,93,80,64,47,30,11,0,0,0,0,0,0,0,0,0,0,22,45,69,92,114,139,161,184,189,165,142,117,95,71,49,53,76,100,121,147,170,193,184,160,138,114,91,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,205,188,173,170,170,170,170,170,170,170,172,176,182,189,195,185,174,162,147,132,112,94,75,55,35,13,0,0,0,0,5,30,53,78,104,129,154,180,205,196,173,155,149,149,149,149,149,149,149,152,154,160,167,177,189,197,183,168,152,134,113,93,73,51,30,8,0,0,5,27,53,78,104,129,154,180,205,182,157,134,106,81,81,104,124,148,170,191,177,155,134,110,89,86,111,137,162,187,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,215,197,186,182,189,196,177,158,144,154,173,194,189,169,147,124,105,83,62,41,21,0,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,201,178,161,154,154,154,154,154,154,154,154,156,160,164,171,169,164,158,150,140,129,114,98,82,64,45,26,6,0,0,0,0,0,0,0,0,8,30,53,76,99,121,146,169,192,182,158,136,111,88,65,55,55,69,93,116,140,163,187,192,168,146,121,98,75,53,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,218,203,192,190,190,190,190,190,190,192,198,201,206,190,172,162,153,140,129,110,95,78,58,40,21,0,0,0,0,0,5,30,53,78,104,129,154,180,205,208,190,178,175,175,175,175,175,175,175,175,179,184,191,194,185,174,163,148,134,116,96,78,58,38,17,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,106,83,70,91,113,136,157,179,189,167,146,123,101,85,109,137,160,185,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,228,219,210,208,199,180,161,143,121,140,161,182,202,181,160,139,117,96,75,54,33,12,0,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,129,129,129,129,129,129,129,129,132,135,140,147,157,169,182,173,163,149,135,116,98,80,59,39,17,0,0,0,0,0,0,0,0,15,38,61,84,107,132,154,176,198,175,152,129,104,81,78,78,78,78,86,109,134,156,180,199,176,153,130,106,83,61,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,203,184,169,165,165,165,165,165,165,169,184,203,204,179,156,139,130,117,105,92,76,60,42,24,6,0,0,0,0,0,5,30,53,78,104,129,154,180,205,216,201,190,187,187,187,187,187,187,187,187,184,180,176,170,162,152,141,129,113,96,80,62,44,24,4,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,79,101,121,145,167,189,179,158,137,114,91,108,134,160,184,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,228,240,222,202,184,164,146,124,107,129,148,170,191,194,172,152,132,108,88,66,46,24,4,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,101,101,101,101,101,101,103,105,109,115,123,136,148,164,182,184,169,153,135,114,93,72,50,28,6,0,0,0,0,0,0,0,23,45,69,91,114,139,162,184,191,168,144,121,104,104,104,104,104,104,104,104,124,150,173,196,184,161,138,114,91,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,194,170,148,139,139,139,139,139,139,148,169,190,201,178,154,132,109,96,83,71,56,41,24,8,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,202,182,166,162,162,162,162,162,162,162,162,160,155,152,146,138,129,117,106,92,78,62,44,27,8,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,67,89,110,134,155,177,191,171,148,124,101,106,132,157,182,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,228,225,206,187,168,149,130,109,92,114,136,157,178,199,185,164,144,121,100,79,58,37,16,0,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,76,76,76,76,76,78,80,85,91,100,113,130,148,167,189,188,168,148,129,105,82,60,36,14,0,0,0,0,0,0,8,30,53,77,99,121,146,169,192,190,165,143,132,132,132,132,132,132,132,132,132,132,147,170,195,192,168,145,121,98,76,53,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,111,111,111,111,112,135,156,179,199,187,165,144,121,100,79,57,37,22,6,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,194,169,147,137,137,137,137,137,137,137,137,134,132,124,119,114,105,95,84,72,57,43,26,10,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,55,76,98,119,143,165,187,181,158,137,113,104,132,154,180,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,228,209,190,171,152,134,113,94,80,101,121,145,166,187,198,177,156,135,113,92,71,50,29,8,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,50,50,50,50,53,55,61,68,79,94,112,135,156,179,201,181,160,137,114,90,67,44,20,0,0,0,0,0,0,15,38,61,84,107,132,154,177,200,197,175,161,157,157,157,157,157,157,157,157,157,157,163,179,202,199,176,153,132,106,83,61,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,88,88,88,100,121,145,166,188,199,178,156,136,113,91,70,48,27,6,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,111,111,111,111,111,109,109,107,105,101,96,90,81,72,62,50,37,23,8,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,43,64,86,108,132,153,174,192,170,147,123,101,129,152,177,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,213,193,174,155,137,116,98,78,67,89,109,132,154,174,196,190,169,147,124,105,83,63,41,21,0,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,48,25,25,25,27,31,36,45,59,79,101,124,148,172,196,191,167,144,119,96,72,48,24,0,0,0,0,0,0,23,45,69,92,114,139,161,184,208,206,194,184,182,182,182,182,182,182,182,182,182,182,186,197,209,207,184,161,138,114,91,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,63,67,88,109,132,154,175,197,190,169,148,124,104,82,61,39,18,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,86,86,86,86,86,83,83,80,77,72,65,58,49,39,28,16,2,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,33,53,74,96,117,140,162,184,180,158,136,112,124,150,175,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,200,178,159,140,119,101,82,63,55,76,98,118,141,162,183,203,181,161,139,117,96,75,54,33,12,0,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,48,22,0,2,2,6,12,25,48,72,96,119,144,170,193,196,172,148,121,99,73,50,25,0,0,0,0,0,8,30,53,76,99,121,147,169,192,197,182,177,177,177,177,177,177,177,177,177,177,177,177,177,178,186,200,192,168,146,121,98,76,53,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,55,76,98,119,143,164,186,203,181,160,139,116,95,73,51,31,9,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,60,60,60,60,60,58,55,52,47,42,34,26,16,6,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,33,40,62,83,105,129,150,172,191,169,146,123,121,147,172,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,145,123,104,85,67,47,43,64,85,106,129,149,171,191,194,173,152,132,109,88,67,46,24,4,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,48,22,0,0,0,0,0,22,47,71,93,119,144,170,193,198,172,149,121,99,73,50,25,0,0,0,0,0,15,38,61,84,107,132,154,176,200,180,161,152,152,152,152,152,152,152,152,152,152,152,152,152,152,166,186,200,176,153,130,106,83,61,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,42,64,86,107,130,152,173,195,194,172,150,130,107,86,64,43,22,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,35,35,35,35,33,31,27,23,17,11,3,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,33,28,50,72,93,115,138,160,181,180,157,135,119,147,170,195,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,69,51,31,30,51,73,93,115,137,158,179,200,186,165,144,121,100,79,58,37,17,0,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,48,22,2,4,6,10,17,30,52,75,98,121,147,170,194,197,172,149,121,99,73,50,25,0,0,0,0,0,23,45,69,92,114,139,162,184,194,172,148,124,124,124,124,124,124,124,124,124,124,124,124,124,132,154,178,200,184,161,138,114,91,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,31,53,74,96,117,140,162,183,205,184,163,141,119,98,76,55,34,13,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,17,10,10,10,9,6,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,33,16,38,59,81,103,124,147,170,190,167,146,121,144,169,193,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,18,39,60,81,103,123,146,167,188,198,177,156,136,113,92,71,50,29,8,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,48,27,27,29,31,34,41,50,65,84,106,129,152,175,199,193,169,145,119,96,73,49,25,0,0,0,0,8,30,53,77,99,121,146,169,192,188,165,141,117,99,99,99,99,99,99,99,99,99,99,99,100,123,147,171,194,192,168,146,121,98,76,53,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,19,40,62,83,105,129,149,171,192,197,175,154,134,110,89,67,47,25,3,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,33,7,25,47,69,91,113,136,157,179,179,156,138,147,168,193,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,5,27,48,69,90,110,134,155,175,197,190,169,148,124,105,84,63,42,21,0,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,71,53,53,53,53,55,59,65,73,84,99,117,140,161,183,205,186,163,140,116,93,69,45,22,0,0,0,0,15,38,61,84,107,132,154,177,200,180,158,134,110,87,73,73,73,73,73,73,73,73,73,73,93,116,140,163,187,199,176,153,132,106,83,61,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,17,28,50,72,93,114,137,160,181,202,188,166,146,123,101,80,59,38,16,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,33,7,14,35,57,79,100,121,145,167,189,172,162,166,181,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,14,35,57,78,99,119,143,163,184,203,181,161,139,117,97,75,55,33,12,0,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,96,78,78,78,78,78,81,83,89,96,106,119,136,154,173,194,197,177,154,132,109,86,63,40,16,0,0,0,0,23,45,69,92,114,139,162,184,197,174,151,129,103,80,57,48,48,48,48,48,48,48,48,63,86,109,134,157,180,203,184,161,138,114,91,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,17,16,38,59,81,103,124,147,169,190,200,179,158,137,114,92,72,50,28,7,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,33,7,2,23,45,67,89,110,134,155,177,194,188,190,200,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,2,23,44,65,86,108,130,150,172,193,194,173,152,132,109,88,67,46,25,4,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,119,104,104,104,104,104,104,106,109,113,119,130,141,155,171,188,201,182,163,143,121,99,77,55,33,9,0,0,0,8,30,53,77,99,121,147,169,192,190,167,144,119,97,73,50,27,25,25,25,25,25,25,33,56,79,102,124,150,173,196,192,168,146,121,98,76,53,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,17,4,25,48,69,90,112,136,157,178,200,191,170,149,129,105,83,62,41,20,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,33,7,0,11,33,55,76,98,119,143,165,186,208,215,222,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,0,11,32,53,74,95,116,139,160,181,202,186,165,144,121,100,80,59,38,17,0,0,0,7,30,55,78,104,129,154,177,203,195,170,147,132,132,132,132,132,132,132,132,134,139,144,152,163,174,189,197,182,166,148,130,108,88,66,45,23,0,0,0,0,15,38,61,84,107,132,154,177,200,183,160,137,113,90,66,43,20,0,0,0,0,0,3,26,49,72,96,118,143,166,189,200,176,153,132,106,83,61,37,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,66,43,17,0,14,36,57,79,100,121,145,166,188,204,182,161,140,117,96,74,53,32,11,0,0,5,30,53,78,104,129,154,180,205,193,167,144,116,91,68,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,185,160,134,109,83,58,33,7,0,0,21,43,64,86,107,132,153,174,196,217,223,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,0,0,20,41,62,83,104,124,147,169,190,198,177,156,136,113,92,72,50,29,8,0,0,7,30,55,78,104,129,154,177,203,202,179,163,157,157,157,157,157,157])
.concat([157,157,160,163,168,176,185,196,189,177,163,148,132,112,94,74,54,33,12,0,0,0,0,23,46,69,92,114,139,162,184,199,176,153,130,106,83,59,36,12,0,0,0,0,0,0,19,42,65,89,111,137,159,183,205,184,161,138,114,91,68,45,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,200,193,167,144,116,91,66,43,17,0,2,23,45,66,88,110,132,154,176,198,195,174,152,132,108,87,65,45,23,1,0,5,30,53,78,104,129,154,180,200,193,167,144,116,91,68,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,200,185,160,134,109,83,58,33,7,0,0,9,31,53,74,96,117,140,162,183,200,200,198,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,180,200,193,170,144,119,93,68,45,20,0,0,0,7,28,49,71,91,113,136,156,177,198,190,169,148,124,105,84,63,42,21,0,0,7,30,55,78,104,129,154,177,200,200,197,186,182,182,182,182,182,182,182,182,183,188,192,189,184,176,166,155,143,129,112,96,78,59,40,21,0,0,0,0,8,30,53,77,99,121,147,169,192,192,169,146,121,98,76,53,29,6,0,0,0,0,0,0,12,36,58,82,105,129,152,176,199,192,169,146,121,99,76,53,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,175,175,175,167,144,116,91,66,43,17,0,0,12,33,55,76,98,119,143,164,175,175,175,164,144,121,99,78,57,35,13,0,5,30,53,78,104,129,154,175,175,175,167,144,116,91,68,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,175,175,175,160,134,109,83,58,33,7,0,0,0,19,40,62,83,105,129,150,172,175,175,175,175,149,121,96,71,48,22,0,5,30,55,78,104,129,154,175,175,175,170,144,119,93,68,45,20,0,0,0,0,16,37,58,79,100,121,144,165,175,175,175,161,139,117,97,75,55,33,11,0,7,30,55,78,104,129,154,175,175,175,175,175,175,175,175,175,175,175,175,175,175,172,170,165,160,152,144,134,121,107,92,78,60,44,25,6,0,0,0,0,15,38,61,84,107,132,154,175,175,175,163,139,115,92,69,45,22,0,0,0,0,0,0,0,5,28,51,75,98,121,145,168,175,175,175,153,132,106,83,61,37,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,149,149,149,149,149,144,116,91,66,43,17,0,0,0,21,42,64,86,107,130,149,149,149,149,149,149,135,112,90,68,45,20,0,5,30,53,78,104,129,149,149,149,149,149,144,116,91,68,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,149,149,149,149,149,134,109,83,58,33,7,0,0,0,7,28,50,72,93,115,138,149,149,149,149,149,149,121,96,71,48,22,0,5,30,55,78,104,129,149,149,149,149,149,144,119,93,68,45,20,0,0,0,0,4,24,46,67,88,109,132,149,149,149,149,149,149,132,109,88,65,43,18,0,7,30,55,78,104,129,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,147,144,140,136,129,119,109,99,87,74,58,42,26,8,0,0,0,0,0,21,46,69,92,114,139,149,149,149,149,149,132,109,85,62,38,16,0,0,0,0,0,0,0,0,22,45,68,91,114,139,149,149,149,149,149,138,114,91,68,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,30,53,78,103,121,121,121,121,121,121,121,115,91,65,43,17,0,0,0,9,31,52,74,96,117,121,121,121,121,121,121,121,119,96,70,45,22,0,4,30,53,78,103,121,121,121,121,121,121,121,115,91,68,43,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,53,78,103,121,121,121,121,121,121,121,108,83,58,32,7,0,0,0,0,16,38,59,81,103,121,121,121,121,121,121,121,119,96,70,48,22,0,4,30,55,78,103,121,121,121,121,121,121,121,117,93,68,45,20,0,0,0,0,0,12,33,54,75,97,117,121,121,121,121,121,121,121,115,93,68,45,20,0,7,30,55,78,103,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,118,114,109,103,96,87,76,65,52,38,24,8,0,0,0,0,0,0,22,48,70,96,117,121,121,121,121,121,121,121,101,78,55,32,9,0,0,0,0,0,0,0,0,15,37,61,84,107,121,121,121,121,121,121,121,117,96,70,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,26,48,71,90,99,99,99,99,99,99,99,97,81,59,38,14,0,0,0,0,19,40,62,82,97,99,99,99,99,99,99,99,98,85,66,43,19,0,1,26,48,71,90,99,99,99,99,99,99,99,97,81,62,38,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,48,71,90,99,99,99,99,99,99,99,93,75,52,28,4,0,0,0,0,4,25,47,69,89,99,99,99,99,99,99,99,98,85,64,43,19,0,1,26,50,71,90,99,99,99,99,99,99,99,98,83,62,41,16,0,0,0,0,0,0,21,42,63,83,97,99,99,99,99,99,99,99,98,83,64,41,19,0,4,26,50,71,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,96,93,90,86,80,73,64,54,44,31,18,4,0,0,0,0,0,0,0,21,43,66,85,98,99,99,99,99,99,99,98,89,69,48,24,2,0,0,0,0,0,0,0,0,8,31,53,75,92,99,99,99,99,99,99,99,98,85,64,43,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,36,55,68,73,73,73,73,73,73,73,72,62,45,27,5,0,0,0,0,7,28,47,64,72,73,73,73,73,73,73,73,73,65,51,31,9,0,0,16,36,55,68,73,73,73,73,73,73,73,72,62,47,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,55,68,73,73,73,73,73,73,73,70,58,40,18,0,0,0,0,0,0,14,34,53,67,73,73,73,73,73,73,73,73,65,49,31,9,0,0,16,38,55,68,73,73,73,73,73,73,73,73,64,47,29,7,0,0,0,0,0,0,8,29,47,64,72,73,73,73,73,73,73,73,73,64,49,29,9,0,0,16,38,55,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,71,69,65,61,56,49,41,31,21,9,0,0,0,0,0,0,0,0,0,12,31,51,65,73,73,73,73,73,73,73,73,67,53,36,14,0,0,0,0,0,0,0,0,0,0,21,40,58,69,73,73,73,73,73,73,73,73,65,49,31,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,19,34,45,48,48,48,48,48,48,48,47,40,27,11,0,0,0,0,0,0,12,28,41,47,48,48,48,48,48,48,48,48,42,30,15,0,0,0,2,19,34,45,48,48,48,48,48,48,48,47,40,28,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,34,45,48,48,48,48,48,48,48,46,37,22,4,0,0,0,0,0,0,0,17,33,44,48,48,48,48,48,48,48,48,42,30,15,0,0,0,2,20,34,45,48,48,48,48,48,48,48,47,41,28,13,0,0,0,0,0,0,0,0,13,28,41,47,48,48,48,48,48,48,48,47,41,30,13,0,0,0,2,20,34,45,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,46,44,40,36,31,24,17,8,0,0,0,0,0,0,0,0,0,0,0,0,15,31,42,48,48,48,48,48,48,48,48,44,33,19,0,0,0,0,0,0,0,0,0,0,0,6,22,37,45,48,48,48,48,48,48,48,47,42,30,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,20,22,22,22,22,22,22,22,22,16,6,0,0,0,0,0,0,0,0,7,17,22,22,22,22,22,22,22,22,22,18,8,0,0,0,0,0,0,12,20,22,22,22,22,22,22,22,22,16,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,20,22,22,22,22,22,22,22,21,14,2,0,0,0,0,0,0,0,0,0,11,19,22,22,22,22,22,22,22,22,18,8,0,0,0,0,0,0,12,20,22,22,22,22,22,22,22,22,17,7,0,0,0,0,0,0,0,0,0,0,7,17,22,22,22,22,22,22,22,22,22,17,8,0,0,0,0,0,0,12,20,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,19,16,12,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,18,22,22,22,22,22,22,22,22,19,11,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,20,22,22,22,22,22,22,22,22,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,22,25,25,25,25,25,25,25,25,23,15,2,0,0,0,0,0,0,0,0,0,0,0,0,5,16,23,25,25,25,25,25,25,25,25,20,12,0,0,0,0,0,7,16,22,25,25,25,25,25,25,25,25,25,22,15,5,0,0,0,0,1,13,22,25,25,25,25,25,25,25,25,20,11,0,0,0,0,0,0,0,0,0,0,11,20,25,25,25,25,25,25,25,25,21,12,0,0,0,0,0,1,13,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,20,12,0,0,0,0,0,1,14,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,23,16,4,0,0,0,0,0,1,13,22,25,25,25,25,25,25,25,25,25,25,25,25,22,22,20,17,13,8,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,18,22,22,22,22,22,22,22,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,34,45,50,50,50,50,50,50,50,50,47,38,22,4,0,0,0,0,0,0,0,0,0,0,6,24,39,48,50,50,50,50,50,50,50,50,44,32,15,0,0,0,13,27,38,47,50,50,50,50,50,50,50,50,50,46,36,24,10,0,0,2,20,35,45,50,50,50,50,50,50,50,50,42,30,13,0,0,0,0,0,0,0,0,15,32,43,50,50,50,50,50,50,50,50,45,33,19,0,0,0,2,20,34,45,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,44,32,17,0,0,0,4,20,35,45,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,48,38,24,6,0,0,0,4,20,35,45,50,50,50,50,50,50,50,50,50,50,50,49,48,47,45,42,37,32,26,20,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,31,42,48,48,48,48,48,48,47,42,30,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,55,68,73,73,73,73,73,73,73,73,70,58,40,18,0,0,0,0,0,0,0,0,0,0,21,42,59,71,73,73,73,73,73,73,73,73,66,51,31,9,0,12,29,45,59,69,73,73,73,73,73,73,73,73,73,67,56,42,25,0,0,16,38,55,68,73,73,73,73,73,73,73,73,64,49,29,9,0,0,0,0,0,0,12,31,51,65,73,73,73,73,73,73,73,73,66,51,33,12,0,0,16,38,55,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,65,51,31,12,0,0,18,38,56,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,70,58,42,21,0,0,0,18,38,56,68,73,73,73,73,73,73,73,73,73,73,73,73,73,72,69,66,62,57,50,43,35,26,16,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,31,51,65,73,73,73,73,73,73,73,65,49,31,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,48,71,90,99,99,99,99,99,99,99,99,93,75,53,30,7,0,0,0,0,0,0,0,0,9,33,55,77,95,99,99,99,99,99,99,99,98,87,66,43,19,0,21,41,59,77,92,99,99,99,99,99,99,99,99,98,89,73,55,36,0,4,26,50,71,90,99,99,99,99,99,99,99,98,83,64,41,19,0,0,0,0,0,0,21,43,66,85,98,99,99,99,99,99,99,98,87,66,45,21,0,1,26,50,71,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,85,66,43,21,0,4,28,50,73,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,93,75,55,31,9,0,4,28,50,73,90,99,99,99,99,99,99,99,99,99,99,99,99,99,96,93,91,86,81,74,67,58,49,38,27,14,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,43,66,85,98,99,99,99,99,99,98,85,64,43,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,103,124,124,124,124,124,124,124,124,109,85,61,38,15,0,0,0,0,0,0,0,0,17,41,64,88,111,124,124,124,124,124,124,124,121,98,73,48,22,0,25,45,65,86,106,124,124,124,124,124,124,124,124,121,101,81,60,40,0,7,30,55,78,103,124,124,124,124,124,124,124,118,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,124,124,124,124,124,124,121,98,73,50,25,0,5,30,55,78,103,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,121,96,73,48,25,0,7,32,55,81,103,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,109,83,60,35,12,0,7,32,55,81,103,124,124,124,124,124,124,124,124,124,124,124,124,124,121,119,115,111,106,98,90,81,72,61,49,36,21,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,48,73,96,121,124,124,124,124,124,118,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,152,152,152,152,152,152,141,117,93,70,47,24,0,0,0,0,0,0,0,3,26,49,73,96,119,144,152,152,152,152,152,149,121,99,73,48,22,0,25,45,66,86,106,129,152,152,152,152,152,152,147,121,101,81,60,40,0,7,30,55,78,104,129,152,152,152,152,152,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,152,152,152,152,149,121,99,73,50,25,0,5,30,55,78,104,129,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,149,121,96,73,48,25,0,7,33,55,81,104,129,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,134,109,83,60,35,12,0,7,33,55,81,104,129,152,152,152,152,152,152,152,152,152,152,152,151,148,146,142,137,132,121,114,105,93,82,69,56,42,26,10,0,0,0,0,0,0,0,0,0,0,0,0,3,27,51,76,99,124,149,152,152,152,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,177,177,177,177,173,150,124,102,79,56,33,9,0,0,0,0,0,0,11,34,57,81,105,129,152,176,177,177,177,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,177,177,177,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,177,177,177,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,177,177,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,172,149,121,96,73,48,25,0,7,33,55,81,104,129,154,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,160,134,109,83,60,35,12,0,7,33,55,81,104,129,154,177,177,177,177,177,177,177,177,177,177,175,173,170,166,161,155,147,138,129,116,104,90,76,61,45,28,11,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,101,129,152,175,177,172,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,203,203,203,181,158,136,111,87,64,41,18,0,0,0,0,0,0,20,43,66,90,113,137,160,184,203,203,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,203,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,203,203,195,193,193,193,193,193,193,193,193,193,193,193,193,193,193,172,149,121,96,73,48,25,0,7,33,55,81,104,129,154,177,203,203,203,196,193,193,193,193,193,193,193,193,193,193,193,193,193,193,182,160,134,109,83,60,35,12,0,7,33,55,81,104,129,154,177,203,203,203,191,187,187,187,187,187,188,191,195,190,185,178,170,161,150,139,124,110,95,80,64,46,28,9,0,0,0,0,0,0,0,0,0,1,8,32,56,81,104,132,154,178,195,172,147,119,96,71,48,22,10,10,10,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,228,213,190,167,144,119,96,73,49,26,3,0,0,0,0,4,28,51,74,98,121,146,169,192,216,226,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,205,186,171,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,149,121,96,73,48,25,0,7,33,55,81,104,129,154,177,203,206,188,173,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,160,134,109,83,60,35,12,0,7,33,55,81,104,129,154,177,203,204,184,167,162,162,162,162,162,165,167,172,178,186,195,193,183,172,160,146,132,114,98,80,62,44,24,5,0,0,0,0,0,0,5,16,25,29,35,58,83,106,134,157,180,195,172,147,119,96,71,48,35,35,35,35,32,22,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,217,211,199,176,152,129,105,81,58,35,12,0,0,0,0,12,36,60,82,106,132,154,177,200,211,219,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,195,172,150,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,121,96,73,48,25,0,7,33,55,81,104,129,154,177,203,197,175,154,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,134,109,83,60,35,12,0,7,33,55,81,104,129,154,177,203,196,172,149,137,137,137,137,137,139,143,147,155,163,173,184,197,194,180,166,150,134,114,96,78,58,38,18,0,0,0,0,0,5,24,38,49,53,55,61,86,109,136,160,183,195,172,147,119,96,71,60,60,60,60,60,56,43,28,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,194,185,189,184,161,138,113,90,67,44,20,0,0,0,0,21,45,68,91,114,139,163,186,186,187,196,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,113,93,72,47,24,0,7,33,55,81,104,129,154,177,203,195,172,147,121,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,105,81,59,34,11,0,7,33,55,81,104,129,154,177,203,195,170,147,119,109,109,109,110,113,116,121,132,140,150,163,177,193,200,184,168,150,132,112,92,72,51,31,9,0,0,0,0,19,39,58,72,78,81,81,88,111,139,162,185,195,172,147,119,96,86,86,86,86,86,86,79,62,42,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,193,173,163,165,180,170,147,121,98,75,52,29,5,0,0,6,29,53,76,99,123,147,171,175,163,164,179,197,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,78,61,39,18,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,84,69,50,27,6,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,83,83,86,88,93,98,106,116,129,143,157,175,191,203,186,166,147,129,106,84,64,42,21,0,0,0,4,27,51,73,92,104,106,106,109,114,141,165,188,195,172,147,119,111,111,111,111,111,111,111,97,75,51,26,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,183,159,139,145,167,178,155,132,107,84,61,37,14,0,0,14,38,61,85,108,132,156,180,161,141,143,166,191,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,63,63,63,63,63,63,63,63,63,63,63,63,63,63,56,44,25,7,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,63,63,63,63,63,63,63,63,63,63,63,63,63,63,61,50,35,15,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,58,60,63,68,74,83,94,107,121,139,157,175,195,201,181,161,140,117,97,75,53,30,8,0,0,7,30,55,78,104,129,132,134,136,137,146,169,191,196,173,150,137,137,137,137,137,137,137,129,101,78,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,183,160,134,135,158,181,163,140,116,93,69,46,22,0,0,23,46,70,93,116,141,164,176,153,130,139,165,190,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,40,40,40,40,40,40,40,40,40,40,40,40,40,35,24,10,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,50,40,40,40,40,40,40,40,40,40,40,40,40,40,38,29,16,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,35,38,43,50,61,73,87,103,121,141,161,181,203,194,173,152,130,106,84,62,40,17,0,0,7,30,55,78,104,129,154,160,160,162,166,181,201,205,184,167,162,162,162,162,162,162,152,129,101,78,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,185,160,137,124,150,173,172,148,124,101,78,55,31,8,8,31,55,78,101,124,149,172,168,144,119,142,167,191,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,5,5,5,5,5,5,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,15,15,15,15,15,15,15,15,15,15,15,15,11,2,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,50,25,15,15,15,15,15,15,15,15,15,15,15,15,13,7,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,14,19,28,38,53,69,87,106,129,148,170,191,206,184,162,139,116,93,70,47,24,1,0,7,30,55,78,104,129,154,180,185,187,190,200,216,220,203,191,187,187,187,187,187,177,152,129,101,78,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,187,162,137,117,142,165,181,157,134,109,87,63,40,16,16,40,63,87,109,134,157,181,160,137,118,144,170,194,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,27,27,27,27,27,27,27,27,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,50,25,25,25,25,25,25,25,25,25,25,25,20,11,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,5,18,34,52,72,92,114,137,159,181,204,193,171,147,123,101,77,54,31,8,0,7,30,55,78,104,129,154,170,170,170,177,193,212,209,189,174,170,170,170,170,170,170,152,129,101,78,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,190,165,139,114,134,157,180,166,143,118,95,72,49,25,24,48,72,95,118,143,166,175,152,129,119,147,172,196,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,53,53,53,53,53,53,53,53,53,53,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,25,25,25,25,25,25,25,25,25,25,24,18,7,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,50,50,50,50,50,50,50,50,50,50,50,50,43,32,17,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,18,38,60,81,105,129,151,173,197,200,178,155,132,107,83,60,37,13,0,7,30,55,78,104,129,144,144,144,144,158,179,202,198,176,155,144,144,144,144,144,144,144,129,101,78,53,27,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,192,167,142,116,124,149,172,174,151,129,104,81,57,33,33,57,80,103,129,151,174,166,143,118,121,149,175,198,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,78,78,78,78,78,78,78,78,78,78,78,78,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,50,50,50,50,50,50,50,50,50,50,50,49,41,27,10,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,76,76,76,76,76,76,76,76,76,76,76,76,75,66,51,31,11,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,6,28,51,73,96,119,144,167,191,207,183,160,137,111,88,65,41,17,0,7,29,55,77,101,118,119,119,119,124,152,175,200,195,172,147,119,119,119,119,119,119,119,118,100,77,52,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,194,170,144,117,116,140,164,183,160,137,113,89,65,42,41,65,89,112,137,160,182,158,135,110,124,152,176,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,104,104,104,104,104,104,104,104,104,104,104,104,104,104,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,76,76,76,76,76,76,76,76,76,76,76,76,73,61,45,25,4,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,101,101,101,101,101,101,101,101,101,101,101,101,101,99,85,65,43,19,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,0,20,43,67,90,114,139,162,185,209,188,165,142,116,93,68,45,21,0,2,24,47,68,86,93,93,93,101,124,152,175,200,195,172,147,119,96,93,93,93,93,93,93,85,67,46,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,196,172,147,119,108,132,156,180,168,145,121,98,74,51,49,73,97,119,144,168,173,150,124,102,129,154,178,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,147,173,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,101,101,101,101,101,101,101,101,101,101,101,101,101,97,79,58,36,11,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,129,129,129,129,129,129,129,129,129,129,129,129,129,129,118,96,71,48,22,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,0,14,38,62,86,109,134,157,182,205,192,168,144,119,96,71,48,23,0,0,14,34,51,64,68,68,76,101,124,152,175,200,195,172,147,119,96,71,68,68,68,68,68,63,49,32,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,198,173,149,121,100,123,147,172,177,154,132,106,82,59,58,81,105,130,153,176,165,141,116,104,132,155,180,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,202,179,163,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,163,181,202,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,129,129,129,129,129,129,129,129,129,129,129,129,129,129,111,88,63,40,15,0,0,0,7,33,55,81,104,129,154,177,203,201,180,161,154,154,154,154,154,154,154,154,154,154,154,154,154,144,119,96,71,48,22,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,0,10,35,58,83,106,132,155,180,203,195,170,147,121,98,73,50,25,0,0,0,17,30,40,43,50,76,101,124,152,175,200,195,172,147,119,96,71,48,43,43,43,43,39,28,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,200,175,150,124,99,114,139,162,185,163,139,115,91,68,66,90,114,138,161,179,155,132,108,106,132,157,182,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,215,197,186,182,182,182,182,182,182,182,182,182,182,182,182,182,182,182,182,186,199,215,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,198,177,159,152,152,152,152,152,152,152,152,152,152,152,152,152,139,111,88,63,40,15,0,0,0,7,33,55,81,104,129,154,177,203,213,195,182,177,177,177,177,177,177,177,177,177,177,177,177,170,144,119,96,71,48,22,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,0,8,33,55,81,104,132,154,178,203,197,172,149,121,99,73,50,26,0,0,0,0,7,15,27,50,76,101,124,152,175,200,195,172,147,119,96,71,48,22,17,17,17,14,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,202,177,152,124,101,106,130,153,177,171,148,123,100,77,77,100,121,147,170,170,147,121,99,106,134,160,183,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,222,205,196,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,196,207,223,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,211,193,181,177,177,177,177,177,177,177,177,177,177,177,177,165,139,111,88,63,40,15,0,0,0,7,33,55,81,104,129,154,177,203,222,205,194,190,190,190,190,190,190,190,190,190,190,190,190,170,144,119,96,71,48,22,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,0,7,32,55,79,104,129,154,177,203,198,172,149,121,99,76,50,27,0,0,0,0,0,2,27,50,76,101,124,152,175,200,195,172,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,203,177,153,129,101,97,119,145,168,180,156,134,108,85,85,108,132,156,179,161,138,114,90,106,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,206,186,172,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,173,188,208,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,220,205,195,193,193,193,193,193,193,193,193,193,193,193,187,165,139,111,88,63,40,15,0,0,0,7,33,55,81,104,129,154,177,203,206,188,172,167,167,167,167,167,167,167,167,167,167,167,167,167,144,119,96,71,48,22,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,0,7,32,55,79,104,129,154,177,203,198,172,149,121,99,76,50,27,0,0,0,0,0,2,27,50,76,101,124,152,175,200,195,172,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,203,180,154,129,101,88,111,136,160,182,164,141,116,93,93,116,140,164,176,152,129,105,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,197,173,152,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,154,176,197,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,204,186,171,167,167,167,167,167,167,167,167,167,167,167,167,165,139,111,88,63,40,15,0,0,0,7,33,55,81,104,129,154,177,203,197,175,152,142,142,142,142,142,142,142,142,142,142,142,142,142,142,119,96,71,48,22,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,0,9,33,57,81,104,132,154,178,203,196,172,149,121,99,73,50,25,0,0,0,0,0,2,27,50,76,101,124,152,175,200,195,172,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,79,102,124,150,173,173,149,124,101,100,124,148,172,167,144,119,96,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,116,116,116,116,116,116,116,116,116,116,116,116,116,116,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,194,172,150,142,142,142,142,142,142,142,142,142,142,142,142,142,139,111,88,63,40,15,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,114,114,114,114,114,114,114,114,114,114,114,114,114,112,92,69,47,22,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,0,11,35,59,83,106,132,157,180,204,193,170,147,121,96,73,50,25,0,0,0,0,0,2,27,50,76,101,124,152,175,200,195,172,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,93,117,141,164,181,157,134,109,108,134,156,180,158,135,110,87,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,91,91,91,91,91,91,91,91,91,91,91,91,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,114,114,114,114,114,114,114,114,114,114,114,114,114,107,86,62,39,14,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,88,88,88,88,88,88,88,88,88,88,88,88,88,78,59,39,16,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,0,16,40,63,87,110,137,160,183,206,191,167,144,118,93,71,47,22,0,0,0,0,0,2,27,50,76,101,124,152,175,200,195,172,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,85,108,132,155,179,165,142,117,116,141,164,172,149,124,101,78,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,66,66,66,66,66,66,66,66,66,66,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,88,88,88,88,88,88,88,88,88,88,88,88,85,73,52,32,8,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,63,63,63,63,63,63,63,63,63,63,63,63,56,42,25,5,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,0,21,45,68,92,114,139,163,187,210,186,163,139,114,91,68,44,20,0,0,0,0,0,2,27,50,76,101,124,152,175,200,195,172,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,76,99,123,147,170,174,150,124,124,149,172,163,140,116,93,69,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,40,40,40,40,40,40,40,40,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,63,63,63,63,63,63,63,63,63,63,63,61,52,37,19,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,50,38,38,38,38,38,38,38,38,38,38,37,33,21,8,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,0,8,30,53,75,98,121,146,168,192,205,181,158,135,109,86,63,39,15,0,0,0,0,0,2,27,50,76,101,124,152,175,200,195,172,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,67,91,114,138,161,182,158,135,134,157,178,155,132,107,84,61,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,15,15,15,15,15,15,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,38,38,38,38,38,38,38,38,38,38,36,30,17,3,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,50,25,12,12,12,12,12,12,12,12,12,12,8,0,0,0,0,0,0,0,7,33,55])
.concat([81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,0,2,21,41,63,84,106,130,153,176,198,197,175,152,129,105,81,58,34,11,0,0,0,0,0,2,27,50,76,101,124,152,175,200,195,172,147,119,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,58,82,105,129,152,176,168,150,149,167,169,146,121,98,75,58,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,15,15,15,15,15,15,15,15,15,14,8,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,50,25,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,0,0,6,20,36,55,75,95,116,139,161,184,206,189,167,144,119,98,74,51,28,5,0,0,0,0,0,2,27,50,76,101,124,152,175,200,195,172,147,121,96,71,48,22,14,19,20,16,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,53,73,97,119,144,167,184,174,173,184,160,137,113,90,66,58,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,50,25,15,15,15,15,15,15,15,15,15,15,15,15,15,11,3,0,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,25,14,20,29,40,55,71,89,108,130,150,172,194,202,180,158,136,112,90,67,44,21,0,0,0,0,0,0,2,27,50,76,99,124,150,175,198,195,172,147,121,98,74,50,33,38,44,45,40,28,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,53,65,88,110,135,158,181,198,198,175,152,129,104,81,57,58,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,50,40,40,40,40,40,40,40,40,40,40,40,40,40,40,35,25,11,0,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,48,36,39,44,51,62,74,89,105,123,144,163,184,205,190,170,148,124,103,81,58,36,13,0,0,0,0,0,0,1,25,50,73,99,121,147,172,196,199,175,152,129,104,81,62,58,62,69,70,63,47,30,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,53,56,79,101,124,149,173,196,189,166,143,118,95,72,49,58,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,73,66,66,66,66,66,66,66,66,66,66,66,66,66,66,65,58,45,29,8,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,73,60,60,64,69,75,84,95,109,123,141,159,177,197,198,177,158,137,114,92,71,49,27,4,0,0,0,0,0,0,0,23,47,71,96,119,144,168,191,204,182,159,137,114,96,85,83,86,93,95,83,63,42,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,53,47,70,93,116,140,164,187,180,157,134,109,86,64,40,58,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,99,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,80,62,41,19,0,7,33,55,81,104,129,154,177,203,195,170,147,119,96,83,85,86,88,93,99,107,117,130,144,159,177,193,200,182,163,144,123,103,81,59,38,16,0,0,0,0,0,0,0,0,19,43,67,91,114,139,162,185,207,191,170,150,132,117,109,108,111,116,117,96,72,49,25,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,53,38,61,84,107,132,155,178,172,148,124,101,77,55,33,58,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,195,172,147,121,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,113,96,72,49,24,0,7,33,55,81,104,129,154,177,203,195,170,147,119,109,109,109,111,114,117,123,132,141,152,165,179,195,198,182,166,148,130,109,88,69,48,27,5,0,0,0,0,0,0,0,0,14,37,61,84,106,132,153,174,196,204,184,168,152,141,137,134,137,142,124,101,78,54,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,53,29,52,75,98,121,147,165,163,139,115,92,69,46,33,58,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,197,175,154,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,121,99,73,50,25,0,7,33,55,81,104,129,154,177,203,196,172,149,137,137,137,137,138,139,144,148,155,164,174,186,199,193,179,164,148,132,112,94,75,55,35,14,0,0,0,0,0,0,0,0,0,7,30,52,75,97,119,141,162,182,198,202,186,173,165,160,160,161,155,132,107,83,60,36,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,205,180,154,129,101,78,53,27,44,66,90,113,138,139,139,132,106,83,60,37,33,58,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,208,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,203,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,203,193,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,203,208,188,173,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,149,121,99,73,50,25,0,7,33,55,81,104,129,154,177,203,204,184,167,162,162,162,162,162,165,167,173,179,187,196,193,183,172,159,144,130,112,96,78,59,41,21,1,0,0,0,0,0,0,0,0,0,0,21,42,64,86,107,129,146,163,177,188,195,196,189,185,185,185,161,138,113,90,66,42,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,180,200,180,154,129,101,78,53,27,35,58,81,103,114,114,114,114,97,74,51,28,33,58,83,109,134,160,185,200,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,193,200,187,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,180,200,195,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,195,198,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,180,200,193,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,177,200,200,200,196,193,193,193,193,193,193,193,193,193,193,193,193,193,193,193,172,149,121,99,73,50,25,0,7,33,55,81,104,129,154,177,200,200,200,191,187,187,187,187,187,189,192,195,190,185,178,170,161,149,138,123,109,94,78,60,43,24,6,0,0,0,0,0,0,0,0,0,0,0,9,31,52,72,92,110,129,143,155,164,170,175,175,175,172,168,162,144,119,95,72,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,154,175,175,175,154,129,101,78,53,27,25,47,67,83,88,88,88,88,79,61,41,19,33,58,83,109,134,160,175,175,175,149,121,99,73,48,22,0,25,45,66,86,106,129,152,172,175,175,175,167,147,121,101,81,60,40,0,7,30,55,78,104,129,154,175,175,175,170,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,172,175,175,175,149,121,99,73,50,25,0,5,30,55,78,104,129,154,175,175,175,170,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,154,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,172,149,121,99,73,50,25,0,7,33,55,81,104,129,154,175,175,175,175,175,175,175,175,175,175,175,173,170,166,161,155,147,138,129,115,103,89,74,59,42,26,8,0,0,0,0,0,0,0,0,0,0,0,0,0,18,38,58,76,92,107,121,134,141,147,149,149,149,147,144,138,132,121,98,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,53,78,104,129,149,149,149,149,149,129,101,78,53,27,13,33,48,60,63,63,63,63,58,45,27,7,33,58,83,109,134,149,149,149,149,149,121,99,73,48,22,0,25,45,66,86,106,129,149,149,149,149,149,149,147,121,101,81,60,40,0,7,30,55,78,104,129,149,149,149,149,149,147,119,93,71,45,22,0,0,0,0,0,0,25,48,73,96,121,147,149,149,149,149,149,121,99,73,50,25,0,5,30,55,78,104,129,149,149,149,149,149,144,119,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,33,55,81,104,129,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,73,50,25,0,7,33,55,81,104,129,149,149,149,149,149,149,149,149,149,149,149,149,148,145,142,137,132,121,114,104,93,81,69,55,40,24,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,40,57,72,86,98,108,115,119,121,121,121,121,117,113,106,99,87,66,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,53,78,103,121,121,121,121,121,121,121,101,78,53,27,2,14,28,35,38,38,38,38,34,24,9,7,32,58,83,108,121,121,121,121,121,121,119,98,73,48,22,0,25,45,65,86,106,121,121,121,121,121,121,121,121,119,101,80,60,40,0,7,30,55,78,103,121,121,121,121,121,121,121,117,93,70,45,22,0,0,0,0,0,0,25,48,73,96,119,121,121,121,121,121,121,119,98,73,50,25,0,4,30,55,78,103,121,121,121,121,121,121,121,117,93,68,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,32,55,80,103,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,50,25,0,7,32,55,80,103,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,116,111,106,98,90,81,71,59,48,34,20,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,22,38,52,65,75,84,91,95,96,99,96,96,93,88,82,75,66,51,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,48,71,90,99,99,99,99,99,99,99,89,71,48,24,0,0,4,10,12,12,12,12,9,1,0,4,28,52,75,93,99,99,99,99,99,99,98,87,66,43,19,0,21,41,59,77,92,99,99,99,99,99,99,99,99,98,89,73,55,36,0,4,26,50,71,90,99,99,99,99,99,99,99,98,83,64,41,19,0,0,0,0,0,0,21,43,66,85,98,99,99,99,99,99,99,98,87,66,45,21,0,1,26,50,71,90,99,99,99,99,99,99,99,98,83,62,41,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,28,50,73,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,45,21,0,4,28,50,73,90,99,99,99,99,99,99,99,99,99,99,99,99,99,96,93,91,86,81,74,67,58,48,38,26,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,18,31,42,52,61,66,70,73,73,73,71,68,64,58,51,43,31,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,55,68,73,73,73,73,73,73,73,67,55,36,14,0,0,0,0,0,0,0,0,0,0,0,0,18,40,58,70,73,73,73,73,73,73,73,66,51,31,9,0,12,29,45,59,69,73,73,73,73,73,73,73,73,73,67,56,42,25,0,0,16,38,55,68,73,73,73,73,73,73,73,73,64,49,29,9,0,0,0,0,0,0,12,31,51,65,73,73,73,73,73,73,73,73,66,51,33,12,0,0,16,38,55,68,73,73,73,73,73,73,73,73,64,47,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,38,56,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,33,12,0,0,18,38,56,68,73,73,73,73,73,73,73,73,73,73,73,73,73,72,69,66,62,57,50,43,34,25,15,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,20,28,36,42,45,48,48,48,45,43,39,33,27,20,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,34,45,48,48,48,48,48,48,48,44,34,19,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,37,46,48,48,48,48,48,48,48,43,31,15,0,0,0,13,27,38,45,48,48,48,48,48,48,48,48,48,44,35,24,10,0,0,2,20,34,45,48,48,48,48,48,48,48,47,41,30,13,0,0,0,0,0,0,0,0,15,31,42,48,48,48,48,48,48,48,48,43,31,17,0,0,0,2,20,34,45,48,48,48,48,48,48,48,47,41,28,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,20,35,45,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,31,17,0,0,0,4,20,35,45,48,48,48,48,48,48,48,48,48,48,48,48,48,47,45,42,37,32,26,19,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,12,17,20,22,22,22,21,19,15,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,20,22,22,22,22,22,22,22,19,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,21,22,22,22,22,22,22,22,19,9,0,0,0,0,0,6,15,20,22,22,22,22,22,22,22,22,22,19,13,3,0,0,0,0,0,12,20,22,22,22,22,22,22,22,22,17,8,0,0,0,0,0,0,0,0,0,0,9,18,22,22,22,22,22,22,22,22,19,9,0,0,0,0,0,0,12,20,22,22,22,22,22,22,22,22,17,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,20,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,19,9,0,0,0,0,0,0,13,20,22,22,22,22,22,22,22,22,22,22,22,22,22,22,20,17,13,8,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,20,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,19,24,25,25,25,25,25,25,25,25,23,15,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,15,23,25,25,25,25,25,25,20,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,13,19,23,25,27,27,25,23,19,13,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,14,20,24,26,27,27,25,22,18,12,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,11,16,21,25,26,27,27,25,22,17,11,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,9,14,19,22,25,26,27,27,25,22,19,13,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,33,45,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,44,32,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,28,41,49,50,50,50,50,50,50,50,50,47,38,22,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,15,26,38,47,50,50,50,50,50,50,42,30,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,21,29,36,43,47,50,50,50,50,47,42,36,28,20,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,12,22,31,38,44,48,50,50,50,50,46,41,35,28,19,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,17,25,33,40,45,48,50,50,50,50,46,41,34,25,15,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,18,25,33,38,43,47,50,50,50,50,50,47,42,36,28,20,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,53,67,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,28,47,62,72,73,73,73,73,73,73,73,73,70,58,40,18,0,0,0,0,0,0,0,0,0,0,0,0,2,7,13,20,28,38,48,59,70,73,73,73,73,73,73,64,49,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,22,33,44,53,61,67,71,73,76,76,73,71,66,60,52,42,32,21,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,23,34,45,54,61,68,72,75,76,76,73,71,65,59,51,41,30,17,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,18,30,40,49,57,64,69,73,75,76,76,73,70,64,57,48,38,27,14,0,0,0,0,0,0,0,0,0,0,0,2,12,22,32,41,49,56,62,67,71,73,76,76,76,73,71,66,60,52,42,31,19,5,0,0,0,0,0,0,0,0,0,0,0,0,1,24,48,69,89,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,41,62,82,97,99,99,99,99,99,99,99,99,93,75,52,28,6,0,0,0,0,0,0,0,0,0,9,20,27,32,37,44,51,61,71,82,93,99,99,99,99,99,98,83,64,41,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,16,31,43,55,65,75,83,90,95,99,99,99,98,94,90,83,74,65,54,42,29,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,17,31,44,56,66,76,85,91,96,99,99,99,98,93,89,82,73,62,51,37,23,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,26,39,51,62,72,80,87,93,96,99,99,99,98,93,88,80,70,59,47,34,20,4,0,0,0,0,0,0,0,0,11,23,33,44,54,63,72,79,86,91,94,98,99,99,99,98,95,90,82,74,64,52,38,24,8,0,0,0,0,0,0,0,0,0,0,0,5,27,53,76,101,123,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,121,98,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,34,55,75,96,117,124,124,124,124,124,124,124,124,109,83,58,32,10,0,0,0,0,0,0,0,0,11,29,42,51,56,62,68,75,84,93,104,116,124,124,124,124,124,118,93,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,20,36,50,64,76,88,98,106,114,119,121,124,124,121,119,113,106,97,87,76,63,50,35,19,3,0,0,0,0,0,0,0,0,0,0,0,0,3,20,36,51,64,77,88,99,108,114,119,124,124,124,121,118,113,105,96,84,72,57,42,26,8,0,0,0,0,0,0,0,0,0,0,0,0,16,32,46,60,73,84,94,103,111,116,121,124,124,124,121,117,111,102,92,81,68,54,39,22,6,0,0,0,0,0,6,20,32,45,55,66,76,86,95,102,109,114,119,121,124,124,124,121,119,114,106,96,86,72,58,42,24,7,0,0,0,0,0,0,0,0,0,0,5,27,53,76,101,124,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,26,48,68,89,109,132,152,152,152,152,152,152,152,134,109,83,58,33,10,0,0,0,0,0,0,0,6,26,47,64,76,81,86,93,99,107,116,129,139,150,152,152,152,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,3,21,38,55,70,85,98,109,119,132,139,144,148,150,149,147,144,138,130,119,109,97,83,69,53,37,19,2,0,0,0,0,0,0,0,0,0,0,3,21,38,55,70,85,98,110,121,132,139,145,149,152,149,147,144,137,129,117,105,91,76,60,42,24,5,0,0,0,0,0,0,0,0,0,0,17,34,51,67,81,93,106,116,129,136,142,147,149,152,149,147,142,136,124,114,101,88,74,58,40,19,0,0,0,0,3,22,40,54,66,77,88,98,108,117,124,134,139,144,147,149,152,149,147,144,138,130,118,106,92,76,58,41,22,3,0,0,0,0,0,0,0,0,0,5,27,53,76,101,124,152,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,172,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,40,61,81,103,123,145,165,177,177,177,177,177,160,134,109,83,58,33,10,0,0,0,0,0,0,0,14,36,60,83,99,106,111,116,123,132,141,150,161,173,177,177,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,0,19,38,55,73,89,104,118,132,144,153,161,168,172,175,175,172,167,161,152,143,132,117,103,87,71,55,36,17,0,0,0,0,0,0,0,0,0,0,19,38,55,73,89,104,118,132,144,154,162,168,173,175,175,171,167,160,150,139,124,110,94,76,58,39,20,0,0,0,0,0,0,0,0,0,15,33,51,69,85,100,114,129,139,149,158,165,170,173,175,175,170,165,157,147,136,121,108,92,74,54,32,8,0,0,0,14,37,56,74,86,98,109,119,132,140,150,157,163,168,172,175,175,175,172,167,160,152,140,124,110,92,74,56,36,16,0,0,0,0,0,0,0,0,0,5,27,53,76,101,124,152,177,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,192,201,203,203,197,172,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,12,33,53,74,95,116,137,158,179,200,203,203,203,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,17,40,66,91,116,132,137,142,148,155,164,173,183,195,203,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,0,0,0,14,34,53,72,91,107,123,139,153,165,176,185,192,190,188,188,191,191,184,175,165,153,139,123,105,89,71,52,32,12,0,0,0,0,0,0,0,0,14,34,53,72,91,107,123,139,154,166,177,186,188,183,182,182,184,189,183,173,161,146,130,110,92,74,54,33,12,0,0,0,0,0,0,0,11,31,51,69,87,103,119,136,149,162,172,181,189,194,190,188,188,191,189,180,170,157,143,129,109,85,60,37,12,0,0,0,21,46,68,89,107,119,132,144,154,163,172,180,187,189,187,187,188,192,196,191,184,174,161,146,129,109,90,70,49,28,7,0,0,0,0,0,0,0,0,5,27,53,76,101,124,152,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,168,182,201,201,182,162,144,121,98,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,4,25,46,67,88,108,130,150,172,187,180,183,195,208,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,17,40,66,91,116,142,160,165,172,179,187,196,206,216,220,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,0,0,7,28,48,68,88,107,124,143,159,173,186,194,181,173,167,165,165,167,173,182,194,186,172,158,141,123,105,86,67,46,26,5,0,0,0,0,0,0,6,27,48,68,87,106,124,143,159,173,186,186,174,165,160,157,157,160,167,177,189,180,164,146,129,107,88,67,45,24,2,0,0,0,0,0,4,25,45,65,85,103,121,139,155,170,182,194,189,179,172,167,165,165,167,174,183,185,165,146,124,105,83,59,36,11,0,0,0,22,48,71,96,118,140,154,165,175,186,184,176,170,165,164,162,165,168,177,187,200,194,179,162,144,123,103,82,61,39,17,0,0,0,0,0,0,0,0,5,27,53,76,101,124,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,142,148,168,192,186,166,147,129,108,89,67,45,22,0,0,0,0,0,0,0,0,0,0,0,0,17,38,59,80,101,121,144,164,185,168,155,160,178,198,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,17,40,66,91,116,142,167,180,180,180,180,180,185,198,217,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,0,0,19,40,61,82,101,121,143,161,177,193,188,172,160,149,143,139,139,144,150,161,174,189,192,177,159,141,121,100,81,59,38,16,0,0,0,0,0,0,18,39,61,81,101,121,141,161,177,193,179,164,152,142,136,134,134,137,144,154,170,186,180,162,143,121,100,79,56,34,12,0,0,0,0,0,16,37,58,79,99,118,139,157,173,189,197,181,167,156,148,142,139,139,144,152,162,170,150,132,110,91,71,50,29,5,0,0,0,19,42,64,86,106,129,149,171,181,171,161,153,147,142,139,139,139,145,154,167,182,199,196,177,157,137,114,92,71,48,25,3,0,0,0,0,0,0,0,4,27,51,74,97,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,121,143,166,190,171,152,132,112,92,74,55,34,13,0,0,0,0,0,0,0,0,0,0,0,10,31,52,73,93,114,137,157,177,174,153,132,144,170,193,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,17,40,66,91,116,142,154,154,154,154,154,154,163,182,205,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,0,7,29,51,73,95,116,137,157,177,195,189,171,154,139,124,117,114,114,118,129,140,155,172,190,193,175,155,136,114,92,71,49,28,5,0,0,0,0,7,29,50,72,93,115,137,156,175,195,179,161,144,130,117,110,106,106,111,119,135,152,170,189,176,155,135,111,89,66,44,20,0,0,0,0,5,28,49,71,92,113,135,154,173,191,197,179,162,147,135,124,116,114,114,119,129,141,154,136,115,96,76,56,37,17,0,0,0,0,11,32,53,74,95,116,138,160,158,148,139,130,121,116,113,111,114,121,134,148,165,184,204,190,169,147,124,101,78,56,33,10,0,0,0,0,0,0,0,0,20,44,63,81,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,96,116,138,158,177,177,157,137,116,97,77,58,39,20,1,0,0,0,0,0,0,0,0,0,0,3,24,45,65,86,107,129,150,170,186,163,141,118,144,170,193,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,17,40,66,91,116,129,129,129,129,129,129,129,150,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,0,16,39,61,84,106,129,150,171,191,195,174,155,136,117,105,95,90,91,95,105,119,137,156,175,196,189,170,148,124,105,82,59,37,15,0,0,0,0,16,39,61,83,106,129,149,170,190,182,162,144,124,109,97,88,83,83,89,99,116,136,156,177,188,166,144,121,98,75,52,28,6,0,0,0,15,38,59,82,105,124,148,169,189,201,181,162,144,129,112,101,93,90,91,96,107,118,135,119,100,81,61,42,22,2,0,0,0,0,0,20,41,63,83,105,124,148,138,124,116,106,98,93,88,88,91,99,112,132,150,171,192,200,178,155,132,109,86,62,39,16,0,0,0,0,0,0,0,0,9,29,45,58,63,63,63,63,63,63,63,63,63,63,63,63,63,69,90,110,132,152,172,183,163,143,121,101,82,62,43,24,4,0,0,0,0,0,0,0,0,0,0,0,17,37,58,79,99,119,143,163,184,174,152,130,119,147,170,195,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,14,36,60,83,99,101,101,101,101,101,101,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,1,24,48,71,93,116,139,162,183,205,183,161,140,119,99,83,71,66,66,72,85,101,121,143,163,184,203,182,160,138,114,92,69,46,23,0,0,0,2,24,48,71,93,116,139,161,182,191,170,149,129,109,91,75,64,58,59,66,81,100,121,145,167,190,176,153,130,106,82,59,35,11,0,0,0,24,47,69,92,115,138,161,181,203,188,167,147,129,109,92,79,70,66,66,73,85,99,113,105,86,67,47,27,7,0,0,0,0,0,0,8,30,50,72,92,114,129,115,104,93,83,75,69,65,63,67,78,96,116,139,161,184,205,185,162,139,114,91,68,44,20,0,0,0,0,0,0,0,0,0,11,24,34,38,38,38,38,38,38,38,38,38,38,38,40,62,82,103,123,145,165,186,170,149,129,108,88,67,48,28,9,0,0,0,0,0,0,0,0,0,0,0,9,30,50,72,92,113,135,155,177,184,162,140,117,121,147,172,196,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,6,26,47,64,75,76,76,76,76,76,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,8,32,56,78,102,124,149,172,195,196,172,150,129,105,85,65,50,42,42,51,67,86,107,130,152,174,197,192,170,147,124,101,77,54,31,7,0,0,9,32,56,78,101,124,148,171,193,183,160,137,114,93,74,56,42,40,40,47,67,89,112,137,159,183,184,160,137,111,88,65,40,17,0,0,8,32,55,77,101,124,148,171,194,199,177,155,134,112,92,74,58,47,42,42,52,65,79,88,87,71,52,32,13,0,0,0,0,0,0,0,0,19,39,60,81,99,106,95,82,72,62,52,49,55,60,64,68,84,106,132,154,177,200,190,167,144,119,95,71,48,24,0,0,0,0,0,0,0,0,0,0,1,9,12,12,12,12,12,12,12,12,12,12,31,53,74,95,116,137,158,179,179,157,137,114,94,74,54,33,14,0,0,0,0,0,0,0,0,0,0,0,2,22,43,64,85,106,129,148,169,190,172,150,129,106,121,149,174,198,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,0,11,29,42,50,50,50,50,50,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,14,38,62,86,109,135,157,180,204,188,164,141,117,94,72,51,31,17,18,33,53,73,96,118,142,165,189,202,179,155,134,109,85,61,37,12,0,0,15,38,62,86,109,134,156,180,198,175,152,129,104,82,66,66,66,66,66,66,66,81,106,132,154,178,189,165,142,116,93,69,45,21,0,0,13,37,61,85,109,134,156,180,203,190,168,144,121,99,78,58,40,24,17,19,31,45,58,65,63,52,37,18,0,0,0,0,0,0,0,0,0,7,28,48,65,77,80,73,62,54,61,68,73,78,83,88,91,96,101,124,149,173,198,194,170,147,121,98,73,50,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,44,64,86,107,130,150,171,188,166,145,123,101,81,60,40,19,0,0,0,0,0,0,0,0,0,0,0,0,15,36,57,78,98,118,141,161,182,180,160,139,115,99,121,149,175,198,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,0,0,8,19,24,25,25,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,19,43,67,91,114,140,163,188,205,182,158,134,109,86,62,40,17,0,0,19,41,64,87,110,135,159,183,206,186,162,139,114,90,67,42,18,0,0,19,43,68,91,114,139,163,188,193,169,144,119,97,91,91,91,91,91,91,91,91,91,101,124,152,175,194,170,147,119,96,72,47,23,0,0,18,43,67,91,114,139,163,188,207,183,160,137,112,89,66,44,23,4,0,0,11,25,36,40,38,31,18,1,0,0,0,0,0,0,0,0,0,0,14,31,45,54,55,60,69,77,85,91,98,103,107,111,116,119,121,124,149,172,195,196,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,33,55,76,98,118,141,163,184,177,155,134,110,89,69,47,27,6,0,0,0,0,0,0,0,0,0,0,0,8,28,49,70,91,112,134,154,174,187,167,146,124,104,99,124,149,175,200,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,0,0,0,0,1,2,2,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,22,47,71,95,119,145,169,193,201,177,153,129,104,80,56,32,8,0,0,9,33,57,81,105,129,154,178,202,192,168,144,119,93,70,45,21,0,0,23,47,71,95,119,144,168,192,190,165,140,116,114,114,114,114,114,114,114,114,114,114,114,124,149,175,197,172,148,121,98,73,49,25,0,0,22,46,71,94,119,144,168,193,202,178,154,130,105,81,57,34,11,0,0,0,0,4,13,17,16,9,0,0,0,0,0,0,0,0,0,0,0,3,18,33,47,59,72,82,91,100,107,114,119,129,132,137,141,144,147,151,161,179,201,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,44,66,88,109,132,154,174,188,165,144,121,99,78,56,34,14,0,0,0,0,0,0,0,0,0,0,0,0,21,42,62,83,104,124,147,167,188,174,153,132,110,90,99,124,149,175,200,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,25,50,73,98,121,148,172,196,198,175,150,124,101,76,51,27,3,0,0,4,28,52,77,101,124,152,175,200,196,172,147,121,96,73,48,24,0,2,25,50,73,98,121,148,172,196,189,168,146,142,142,142,142,142,142,142,142,142,142,142,142,142,154,177,198,175,149,121,99,73,50,25,0,0,25,49,73,98,121,148,172,196,199,175,150,124,100,76,52,27,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,19,37,53,67,81,93,104,114,123,132,139,145,152,156,161,165,169,172,175,182,195,212,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,32,55,77,98,121,144,165,187,177,155,134,109,88,65,45,23,2,0,0,0,0,0,0,0,0,0,0,0,14,35,55,76,97,117,139,161,181,181,160,139,117,98,76,99,124,149,175,200,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,2,25,50,76,99,124,150,175,200,198,173,149,121,99,73,49,25,0,0,0,1,25,50,73,99,121,149,175,198,198,175,149,121,99,73,48,25,0,2,27,50,76,99,124,149,175,198,201,180,168,165,165,165,165,165,165,165,165,165,165,165,165,165,171,188,193,175,149,121,99,73,50,25,0,1,25,50,75,99,124,150,175,200,198,172,149,121,97,73,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,36,53,71,87,101,114,124,137,147,155,162,168,175,178,172,167,163,160,157,165,181,203,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,42,65,87,109,132,154,177,190,168,145,121,99,78,55,33,11,0,0,0,0,0,0,0,0,0,0,0,6,27,48,69,89,110,132,153,174,187,167,146,124,104,83,73,99,124,149,175,200,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,2,25,50,76,99,124,152,175,200,198,172,149,121,96,73,48,22,0,0,0,0,25,48,73,99,121,149,175,198,198,175,149,121,99,73,48,25,0,2,27,50,76,99,124,152,175,200,203,184,172,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,149,121,99,73,50,25,0,2,25,50,76,99,124,152,175,200,198,172,147,121,96,72,48,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,31,51,70,87,105,121,136,148,160,169,178,179,169,161,155,148,144,139,136,132,150,173,196,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,29,52,74,97,119,143,164,187,181,158,136,112,90,67,45,23,0,0,0,0,0,0,0,0,0,0,0,0,20,41,62,82,103,123,146,166,187,174,154,132,110,90,70,73,99,124,149,175,200,185,160,134,109,83,58,33,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,2,25,50,76,99,124,150,175,200,198,172,149,121,99,73,48,25,0,0,0,1,25,50,73,99,121,149,175,198,198,175,149,121,99,73,48,25,0,2,27,50,76,99,124,149,175,200,192,170,150,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,119,96,72,48,24,0,2,25,50,76,99,124,152,175,200,198,172,149,121,97,73,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,44,64,85,103,121,141,155,170,181,182,169,157,147,138,132,123,118,114,109,121,149,172,195,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,38,61,84,106,130,152,174,196,173,150,124,103,81,58,35,13,0,0,0,0,0,0,0,0,0,0,0,12,33,54,75,95,116,138,159,179,181,160,139,117,97,76,56,73,99,124,149,175,200,185,160,134,109,83,58,33,10,6,0,0,0,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,25,50,73,98,121,149,172,197,198,175,150,124,101,76,51,27,3,0,0,4,28,52,77,101,124,152,175,200,196,172,147,121,97,73,48,24,0,2,25,50,75,99,121,149,172,197,190,165,142,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119])
.concat([114,91,68,44,20,0,0,25,50,73,98,121,149,172,197,198,175,150,124,100,76,52,27,3,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,10,33,54,76,97,117,139,157,174,189,180,164,148,136,124,114,107,100,94,90,99,121,149,172,195,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,47,69,92,115,139,162,184,188,165,142,118,95,72,49,26,4,0,0,0,0,0,0,0,0,0,0,5,26,46,67,88,109,132,152,172,188,167,146,124,104,83,63,50,73,99,124,149,175,200,185,160,134,109,83,58,33,32,28,18,4,0,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,22,47,71,95,119,146,169,193,201,177,153,129,104,80,56,32,8,0,0,9,33,57,81,105,130,154,178,202,192,168,144,119,93,70,46,21,0,0,23,47,72,96,119,146,169,193,193,168,144,119,96,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,92,78,59,37,15,0,0,22,47,71,96,119,147,170,194,202,178,154,129,105,81,57,33,11,0,0,0,0,2,14,24,27,23,15,5,0,0,0,0,0,0,17,41,63,86,108,132,153,172,191,186,165,146,130,114,101,91,83,77,70,73,99,121,149,172,195,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,54,77,101,123,147,171,193,181,158,135,110,87,64,41,18,0,0,0,0,0,0,0,0,0,0,0,19,39,59,81,101,121,144,165,186,174,154,132,110,90,70,58,58,73,99,124,149,175,200,185,160,134,109,83,58,58,58,51,40,22,2,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,19,43,68,91,115,140,164,188,205,182,158,134,109,86,63,40,17,0,0,19,41,64,87,111,135,159,183,207,186,162,139,114,90,67,42,18,0,0,20,44,68,92,116,141,164,188,198,174,151,129,103,81,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,67,58,44,24,5,0,0,19,44,68,91,116,142,165,189,207,183,160,136,111,89,65,43,22,4,0,0,7,21,35,46,50,48,38,22,6,0,0,0,0,0,23,47,70,93,116,139,163,184,199,177,154,132,110,94,81,70,61,53,50,73,99,121,149,172,195,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,38,61,85,108,132,155,179,199,175,152,129,103,81,57,34,10,0,0,0,0,0,0,0,0,0,0,14,32,52,73,94,115,137,157,178,181,161,139,117,98,83,83,83,83,83,99,124,149,175,200,185,160,134,109,83,83,83,83,74,58,37,14,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,14,38,62,86,109,135,157,181,204,188,164,141,117,95,72,51,31,19,19,33,53,73,96,118,142,165,189,202,179,155,134,109,85,61,37,13,0,0,16,39,63,87,111,136,158,181,204,181,158,136,112,90,69,50,45,45,45,45,45,45,45,45,50,57,57,51,45,45,38,26,10,0,0,0,14,39,63,86,111,136,159,182,206,190,167,144,119,98,76,56,38,24,18,19,28,41,55,69,76,71,58,40,19,0,0,0,0,3,27,50,74,98,121,146,170,192,193,170,147,121,100,78,60,47,38,33,50,73,99,121,149,172,195,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,45,69,92,114,139,162,186,192,168,145,121,97,73,50,27,3,0,0,0,0,0,0,0,0,0,0,24,46,68,87,107,130,150,171,191,169,146,124,109,109,109,109,109,109,109,109,124,149,175,200,185,160,134,109,109,109,109,108,91,70,46,21,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,9,33,56,79,102,124,149,172,195,196,172,150,129,105,85,65,50,43,43,51,67,86,107,130,152,174,197,193,170,147,124,101,77,54,31,7,0,0,11,33,57,80,103,129,150,173,195,190,167,146,123,103,83,67,53,42,37,35,37,41,50,61,72,82,82,71,54,33,14,5,0,0,0,0,9,33,57,80,103,129,152,174,197,199,177,154,132,110,91,73,58,47,43,43,50,62,74,89,99,92,74,53,33,12,0,0,0,5,27,53,76,100,124,149,173,197,193,167,144,118,95,71,48,36,41,53,67,82,99,121,149,172,195,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,27,51,74,98,121,146,169,193,187,163,139,115,91,68,44,21,0,0,0,0,0,0,0,0,0,0,4,30,52,78,102,121,143,163,184,191,168,145,137,137,137,137,137,137,137,137,137,137,152,176,201,186,161,139,137,137,137,137,121,96,73,48,22,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,1,24,49,71,93,116,140,162,184,205,183,161,140,118,99,84,72,67,67,73,85,101,119,141,163,184,203,182,161,138,115,92,69,46,23,0,0,0,4,26,50,73,95,117,140,163,183,200,179,158,138,117,101,86,74,65,60,58,60,65,72,82,93,105,106,87,66,45,23,2,0,0,0,0,2,26,49,73,96,118,141,164,186,207,187,166,146,124,107,92,79,70,66,67,72,82,95,109,123,108,88,67,46,26,5,0,0,5,27,53,76,101,124,149,175,198,193,170,144,119,98,74,63,60,65,74,86,100,116,132,152,173,196,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,33,56,80,103,129,152,175,199,183,158,135,109,86,62,38,15,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,177,198,199,181,165,162,162,162,162,162,162,162,162,162,162,169,186,208,195,175,163,162,162,162,149,121,96,73,48,22,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,0,17,40,62,84,106,129,150,172,191,195,174,154,137,117,105,96,91,91,96,106,119,137,156,175,196,190,170,148,124,105,82,59,38,15,0,0,0,0,18,41,63,85,107,129,150,171,191,192,172,154,137,119,107,97,89,85,83,85,88,95,105,115,129,121,99,78,56,34,13,0,0,0,0,0,18,41,63,86,108,132,153,174,194,200,180,161,143,124,112,101,93,91,91,96,104,116,130,143,121,101,80,59,39,19,0,0,4,27,52,75,99,121,147,171,194,197,174,151,130,109,94,87,86,88,96,107,119,136,152,167,184,204,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,38,62,86,109,134,157,181,201,178,154,132,106,81,57,34,10,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,180,195,195,195,189,187,187,187,187,187,187,187,187,187,187,192,204,222,211,196,188,187,187,175,149,121,96,73,48,22,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,0,7,30,51,73,95,116,137,158,177,195,189,171,154,139,129,119,114,114,119,129,140,155,173,190,194,175,155,136,114,92,72,49,28,5,0,0,0,0,8,31,53,74,95,116,137,157,175,194,189,171,155,141,129,119,112,109,106,109,112,118,129,137,148,134,110,89,67,46,24,3,0,0,0,0,8,31,53,75,97,117,139,160,179,198,196,179,161,146,135,123,116,114,114,119,129,138,150,156,136,114,93,73,52,31,9,0,1,24,48,71,95,118,142,165,188,205,183,163,144,129,116,110,109,111,118,129,141,155,170,180,187,200,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,66,91,114,139,162,186,198,175,150,124,101,77,53,29,5,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,154,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,177,193,212,199,181,171,170,170,170,149,121,96,73,48,22,0,0,0,0,0,0,0,0,0,0,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,0,0,0,0,0,0,0,0,0,0,0,19,40,62,83,103,121,143,161,177,193,188,173,161,151,144,142,142,144,151,162,174,189,192,177,159,141,121,100,81,59,38,17,0,0,0,0,0,0,20,41,62,83,101,121,141,159,176,191,189,175,162,152,144,137,134,134,134,137,143,150,160,166,145,121,100,79,57,36,14,0,0,0,0,0,21,41,63,85,105,124,144,163,180,196,196,181,167,156,148,144,142,142,144,151,160,172,170,148,129,107,86,65,43,19,0,0,19,43,65,89,111,135,156,178,198,196,179,161,149,140,137,135,137,143,152,162,172,158,155,166,186,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,47,70,94,118,144,167,191,194,171,147,121,98,73,50,25,2,0,0,0,0,0,0,0,0,0,0,5,30,53,78,104,129,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,157,179,202,188,164,147,144,144,144,144,121,96,73,48,22,0,0,0,0,0,7,10,10,10,10,25,48,73,99,124,149,175,200,195,170,147,119,93,71,45,20,10,10,10,6,0,0,0,0,0,0,0,7,28,48,69,88,107,124,143,159,173,186,194,182,173,167,165,165,168,174,183,195,186,173,158,143,123,105,87,67,47,26,5,0,0,0,0,0,0,7,28,48,68,87,105,123,141,157,171,184,196,183,174,167,162,160,160,160,162,166,173,182,178,156,135,112,90,68,44,21,0,0,0,0,0,8,30,50,71,90,109,129,146,161,176,189,199,189,179,172,167,165,165,168,174,182,187,174,161,141,119,96,73,48,22,0,0,12,36,58,80,101,123,145,164,182,197,195,182,172,164,160,160,161,166,173,167,154,139,132,155,178,198,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,27,51,75,99,121,147,172,195,192,168,144,119,93,70,46,22,0,0,0,0,0,0,0,0,0,0,0,4,29,52,77,101,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,124,149,175,200,185,160,134,116,116,116,116,115,94,72,47,22,0,0,0,7,21,31,35,35,35,35,35,48,73,99,124,149,175,200,195,170,147,119,93,71,45,35,35,35,35,30,19,4,0,0,0,0,0,0,14,34,54,72,91,107,123,139,154,166,176,184,191,191,190,190,192,191,184,175,165,153,139,123,107,89,71,52,33,12,0,0,0,0,0,0,0,0,14,34,53,71,89,105,121,138,152,164,174,183,189,190,185,182,182,182,185,184,176,167,157,146,135,118,96,71,45,22,0,0,0,0,0,0,16,36,56,74,92,110,129,143,155,167,178,185,191,195,191,190,190,191,184,176,166,155,141,129,110,91,70,46,21,0,0,5,27,48,70,90,110,130,148,164,177,188,194,194,188,185,185,182,172,160,147,134,118,124,151,174,182,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,30,55,78,102,129,152,175,199,190,165,142,116,91,68,43,20,0,0,0,0,0,0,0,0,0,0,0,0,24,46,68,85,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,99,124,149,175,200,185,160,134,109,93,93,93,93,82,62,40,17,0,0,8,26,43,54,58,58,58,58,58,58,73,99,124,149,175,200,195,170,147,119,93,71,58,58,58,58,58,52,40,22,4,0,0,0,0,0,0,19,38,55,73,89,104,118,132,144,153,161,167,171,173,173,170,167,160,152,143,132,117,103,88,71,55,36,17,0,0,0,0,0,0,0,0,0,0,19,37,55,71,87,103,116,130,141,152,160,165,170,172,175,172,170,166,160,153,144,135,123,112,99,85,64,41,19,0,0,0,0,0,0,2,21,40,58,74,92,107,121,135,145,154,162,167,171,173,173,171,167,161,153,144,134,119,106,91,76,58,37,15,0,0,0,16,37,57,76,95,112,130,144,155,163,170,173,173,171,166,160,149,138,124,112,99,121,147,157,157,157,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,33,58,81,106,132,155,179,203,187,164,139,114,88,66,41,17,0,0,0,0,0,0,0,0,0,0,0,0,14,32,51,64,68,68,68,68,68,68,68,68,68,68,68,68,68,68,73,99,124,149,175,200,185,160,134,109,83,68,68,68,61,46,28,7,0,0,21,41,62,78,83,83,83,83,83,83,83,99,124,149,175,200,195,170,147,119,93,83,83,83,83,83,83,75,58,37,16,0,0,0,0,0,0,4,21,38,55,70,85,98,110,121,132,138,144,147,149,149,147,144,137,130,119,109,97,84,69,53,37,19,2,0,0,0,0,0,0,0,0,0,0,3,21,37,53,69,83,96,108,118,129,137,142,147,149,149,149,147,143,137,132,121,112,101,90,79,66,49,31,9,0,0,0,0,0,0,0,6,22,40,56,72,87,99,112,121,132,139,144,147,149,149,147,144,138,132,121,110,99,86,72,57,40,24,3,0,0,0,4,24,43,61,78,94,109,121,134,141,147,149,149,147,144,137,129,116,105,92,93,117,134,134,134,134,134,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,36,60,84,109,134,158,182,206,185,162,137,111,88,63,40,15,0,0,0,0,0,0,0,0,0,0,0,0,0,15,30,40,43,43,43,43,43,43,43,43,43,43,43,43,43,50,73,99,124,149,175,200,185,160,134,109,83,58,43,43,37,26,11,0,0,3,28,51,75,98,109,109,109,109,109,109,109,109,124,149,175,200,195,170,147,119,109,109,109,109,109,109,108,93,70,46,23,0,0,0,0,0,0,0,4,21,36,51,64,77,88,98,106,114,118,121,121,121,121,118,113,106,98,87,76,64,50,35,19,3,0,0,0,0,0,0,0,0,0,0,0,0,3,19,34,49,63,75,86,97,105,111,116,119,121,121,121,121,116,112,106,98,90,80,69,57,45,32,15,0,0,0,0,0,0,0,0,0,6,22,38,53,66,79,90,99,107,114,119,121,121,121,121,119,114,106,98,88,78,65,52,38,23,6,0,0,0,0,0,9,28,44,60,76,89,100,109,116,121,121,121,121,117,112,104,95,83,72,88,104,106,106,106,106,106,106,92,72,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,39,63,87,111,137,160,185,208,183,160,135,109,86,61,38,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,15,17,17,17,17,17,17,17,17,17,17,17,17,25,50,73,99,124,149,175,200,185,160,134,109,83,58,33,17,13,4,0,0,0,5,30,53,78,104,129,137,137,137,137,137,137,137,137,153,176,201,196,172,149,137,137,137,137,137,137,137,121,99,73,48,25,0,0,0,0,0,0,0,0,2,16,31,43,55,66,75,83,90,93,98,99,99,98,93,89,82,74,65,55,43,30,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,29,41,54,64,73,81,88,93,96,99,99,99,96,93,88,82,75,66,57,47,36,24,12,0,0,0,0,0,0,0,0,0,0,0,4,19,33,45,57,67,76,84,90,93,97,99,99,98,93,90,83,75,66,56,44,31,18,4,0,0,0,0,0,0,0,10,26,42,55,67,78,86,93,96,99,99,98,93,89,81,72,62,52,70,80,81,81,81,81,81,80,73,58,38,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,139,163,187,206,182,158,134,109,83,60,35,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,149,175,200,185,160,134,109,83,58,33,10,0,0,0,0,0,5,30,53,78,104,129,154,162,162,162,162,162,162,162,170,186,208,204,184,167,162,162,162,162,162,162,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,10,23,33,44,53,61,66,71,73,73,73,73,70,65,60,52,43,33,22,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,21,32,42,51,58,64,69,73,73,73,73,73,70,65,59,53,44,35,25,15,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,24,35,45,53,61,66,70,73,73,73,73,71,66,60,53,44,34,23,11,0,0,0,0,0,0,0,0,0,0,8,22,34,46,56,63,69,73,73,73,73,70,65,59,50,40,36,49,57,58,58,58,58,58,58,52,41,24,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,43,68,91,116,142,165,190,200,180,157,132,106,81,58,34,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,149,175,200,185,160,134,109,83,58,33,10,0,0,0,0,0,5,30,53,78,104,129,154,180,187,187,187,187,187,187,192,200,200,200,200,191,187,187,187,187,187,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,11,21,29,36,42,46,48,50,50,48,46,41,36,28,20,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,28,35,40,45,48,50,50,50,48,45,41,35,28,21,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,13,22,30,36,42,46,48,50,50,49,46,42,36,29,21,11,2,0,0,0,0,0,0,0,0,0,0,0,0,1,13,24,33,40,45,48,50,50,48,46,41,35,27,17,16,27,32,33,33,33,33,33,32,28,20,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,45,69,93,116,144,167,175,175,175,154,132,104,81,55,33,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,149,175,175,175,160,134,109,83,58,33,10,0,0,0,0,0,5,30,53,78,104,129,154,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,13,18,22,25,25,25,25,22,18,12,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,11,17,21,24,25,25,25,25,22,17,12,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,13,18,22,25,25,25,25,22,18,13,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,9,16,21,25,25,25,25,22,18,12,5,0,0,4,9,10,10,10,10,10,10,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,45,71,93,119,144,149,149,149,149,149,129,104,78,55,30,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,99,124,149,149,149,149,149,134,109,83,58,33,10,0,0,0,0,0,5,30,53,78,104,129,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,48,70,96,117,121,121,121,121,121,121,121,102,78,53,30,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,50,73,98,121,121,121,121,121,121,121,108,83,58,32,10,0,0,0,0,0,4,30,53,78,103,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,64,85,98,99,99,99,99,99,99,99,89,71,48,26,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,45,66,87,98,99,99,99,99,99,99,93,75,52,28,6,0,0,0,0,0,1,26,48,71,90,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,43,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,31,49,65,73,73,73,73,73,73,73,73,67,55,36,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,33,51,66,73,73,73,73,73,73,73,70,58,40,18,0,0,0,0,0,0,0,16,36,55,68,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,31,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,30,42,47,48,48,48,48,48,48,48,44,34,19,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,31,43,48,48,48,48,48,48,48,46,37,22,4,0,0,0,0,0,0,0,2,19,34,45,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,31,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,18,22,22,22,22,22,22,22,22,19,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,19,22,22,22,22,22,22,22,21,14,2,0,0,0,0,0,0,0,0,0,0,12,20,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,19,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,7,7,7,7,7,7,7,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,14,19,23,25,27,27,26,25,21,17,11,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,14,21,27,27,27,26,20,13,2,0,0,0,0,0,0,0,0,0,6,10,10,10,10,10,10,8,2,0,0,7,15,20,24,25,25,25,22,17,11,2,0,0,0,0,0,1,9,16,21,25,25,25,24,21,15,8,0,0,0,0,0,0,0,0,0,0,0,0,0,6,10,10,10,10,10,10,8,2,0,0,4,12,18,22,25,25,25,24,21,16,9,0,0,0,0,0,0,0,0,0,0,0,0,0,6,10,10,10,10,10,10,8,1,0,0,9,17,22,25,25,25,22,17,10,0,0,0,0,0,0,2,14,24,27,27,27,27,27,27,27,27,21,10,0,0,0,0,0,11,21,27,27,27,27,27,27,27,27,24,14,0,0,0,0,0,0,0,7,18,24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,24,18,7,0,0,0,0,0,5,17,27,30,30,30,30,30,30,30,30,25,16,2,0,0,0,0,0,0,0,0,0,0,0,0,0,11,22,30,37,43,47,50,50,50,50,48,45,40,34,25,16,6,0,0,0,0,0,0,0,0,0,0,0,12,25,36,45,50,53,53,49,43,34,23,10,0,0,0,0,0,0,6,20,28,32,33,33,33,33,33,31,24,12,21,30,39,44,48,50,50,50,46,41,34,25,14,1,0,0,13,24,33,41,46,50,50,50,49,45,39,31,22,11,0,0,0,0,0,0,0,0,0,6,20,28,32,33,33,33,33,33,31,24,13,16,27,35,42,47,50,50,50,49,45,40,33,23,12,0,0,0,0,0,0,0,0,0,4,18,28,32,33,33,33,33,33,31,23,11,22,33,41,47,50,50,50,47,41,33,23,8,0,0,0,0,19,35,45,50,50,50,50,50,50,50,50,43,30,13,0,0,0,13,30,43,50,50,50,50,50,50,50,50,45,33,17,0,0,0,0,0,11,27,40,49,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,49,41,27,11,0,0,0,3,22,37,49,53,53,53,53,53,53,53,53,47,36,19,1,0,0,0,0,0,0,0,0,0,0,7,21,33,44,53,61,67,72,73,76,76,75,73,70,64,57,49,39,29,17,6,0,0,0,0,0,0,0,0,15,31,46,58,68,75,77,77,73,67,56,44,29,12,0,0,0,0,4,24,40,52,58,58,58,58,58,58,56,47,31,42,53,62,69,73,75,76,73,70,65,57,48,35,22,7,21,34,46,56,65,70,73,76,75,73,69,63,54,44,31,17,1,0,0,0,0,0,0,4,24,41,52,58,58,58,58,58,58,56,47,31,39,50,58,66,71,73,76,75,73,70,64,56,45,33,19,4,0,0,0,0,0,0,2,22,40,52,58,58,58,58,58,58,56,45,32,45,55,65,71,74,76,73,71,65,56,42,24,3,0,0,13,35,55,69,76,76,76,76,76,76,76,75,64,49,28,7,0,8,28,49,66,75,76,76,76,76,76,76,75,69,53,33,13,0,0,0,5,25,45,61,73,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,73,61,45,26,5,0,0,16,37,56,71,78,78,78,78,78,78,78,78,69,55,34,13,0,0,0,0,0,0,0,0,0,11,27,41,55,65,76,84,90,95,98,99,99,99,96,93,87,80,71,61,50,39,26,13,0,0,0,0,0,0,14,32,49,65,79,90,98,101,101,97,89,77,62,46,28,10,0,0,0,15,38,58,75,83,83,83,83,83,83,80,65,52,64,75,85,93,98,99,99,99,93,89,80,69,56,41,27,41,55,67,79,87,93,98,99,99,97,93,85,76,65,51,36,19,1,0,0,0,0,0,16,38,58,75,83,83,83,83,83,83,80,67,48,61,72,81,90,94,99,99,99,98,93,87,78,66,54,38,22,4,0,0,0,0,0,14,37,58,75,83,83,83,83,83,83,79,64,52,66,78,88,94,99,99,99,95,88,77,59,38,15,0,0,22,46,69,89,101,101,101,101,101,101,101,99,83,63,39,16,0,16,39,63,83,99,101,101,101,101,101,101,101,89,67,44,22,0,0,0,14,36,57,79,95,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,97,79,59,36,14,0,1,24,49,70,91,101,101,101,101,101,101,101,101,87,67,44,22,0,0,0,0,0,0,0,0,12,30,46,61,75,88,98,107,114,119,121,124,124,124,121,116,111,103,93,83,72,59,47,33,18,1,0,0,0,6,28,47,66,83,99,112,121,124,124,119,110,96,80,62,43,23,2,0,0,23,48,72,92,106,106,106,106,106,106,101,81,72,86,98,108,116,121,124,124,121,119,112,103,90,76,60,46,61,76,89,101,110,117,121,124,124,121,116,109,98,86,71,55,37,17,0,0,0,0,0,23,48,72,92,106,106,106,106,106,106,101,82,69,82,93,105,113,119,121,124,124,121,116,110,100,88,74,56,38,20,1,0,0,0,0,20,45,69,92,106,106,106,106,106,106,99,79,72,87,99,110,118,123,124,123,119,110,95,71,46,21,0,2,25,50,76,98,123,124,124,124,124,124,124,116,93,68,43,20,0,20,43,68,93,116,124,124,124,124,124,124,121,98,73,48,25,0,0,0,17,40,63,88,111,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,111,88,65,40,17,0,5,27,53,76,101,124,124,124,124,124,124,124,121,96,73,48,25,0,0,0,0,0,0,0,8,28,46,64,80,95,109,121,132,139,144,148,149,152,149,147,142,136,124,115,105,93,81,67,53,36,16,0,0,0,16,38,59,81,99,117,134,146,152,152,144,132,114,96,76,55,33,12,0,0,25,50,76,99,124,134,134,134,134,134,111,86,92,107,119,132,141,147,150,152,149,144,137,124,110,94,77,65,81,96,110,123,135,144,148,152,151,147,142,134,119,106,89,71,52,32,11,0,0,0,0,25,50,76,99,124,134,134,134,134,134,113,88,89,103,116,129,137,144,149,152,152,147,143,135,121,108,91,74,55,35,14,0,0,0,0,22,48,73,99,124,134,134,134,134,134,109,84,92,107,121,135,144,149,152,149,144,121,98,73,48,22,0,2,25,50,76,99,124,152,152,152,152,152,144,116,93,68,43,20,0,20,43,68,93,116,144,152,152,152,152,149,121,99,73,48,25,0,0,0,17,40,63,88,111,137,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,139,111,88,66,40,17,0,4,27,53,76,101,124,149,149,149,149,149,147,121,96,73,48,25,0,0,0,0,0,0,1,22,42,62,80,98,114,130,143,154,162,168,172,175,175,173,170,165,158,149,139,129,114,101,87,71,49,26,4,0,1,24,47,69,91,113,134,154,167,175,174,165,149,130,108,87,65,42,19,0,0,25,50,76,99,124,152,160,160,160,142,114,96,112,129,141,154,163,170,175,175,172,167,158,146,130,112,93,83,99,116,132,145,157,166,172,175,175,171,164,155,141,124,107,87,67,45,23,2,0,0,0,25,50,76,99,124,152,160,160,160,142,116,93,109,123,138,150,160,168,173,175,175,172,166,156,143,129,109,90,69,48,27,5,0,0,0,22,48,73,99,124,152,160,160,160,139,111,92,110,129,143,156,166,173,175,168,144,117,93,68,43,19,0,2,25,50,76,99,124,152,175,177,177,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,177,177,175,149,121,99,73,48,25,0,0,0,17,40,63,88,111,137,162,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,162,139,111,88,66,40,17,0,2,27,50,76,99,124,150,175,175,175,172,147,121,96,73,48,25,0,0,0,0,0,0,13,34,56,76,96,115,134,150,164,176,185,189,183,180,180,180,183,189,181,171,161,148,136,121,104,81,57,32,9,0,6,29,52,75,99,121,145,167,186,199,198,182,163,141,116,94,71,48,24,0,0,25,50,76,99,124,152,177,182,168,144,116,114,132,147,162,175,187,195,198,200,196,191,180,165,148,130,108,101,119,136,152,166,179,189,196,200,199,195,188,176,161,143,121,101,79,57,34,12,0,0,0,25,50,76,99,124,152,177,182,170,144,119,112,130,144,158,172,183,192,196,200,199,196,188,178,162,144,124,103,82,59,38,15,0,0,0,22,48,73,99,124,152,177,182,165,141,114,109,129,146,162,177,189,197,188,163,139,113,88,64,39,14,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,17,40,63,88,111,137,162,182,182,182,182,182,182,182,182,182,182,183,190,203,203,203,201,181,162,139,111,88,66,40,17,0,2,27,50,76,99,124,149,175,198,195,170,147,119,96,72,48,22,0,0,0,0,0,0,22,45,66,89,109,132,150,168,184,193,178,167,160,155,154,155,160,166,175,186,181,164,144,123,104,81,57,32,9,0,9,32,55,80,103,124,152,175,197,220,216,193,170,147,121,98,73,50,27,0,0,25,50,76,99,124,152,177,196,172,147,119,134,150,166,180,173,170,170,174,181,193,207,200,183,164,144,121,119,139,155,171,178,172,170,172,176,186,198,210,195,177,157,136,113,90,67,44,20,0,0,0,25,50,76,99,124,152,177,197,172,147,121,132,148,164,179,175,172,170,172,176,184,196,211,198,179,159,138,115,92,70,47,24,0,0,0,22,48,73,99,124,152,177,193,167,142,116,124,145,164,182,181,176,175,175,160,134,109,83,59,34,9,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,17,40,63,88,111,137,157,157,157,157,157,157,157,157,157,157,157,157,168,188,209,207,187,167,148,129,108,86,64,40,17,0,2,25,50,73,99,121,149,172,198,195,170,147,119,96,71,47,22,0,0,0,0,0,6,30,53,76,99,121,145,165,184,194,175,158,145,136,132,129,132,137,144,154,164,168,149,130,109,90,71,49,27,4,0,9,32,55,80,103,129,152,175,197,220,216,193,170,147,121,98,73,50,27,0,0,25,50,76,99,124,152,177,199,175,153,139,152,168,169,158,150,147,147,151,160,172,189,207,198,177,155,132,139,157,173,165,155,148,147,147,153,164,179,197,211,191,170,147,121,99,76,52,28,4,0,0,25,50,76,99,124,152,177,200,176,153,139,150,167,171,160,152,147,147,147,153,163,177,193,211,194,171,149,124,101,78,55,32,8,0,0,22,48,73,99,124,152,177,195,170,144,118,139,160,180,169,158,152,149,152,154,129,104,79,54,29,4,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,17,40,63,88,111,132,132,132,132,132,132,132,132,132,132,132,132,134,155,180,203,193,173,154,135,114,94,74,54,33,11,0,0,25,48,73,96,121,149,172,198,195,170,147,119,93,71,45,22,0,0,0,0,0,12,36,59,83,107,132,154,177,198,182,161,141,123,111,106,104,106,111,119,132,143,154,135,114,94,75,56,36,16,0,0,6,29,52,76,99,121,146,167,187,199,198,183,163,141,116,94,71,48,24,0,0,25,50,76,99,124,152,177,203,186,169,162,169,162,148,136,124,119,121,129,138,154,172,193,211,188,168,153,156,172,157,144,132,123,119,121,130,144,161,180,202,202,179,155,132,106,83,59,34,10,0,0,25,50,76,99,124,152,177,200,188,171,165,170,164,150,138,129,121,119,121,129,141,159,177,198,204,181,158,134,109,85,62,38,13,0,0,22,48,73,99,124,152,177,198,173,148,134,152,173,160,146,136,129,124,124,132,124,99,74,49,24,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,15,37,59,82,99,104,104,104,104,104,104,104,104,104,104,104,121,141,161,183,198,179,159,140,119,99,80,60,41,21,0,0,0,25,48,73,96,121,147,172,195,193,170,144,119,93,71,45,22,0,0,0,0,0,15,40,64,88,111,137,161,184,197,173,151,129,105,89,81,78,82,89,98,108,121,136,118,99,80,60,41,22,2,0,0,1,24,47,69,91,113,135,154,167,176,175,166,150,132,108,88,65,43,20,0,0,25,50,76,99,124,152,177,203,204,192,175,159,143,129,113,102,96,96,103,117,137,158,181,204,202,186,175,170,154,137,121,109,99,94,98,108,124,146,167,190,210,186,162,139,112,88,64,39,15,0,0,25,50,76,99,124,152,177,200,204,193,177,161,145,130,115,104,97,93,98,107,123,143,164,187,210,188,164,140,114,91,67,42,18,0,0,22,48,73,99,124,152,177,203,183,165,160,168,157,141,124,112,103,99,101,106,108,91,68,45,20,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,7,28,48,65,77,81,81,81,81,81,81,81,81,81,95,114,136,155,174,194,184,165,146,124,105,86,66,47,26,7,0,0,0,22,48,71,96,119,146,170,194,192,167,144,117,93,70,45,21,0,0,0,0,0,17,42,66,91,114,140,165,188,195,170,147,119,96,73,57,55,58,65,75,87,100,111,103,84,65,45,26,7,0,0,0,0,17,38,59,81,99,117,135,146,152,152,145,132,114,96,76,55,34,12,0,0,25,50,76,99,124,152,177,203,198,177,159,141,121,107,92,80,72,72,83,103,124,149,172,197,213,190,170,152,136,116,101,88,76,71,74,90,110,135,158,182,206,192,167,143,116,92,68,43,18,0,0,25,50,76,99,124,152,177,200,199,177,159,143,124,109,95,82,73,71,74,87,108,132,155,179,203,193,170,144,119,93,70,46,21,0,0,22,48,73,99,124,152,177,203,201,188,180,159,140,119,104,90,79,74,76,81,83,76,57,36,12,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,15,31,45,54,55,55,55,55,55,55,55,70,90,109,130,149,169,189,191,171,152,132,110,91,72,52,33,13,0,0,0,0,21,45,69,93,116,143,167,191,188,165,141,114,91,67,43,19,0,0,0,0,0,17,42,66,91,114,141,165,189,196,172,149,123,101,84,72,61,53,44,54,67,80,88,84,69,50,31,12,0,0,0,0,0,6,28,48,67,83,99,113,121,129,129,121,110,97,82,63,43,23,3,0,0,25,50,76,99,124,152,177,203,190,167,143,121,103,87,72,58,48,49,69,93,116,142,167,191,208,183,158,136,116,98,82,67,54,46,55,78,102,129,152,176,201,195,171,147,119,93,70,45,20,0,0,25,50,76,99,124,152,177,200,193,167,144,123,107,91,75,61,49,45,53,76,100,124,149,173,198,197,172,149,121,96,73,48,22,0,0,22,48,73,99,124,152,177,203,212,189,167,146,123,103,85,69,57,50,52,58,60,54,40,22,1,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,0,11,23,29,30,30,30,30,30,45,64,84,104,123,144,163,183,196,177,157,137,116,97,78,57,38,19,0,0,0,0,0,19,42,67,91,114,140,165,188,185,162,138,111,88,64,40,16,0,0,0,0,0,16,40,64,88,112,137,161,184,201,179,157,136,117,105,93,84,75,67,59,50,58,63,61,50,35,16,0,0,0,0,0,0,0,14,33,49,65,80,91,98,101,101,98,89,78,63,47,29,10,0,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,69,53,37,24,39,63,88,111,139,163,188,208,182,157,132,106,81,64,47,33,24,48,73,97,121,147,172,198,198,172,148,121,96,71,46,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,71,55,40,27,22,46,70,95,119,145,170,195,199,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,201,178,155,132,110,89,69,50,35,25,28,34,35,30,19,4,0,0,0,2,25,50,76,99,124,152,175])
.concat([200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,4,5,5,5,20,39,59,79,98,117,139,158,177,197,182,163,143,121,103,83,64,44,24,5,0,0,0,0,0,16,40,64,88,111,137,162,185,183,160,135,109,86,61,37,13,0,0,0,0,0,12,36,60,83,106,132,154,174,194,189,171,154,139,129,116,106,98,90,81,73,63,53,41,30,16,2,0,0,0,0,0,0,0,0,15,32,47,58,69,75,78,78,74,67,57,45,29,13,0,0,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,18,10,35,60,85,109,137,162,186,208,182,157,132,106,81,55,30,13,20,45,70,93,119,147,172,195,198,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,21,6,19,43,68,93,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,192,168,145,121,98,76,55,33,15,2,4,9,10,6,0,0,0,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,0,14,34,53,73,92,112,134,153,172,191,188,168,148,129,109,88,69,50,30,10,0,0,0,0,0,0,13,37,61,85,109,134,159,183,180,156,132,106,83,58,34,10,0,0,0,0,0,6,30,53,75,98,119,140,160,179,195,188,173,160,149,139,132,121,113,104,95,84,74,63,50,36,20,4,0,0,0,0,0,0,0,0,13,26,37,45,51,53,53,51,45,36,24,11,0,0,0,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,35,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,19,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,88,65,42,20,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,0,9,28,48,67,87,107,129,146,166,186,194,174,154,135,114,95,75,55,36,16,0,0,0,0,0,0,0,10,34,58,82,106,132,156,180,177,153,129,104,80,55,31,7,0,0,0,0,0,0,21,43,65,86,105,124,144,161,175,188,194,182,171,162,154,145,137,129,117,107,96,84,69,55,38,22,4,0,0,0,0,0,0,0,0,4,15,22,27,29,29,26,20,13,3,0,0,0,0,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,3,23,42,62,81,101,121,141,161,180,199,179,160,141,119,100,81,61,41,21,2,0,0,0,0,0,0,0,7,31,55,80,104,129,153,177,175,150,124,101,77,53,28,4,0,0,0,0,0,0,11,31,51,72,91,108,124,141,155,167,178,188,193,184,176,168,160,150,140,130,117,103,89,73,56,38,19,0,0,0,0,0,0,0,0,0,0,0,3,5,5,2,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,0,17,37,56,76,95,115,136,155,174,194,186,165,146,124,106,86,67,47,27,8,0,0,0,0,0,0,0,0,5,29,53,77,101,124,150,175,172,147,121,98,73,50,25,2,0,0,0,0,0,0,0,17,38,56,73,91,106,119,134,145,155,165,174,183,193,191,182,172,163,152,139,123,107,91,72,52,33,11,0,0,0,0,0,0,0,0,0,1,5,7,7,5,0,0,0,0,0,0,0,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,0,0,0,12,31,51,70,90,109,130,150,169,189,191,172,152,132,112,92,72,52,33,13,0,0,0,0,0,0,0,0,0,2,26,50,73,99,121,147,172,169,144,119,96,71,47,22,0,0,0,0,0,0,0,0,3,21,38,56,72,86,99,110,121,134,143,152,161,170,180,190,195,184,172,158,143,124,107,86,65,45,22,0,0,0,0,0,0,0,6,17,24,29,30,30,29,23,15,5,0,0,0,0,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,0,0,6,26,45,64,84,104,123,144,164,183,196,177,158,138,117,98,78,58,39,19,0,0,0,0,0,0,0,0,0,0,0,23,48,71,96,119,144,170,166,142,116,93,68,45,20,0,0,0,0,0,0,0,0,0,4,22,38,52,66,79,90,100,109,119,129,139,148,157,169,181,195,192,177,161,141,119,98,76,55,32,9,0,0,0,0,0,15,28,39,48,54,55,55,53,46,38,26,13,0,0,0,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,152,175,200,193,170,144,116,93,68,43,20,0,20,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,0,0,20,40,59,79,98,117,139,158,178,197,183,163,144,123,103,83,64,44,25,5,0,0,0,0,0,0,0,0,0,0,0,20,45,68,93,116,142,149,149,139,114,90,65,42,17,0,0,0,0,0,0,0,0,0,7,22,31,35,45,57,67,78,87,96,106,115,124,136,147,161,177,195,195,175,154,132,109,86,64,40,17,0,0,0,1,17,34,49,61,71,77,81,80,77,69,59,47,31,15,0,0,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,152,175,200,193,170,144,118,93,69,45,21,8,24,43,68,93,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,0,14,34,53,74,92,112,134,152,172,192,189,169,149,130,109,89,70,50,31,11,7,7,7,7,7,4,0,0,0,0,0,0,17,42,65,91,113,121,121,121,121,110,86,63,39,14,0,0,0,0,0,0,0,0,7,24,41,53,58,56,45,46,56,65,74,83,93,102,113,124,143,161,180,202,187,164,141,116,93,70,45,22,0,0,0,16,34,51,67,82,93,101,104,104,100,91,79,65,49,30,12,0,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,2,25,50,76,99,124,150,175,199,195,171,147,119,96,73,48,24,28,42,58,77,96,116,144,170,193,198,175,149,121,99,73,48,25,0,0,0,0,9,28,48,67,88,107,129,147,167,186,194,174,155,136,114,95,75,56,36,33,33,33,33,33,33,32,28,20,6,0,0,0,0,14,37,59,80,96,99,99,99,99,95,77,56,33,10,0,0,0,0,0,0,0,2,21,41,60,75,83,79,66,52,38,42,51,61,70,80,92,107,124,147,169,192,195,170,147,121,96,73,48,25,0,0,7,29,49,68,85,101,115,124,132,130,123,113,99,83,64,45,24,4,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,25,49,73,98,121,149,172,197,198,175,150,124,101,78,55,47,50,62,76,94,112,132,150,172,195,198,175,149,121,99,73,48,25,0,0,0,3,23,43,62,81,101,121,141,161,181,200,180,161,141,119,101,81,61,58,58,58,58,58,58,58,58,58,52,41,24,6,0,0,0,6,27,47,63,74,76,76,76,76,73,61,44,24,2,0,0,0,0,0,0,0,16,35,55,74,94,109,99,86,72,59,47,39,38,48,58,73,91,114,139,163,188,198,172,149,121,99,73,48,25,0,0,18,39,61,82,101,119,137,148,154,154,147,134,116,98,78,56,35,13,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,22,47,71,95,119,144,169,193,203,180,156,134,109,89,75,71,74,83,96,112,130,148,166,185,205,198,175,149,121,99,73,48,25,0,0,0,17,37,57,76,95,115,136,155,175,194,186,166,146,124,106,87,83,83,83,83,83,83,83,83,83,83,83,75,58,39,18,0,0,0,0,13,31,44,52,53,53,53,53,51,42,28,11,0,0,0,0,0,0,0,10,30,50,69,89,109,130,119,105,92,80,69,62,58,55,58,69,90,114,139,164,188,195,171,147,121,96,73,48,25,0,1,25,48,70,92,114,136,155,170,178,178,168,152,132,109,89,65,43,20,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,19,43,67,91,115,140,164,188,211,188,166,144,124,108,99,96,98,105,116,132,148,164,180,186,200,198,175,149,121,99,73,48,25,0,0,12,31,51,71,90,109,130,150,170,189,197,174,152,134,112,106,106,106,106,106,106,106,106,106,106,106,106,106,92,72,48,25,0,0,0,0,0,12,23,29,30,30,30,30,28,22,10,0,0,0,0,0,0,0,5,24,45,64,83,103,123,144,141,124,114,101,93,86,82,81,83,89,103,123,145,168,192,189,166,143,117,93,70,46,22,0,6,30,53,76,100,121,146,169,188,202,200,184,164,142,117,95,72,48,25,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,14,38,62,86,109,134,157,180,204,199,179,161,144,132,121,119,121,129,139,152,166,161,154,164,184,198,175,149,121,99,73,48,25,0,0,23,45,64,85,104,123,144,164,183,203,196,173,148,134,134,134,134,134,134,134,134,134,134,134,134,134,134,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,59,78,98,117,138,158,161,148,136,124,115,109,106,104,106,111,121,138,157,178,200,180,157,136,111,88,65,41,17,0,10,32,55,80,103,129,152,175,198,221,217,193,170,147,121,98,73,50,27,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,8,32,56,79,102,124,149,171,193,213,195,177,164,154,149,147,148,152,161,172,162,144,130,152,175,198,175,149,121,99,73,48,25,0,4,29,52,75,98,117,139,158,178,197,217,203,183,165,160,160,160,160,160,160,160,160,160,160,160,160,160,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,48,71,92,112,134,153,172,181,169,157,147,140,135,132,132,132,137,144,156,173,191,186,167,146,124,102,80,57,34,12,0,9,32,55,80,102,124,151,174,197,218,215,192,170,147,121,98,73,50,27,0,0,25,50,76,99,124,152,177,203,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,208,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,203,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,1,24,48,70,93,115,138,159,179,197,211,198,186,177,172,172,172,176,177,161,144,129,121,149,172,197,175,149,121,99,73,48,25,0,5,30,53,76,101,124,149,172,192,200,200,200,200,188,185,185,185,185,185,185,185,185,185,185,185,185,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,141,155,167,180,190,179,171,163,160,157,154,157,160,166,177,190,183,168,152,132,112,91,70,48,25,3,0,5,29,52,75,98,121,144,166,185,196,196,181,162,140,116,93,70,47,24,0,0,25,50,76,99,124,152,177,200,190,167,142,114,88,63,40,15,10,33,58,83,109,137,162,185,200,182,157,132,106,81,55,30,5,17,43,68,93,119,144,170,195,200,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,177,200,193,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,193,200,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,177,200,190,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,16,38,59,82,104,124,144,162,177,188,194,198,198,196,191,182,170,157,143,124,109,119,146,170,182,175,149,121,99,73,48,25,0,5,30,53,76,101,124,149,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,175,172,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,47,70,91,106,121,135,147,158,169,177,185,187,183,180,180,180,183,189,182,173,163,149,134,116,98,78,57,37,15,0,0,0,24,46,68,90,112,132,152,165,172,172,163,148,129,107,86,64,41,19,0,0,25,50,76,99,124,152,175,175,175,167,142,114,88,63,40,15,10,33,58,83,109,137,162,175,175,175,157,132,106,81,55,30,5,17,43,68,93,119,144,170,175,175,175,149,121,96,71,48,22,0,0,25,50,76,99,124,152,175,175,175,167,142,116,91,66,40,17,0,17,43,66,91,116,144,167,175,175,175,149,121,99,73,48,22,0,0,22,48,73,99,124,152,175,175,175,165,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,5,28,49,70,90,109,129,143,155,164,170,173,175,172,167,160,149,137,121,107,93,116,143,157,157,157,149,121,99,73,48,25,0,5,30,53,76,101,124,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,76,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,36,56,72,86,99,112,124,136,146,154,161,167,170,172,175,172,170,165,159,151,140,129,114,98,82,63,44,24,3,0,0,0,16,37,58,79,98,116,132,144,149,149,142,130,112,94,75,54,32,11,0,0,25,50,76,99,124,149,149,149,149,149,142,114,88,63,40,15,10,33,58,83,109,137,149,149,149,149,149,132,106,81,55,30,5,17,43,68,93,119,144,149,149,149,149,149,121,96,71,48,22,0,0,25,50,76,99,124,149,149,149,149,149,142,116,91,66,40,17,0,17,43,66,91,116,144,149,149,149,149,149,121,99,73,48,22,0,0,22,48,73,99,124,149,149,149,149,149,139,111,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,36,55,74,91,108,121,134,142,147,149,149,148,144,137,129,115,101,87,89,114,134,134,134,134,134,121,99,73,48,25,0,4,30,53,75,101,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,75,50,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,21,38,53,67,79,91,103,113,121,132,138,144,147,149,149,149,147,142,137,129,117,107,95,80,64,47,29,10,0,0,0,0,5,26,45,64,82,98,109,119,121,121,117,108,94,78,61,41,22,0,0,0,25,50,75,98,121,121,121,121,121,121,121,113,88,63,40,15,10,32,58,83,108,121,121,121,121,121,121,121,106,80,55,30,4,17,43,68,93,117,121,121,121,121,121,121,119,96,70,48,22,0,0,25,50,75,98,121,121,121,121,121,121,121,115,91,65,40,17,0,17,43,65,91,115,121,121,121,121,121,121,119,98,73,48,22,0,0,22,48,73,98,121,121,121,121,121,121,121,110,86,60,35,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,21,40,56,73,88,99,109,116,121,121,121,121,118,112,104,93,81,67,83,103,106,106,106,106,106,106,92,69,45,23,0,1,26,48,69,89,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,69,45,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,19,33,45,58,70,81,90,99,107,113,117,121,121,121,121,119,116,111,104,96,86,74,60,46,30,12,0,0,0,0,0,0,12,31,47,64,77,88,95,99,99,94,87,75,60,44,27,9,0,0,0,21,45,69,87,98,99,99,99,99,99,99,96,79,57,36,11,6,28,52,75,93,99,99,99,99,99,99,99,92,73,50,26,1,14,38,62,83,98,99,99,99,99,99,99,98,85,64,43,19,0,0,21,45,69,87,98,99,99,99,99,99,99,97,81,59,36,14,0,14,38,59,81,97,99,99,99,99,99,99,98,87,66,43,19,0,0,19,43,66,87,98,99,99,99,99,99,99,95,77,55,31,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,38,53,66,77,85,92,96,99,99,96,93,89,81,71,59,48,67,79,81,81,81,81,81,80,73,56,35,15,0,0,16,36,53,67,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,53,33,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,25,37,48,58,68,76,83,89,93,96,99,99,99,96,93,88,81,73,63,53,40,26,11,0,0,0,0,0,0,0,0,13,30,44,56,65,72,73,73,71,65,54,42,27,10,0,0,0,0,12,33,53,66,73,73,73,73,73,73,73,72,61,44,25,3,0,18,40,58,70,73,73,73,73,73,73,73,69,56,38,16,0,5,27,47,64,73,73,73,73,73,73,73,73,65,49,31,9,0,0,12,33,53,66,73,73,73,73,73,73,73,72,62,45,25,5,0,5,27,45,62,72,73,73,73,73,73,73,73,66,51,31,9,0,0,9,31,51,66,73,73,73,73,73,73,73,71,59,42,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,19,33,45,55,63,69,73,73,73,73,70,65,58,49,38,33,47,56,58,58,58,58,58,58,52,40,22,4,0,0,2,19,33,44,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,43,33,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,15,26,36,45,53,60,65,70,73,73,73,73,73,69,64,58,50,41,31,19,7,0,0,0,0,0,0,0,0,0,0,10,23,33,42,47,50,50,47,41,32,21,8,0,0,0,0,0,0,17,33,43,48,48,48,48,48,48,48,47,39,25,10,0,0,4,22,37,46,48,48,48,48,48,48,48,45,35,20,2,0,0,11,28,41,47,48,48,48,48,48,48,48,42,30,15,0,0,0,0,17,33,43,48,48,48,48,48,48,48,47,40,27,10,0,0,0,11,27,40,47,48,48,48,48,48,48,48,43,31,15,0,0,0,0,15,31,43,48,48,48,48,48,48,48,46,38,24,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,22,32,39,44,48,48,48,48,46,41,35,27,16,13,25,32,33,33,33,33,33,32,28,18,4,0,0,0,0,0,11,19,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,19,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,14,22,29,36,41,45,48,50,50,50,48,45,40,34,27,19,8,0,0,0,0,0,0,0,0,0,0,0,0,0,2,11,19,24,25,25,24,18,10,0,0,0,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,24,18,7,0,0,0,0,4,16,23,25,25,25,25,25,25,25,23,15,2,0,0,0,0,9,20,25,25,25,25,25,25,25,25,20,11,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,24,19,8,0,0,0,0,0,8,19,24,25,25,25,25,25,25,25,21,12,0,0,0,0,0,0,12,21,25,25,25,25,25,25,25,24,17,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,15,20,23,25,25,23,21,17,11,3,0,0,1,6,7,7,7,7,7,7,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,12,18,22,25,25,25,25,24,21,17,11,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,5,5,5,5,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,17,23,25,25,25,25,25,25,25,25,22,14,1,0,0,0,0,0,13,21,25,25,25,25,25,25,25,25,22,15,2,0,0,0,0,0,0,12,21,25,25,25,25,25,25,25,25,20,9,0,0,0,0,0,0,0,0,5,17,24,25,25,25,25,25,25,25,21,12,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,24,19,8,0,0,0,0,0,12,21,25,25,25,25,25,25,25,22,14,1,0,0,0,0,4,16,23,25,25,25,25,25,25,25,20,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,20,27,27,27,27,27,27,27,20,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,15,24,27,25,18,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,10,19,26,27,24,14,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,26,39,48,50,50,50,50,50,50,50,50,46,36,21,4,0,0,2,19,35,45,50,50,50,50,50,50,50,50,47,38,22,6,0,0,0,0,19,33,45,50,50,50,50,50,50,50,50,43,30,13,0,0,0,0,0,0,8,26,40,49,50,50,50,50,50,50,50,45,33,17,0,0,0,0,19,35,45,50,50,50,50,50,50,50,49,42,29,11,0,0,0,19,33,45,50,50,50,50,50,50,50,46,36,21,2,0,0,6,24,39,48,50,50,50,50,50,50,50,44,32,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,29,44,52,53,53,53,53,53,51,44,29,13,0,0,0,0,0,0,0,0,0,0,0,0,0,2,19,35,45,53,49,41,32,23,14,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,15,24,33,41,49,50,45,33,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,24,43,60,73,76,76,76,76,76,76,76,76,70,55,38,17,0,0,15,36,53,69,75,76,76,76,76,76,76,76,71,58,39,20,0,0,0,13,35,53,69,76,76,76,76,76,76,76,75,66,49,29,8,0,0,0,0,1,23,43,61,73,76,76,76,76,76,76,75,69,53,33,12,0,0,13,35,53,69,76,76,76,76,76,76,76,74,64,47,26,5,0,12,33,53,69,76,76,76,76,76,76,76,70,55,37,15,0,0,20,41,60,72,76,76,76,76,76,76,75,67,51,31,11,0,0,0,0,0,0,0,0,0,0,0,0,6,26,47,63,74,76,76,76,76,76,74,63,47,26,4,0,0,0,0,0,0,0,0,0,0,0,0,15,35,55,69,76,73,64,55,46,37,29,20,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,11,20,29,38,47,55,64,73,75,69,53,35,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,33,56,77,95,101,101,101,101,101,101,101,101,89,72,51,30,10,5,25,47,69,87,100,101,101,101,101,101,101,101,92,73,51,28,6,0,0,22,45,67,89,101,101,101,101,101,101,101,99,83,63,41,17,0,0,0,0,10,33,56,78,95,101,101,101,101,101,101,101,87,66,44,21,0,0,21,45,69,89,101,101,101,101,101,101,101,98,81,60,37,14,0,21,45,69,87,101,101,101,101,101,101,101,91,71,48,24,1,6,30,53,75,94,101,101,101,101,101,101,101,87,65,43,19,0,0,0,0,0,0,0,0,0,0,0,0,14,36,60,81,98,101,101,101,101,101,98,81,59,36,12,0,0,0,0,0,0,0,0,0,0,0,0,24,46,70,89,101,95,86,77,69,60,51,42,33,24,16,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,16,25,33,42,51,60,69,78,87,95,98,87,66,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,38,60,86,109,124,124,124,124,124,124,124,124,105,84,64,43,23,16,37,58,80,101,123,124,124,124,124,124,124,124,103,81,58,32,10,0,0,25,50,76,98,123,124,124,124,124,124,124,118,95,72,48,24,0,0,0,0,17,41,64,88,112,124,124,124,124,124,124,121,98,73,48,25,0,0,25,50,76,101,123,124,124,124,124,124,124,116,93,68,43,19,3,28,52,76,100,123,124,124,124,124,124,124,103,80,56,31,7,12,36,61,85,109,124,124,124,124,124,124,121,96,71,48,22,0,0,0,0,0,0,0,0,0,0,0,0,17,40,65,88,114,124,124,124,124,124,114,88,65,40,15,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,98,123,117,109,100,91,82,74,65,56,48,39,30,21,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,12,21,30,39,48,57,65,74,83,92,100,109,118,121,98,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,35,57,80,100,121,143,152,152,152,152,152,139,117,97,76,56,35,28,48,70,91,112,136,152,152,152,152,152,139,117,97,76,53,30,7,0,0,23,48,71,93,117,142,152,152,152,152,151,129,102,79,56,32,8,0,0,0,24,48,72,95,119,144,152,152,152,152,141,116,93,70,46,22,0,0,24,48,72,96,119,145,152,152,152,152,147,121,98,73,49,25,9,34,58,82,106,132,152,152,152,152,152,134,109,86,62,37,13,17,41,66,91,114,139,152,152,152,152,142,116,93,69,45,20,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,142,152,152,152,139,114,88,66,40,15,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,142,134,123,114,106,97,88,79,70,61,53,44,35,26,17,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,17,26,35,44,53,62,71,79,88,97,106,114,123,134,142,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,27,47,67,87,107,129,149,170,177,177,172,152,132,109,89,69,48,38,59,81,103,123,146,167,177,177,168,147,124,105,84,64,43,22,0,0,0,16,40,63,85,109,134,157,177,177,177,158,135,109,86,62,39,15,0,0,8,32,56,78,102,129,151,174,177,177,157,134,109,85,62,39,15,0,0,18,42,65,90,114,139,163,177,177,176,152,129,103,79,55,30,16,40,64,88,111,137,161,177,177,177,165,140,115,92,68,43,19,23,47,72,96,119,144,169,177,177,160,137,110,86,62,39,14,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,142,165,175,165,139,114,88,66,40,15,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,152,155,147,138,129,119,110,101,93,84,75,66,57,49,40,31,22,13,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,14,22,31,40,49,57,66,75,84,93,101,110,119,129,138,147,155,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,33,54,74,95,115,136,156,177,197,184,164,144,121,101,81,61,49,71,92,114,136,157,179,197,177,156,135,114,92,72,51,31,11,0,0,0,8,32,54,77,101,124,149,172,196,188,165,142,116,93,70,46,22,0,0,15,39,62,86,109,135,158,181,196,172,149,124,101,77,54,31,8,0,0,12,36,59,83,107,132,156,180,203,182,157,134,109,85,60,36,22,46,70,94,117,143,167,191,203,195,171,147,121,98,74,49,25,29,53,77,101,124,150,175,199,177,154,130,104,80,56,33,8,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,142,165,190,165,139,114,88,66,40,15,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,152,175,170,161,152,144,135,124,115,107,98,89,81,72,63,54,45,36,27,19,10,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,10,19,28,36,45,54,63,72,81,90,98,107,116,124,135,144,152,161,170,175,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,41,61,81,101,121,144,163,184,197,177,156,136,114,93,73,61,82,104,124,147,169,190,184,164,144,121,101,80,59,39,18,0,0,0,0,0,23,46,69,93,116,141,164,188,196,172,149,124,101,77,53,29,6,0,22,46,70,93,116,142,165,188,188,164,141,116,93,69,46,23,0,0,0,5,29,53,77,101,124,150,174,198,188,163,139,114,90,65,42,27,52,76,100,124,149,173,197,198,201,177,152,129,104,80,56,32,34,58,83,106,132,155,180,196,171,147,121,98,74,50,27,2,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,142,165,190,165,139,114,88,66,40,15,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,152,175,188,183,174,165,156,148,139,130,119,112,103,93,85,76,67,59,50,41,32,24,15,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,15,24,33,41,50,59,68,77,85,94,103,112,121,132,139,148,157,166,174,183,188,175,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,28,48,68,89,109,130,150,171,191,189,169,148,129,106,85,72,93,114,137,158,180,192,172,152,132,109,88,67,47,27,6,0,0,0,0,0,15,38,61,85,109,132,155,180,203,180,156,132,107,84,61,36,13,6,29,53,77,100,124,149,172,196,180,156,134,109,85,61,38,15,0,0,0,0,23,47,70,95,119,144,167,191,193,169,145,119,96,71,47,33,58,82,106,132,155,179,177,172,179,183,159,135,110,86,62,38,40,64,88,112,138,162,186,189,165,142,116,93,68,44,20,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,142,165,190,165,139,114,88,66,40,15,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,149,157,165,173,181,188,180,171,162,153,144,136,124,116,108,99,90,81,73,64,55,46,37,29,20,11,2,0,0,0,0,0,0,0,0,2,11,20,29,38,47,55,64,73,82,90,99,108,116,124,136,144,153,162,171,180,188,181,173,164,156,148,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,35,55,76,96,116,137,158,178,198,181,161,140,117,97,82,103,124,148,170,191,180,160,139,117,96,76,55,34,14,0,0,0,0,0,0,7,30,53,77,100,123,147,172,195,187,163,139,114,91,68,44,20,13,36,61,84,107,132,156,180,196,172,148,124,101,77,53,30,7,0,0,0,0,17,40,64,88,113,137,161,185,199,175,151,124,101,77,53,40,64,88,112,137,161,175,155,147,159,181,165,141,116,92,68,44,45,69,93,118,144,167,191,183,160,136,110,86,62,38,14,0,0,0,0,0,0,0,2,2,2,2,2,2,17,40,66,88,114,142,165,190,165,139,114,88,66,40,15,2,2,2,2,2,2,0,0,0,0,0,2,27,50,75,97,116,124,134,142,150,158,166,174,182,185,176,167,158,149,140,132,121,113,104,96,87,78,69,60,51,42,34,25,15,2,0,0,0,0,2,15,25,34,43,52,61,69,78,87,96,105,114,121,132,141,150,158,167,176,185,182,174,166,158,150,142,134,124,116,97,72,50,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,22,42,62,83,103,123,145,165,185,194,172,152,130,108,92,113,137,158,180,188,167,147,124,105,84,64,43,22,2,0,0,0,0,0,0,0,22,45,69,92,115,139,163,187,194,171,147,121,98,75,51,27,20,44,68,91,114,139,163,187,188,164,140,116,93,69,45,22,0,0,0,0,0,11,34,58,82,106,132,155,179,203,180,156,132,106,83,58,46,70,94,118,143,167,169,144,124,151,175,171,147,121,98,74,50,51,75,99,124,149,173,197,177,153,129,104,80,56,32,8,0,0,0,0,2,15,24,27,27,27,27,27,27,27,40,66,88,114,142,165,190,165,139,114,88,66,40,27,27,27,27,27,27,27,24,14,2,0,0,0,21,43,64,83,94,102,110,118,129,136,144,152,160,168,176,184,180,172,163,154,145,137,129,117,109,100,91,82,74,65,56,47,36,19,1,0,0,2,21,36,48,57,65,74,83,92,101,109,118,129,137,146,155,163,172,181,184,176,168,160,152,144,136,129,117,109,101,93,82,64,42,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,29,50,69,90,110,132,152,172,192,184,163,141,119,103,124,147,169,190,175,155,135,113,92,72,51,30,10,0,0,0,0,0,0,0,0,14,37,61,84,107,132,155,179,201,178,154,130,106,82,58,35,27,51,75,98,121,147,170,194,180,156,132,108,85,61,38,15,0,0,0,0,0,4,28,52,76,100,124,148,172,197,185,162,138,112,88,64,51,76,100,124,149,173,165,139,119,146,170,177,153,129,104,80,56,56,80,105,132,155,178,195,171,147,121,98,74,49,26,2,0,0,0,2,21,36,48,53,53,53,53,53,53,53,53,66,88,114,142,165,190,165,139,114,88,66,53,53,53,53,53,53,53,53,47,36,19,1,0,0,10,30,49,62,71,79,87,95,103,111,119,129,137,144,152,160,168,177,185,177,168,160,151,142,134,123,114,106,97,88,79,69,53,35,13,0,0,15,35,55,69,80,89,97,106,115,123,134,143,151,160,169,178,184,176,168,160,152,144,137,129,119,110,103,95,86,78,70,62,47,30,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,36,57,77,97,117,139,159,179,196,174,154,134,113,136,157,179,184,163,143,121,100,80,59,39,18,0,0,0,0,0,0,0,0,0,6,29,53,76,99,121,147,171,193,185,161,137,113,90,65,41,34,58,82,106,130,154,178,195,172,148,123,100,77,53,30,7,0,0,0,0,0,0,21,45,69,93,117,142,166,191,191,167,144,117,93,70,57,82,106,132,155,179,160,136,115,141,165,183,160,136,110,86,62,62,86,110,137,160,183,189,165,141,116,92,68,44,20,0,0,0,0,15,35,55,69,76,76,76,76,76,76,76,76,76,88,114,142,165,190,165,139,114,88,76,76,76,76,76,76,76,76,75,69,53,35,13,0,0,0,13,29,40,48,56,64,72,81,89])
.concat([97,105,113,121,130,138,146,154,162,171,179,182,173,164,155,147,138,129,119,110,101,89,67,46,22,0,0,24,46,70,89,101,110,119,129,138,147,156,164,173,182,178,170,162,154,146,138,130,121,113,104,96,88,80,72,64,56,48,40,28,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,23,43,64,84,104,124,146,166,186,187,165,145,124,146,167,189,172,150,130,108,88,67,47,26,5,0,0,0,0,0,0,0,0,0,0,20,45,68,91,114,139,162,185,192,168,144,119,97,73,49,41,65,90,113,137,161,185,187,163,140,115,92,69,45,22,0,0,0,0,0,0,0,15,39,63,87,111,137,160,184,197,173,149,123,99,75,64,88,112,137,160,180,155,132,110,137,160,184,165,142,116,93,68,68,91,116,142,165,189,183,159,135,109,86,62,38,14,0,0,0,0,24,46,70,89,101,101,101,101,101,101,101,101,101,101,114,142,165,190,165,139,114,101,101,101,101,101,101,101,101,101,101,89,67,46,22,0,0,0,0,8,17,25,33,41,49,57,65,73,81,90,98,106,114,121,132,139,147,155,163,172,180,178,170,161,152,144,135,121,98,73,50,25,0,2,27,50,76,99,123,135,144,152,161,170,179,180,172,163,155,147,139,132,121,114,106,98,90,81,73,65,57,49,41,33,24,16,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,30,51,71,91,112,132,154,173,194,178,161,152,161,178,179,159,138,116,96,75,55,34,14,0,0,0,0,0,0,0,0,0,0,0,12,36,60,83,106,132,154,177,199,176,152,129,104,80,56,49,73,97,119,144,168,192,179,155,132,108,85,61,37,14,0,0,0,0,0,0,0,9,33,57,81,105,130,154,178,202,178,155,130,104,80,70,93,118,144,167,175,150,124,106,132,155,180,172,147,121,98,74,73,97,121,147,171,195,177,152,129,103,80,56,32,8,0,0,0,2,27,50,76,98,123,124,124,124,124,124,124,124,124,124,124,142,165,190,165,139,124,124,124,124,124,124,124,124,124,124,121,98,73,50,25,0,0,0,0,0,0,2,10,18,26,34,42,50,58,66,74,82,90,99,107,115,123,132,140,149,157,167,184,184,175,166,149,121,99,73,50,25,0,2,27,50,76,99,124,152,166,175,184,183,167,156,148,140,132,123,115,106,98,90,82,74,66,58,50,42,34,26,17,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,38,58,78,98,118,140,161,180,195,181,177,181,188,167,147,124,105,83,63,42,22,1,0,0,0,0,0,0,0,0,0,0,0,4,28,52,75,98,121,146,169,192,183,159,136,111,87,63,56,80,103,129,152,175,195,171,148,123,100,77,53,29,6,0,0,0,0,0,0,0,3,26,51,75,98,121,147,172,196,184,160,136,110,86,75,100,124,149,173,170,145,119,101,124,150,175,177,154,130,104,80,78,103,129,152,176,195,171,147,121,98,73,49,25,1,0,0,0,2,27,50,76,99,124,152,152,152,152,152,152,152,152,152,152,156,172,195,172,155,152,152,152,152,152,152,152,152,152,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,4,12,20,28,36,44,52,60,68,76,84,93,101,109,116,124,135,152,173,198,197,175,149,121,99,73,50,25,0,2,27,50,76,99,124,152,175,197,198,173,152,134,124,116,109,100,92,84,76,68,60,52,44,36,27,19,11,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,24,45,65,86,105,129,148,170,195,205,203,197,175,155,135,112,92,71,50,30,9,0,0,0,0,0,0,0,0,0,0,0,0,0,20,44,66,90,114,138,161,184,190,166,143,118,94,70,63,87,111,136,159,183,187,163,140,115,92,69,45,22,0,0,0,0,0,0,0,0,0,20,44,69,92,116,141,165,189,189,165,141,116,91,81,106,132,155,179,165,139,114,96,119,144,169,183,160,137,110,86,84,109,134,158,182,189,165,140,115,91,68,43,19,0,0,0,0,2,27,50,76,99,124,152,175,175,175,175,175,175,175,175,175,177,190,206,188,177,175,175,175,175,175,175,175,175,175,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,5,13,21,29,37,45,53,62,70,78,86,94,102,110,118,129,137,153,174,199,196,175,149,121,99,73,50,25,0,2,27,50,76,99,124,152,175,196,198,174,152,136,129,118,110,102,94,86,77,69,61,53,45,37,29,21,13,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,27,47,67,88,108,130,150,172,194,215,215,193,167,144,121,99,79,58,38,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,106,130,153,176,197,173,150,124,101,78,71,95,117,143,166,190,179,155,132,107,84,61,37,14,0,0,0,0,0,0,0,0,0,14,38,62,86,109,135,159,183,195,171,147,121,98,88,111,137,161,183,160,135,109,90,114,139,164,188,166,142,116,93,90,114,139,163,188,183,159,134,109,86,62,37,13,0,0,0,0,2,27,50,76,99,124,152,175,175,175,175,175,175,175,175,175,177,188,206,188,176,175,175,175,175,175,175,175,175,175,149,121,99,73,50,25,0,0,0,0,0,0,4,12,20,28,36,44,52,60,68,76,85,93,101,109,116,124,134,143,151,159,169,186,182,173,164,149,121,99,73,50,25,0,2,27,50,76,99,124,152,164,173,182,184,168,158,150,142,134,124,116,109,100,92,84,76,68,60,52,44,36,28,20,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,40,59,80,100,121,143,163,183,192,190,195,195,172,152,132,109,90,69,50,30,9,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,50,73,97,121,144,168,192,180,157,134,109,85,78,102,129,150,173,194,171,147,123,100,76,53,29,6,0,0,0,0,0,0,0,0,0,8,32,56,80,103,129,152,176,200,176,152,129,103,93,118,144,168,178,154,129,104,85,109,134,158,182,172,148,121,98,96,119,145,169,193,176,152,129,103,80,56,31,7,0,0,0,0,2,27,50,76,99,124,149,149,149,149,149,149,149,149,149,149,154,172,194,171,154,149,149,149,149,149,149,149,149,149,149,121,99,73,50,25,0,0,0,0,9,19,27,35,43,51,59,67,75,83,91,99,107,115,124,134,141,149,157,165,173,182,177,168,160,150,141,134,121,98,73,50,25,0,2,27,50,76,98,123,134,142,151,160,168,177,181,173,165,157,149,141,132,123,115,107,99,91,83,75,67,59,51,43,34,26,18,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,32,52,73,92,114,135,155,175,184,169,165,172,188,184,165,144,123,103,83,63,43,23,3,0,0,0,0,0,0,0,0,0,0,0,0,0,19,42,65,89,113,137,160,184,188,165,141,116,92,85,109,134,157,181,186,163,139,115,92,68,45,21,0,0,0,0,0,0,0,0,0,0,1,25,49,73,97,121,146,170,194,182,157,134,108,100,124,150,173,172,147,121,98,79,103,129,152,176,178,154,130,104,100,124,150,174,194,170,147,121,97,73,49,25,1,0,0,0,0,2,27,50,76,98,123,124,124,124,124,124,124,124,124,124,124,142,165,190,165,139,124,124,124,124,124,124,124,124,124,124,121,98,73,50,25,0,0,0,15,31,42,50,58,66,74,82,90,98,106,114,121,132,139,147,156,164,172,180,180,172,163,154,145,137,129,117,109,100,87,66,45,21,0,0,24,45,69,87,100,109,118,129,137,146,154,163,172,180,180,172,163,155,147,139,132,121,114,106,98,90,82,73,65,57,49,41,30,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,24,45,65,86,106,129,148,168,189,170,150,139,154,174,195,178,158,137,116,96,76,56,36,16,0,0,0,0,0,0,0,0,0,0,0,0,0,11,34,57,81,104,129,152,175,195,171,147,121,98,92,115,140,164,188,179,155,132,107,84,60,36,13,0,0,0,0,0,0,0,0,0,0,0,19,43,67,91,114,139,163,188,187,162,138,112,106,132,155,180,166,142,116,93,73,97,121,147,170,184,160,136,110,104,129,154,178,188,164,140,115,91,67,43,19,0,0,0,0,0,0,24,45,69,87,98,99,99,99,99,99,99,99,99,99,114,142,165,190,165,139,114,99,99,99,99,99,99,99,99,99,98,87,66,45,21,0,0,11,32,49,64,73,81,89,97,105,113,121,130,138,146,154,162,171,179,184,176,167,158,149,140,132,121,113,104,95,87,78,69,53,33,13,0,0,14,35,53,69,78,87,96,105,114,121,132,141,149,158,167,176,185,178,170,162,154,146,138,130,121,113,105,97,89,80,72,63,49,30,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,37,57,78,98,118,140,161,181,180,158,137,119,141,162,182,191,171,150,132,109,90,70,49,29,9,0,0,0,0,0,0,0,0,0,0,0,0,3,26,49,73,96,119,144,167,191,178,154,130,105,98,121,147,171,194,171,147,121,99,76,52,28,6,0,0,0,0,0,0,0,0,0,0,0,12,36,61,84,109,134,157,181,191,167,142,116,111,137,161,184,160,137,110,86,67,91,115,140,165,188,165,142,116,109,134,159,183,182,158,134,109,85,61,37,13,0,0,0,0,0,0,14,35,55,69,76,76,76,76,76,76,76,76,76,88,114,142,165,190,165,139,114,88,76,76,76,76,76,76,76,76,75,69,53,33,13,0,0,22,43,66,83,96,104,112,119,129,137,145,153,161,169,178,186,179,170,162,153,144,135,124,116,107,99,90,81,73,64,55,46,33,19,0,0,0,2,19,35,46,55,64,73,81,90,99,108,116,124,136,144,153,162,171,180,185,177,169,161,153,145,137,129,119,112,104,96,83,64,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,29,50,70,91,110,132,154,173,190,169,147,124,107,129,149,170,191,184,164,144,123,103,83,63,43,23,2,0,0,0,0,0,0,0,0,0,0,0,0,18,41,65,88,111,136,159,182,184,160,137,111,106,132,154,178,186,163,139,114,91,68,45,21,0,0,0,0,0,0,0,0,0,0,0,0,6,30,54,78,101,129,152,175,195,170,147,121,116,142,167,178,154,130,105,80,61,85,109,135,159,183,172,147,121,114,139,163,188,176,152,129,103,78,55,31,7,0,0,0,0,0,0,2,19,35,45,50,50,50,50,50,50,50,50,66,88,114,142,165,190,165,139,114,88,66,50,50,50,50,50,50,50,50,45,33,19,0,0,2,27,50,75,98,118,129,136,144,152,160,168,176,184,183,174,165,157,148,139,130,121,112,103,94,85,76,67,59,50,41,33,24,14,0,0,0,0,0,0,14,24,33,41,50,59,68,77,85,94,103,112,121,132,139,148,157,166,175,183,184,176,168,160,152,144,136,129,117,98,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,22,42,63,83,104,124,146,166,186,179,158,136,114,95,115,137,158,179,198,178,158,137,116,97,76,56,36,16,0,0,0,0,0,0,0,0,0,0,0,0,9,33,57,80,103,129,151,174,191,167,144,118,112,137,161,185,178,155,132,106,84,60,36,13,0,0,0,0,0,0,0,0,0,0,0,0,0,24,48,72,96,119,145,168,192,175,151,124,121,147,172,172,148,123,98,75,56,79,103,129,152,176,177,152,129,117,143,167,192,170,146,121,97,73,49,25,1,0,0,0,0,0,0,0,2,14,24,27,27,27,27,27,27,27,40,66,88,114,142,165,190,165,139,114,88,66,40,27,27,27,27,27,27,27,23,14,0,0,0,2,27,50,76,99,124,151,159,167,175,183,187,178,169,160,152,143,134,124,115,106,98,89,80,71,62,54,45,36,27,18,9,0,0,0,0,0,0,0,0,0,1,10,19,27,36,45,54,63,72,80,89,98,107,115,124,135,143,152,161,170,178,187,183,175,167,159,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,35,55,76,96,116,138,158,179,190,169,147,124,103,82,103,123,146,166,187,191,171,150,132,109,90,69,49,29,9,0,0,0,0,0,0,0,0,0,0,0,1,24,49,72,95,118,143,166,189,174,150,124,119,144,168,192,170,147,121,99,76,52,28,5,0,0,0,0,0,0,0,0,0,0,0,0,0,17,41,65,90,114,139,162,186,180,155,132,129,152,176,166,142,116,93,69,49,73,98,121,147,170,183,158,134,121,147,172,188,163,139,114,91,67,43,19,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,17,40,66,88,114,142,165,190,165,139,114,88,66,40,15,2,2,2,2,2,2,0,0,0,0,0,2,27,50,76,99,124,152,175,190,181,173,164,155,146,138,129,118,110,101,92,84,75,66,57,49,40,31,22,13,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,13,22,31,40,49,57,66,75,84,93,101,110,119,129,138,147,155,164,173,182,189,175,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,28,48,68,88,109,130,150,171,191,179,157,137,114,92,71,91,112,134,154,174,195,184,164,144,123,103,83,63,43,23,2,0,0,0,0,0,0,0,0,0,0,0,16,40,64,87,110,135,158,181,180,156,132,124,151,175,185,163,139,114,91,68,44,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,35,59,83,107,132,155,180,184,160,136,132,157,181,160,137,111,87,63,43,67,92,116,141,165,188,163,139,129,152,176,181,157,134,109,85,61,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,142,165,190,165,139,114,88,66,40,15,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,152,175,168,160,150,141,134,123,114,106,97,88,79,70,61,52,44,35,26,17,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,17,26,35,44,53,62,70,79,88,97,106,114,123,134,142,151,160,168,175,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,40,61,81,101,121,144,163,184,188,167,146,124,103,81,60,79,99,119,141,161,181,198,177,158,138,116,96,76,56,36,16,0,0,0,0,0,0,0,0,0,0,0,8,32,56,78,101,124,150,173,187,163,139,134,157,181,177,155,132,106,83,60,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,29,53,77,101,124,150,173,189,164,144,143,162,178,155,132,106,81,57,38,62,86,110,136,159,183,169,148,140,157,181,175,152,129,102,78,54,30,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,142,165,190,165,139,114,88,66,40,15,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,152,154,145,137,129,117,109,100,91,82,73,65,56,47,38,29,21,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,12,21,30,39,47,56,65,73,82,91,100,109,117,129,137,145,154,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,32,53,74,93,114,136,156,177,197,177,155,135,112,91,70,49,66,86,107,129,148,169,189,191,171,152,132,109,89,69,50,29,10,0,0,0,0,0,0,0,0,0,0,0,24,48,70,93,117,142,165,188,174,157,155,168,189,170,147,121,98,75,52,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,46,70,94,118,144,167,191,179,167,165,177,172,148,124,99,75,51,32,56,80,104,129,153,177,182,168,165,174,192,169,145,121,96,72,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,142,165,190,165,139,114,88,66,40,15,0,0,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,140,132,121,113,104,95,86,77,69,60,51,42,33,24,16,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,16,25,34,42,51,60,69,78,87,96,104,113,121,132,140,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,25,45,66,86,107,129,148,169,189,186,165,144,121,100,79,58,38,53,73,93,114,136,155,175,196,184,164,144,123,103,83,63,43,23,2,0,0,0,0,0,0,0,0,0,0,16,39,62,85,109,134,156,180,192,181,180,188,185,162,139,114,90,67,44,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,64,88,112,137,160,185,199,191,190,191,167,143,117,93,69,45,26,50,74,98,121,147,171,196,192,190,196,188,163,139,114,91,66,42,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,142,165,175,165,139,114,88,66,40,15,0,0,0,0,0,0,0,0,0,0,0,2,27,50,75,98,121,116,107,99,90,81,73,64,55,46,37,28,19,11,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,11,20,28,37,46,55,64,73,81,90,99,108,116,119,98,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,38,58,79,99,119,141,161,175,175,174,153,132,109,89,67,47,25,40,60,81,101,121,143,163,175,175,175,158,137,116,96,76,56,36,14,0,0,0,0,0,0,0,0,0,0,8,31,54,77,101,124,148,172,175,175,175,175,175,154,132,106,82,59,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,33,57,82,106,132,155,175,175,175,175,175,160,137,111,88,64,39,20,44,68,93,116,142,165,175,175,175,175,175,157,134,109,85,60,36,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,66,88,114,142,149,149,149,139,114,88,66,40,15,0,0,0,0,0,0,0,0,0,0,0,0,24,45,69,87,98,93,85,76,67,58,49,41,32,23,14,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,15,24,32,41,50,58,67,76,85,93,98,87,66,45,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,48,69,91,112,134,149,149,149,149,149,141,119,98,78,56,34,14,27,47,67,88,108,130,149,149,149,149,149,149,132,109,90,67,45,21,0,0,0,0,0,0,0,0,0,0,0,23,46,69,93,116,140,149,149,149,149,149,149,146,121,98,74,51,28,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,51,75,99,123,148,149,149,149,149,149,149,132,106,82,57,33,14,38,62,86,110,136,149,149,149,149,149,149,149,124,102,78,54,30,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,40,65,88,113,121,121,121,121,121,113,88,65,40,15,0,0,0,0,0,0,0,0,0,0,0,0,14,33,53,66,73,71,62,54,45,36,27,18,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,10,19,27,36,45,54,63,71,73,66,51,33,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,50,73,96,119,121,121,121,121,121,121,121,108,87,65,45,23,3,14,34,55,75,95,116,121,121,121,121,121,121,121,117,93,70,48,22,0,0,0,0,0,0,0,0,0,0,0,15,38,61,85,108,121,121,121,121,121,121,121,121,113,90,66,43,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,45,69,93,116,121,121,121,121,121,121,121,121,100,76,52,27,8,32,56,81,105,121,121,121,121,121,121,121,121,117,96,72,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,36,59,79,96,99,99,99,99,99,96,79,59,36,11,0,0,0,0,0,0,0,0,0,0,0,0,2,19,35,45,50,48,39,31,22,13,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,13,22,31,40,48,50,45,33,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,45,66,87,98,99,99,99,99,99,99,99,92,74,54,33,12,0,1,21,41,62,81,96,99,99,99,99,99,99,99,98,85,64,43,21,0,0,0,0,0,0,0,0,0,0,0,7,30,53,75,93,99,99,99,99,99,99,99,99,96,79,58,35,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,38,62,82,97,99,99,99,99,99,99,99,98,87,69,45,21,2,26,50,72,90,99,99,99,99,99,99,99,99,98,85,64,41,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,25,45,61,72,73,73,73,73,73,72,61,45,25,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,21,25,23,17,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,17,24,25,21,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,33,51,66,73,73,73,73,73,73,73,73,69,58,40,21,0,0,0,8,28,47,62,72,73,73,73,73,73,73,73,73,65,49,31,9,0,0,0,0,0,0,0,0,0,0,0,0,19,40,58,70,73,73,73,73,73,73,73,73,72,61,44,25,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,27,47,64,72,73,73,73,73,73,73,73,73,66,53,33,12,0,16,38,55,68,73,73,73,73,73,73,73,73,73,65,49,29,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,29,41,49,50,50,50,50,50,49,41,29,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,31,43,48,48,48,48,48,48,48,48,45,37,22,6,0,0,0,0,12,28,40,47,48,48,48,48,48,48,48,47,42,30,15,0,0,0,0,0,0,0,0,0,0,0,0,0,4,22,37,46,48,48,48,48,48,48,48,48,47,39,25,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,28,41,47,48,48,48,48,48,48,48,48,43,33,17,0,0,2,20,34,45,48,48,48,48,48,48,48,48,47,42,30,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,18,24,25,25,25,25,25,24,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,18,22,22,22,22,22,22,22,22,20,14,3,0,0,0,0,0,0,7,16,22,22,22,22,22,22,22,22,22,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,21,22,22,22,22,22,22,22,22,22,16,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,17,22,22,22,22,22,22,22,22,22,19,11,0,0,0,0,0,13,20,22,22,22,22,22,22,22,22,22,18,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,5,5,5,5,5,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,7,7,7,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,1,0,0,0,0,0,0,0,0,4,7,7,7,7,7,7,7,7,3,0,0,4,7,7,7,7,7,7,7,7,4,0,0,0,0,0,0,0,0,0,0,0,6,11,12,12,11,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,7,7,7,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,17,20,20,20,20,20,20,20,20,15,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,18,26,27,27,27,27,27,27,25,16,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,15,23,29,31,32,30,26,19,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,14,24,27,27,27,27,27,22,11,0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,26,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,25,15,2,0,0,0,0,5,17,27,30,30,30,30,30,30,30,30,25,16,17,27,30,30,30,30,30,30,30,30,26,16,4,0,0,0,0,0,0,0,9,20,28,33,35,35,32,27,19,8,0,0,0,0,0,0,0,0,0,0,0,0,0,4,14,22,27,30,33,30,28,22,15,4,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,18,28,42,43,43,43,43,43,43,43,42,35,24,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,26,40,50,53,53,53,53,53,53,49,38,22,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,26,37,45,51,55,55,53,49,41,31,19,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,35,45,50,50,50,50,50,43,32,15,0,0,0,0,0,0,0,0,0,0,0,3,21,37,48,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,48,36,21,1,0,0,3,22,37,49,53,53,53,53,53,53,53,53,47,36,37,49,53,53,53,53,53,53,53,53,48,36,21,1,0,0,0,0,1,16,30,40,49,55,58,58,54,48,39,28,14,0,0,0,0,0,0,0,0,0,0,1,14,25,35,44,50,53,55,54,51,45,36,25,13,1,0,0,0,0,9,20,24,24,17,7,0,0,0,0,0,0,0,9,27,45,57,63,63,63,63,63,63,63,62,55,40,23,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,42,60,73,76,76,76,76,76,76,71,56,38,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,32,46,57,67,74,78,78,76,71,63,51,38,22,6,0,0,0,0,0,0,0,0,0,0,0,0,13,35,53,69,76,76,76,76,75,66,51,31,9,0,0,0,0,0,0,0,0,0,0,15,36,55,71,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,69,55,35,14,0,0,16,37,56,71,78,78,78,78,78,78,78,78,69,55,56,71,78,78,78,78,78,78,78,78,69,55,35,14,0,0,0,0,17,33,48,61,70,77,80,79,76,69,58,45,31,13,0,0,0,0,0,0,0,0,6,20,34,46,57,66,73,78,78,78,74,67,57,46,34,21,7,0,0,12,28,41,47,46,39,26,11,0,0,0,0,0,0,18,39,60,75,83,83,83,83,83,83,83,82,72,55,35,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,55,76,94,101,101,101,101,101,101,91,73,50,27,3,0,0,0,0,0,0,0,0,0,0,0,0,15,33,49,65,79,89,97,101,101,99,93,83,70,55,38,20,2,0,0,0,0,0,0,0,0,0,0,0,22,46,69,89,101,101,101,101,100,85,64,41,19,0,0,0,0,0,0,0,0,0,0,24,46,70,89,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,89,67,46,22,0,1,24,49,70,91,101,101,101,101,101,101,101,101,87,67,70,89,101,101,101,101,101,101,101,101,89,67,45,22,0,0,0,14,33,49,65,80,91,98,101,101,98,89,78,63,47,29,10,0,0,0,0,0,0,6,22,39,53,66,79,88,96,101,101,101,97,89,78,66,55,41,26,12,7,28,46,62,70,69,59,45,29,15,0,0,0,0,0,25,47,71,90,103,104,104,104,104,104,104,102,87,67,46,26,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,64,87,109,124,124,124,124,124,124,106,82,59,36,12,0,0,0,0,0,0,0,0,0,0,0,7,28,48,65,82,97,109,119,124,124,121,114,103,87,71,54,34,14,0,0,0,0,0,0,0,0,0,0,2,27,51,76,98,123,124,124,124,118,96,71,47,22,0,0,0,0,0,0,0,0,0,2,27,50,76,99,124,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,121,99,73,50,25,0,5,27,53,76,101,124,124,124,124,124,124,124,121,96,73,76,101,123,124,124,124,124,124,124,121,98,73,50,25,0,0,6,26,46,65,83,98,110,119,124,124,119,109,95,80,62,43,22,2,0,0,0,0,4,22,40,56,72,86,99,109,118,124,124,124,118,109,98,87,74,59,45,31,20,40,61,80,93,91,78,63,48,33,18,2,0,0,5,27,53,76,101,123,124,124,124,124,124,124,118,98,78,57,37,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,25,49,72,96,118,143,152,152,152,152,138,114,91,68,44,21,0,0,0,0,0,0,0,0,0,0,0,17,39,59,79,98,114,130,141,148,149,145,136,121,103,86,66,46,25,4,0,0,0,0,0,12,21,25,24,19,29,53,78,101,129,152,152,147,121,98,73,49,25,19,24,25,20,11,0,0,0,0,2,27,50,76,99,124,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,149,121,99,73,50,25,0,4,27,52,76,101,124,149,149,149,149,149,147,121,96,73,76,99,124,149,149,149,149,149,149,121,99,73,49,25,0,0,15,37,57,79,98,116,132,143,148,147,141,130,112,94,75,54,32,11,0,0,0,0,19,38,56,73,91,105,118,132,141,147,150,147,142,132,118,107,92,79,64,50,36,53,73,94,114,110,96,81,66,51,36,19,0,0,5,26,52,73,95,114,134,149,149,149,149,149,132,109,88,68,48,27,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,34,57,81,104,129,152,174,175,175,170,147,123,100,77,53,30,7,0,0,0,0,0,0,0,0,0,1,24,46,69,90,110,132,149,163,170,172,167,155,137,117,98,78,56,34,12,0,0,0,0,17,33,45,50,48,42,37,55,80,104,130,154,175,149,124,99,76,51,38,43,48,50,44,32,15,0,0,0,2,27,50,76,99,124,152,175,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,175,149,121,99,73,50,25,0,2,27,50,76,99,124,151,175,175,175,172,147,121,96,73,76,99,124,149,175,175,175,172,149,121,96,73,48,25,0,0,23,45,67,89,110,132,149,163,170,170,161,146,129,106,84,63,41,18,0,0,0,14,34,53,72,91,107,124,139,153,163,170,173,170,163,152,140,124,112,98,83,69,60,69,87,107,129,132,114,99,85,70,53,33,12,0,0,20,41,63,82,101,119,139,158,170,170,162,141,119,99,79,58,38,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,43,66,90,113,137,160,183,200,200,179,156,134,109,85,62,39,16,0,0,0,0,0,0,0,0,0,5,29,52,75,98,119,144,164,181,193,195,187,171,150,130,108,86,64,41,19,0,0,0,12,33,51,66,73,72,67,61,58,82,106,132,157,176,152,129,101,78,56,62,67,73,73,65,49,31,9,0,0,2,27,50,76,99,124,152,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,149,121,99,73,50,25,0,2,27,50,76,99,124,149,175,198,195,170,147,119,96,71,73,99,121,149,172,198,196,172,147,121,96,73,48,25,0,4,28,51,74,97,119,143,163,181,192,191,179,160,138,115,93,69,46,23,0,0,6,27,48,67,87,105,124,143,159,173,184,178,177,178,184,173,160,146,132,116,101,89,83,89,103,121,141,149,135,117,103,87,66,44,19,0,0,11,31,50,69,87,107,124,145,164,182,173,153,132,110,90,69,49,28,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,52,75,98,121,146,169,189,181,181,188,164,142,117,94,71,48,24,1,0,0,0,0,0,0,0,0,7,30,53,78,101,124,149,172,195,215,218,203,182,160,139,115,93,70,47,24,0,0,0,22,45,67,87,98,96,91,85,80,84,109,134,159,178,154,132,104,81,80,86,91,97,98,85,64,43,20,0,0,2,27,50,76,99,124,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,73,50,25,0,1,25,50,73,99,121,149,172,198,195,170,147,119,96,71,73,96,121,148,172,198,195,172,147,121,96,72,48,22,0,8,31,55,78,101,124,149,172,195,213,210,190,168,144,119,96,73,50,26,0,0,17,39,60,81,101,121,141,159,177,174,162,155,154,155,164,175,179,165,150,136,121,110,106,110,121,139,155,168,153,138,121,96,73,48,22,0,0,0,18,37,56,74,93,112,132,150,170,184,163,143,121,100,80,59,39,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,38,61,84,107,132,155,178,171,158,160,175,173,150,129,103,80,56,33,10,0,0,0,0,0,0,0,0,7,30,53,77,100,121,147,171,193,209,213,212,190,167,144,119,98,75,51,27,0,0,7,29,53,76,99,121,119,114,109,103,98,111,137,160,180,157,132,106,98,104,109,114,119,119,97,73,50,27,4,0,2,27,50,75,98,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,50,25,0,0,25,48,73,96,121,149,172,198,195,170,146,119,93,71,73,96,121,147,172,195,195,170,147,119,96,71,48,22,0,10,33,55,81,104,129,153,176,199,223,218,195,171,147,121,99,73,50,27,0,0,23,48,72,93,114,136,155,174,171,154,141,132,129,134,143,155,170,184,170,155,143,134,132,134,143,156,171,172,154,134,112,91,69,46,21,0,0,0,6,24,43,62,80,99,117,137,157,175,174,154,134,112,91,71,50,30,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,46,69,93,116,140,163,183,159,137,140,163,182,160,137,112,88,65,42,19,0,0,0,0,0,0,0,0,4,28,51,74,96,118,141,162,178,188,190,194,194,170,147,121,99,76,53,30,0,0,14,36,61,83,106,132,144,139,134,129,121,116,139,162,183,160,134,116,121,129,135,139,145,129,104,81,57,34,11,0,0,24,45,69,87,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,45,21,0,0,25,48,73,96,121,147,172,195,193,170,144,119,93,71,71,96,119,147,170,195,195,170,147,119,95,71,45,22,0,8,31,55,78,101,124,149,172,195,212,209,190,168,144,119,96,73,50,26,0,2,25,50,76,98,123,139,154,168,155,137,119,109,105,110,121,137,150,165,179,174,163,157,154,156,164,175,175,157,139,118,99,79,59,37,15,0,0,0,0,11,29,49,67,86,105,123,144,162,181,165,144,121,101,81,61,41,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,32,55,78,101,124,149,172,175,152,129,132,155,179,168,145,121,97,74,51,28,4,0,0,0,0,0,0,0,0,22,45,67,89,109,130,146,158,165,167,173,188,172,149,121,99,76,53,30,0,0,21,44,68,91,114,139,161,163,158,152,147,142,146,168,186,163,145,143,148,153,159,164,159,136,111,88,65,41,19,0,0,14,33,53,66,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,33,12,0,0,22,48,71,96,119,146,170,194,191,167,144,117,93,70,71,94,119,144,168,193,193,167,144,119,93,71,45,22,0,4,28,51,73,97,119,141,163,180,190,189,177,159,138,115,93,69,46,23,0,0,22,46,67,89,105,119,136,150,139,119,101,88,81,89,103,116,132,146,160,173,186,180,177,180,183,172,157,141,121,103,85,65,45,25,5,0,0,0,0,0,17,36,54,73,92,110,130,149,168,175,155,135,113,92,72,51,31,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,41,64,87,110,135,158,181,167,144,118,123,147,171,177,154,130,106,82,59,36,13,0,0,0,0,0,0,0,0,15,37,57,77,96,112,124,137,142,144,155,176,172,149,121,99,76,53,30,0,2,25,50,75,98,121,146,158,168,178,176,171,165,168,180,196,179,166,166,172,177,176,166,157,144,118,95,72,47,22,0,0,0,19,35,45,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,45,33,19,0,0,0,21,45,69,93,116,143,167,191,188,165,140,114,91,67,68,92,116,142,166,190,190,165,142,116,91,68,43,20,0,0,22,45,67,89,109,130,148,162,169,168,160,144,124,105,84,63,41,18,0,0,14,35,55,71,86,100,115,130,124,105,85,68,58,69,83,97,112,124,140,153,163,170,172,168,162,152,139,121,105,89,70,51,32,12,0,0,0,0,0,0,4,22,41,60,79,98,116,136,155,167,166,146,123,103,83,62,41,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,26,50,73,96,119,144,167,182,159,136,110,115,139,163,186,163,139,114,91,68,45,22,0,0,0,0,0,0,0,0,5,25,45,62,80,93,105,114,116,124,149,172,170,147,121,99,76,53,29,0,1,27,49,74,96,115,124,136,146,155,165,175,186,192,201,213,198,191,183,173,163,154,144,135,123,114,93,72,47,22,0,0,0,2,15,24,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,24,14,2,0,0,0,18,42,67,91,114,140,165,188,185,162,137,111,88,64,66,90,114,139,163,188,187,162,139,113,88,65,40,17,0,0,15,36,57,78,97,114,132,141,147,147,140,129,110,93,74,53,32,10,0,0,1,21,38,52,67,82,96,110,112,92,72,52,37,50,64,78,92,106,119,132,142,147,149,147,140,132,117,104,89,71,55,36,17,0,0,0,0,0,0,0,0,9,28,47,65,84,103,121,143,147,147,147,136,114,93,71,48,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,35,58,81,105,129,152,176,174,151,129,103,107,132,155,178,171,148,123,100,77,54,31,8,0,0,0,0,0,0,0,0,13,30,46,61,74,84,91,106,129,152,175,165,142,118,96,73,50,27,0,0,20,41,63,81,92,101,112,121,132,143,152,166,187,208,223,205,182,162,150,141,132,119,110,101,91,78,61,39,18,0,0,3,21,37,48,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,48,36,21,1,0,0,16,40,64,88,111,137,162,185,183,160,134,109,85,61,63,86,111,137,160,185,184,160,137,109,86,62,38,14,0,0,5,26,45,64,82,98,109,119,121,121,117,108,94,78,61,41,22,0,0,0])
.concat([0,4,19,33,48,63,78,91,92,80,59,38,19,31,45,59,73,87,99,110,118,121,121,121,116,108,98,85,71,55,37,21,2,0,0,0,0,0,0,0,0,0,15,34,53,71,90,109,121,121,121,121,121,119,96,73,48,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,44,67,90,114,138,161,184,166,143,118,95,99,121,147,170,180,156,134,109,86,63,40,16,0,0,0,0,0,0,0,0,0,13,28,42,53,72,92,113,135,157,180,159,137,114,91,69,46,22,0,0,9,29,46,59,70,80,90,99,109,118,132,155,180,203,200,200,175,152,129,117,107,98,88,78,69,58,44,27,6,0,0,15,35,55,69,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,75,69,53,35,13,0,0,13,37,61,85,109,134,159,183,180,156,132,106,82,58,60,83,109,134,157,182,181,157,134,106,83,59,35,11,0,0,0,13,32,49,65,79,90,98,101,101,96,88,76,62,46,28,10,0,0,0,0,0,0,15,30,44,59,69,70,59,46,26,6,12,26,40,54,67,79,89,96,99,99,99,94,87,78,65,52,37,21,4,0,0,0,0,0,0,0,0,0,0,2,21,40,58,77,94,101,101,101,101,101,101,87,67,44,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,29,53,76,99,121,147,170,182,158,135,110,87,91,114,139,162,186,165,142,117,95,72,49,25,1,0,0,0,0,0,0,9,21,31,42,55,69,87,105,123,145,166,172,151,129,106,85,62,40,17,0,0,0,11,26,38,48,57,67,77,97,117,139,161,183,180,175,181,179,157,136,114,92,75,66,56,46,37,25,10,0,0,0,24,46,70,89,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,89,67,46,22,0,0,10,34,58,82,106,132,156,180,177,152,129,104,79,55,58,81,106,132,155,180,178,154,130,104,80,56,32,8,0,0,0,0,17,33,48,59,69,75,78,78,75,68,57,45,30,13,0,0,0,0,0,0,0,0,11,25,38,44,45,39,26,12,0,0,7,21,34,47,58,67,73,76,76,76,72,65,56,45,33,19,4,0,0,0,0,0,0,0,0,0,0,0,0,8,26,45,64,76,81,81,81,81,81,80,73,56,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,38,62,85,108,132,155,179,174,151,129,102,79,83,106,132,154,178,174,151,129,104,81,57,34,10,0,0,0,0,0,9,26,41,53,62,74,87,101,119,139,157,177,162,141,118,98,77,55,33,11,0,0,0,0,5,15,25,46,67,88,109,132,152,173,177,159,149,161,179,170,148,129,105,84,64,43,24,14,4,0,0,0,2,27,50,76,99,124,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,129,121,98,73,50,25,0,0,7,31,55,80,104,129,153,177,175,150,124,101,76,53,55,78,103,129,152,177,175,152,124,101,78,53,29,5,0,0,0,0,1,16,29,39,48,54,55,55,54,47,38,26,13,0,0,0,0,0,0,0,0,0,0,6,16,22,22,17,7,0,0,0,0,1,14,27,36,44,50,53,53,53,49,42,34,24,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,31,46,57,60,60,60,60,60,60,55,42,26,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,47,70,93,116,141,164,188,165,143,118,95,71,75,98,121,145,169,183,160,137,112,89,66,42,19,0,0,0,0,0,21,41,58,73,83,93,106,119,137,154,170,168,149,130,108,88,67,46,24,3,0,0,0,0,0,17,38,59,80,100,121,144,165,179,161,143,124,144,162,181,161,140,117,97,76,55,34,13,0,0,0,0,2,27,50,76,99,124,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,152,149,121,99,73,50,25,0,0,4,28,53,77,101,124,150,175,172,147,121,98,73,50,52,76,101,124,149,175,172,148,121,99,75,50,26,2,0,0,0,0,0,0,8,19,27,32,33,33,31,25,17,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,14,22,27,30,30,29,26,20,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,29,38,40,40,40,40,40,40,36,25,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,33,56,79,102,124,149,173,181,157,134,109,86,63,66,90,113,137,160,184,168,145,121,98,75,51,28,5,0,0,0,7,29,51,72,91,104,114,124,139,154,170,171,154,136,116,96,76,57,36,15,0,0,0,0,0,5,29,50,72,92,113,136,156,177,163,144,124,109,129,146,166,173,153,132,109,88,67,47,24,2,0,0,0,2,27,50,76,99,124,152,175,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,177,175,149,121,99,73,50,25,0,0,2,26,50,73,99,121,147,172,169,144,119,96,71,47,50,73,98,121,147,172,170,145,119,96,72,48,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,41,65,88,111,136,158,181,173,149,124,101,78,55,58,81,105,129,152,176,177,154,132,107,83,60,37,14,0,0,0,10,32,55,78,101,124,136,146,158,172,169,154,137,119,101,83,64,45,25,5,0,0,0,0,0,11,36,59,83,105,124,147,169,165,146,129,109,92,110,130,150,168,165,144,121,101,78,56,31,8,0,0,0,2,27,50,76,99,124,152,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,172,149,121,99,73,50,25,0,0,0,23,48,71,96,119,144,170,166,142,116,93,68,45,47,71,94,119,144,168,167,142,116,93,69,45,20,0,0,0,0,1,13,22,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,21,12,0,0,0,0,0,0,11,19,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,19,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,27,50,73,97,119,144,167,188,164,141,116,93,70,46,49,73,97,119,144,168,186,163,139,115,92,69,46,22,0,0,0,8,30,53,75,97,118,141,163,174,163,150,136,119,103,87,69,51,32,12,0,0,0,0,0,0,12,37,60,85,108,129,143,156,149,130,110,92,76,95,114,134,152,154,139,124,105,80,57,32,9,0,0,0,2,27,50,76,99,124,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,73,50,25,0,0,0,20,45,68,93,116,142,149,149,139,114,90,65,42,44,68,92,116,142,149,149,139,114,91,66,42,17,0,0,0,0,17,31,41,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,41,29,15,0,0,0,0,15,28,39,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,38,27,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,36,59,82,106,130,153,176,180,156,134,108,85,62,38,41,65,88,112,137,160,183,172,148,124,101,78,54,31,8,0,0,1,23,45,67,89,110,132,154,154,143,130,116,101,87,71,53,36,18,0,0,0,0,0,0,0,8,33,54,76,92,107,121,137,134,114,94,76,61,80,98,116,136,135,118,105,90,72,51,28,3,0,0,0,2,27,50,75,98,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,50,25,0,0,0,17,42,65,91,113,121,121,121,121,110,86,63,39,41,65,89,113,121,121,121,121,110,88,63,40,15,0,0,0,11,31,47,60,65,66,66,66,66,66,66,66,66,66,66,66,66,66,65,59,45,29,8,0,0,9,29,45,58,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,57,44,27,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,44,68,91,114,139,162,185,172,148,123,100,77,53,30,33,57,80,103,129,152,175,180,157,135,109,87,63,40,17,0,0,0,15,36,58,80,101,123,141,132,121,110,98,83,69,54,37,21,4,0,0,0,0,0,0,0,0,21,40,58,72,87,101,116,116,98,78,60,45,64,82,99,117,113,99,85,70,56,38,17,0,0,0,0,0,23,45,69,87,98,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,98,87,66,45,21,0,0,0,14,37,59,80,96,99,99,99,99,95,77,56,33,36,58,79,96,99,99,99,99,95,78,57,34,11,0,0,0,21,42,62,79,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,77,59,40,17,0,0,18,41,60,76,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,75,58,39,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,30,53,76,100,123,147,171,187,163,140,115,92,69,45,22,25,49,72,95,118,144,167,189,166,143,118,95,72,49,26,3,0,0,6,28,50,72,93,114,119,110,100,90,78,65,51,37,21,4,0,0,0,0,0,0,0,0,0,6,24,38,53,67,81,94,94,80,62,44,28,47,65,83,96,92,79,64,50,36,21,4,0,0,0,0,0,14,33,53,66,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,66,51,33,12,0,0,0,6,26,47,63,74,76,76,76,76,73,61,44,24,26,45,63,74,76,76,76,76,73,61,45,24,4,0,0,3,27,50,73,94,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,92,69,48,23,0,2,25,49,71,92,103,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,103,90,68,47,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,39,62,85,109,134,156,175,175,155,132,107,84,61,37,14,17,41,64,87,110,135,159,175,175,152,129,104,81,57,34,11,0,0,0,19,41,62,82,96,98,89,80,70,58,46,33,19,4,0,0,0,0,0,0,0,0,0,0,0,5,19,33,48,62,72,70,62,46,28,13,31,49,63,70,70,59,45,31,16,2,0,0,0,0,0,0,0,19,35,45,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,45,33,17,0,0,0,0,0,13,31,44,52,53,53,53,53,51,42,28,11,13,29,44,52,53,53,53,53,51,42,29,11,0,0,0,5,30,53,78,101,124,129,129,129,129,129,129,129,129,129,129,129,129,129,121,99,73,50,25,0,5,27,53,76,101,123,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,121,98,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,46,70,94,117,142,149,149,149,147,121,99,76,52,29,5,8,32,56,79,102,124,149,149,149,149,137,113,90,66,41,18,0,0,0,9,31,49,64,74,75,67,58,49,38,26,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,27,40,47,47,40,27,12,0,15,30,42,47,46,38,25,11,0,0,0,0,0,0,0,0,0,0,13,21,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,21,12,0,0,0,0,0,0,0,12,23,29,30,30,30,30,28,22,10,0,0,11,23,29,30,30,30,30,29,22,11,0,0,0,0,5,30,53,78,101,129,149,149,149,149,149,149,149,149,149,149,149,149,149,121,99,73,50,25,0,5,27,53,76,101,124,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,147,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,48,73,98,121,121,121,121,121,121,114,91,67,44,21,0,0,24,47,70,93,117,121,121,121,121,121,117,93,68,43,20,0,0,0,0,15,32,45,52,52,46,37,28,17,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,16,22,22,16,7,0,0,0,8,18,22,21,15,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,101,129,152,170,170,170,170,170,170,170,170,170,170,170,149,121,99,73,50,25,0,5,27,53,76,101,124,152,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,167,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,43,66,87,98,99,99,99,99,99,96,80,58,36,12,0,0,16,39,62,82,97,99,99,99,99,99,98,83,62,38,16,0,0,0,0,0,11,24,27,27,24,16,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,101,129,152,177,185,185,185,185,185,185,185,185,185,172,149,121,99,73,50,25,0,5,27,53,76,101,124,152,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,149,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,31,51,66,73,73,73,73,73,73,72,61,45,25,3,0,0,6,28,47,64,73,73,73,73,73,73,73,64,47,27,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,101,129,152,165,165,165,165,165,165,165,165,165,165,165,149,121,99,73,50,25,0,5,27,53,76,101,124,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,121,99,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,33,45,50,50,50,50,50,50,49,41,27,10,0,0,0,0,13,30,42,50,50,50,50,50,50,50,43,30,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,30,53,78,101,129,144,144,144,144,144,144,144,144,144,144,144,144,144,121,99,73,50,25,0,4,27,53,75,101,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,50,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,21,25,25,25,25,25,25,24,18,8,0,0,0,0,0,0,9,20,25,25,25,25,25,25,25,20,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,30,53,78,101,121,121,121,121,121,121,121,121,121,121,121,121,121,121,119,98,73,50,25,0,2,24,49,70,91,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,89,67,46,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,27,49,72,91,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,89,67,46,22,0,0,17,40,58,74,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,80,73,56,38,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,40,60,74,81,81,81,81,81,81,81,81,81,81,81,81,81,81,80,73,56,38,15,0,0,7,28,43,56,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,55,42,26,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,28,45,56,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,55,42,26,5,0,0,0,13,26,36,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,36,25,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,28,36,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,36,25,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,0,16,0,15,0,17,0,12,0,16,0,16,0,15,0,13,0,13,0,14,0,22,0,45,0,37,0,45,0,14,0,17,0,18,0,17,0,17,0,18,0,18,0,17,0,18,0,17,0,17,0,26,0,26,0,23,0,27,0,23,0,16,0,17,0,17,0,17,0,16,0,17,0,17,0,17,0,16,0,17,0,17,0,17,0,17,0,17,0,17,0,17,0,16,0,17,0,16,0,17,0,16,0,17,0,17,0,17,0,17,0,17,0,17,0,17,0,14,0,14,0,14,0,16,0,57,0,13,0,25,0,14,0,25,0,14,0,25,0,14,0,25,0,14,0,14,0,14,0,14,0,14,0,25,0,25,0,25,0,25,0,25,0,25,0,25,0,19,0,26,0,26,0,26,0,26,0,26,0,26,0,14,0,12,0,14,0,31,0,0,0,0,0,4,0,4,0,1,0,2,0,1,0,1,0,4,0,4,0,2,0,2,0,1,0,2,0,2,0,3,0,0,0,2,0,4,0,1,0,1,0,1,0,1,0,2,0,2,0,2,0,2,0,3,0,2,0,1,0,1,0,1,0,2,0,2,0,255,255,4,0,2,0,4,0,4,0,4,0,2,0,4,0,4,0,1,0,4,0,4,0,4,0,4,0,2,0,4,0,2,0,4,0,2,0,1,0,4,0,255,255,1,0,0,0,255,255,2,0,5,0,1,0,2,0,3,0,0,0,8,0,2,0,4,0,2,0,2,0,2,0,1,0,2,0,4,0,3,0,253,255,4,0,4,0,4,0,4,0,2,0,4,0,2,0,4,0,1,0,1,0,3,0,0,0,1,0,0,0,0,0,1,0,1,0,4,0,2,0,1,0,0,0,0,0,19,0,29,0,36,0,34,0,55,0,44,0,17,0,22,0,22,0,30,0,36,0,21,0,24,0,19,0,28,0,35,0,32,0,36,0,35,0,37,0,35,0,35,0,35,0,35,0,35,0,19,0,21,0,36,0,36,0,36,0,31,0,54,0,43,0,38,0,39,0,39,0,34,0,33,0,40,0,39,0,18,0,33,0,40,0,33,0,43,0,38,0,43,0,37,0,45,0,38,0,37,0,38,0,39,0,42,0,53,0,40,0,40,0,36,0,21,0,28,0,22,0,33,0,38,0,22,0,34,0,36,0,33,0,36,0,35,0,29,0,37,0,34,0,19,0,25,0,35,0,20,0,50,0,34,0,37,0,36,0,36,0,27,0,32,0,29,0,34,0,37,0,50,0,37,0,37,0,33,0,25,0,16,0,25,0,36,0,0,0,1,0,180,0,88,2,24,1,1,0,180,0,180,0,8,2,1,0,1,0,88,2,49,2,88,2,109,2,88,2,68,0,24,1,217,1,24,1,230,0,217,1,73,1,230,0,217,1,24,1,24,1,8,2,230,0,49,2,88,2,49,2,230,0,68,0,121,1,121,1,180,0,169,1,169,1,169,1,180,0,169,1,169,1,230,0,121,1,24,1,169,1,121,1,180,0,121,1,68,0,121,1,230,0,73,1,230,0,73,1,73,1,73,1,73,1,24,1,1,0,1,0,1,0,88,2,109,2,88,2,217,1,68,0,217,1,128,0,217,1,128,0,68,0,128,0,68,0,1,0,128,0,68,0,8,2,8,2,217,1,128,0,128,0,8,2,8,2,169,1,8,2,49,2,49,2,49,2,128,0,8,2,1,0,1,0,1,0,88,2,0,0,251,0,98,0,125,0,109,0,112,0,42,0,202,0,237,0,44,0,67,0,57,0,128,0,35,0,155,0,155,0,1,0,73,0,75,0,146,0,163,0,37,0,219,0,127,0,1,0,1,0,37,0,34,0,1,0,202,0,88,0,165,0,23,0,76,0,197,0,158,0,118,0,173,0,138,0,104,0,1,0,64,0,45,0,93,0,117,0,220,0,1,0,78,0,158,0,40,0,30,0,1,0,55,0,180,0,199,0,137,0,83,0,42,0,1,0,183,0,90,0,173,0,202,0,1,0,180,0,212,0,216,0,169,0,182,0,1,0,146,0,183,0,131,0,148,0,227,0,18,0,112,0,206,0,54,0,105,0,108,0,75,0,38,0,140,0,1,0,213,0,168,0,39,0,77,0,1,0,213,0,203,0,225,0,1,0,147,0,175,0,0,0,0,0,49,0,28,0,47,0,59,0,49,0,49,0,28,0,61,0,61,0,29,0,37,0,30,0,16,0,20,0,59,0,48,0,46,0,47,0,48,0,46,0,47,0,48,0,46,0,48,0,48,0,39,0,49,0,35,0,28,0,35,0,49,0,57,0,47,0,47,0,49,0,47,0,47,0,47,0,49,0,47,0,47,0,48,0,47,0,47,0,47,0,47,0,49,0,47,0,58,0,47,0,49,0,47,0,48,0,47,0,47,0,47,0,47,0,47,0,59,0,59,0,59,0,33,0,15,0,20,0,40,0,51,0,40,0,51,0,40,0,50,0,52,0,50,0,50,0,62,0,50,0,51,0,39,0,39,0,40,0,50,0,50,0,39,0,40,0,46,0,39,0,38,0,38,0,38,0,50,0,38,0,59,0,66,0,59,0,20,0,0,0,183,0,25,1,173,1,201,1,201,1,237,2,57,2,245,0,33,1,33,1,134,1,201,1,245,0,31,1,245,0,51,1,201,1,201,1,201,1,201,1,201,1,201,1,201,1,201,1,201,1,201,1,245,0,245,0,201,1,201,1,201,1,140,1,12,3,241,1,20,2,1,2,45,2,223,1,198,1,48,2,79,2,251,0,184,1,20,2,191,1,152,2,73,2,89,2,15,2,89,2,22,2,230,1,230,1,72,2,222,1,201,2,226,1,190,1,225,1,33,1,51,1,33,1,201,1,190,1,233,1,210,1,247,1,156,1,247,1,196,1,26,1,207,1,241,1,233,0,234,0,209,1,241,0,239,2,243,1,233,1,247,1,244,1,76,1,128,1,66,1,239,1,185,1,154,2,173,1,185,1,139,1,33,1,227,0,33,1,201,1,0,0,62,180,228,51,9,145,243,51,139,178,1,52,60,32,10,52,35,26,19,52,96,169,28,52,167,215,38,52,75,175,49,52,80,59,61,52,112,135,73,52,35,160,86,52,184,146,100,52,85,109,115,52,136,159,129,52,252,11,138,52,147,4,147,52,105,146,156,52,50,191,166,52,63,149,177,52,147,31,189,52,228,105,201,52,173,128,214,52,54,113,228,52,166,73,243,52,136,140,1,53,192,247,9,53,6,239,18,53,118,123,28,53,192,166,38,53,55,123,49,53,218,3,61,53,94,76,73,53,59,97,86,53,185,79,100,53,252,37,115,53,138,121,129,53,134,227,137,53,124,217,146,53,133,100,156,53,82,142,166,53,51,97,177,53,37,232,188,53,220,46,201,53,206,65,214,53,65,46,228,53,87,2,243,53,143,102,1,54,79,207,9,54,245,195,18,54,152,77,28,54,232,117,38,54,50,71,49,54,116,204,60,54,94,17,73,54,101,34,86,54,206,12,100,54,184,222,114,54,151,83,129,54,28,187,137,54,114,174,146,54,175,54,156,54,129,93,166,54,53,45,177,54,199,176,188,54,228,243,200,54,1,3,214,54,96,235,227,54,30,187,242,54,162,64,1,55,235,166,9,55,241,152,18,55,201,31,28,55,30,69,38,55,61,19,49,55,30,149,60,55,111,214,72,55,162,227,85,55,247,201,99,55,137,151,114,55,175,45,129,55,190,146,137,55,116,131,146,55,230,8,156,55,190,44,166,55,71,249,176,55,121,121,188,55,254,184,200,55,71,196,213,55,146,168,227,55,248,115,242,55,192,26,1,56,147,126,9,56,249,109,18,56,6,242,27,56,98,20,38,56,86,223,48,56,216,93,60,56,146,155,72,56,242,164,85,56,51,135,99,56,110,80,114,56,211,7,129,56,107,106,137,56,130,88,146,56,42,219,155,56,9,252,165,56,104,197,176,56,59,66,188,56,41,126,200,56,160,133,213,56,217,101,227,56,232,44,242,56,233,244,0,57,70,86,9,57,14,67,18,57,81,196,27,57,181,227,37,57,127,171,48,57,162,38,60,57,197,96,72,57,83,102,85,57,131,68,99,57,104,9,114,57,1,226,128,57,36,66,137,57,157,45,146,57,123,173,155,57,99,203,165,57,153,145,176,57,13,11,188,57,102,67,200,57,11,71,213,57,50,35,227,57,237,229,241,57,29,207,0,58,5,46,9,58,48,24,18,58,169,150,27,58,21,179,37,58,183,119,48,58,124,239,59,58,10,38,72,58,199,39,85,58,230,1,99,58,120,194,113,58,59,188,128,58,233,25,137,58,198,2,146,58,219,127,155,58,203,154,165,58,216,93,176,58,239,211,187,58,179,8,200,58,136,8,213,58,159,224,226,58,7,159,241,58,92,169,0,59,208,5,9,59,94,237,17,59,15,105,27,59,132,130,37,59,253,67,48,59,103,184,59,59,97,235,71,59,77,233,84,59,93,191,98,59,156,123,113,59,127,150,128,59,186,241,136,59,249,215,145,59,71,82,155,59,65,106,165,59,39,42,176,59,226,156,187,59,18,206,199,59,23,202,212,59,32,158,226,59,53,88,241,59,166,131,0,60,167,221,8,60,152,194,17,60,130,59,27,60,1,82,37,60,84,16,48,60,97,129,59,60,200,176,71,60,229,170,84,60,232,124,98,60,212,52,113,60,207,112,128,60,150,201,136,60,58,173,145,60,192,36,155,60,197,57,165,60,133,246,175,60,229,101,187,60,130,147,199,60,185,139,212,60,180,91,226,60,121,17,241,60,251,93,0,61,137,181,8,61,223,151,17,61,2,14,27,61,141,33,37,61,185,220,47,61,109,74,59,61,64,118,71,61,145,108,84,61,133,58,98,61,34,238,112,61,42,75,128,61,127,161,136,61,136,130,145,61,72,247,154,61,88,9,165,61,242,194,175,61,248,46,187,61,3,89,199,61,109,77,212,61,92,25,226,61,209,202,240,61,91,56,0,62,119,141,8,62,51,109,17,62,144,224,26,62,39,241,36,62,46,169,47,62,135,19,59,62,202,59,71,62,77,46,84,62,55,248,97,62,132,167,112,62,143,37,128,62,115,121,136,62,226,87,145,62,220,201,154,62,249,216,164,62,109,143,175,62,27,248,186,62,149,30,199,62,51,15,212,62,23,215,225,62,61,132,240,62,198,18,0,63,114,101,8,63,147,66,17,63,43,179,26,63,206,192,36,63,177,117,47,63,178,220,58,63,101,1,71,63,29,240,83,63,251,181,97,63,251,96,112,63,0,0,128,63,0,1,0,5,6,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,3,5,0,0,0,0,3,7,5,0,0,0,3,5,3,5,0,0,3,7,5,3,5,0,3,7,5,3,5,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0])
.concat([2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,13,0,0,0,15,0,0,0,17,0,0,0,19,0,0,0,23,0,0,0,27,0,0,0,31,0,0,0,35,0,0,0,43,0,0,0,51,0,0,0,59,0,0,0,67,0,0,0,83,0,0,0,99,0,0,0,115,0,0,0,131,0,0,0,163,0,0,0,195,0,0,0,227,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,46,186,232,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,7,0,0,0,7,0,0,0,8,0,0,0,8,0,0,0,9,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,11,0,0,0,11,0,0,0,12,0,0,0,12,0,0,0,13,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0])
, "i8", ALLOC_NONE, Runtime.GLOBAL_BASE)
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);
assert(tempDoublePtr % 8 == 0);
function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
}
function copyTempDouble(ptr) {
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];
  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];
  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];
  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];
}
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};
  var ___errno_state=0;function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      HEAP32[((___errno_state)>>2)]=value
      return value;
    }
  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up--; up) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash+1);
      },extname:function (path) {
        return PATH.splitPath(path)[3];
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
      },join2:function (l, r) {
        return PATH.normalize(l + '/' + r);
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            continue;
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  var TTY={ttys:[],init:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          if (stream.tty.output.length) {
            stream.tty.ops.put_char(stream.tty, 10);
          }
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              result = process['stdin']['read']();
              if (!result) {
                if (process['stdin']['_readableState'] && process['stdin']['_readableState']['ended']) {
                  return null;  // EOF
                }
                return undefined;  // no data available
              }
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }}};
  var MEMFS={ops_table:null,CONTENT_OWNING:1,CONTENT_FLEXIBLE:2,CONTENT_FIXED:3,mount:function (mount) {
        return MEMFS.createNode(null, '/', 16384 | 0777, 0);
      },createNode:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek
              }
            },
            file: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              },
              stream: {}
            },
            chrdev: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: FS.chrdev_stream_ops
            },
          };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node;
          node.stream_ops = MEMFS.ops_table.dir.stream;
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node;
          node.stream_ops = MEMFS.ops_table.file.stream;
          node.contents = [];
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node;
          node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node;
          node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },ensureFlexible:function (node) {
        if (node.contentMode !== MEMFS.CONTENT_FLEXIBLE) {
          var contents = node.contents;
          node.contents = Array.prototype.slice.call(contents);
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        }
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.contents.length;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.ensureFlexible(node);
            var contents = node.contents;
            if (attr.size < contents.length) contents.length = attr.size;
            else while (attr.size > contents.length) contents.push(0);
          }
        },lookup:function (parent, name) {
          throw FS.genericErrors[ERRNO_CODES.ENOENT];
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          old_node.parent = new_dir;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 0777 | 40960, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else
          {
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          var node = stream.node;
          node.timestamp = Date.now();
          var contents = node.contents;
          if (length && contents.length === 0 && position === 0 && buffer.subarray) {
            // just replace it with the new data
            if (canOwn && offset === 0) {
              node.contents = buffer; // this could be a subarray of Emscripten HEAP, or allocated from some other source.
              node.contentMode = (buffer.buffer === HEAP8.buffer) ? MEMFS.CONTENT_OWNING : MEMFS.CONTENT_FIXED;
            } else {
              node.contents = new Uint8Array(buffer.subarray(offset, offset+length));
              node.contentMode = MEMFS.CONTENT_FIXED;
            }
            return length;
          }
          MEMFS.ensureFlexible(node);
          var contents = node.contents;
          while (contents.length < position) contents.push(0);
          for (var i = 0; i < length; i++) {
            contents[position + i] = buffer[offset + i];
          }
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.contents.length;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          stream.ungotten = [];
          stream.position = position;
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.ensureFlexible(stream.node);
          var contents = stream.node.contents;
          var limit = offset + length;
          while (limit > contents.length) contents.push(0);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 2) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < contents.length) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        }}};
  var IDBFS={dbs:{},indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",mount:function (mount) {
        return MEMFS.mount.apply(null, arguments);
      },syncfs:function (mount, populate, callback) {
        IDBFS.getLocalSet(mount, function(err, local) {
          if (err) return callback(err);
          IDBFS.getRemoteSet(mount, function(err, remote) {
            if (err) return callback(err);
            var src = populate ? remote : local;
            var dst = populate ? local : remote;
            IDBFS.reconcile(src, dst, callback);
          });
        });
      },reconcile:function (src, dst, callback) {
        var total = 0;
        var create = {};
        for (var key in src.files) {
          if (!src.files.hasOwnProperty(key)) continue;
          var e = src.files[key];
          var e2 = dst.files[key];
          if (!e2 || e.timestamp > e2.timestamp) {
            create[key] = e;
            total++;
          }
        }
        var remove = {};
        for (var key in dst.files) {
          if (!dst.files.hasOwnProperty(key)) continue;
          var e = dst.files[key];
          var e2 = src.files[key];
          if (!e2) {
            remove[key] = e;
            total++;
          }
        }
        if (!total) {
          // early out
          return callback(null);
        }
        var completed = 0;
        function done(err) {
          if (err) return callback(err);
          if (++completed >= total) {
            return callback(null);
          }
        };
        // create a single transaction to handle and IDB reads / writes we'll need to do
        var db = src.type === 'remote' ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readwrite');
        transaction.onerror = function transaction_onerror() { callback(this.error); };
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
        for (var path in create) {
          if (!create.hasOwnProperty(path)) continue;
          var entry = create[path];
          if (dst.type === 'local') {
            // save file to local
            try {
              if (FS.isDir(entry.mode)) {
                FS.mkdir(path, entry.mode);
              } else if (FS.isFile(entry.mode)) {
                var stream = FS.open(path, 'w+', 0666);
                FS.write(stream, entry.contents, 0, entry.contents.length, 0, true /* canOwn */);
                FS.close(stream);
              }
              done(null);
            } catch (e) {
              return done(e);
            }
          } else {
            // save file to IDB
            var req = store.put(entry, path);
            req.onsuccess = function req_onsuccess() { done(null); };
            req.onerror = function req_onerror() { done(this.error); };
          }
        }
        for (var path in remove) {
          if (!remove.hasOwnProperty(path)) continue;
          var entry = remove[path];
          if (dst.type === 'local') {
            // delete file from local
            try {
              if (FS.isDir(entry.mode)) {
                // TODO recursive delete?
                FS.rmdir(path);
              } else if (FS.isFile(entry.mode)) {
                FS.unlink(path);
              }
              done(null);
            } catch (e) {
              return done(e);
            }
          } else {
            // delete file from IDB
            var req = store.delete(path);
            req.onsuccess = function req_onsuccess() { done(null); };
            req.onerror = function req_onerror() { done(this.error); };
          }
        }
      },getLocalSet:function (mount, callback) {
        var files = {};
        function isRealDir(p) {
          return p !== '.' && p !== '..';
        };
        function toAbsolute(root) {
          return function(p) {
            return PATH.join2(root, p);
          }
        };
        var check = FS.readdir(mount.mountpoint)
          .filter(isRealDir)
          .map(toAbsolute(mount.mountpoint));
        while (check.length) {
          var path = check.pop();
          var stat, node;
          try {
            var lookup = FS.lookupPath(path);
            node = lookup.node;
            stat = FS.stat(path);
          } catch (e) {
            return callback(e);
          }
          if (FS.isDir(stat.mode)) {
            check.push.apply(check, FS.readdir(path)
              .filter(isRealDir)
              .map(toAbsolute(path)));
            files[path] = { mode: stat.mode, timestamp: stat.mtime };
          } else if (FS.isFile(stat.mode)) {
            files[path] = { contents: node.contents, mode: stat.mode, timestamp: stat.mtime };
          } else {
            return callback(new Error('node type not supported'));
          }
        }
        return callback(null, { type: 'local', files: files });
      },getDB:function (name, callback) {
        // look it up in the cache
        var db = IDBFS.dbs[name];
        if (db) {
          return callback(null, db);
        }
        var req;
        try {
          req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        req.onupgradeneeded = function req_onupgradeneeded() {
          db = req.result;
          db.createObjectStore(IDBFS.DB_STORE_NAME);
        };
        req.onsuccess = function req_onsuccess() {
          db = req.result;
          // add to the cache
          IDBFS.dbs[name] = db;
          callback(null, db);
        };
        req.onerror = function req_onerror() {
          callback(this.error);
        };
      },getRemoteSet:function (mount, callback) {
        var files = {};
        IDBFS.getDB(mount.mountpoint, function(err, db) {
          if (err) return callback(err);
          var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readonly');
          transaction.onerror = function transaction_onerror() { callback(this.error); };
          var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
          store.openCursor().onsuccess = function store_openCursor_onsuccess(event) {
            var cursor = event.target.result;
            if (!cursor) {
              return callback(null, { type: 'remote', db: db, files: files });
            }
            files[cursor.key] = cursor.value;
            cursor.continue();
          };
        });
      }};
  var NODEFS={isWindows:false,staticInit:function () {
        NODEFS.isWindows = !!process.platform.match(/^win/);
      },mount:function (mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, '/', NODEFS.getMode(mount.opts.root), 0);
      },createNode:function (parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node;
      },getMode:function (path) {
        var stat;
        try {
          stat = fs.lstatSync(path);
          if (NODEFS.isWindows) {
            // On Windows, directories return permission bits 'rw-rw-rw-', even though they have 'rwxrwxrwx', so 
            // propagate write bits to execute bits.
            stat.mode = stat.mode | ((stat.mode & 146) >> 1);
          }
        } catch (e) {
          if (!e.code) throw e;
          throw new FS.ErrnoError(ERRNO_CODES[e.code]);
        }
        return stat.mode;
      },realPath:function (node) {
        var parts = [];
        while (node.parent !== node) {
          parts.push(node.name);
          node = node.parent;
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts);
      },flagsToPermissionStringMap:{0:"r",1:"r+",2:"r+",64:"r",65:"r+",66:"r+",129:"rx+",193:"rx+",514:"w+",577:"w",578:"w+",705:"wx",706:"wx+",1024:"a",1025:"a",1026:"a+",1089:"a",1090:"a+",1153:"ax",1154:"ax+",1217:"ax",1218:"ax+",4096:"rs",4098:"rs+"},flagsToPermissionString:function (flags) {
        if (flags in NODEFS.flagsToPermissionStringMap) {
          return NODEFS.flagsToPermissionStringMap[flags];
        } else {
          return flags;
        }
      },node_ops:{getattr:function (node) {
          var path = NODEFS.realPath(node);
          var stat;
          try {
            stat = fs.lstatSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          // node.js v0.10.20 doesn't report blksize and blocks on Windows. Fake them with default blksize of 4096.
          // See http://support.microsoft.com/kb/140365
          if (NODEFS.isWindows && !stat.blksize) {
            stat.blksize = 4096;
          }
          if (NODEFS.isWindows && !stat.blocks) {
            stat.blocks = (stat.size+stat.blksize-1)/stat.blksize|0;
          }
          return {
            dev: stat.dev,
            ino: stat.ino,
            mode: stat.mode,
            nlink: stat.nlink,
            uid: stat.uid,
            gid: stat.gid,
            rdev: stat.rdev,
            size: stat.size,
            atime: stat.atime,
            mtime: stat.mtime,
            ctime: stat.ctime,
            blksize: stat.blksize,
            blocks: stat.blocks
          };
        },setattr:function (node, attr) {
          var path = NODEFS.realPath(node);
          try {
            if (attr.mode !== undefined) {
              fs.chmodSync(path, attr.mode);
              // update the common node structure mode as well
              node.mode = attr.mode;
            }
            if (attr.timestamp !== undefined) {
              var date = new Date(attr.timestamp);
              fs.utimesSync(path, date, date);
            }
            if (attr.size !== undefined) {
              fs.truncateSync(path, attr.size);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },lookup:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          var mode = NODEFS.getMode(path);
          return NODEFS.createNode(parent, name, mode);
        },mknod:function (parent, name, mode, dev) {
          var node = NODEFS.createNode(parent, name, mode, dev);
          // create the backing node for this in the fs root as well
          var path = NODEFS.realPath(node);
          try {
            if (FS.isDir(node.mode)) {
              fs.mkdirSync(path, node.mode);
            } else {
              fs.writeFileSync(path, '', { mode: node.mode });
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return node;
        },rename:function (oldNode, newDir, newName) {
          var oldPath = NODEFS.realPath(oldNode);
          var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
          try {
            fs.renameSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },unlink:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.unlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },rmdir:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.rmdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readdir:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },symlink:function (parent, newName, oldPath) {
          var newPath = PATH.join2(NODEFS.realPath(parent), newName);
          try {
            fs.symlinkSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readlink:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        }},stream_ops:{open:function (stream) {
          var path = NODEFS.realPath(stream.node);
          try {
            if (FS.isFile(stream.node.mode)) {
              stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags));
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },close:function (stream) {
          try {
            if (FS.isFile(stream.node.mode) && stream.nfd) {
              fs.closeSync(stream.nfd);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },read:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(length);
          var res;
          try {
            res = fs.readSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          if (res > 0) {
            for (var i = 0; i < res; i++) {
              buffer[offset + i] = nbuffer[i];
            }
          }
          return res;
        },write:function (stream, buffer, offset, length, position) {
          // FIXME this is terrible.
          var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
          var res;
          try {
            res = fs.writeSync(stream.nfd, nbuffer, 0, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return res;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              try {
                var stat = fs.fstatSync(stream.nfd);
                position += stat.size;
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
              }
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          stream.position = position;
          return position;
        }}};
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);
  function _fflush(stream) {
      // int fflush(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
      // we don't currently perform any user-space buffering of data
    }var FS={root:null,mounts:[],devices:[null],streams:[null],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,ErrnoError:null,genericErrors:{},handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + stackTrace();
        return ___setErrNo(e.errno);
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || { recurse_count: 0 };
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
        // start at the root
        var current = FS.root;
        var current_path = '/';
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join2(current_path, parts[i]);
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            current = current.mount.root;
          }
          // follow symlinks
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }
        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint;
            if (!path) return mount;
            return mount[mount.length-1] !== '/' ? mount + '/' + path : mount + path;
          }
          path = path ? node.name + '/' + path : node.name;
          node = node.parent;
        }
      },hashName:function (parentid, name) {
        var hash = 0;
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name;
          if (node.parent.id === parent.id && nodeName === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        if (!FS.FSNode) {
          FS.FSNode = function(parent, name, mode, rdev) {
            this.id = FS.nextInode++;
            this.name = name;
            this.mode = mode;
            this.node_ops = {};
            this.stream_ops = {};
            this.rdev = rdev;
            this.parent = null;
            this.mount = null;
            if (!parent) {
              parent = this;  // root node sets parent to itself
            }
            this.parent = parent;
            this.mount = parent.mount;
            FS.hashAddNode(this);
          };
          // compatibility
          var readMode = 292 | 73;
          var writeMode = 146;
          FS.FSNode.prototype = {};
          // NOTE we must use Object.defineProperties instead of individual calls to
          // Object.defineProperty in order to make closure compiler happy
          Object.defineProperties(FS.FSNode.prototype, {
            read: {
              get: function() { return (this.mode & readMode) === readMode; },
              set: function(val) { val ? this.mode |= readMode : this.mode &= ~readMode; }
            },
            write: {
              get: function() { return (this.mode & writeMode) === writeMode; },
              set: function(val) { val ? this.mode |= writeMode : this.mode &= ~writeMode; }
            },
            isFolder: {
              get: function() { return FS.isDir(this.mode); },
            },
            isDevice: {
              get: function() { return FS.isChrdev(this.mode); },
            },
          });
        }
        return new FS.FSNode(parent, name, mode, rdev);
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return node.mounted;
      },isFile:function (mode) {
        return (mode & 61440) === 32768;
      },isDir:function (mode) {
        return (mode & 61440) === 16384;
      },isLink:function (mode) {
        return (mode & 61440) === 40960;
      },isChrdev:function (mode) {
        return (mode & 61440) === 8192;
      },isBlkdev:function (mode) {
        return (mode & 61440) === 24576;
      },isFIFO:function (mode) {
        return (mode & 61440) === 4096;
      },isSocket:function (mode) {
        return (mode & 49152) === 49152;
      },flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var accmode = flag & 2097155;
        var perms = ['r', 'w', 'rw'][accmode];
        if ((flag & 512)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        return FS.nodePermissions(dir, 'x');
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if ((flags & 2097155) !== 0 ||  // opening for write
              (flags & 512)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 1;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = function(){};
          FS.FSStream.prototype = {};
          // compatibility
          Object.defineProperties(FS.FSStream.prototype, {
            object: {
              get: function() { return this.node; },
              set: function(val) { this.node = val; }
            },
            isRead: {
              get: function() { return (this.flags & 2097155) !== 1; }
            },
            isWrite: {
              get: function() { return (this.flags & 2097155) !== 0; }
            },
            isAppend: {
              get: function() { return (this.flags & 1024); }
            }
          });
        }
        if (stream.__proto__) {
          // reuse the object
          stream.__proto__ = FS.FSStream.prototype;
        } else {
          var newStream = new FS.FSStream();
          for (var p in stream) {
            newStream[p] = stream[p];
          }
          stream = newStream;
        }
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },syncfs:function (populate, callback) {
        if (typeof(populate) === 'function') {
          callback = populate;
          populate = false;
        }
        var completed = 0;
        var total = FS.mounts.length;
        function done(err) {
          if (err) {
            return callback(err);
          }
          if (++completed >= total) {
            callback(null);
          }
        };
        // sync all mounts
        for (var i = 0; i < FS.mounts.length; i++) {
          var mount = FS.mounts[i];
          if (!mount.type.syncfs) {
            done(null);
            continue;
          }
          mount.type.syncfs(mount, populate, done);
        }
      },mount:function (type, opts, mountpoint) {
        var lookup;
        if (mountpoint) {
          lookup = FS.lookupPath(mountpoint, { follow: false });
          mountpoint = lookup.path;  // use the absolute path
        }
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          root: null
        };
        // create a root node for the fs
        var root = type.mount(mount);
        root.mount = mount;
        mount.root = root;
        // assign the mount info to the mountpoint's node
        if (lookup) {
          lookup.node.mount = mount;
          lookup.node.mounted = true;
          // compatibility update FS.root if we mount to /
          if (mountpoint === '/') {
            FS.root = mount.root;
          }
        }
        // add to our cached list of mounts
        FS.mounts.push(mount);
        return root;
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode = mode !== undefined ? mode : 0666;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode = mode !== undefined ? mode : 0777;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
      },mkdev:function (path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 0666;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // POSIX says unlink should set EPERM, not EISDIR
          if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
      },readlink:function (path) {
        var lookup = FS.lookupPath(path, { follow: false });
        var link = lookup.node;
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return link.node_ops.readlink(link);
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 0666 : mode;
        if ((flags & 64)) {
          mode = (mode & 4095) | 32768;
        } else {
          mode = 0;
        }
        var node;
        if (typeof path === 'object') {
          node = path;
        } else {
          path = PATH.normalize(path);
          try {
            var lookup = FS.lookupPath(path, {
              follow: !(flags & 131072)
            });
            node = lookup.node;
          } catch (e) {
            // ignore
          }
        }
        // perhaps we need to create the node
        if ((flags & 64)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 128)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~512;
        }
        // check permissions
        var err = FS.mayOpen(node, flags);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // do truncation if necessary
        if ((flags & 512)) {
          FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512);
        // register the stream with the filesystem
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),  // we want the absolute path to the node
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
          if (!FS.readFiles) FS.readFiles = {};
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1;
            Module['printErr']('read file: ' + path);
          }
        }
        return stream;
      },close:function (stream) {
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
      },llseek:function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        return stream.stream_ops.llseek(stream, offset, whence);
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        if (stream.flags & 1024) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.errnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      },ioctl:function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = '';
          var utf8 = new Runtime.UTF8Processor();
          for (var i = 0; i < length; i++) {
            ret += utf8.processCChar(buf[i]);
          }
        } else if (opts.encoding === 'binary') {
          ret = buf;
        } else {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        FS.close(stream);
        return ret;
      },writeFile:function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        opts.encoding = opts.encoding || 'utf8';
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === 'utf8') {
          var utf8 = new Runtime.UTF8Processor();
          var buf = new Uint8Array(utf8.processJSString(data));
          FS.write(stream, buf, 0, buf.length, 0);
        } else if (opts.encoding === 'binary') {
          FS.write(stream, data, 0, data.length, 0);
        } else {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        FS.close(stream);
      },cwd:function () {
        return FS.currentPath;
      },chdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        var err = FS.nodePermissions(lookup.node, 'x');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        FS.currentPath = lookup.path;
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp');
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function() { return 0; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        HEAP32[((_stdin)>>2)]=stdin.fd;
        assert(stdin.fd === 1, 'invalid handle for stdin (' + stdin.fd + ')');
        var stdout = FS.open('/dev/stdout', 'w');
        HEAP32[((_stdout)>>2)]=stdout.fd;
        assert(stdout.fd === 2, 'invalid handle for stdout (' + stdout.fd + ')');
        var stderr = FS.open('/dev/stderr', 'w');
        HEAP32[((_stderr)>>2)]=stderr.fd;
        assert(stderr.fd === 3, 'invalid handle for stderr (' + stderr.fd + ')');
      },ensureErrnoError:function () {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno) {
          this.errno = errno;
          for (var key in ERRNO_CODES) {
            if (ERRNO_CODES[key] === errno) {
              this.code = key;
              break;
            }
          }
          this.message = ERRNO_MESSAGES[errno];
          this.stack = stackTrace();
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [ERRNO_CODES.ENOENT].forEach(function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code);
          FS.genericErrors[code].stack = '<generic error, no stack>';
        });
      },staticInit:function () {
        FS.ensureErrnoError();
        FS.nameTable = new Array(4096);
        FS.root = FS.createNode(null, '/', 16384 | 0777, 0);
        FS.mount(MEMFS, {}, '/');
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
        FS.ensureErrnoError();
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join2(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(node, mode | 146);
          var stream = FS.open(node, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(node, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
          function LazyUint8Array() {
            this.lengthKnown = false;
            this.chunks = []; // Loaded chunks. Index is the chunk number
          }
          LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
            if (idx > this.length-1 || idx < 0) {
              return undefined;
            }
            var chunkOffset = idx % this.chunkSize;
            var chunkNum = Math.floor(idx / this.chunkSize);
            return this.getter(chunkNum)[chunkOffset];
          }
          LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
            this.getter = getter;
          }
          LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
              // Find length
              var xhr = new XMLHttpRequest();
              xhr.open('HEAD', url, false);
              xhr.send(null);
              if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
              var datalength = Number(xhr.getResponseHeader("Content-length"));
              var header;
              var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
              var chunkSize = 1024*1024; // Chunk size in bytes
              if (!hasByteServing) chunkSize = datalength;
              // Function to get a range from the remote URL.
              var doXHR = (function(from, to) {
                if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
                if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
                // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
                var xhr = new XMLHttpRequest();
                xhr.open('GET', url, false);
                if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
                // Some hints to the browser that we want binary data.
                if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
                if (xhr.overrideMimeType) {
                  xhr.overrideMimeType('text/plain; charset=x-user-defined');
                }
                xhr.send(null);
                if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
                if (xhr.response !== undefined) {
                  return new Uint8Array(xhr.response || []);
                } else {
                  return intArrayFromString(xhr.responseText || '', true);
                }
              });
              var lazyArray = this;
              lazyArray.setDataGetter(function(chunkNum) {
                var start = chunkNum * chunkSize;
                var end = (chunkNum+1) * chunkSize - 1; // including this byte
                end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
                  lazyArray.chunks[chunkNum] = doXHR(start, end);
                }
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
                return lazyArray.chunks[chunkNum];
              });
              this._length = datalength;
              this._chunkSize = chunkSize;
              this.lengthKnown = true;
          }
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function forceLoadLazyFile() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;
        function processData(byteArray) {
          function finish(byteArray) {
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency('cp ' + fullname);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency('cp ' + fullname);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function () {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          console.log('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function putRequest_onsuccess() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function putRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function getRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};
  var Browser={mainLoop:{scheduler:null,shouldPause:false,paused:false,queue:[],pause:function () {
          Browser.mainLoop.shouldPause = true;
        },resume:function () {
          if (Browser.mainLoop.paused) {
            Browser.mainLoop.paused = false;
            Browser.mainLoop.scheduler();
          }
          Browser.mainLoop.shouldPause = false;
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers
        if (Browser.initted || ENVIRONMENT_IS_WORKER) return;
        Browser.initted = true;
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
          console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
          Module.noImageDecoding = true;
        }
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
        var imagePlugin = {};
        imagePlugin['canHandle'] = function imagePlugin_canHandle(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function imagePlugin_handle(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function img_onload() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function img_onerror(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
        var audioPlugin = {};
        audioPlugin['canHandle'] = function audioPlugin_canHandle(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function audioPlugin_handle(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function audio_onerror(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
        // Canvas event setup
        var canvas = Module['canvas'];
        canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                    canvas['mozRequestPointerLock'] ||
                                    canvas['webkitRequestPointerLock'];
        canvas.exitPointerLock = document['exitPointerLock'] ||
                                 document['mozExitPointerLock'] ||
                                 document['webkitExitPointerLock'] ||
                                 function(){}; // no-op if function does not exist
        canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas;
        }
        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
        if (Module['elementPointerLock']) {
          canvas.addEventListener("click", function(ev) {
            if (!Browser.pointerLock && canvas.requestPointerLock) {
              canvas.requestPointerLock();
              ev.preventDefault();
            }
          }, false);
        }
      },createContext:function (canvas, useWebGL, setInModule, webGLContextAttributes) {
        var ctx;
        try {
          if (useWebGL) {
            var contextAttributes = {
              antialias: false,
              alpha: false
            };
            if (webGLContextAttributes) {
              for (var attribute in webGLContextAttributes) {
                contextAttributes[attribute] = webGLContextAttributes[attribute];
              }
            }
            ['experimental-webgl', 'webgl'].some(function(webglId) {
              return ctx = canvas.getContext(webglId, contextAttributes);
            });
          } else {
            ctx = canvas.getContext('2d');
          }
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas - ' + e);
          return null;
        }
        if (useWebGL) {
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
          // Warn on context loss
          canvas.addEventListener('webglcontextlost', function(event) {
            
          }, false);
        }
        if (setInModule) {
          Module.ctx = ctx;
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement']) === canvas) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'];
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else if (Browser.resizeCanvas){
            Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
        }
        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
        }
        canvas.requestFullScreen = canvas['requestFullScreen'] ||
                                   canvas['mozRequestFullScreen'] ||
                                   (canvas['webkitRequestFullScreen'] ? function() { canvas['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
        canvas.requestFullScreen();
      },requestAnimationFrame:function requestAnimationFrame(func) {
        if (typeof window === 'undefined') { // Provide fallback to setTimeout if window is undefined (e.g. in Node.js)
          setTimeout(func, 1000/60);
        } else {
          if (!window.requestAnimationFrame) {
            window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                           window['mozRequestAnimationFrame'] ||
                                           window['webkitRequestAnimationFrame'] ||
                                           window['msRequestAnimationFrame'] ||
                                           window['oRequestAnimationFrame'] ||
                                           window['setTimeout'];
          }
          window.requestAnimationFrame(func);
        }
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (!ABORT) func();
        });
      },safeSetTimeout:function (func, timeout) {
        return setTimeout(function() {
          if (!ABORT) func();
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        return setInterval(function() {
          if (!ABORT) func();
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          // check if SDL is available
          if (typeof SDL != "undefined") {
          	Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
          	Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
          	// just add the mouse delta to the current absolut mouse position
          	// FIXME: ideally this should be clamped against the canvas size and zero
          	Browser.mouseX += Browser.mouseMovementX;
          	Browser.mouseY += Browser.mouseMovementY;
          }        
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var x, y;
          if (event.type == 'touchstart' ||
              event.type == 'touchend' ||
              event.type == 'touchmove') {
            var t = event.touches.item(0);
            if (t) {
              x = t.pageX - (window.scrollX + rect.left);
              y = t.pageY - (window.scrollY + rect.top);
            } else {
              return;
            }
          } else {
            x = event.pageX - (window.scrollX + rect.left);
            y = event.pageY - (window.scrollY + rect.top);
          }
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function xhr_onload() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        canvas.width = width;
        canvas.height = height;
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        var canvas = Module['canvas'];
        this.windowedWidth = canvas.width;
        this.windowedHeight = canvas.height;
        canvas.width = screen.width;
        canvas.height = screen.height;
        // check if SDL is available   
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        var canvas = Module['canvas'];
        canvas.width = this.windowedWidth;
        canvas.height = this.windowedHeight;
        // check if SDL is available       
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      }};var SDL={defaults:{width:320,height:200,copyOnLock:true},version:null,surfaces:{},canvasPool:[],events:[],fonts:[null],audios:[null],rwops:[null],music:{audio:null,volume:1},mixerFrequency:22050,mixerFormat:32784,mixerNumChannels:2,mixerChunkSize:1024,channelMinimumNumber:0,GL:false,glAttributes:{0:3,1:3,2:2,3:0,4:0,5:1,6:16,7:0,8:0,9:0,10:0,11:0,12:0,13:0,14:0,15:1,16:0,17:0,18:0},keyboardState:null,keyboardMap:{},canRequestFullscreen:false,isRequestingFullscreen:false,textInput:false,startTime:null,initFlags:0,buttonState:0,modState:0,DOMButtons:[0,0,0],DOMEventToSDLEvent:{},keyCodes:{16:1249,17:1248,18:1250,33:1099,34:1102,37:1104,38:1106,39:1103,40:1105,46:127,96:1112,97:1113,98:1114,99:1115,100:1116,101:1117,102:1118,103:1119,104:1120,105:1121,112:1082,113:1083,114:1084,115:1085,116:1086,117:1087,118:1088,119:1089,120:1090,121:1091,122:1092,123:1093,173:45,188:44,190:46,191:47,192:96},scanCodes:{8:42,9:43,13:40,27:41,32:44,44:54,46:55,47:56,48:39,49:30,50:31,51:32,52:33,53:34,54:35,55:36,56:37,57:38,59:51,61:46,91:47,92:49,93:48,96:52,97:4,98:5,99:6,100:7,101:8,102:9,103:10,104:11,105:12,106:13,107:14,108:15,109:16,110:17,111:18,112:19,113:20,114:21,115:22,116:23,117:24,118:25,119:26,120:27,121:28,122:29,305:224,308:226},loadRect:function (rect) {
        return {
          x: HEAP32[((rect + 0)>>2)],
          y: HEAP32[((rect + 4)>>2)],
          w: HEAP32[((rect + 8)>>2)],
          h: HEAP32[((rect + 12)>>2)]
        };
      },loadColorToCSSRGB:function (color) {
        var rgba = HEAP32[((color)>>2)];
        return 'rgb(' + (rgba&255) + ',' + ((rgba >> 8)&255) + ',' + ((rgba >> 16)&255) + ')';
      },loadColorToCSSRGBA:function (color) {
        var rgba = HEAP32[((color)>>2)];
        return 'rgba(' + (rgba&255) + ',' + ((rgba >> 8)&255) + ',' + ((rgba >> 16)&255) + ',' + (((rgba >> 24)&255)/255) + ')';
      },translateColorToCSSRGBA:function (rgba) {
        return 'rgba(' + (rgba&0xff) + ',' + (rgba>>8 & 0xff) + ',' + (rgba>>16 & 0xff) + ',' + (rgba>>>24)/0xff + ')';
      },translateRGBAToCSSRGBA:function (r, g, b, a) {
        return 'rgba(' + (r&0xff) + ',' + (g&0xff) + ',' + (b&0xff) + ',' + (a&0xff)/255 + ')';
      },translateRGBAToColor:function (r, g, b, a) {
        return r | g << 8 | b << 16 | a << 24;
      },makeSurface:function (width, height, flags, usePageCanvas, source, rmask, gmask, bmask, amask) {
        flags = flags || 0;
        var surf = _malloc(60);  // SDL_Surface has 15 fields of quantum size
        var buffer = _malloc(width*height*4); // TODO: only allocate when locked the first time
        var pixelFormat = _malloc(44);
        flags |= 1; // SDL_HWSURFACE - this tells SDL_MUSTLOCK that this needs to be locked
        //surface with SDL_HWPALETTE flag is 8bpp surface (1 byte)
        var is_SDL_HWPALETTE = flags & 0x00200000;  
        var bpp = is_SDL_HWPALETTE ? 1 : 4;
        HEAP32[((surf)>>2)]=flags         // SDL_Surface.flags
        HEAP32[(((surf)+(4))>>2)]=pixelFormat // SDL_Surface.format TODO
        HEAP32[(((surf)+(8))>>2)]=width         // SDL_Surface.w
        HEAP32[(((surf)+(12))>>2)]=height        // SDL_Surface.h
        HEAP32[(((surf)+(16))>>2)]=width * bpp       // SDL_Surface.pitch, assuming RGBA or indexed for now,
                                                                                 // since that is what ImageData gives us in browsers
        HEAP32[(((surf)+(20))>>2)]=buffer      // SDL_Surface.pixels
        HEAP32[(((surf)+(36))>>2)]=0      // SDL_Surface.offset
        HEAP32[(((surf)+(56))>>2)]=1
        HEAP32[((pixelFormat)>>2)]=0 /* XXX missing C define SDL_PIXELFORMAT_RGBA8888 */ // SDL_PIXELFORMAT_RGBA8888
        HEAP32[(((pixelFormat)+(4))>>2)]=0 // TODO
        HEAP8[(((pixelFormat)+(8))|0)]=bpp * 8
        HEAP8[(((pixelFormat)+(9))|0)]=bpp
        HEAP32[(((pixelFormat)+(12))>>2)]=rmask || 0x000000ff
        HEAP32[(((pixelFormat)+(16))>>2)]=gmask || 0x0000ff00
        HEAP32[(((pixelFormat)+(20))>>2)]=bmask || 0x00ff0000
        HEAP32[(((pixelFormat)+(24))>>2)]=amask || 0xff000000
        // Decide if we want to use WebGL or not
        var useWebGL = (flags & 0x04000000) != 0; // SDL_OPENGL
        SDL.GL = SDL.GL || useWebGL;
        var canvas;
        if (!usePageCanvas) {
          if (SDL.canvasPool.length > 0) {
            canvas = SDL.canvasPool.pop();
          } else {
            canvas = document.createElement('canvas');
          }
          canvas.width = width;
          canvas.height = height;
        } else {
          canvas = Module['canvas'];
        }
        var webGLContextAttributes = {
          antialias: ((SDL.glAttributes[13 /*SDL_GL_MULTISAMPLEBUFFERS*/] != 0) && (SDL.glAttributes[14 /*SDL_GL_MULTISAMPLESAMPLES*/] > 1)),
          depth: (SDL.glAttributes[6 /*SDL_GL_DEPTH_SIZE*/] > 0),
          stencil: (SDL.glAttributes[7 /*SDL_GL_STENCIL_SIZE*/] > 0)
        };
        var ctx = Browser.createContext(canvas, useWebGL, usePageCanvas, webGLContextAttributes);
        SDL.surfaces[surf] = {
          width: width,
          height: height,
          canvas: canvas,
          ctx: ctx,
          surf: surf,
          buffer: buffer,
          pixelFormat: pixelFormat,
          alpha: 255,
          flags: flags,
          locked: 0,
          usePageCanvas: usePageCanvas,
          source: source,
          isFlagSet: function(flag) {
            return flags & flag;
          }
        };
        return surf;
      },copyIndexedColorData:function (surfData, rX, rY, rW, rH) {
        // HWPALETTE works with palette
        // setted by SDL_SetColors
        if (!surfData.colors) {
          return;
        }
        var fullWidth  = Module['canvas'].width;
        var fullHeight = Module['canvas'].height;
        var startX  = rX || 0;
        var startY  = rY || 0;
        var endX    = (rW || (fullWidth - startX)) + startX;
        var endY    = (rH || (fullHeight - startY)) + startY;
        var buffer  = surfData.buffer;
        var data    = surfData.image.data;
        var colors  = surfData.colors;
        for (var y = startY; y < endY; ++y) {
          var indexBase = y * fullWidth;
          var colorBase = indexBase * 4;
          for (var x = startX; x < endX; ++x) {
            // HWPALETTE have only 256 colors (not rgba)
            var index = HEAPU8[((buffer + indexBase + x)|0)] * 3;
            var colorOffset = colorBase + x * 4;
            data[colorOffset   ] = colors[index   ];
            data[colorOffset +1] = colors[index +1];
            data[colorOffset +2] = colors[index +2];
            //unused: data[colorOffset +3] = color[index +3];
          }
        }
      },freeSurface:function (surf) {
        var refcountPointer = surf + 56;
        var refcount = HEAP32[((refcountPointer)>>2)];
        if (refcount > 1) {
          HEAP32[((refcountPointer)>>2)]=refcount - 1;
          return;
        }
        var info = SDL.surfaces[surf];
        if (!info.usePageCanvas && info.canvas) SDL.canvasPool.push(info.canvas);
        _free(info.buffer);
        _free(info.pixelFormat);
        _free(surf);
        SDL.surfaces[surf] = null;
      },touchX:0,touchY:0,savedKeydown:null,receiveEvent:function (event) {
        switch(event.type) {
          case 'touchstart':
            event.preventDefault();
            var touch = event.touches[0];
            touchX = touch.pageX;
            touchY = touch.pageY;
            var event = {
              type: 'mousedown',
              button: 0,
              pageX: touchX,
              pageY: touchY
            };
            SDL.DOMButtons[0] = 1;
            SDL.events.push(event);
            break;
          case 'touchmove':
            event.preventDefault();
            var touch = event.touches[0];
            touchX = touch.pageX;
            touchY = touch.pageY;
            event = {
              type: 'mousemove',
              button: 0,
              pageX: touchX,
              pageY: touchY
            };
            SDL.events.push(event);
            break;
          case 'touchend':
            event.preventDefault();
            event = {
              type: 'mouseup',
              button: 0,
              pageX: touchX,
              pageY: touchY
            };
            SDL.DOMButtons[0] = 0;
            SDL.events.push(event);
            break;
          case 'mousemove':
            if (Browser.pointerLock) {
              // workaround for firefox bug 750111
              if ('mozMovementX' in event) {
                event['movementX'] = event['mozMovementX'];
                event['movementY'] = event['mozMovementY'];
              }
              // workaround for Firefox bug 782777
              if (event['movementX'] == 0 && event['movementY'] == 0) {
                // ignore a mousemove event if it doesn't contain any movement info
                // (without pointer lock, we infer movement from pageX/pageY, so this check is unnecessary)
                event.preventDefault();
                return;
              }
            }
            // fall through
          case 'keydown': case 'keyup': case 'keypress': case 'mousedown': case 'mouseup': case 'DOMMouseScroll': case 'mousewheel':
            // If we preventDefault on keydown events, the subsequent keypress events
            // won't fire. However, it's fine (and in some cases necessary) to
            // preventDefault for keys that don't generate a character. Otherwise,
            // preventDefault is the right thing to do in general.
            if (event.type !== 'keydown' || (event.keyCode === 8 /* backspace */ || event.keyCode === 9 /* tab */)) {
              event.preventDefault();
            }
            if (event.type == 'DOMMouseScroll' || event.type == 'mousewheel') {
              var button = (event.type == 'DOMMouseScroll' ? event.detail : -event.wheelDelta) > 0 ? 4 : 3;
              var event2 = {
                type: 'mousedown',
                button: button,
                pageX: event.pageX,
                pageY: event.pageY
              };
              SDL.events.push(event2);
              event = {
                type: 'mouseup',
                button: button,
                pageX: event.pageX,
                pageY: event.pageY
              };
            } else if (event.type == 'mousedown') {
              SDL.DOMButtons[event.button] = 1;
            } else if (event.type == 'mouseup') {
              // ignore extra ups, can happen if we leave the canvas while pressing down, then return,
              // since we add a mouseup in that case
              if (!SDL.DOMButtons[event.button]) {
                return;
              }
              SDL.DOMButtons[event.button] = 0;
            }
            // We can only request fullscreen as the result of user input.
            // Due to this limitation, we toggle a boolean on keydown which
            // SDL_WM_ToggleFullScreen will check and subsequently set another
            // flag indicating for us to request fullscreen on the following
            // keyup. This isn't perfect, but it enables SDL_WM_ToggleFullScreen
            // to work as the result of a keypress (which is an extremely
            // common use case).
            if (event.type === 'keydown') {
              SDL.canRequestFullscreen = true;
            } else if (event.type === 'keyup') {
              if (SDL.isRequestingFullscreen) {
                Module['requestFullScreen'](true, true);
                SDL.isRequestingFullscreen = false;
              }
              SDL.canRequestFullscreen = false;
            }
            // SDL expects a unicode character to be passed to its keydown events.
            // Unfortunately, the browser APIs only provide a charCode property on
            // keypress events, so we must backfill in keydown events with their
            // subsequent keypress event's charCode.
            if (event.type === 'keypress' && SDL.savedKeydown) {
              // charCode is read-only
              SDL.savedKeydown.keypressCharCode = event.charCode;
              SDL.savedKeydown = null;
            } else if (event.type === 'keydown') {
              SDL.savedKeydown = event;
            }
            // Don't push keypress events unless SDL_StartTextInput has been called.
            if (event.type !== 'keypress' || SDL.textInput) {
              SDL.events.push(event);
            }
            break;
          case 'mouseout':
            // Un-press all pressed mouse buttons, because we might miss the release outside of the canvas
            for (var i = 0; i < 3; i++) {
              if (SDL.DOMButtons[i]) {
                SDL.events.push({
                  type: 'mouseup',
                  button: i,
                  pageX: event.pageX,
                  pageY: event.pageY
                });
                SDL.DOMButtons[i] = 0;
              }
            }
            event.preventDefault();
            break;
          case 'blur':
          case 'visibilitychange': {
            // Un-press all pressed keys: TODO
            for (var code in SDL.keyboardMap) {
              SDL.events.push({
                type: 'keyup',
                keyCode: SDL.keyboardMap[code]
              });
            }
            event.preventDefault();
            break;
          }
          case 'unload':
            if (Browser.mainLoop.runner) {
              SDL.events.push(event);
              // Force-run a main event loop, since otherwise this event will never be caught!
              Browser.mainLoop.runner();
            }
            return;
          case 'resize':
            SDL.events.push(event);
            // manually triggered resize event doesn't have a preventDefault member
            if (event.preventDefault) {
              event.preventDefault();
            }
            break;
        }
        if (SDL.events.length >= 10000) {
          Module.printErr('SDL event queue full, dropping events');
          SDL.events = SDL.events.slice(0, 10000);
        }
        return;
      },handleEvent:function (event) {
        if (event.handled) return;
        event.handled = true;
        switch (event.type) {
          case 'keydown': case 'keyup': {
            var down = event.type === 'keydown';
            var code = event.keyCode;
            if (code >= 65 && code <= 90) {
              code += 32; // make lowercase for SDL
            } else {
              code = SDL.keyCodes[event.keyCode] || event.keyCode;
            }
            HEAP8[(((SDL.keyboardState)+(code))|0)]=down;
            // TODO: lmeta, rmeta, numlock, capslock, KMOD_MODE, KMOD_RESERVED
            SDL.modState = (HEAP8[(((SDL.keyboardState)+(1248))|0)] ? 0x0040 | 0x0080 : 0) | // KMOD_LCTRL & KMOD_RCTRL
              (HEAP8[(((SDL.keyboardState)+(1249))|0)] ? 0x0001 | 0x0002 : 0) | // KMOD_LSHIFT & KMOD_RSHIFT
              (HEAP8[(((SDL.keyboardState)+(1250))|0)] ? 0x0100 | 0x0200 : 0); // KMOD_LALT & KMOD_RALT
            if (down) {
              SDL.keyboardMap[code] = event.keyCode; // save the DOM input, which we can use to unpress it during blur
            } else {
              delete SDL.keyboardMap[code];
            }
            break;
          }
          case 'mousedown': case 'mouseup':
            if (event.type == 'mousedown') {
              // SDL_BUTTON(x) is defined as (1 << ((x)-1)).  SDL buttons are 1-3,
              // and DOM buttons are 0-2, so this means that the below formula is
              // correct.
              SDL.buttonState |= 1 << event.button;
            } else if (event.type == 'mouseup') {
              SDL.buttonState &= ~(1 << event.button);
            }
            // fall through
          case 'mousemove': {
            Browser.calculateMouseEvent(event);
            break;
          }
        }
      },makeCEvent:function (event, ptr) {
        if (typeof event === 'number') {
          // This is a pointer to a native C event that was SDL_PushEvent'ed
          _memcpy(ptr, event, 28); // XXX
          return;
        }
        SDL.handleEvent(event);
        switch (event.type) {
          case 'keydown': case 'keyup': {
            var down = event.type === 'keydown';
            //Module.print('Received key event: ' + event.keyCode);
            var key = event.keyCode;
            if (key >= 65 && key <= 90) {
              key += 32; // make lowercase for SDL
            } else {
              key = SDL.keyCodes[event.keyCode] || event.keyCode;
            }
            var scan;
            if (key >= 1024) {
              scan = key - 1024;
            } else {
              scan = SDL.scanCodes[key] || key;
            }
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type]
            HEAP8[(((ptr)+(8))|0)]=down ? 1 : 0
            HEAP8[(((ptr)+(9))|0)]=0 // TODO
            HEAP32[(((ptr)+(12))>>2)]=scan
            HEAP32[(((ptr)+(16))>>2)]=key
            HEAP16[(((ptr)+(20))>>1)]=SDL.modState
            // some non-character keys (e.g. backspace and tab) won't have keypressCharCode set, fill in with the keyCode.
            HEAP32[(((ptr)+(24))>>2)]=event.keypressCharCode || key
            break;
          }
          case 'keypress': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type]
            // Not filling in windowID for now
            var cStr = intArrayFromString(String.fromCharCode(event.charCode));
            for (var i = 0; i < cStr.length; ++i) {
              HEAP8[(((ptr)+(8 + i))|0)]=cStr[i];
            }
            break;
          }
          case 'mousedown': case 'mouseup': case 'mousemove': {
            if (event.type != 'mousemove') {
              var down = event.type === 'mousedown';
              HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
              HEAP8[(((ptr)+(8))|0)]=event.button+1; // DOM buttons are 0-2, SDL 1-3
              HEAP8[(((ptr)+(9))|0)]=down ? 1 : 0;
              HEAP32[(((ptr)+(12))>>2)]=Browser.mouseX;
              HEAP32[(((ptr)+(16))>>2)]=Browser.mouseY;
            } else {
              HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
              HEAP8[(((ptr)+(8))|0)]=SDL.buttonState;
              HEAP32[(((ptr)+(12))>>2)]=Browser.mouseX;
              HEAP32[(((ptr)+(16))>>2)]=Browser.mouseY;
              HEAP32[(((ptr)+(20))>>2)]=Browser.mouseMovementX;
              HEAP32[(((ptr)+(24))>>2)]=Browser.mouseMovementY;
            }
            break;
          }
          case 'unload': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            break;
          }
          case 'resize': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP32[(((ptr)+(4))>>2)]=event.w;
            HEAP32[(((ptr)+(8))>>2)]=event.h;
            break;
          }
          case 'joystick_button_up': case 'joystick_button_down': {
            var state = event.type === 'joystick_button_up' ? 0 : 1;
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP8[(((ptr)+(4))|0)]=event.index;
            HEAP8[(((ptr)+(5))|0)]=event.button;
            HEAP8[(((ptr)+(6))|0)]=state;
            break;
          }
          case 'joystick_axis_motion': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP8[(((ptr)+(4))|0)]=event.index;
            HEAP8[(((ptr)+(5))|0)]=event.axis;
            HEAP32[(((ptr)+(8))>>2)]=SDL.joystickAxisValueConversion(event.value);
            break;
          }
          default: throw 'Unhandled SDL event: ' + event.type;
        }
      },estimateTextWidth:function (fontData, text) {
        var h = fontData.size;
        var fontString = h + 'px ' + fontData.name;
        var tempCtx = SDL.ttfContext;
        tempCtx.save();
        tempCtx.font = fontString;
        var ret = tempCtx.measureText(text).width | 0;
        tempCtx.restore();
        return ret;
      },allocateChannels:function (num) { // called from Mix_AllocateChannels and init
        if (SDL.numChannels && SDL.numChannels >= num && num != 0) return;
        SDL.numChannels = num;
        SDL.channels = [];
        for (var i = 0; i < num; i++) {
          SDL.channels[i] = {
            audio: null,
            volume: 1.0
          };
        }
      },setGetVolume:function (info, volume) {
        if (!info) return 0;
        var ret = info.volume * 128; // MIX_MAX_VOLUME
        if (volume != -1) {
          info.volume = volume / 128;
          if (info.audio) info.audio.volume = info.volume;
        }
        return ret;
      },debugSurface:function (surfData) {
        console.log('dumping surface ' + [surfData.surf, surfData.source, surfData.width, surfData.height]);
        var image = surfData.ctx.getImageData(0, 0, surfData.width, surfData.height);
        var data = image.data;
        var num = Math.min(surfData.width, surfData.height);
        for (var i = 0; i < num; i++) {
          console.log('   diagonal ' + i + ':' + [data[i*surfData.width*4 + i*4 + 0], data[i*surfData.width*4 + i*4 + 1], data[i*surfData.width*4 + i*4 + 2], data[i*surfData.width*4 + i*4 + 3]]);
        }
      },joystickEventState:0,lastJoystickState:{},joystickNamePool:{},recordJoystickState:function (joystick, state) {
        // Standardize button state.
        var buttons = new Array(state.buttons.length);
        for (var i = 0; i < state.buttons.length; i++) {
          buttons[i] = SDL.getJoystickButtonState(state.buttons[i]);
        }
        SDL.lastJoystickState[joystick] = {
          buttons: buttons,
          axes: state.axes.slice(0),
          timestamp: state.timestamp,
          index: state.index,
          id: state.id
        };
      },getJoystickButtonState:function (button) {
        if (typeof button === 'object') {
          // Current gamepad API editor's draft (Firefox Nightly)
          // https://dvcs.w3.org/hg/gamepad/raw-file/default/gamepad.html#idl-def-GamepadButton
          return button.pressed;
        } else {
          // Current gamepad API working draft (Firefox / Chrome Stable)
          // http://www.w3.org/TR/2012/WD-gamepad-20120529/#gamepad-interface
          return button > 0;
        }
      },queryJoysticks:function () {
        for (var joystick in SDL.lastJoystickState) {
          var state = SDL.getGamepad(joystick - 1);
          var prevState = SDL.lastJoystickState[joystick];
          // Check only if the timestamp has differed.
          // NOTE: Timestamp is not available in Firefox.
          if (typeof state.timestamp !== 'number' || state.timestamp !== prevState.timestamp) {
            var i;
            for (i = 0; i < state.buttons.length; i++) {
              var buttonState = SDL.getJoystickButtonState(state.buttons[i]);
              // NOTE: The previous state already has a boolean representation of
              //       its button, so no need to standardize its button state here.
              if (buttonState !== prevState.buttons[i]) {
                // Insert button-press event.
                SDL.events.push({
                  type: buttonState ? 'joystick_button_down' : 'joystick_button_up',
                  joystick: joystick,
                  index: joystick - 1,
                  button: i
                });
              }
            }
            for (i = 0; i < state.axes.length; i++) {
              if (state.axes[i] !== prevState.axes[i]) {
                // Insert axes-change event.
                SDL.events.push({
                  type: 'joystick_axis_motion',
                  joystick: joystick,
                  index: joystick - 1,
                  axis: i,
                  value: state.axes[i]
                });
              }
            }
            SDL.recordJoystickState(joystick, state);
          }
        }
      },joystickAxisValueConversion:function (value) {
        // Ensures that 0 is 0, 1 is 32767, and -1 is 32768.
        return Math.ceil(((value+1) * 32767.5) - 32768);
      },getGamepads:function () {
        var fcn = navigator.getGamepads || navigator.webkitGamepads || navigator.mozGamepads || navigator.gamepads || navigator.webkitGetGamepads;
        if (fcn !== undefined) {
          // The function must be applied on the navigator object.
          return fcn.apply(navigator);
        } else {
          return [];
        }
      },getGamepad:function (deviceIndex) {
        var gamepads = SDL.getGamepads();
        if (gamepads.length > deviceIndex && deviceIndex >= 0) {
          return gamepads[deviceIndex];
        }
        return null;
      }};function _Mix_Init(flags) {
      if (!flags) return 0;
      return 8; /* MIX_INIT_OGG */
    }
  function ___gxx_personality_v0() {
    }
  function _Mix_OpenAudio(frequency, format, channels, chunksize) {
      SDL.allocateChannels(32);
      // Just record the values for a later call to Mix_QuickLoad_RAW
      SDL.mixerFrequency = frequency;
      SDL.mixerFormat = format;
      SDL.mixerNumChannels = channels;
      SDL.mixerChunkSize = chunksize;
      return 0;
    }
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      Module['exit'](status);
    }function _exit(status) {
      __exit(status);
    }function __ZSt9terminatev() {
      _exit(-1234);
    }
  function _Mix_PlayChannel(channel, id, loops) {
      // TODO: handle loops
      // Get the audio element associated with the ID
      var info = SDL.audios[id];
      if (!info) return -1;
      var audio = info.audio;
      if (!audio) return -1;
      // If the user asks us to allocate a channel automatically, get the first
      // free one.
      if (channel == -1) {
        for (var i = SDL.channelMinimumNumber; i < SDL.numChannels; i++) {
          if (!SDL.channels[i].audio) {
            channel = i;
            break;
          }
        }
        if (channel == -1) {
          Module.printErr('All ' + SDL.numChannels + ' channels in use!');
          return -1;
        }
      }
      // We clone the audio node to utilize the preloaded audio buffer, since
      // the browser has already preloaded the audio file.
      var channelInfo = SDL.channels[channel];
      channelInfo.audio = audio = audio.cloneNode(true);
      audio.numChannels = info.audio.numChannels;
      audio.frequency = info.audio.frequency;
      // TODO: handle N loops. Behavior matches Mix_PlayMusic
      audio.loop = loops != 0; 
      audio['onended'] = function SDL_audio_onended() { // TODO: cache these
        channelInfo.audio = null;
        if (SDL.channelFinished) {
          Runtime.getFuncWrapper(SDL.channelFinished, 'vi')(channel);
        }
      }
      // Either play the element, or load the dynamic data into it
      if (info.buffer) {
        var contextCtor = null;
        if (audio && ('mozSetup' in audio)) { // Audio Data API
          try {
            audio['mozSetup'](audio.numChannels, audio.frequency);
            audio["mozWriteAudio"](info.buffer);
          } catch (e) {
            // Workaround for Firefox bug 783052
            // ignore this exception!
          }
        /*
        } else if (contextCtor = (window.AudioContext || // WebAudio API
                                  window.webkitAudioContext)) {
          var currentIndex = 0;
          var numChannels = parseInt(audio.numChannels);
          var context = new contextCtor();
          var source = context.createBufferSource();
          source.loop = false;
          source.buffer = context.createBuffer(numChannels, 1, audio.frequency);
          var jsNode = context.createJavaScriptNode(2048, numChannels, numChannels);
          jsNode.onaudioprocess = function jsNode_onaudioprocess(event) {
            var buffers = new Array(numChannels);
            for (var i = 0; i < numChannels; ++i) {
              buffers[i] = event.outputBuffer.getChannelData(i);
            }
            var remaining = info.buffer.length - currentIndex;
            if (remaining > 2048) {
              remaining = 2048;
            }
            for (var i = 0; i < remaining;) {
              for (var j = 0; j < numChannels; ++j) {
                buffers[j][i] = info.buffer[currentIndex + i + j] * audio.volume;
              }
              i += j;
            }
            currentIndex += remaining * numChannels;
            for (var i = remaining; i < 2048;) {
              for (var j = 0; j < numChannels; ++j) {
                buffers[j][i] = 0; // silence
              }
              i += j;
            }
          };
          source.connect(jsNode);
          jsNode.connect(context.destination);
          source.noteOn(0);
        */
        }
      } else {
        audio.play();
      }
      audio.volume = channelInfo.volume;
      return channel;
    }var _Mix_PlayChannelTimed=_Mix_PlayChannel;
  function _Mix_LoadWAV_RW(rwopsID, freesrc) {
      var rwops = SDL.rwops[rwopsID];
      if (rwops === undefined)
        return 0;
      var filename = '';
      var audio;
      var bytes;
      if (rwops.filename !== undefined) {
        filename = PATH.resolve(rwops.filename);
        var raw = Module["preloadedAudios"][filename];
        if (!raw) {
          if (raw === null) Module.printErr('Trying to reuse preloaded audio, but freePreloadedMediaOnUse is set!');
          Runtime.warnOnce('Cannot find preloaded audio ' + filename);
          // see if we can read the file-contents from the in-memory FS
          var fileObject = FS.findObject(filename);
          if (fileObject === null) Module.printErr('Couldn\'t find file for: ' + filename);
          // We found the file. Load the contents
          if (fileObject && !fileObject.isFolder && fileObject.read) {
            bytes = fileObject.contents;
          } else {
            return 0;
          }
        }
        if (Module['freePreloadedMediaOnUse']) {
          Module["preloadedAudios"][filename] = null;
        }
        audio = raw;
      }
      else if (rwops.bytes !== undefined) {
        bytes = HEAPU8.subarray(rwops.bytes, rwops.bytes + rwops.count);
      }
      else {
        return 0;
      }
      // Here, we didn't find a preloaded audio but we either were passed a filepath for
      // which we loaded bytes, or we were passed some bytes
      if (audio === undefined && bytes) {
        var blob = new Blob([new Uint8Array(bytes)], {type: rwops.mimetype});
        var url = URL.createObjectURL(blob);
        audio = new Audio();
        audio.src = url;
      }
      var id = SDL.audios.length;
      // Keep the loaded audio in the audio arrays, ready for playback
      SDL.audios.push({
        source: filename,
        audio: audio
      });
      return id;
    }var _Mix_LoadMUS_RW=_Mix_LoadWAV_RW;
  function _SDL_RWFromFile(_name, mode) {
      var id = SDL.rwops.length; // TODO: recycle ids when they are null
      var name = Pointer_stringify(_name)
      SDL.rwops.push({ filename: name, mimetype: Browser.getMimetype(name) });
      return id;
    }
  function _SDL_FreeRW(rwopsID) {
      SDL.rwops[rwopsID] = null;
      while (SDL.rwops.length > 0 && SDL.rwops[SDL.rwops.length-1] === null) {
        SDL.rwops.pop();
      }
    }function _Mix_LoadMUS(filename) {
      var rwops = _SDL_RWFromFile(filename);
      var result = _Mix_LoadMUS_RW(rwops);
      _SDL_FreeRW(rwops);
      return result;
    }
  function _Mix_HaltMusic() {
      var audio = SDL.music.audio;
      if (!audio) return 0;
      audio.src = audio.src; // rewind
      audio.pause();
      SDL.music.audio = null;
      if (SDL.hookMusicFinished) {
        Runtime.dynCall('v', SDL.hookMusicFinished);
      }
      return 0;
    }function _Mix_PlayMusic(id, loops) {
      loops = Math.max(loops, 1);
      var audio = SDL.audios[id].audio;
      if (!audio) return 0;
      audio.loop = loops != 0; // TODO: handle N loops for finite N
      if (SDL.audios[id].buffer) {
        audio["mozWriteAudio"](SDL.audios[id].buffer);
      } else {
        audio.play();
      }
      audio.volume = SDL.music.volume;
      audio['onended'] = _Mix_HaltMusic; // will send callback
      if (SDL.music.audio) {
        if (!SDL.music.audio.paused) {
          Module.printErr('Music is already playing. ' + SDL.music.source);
        }
        SDL.music.audio.pause();
      }
      SDL.music.audio = audio;
      return 0;
    }
  function _SDL_Init(initFlags) {
      SDL.startTime = Date.now();
      SDL.initFlags = initFlags;
      // capture all key events. we just keep down and up, but also capture press to prevent default actions
      if (!Module['doNotCaptureKeyboard']) {
        document.addEventListener("keydown", SDL.receiveEvent);
        document.addEventListener("keyup", SDL.receiveEvent);
        document.addEventListener("keypress", SDL.receiveEvent);
        window.addEventListener("blur", SDL.receiveEvent);
        document.addEventListener("visibilitychange", SDL.receiveEvent);
      }
      if (initFlags & 0x200) {
        // SDL_INIT_JOYSTICK
        // Firefox will not give us Joystick data unless we register this NOP
        // callback.
        // https://bugzilla.mozilla.org/show_bug.cgi?id=936104
        addEventListener("gamepadconnected", function() {});
      }
      window.addEventListener("unload", SDL.receiveEvent);
      SDL.keyboardState = _malloc(0x10000); // Our SDL needs 512, but 64K is safe for older SDLs
      _memset(SDL.keyboardState, 0, 0x10000);
      // Initialize this structure carefully for closure
      SDL.DOMEventToSDLEvent['keydown'] = 0x300 /* SDL_KEYDOWN */;
      SDL.DOMEventToSDLEvent['keyup'] = 0x301 /* SDL_KEYUP */;
      SDL.DOMEventToSDLEvent['keypress'] = 0x303 /* SDL_TEXTINPUT */;
      SDL.DOMEventToSDLEvent['mousedown'] = 0x401 /* SDL_MOUSEBUTTONDOWN */;
      SDL.DOMEventToSDLEvent['mouseup'] = 0x402 /* SDL_MOUSEBUTTONUP */;
      SDL.DOMEventToSDLEvent['mousemove'] = 0x400 /* SDL_MOUSEMOTION */;
      SDL.DOMEventToSDLEvent['unload'] = 0x100 /* SDL_QUIT */;
      SDL.DOMEventToSDLEvent['resize'] = 0x7001 /* SDL_VIDEORESIZE/SDL_EVENT_COMPAT2 */;
      // These are not technically DOM events; the HTML gamepad API is poll-based.
      // However, we define them here, as the rest of the SDL code assumes that
      // all SDL events originate as DOM events.
      SDL.DOMEventToSDLEvent['joystick_axis_motion'] = 0x600 /* SDL_JOYAXISMOTION */;
      SDL.DOMEventToSDLEvent['joystick_button_down'] = 0x603 /* SDL_JOYBUTTONDOWN */;
      SDL.DOMEventToSDLEvent['joystick_button_up'] = 0x604 /* SDL_JOYBUTTONUP */;
      return 0; // success
    }
  function _SDL_GL_SetAttribute(attr, value) {
      if (!(attr in SDL.glAttributes)) {
        abort('Unknown SDL GL attribute (' + attr + '). Please check if your SDL version is supported.');
      }
      SDL.glAttributes[attr] = value;
    }
  function _SDL_SetVideoMode(width, height, depth, flags) {
      ['mousedown', 'mouseup', 'mousemove', 'DOMMouseScroll', 'mousewheel', 'mouseout'].forEach(function(event) {
        Module['canvas'].addEventListener(event, SDL.receiveEvent, true);
      });
      // (0,0) means 'use fullscreen' in native; in Emscripten, use the current canvas size.
      if (width == 0 && height == 0) {
        var canvas = Module['canvas'];
        width = canvas.width;
        height = canvas.height;
      }
      Browser.setCanvasSize(width, height, true);
      // Free the old surface first.
      if (SDL.screen) {
        SDL.freeSurface(SDL.screen);
        SDL.screen = null;
      }
      SDL.screen = SDL.makeSurface(width, height, flags, true, 'screen');
      if (!SDL.addedResizeListener) {
        SDL.addedResizeListener = true;
        Browser.resizeListeners.push(function(w, h) {
          SDL.receiveEvent({
            type: 'resize',
            w: w,
            h: h
          });
        });
      }
      return SDL.screen;
    }
  function _SDL_PollEvent(ptr) {
      if (SDL.initFlags & 0x200 && SDL.joystickEventState) {
        // If SDL_INIT_JOYSTICK was supplied AND the joystick system is configured
        // to automatically query for events, query for joystick events.
        SDL.queryJoysticks();
      }
      if (SDL.events.length === 0) return 0;
      if (ptr) {
        SDL.makeCEvent(SDL.events.shift(), ptr);
      }
      return 1;
    }
  function _SDL_FreeSurface(surf) {
      if (surf) SDL.freeSurface(surf);
    }
  function _SDL_GL_SwapBuffers() {}
  function _emscripten_set_main_loop(func, fps, simulateInfiniteLoop) {
      Module['noExitRuntime'] = true;
      Browser.mainLoop.runner = function Browser_mainLoop_runner() {
        if (ABORT) return;
        if (Browser.mainLoop.queue.length > 0) {
          var start = Date.now();
          var blocker = Browser.mainLoop.queue.shift();
          blocker.func(blocker.arg);
          if (Browser.mainLoop.remainingBlockers) {
            var remaining = Browser.mainLoop.remainingBlockers;
            var next = remaining%1 == 0 ? remaining-1 : Math.floor(remaining);
            if (blocker.counted) {
              Browser.mainLoop.remainingBlockers = next;
            } else {
              // not counted, but move the progress along a tiny bit
              next = next + 0.5; // do not steal all the next one's progress
              Browser.mainLoop.remainingBlockers = (8*remaining + next)/9;
            }
          }
          console.log('main loop blocker "' + blocker.name + '" took ' + (Date.now() - start) + ' ms'); //, left: ' + Browser.mainLoop.remainingBlockers);
          Browser.mainLoop.updateStatus();
          setTimeout(Browser.mainLoop.runner, 0);
          return;
        }
        if (Browser.mainLoop.shouldPause) {
          // catch pauses from non-main loop sources
          Browser.mainLoop.paused = true;
          Browser.mainLoop.shouldPause = false;
          return;
        }
        if (Module['preMainLoop']) {
          Module['preMainLoop']();
        }
        try {
          Runtime.dynCall('v', func);
        } catch (e) {
          if (e instanceof ExitStatus) {
            return;
          } else {
            if (e && typeof e === 'object' && e.stack) Module.printErr('exception thrown: ' + [e, e.stack]);
            throw e;
          }
        }
        if (Module['postMainLoop']) {
          Module['postMainLoop']();
        }
        if (Browser.mainLoop.shouldPause) {
          // catch pauses from the main loop itself
          Browser.mainLoop.paused = true;
          Browser.mainLoop.shouldPause = false;
          return;
        }
        Browser.mainLoop.scheduler();
      }
      if (fps && fps > 0) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler() {
          setTimeout(Browser.mainLoop.runner, 1000/fps); // doing this each time means that on exception, we stop
        }
      } else {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler() {
          Browser.requestAnimationFrame(Browser.mainLoop.runner);
        }
      }
      Browser.mainLoop.scheduler();
      if (simulateInfiniteLoop) {
        throw 'SimulateInfiniteLoop';
      }
    }
  Module["_memcpy"] = _memcpy;var _llvm_memcpy_p0i8_p0i8_i32=_memcpy;
  function ___cxa_allocate_exception(size) {
      return _malloc(size);
    }
  function ___cxa_free_exception(ptr) {
      try {
        return _free(ptr);
      } catch(e) { // XXX FIXME
      }
    }
  function _llvm_eh_exception() {
      return HEAP32[((_llvm_eh_exception.buf)>>2)];
    }
  function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
      return !!__ZSt18uncaught_exceptionv.uncaught_exception;
    }
  function ___cxa_is_number_type(type) {
      var isNumber = false;
      try { if (type == __ZTIi) isNumber = true } catch(e){}
      try { if (type == __ZTIj) isNumber = true } catch(e){}
      try { if (type == __ZTIl) isNumber = true } catch(e){}
      try { if (type == __ZTIm) isNumber = true } catch(e){}
      try { if (type == __ZTIx) isNumber = true } catch(e){}
      try { if (type == __ZTIy) isNumber = true } catch(e){}
      try { if (type == __ZTIf) isNumber = true } catch(e){}
      try { if (type == __ZTId) isNumber = true } catch(e){}
      try { if (type == __ZTIe) isNumber = true } catch(e){}
      try { if (type == __ZTIc) isNumber = true } catch(e){}
      try { if (type == __ZTIa) isNumber = true } catch(e){}
      try { if (type == __ZTIh) isNumber = true } catch(e){}
      try { if (type == __ZTIs) isNumber = true } catch(e){}
      try { if (type == __ZTIt) isNumber = true } catch(e){}
      return isNumber;
    }function ___cxa_does_inherit(definiteType, possibilityType, possibility) {
      if (possibility == 0) return false;
      if (possibilityType == 0 || possibilityType == definiteType)
        return true;
      var possibility_type_info;
      if (___cxa_is_number_type(possibilityType)) {
        possibility_type_info = possibilityType;
      } else {
        var possibility_type_infoAddr = HEAP32[((possibilityType)>>2)] - 8;
        possibility_type_info = HEAP32[((possibility_type_infoAddr)>>2)];
      }
      switch (possibility_type_info) {
      case 0: // possibility is a pointer
        // See if definite type is a pointer
        var definite_type_infoAddr = HEAP32[((definiteType)>>2)] - 8;
        var definite_type_info = HEAP32[((definite_type_infoAddr)>>2)];
        if (definite_type_info == 0) {
          // Also a pointer; compare base types of pointers
          var defPointerBaseAddr = definiteType+8;
          var defPointerBaseType = HEAP32[((defPointerBaseAddr)>>2)];
          var possPointerBaseAddr = possibilityType+8;
          var possPointerBaseType = HEAP32[((possPointerBaseAddr)>>2)];
          return ___cxa_does_inherit(defPointerBaseType, possPointerBaseType, possibility);
        } else
          return false; // one pointer and one non-pointer
      case 1: // class with no base class
        return false;
      case 2: // class with base class
        var parentTypeAddr = possibilityType + 8;
        var parentType = HEAP32[((parentTypeAddr)>>2)];
        return ___cxa_does_inherit(definiteType, parentType, possibility);
      default:
        return false; // some unencountered type
      }
    }
  function ___resumeException(ptr) {
      if (HEAP32[((_llvm_eh_exception.buf)>>2)] == 0) HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr;
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }function ___cxa_find_matching_catch(thrown, throwntype) {
      if (thrown == -1) thrown = HEAP32[((_llvm_eh_exception.buf)>>2)];
      if (throwntype == -1) throwntype = HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)];
      var typeArray = Array.prototype.slice.call(arguments, 2);
      // If throwntype is a pointer, this means a pointer has been
      // thrown. When a pointer is thrown, actually what's thrown
      // is a pointer to the pointer. We'll dereference it.
      if (throwntype != 0 && !___cxa_is_number_type(throwntype)) {
        var throwntypeInfoAddr= HEAP32[((throwntype)>>2)] - 8;
        var throwntypeInfo= HEAP32[((throwntypeInfoAddr)>>2)];
        if (throwntypeInfo == 0)
          thrown = HEAP32[((thrown)>>2)];
      }
      // The different catch blocks are denoted by different types.
      // Due to inheritance, those types may not precisely match the
      // type of the thrown object. Find one which matches, and
      // return the type of the catch block which should be called.
      for (var i = 0; i < typeArray.length; i++) {
        if (___cxa_does_inherit(typeArray[i], throwntype, thrown))
          return ((asm["setTempRet0"](typeArray[i]),thrown)|0);
      }
      // Shouldn't happen unless we have bogus data in typeArray
      // or encounter a type for which emscripten doesn't have suitable
      // typeinfo defined. Best-efforts match just in case.
      return ((asm["setTempRet0"](throwntype),thrown)|0);
    }function ___cxa_throw(ptr, type, destructor) {
      if (!___cxa_throw.initialized) {
        try {
          HEAP32[((__ZTVN10__cxxabiv119__pointer_type_infoE)>>2)]=0; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv117__class_type_infoE)>>2)]=1; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv120__si_class_type_infoE)>>2)]=2; // Workaround for libcxxabi integration bug
        } catch(e){}
        ___cxa_throw.initialized = true;
      }
      HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=type
      HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=destructor
      if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
      } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
      }
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }
  Module["_memcmp"] = _memcmp;
  function _SDL_RWFromConstMem(mem, size) {
      var id = SDL.rwops.length; // TODO: recycle ids when they are null
      SDL.rwops.push({ bytes: mem, count: size });
      return id;
    }
  function _emscripten_asm_const_int(code) {
      var args = Array.prototype.slice.call(arguments, 1);
      return Runtime.getAsmConst(code, args.length).apply(null, args) | 0;
    }
  Module["_memset"] = _memset;var _llvm_memset_p0i8_i64=_memset;
  function _gettimeofday(ptr) {
      var now = Date.now();
      HEAP32[((ptr)>>2)]=Math.floor(now/1000); // seconds
      HEAP32[(((ptr)+(4))>>2)]=Math.floor((now-1000*Math.floor(now/1000))*1000); // microseconds
      return 0;
    }
  function _stat(path, buf, dontResolveLastLink) {
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/stat.html
      // int stat(const char *path, struct stat *buf);
      // NOTE: dontResolveLastLink is a shortcut for lstat(). It should never be
      //       used in client code.
      path = typeof path !== 'string' ? Pointer_stringify(path) : path;
      try {
        var stat = dontResolveLastLink ? FS.lstat(path) : FS.stat(path);
        HEAP32[((buf)>>2)]=stat.dev;
        HEAP32[(((buf)+(4))>>2)]=0;
        HEAP32[(((buf)+(8))>>2)]=stat.ino;
        HEAP32[(((buf)+(12))>>2)]=stat.mode
        HEAP32[(((buf)+(16))>>2)]=stat.nlink
        HEAP32[(((buf)+(20))>>2)]=stat.uid
        HEAP32[(((buf)+(24))>>2)]=stat.gid
        HEAP32[(((buf)+(28))>>2)]=stat.rdev
        HEAP32[(((buf)+(32))>>2)]=0;
        HEAP32[(((buf)+(36))>>2)]=stat.size
        HEAP32[(((buf)+(40))>>2)]=4096
        HEAP32[(((buf)+(44))>>2)]=stat.blocks
        HEAP32[(((buf)+(48))>>2)]=Math.floor(stat.atime.getTime() / 1000)
        HEAP32[(((buf)+(52))>>2)]=0
        HEAP32[(((buf)+(56))>>2)]=Math.floor(stat.mtime.getTime() / 1000)
        HEAP32[(((buf)+(60))>>2)]=0
        HEAP32[(((buf)+(64))>>2)]=Math.floor(stat.ctime.getTime() / 1000)
        HEAP32[(((buf)+(68))>>2)]=0
        HEAP32[(((buf)+(72))>>2)]=stat.ino
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  Module["_strlen"] = _strlen;function _strdup(ptr) {
      var len = _strlen(ptr);
      var newStr = _malloc(len + 1);
      (_memcpy(newStr, ptr, len)|0);
      HEAP8[(((newStr)+(len))|0)]=0;
      return newStr;
    }
  function _strchr(ptr, chr) {
      ptr--;
      do {
        ptr++;
        var val = HEAP8[(ptr)];
        if (val == chr) return ptr;
      } while (val);
      return 0;
    }
  function _isspace(chr) {
      return (chr == 32) || (chr >= 9 && chr <= 13);
    }
  function _strncmp(px, py, n) {
      var i = 0;
      while (i < n) {
        var x = HEAPU8[(((px)+(i))|0)];
        var y = HEAPU8[(((py)+(i))|0)];
        if (x == y && x == 0) return 0;
        if (x == 0) return -1;
        if (y == 0) return 1;
        if (x == y) {
          i ++;
          continue;
        } else {
          return x > y ? 1 : -1;
        }
      }
      return 0;
    }
  function _strtok_r(s, delim, lasts) {
      var skip_leading_delim = 1;
      var spanp;
      var c, sc;
      var tok;
      if (s == 0 && (s = getValue(lasts, 'i8*')) == 0) {
        return 0;
      }
      cont: while (1) {
        c = getValue(s++, 'i8');
        for (spanp = delim; (sc = getValue(spanp++, 'i8')) != 0;) {
          if (c == sc) {
            if (skip_leading_delim) {
              continue cont;
            } else {
              setValue(lasts, s, 'i8*');
              setValue(s - 1, 0, 'i8');
              return s - 1;
            }
          }
        }
        break;
      }
      if (c == 0) {
        setValue(lasts, 0, 'i8*');
        return 0;
      }
      tok = s - 1;
      for (;;) {
        c = getValue(s++, 'i8');
        spanp = delim;
        do {
          if ((sc = getValue(spanp++, 'i8')) == c) {
            if (c == 0) {
              s = 0;
            } else {
              setValue(s - 1, 0, 'i8');
            }
            setValue(lasts, s, 'i8*');
            return tok;
          }
        } while (sc != 0);
      }
      abort('strtok_r error!');
    }
  var _llvm_va_start=undefined;
  function __reallyNegative(x) {
      return x < 0 || (x === 0 && (1/x) === -Infinity);
    }function __formatString(format, varargs) {
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
          ret = HEAPF64[(((varargs)+(argIndex))>>3)];
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+8))>>2)]];
          argIndex += 8; // each 32-bit chunk is in a 64-bit block
        } else {
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
        }
        argIndex += Math.max(Runtime.getNativeFieldSize(type), Runtime.getAlignSize(type, null, true));
        return ret;
      }
      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[((textIndex+1)|0)];
        if (curr == 37) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          var flagPadSign = false;
          flagsLoop: while (1) {
            switch (next) {
              case 43:
                flagAlwaysSigned = true;
                break;
              case 45:
                flagLeftAlign = true;
                break;
              case 35:
                flagAlternative = true;
                break;
              case 48:
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              case 32:
                flagPadSign = true;
                break;
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          }
          // Handle width.
          var width = 0;
          if (next == 42) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          } else {
            while (next >= 48 && next <= 57) {
              width = width * 10 + (next - 48);
              textIndex++;
              next = HEAP8[((textIndex+1)|0)];
            }
          }
          // Handle precision.
          var precisionSet = false;
          if (next == 46) {
            var precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
            if (next == 42) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[((textIndex+1)|0)];
                if (precisionChr < 48 ||
                    precisionChr > 57) break;
                precision = precision * 10 + (precisionChr - 48);
                textIndex++;
              }
            }
            next = HEAP8[((textIndex+1)|0)];
          } else {
            var precision = 6; // Standard default.
          }
          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 104) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 108) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[((textIndex+1)|0)];
          // Handle type specifier.
          switch (String.fromCharCode(next)) {
            case 'd': case 'i': case 'u': case 'o': case 'x': case 'X': case 'p': {
              // Integer.
              var signed = next == 100 || next == 105;
              argSize = argSize || 4;
              var currArg = getNextArg('i' + (argSize * 8));
              var origArg = currArg;
              var argText;
              // Flatten i64-1 [low, high] into a (slightly rounded) double
              if (argSize == 8) {
                currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
              }
              // Truncate to requested size.
              if (argSize <= 4) {
                var limit = Math.pow(256, argSize) - 1;
                currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
              }
              // Format the number.
              var currAbsArg = Math.abs(currArg);
              var prefix = '';
              if (next == 100 || next == 105) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null); else
                argText = reSign(currArg, 8 * argSize, 1).toString(10);
              } else if (next == 117) {
                if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true); else
                argText = unSign(currArg, 8 * argSize, 1).toString(10);
                currArg = Math.abs(currArg);
              } else if (next == 111) {
                argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
              } else if (next == 120 || next == 88) {
                prefix = (flagAlternative && currArg != 0) ? '0x' : '';
                if (argSize == 8 && i64Math) {
                  if (origArg[1]) {
                    argText = (origArg[1]>>>0).toString(16);
                    var lower = (origArg[0]>>>0).toString(16);
                    while (lower.length < 8) lower = '0' + lower;
                    argText += lower;
                  } else {
                    argText = (origArg[0]>>>0).toString(16);
                  }
                } else
                if (currArg < 0) {
                  // Represent negative numbers in hex as 2's complement.
                  currArg = -currArg;
                  argText = (currAbsArg - 1).toString(16);
                  var buffer = [];
                  for (var i = 0; i < argText.length; i++) {
                    buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                  }
                  argText = buffer.join('');
                  while (argText.length < argSize * 2) argText = 'f' + argText;
                } else {
                  argText = currAbsArg.toString(16);
                }
                if (next == 88) {
                  prefix = prefix.toUpperCase();
                  argText = argText.toUpperCase();
                }
              } else if (next == 112) {
                if (currAbsArg === 0) {
                  argText = '(nil)';
                } else {
                  prefix = '0x';
                  argText = currAbsArg.toString(16);
                }
              }
              if (precisionSet) {
                while (argText.length < precision) {
                  argText = '0' + argText;
                }
              }
              // Add sign if needed
              if (currArg >= 0) {
                if (flagAlwaysSigned) {
                  prefix = '+' + prefix;
                } else if (flagPadSign) {
                  prefix = ' ' + prefix;
                }
              }
              // Move sign to prefix so we zero-pad after the sign
              if (argText.charAt(0) == '-') {
                prefix = '-' + prefix;
                argText = argText.substr(1);
              }
              // Add padding.
              while (prefix.length + argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad) {
                    argText = '0' + argText;
                  } else {
                    prefix = ' ' + prefix;
                  }
                }
              }
              // Insert the result into the buffer.
              argText = prefix + argText;
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 'f': case 'F': case 'e': case 'E': case 'g': case 'G': {
              // Float.
              var currArg = getNextArg('double');
              var argText;
              if (isNaN(currArg)) {
                argText = 'nan';
                flagZeroPad = false;
              } else if (!isFinite(currArg)) {
                argText = (currArg < 0 ? '-' : '') + 'inf';
                flagZeroPad = false;
              } else {
                var isGeneral = false;
                var effectivePrecision = Math.min(precision, 20);
                // Convert g/G to f/F or e/E, as per:
                // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                if (next == 103 || next == 71) {
                  isGeneral = true;
                  precision = precision || 1;
                  var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                  if (precision > exponent && exponent >= -4) {
                    next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                    precision -= exponent + 1;
                  } else {
                    next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                    precision--;
                  }
                  effectivePrecision = Math.min(precision, 20);
                }
                if (next == 101 || next == 69) {
                  argText = currArg.toExponential(effectivePrecision);
                  // Make sure the exponent has at least 2 digits.
                  if (/[eE][-+]\d$/.test(argText)) {
                    argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                  }
                } else if (next == 102 || next == 70) {
                  argText = currArg.toFixed(effectivePrecision);
                  if (currArg === 0 && __reallyNegative(currArg)) {
                    argText = '-' + argText;
                  }
                }
                var parts = argText.split('e');
                if (isGeneral && !flagAlternative) {
                  // Discard trailing zeros and periods.
                  while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                         (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                    parts[0] = parts[0].slice(0, -1);
                  }
                } else {
                  // Make sure we have a period in alternative mode.
                  if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                  // Zero pad until required precision.
                  while (precision > effectivePrecision++) parts[0] += '0';
                }
                argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');
                // Capitalize 'E' if needed.
                if (next == 69) argText = argText.toUpperCase();
                // Add sign.
                if (currArg >= 0) {
                  if (flagAlwaysSigned) {
                    argText = '+' + argText;
                  } else if (flagPadSign) {
                    argText = ' ' + argText;
                  }
                }
              }
              // Add padding.
              while (argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                    argText = argText[0] + '0' + argText.slice(1);
                  } else {
                    argText = (flagZeroPad ? '0' : ' ') + argText;
                  }
                }
              }
              // Adjust case.
              if (next < 97) argText = argText.toUpperCase();
              // Insert the result into the buffer.
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 's': {
              // String.
              var arg = getNextArg('i8*');
              var argLength = arg ? _strlen(arg) : '(null)'.length;
              if (precisionSet) argLength = Math.min(argLength, precision);
              if (!flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              if (arg) {
                for (var i = 0; i < argLength; i++) {
                  ret.push(HEAPU8[((arg++)|0)]);
                }
              } else {
                ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
              }
              if (flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              break;
            }
            case 'c': {
              // Character.
              if (flagLeftAlign) ret.push(getNextArg('i8'));
              while (--width > 0) {
                ret.push(32);
              }
              if (!flagLeftAlign) ret.push(getNextArg('i8'));
              break;
            }
            case 'n': {
              // Write the length written so far to the next parameter.
              var ptr = getNextArg('i32*');
              HEAP32[((ptr)>>2)]=ret.length
              break;
            }
            case '%': {
              // Literal percent sign.
              ret.push(curr);
              break;
            }
            default: {
              // Unknown specifiers remain untouched.
              for (var i = startTextIndex; i < textIndex + 2; i++) {
                ret.push(HEAP8[(i)]);
              }
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _snprintf(s, n, format, varargs) {
      // int snprintf(char *restrict s, size_t n, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var limit = (n === undefined) ? result.length
                                    : Math.min(result.length, Math.max(n - 1, 0));
      if (s < 0) {
        s = -s;
        var buf = _malloc(limit+1);
        HEAP32[((s)>>2)]=buf;
        s = buf;
      }
      for (var i = 0; i < limit; i++) {
        HEAP8[(((s)+(i))|0)]=result[i];
      }
      if (limit < n || (n === undefined)) HEAP8[(((s)+(i))|0)]=0;
      return result.length;
    }function _sprintf(s, format, varargs) {
      // int sprintf(char *restrict s, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      return _snprintf(s, undefined, format, varargs);
    }function _asprintf(s, format, varargs) {
      return _sprintf(-s, format, varargs);
    }function _vasprintf(s, format, va_arg) {
      return _asprintf(s, format, HEAP32[((va_arg)>>2)]);
    }
  var _llvm_memset_p0i8_i32=_memset;
  function ___cxa_begin_catch(ptr) {
      __ZSt18uncaught_exceptionv.uncaught_exception--;
      return ptr;
    }
  function ___cxa_end_catch() {
      if (___cxa_end_catch.rethrown) {
        ___cxa_end_catch.rethrown = false;
        return;
      }
      // Clear state flag.
      asm['setThrew'](0);
      // Clear type.
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=0
      // Call destructor if one is registered then clear it.
      var ptr = HEAP32[((_llvm_eh_exception.buf)>>2)];
      var destructor = HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)];
      if (destructor) {
        Runtime.dynCall('vi', destructor, [ptr]);
        HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=0
      }
      // Free ptr if it isn't null.
      if (ptr) {
        ___cxa_free_exception(ptr);
        HEAP32[((_llvm_eh_exception.buf)>>2)]=0
      }
    }
  function _mknod(path, mode, dev) {
      // int mknod(const char *path, mode_t mode, dev_t dev);
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/mknod.html
      path = Pointer_stringify(path);
      // we don't want this in the JS API as the JS API
      // uses mknod to create all nodes.
      switch (mode & 61440) {
        case 32768:
        case 8192:
        case 24576:
        case 4096:
        case 49152:
          break;
        default:
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
      }
      try {
        FS.mknod(path, mode, dev);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _mkdir(path, mode) {
      // int mkdir(const char *path, mode_t mode);
      // http://pubs.opengroup.org/onlinepubs/7908799/xsh/mkdir.html
      path = Pointer_stringify(path);
      try {
        FS.mkdir(path, mode, 0);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  function _llvm_lifetime_start() {}
  function _llvm_lifetime_end() {}
  function _open(path, oflag, varargs) {
      // int open(const char *path, int oflag, ...);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/open.html
      var mode = HEAP32[((varargs)>>2)];
      path = Pointer_stringify(path);
      try {
        var stream = FS.open(path, oflag, mode);
        return stream.fd;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fopen(filename, mode) {
      // FILE *fopen(const char *restrict filename, const char *restrict mode);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fopen.html
      var flags;
      mode = Pointer_stringify(mode);
      if (mode[0] == 'r') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 0;
        }
      } else if (mode[0] == 'w') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 64;
        flags |= 512;
      } else if (mode[0] == 'a') {
        if (mode.indexOf('+') != -1) {
          flags = 2;
        } else {
          flags = 1;
        }
        flags |= 64;
        flags |= 1024;
      } else {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return 0;
      }
      var ret = _open(filename, flags, allocate([0x1FF, 0, 0, 0], 'i32', ALLOC_STACK));  // All creation permissions.
      return (ret == -1) ? 0 : ret;
    }
  var SOCKFS={mount:function (mount) {
        return FS.createNode(null, '/', 16384 | 0777, 0);
      },createSocket:function (family, type, protocol) {
        var streaming = type == 1;
        if (protocol) {
          assert(streaming == (protocol == 6)); // if SOCK_STREAM, must be tcp
        }
        // create our internal socket structure
        var sock = {
          family: family,
          type: type,
          protocol: protocol,
          server: null,
          peers: {},
          pending: [],
          recv_queue: [],
          sock_ops: SOCKFS.websocket_sock_ops
        };
        // create the filesystem node to store the socket structure
        var name = SOCKFS.nextname();
        var node = FS.createNode(SOCKFS.root, name, 49152, 0);
        node.sock = sock;
        // and the wrapping stream that enables library functions such
        // as read and write to indirectly interact with the socket
        var stream = FS.createStream({
          path: name,
          node: node,
          flags: FS.modeStringToFlags('r+'),
          seekable: false,
          stream_ops: SOCKFS.stream_ops
        });
        // map the new stream to the socket structure (sockets have a 1:1
        // relationship with a stream)
        sock.stream = stream;
        return sock;
      },getSocket:function (fd) {
        var stream = FS.getStream(fd);
        if (!stream || !FS.isSocket(stream.node.mode)) {
          return null;
        }
        return stream.node.sock;
      },stream_ops:{poll:function (stream) {
          var sock = stream.node.sock;
          return sock.sock_ops.poll(sock);
        },ioctl:function (stream, request, varargs) {
          var sock = stream.node.sock;
          return sock.sock_ops.ioctl(sock, request, varargs);
        },read:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          var msg = sock.sock_ops.recvmsg(sock, length);
          if (!msg) {
            // socket is closed
            return 0;
          }
          buffer.set(msg.buffer, offset);
          return msg.buffer.length;
        },write:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          return sock.sock_ops.sendmsg(sock, buffer, offset, length);
        },close:function (stream) {
          var sock = stream.node.sock;
          sock.sock_ops.close(sock);
        }},nextname:function () {
        if (!SOCKFS.nextname.current) {
          SOCKFS.nextname.current = 0;
        }
        return 'socket[' + (SOCKFS.nextname.current++) + ']';
      },websocket_sock_ops:{createPeer:function (sock, addr, port) {
          var ws;
          if (typeof addr === 'object') {
            ws = addr;
            addr = null;
            port = null;
          }
          if (ws) {
            // for sockets that've already connected (e.g. we're the server)
            // we can inspect the _socket property for the address
            if (ws._socket) {
              addr = ws._socket.remoteAddress;
              port = ws._socket.remotePort;
            }
            // if we're just now initializing a connection to the remote,
            // inspect the url property
            else {
              var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
              if (!result) {
                throw new Error('WebSocket URL must be in the format ws(s)://address:port');
              }
              addr = result[1];
              port = parseInt(result[2], 10);
            }
          } else {
            // create the actual websocket object and connect
            try {
              var url = 'ws://' + addr + ':' + port;
              // the node ws library API is slightly different than the browser's
              var opts = ENVIRONMENT_IS_NODE ? {headers: {'websocket-protocol': ['binary']}} : ['binary'];
              // If node we use the ws library.
              var WebSocket = ENVIRONMENT_IS_NODE ? require('ws') : window['WebSocket'];
              ws = new WebSocket(url, opts);
              ws.binaryType = 'arraybuffer';
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH);
            }
          }
          var peer = {
            addr: addr,
            port: port,
            socket: ws,
            dgram_send_queue: []
          };
          SOCKFS.websocket_sock_ops.addPeer(sock, peer);
          SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);
          // if this is a bound dgram socket, send the port number first to allow
          // us to override the ephemeral port reported to us by remotePort on the
          // remote end.
          if (sock.type === 2 && typeof sock.sport !== 'undefined') {
            peer.dgram_send_queue.push(new Uint8Array([
                255, 255, 255, 255,
                'p'.charCodeAt(0), 'o'.charCodeAt(0), 'r'.charCodeAt(0), 't'.charCodeAt(0),
                ((sock.sport & 0xff00) >> 8) , (sock.sport & 0xff)
            ]));
          }
          return peer;
        },getPeer:function (sock, addr, port) {
          return sock.peers[addr + ':' + port];
        },addPeer:function (sock, peer) {
          sock.peers[peer.addr + ':' + peer.port] = peer;
        },removePeer:function (sock, peer) {
          delete sock.peers[peer.addr + ':' + peer.port];
        },handlePeerEvents:function (sock, peer) {
          var first = true;
          var handleOpen = function () {
            try {
              var queued = peer.dgram_send_queue.shift();
              while (queued) {
                peer.socket.send(queued);
                queued = peer.dgram_send_queue.shift();
              }
            } catch (e) {
              // not much we can do here in the way of proper error handling as we've already
              // lied and said this data was sent. shut it down.
              peer.socket.close();
            }
          };
          function handleMessage(data) {
            assert(typeof data !== 'string' && data.byteLength !== undefined);  // must receive an ArrayBuffer
            data = new Uint8Array(data);  // make a typed array view on the array buffer
            // if this is the port message, override the peer's port with it
            var wasfirst = first;
            first = false;
            if (wasfirst &&
                data.length === 10 &&
                data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 &&
                data[4] === 'p'.charCodeAt(0) && data[5] === 'o'.charCodeAt(0) && data[6] === 'r'.charCodeAt(0) && data[7] === 't'.charCodeAt(0)) {
              // update the peer's port and it's key in the peer map
              var newport = ((data[8] << 8) | data[9]);
              SOCKFS.websocket_sock_ops.removePeer(sock, peer);
              peer.port = newport;
              SOCKFS.websocket_sock_ops.addPeer(sock, peer);
              return;
            }
            sock.recv_queue.push({ addr: peer.addr, port: peer.port, data: data });
          };
          if (ENVIRONMENT_IS_NODE) {
            peer.socket.on('open', handleOpen);
            peer.socket.on('message', function(data, flags) {
              if (!flags.binary) {
                return;
              }
              handleMessage((new Uint8Array(data)).buffer);  // copy from node Buffer -> ArrayBuffer
            });
            peer.socket.on('error', function() {
              // don't throw
            });
          } else {
            peer.socket.onopen = handleOpen;
            peer.socket.onmessage = function peer_socket_onmessage(event) {
              handleMessage(event.data);
            };
          }
        },poll:function (sock) {
          if (sock.type === 1 && sock.server) {
            // listen sockets should only say they're available for reading
            // if there are pending clients.
            return sock.pending.length ? (64 | 1) : 0;
          }
          var mask = 0;
          var dest = sock.type === 1 ?  // we only care about the socket state for connection-based sockets
            SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) :
            null;
          if (sock.recv_queue.length ||
              !dest ||  // connection-less sockets are always ready to read
              (dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {  // let recv return 0 once closed
            mask |= (64 | 1);
          }
          if (!dest ||  // connection-less sockets are always ready to write
              (dest && dest.socket.readyState === dest.socket.OPEN)) {
            mask |= 4;
          }
          if ((dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {
            mask |= 16;
          }
          return mask;
        },ioctl:function (sock, request, arg) {
          switch (request) {
            case 21531:
              var bytes = 0;
              if (sock.recv_queue.length) {
                bytes = sock.recv_queue[0].data.length;
              }
              HEAP32[((arg)>>2)]=bytes;
              return 0;
            default:
              return ERRNO_CODES.EINVAL;
          }
        },close:function (sock) {
          // if we've spawned a listen server, close it
          if (sock.server) {
            try {
              sock.server.close();
            } catch (e) {
            }
            sock.server = null;
          }
          // close any peer connections
          var peers = Object.keys(sock.peers);
          for (var i = 0; i < peers.length; i++) {
            var peer = sock.peers[peers[i]];
            try {
              peer.socket.close();
            } catch (e) {
            }
            SOCKFS.websocket_sock_ops.removePeer(sock, peer);
          }
          return 0;
        },bind:function (sock, addr, port) {
          if (typeof sock.saddr !== 'undefined' || typeof sock.sport !== 'undefined') {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already bound
          }
          sock.saddr = addr;
          sock.sport = port || _mkport();
          // in order to emulate dgram sockets, we need to launch a listen server when
          // binding on a connection-less socket
          // note: this is only required on the server side
          if (sock.type === 2) {
            // close the existing server if it exists
            if (sock.server) {
              sock.server.close();
              sock.server = null;
            }
            // swallow error operation not supported error that occurs when binding in the
            // browser where this isn't supported
            try {
              sock.sock_ops.listen(sock, 0);
            } catch (e) {
              if (!(e instanceof FS.ErrnoError)) throw e;
              if (e.errno !== ERRNO_CODES.EOPNOTSUPP) throw e;
            }
          }
        },connect:function (sock, addr, port) {
          if (sock.server) {
            throw new FS.ErrnoError(ERRNO_CODS.EOPNOTSUPP);
          }
          // TODO autobind
          // if (!sock.addr && sock.type == 2) {
          // }
          // early out if we're already connected / in the middle of connecting
          if (typeof sock.daddr !== 'undefined' && typeof sock.dport !== 'undefined') {
            var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
            if (dest) {
              if (dest.socket.readyState === dest.socket.CONNECTING) {
                throw new FS.ErrnoError(ERRNO_CODES.EALREADY);
              } else {
                throw new FS.ErrnoError(ERRNO_CODES.EISCONN);
              }
            }
          }
          // add the socket to our peer list and set our
          // destination address / port to match
          var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
          sock.daddr = peer.addr;
          sock.dport = peer.port;
          // always "fail" in non-blocking mode
          throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS);
        },listen:function (sock, backlog) {
          if (!ENVIRONMENT_IS_NODE) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
          }
          if (sock.server) {
             throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already listening
          }
          var WebSocketServer = require('ws').Server;
          var host = sock.saddr;
          sock.server = new WebSocketServer({
            host: host,
            port: sock.sport
            // TODO support backlog
          });
          sock.server.on('connection', function(ws) {
            if (sock.type === 1) {
              var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);
              // create a peer on the new socket
              var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
              newsock.daddr = peer.addr;
              newsock.dport = peer.port;
              // push to queue for accept to pick up
              sock.pending.push(newsock);
            } else {
              // create a peer on the listen socket so calling sendto
              // with the listen socket and an address will resolve
              // to the correct client
              SOCKFS.websocket_sock_ops.createPeer(sock, ws);
            }
          });
          sock.server.on('closed', function() {
            sock.server = null;
          });
          sock.server.on('error', function() {
            // don't throw
          });
        },accept:function (listensock) {
          if (!listensock.server) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          var newsock = listensock.pending.shift();
          newsock.stream.flags = listensock.stream.flags;
          return newsock;
        },getname:function (sock, peer) {
          var addr, port;
          if (peer) {
            if (sock.daddr === undefined || sock.dport === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            }
            addr = sock.daddr;
            port = sock.dport;
          } else {
            // TODO saddr and sport will be set for bind()'d UDP sockets, but what
            // should we be returning for TCP sockets that've been connect()'d?
            addr = sock.saddr || 0;
            port = sock.sport || 0;
          }
          return { addr: addr, port: port };
        },sendmsg:function (sock, buffer, offset, length, addr, port) {
          if (sock.type === 2) {
            // connection-less sockets will honor the message address,
            // and otherwise fall back to the bound destination address
            if (addr === undefined || port === undefined) {
              addr = sock.daddr;
              port = sock.dport;
            }
            // if there was no address to fall back to, error out
            if (addr === undefined || port === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ);
            }
          } else {
            // connection-based sockets will only use the bound
            addr = sock.daddr;
            port = sock.dport;
          }
          // find the peer for the destination address
          var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);
          // early out if not connected with a connection-based socket
          if (sock.type === 1) {
            if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            } else if (dest.socket.readyState === dest.socket.CONNECTING) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
          // create a copy of the incoming data to send, as the WebSocket API
          // doesn't work entirely with an ArrayBufferView, it'll just send
          // the entire underlying buffer
          var data;
          if (buffer instanceof Array || buffer instanceof ArrayBuffer) {
            data = buffer.slice(offset, offset + length);
          } else {  // ArrayBufferView
            data = buffer.buffer.slice(buffer.byteOffset + offset, buffer.byteOffset + offset + length);
          }
          // if we're emulating a connection-less dgram socket and don't have
          // a cached connection, queue the buffer to send upon connect and
          // lie, saying the data was sent now.
          if (sock.type === 2) {
            if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
              // if we're not connected, open a new connection
              if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
              }
              dest.dgram_send_queue.push(data);
              return length;
            }
          }
          try {
            // send the actual data
            dest.socket.send(data);
            return length;
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
        },recvmsg:function (sock, length) {
          // http://pubs.opengroup.org/onlinepubs/7908799/xns/recvmsg.html
          if (sock.type === 1 && sock.server) {
            // tcp servers should not be recv()'ing on the listen socket
            throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
          }
          var queued = sock.recv_queue.shift();
          if (!queued) {
            if (sock.type === 1) {
              var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
              if (!dest) {
                // if we have a destination address but are not connected, error out
                throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
              }
              else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                // return null if the socket has closed
                return null;
              }
              else {
                // else, our socket is in a valid state but truly has nothing available
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
            } else {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
          // queued.data will be an ArrayBuffer if it's unadulterated, but if it's
          // requeued TCP data it'll be an ArrayBufferView
          var queuedLength = queued.data.byteLength || queued.data.length;
          var queuedOffset = queued.data.byteOffset || 0;
          var queuedBuffer = queued.data.buffer || queued.data;
          var bytesRead = Math.min(length, queuedLength);
          var res = {
            buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
            addr: queued.addr,
            port: queued.port
          };
          // push back any unread data for TCP connections
          if (sock.type === 1 && bytesRead < queuedLength) {
            var bytesRemaining = queuedLength - bytesRead;
            queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
            sock.recv_queue.unshift(queued);
          }
          return res;
        }}};function _send(fd, buf, len, flags) {
      var sock = SOCKFS.getSocket(fd);
      if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      // TODO honor flags
      return _write(fd, buf, len);
    }
  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var bytesWritten = _write(stream, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        var streamObj = FS.getStream(stream);
        if (streamObj) streamObj.error = true;
        return 0;
      } else {
        return Math.floor(bytesWritten / size);
      }
    }
  function _close(fildes) {
      // int close(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/close.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        FS.close(stream);
        return 0;
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }
  function _fsync(fildes) {
      // int fsync(int fildes);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fsync.html
      var stream = FS.getStream(fildes);
      if (stream) {
        // We write directly to the file system, so there's nothing to do here.
        return 0;
      } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
    }function _fclose(stream) {
      // int fclose(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fclose.html
      _fsync(stream);
      return _close(stream);
    }
  Module["_memmove"] = _memmove;var _llvm_memmove_p0i8_p0i8_i32=_memmove;
  function _lseek(fildes, offset, whence) {
      // off_t lseek(int fildes, off_t offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/lseek.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        return FS.llseek(stream, offset, whence);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fseek(stream, offset, whence) {
      // int fseek(FILE *stream, long offset, int whence);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fseek.html
      var ret = _lseek(stream, offset, whence);
      if (ret == -1) {
        return -1;
      }
      stream = FS.getStream(stream);
      stream.eof = false;
      return 0;
    }
  function _ftell(stream) {
      // long ftell(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ftell.html
      stream = FS.getStream(stream);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      if (FS.isChrdev(stream.node.mode)) {
        ___setErrNo(ERRNO_CODES.ESPIPE);
        return -1;
      } else {
        return stream.position;
      }
    }
  function _recv(fd, buf, len, flags) {
      var sock = SOCKFS.getSocket(fd);
      if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      // TODO honor flags
      return _read(fd, buf, len);
    }
  function _pread(fildes, buf, nbyte, offset) {
      // ssize_t pread(int fildes, void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _read(fildes, buf, nbyte) {
      // ssize_t read(int fildes, void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/read.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fread(ptr, size, nitems, stream) {
      // size_t fread(void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fread.html
      var bytesToRead = nitems * size;
      if (bytesToRead == 0) {
        return 0;
      }
      var bytesRead = 0;
      var streamObj = FS.getStream(stream);
      while (streamObj.ungotten.length && bytesToRead > 0) {
        HEAP8[((ptr++)|0)]=streamObj.ungotten.pop()
        bytesToRead--;
        bytesRead++;
      }
      var err = _read(stream, ptr, bytesToRead);
      if (err == -1) {
        if (streamObj) streamObj.error = true;
        return 0;
      }
      bytesRead += err;
      if (bytesRead < bytesToRead) streamObj.eof = true;
      return Math.floor(bytesRead / size);
    }
  function _strcmp(px, py) {
      return _strncmp(px, py, TOTAL_MEMORY);
    }
  function _srand(seed) {}
  function _time(ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret
      }
      return ret;
    }
  var _cosf=Math_cos;
  function _rand() {
      return Math.floor(Math.random()*0x80000000);
    }
  var _sinf=Math_sin;
  var _fabsf=Math_abs;
  var _sqrtf=Math_sqrt;
  var _cos=Math_cos;
  function _pthread_mutex_init() {}
  function _pthread_mutex_destroy() {}
  function _pthread_mutex_lock() {}
  function _pthread_mutex_unlock() {}
  function _fmod(x, y) {
      return x % y;
    }var _fmodf=_fmod;
  function ___assert_fail(condition, filename, line, func) {
      ABORT = true;
      throw 'Assertion failed: ' + Pointer_stringify(condition) + ', at: ' + [filename ? Pointer_stringify(filename) : 'unknown filename', line, func ? Pointer_stringify(func) : 'unknown function'] + ' at ' + stackTrace();
    }
  function _qsort(base, num, size, cmp) {
      if (num == 0 || size == 0) return;
      // forward calls to the JavaScript sort method
      // first, sort the items logically
      var keys = [];
      for (var i = 0; i < num; i++) keys.push(i);
      keys.sort(function(a, b) {
        return Module['dynCall_iii'](cmp, base+a*size, base+b*size);
      });
      // apply the sort
      var temp = _malloc(num*size);
      _memcpy(temp, base, num*size);
      for (var i = 0; i < num; i++) {
        if (keys[i] == i) continue; // already in place
        _memcpy(base+i*size, temp+keys[i]*size, size);
      }
      _free(temp);
    }
  var _sin=Math_sin;
  var _floor=Math_floor;
  var _exp=Math_exp;
  var _log=Math_log;
  var _llvm_pow_f64=Math_pow;
  function _ldexp(x, exp_) {
      return x * Math.pow(2, exp_);
    }
  function __getFloat(text) {
      return /^[+-]?[0-9]*\.?[0-9]+([eE][+-]?[0-9]+)?/.exec(text);
    }function __scanString(format, get, unget, varargs) {
      if (!__scanString.whiteSpace) {
        __scanString.whiteSpace = {};
        __scanString.whiteSpace[32] = 1;
        __scanString.whiteSpace[9] = 1;
        __scanString.whiteSpace[10] = 1;
        __scanString.whiteSpace[11] = 1;
        __scanString.whiteSpace[12] = 1;
        __scanString.whiteSpace[13] = 1;
      }
      // Supports %x, %4x, %d.%d, %lld, %s, %f, %lf.
      // TODO: Support all format specifiers.
      format = Pointer_stringify(format);
      var soFar = 0;
      if (format.indexOf('%n') >= 0) {
        // need to track soFar
        var _get = get;
        get = function get() {
          soFar++;
          return _get();
        }
        var _unget = unget;
        unget = function unget() {
          soFar--;
          return _unget();
        }
      }
      var formatIndex = 0;
      var argsi = 0;
      var fields = 0;
      var argIndex = 0;
      var next;
      mainLoop:
      for (var formatIndex = 0; formatIndex < format.length;) {
        if (format[formatIndex] === '%' && format[formatIndex+1] == 'n') {
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          HEAP32[((argPtr)>>2)]=soFar;
          formatIndex += 2;
          continue;
        }
        if (format[formatIndex] === '%') {
          var nextC = format.indexOf('c', formatIndex+1);
          if (nextC > 0) {
            var maxx = 1;
            if (nextC > formatIndex+1) {
              var sub = format.substring(formatIndex+1, nextC);
              maxx = parseInt(sub);
              if (maxx != sub) maxx = 0;
            }
            if (maxx) {
              var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
              argIndex += Runtime.getAlignSize('void*', null, true);
              fields++;
              for (var i = 0; i < maxx; i++) {
                next = get();
                HEAP8[((argPtr++)|0)]=next;
              }
              formatIndex += nextC - formatIndex + 1;
              continue;
            }
          }
        }
        // handle %[...]
        if (format[formatIndex] === '%' && format.indexOf('[', formatIndex+1) > 0) {
          var match = /\%([0-9]*)\[(\^)?(\]?[^\]]*)\]/.exec(format.substring(formatIndex));
          if (match) {
            var maxNumCharacters = parseInt(match[1]) || Infinity;
            var negateScanList = (match[2] === '^');
            var scanList = match[3];
            // expand "middle" dashs into character sets
            var middleDashMatch;
            while ((middleDashMatch = /([^\-])\-([^\-])/.exec(scanList))) {
              var rangeStartCharCode = middleDashMatch[1].charCodeAt(0);
              var rangeEndCharCode = middleDashMatch[2].charCodeAt(0);
              for (var expanded = ''; rangeStartCharCode <= rangeEndCharCode; expanded += String.fromCharCode(rangeStartCharCode++));
              scanList = scanList.replace(middleDashMatch[1] + '-' + middleDashMatch[2], expanded);
            }
            var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
            argIndex += Runtime.getAlignSize('void*', null, true);
            fields++;
            for (var i = 0; i < maxNumCharacters; i++) {
              next = get();
              if (negateScanList) {
                if (scanList.indexOf(String.fromCharCode(next)) < 0) {
                  HEAP8[((argPtr++)|0)]=next;
                } else {
                  unget();
                  break;
                }
              } else {
                if (scanList.indexOf(String.fromCharCode(next)) >= 0) {
                  HEAP8[((argPtr++)|0)]=next;
                } else {
                  unget();
                  break;
                }
              }
            }
            // write out null-terminating character
            HEAP8[((argPtr++)|0)]=0;
            formatIndex += match[0].length;
            continue;
          }
        }      
        // remove whitespace
        while (1) {
          next = get();
          if (next == 0) return fields;
          if (!(next in __scanString.whiteSpace)) break;
        }
        unget();
        if (format[formatIndex] === '%') {
          formatIndex++;
          var suppressAssignment = false;
          if (format[formatIndex] == '*') {
            suppressAssignment = true;
            formatIndex++;
          }
          var maxSpecifierStart = formatIndex;
          while (format[formatIndex].charCodeAt(0) >= 48 &&
                 format[formatIndex].charCodeAt(0) <= 57) {
            formatIndex++;
          }
          var max_;
          if (formatIndex != maxSpecifierStart) {
            max_ = parseInt(format.slice(maxSpecifierStart, formatIndex), 10);
          }
          var long_ = false;
          var half = false;
          var longLong = false;
          if (format[formatIndex] == 'l') {
            long_ = true;
            formatIndex++;
            if (format[formatIndex] == 'l') {
              longLong = true;
              formatIndex++;
            }
          } else if (format[formatIndex] == 'h') {
            half = true;
            formatIndex++;
          }
          var type = format[formatIndex];
          formatIndex++;
          var curr = 0;
          var buffer = [];
          // Read characters according to the format. floats are trickier, they may be in an unfloat state in the middle, then be a valid float later
          if (type == 'f' || type == 'e' || type == 'g' ||
              type == 'F' || type == 'E' || type == 'G') {
            next = get();
            while (next > 0 && (!(next in __scanString.whiteSpace)))  {
              buffer.push(String.fromCharCode(next));
              next = get();
            }
            var m = __getFloat(buffer.join(''));
            var last = m ? m[0].length : 0;
            for (var i = 0; i < buffer.length - last + 1; i++) {
              unget();
            }
            buffer.length = last;
          } else {
            next = get();
            var first = true;
            // Strip the optional 0x prefix for %x.
            if ((type == 'x' || type == 'X') && (next == 48)) {
              var peek = get();
              if (peek == 120 || peek == 88) {
                next = get();
              } else {
                unget();
              }
            }
            while ((curr < max_ || isNaN(max_)) && next > 0) {
              if (!(next in __scanString.whiteSpace) && // stop on whitespace
                  (type == 's' ||
                   ((type === 'd' || type == 'u' || type == 'i') && ((next >= 48 && next <= 57) ||
                                                                     (first && next == 45))) ||
                   ((type === 'x' || type === 'X') && (next >= 48 && next <= 57 ||
                                     next >= 97 && next <= 102 ||
                                     next >= 65 && next <= 70))) &&
                  (formatIndex >= format.length || next !== format[formatIndex].charCodeAt(0))) { // Stop when we read something that is coming up
                buffer.push(String.fromCharCode(next));
                next = get();
                curr++;
                first = false;
              } else {
                break;
              }
            }
            unget();
          }
          if (buffer.length === 0) return 0;  // Failure.
          if (suppressAssignment) continue;
          var text = buffer.join('');
          var argPtr = HEAP32[(((varargs)+(argIndex))>>2)];
          argIndex += Runtime.getAlignSize('void*', null, true);
          switch (type) {
            case 'd': case 'u': case 'i':
              if (half) {
                HEAP16[((argPtr)>>1)]=parseInt(text, 10);
              } else if (longLong) {
                (tempI64 = [parseInt(text, 10)>>>0,(tempDouble=parseInt(text, 10),(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)],HEAP32[((argPtr)>>2)]=tempI64[0],HEAP32[(((argPtr)+(4))>>2)]=tempI64[1]);
              } else {
                HEAP32[((argPtr)>>2)]=parseInt(text, 10);
              }
              break;
            case 'X':
            case 'x':
              HEAP32[((argPtr)>>2)]=parseInt(text, 16)
              break;
            case 'F':
            case 'f':
            case 'E':
            case 'e':
            case 'G':
            case 'g':
            case 'E':
              // fallthrough intended
              if (long_) {
                HEAPF64[((argPtr)>>3)]=parseFloat(text)
              } else {
                HEAPF32[((argPtr)>>2)]=parseFloat(text)
              }
              break;
            case 's':
              var array = intArrayFromString(text);
              for (var j = 0; j < array.length; j++) {
                HEAP8[(((argPtr)+(j))|0)]=array[j]
              }
              break;
          }
          fields++;
        } else if (format[formatIndex].charCodeAt(0) in __scanString.whiteSpace) {
          next = get();
          while (next in __scanString.whiteSpace) {
            if (next <= 0) break mainLoop;  // End of input.
            next = get();
          }
          unget(next);
          formatIndex++;
        } else {
          // Not a specifier.
          next = get();
          if (format[formatIndex].charCodeAt(0) !== next) {
            unget(next);
            break mainLoop;
          }
          formatIndex++;
        }
      }
      return fields;
    }function _sscanf(s, format, varargs) {
      // int sscanf(const char *restrict s, const char *restrict format, ... );
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/scanf.html
      var index = 0;
      function get() { return HEAP8[(((s)+(index++))|0)]; };
      function unget() { index--; };
      return __scanString(format, get, unget, varargs);
    }
  function __parseInt(str, endptr, base, min, max, bits, unsign) {
      // Skip space.
      while (_isspace(HEAP8[(str)])) str++;
      // Check for a plus/minus sign.
      var multiplier = 1;
      if (HEAP8[(str)] == 45) {
        multiplier = -1;
        str++;
      } else if (HEAP8[(str)] == 43) {
        str++;
      }
      // Find base.
      var finalBase = base;
      if (!finalBase) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            finalBase = 16;
            str += 2;
          } else {
            finalBase = 8;
            str++;
          }
        }
      } else if (finalBase==16) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            str += 2;
          }
        }
      }
      if (!finalBase) finalBase = 10;
      // Get digits.
      var chr;
      var ret = 0;
      while ((chr = HEAP8[(str)]) != 0) {
        var digit = parseInt(String.fromCharCode(chr), finalBase);
        if (isNaN(digit)) {
          break;
        } else {
          ret = ret * finalBase + digit;
          str++;
        }
      }
      // Apply sign.
      ret *= multiplier;
      // Set end pointer.
      if (endptr) {
        HEAP32[((endptr)>>2)]=str
      }
      // Unsign if needed.
      if (unsign) {
        if (Math.abs(ret) > max) {
          ret = max;
          ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          ret = unSign(ret, bits);
        }
      }
      // Validate range.
      if (ret > max || ret < min) {
        ret = ret > max ? max : min;
        ___setErrNo(ERRNO_CODES.ERANGE);
      }
      if (bits == 64) {
        return ((asm["setTempRet0"]((tempDouble=ret,(+(Math_abs(tempDouble))) >= (+1) ? (tempDouble > (+0) ? ((Math_min((+(Math_floor((tempDouble)/(+4294967296)))), (+4294967295)))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+4294967296))))))>>>0) : 0)),ret>>>0)|0);
      }
      return ret;
    }function _strtol(str, endptr, base) {
      return __parseInt(str, endptr, base, -2147483648, 2147483647, 32);  // LONG_MIN, LONG_MAX.
    }function _atoi(ptr) {
      return _strtol(ptr, null, 10);
    }
  function ___cxa_pure_virtual() {
      ABORT = true;
      throw 'Pure virtual function called!';
    }
  var GL={counter:1,lastError:0,buffers:[],programs:[],framebuffers:[],renderbuffers:[],textures:[],uniforms:[],shaders:[],currArrayBuffer:0,currElementArrayBuffer:0,byteSizeByTypeRoot:5120,byteSizeByType:[1,1,2,2,4,4,4,2,3,4,8],programInfos:{},stringCache:{},packAlignment:4,unpackAlignment:4,init:function () {
        Browser.moduleContextCreatedCallbacks.push(GL.initExtensions);
      },recordError:function recordError(errorCode) {
        if (!GL.lastError) {
          GL.lastError = errorCode;
        }
      },getNewId:function (table) {
        var ret = GL.counter++;
        for (var i = table.length; i < ret; i++) {
          table[i] = null;
        }
        return ret;
      },MINI_TEMP_BUFFER_SIZE:16,miniTempBuffer:null,miniTempBufferViews:[0],MAX_TEMP_BUFFER_SIZE:2097152,tempBufferIndexLookup:null,tempVertexBuffers:null,tempIndexBuffers:null,tempQuadIndexBuffer:null,generateTempBuffers:function (quads) {
        GL.tempBufferIndexLookup = new Uint8Array(GL.MAX_TEMP_BUFFER_SIZE+1);
        GL.tempVertexBuffers = [];
        GL.tempIndexBuffers = [];
        var last = -1, curr = -1;
        var size = 1;
        for (var i = 0; i <= GL.MAX_TEMP_BUFFER_SIZE; i++) {
          if (i > size) {
            size <<= 1;
          }
          if (size != last) {
            curr++;
            GL.tempVertexBuffers[curr] = Module.ctx.createBuffer();
            Module.ctx.bindBuffer(Module.ctx.ARRAY_BUFFER, GL.tempVertexBuffers[curr]);
            Module.ctx.bufferData(Module.ctx.ARRAY_BUFFER, size, Module.ctx.DYNAMIC_DRAW);
            Module.ctx.bindBuffer(Module.ctx.ARRAY_BUFFER, null);
            GL.tempIndexBuffers[curr] = Module.ctx.createBuffer();
            Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, GL.tempIndexBuffers[curr]);
            Module.ctx.bufferData(Module.ctx.ELEMENT_ARRAY_BUFFER, size, Module.ctx.DYNAMIC_DRAW);
            Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, null);
            last = size;
          }
          GL.tempBufferIndexLookup[i] = curr;
        }
        if (quads) {
          // GL_QUAD indexes can be precalculated
          GL.tempQuadIndexBuffer = Module.ctx.createBuffer();
          Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, GL.tempQuadIndexBuffer);
          var numIndexes = GL.MAX_TEMP_BUFFER_SIZE >> 1;
          var quadIndexes = new Uint16Array(numIndexes);
          var i = 0, v = 0;
          while (1) {
            quadIndexes[i++] = v;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+1;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+2;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+2;
            if (i >= numIndexes) break;
            quadIndexes[i++] = v+3;
            if (i >= numIndexes) break;
            v += 4;
          }
          Module.ctx.bufferData(Module.ctx.ELEMENT_ARRAY_BUFFER, quadIndexes, Module.ctx.STATIC_DRAW);
          Module.ctx.bindBuffer(Module.ctx.ELEMENT_ARRAY_BUFFER, null);
        }
      },findToken:function (source, token) {
        function isIdentChar(ch) {
          if (ch >= 48 && ch <= 57) // 0-9
            return true;
          if (ch >= 65 && ch <= 90) // A-Z
            return true;
          if (ch >= 97 && ch <= 122) // a-z
            return true;
          return false;
        }
        var i = -1;
        do {
          i = source.indexOf(token, i + 1);
          if (i < 0) {
            break;
          }
          if (i > 0 && isIdentChar(source[i - 1])) {
            continue;
          }
          i += token.length;
          if (i < source.length - 1 && isIdentChar(source[i + 1])) {
            continue;
          }
          return true;
        } while (true);
        return false;
      },getSource:function (shader, count, string, length) {
        var source = '';
        for (var i = 0; i < count; ++i) {
          var frag;
          if (length) {
            var len = HEAP32[(((length)+(i*4))>>2)];
            if (len < 0) {
              frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)]);
            } else {
              frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)], len);
            }
          } else {
            frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)]);
          }
          source += frag;
        }
        // Let's see if we need to enable the standard derivatives extension
        type = Module.ctx.getShaderParameter(GL.shaders[shader], 0x8B4F /* GL_SHADER_TYPE */);
        if (type == 0x8B30 /* GL_FRAGMENT_SHADER */) {
          if (GL.findToken(source, "dFdx") ||
              GL.findToken(source, "dFdy") ||
              GL.findToken(source, "fwidth")) {
            source = "#extension GL_OES_standard_derivatives : enable\n" + source;
            var extension = Module.ctx.getExtension("OES_standard_derivatives");
          }
        }
        return source;
      },computeImageSize:function (width, height, sizePerPixel, alignment) {
        function roundedToNextMultipleOf(x, y) {
          return Math.floor((x + y - 1) / y) * y
        }
        var plainRowSize = width * sizePerPixel;
        var alignedRowSize = roundedToNextMultipleOf(plainRowSize, alignment);
        return (height <= 0) ? 0 :
                 ((height - 1) * alignedRowSize + plainRowSize);
      },getTexPixelData:function (type, format, width, height, pixels, internalFormat) {
        var sizePerPixel;
        switch (type) {
          case 0x1401 /* GL_UNSIGNED_BYTE */:
            switch (format) {
              case 0x1906 /* GL_ALPHA */:
              case 0x1909 /* GL_LUMINANCE */:
                sizePerPixel = 1;
                break;
              case 0x1907 /* GL_RGB */:
                sizePerPixel = 3;
                break;
              case 0x1908 /* GL_RGBA */:
                sizePerPixel = 4;
                break;
              case 0x190A /* GL_LUMINANCE_ALPHA */:
                sizePerPixel = 2;
                break;
              default:
                throw 'Invalid format (' + format + ')';
            }
            break;
          case 0x1403 /* GL_UNSIGNED_SHORT */:
            if (format == 0x1902 /* GL_DEPTH_COMPONENT */) {
              sizePerPixel = 2;
            } else {
              throw 'Invalid format (' + format + ')';
            }
            break;
          case 0x1405 /* GL_UNSIGNED_INT */:
            if (format == 0x1902 /* GL_DEPTH_COMPONENT */) {
              sizePerPixel = 4;
            } else {
              throw 'Invalid format (' + format + ')';
            }
            break;
          case 0x84FA /* UNSIGNED_INT_24_8_WEBGL */:
            sizePerPixel = 4;
            break;
          case 0x8363 /* GL_UNSIGNED_SHORT_5_6_5 */:
          case 0x8033 /* GL_UNSIGNED_SHORT_4_4_4_4 */:
          case 0x8034 /* GL_UNSIGNED_SHORT_5_5_5_1 */:
            sizePerPixel = 2;
            break;
          case 0x1406 /* GL_FLOAT */:
            switch (format) {
              case 0x1907 /* GL_RGB */:
                sizePerPixel = 3*4;
                break;
              case 0x1908 /* GL_RGBA */:
                sizePerPixel = 4*4;
                break;
              default:
                throw 'Invalid format (' + format + ')';
            }
            internalFormat = Module.ctx.RGBA;
            break;
          default:
            throw 'Invalid type (' + type + ')';
        }
        var bytes = GL.computeImageSize(width, height, sizePerPixel, GL.unpackAlignment);
        if (type == 0x1401 /* GL_UNSIGNED_BYTE */) {
          pixels = HEAPU8.subarray((pixels),(pixels+bytes));
        } else if (type == 0x1406 /* GL_FLOAT */) {
          pixels = HEAPF32.subarray((pixels)>>2,(pixels+bytes)>>2);
        } else if (type == 0x1405 /* GL_UNSIGNED_INT */ || type == 0x84FA /* UNSIGNED_INT_24_8_WEBGL */) {
          pixels = HEAPU32.subarray((pixels)>>2,(pixels+bytes)>>2);
        } else {
          pixels = HEAPU16.subarray((pixels)>>1,(pixels+bytes)>>1);
        }
        return {
          pixels: pixels,
          internalFormat: internalFormat
        }
      },initExtensions:function () {
        if (GL.initExtensions.done) return;
        GL.initExtensions.done = true;
        if (!Module.useWebGL) return; // an app might link both gl and 2d backends
        GL.miniTempBuffer = new Float32Array(GL.MINI_TEMP_BUFFER_SIZE);
        for (var i = 0; i < GL.MINI_TEMP_BUFFER_SIZE; i++) {
          GL.miniTempBufferViews[i] = GL.miniTempBuffer.subarray(0, i+1);
        }
        GL.maxVertexAttribs = Module.ctx.getParameter(Module.ctx.MAX_VERTEX_ATTRIBS);
        // Detect the presence of a few extensions manually, this GL interop layer itself will need to know if they exist. 
        GL.compressionExt = Module.ctx.getExtension('WEBGL_compressed_texture_s3tc') ||
                            Module.ctx.getExtension('MOZ_WEBGL_compressed_texture_s3tc') ||
                            Module.ctx.getExtension('WEBKIT_WEBGL_compressed_texture_s3tc');
        GL.anisotropicExt = Module.ctx.getExtension('EXT_texture_filter_anisotropic') ||
                            Module.ctx.getExtension('MOZ_EXT_texture_filter_anisotropic') ||
                            Module.ctx.getExtension('WEBKIT_EXT_texture_filter_anisotropic');
        GL.floatExt = Module.ctx.getExtension('OES_texture_float');
        // These are the 'safe' feature-enabling extensions that don't add any performance impact related to e.g. debugging, and
        // should be enabled by default so that client GLES2/GL code will not need to go through extra hoops to get its stuff working.
        // As new extensions are ratified at http://www.khronos.org/registry/webgl/extensions/ , feel free to add your new extensions
        // here, as long as they don't produce a performance impact for users that might not be using those extensions.
        // E.g. debugging-related extensions should probably be off by default.
        var automaticallyEnabledExtensions = [ "OES_texture_float", "OES_texture_half_float", "OES_standard_derivatives",
                                               "OES_vertex_array_object", "WEBGL_compressed_texture_s3tc", "WEBGL_depth_texture",
                                               "OES_element_index_uint", "EXT_texture_filter_anisotropic", "ANGLE_instanced_arrays",
                                               "OES_texture_float_linear", "OES_texture_half_float_linear", "WEBGL_compressed_texture_atc",
                                               "WEBGL_compressed_texture_pvrtc", "EXT_color_buffer_half_float", "WEBGL_color_buffer_float",
                                               "EXT_frag_depth", "EXT_sRGB", "WEBGL_draw_buffers", "WEBGL_shared_resources" ];
        function shouldEnableAutomatically(extension) {
          for(var i in automaticallyEnabledExtensions) {
            var include = automaticallyEnabledExtensions[i];
            if (ext.indexOf(include) != -1) {
              return true;
            }
          }
          return false;
        }
        var extensions = Module.ctx.getSupportedExtensions();
        for(var e in extensions) {
          var ext = extensions[e].replace('MOZ_', '').replace('WEBKIT_', '');
          if (automaticallyEnabledExtensions.indexOf(ext) != -1) {
            Module.ctx.getExtension(ext); // Calling .getExtension enables that extension permanently, no need to store the return value to be enabled.
          }
        }
      },populateUniformTable:function (program) {
        var p = GL.programs[program];
        GL.programInfos[program] = {
          uniforms: {},
          maxUniformLength: 0, // This is eagerly computed below, since we already enumerate all uniforms anyway.
          maxAttributeLength: -1 // This is lazily computed and cached, computed when/if first asked, "-1" meaning not computed yet.
        };
        var ptable = GL.programInfos[program];
        var utable = ptable.uniforms;
        // A program's uniform table maps the string name of an uniform to an integer location of that uniform.
        // The global GL.uniforms map maps integer locations to WebGLUniformLocations.
        var numUniforms = Module.ctx.getProgramParameter(p, Module.ctx.ACTIVE_UNIFORMS);
        for (var i = 0; i < numUniforms; ++i) {
          var u = Module.ctx.getActiveUniform(p, i);
          var name = u.name;
          ptable.maxUniformLength = Math.max(ptable.maxUniformLength, name.length+1);
          // Strip off any trailing array specifier we might have got, e.g. "[0]".
          if (name.indexOf(']', name.length-1) !== -1) {
            var ls = name.lastIndexOf('[');
            name = name.slice(0, ls);
          }
          // Optimize memory usage slightly: If we have an array of uniforms, e.g. 'vec3 colors[3];', then 
          // only store the string 'colors' in utable, and 'colors[0]', 'colors[1]' and 'colors[2]' will be parsed as 'colors'+i.
          // Note that for the GL.uniforms table, we still need to fetch the all WebGLUniformLocations for all the indices.
          var loc = Module.ctx.getUniformLocation(p, name);
          var id = GL.getNewId(GL.uniforms);
          utable[name] = [u.size, id];
          GL.uniforms[id] = loc;
          for (var j = 1; j < u.size; ++j) {
            var n = name + '['+j+']';
            loc = Module.ctx.getUniformLocation(p, n);
            id = GL.getNewId(GL.uniforms);
            GL.uniforms[id] = loc;
          }
        }
      }};function _glUniformMatrix4fv(location, count, transpose, value) {
      location = GL.uniforms[location];
      var view;
      if (count == 1) {
        // avoid allocation for the common case of uploading one uniform matrix
        view = GL.miniTempBufferViews[15];
        for (var i = 0; i < 16; i++) {
          view[i] = HEAPF32[(((value)+(i*4))>>2)];
        }
      } else {
        view = HEAPF32.subarray((value)>>2,(value+count*64)>>2);
      }
      Module.ctx.uniformMatrix4fv(location, transpose, view);
    }
  function _glDrawArrays(mode, first, count) {
      Module.ctx.drawArrays(mode, first, count);
    }
  function _glUniform2f(location, v0, v1) {
      location = GL.uniforms[location];
      Module.ctx.uniform2f(location, v0, v1);
    }
  function _glClearColor(x0, x1, x2, x3) { Module.ctx.clearColor(x0, x1, x2, x3) }
  function _glPixelStorei(pname, param) {
      if (pname == 0x0D05 /* GL_PACK_ALIGNMENT */) {
        GL.packAlignment = param;
      } else if (pname == 0x0cf5 /* GL_UNPACK_ALIGNMENT */) {
        GL.unpackAlignment = param;
      }
      Module.ctx.pixelStorei(pname, param);
    }
  function _glEnable(x0) { Module.ctx.enable(x0) }
  function _glCullFace(x0) { Module.ctx.cullFace(x0) }
  function _glBlendFunc(x0, x1) { Module.ctx.blendFunc(x0, x1) }
  function _glViewport(x0, x1, x2, x3) { Module.ctx.viewport(x0, x1, x2, x3) }
  function _glDisable(x0) { Module.ctx.disable(x0) }
  function _glClear(x0) { Module.ctx.clear(x0) }
  function _glColorMask(x0, x1, x2, x3) { Module.ctx.colorMask(x0, x1, x2, x3) }
  function _glEnableVertexAttribArray(index) {
      Module.ctx.enableVertexAttribArray(index);
    }
  function _llvm_umul_with_overflow_i32(x, y) {
      x = x>>>0;
      y = y>>>0;
      return ((asm["setTempRet0"](x*y > 4294967295),(x*y)>>>0)|0);
    }
  function _glUniform3fv(location, count, value) {
      location = GL.uniforms[location];
      var view;
      if (count == 1) {
        // avoid allocation for the common case of uploading one uniform
        view = GL.miniTempBufferViews[2];
        view[0] = HEAPF32[((value)>>2)];
        view[1] = HEAPF32[(((value)+(4))>>2)];
        view[2] = HEAPF32[(((value)+(8))>>2)];
      } else {
        view = HEAPF32.subarray((value)>>2,(value+count*12)>>2);
      }
      Module.ctx.uniform3fv(location, view);
    }
  function _glUniform1i(location, v0) {
      location = GL.uniforms[location];
      Module.ctx.uniform1i(location, v0);
    }
  function _glDisableVertexAttribArray(index) {
      Module.ctx.disableVertexAttribArray(index);
    }
  function _glUniform4f(location, v0, v1, v2, v3) {
      location = GL.uniforms[location];
      Module.ctx.uniform4f(location, v0, v1, v2, v3);
    }
  function _glVertexAttribPointer(index, size, type, normalized, stride, ptr) {
      Module.ctx.vertexAttribPointer(index, size, type, normalized, stride, ptr);
    }
  var _tanf=Math_tan;
  function ___cxa_rethrow() {
      ___cxa_end_catch.rethrown = true;
      throw HEAP32[((_llvm_eh_exception.buf)>>2)] + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }
  function _memchr(ptr, chr, num) {
      chr = unSign(chr);
      for (var i = 0; i < num; i++) {
        if (HEAP8[(ptr)] == chr) return ptr;
        ptr++;
      }
      return 0;
    }
  function _glCreateShader(shaderType) {
      var id = GL.getNewId(GL.shaders);
      GL.shaders[id] = Module.ctx.createShader(shaderType);
      return id;
    }
  function _glShaderSource(shader, count, string, length) {
      var source = GL.getSource(shader, count, string, length);
      Module.ctx.shaderSource(GL.shaders[shader], source);
    }
  function _glCompileShader(shader) {
      Module.ctx.compileShader(GL.shaders[shader]);
    }
  function _glGetShaderiv(shader, pname, p) {
      if (pname == 0x8B84) { // GL_INFO_LOG_LENGTH
        HEAP32[((p)>>2)]=Module.ctx.getShaderInfoLog(GL.shaders[shader]).length + 1;
      } else {
        HEAP32[((p)>>2)]=Module.ctx.getShaderParameter(GL.shaders[shader], pname);
      }
    }
  function _glDeleteShader(shader) {
      Module.ctx.deleteShader(GL.shaders[shader]);
      GL.shaders[shader] = null;
    }
  function _glCreateProgram() {
      var id = GL.getNewId(GL.programs);
      var program = Module.ctx.createProgram();
      program.name = id;
      GL.programs[id] = program;
      return id;
    }
  function _glAttachShader(program, shader) {
      Module.ctx.attachShader(GL.programs[program],
                              GL.shaders[shader]);
    }
  function _glLinkProgram(program) {
      Module.ctx.linkProgram(GL.programs[program]);
      GL.programInfos[program] = null; // uniforms no longer keep the same names after linking
      GL.populateUniformTable(program);
    }
  function _glGetProgramiv(program, pname, p) {
      if (pname == 0x8B84) { // GL_INFO_LOG_LENGTH
        HEAP32[((p)>>2)]=Module.ctx.getProgramInfoLog(GL.programs[program]).length + 1;
      } else if (pname == 0x8B87 /* GL_ACTIVE_UNIFORM_MAX_LENGTH */) {
        var ptable = GL.programInfos[program];
        if (ptable) {
          HEAP32[((p)>>2)]=ptable.maxUniformLength;
          return;
        } else if (program < GL.counter) {
          GL.recordError(0x0502 /* GL_INVALID_OPERATION */);
        } else {
          GL.recordError(0x0501 /* GL_INVALID_VALUE */);
        }
      } else if (pname == 0x8B8A /* GL_ACTIVE_ATTRIBUTE_MAX_LENGTH */) {
        var ptable = GL.programInfos[program];
        if (ptable) {
          if (ptable.maxAttributeLength == -1) {
            var program = GL.programs[program];
            var numAttribs = Module.ctx.getProgramParameter(program, Module.ctx.ACTIVE_ATTRIBUTES);
            ptable.maxAttributeLength = 0; // Spec says if there are no active attribs, 0 must be returned.
            for(var i = 0; i < numAttribs; ++i) {
              var activeAttrib = Module.ctx.getActiveAttrib(program, i);
              ptable.maxAttributeLength = Math.max(ptable.maxAttributeLength, activeAttrib.name.length+1);
            }
          }
          HEAP32[((p)>>2)]=ptable.maxAttributeLength;
          return;
        } else if (program < GL.counter) {
          GL.recordError(0x0502 /* GL_INVALID_OPERATION */);
        } else {
          GL.recordError(0x0501 /* GL_INVALID_VALUE */);
        }
      } else {
        HEAP32[((p)>>2)]=Module.ctx.getProgramParameter(GL.programs[program], pname);
      }
    }
  function _glDeleteProgram(program) {
      var program = GL.programs[program];
      Module.ctx.deleteProgram(program);
      program.name = 0;
      GL.programs[program] = null;
      GL.programInfos[program] = null;
    }
  function _glUseProgram(program) {
      Module.ctx.useProgram(program ? GL.programs[program] : null);
    }
  function _glGetUniformLocation(program, name) {
      name = Pointer_stringify(name);
      var arrayOffset = 0;
      // If user passed an array accessor "[index]", parse the array index off the accessor.
      if (name.indexOf(']', name.length-1) !== -1) {
        var ls = name.lastIndexOf('[');
        var arrayIndex = name.slice(ls+1, -1);
        if (arrayIndex.length > 0) {
          arrayOffset = parseInt(arrayIndex);
          if (arrayOffset < 0) {
            return -1;
          }
        }
        name = name.slice(0, ls);
      }
      var ptable = GL.programInfos[program];
      if (!ptable) {
        return -1;
      }
      var utable = ptable.uniforms;
      var uniformInfo = utable[name]; // returns pair [ dimension_of_uniform_array, uniform_location ]
      if (uniformInfo && arrayOffset < uniformInfo[0]) { // Check if user asked for an out-of-bounds element, i.e. for 'vec4 colors[3];' user could ask for 'colors[10]' which should return -1.
        return uniformInfo[1]+arrayOffset;
      } else {
        return -1;
      }
    }
  function _glGetAttribLocation(program, name) {
      program = GL.programs[program];
      name = Pointer_stringify(name);
      return Module.ctx.getAttribLocation(program, name);
    }
  function _atexit(func, arg) {
      __ATEXIT__.unshift({ func: func, arg: arg });
    }var ___cxa_atexit=_atexit;
  function _glGenTextures(n, textures) {
      for (var i = 0; i < n; i++) {
        var id = GL.getNewId(GL.textures);
        var texture = Module.ctx.createTexture();
        texture.name = id;
        GL.textures[id] = texture;
        HEAP32[(((textures)+(i*4))>>2)]=id;
      }
    }
  function _glTexParameteri(x0, x1, x2) { Module.ctx.texParameteri(x0, x1, x2) }
  function _glDeleteTextures(n, textures) {
      for (var i = 0; i < n; i++) {
        var id = HEAP32[(((textures)+(i*4))>>2)];
        var texture = GL.textures[id];
        Module.ctx.deleteTexture(texture);
        texture.name = 0;
        GL.textures[id] = null;
      }
    }
  function _glTexImage2D(target, level, internalFormat, width, height, border, format, type, pixels) {
      if (pixels) {
        var data = GL.getTexPixelData(type, format, width, height, pixels, internalFormat);
        pixels = data.pixels;
        internalFormat = data.internalFormat;
      } else {
        pixels = null;
      }
      Module.ctx.texImage2D(target, level, internalFormat, width, height, border, format, type, pixels);
    }
  function _glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels) {
      if (pixels) {
        var data = GL.getTexPixelData(type, format, width, height, pixels, -1);
        pixels = data.pixels;
      } else {
        pixels = null;
      }
      Module.ctx.texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
  function _glBindTexture(target, texture) {
      Module.ctx.bindTexture(target, texture ? GL.textures[texture] : null);
    }
  function _glGenBuffers(n, buffers) {
      for (var i = 0; i < n; i++) {
        var id = GL.getNewId(GL.buffers);
        var buffer = Module.ctx.createBuffer();
        buffer.name = id;
        GL.buffers[id] = buffer;
        HEAP32[(((buffers)+(i*4))>>2)]=id;
      }
    }
  function _glDeleteBuffers(n, buffers) {
      for (var i = 0; i < n; i++) {
        var id = HEAP32[(((buffers)+(i*4))>>2)];
        var buffer = GL.buffers[id];
        // From spec: "glDeleteBuffers silently ignores 0's and names that do not
        // correspond to existing buffer objects."
        if (!buffer) continue;
        Module.ctx.deleteBuffer(buffer);
        buffer.name = 0;
        GL.buffers[id] = null;
        if (id == GL.currArrayBuffer) GL.currArrayBuffer = 0;
        if (id == GL.currElementArrayBuffer) GL.currElementArrayBuffer = 0;
      }
    }
  function _glBindBuffer(target, buffer) {
      var bufferObj = buffer ? GL.buffers[buffer] : null;
      if (target == Module.ctx.ARRAY_BUFFER) {
        GL.currArrayBuffer = buffer;
      } else if (target == Module.ctx.ELEMENT_ARRAY_BUFFER) {
        GL.currElementArrayBuffer = buffer;
      }
      Module.ctx.bindBuffer(target, bufferObj);
    }
  function _glBufferData(target, size, data, usage) {
      switch (usage) { // fix usages, WebGL only has *_DRAW
        case 0x88E1: // GL_STREAM_READ
        case 0x88E2: // GL_STREAM_COPY
          usage = 0x88E0; // GL_STREAM_DRAW
          break;
        case 0x88E5: // GL_STATIC_READ
        case 0x88E6: // GL_STATIC_COPY
          usage = 0x88E4; // GL_STATIC_DRAW
          break;
        case 0x88E9: // GL_DYNAMIC_READ
        case 0x88EA: // GL_DYNAMIC_COPY
          usage = 0x88E8; // GL_DYNAMIC_DRAW
          break;
      }
      Module.ctx.bufferData(target, HEAPU8.subarray(data, data+size), usage);
    }
  function _glGenFramebuffers(n, ids) {
      for (var i = 0; i < n; ++i) {
        var id = GL.getNewId(GL.framebuffers);
        var framebuffer = Module.ctx.createFramebuffer();
        framebuffer.name = id;
        GL.framebuffers[id] = framebuffer;
        HEAP32[(((ids)+(i*4))>>2)]=id;
      }
    }
  function _glFramebufferTexture2D(target, attachment, textarget, texture, level) {
      Module.ctx.framebufferTexture2D(target, attachment, textarget,
                                      GL.textures[texture], level);
    }
  function _glCheckFramebufferStatus(x0) { return Module.ctx.checkFramebufferStatus(x0) }
  function _glDeleteFramebuffers(n, framebuffers) {
      for (var i = 0; i < n; ++i) {
        var id = HEAP32[(((framebuffers)+(i*4))>>2)];
        var framebuffer = GL.framebuffers[id];
        Module.ctx.deleteFramebuffer(framebuffer);
        framebuffer.name = 0;
        GL.framebuffers[id] = null;
      }
    }
  function _glGetIntegerv(name_, p) {
      switch(name_) { // Handle a few trivial GLES values
        case 0x8DFA: // GL_SHADER_COMPILER
          HEAP32[((p)>>2)]=1;
          return;
        case 0x8DF8: // GL_SHADER_BINARY_FORMATS
        case 0x8DF9: // GL_NUM_SHADER_BINARY_FORMATS
          HEAP32[((p)>>2)]=0;
          return;
        case 0x86A2: // GL_NUM_COMPRESSED_TEXTURE_FORMATS
          // WebGL doesn't have GL_NUM_COMPRESSED_TEXTURE_FORMATS (it's obsolete since GL_COMPRESSED_TEXTURE_FORMATS returns a JS array that can be queried for length),
          // so implement it ourselves to allow C++ GLES2 code get the length.
          var formats = Module.ctx.getParameter(0x86A3 /*GL_COMPRESSED_TEXTURE_FORMATS*/);
          HEAP32[((p)>>2)]=formats.length;
          return;
      }
      var result = Module.ctx.getParameter(name_);
      switch (typeof(result)) {
        case "number":
          HEAP32[((p)>>2)]=result;
          break;
        case "boolean":
          HEAP8[(p)]=result ? 1 : 0;
          break;
        case "string":
          GL.recordError(0x0500/*GL_INVALID_ENUM*/);
          return;
        case "object":
          if (result === null) {
            HEAP32[((p)>>2)]=0;
          } else if (result instanceof Float32Array ||
                     result instanceof Uint32Array ||
                     result instanceof Int32Array ||
                     result instanceof Array) {
            for (var i = 0; i < result.length; ++i) {
              HEAP32[(((p)+(i*4))>>2)]=result[i];
            }
          } else if (result instanceof WebGLBuffer) {
            HEAP32[((p)>>2)]=result.name | 0;
          } else if (result instanceof WebGLProgram) {
            HEAP32[((p)>>2)]=result.name | 0;
          } else if (result instanceof WebGLFramebuffer) {
            HEAP32[((p)>>2)]=result.name | 0;
          } else if (result instanceof WebGLRenderbuffer) {
            HEAP32[((p)>>2)]=result.name | 0;
          } else if (result instanceof WebGLTexture) {
            HEAP32[((p)>>2)]=result.name | 0;
          } else {
            GL.recordError(0x0500/*GL_INVALID_ENUM*/);
            return;
          }
          break;
        default:
          GL.recordError(0x0500/*GL_INVALID_ENUM*/);
          return;
      }
    }
  function _glBindFramebuffer(target, framebuffer) {
      Module.ctx.bindFramebuffer(target, framebuffer ? GL.framebuffers[framebuffer] : null);
    }
  var _atanf=Math_atan;
  var _atan2f=Math_atan2;
  var _powf=Math_pow;
  function _isalpha(chr) {
      return (chr >= 97 && chr <= 122) ||
             (chr >= 65 && chr <= 90);
    }
  function _isdigit(chr) {
      return chr >= 48 && chr <= 57;
    }
  function ___cxa_guard_acquire(variable) {
      if (!HEAP8[(variable)]) { // ignore SAFE_HEAP stuff because llvm mixes i64 and i8 here
        HEAP8[(variable)]=1;
        return 1;
      }
      return 0;
    }
  function ___cxa_guard_release() {}
  function _pthread_cond_broadcast() {
      return 0;
    }
  function _pthread_cond_wait() {
      return 0;
    }
  function _ungetc(c, stream) {
      // int ungetc(int c, FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/ungetc.html
      stream = FS.getStream(stream);
      if (!stream) {
        return -1;
      }
      if (c === -1) {
        // do nothing for EOF character
        return c;
      }
      c = unSign(c & 0xFF);
      stream.ungotten.push(c);
      stream.eof = false;
      return c;
    }
  function _fgetc(stream) {
      // int fgetc(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fgetc.html
      var streamObj = FS.getStream(stream);
      if (!streamObj) return -1;
      if (streamObj.eof || streamObj.error) return -1;
      var ret = _fread(_fgetc.ret, 1, 1, stream);
      if (ret == 0) {
        return -1;
      } else if (ret == -1) {
        streamObj.error = true;
        return -1;
      } else {
        return HEAPU8[((_fgetc.ret)|0)];
      }
    }var _getc=_fgetc;
  function ___errno_location() {
      return ___errno_state;
    }
  function _strerror_r(errnum, strerrbuf, buflen) {
      if (errnum in ERRNO_MESSAGES) {
        if (ERRNO_MESSAGES[errnum].length > buflen - 1) {
          return ___setErrNo(ERRNO_CODES.ERANGE);
        } else {
          var msg = ERRNO_MESSAGES[errnum];
          writeAsciiToMemory(msg, strerrbuf);
          return 0;
        }
      } else {
        return ___setErrNo(ERRNO_CODES.EINVAL);
      }
    }function _strerror(errnum) {
      if (!_strerror.buffer) _strerror.buffer = _malloc(256);
      _strerror_r(errnum, _strerror.buffer, 256);
      return _strerror.buffer;
    }
  function _abort() {
      Module['abort']();
    }
  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 30: return PAGE_SIZE;
        case 132:
        case 133:
        case 12:
        case 137:
        case 138:
        case 15:
        case 235:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 149:
        case 13:
        case 10:
        case 236:
        case 153:
        case 9:
        case 21:
        case 22:
        case 159:
        case 154:
        case 14:
        case 77:
        case 78:
        case 139:
        case 80:
        case 81:
        case 79:
        case 82:
        case 68:
        case 67:
        case 164:
        case 11:
        case 29:
        case 47:
        case 48:
        case 95:
        case 52:
        case 51:
        case 46:
          return 200809;
        case 27:
        case 246:
        case 127:
        case 128:
        case 23:
        case 24:
        case 160:
        case 161:
        case 181:
        case 182:
        case 242:
        case 183:
        case 184:
        case 243:
        case 244:
        case 245:
        case 165:
        case 178:
        case 179:
        case 49:
        case 50:
        case 168:
        case 169:
        case 175:
        case 170:
        case 171:
        case 172:
        case 97:
        case 76:
        case 32:
        case 173:
        case 35:
          return -1;
        case 176:
        case 177:
        case 7:
        case 155:
        case 8:
        case 157:
        case 125:
        case 126:
        case 92:
        case 93:
        case 129:
        case 130:
        case 131:
        case 94:
        case 91:
          return 1;
        case 74:
        case 60:
        case 69:
        case 70:
        case 4:
          return 1024;
        case 31:
        case 42:
        case 72:
          return 32;
        case 87:
        case 26:
        case 33:
          return 2147483647;
        case 34:
        case 1:
          return 47839;
        case 38:
        case 36:
          return 99;
        case 43:
        case 37:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 28: return 32768;
        case 44: return 32767;
        case 75: return 16384;
        case 39: return 1000;
        case 89: return 700;
        case 71: return 256;
        case 40: return 255;
        case 2: return 100;
        case 180: return 64;
        case 25: return 20;
        case 5: return 16;
        case 6: return 6;
        case 73: return 4;
        case 84: return 1;
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }
  function ___cxa_guard_abort() {}
  function _isxdigit(chr) {
      return (chr >= 48 && chr <= 57) ||
             (chr >= 97 && chr <= 102) ||
             (chr >= 65 && chr <= 70);
    }var _isxdigit_l=_isxdigit;
  var _isdigit_l=_isdigit;
  function _catopen() { throw 'TODO: ' + aborter }
  function _catgets() { throw 'TODO: ' + aborter }
  function _catclose() { throw 'TODO: ' + aborter }
  function _newlocale(mask, locale, base) {
      return _malloc(4);
    }
  function _freelocale(locale) {
      _free(locale);
    }
  function _isascii(chr) {
      return chr >= 0 && (chr & 0x80) == 0;
    }
  function ___ctype_b_loc() {
      // http://refspecs.freestandards.org/LSB_3.0.0/LSB-Core-generic/LSB-Core-generic/baselib---ctype-b-loc.html
      var me = ___ctype_b_loc;
      if (!me.ret) {
        var values = [
          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
          0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,8195,8194,8194,8194,8194,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,24577,49156,49156,49156,
          49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,49156,55304,55304,55304,55304,55304,55304,55304,55304,
          55304,55304,49156,49156,49156,49156,49156,49156,49156,54536,54536,54536,54536,54536,54536,50440,50440,50440,50440,50440,
          50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,50440,49156,49156,49156,49156,49156,
          49156,54792,54792,54792,54792,54792,54792,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,50696,
          50696,50696,50696,50696,50696,50696,50696,49156,49156,49156,49156,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
          0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        ];
        var i16size = 2;
        var arr = _malloc(values.length * i16size);
        for (var i = 0; i < values.length; i++) {
          HEAP16[(((arr)+(i * i16size))>>1)]=values[i]
        }
        me.ret = allocate([arr + 128 * i16size], 'i16*', ALLOC_NORMAL);
      }
      return me.ret;
    }
  function ___ctype_tolower_loc() {
      // http://refspecs.freestandards.org/LSB_3.1.1/LSB-Core-generic/LSB-Core-generic/libutil---ctype-tolower-loc.html
      var me = ___ctype_tolower_loc;
      if (!me.ret) {
        var values = [
          128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,
          158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,
          188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,
          218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,
          248,249,250,251,252,253,254,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
          33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,97,98,99,100,101,102,103,
          104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,91,92,93,94,95,96,97,98,99,100,101,102,103,
          104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,
          134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,
          164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,
          194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
          224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,
          254,255
        ];
        var i32size = 4;
        var arr = _malloc(values.length * i32size);
        for (var i = 0; i < values.length; i++) {
          HEAP32[(((arr)+(i * i32size))>>2)]=values[i]
        }
        me.ret = allocate([arr + 128 * i32size], 'i32*', ALLOC_NORMAL);
      }
      return me.ret;
    }
  function ___ctype_toupper_loc() {
      // http://refspecs.freestandards.org/LSB_3.1.1/LSB-Core-generic/LSB-Core-generic/libutil---ctype-toupper-loc.html
      var me = ___ctype_toupper_loc;
      if (!me.ret) {
        var values = [
          128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,
          158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,
          188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,
          218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,
          248,249,250,251,252,253,254,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
          33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
          73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,
          81,82,83,84,85,86,87,88,89,90,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,
          145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,
          175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,
          205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,
          235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
        ];
        var i32size = 4;
        var arr = _malloc(values.length * i32size);
        for (var i = 0; i < values.length; i++) {
          HEAP32[(((arr)+(i * i32size))>>2)]=values[i]
        }
        me.ret = allocate([arr + 128 * i32size], 'i32*', ALLOC_NORMAL);
      }
      return me.ret;
    }
  function __isLeapYear(year) {
        return year%4 === 0 && (year%100 !== 0 || year%400 === 0);
    }
  function __arraySum(array, index) {
      var sum = 0;
      for (var i = 0; i <= index; sum += array[i++]);
      return sum;
    }
  var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];
  var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date, days) {
      var newDate = new Date(date.getTime());
      while(days > 0) {
        var leap = __isLeapYear(newDate.getFullYear());
        var currentMonth = newDate.getMonth();
        var daysInCurrentMonth = (leap ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR)[currentMonth];
        if (days > daysInCurrentMonth-newDate.getDate()) {
          // we spill over to next month
          days -= (daysInCurrentMonth-newDate.getDate()+1);
          newDate.setDate(1);
          if (currentMonth < 11) {
            newDate.setMonth(currentMonth+1)
          } else {
            newDate.setMonth(0);
            newDate.setFullYear(newDate.getFullYear()+1);
          }
        } else {
          // we stay in current month 
          newDate.setDate(newDate.getDate()+days);
          return newDate;
        }
      }
      return newDate;
    }function _strftime(s, maxsize, format, tm) {
      // size_t strftime(char *restrict s, size_t maxsize, const char *restrict format, const struct tm *restrict timeptr);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/strftime.html
      var date = {
        tm_sec: HEAP32[((tm)>>2)],
        tm_min: HEAP32[(((tm)+(4))>>2)],
        tm_hour: HEAP32[(((tm)+(8))>>2)],
        tm_mday: HEAP32[(((tm)+(12))>>2)],
        tm_mon: HEAP32[(((tm)+(16))>>2)],
        tm_year: HEAP32[(((tm)+(20))>>2)],
        tm_wday: HEAP32[(((tm)+(24))>>2)],
        tm_yday: HEAP32[(((tm)+(28))>>2)],
        tm_isdst: HEAP32[(((tm)+(32))>>2)]
      };
      var pattern = Pointer_stringify(format);
      // expand format
      var EXPANSION_RULES_1 = {
        '%c': '%a %b %d %H:%M:%S %Y',     // Replaced by the locale's appropriate date and time representation - e.g., Mon Aug  3 14:02:01 2013
        '%D': '%m/%d/%y',                 // Equivalent to %m / %d / %y
        '%F': '%Y-%m-%d',                 // Equivalent to %Y - %m - %d
        '%h': '%b',                       // Equivalent to %b
        '%r': '%I:%M:%S %p',              // Replaced by the time in a.m. and p.m. notation
        '%R': '%H:%M',                    // Replaced by the time in 24-hour notation
        '%T': '%H:%M:%S',                 // Replaced by the time
        '%x': '%m/%d/%y',                 // Replaced by the locale's appropriate date representation
        '%X': '%H:%M:%S',                 // Replaced by the locale's appropriate date representation
      };
      for (var rule in EXPANSION_RULES_1) {
        pattern = pattern.replace(new RegExp(rule, 'g'), EXPANSION_RULES_1[rule]);
      }
      var WEEKDAYS = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
      var MONTHS = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
      function leadingSomething(value, digits, character) {
        var str = typeof value === 'number' ? value.toString() : (value || '');
        while (str.length < digits) {
          str = character[0]+str;
        }
        return str;
      };
      function leadingNulls(value, digits) {
        return leadingSomething(value, digits, '0');
      };
      function compareByDay(date1, date2) {
        function sgn(value) {
          return value < 0 ? -1 : (value > 0 ? 1 : 0);
        };
        var compare;
        if ((compare = sgn(date1.getFullYear()-date2.getFullYear())) === 0) {
          if ((compare = sgn(date1.getMonth()-date2.getMonth())) === 0) {
            compare = sgn(date1.getDate()-date2.getDate());
          }
        }
        return compare;
      };
      function getFirstWeekStartDate(janFourth) {
          switch (janFourth.getDay()) {
            case 0: // Sunday
              return new Date(janFourth.getFullYear()-1, 11, 29);
            case 1: // Monday
              return janFourth;
            case 2: // Tuesday
              return new Date(janFourth.getFullYear(), 0, 3);
            case 3: // Wednesday
              return new Date(janFourth.getFullYear(), 0, 2);
            case 4: // Thursday
              return new Date(janFourth.getFullYear(), 0, 1);
            case 5: // Friday
              return new Date(janFourth.getFullYear()-1, 11, 31);
            case 6: // Saturday
              return new Date(janFourth.getFullYear()-1, 11, 30);
          }
      };
      function getWeekBasedYear(date) {
          var thisDate = __addDays(new Date(date.tm_year+1900, 0, 1), date.tm_yday);
          var janFourthThisYear = new Date(thisDate.getFullYear(), 0, 4);
          var janFourthNextYear = new Date(thisDate.getFullYear()+1, 0, 4);
          var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
          var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);
          if (compareByDay(firstWeekStartThisYear, thisDate) <= 0) {
            // this date is after the start of the first week of this year
            if (compareByDay(firstWeekStartNextYear, thisDate) <= 0) {
              return thisDate.getFullYear()+1;
            } else {
              return thisDate.getFullYear();
            }
          } else { 
            return thisDate.getFullYear()-1;
          }
      };
      var EXPANSION_RULES_2 = {
        '%a': function(date) {
          return WEEKDAYS[date.tm_wday].substring(0,3);
        },
        '%A': function(date) {
          return WEEKDAYS[date.tm_wday];
        },
        '%b': function(date) {
          return MONTHS[date.tm_mon].substring(0,3);
        },
        '%B': function(date) {
          return MONTHS[date.tm_mon];
        },
        '%C': function(date) {
          var year = date.tm_year+1900;
          return leadingNulls(Math.floor(year/100),2);
        },
        '%d': function(date) {
          return leadingNulls(date.tm_mday, 2);
        },
        '%e': function(date) {
          return leadingSomething(date.tm_mday, 2, ' ');
        },
        '%g': function(date) {
          // %g, %G, and %V give values according to the ISO 8601:2000 standard week-based year. 
          // In this system, weeks begin on a Monday and week 1 of the year is the week that includes 
          // January 4th, which is also the week that includes the first Thursday of the year, and 
          // is also the first week that contains at least four days in the year. 
          // If the first Monday of January is the 2nd, 3rd, or 4th, the preceding days are part of 
          // the last week of the preceding year; thus, for Saturday 2nd January 1999, 
          // %G is replaced by 1998 and %V is replaced by 53. If December 29th, 30th, 
          // or 31st is a Monday, it and any following days are part of week 1 of the following year. 
          // Thus, for Tuesday 30th December 1997, %G is replaced by 1998 and %V is replaced by 01.
          return getWeekBasedYear(date).toString().substring(2);
        },
        '%G': function(date) {
          return getWeekBasedYear(date);
        },
        '%H': function(date) {
          return leadingNulls(date.tm_hour, 2);
        },
        '%I': function(date) {
          return leadingNulls(date.tm_hour < 13 ? date.tm_hour : date.tm_hour-12, 2);
        },
        '%j': function(date) {
          // Day of the year (001-366)
          return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, date.tm_mon-1), 3);
        },
        '%m': function(date) {
          return leadingNulls(date.tm_mon+1, 2);
        },
        '%M': function(date) {
          return leadingNulls(date.tm_min, 2);
        },
        '%n': function() {
          return '\n';
        },
        '%p': function(date) {
          if (date.tm_hour > 0 && date.tm_hour < 13) {
            return 'AM';
          } else {
            return 'PM';
          }
        },
        '%S': function(date) {
          return leadingNulls(date.tm_sec, 2);
        },
        '%t': function() {
          return '\t';
        },
        '%u': function(date) {
          var day = new Date(date.tm_year+1900, date.tm_mon+1, date.tm_mday, 0, 0, 0, 0);
          return day.getDay() || 7;
        },
        '%U': function(date) {
          // Replaced by the week number of the year as a decimal number [00,53]. 
          // The first Sunday of January is the first day of week 1; 
          // days in the new year before this are in week 0. [ tm_year, tm_wday, tm_yday]
          var janFirst = new Date(date.tm_year+1900, 0, 1);
          var firstSunday = janFirst.getDay() === 0 ? janFirst : __addDays(janFirst, 7-janFirst.getDay());
          var endDate = new Date(date.tm_year+1900, date.tm_mon, date.tm_mday);
          // is target date after the first Sunday?
          if (compareByDay(firstSunday, endDate) < 0) {
            // calculate difference in days between first Sunday and endDate
            var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth()-1)-31;
            var firstSundayUntilEndJanuary = 31-firstSunday.getDate();
            var days = firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();
            return leadingNulls(Math.ceil(days/7), 2);
          }
          return compareByDay(firstSunday, janFirst) === 0 ? '01': '00';
        },
        '%V': function(date) {
          // Replaced by the week number of the year (Monday as the first day of the week) 
          // as a decimal number [01,53]. If the week containing 1 January has four 
          // or more days in the new year, then it is considered week 1. 
          // Otherwise, it is the last week of the previous year, and the next week is week 1. 
          // Both January 4th and the first Thursday of January are always in week 1. [ tm_year, tm_wday, tm_yday]
          var janFourthThisYear = new Date(date.tm_year+1900, 0, 4);
          var janFourthNextYear = new Date(date.tm_year+1901, 0, 4);
          var firstWeekStartThisYear = getFirstWeekStartDate(janFourthThisYear);
          var firstWeekStartNextYear = getFirstWeekStartDate(janFourthNextYear);
          var endDate = __addDays(new Date(date.tm_year+1900, 0, 1), date.tm_yday);
          if (compareByDay(endDate, firstWeekStartThisYear) < 0) {
            // if given date is before this years first week, then it belongs to the 53rd week of last year
            return '53';
          } 
          if (compareByDay(firstWeekStartNextYear, endDate) <= 0) {
            // if given date is after next years first week, then it belongs to the 01th week of next year
            return '01';
          }
          // given date is in between CW 01..53 of this calendar year
          var daysDifference;
          if (firstWeekStartThisYear.getFullYear() < date.tm_year+1900) {
            // first CW of this year starts last year
            daysDifference = date.tm_yday+32-firstWeekStartThisYear.getDate()
          } else {
            // first CW of this year starts this year
            daysDifference = date.tm_yday+1-firstWeekStartThisYear.getDate();
          }
          return leadingNulls(Math.ceil(daysDifference/7), 2);
        },
        '%w': function(date) {
          var day = new Date(date.tm_year+1900, date.tm_mon+1, date.tm_mday, 0, 0, 0, 0);
          return day.getDay();
        },
        '%W': function(date) {
          // Replaced by the week number of the year as a decimal number [00,53]. 
          // The first Monday of January is the first day of week 1; 
          // days in the new year before this are in week 0. [ tm_year, tm_wday, tm_yday]
          var janFirst = new Date(date.tm_year, 0, 1);
          var firstMonday = janFirst.getDay() === 1 ? janFirst : __addDays(janFirst, janFirst.getDay() === 0 ? 1 : 7-janFirst.getDay()+1);
          var endDate = new Date(date.tm_year+1900, date.tm_mon, date.tm_mday);
          // is target date after the first Monday?
          if (compareByDay(firstMonday, endDate) < 0) {
            var februaryFirstUntilEndMonth = __arraySum(__isLeapYear(endDate.getFullYear()) ? __MONTH_DAYS_LEAP : __MONTH_DAYS_REGULAR, endDate.getMonth()-1)-31;
            var firstMondayUntilEndJanuary = 31-firstMonday.getDate();
            var days = firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();
            return leadingNulls(Math.ceil(days/7), 2);
          }
          return compareByDay(firstMonday, janFirst) === 0 ? '01': '00';
        },
        '%y': function(date) {
          // Replaced by the last two digits of the year as a decimal number [00,99]. [ tm_year]
          return (date.tm_year+1900).toString().substring(2);
        },
        '%Y': function(date) {
          // Replaced by the year as a decimal number (for example, 1997). [ tm_year]
          return date.tm_year+1900;
        },
        '%z': function(date) {
          // Replaced by the offset from UTC in the ISO 8601:2000 standard format ( +hhmm or -hhmm ),
          // or by no characters if no timezone is determinable. 
          // For example, "-0430" means 4 hours 30 minutes behind UTC (west of Greenwich). 
          // If tm_isdst is zero, the standard time offset is used. 
          // If tm_isdst is greater than zero, the daylight savings time offset is used. 
          // If tm_isdst is negative, no characters are returned. 
          // FIXME: we cannot determine time zone (or can we?)
          return '';
        },
        '%Z': function(date) {
          // Replaced by the timezone name or abbreviation, or by no bytes if no timezone information exists. [ tm_isdst]
          // FIXME: we cannot determine time zone (or can we?)
          return '';
        },
        '%%': function() {
          return '%';
        }
      };
      for (var rule in EXPANSION_RULES_2) {
        if (pattern.indexOf(rule) >= 0) {
          pattern = pattern.replace(new RegExp(rule, 'g'), EXPANSION_RULES_2[rule](date));
        }
      }
      var bytes = intArrayFromString(pattern, false);
      if (bytes.length > maxsize) {
        return 0;
      } 
      writeArrayToMemory(bytes, s);
      return bytes.length-1;
    }var _strftime_l=_strftime;
  function __parseInt64(str, endptr, base, min, max, unsign) {
      var isNegative = false;
      // Skip space.
      while (_isspace(HEAP8[(str)])) str++;
      // Check for a plus/minus sign.
      if (HEAP8[(str)] == 45) {
        str++;
        isNegative = true;
      } else if (HEAP8[(str)] == 43) {
        str++;
      }
      // Find base.
      var ok = false;
      var finalBase = base;
      if (!finalBase) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            finalBase = 16;
            str += 2;
          } else {
            finalBase = 8;
            ok = true; // we saw an initial zero, perhaps the entire thing is just "0"
          }
        }
      } else if (finalBase==16) {
        if (HEAP8[(str)] == 48) {
          if (HEAP8[((str+1)|0)] == 120 ||
              HEAP8[((str+1)|0)] == 88) {
            str += 2;
          }
        }
      }
      if (!finalBase) finalBase = 10;
      var start = str;
      // Get digits.
      var chr;
      while ((chr = HEAP8[(str)]) != 0) {
        var digit = parseInt(String.fromCharCode(chr), finalBase);
        if (isNaN(digit)) {
          break;
        } else {
          str++;
          ok = true;
        }
      }
      if (!ok) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return ((asm["setTempRet0"](0),0)|0);
      }
      // Set end pointer.
      if (endptr) {
        HEAP32[((endptr)>>2)]=str
      }
      try {
        var numberString = isNegative ? '-'+Pointer_stringify(start, str - start) : Pointer_stringify(start, str - start);
        i64Math.fromString(numberString, finalBase, min, max, unsign);
      } catch(e) {
        ___setErrNo(ERRNO_CODES.ERANGE); // not quite correct
      }
      return ((asm["setTempRet0"](((HEAP32[(((tempDoublePtr)+(4))>>2)])|0)),((HEAP32[((tempDoublePtr)>>2)])|0))|0);
    }function _strtoull(str, endptr, base) {
      return __parseInt64(str, endptr, base, 0, '18446744073709551615', true);  // ULONG_MAX.
    }var _strtoull_l=_strtoull;
  function _strtoll(str, endptr, base) {
      return __parseInt64(str, endptr, base, '-9223372036854775808', '9223372036854775807');  // LLONG_MIN, LLONG_MAX.
    }var _strtoll_l=_strtoll;
  function _uselocale(locale) {
      return 0;
    }
  function _llvm_va_end() {}
  function _vsnprintf(s, n, format, va_arg) {
      return _snprintf(s, n, format, HEAP32[((va_arg)>>2)]);
    }
  function _vsscanf(s, format, va_arg) {
      return _sscanf(s, format, HEAP32[((va_arg)>>2)]);
    }
  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) self.alloc(bytes);
      return ret;  // Previous break location.
    }
  function ___cxa_call_unexpected(exception) {
      Module.printErr('Unexpected exception thrown, this is not properly supported - aborting');
      ABORT = true;
      throw exception;
    }
FS.staticInit();__ATINIT__.unshift({ func: function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() } });__ATMAIN__.push({ func: function() { FS.ignorePermissions = false } });__ATEXIT__.push({ func: function() { FS.quit() } });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
___errno_state = Runtime.staticAlloc(4); HEAP32[((___errno_state)>>2)]=0;
__ATINIT__.unshift({ func: function() { TTY.init() } });__ATEXIT__.push({ func: function() { TTY.shutdown() } });TTY.utf8 = new Runtime.UTF8Processor();
if (ENVIRONMENT_IS_NODE) { var fs = require("fs"); NODEFS.staticInit(); }
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas) { Browser.requestFullScreen(lockPointer, resizeCanvas) };
  Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) { Browser.requestAnimationFrame(func) };
  Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) { Browser.setCanvasSize(width, height, noUpdates) };
  Module["pauseMainLoop"] = function Module_pauseMainLoop() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function Module_resumeMainLoop() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function Module_getUserMedia() { Browser.getUserMedia() }
_llvm_eh_exception.buf = allocate(12, "void*", ALLOC_STATIC);
__ATINIT__.push({ func: function() { SOCKFS.root = FS.mount(SOCKFS, {}, null); } });
GL.init()
_fgetc.ret = allocate([0], "i8", ALLOC_STATIC);
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);
staticSealed = true; // seal the static portion of memory
STACK_MAX = STACK_BASE + 5242880;
DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);
assert(DYNAMIC_BASE < TOTAL_MEMORY); // Stack must fit in TOTAL_MEMORY; allocations from here on may enlarge TOTAL_MEMORY
 var ctlz_i8 = allocate([8,7,6,6,5,5,5,5,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_DYNAMIC);
 var cttz_i8 = allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0], "i8", ALLOC_DYNAMIC);
var Math_min = Math.min;
function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fi(index,a1) {
  try {
    return Module["dynCall_fi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vif(index,a1,a2) {
  try {
    Module["dynCall_vif"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fff(index,a1,a2) {
  try {
    return Module["dynCall_fff"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiff(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiff"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiii(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiid(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiid"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    Module["dynCall_viiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_fiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ff(index,a1) {
  try {
    return Module["dynCall_ff"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiid(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    Module["dynCall_viiiiiid"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fii(index,a1,a2) {
  try {
    return Module["dynCall_fii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    return Module["dynCall_iiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viif(index,a1,a2,a3) {
  try {
    Module["dynCall_viif"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function asmPrintInt(x, y) {
  Module.print('int ' + x + ',' + y);// + ' ' + new Error().stack);
}
function asmPrintFloat(x, y) {
  Module.print('float ' + x + ',' + y);// + ' ' + new Error().stack);
}
// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer){"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.ctlz_i8|0;var o=env.__ZTVN10__cxxabiv117__class_type_infoE|0;var p=env._stderr|0;var q=env.___fsmu8|0;var r=env.__ZTVN10__cxxabiv120__si_class_type_infoE|0;var s=env._stdout|0;var t=env.__ZTVN10__cxxabiv119__pointer_type_infoE|0;var u=env.___dso_handle|0;var v=env._stdin|0;var w=+env.NaN;var x=+env.Infinity;var y=0;var z=0;var A=0;var B=0;var C=0,D=0,E=0,F=0,G=0.0,H=0,I=0,J=0,K=0.0;var L=0;var M=0;var N=0;var O=0;var P=0;var Q=0;var R=0;var S=0;var T=0;var U=0;var V=global.Math.floor;var W=global.Math.abs;var X=global.Math.sqrt;var Y=global.Math.pow;var Z=global.Math.cos;var _=global.Math.sin;var $=global.Math.tan;var aa=global.Math.acos;var ab=global.Math.asin;var ac=global.Math.atan;var ad=global.Math.atan2;var ae=global.Math.exp;var af=global.Math.log;var ag=global.Math.ceil;var ah=global.Math.imul;var ai=env.abort;var aj=env.assert;var ak=env.asmPrintInt;var al=env.asmPrintFloat;var am=env.min;var an=env.invoke_viiiii;var ao=env.invoke_fi;var ap=env.invoke_vif;var aq=env.invoke_vi;var ar=env.invoke_vii;var as=env.invoke_ii;var at=env.invoke_fff;var au=env.invoke_viiff;var av=env.invoke_iiiiii;var aw=env.invoke_iiii;var ax=env.invoke_viiiiid;var ay=env.invoke_viiiiiiii;var az=env.invoke_viiiiii;var aA=env.invoke_fiii;var aB=env.invoke_viiiiiii;var aC=env.invoke_ff;var aD=env.invoke_viiiiiid;var aE=env.invoke_viiiiiiiii;var aF=env.invoke_iii;var aG=env.invoke_fii;var aH=env.invoke_iiiii;var aI=env.invoke_viii;var aJ=env.invoke_v;var aK=env.invoke_iiiiiiiii;var aL=env.invoke_viif;var aM=env.invoke_viiii;var aN=env._llvm_lifetime_end;var aO=env._lseek;var aP=env._glClearColor;var aQ=env._sysconf;var aR=env.__scanString;var aS=env._Mix_OpenAudio;var aT=env._pthread_mutex_lock;var aU=env.___cxa_end_catch;var aV=env._glLinkProgram;var aW=env._strtoull;var aX=env._glBindTexture;var aY=env._fflush;var aZ=env._isxdigit;var a_=env._strtol;var a$=env._write;var a0=env._Mix_PlayChannel;var a1=env._fwrite;var a2=env._send;var a3=env._pthread_mutex_init;var a4=env._llvm_umul_with_overflow_i32;var a5=env._glCompileShader;var a6=env._isspace;var a7=env._Mix_Init;var a8=env._glDeleteTextures;var a9=env._read;var ba=env._fclose;var bb=env.___cxa_guard_abort;var bc=env._fsync;var bd=env._glGenTextures;var be=env._newlocale;var bf=env.___gxx_personality_v0;var bg=env._glDeleteShader;var bh=env._pthread_cond_wait;var bi=env.___cxa_rethrow;var bj=env._fmod;var bk=env.___resumeException;var bl=env._glCreateShader;var bm=env._strcmp;var bn=env._glUniform1i;var bo=env._strncmp;var bp=env._cosf;var bq=env._vsscanf;var br=env._glTexSubImage2D;var bs=env._snprintf;var bt=env._SDL_RWFromFile;var bu=env._glUniform2f;var bv=env._glGetProgramiv;var bw=env._glColorMask;var bx=env.__getFloat;var by=env._atexit;var bz=env._mknod;var bA=env._glGetIntegerv;var bB=env.___cxa_free_exception;var bC=env._glGetUniformLocation;var bD=env._close;var bE=env._glBindFramebuffer;var bF=env._strchr;var bG=env._catclose;var bH=env._Mix_LoadWAV_RW;var bI=env.___setErrNo;var bJ=env._glDeleteFramebuffers;var bK=env._glDrawArrays;var bL=env._ftell;var bM=env._glDeleteProgram;var bN=env._exit;var bO=env._sprintf;var bP=env.___ctype_b_loc;var bQ=env._freelocale;var bR=env._glAttachShader;var bS=env._atan2f;var bT=env._catgets;var bU=env._glCheckFramebufferStatus;var bV=env.__isLeapYear;var bW=env._asprintf;var bX=env.___cxa_is_number_type;var bY=env.___cxa_does_inherit;var bZ=env.___ctype_toupper_loc;var b_=env.___cxa_guard_acquire;var b$=env.___cxa_begin_catch;var b0=env._sinf;var b1=env._recv;var b2=env.__parseInt64;var b3=env.__ZSt18uncaught_exceptionv;var b4=env._SDL_GL_SwapBuffers;var b5=env.___cxa_call_unexpected;var b6=env._SDL_Init;var b7=env._SDL_RWFromConstMem;var b8=env._memchr;var b9=env._glGetShaderiv;var ca=env.__exit;var cb=env._SDL_FreeRW;var cc=env._strftime;var cd=env._rand;var ce=env._fabsf;var cf=env._glEnableVertexAttribArray;var cg=env._qsort;var ch=env.___cxa_throw;var ci=env._glUseProgram;var cj=env._ldexp;var ck=env._llvm_eh_exception;var cl=env._glShaderSource;var cm=env._pread;var cn=env._SDL_SetVideoMode;var co=env._fopen;var cp=env._open;var cq=env._sqrtf;var cr=env._SDL_GL_SetAttribute;var cs=env.__arraySum;var ct=env._log;var cu=env._SDL_PollEvent;var cv=env._glClear;var cw=env._mkdir;var cx=env._fgetc;var cy=env._isalpha;var cz=env._Mix_HaltMusic;var cA=env._glUniform3fv;var cB=env.___cxa_find_matching_catch;var cC=env._strdup;var cD=env._glUniform4f;var cE=env._glFramebufferTexture2D;var cF=env._fread;var cG=env._glBindBuffer;var cH=env._glBufferData;var cI=env.__formatString;var cJ=env._cos;var cK=env.__ZSt9terminatev;var cL=env._gettimeofday;var cM=env._atoi;var cN=env._isascii;var cO=env._pthread_mutex_unlock;var cP=env._glVertexAttribPointer;var cQ=env._glGenFramebuffers;var cR=env._llvm_pow_f64;var cS=env._sbrk;var cT=env._tanf;var cU=env.___errno_location;var cV=env._strerror;var cW=env._pthread_mutex_destroy;var cX=env._glPixelStorei;var cY=env._llvm_lifetime_start;var cZ=env.__parseInt;var c_=env.___cxa_guard_release;var c$=env._ungetc;var c0=env._uselocale;var c1=env._vsnprintf;var c2=env._glDisableVertexAttribArray;var c3=env._sscanf;var c4=env._glTexImage2D;var c5=env.___assert_fail;var c6=env._srand;var c7=env._strtok_r;var c8=env._abort;var c9=env._isdigit;var da=env._strtoll;var db=env.__addDays;var dc=env._glDisable;var dd=env._glEnable;var de=env._atanf;var df=env._floor;var dg=env.__reallyNegative;var dh=env._fseek;var di=env._emscripten_asm_const_int;var dj=env._glGenBuffers;var dk=env._glGetAttribLocation;var dl=env.___cxa_allocate_exception;var dm=env._sin;var dn=env._glBlendFunc;var dp=env._glCreateProgram;var dq=env._glCullFace;var dr=env._stat;var ds=env.___cxa_pure_virtual;var dt=env._exp;var du=env._vasprintf;var dv=env._glViewport;var dw=env._emscripten_set_main_loop;var dx=env._catopen;var dy=env._Mix_LoadMUS;var dz=env._pthread_cond_broadcast;var dA=env.___ctype_tolower_loc;var dB=env._llvm_va_end;var dC=env._glUniformMatrix4fv;var dD=env._pwrite;var dE=env._strerror_r;var dF=env._glTexParameteri;var dG=env._glDeleteBuffers;var dH=env._Mix_PlayMusic;var dI=env._SDL_FreeSurface;var dJ=env._time;var dK=env._powf;var dL=0.0;
// EMSCRIPTEN_START_FUNCS
function oP(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0;f=i;i=i+56|0;g=f|0;h=f+16|0;j=f+40|0;k=i;i=i+12|0;i=i+7&-8;l=i;i=i+12|0;i=i+7&-8;m=i;i=i+20|0;i=i+7&-8;n=i;i=i+12|0;i=i+7&-8;o=i;i=i+12|0;i=i+7&-8;p=i;i=i+12|0;i=i+7&-8;q=i;i=i+20|0;i=i+7&-8;r=i;i=i+12|0;i=i+7&-8;s=i;i=i+12|0;i=i+7&-8;t=i;i=i+104|0;u=i;i=i+12|0;i=i+7&-8;v=i;i=i+12|0;i=i+7&-8;w=i;i=i+12|0;i=i+7&-8;x=i;i=i+12|0;i=i+7&-8;y=i;i=i+20|0;i=i+7&-8;z=i;i=i+12|0;i=i+7&-8;A=z;z=i;i=i+12|0;i=i+7&-8;B=i;i=i+104|0;C=i;i=i+12|0;i=i+7&-8;D=i;i=i+104|0;E=i;i=i+20|0;i=i+7&-8;F=i;i=i+12|0;i=i+7&-8;G=i;i=i+104|0;H=i;i=i+12|0;i=i+7&-8;I=i;i=i+104|0;J=i;i=i+12|0;i=i+7&-8;K=i;i=i+20|0;i=i+7&-8;L=i;i=i+12|0;i=i+7&-8;M=i;i=i+20|0;i=i+7&-8;N=i;i=i+12|0;i=i+7&-8;O=N;N=i;i=i+12|0;i=i+7&-8;P=e+8|0;if((c[P>>2]|0)==0){nT(b);i=f;return}oM(g,d,e);Q=g+8|0;R=c[Q>>2]|0;L3678:do{if((R|0)==0){do{if((a[d+12|0]&1)==0){xc(j|0,0,12);c[h>>2]=5;S=h+4|0;T=S;c[T>>2]=c[j>>2];c[T+4>>2]=c[j+4>>2];c[T+8>>2]=c[j+8>>2];c[h+16>>2]=-1;T=w0(16)|0;U=k+8|0;c[U>>2]=T;c[k>>2]=17;c[k+4>>2]=14;xa(T|0,5744,14)|0;a[T+14|0]=0;oJ(d,h,k);if((a[k]&1)!=0){w2(c[U>>2]|0)}if((a[S]&1)==0){break}w2(c[h+12>>2]|0)}}while(0);nL(b,0.0)}else{if((c[P>>2]|0)==0){S=g+4|0;U=c[S>>2]|0;T=c[U+8>>2]|0;if((R|0)==1){if((T|0)==0){V=U+12|0;if((a[V]&1)==0){W=l;c[W>>2]=c[V>>2];c[W+4>>2]=c[V+4>>2];c[W+8>>2]=c[V+8>>2]}else{V=c[U+20>>2]|0;W=c[U+16>>2]|0;if(W>>>0>4294967279>>>0){pH(0)}if(W>>>0<11>>>0){a[l]=W<<1&255;X=l+1|0}else{Y=W+16&-16;Z=w0(Y)|0;c[l+8>>2]=Z;c[l>>2]=Y|1;c[l+4>>2]=W;X=Z}xa(X|0,V|0,W)|0;a[X+W|0]=0}nP(b,l);if((a[l]&1)==0){break}w2(c[l+8>>2]|0);break}else if((T|0)==1){W=U+12|0;if((a[W]&1)==0){_=W+1|0}else{_=c[U+20>>2]|0}nL(b,+w8(_,0));break}else{c[m>>2]=T;W=m+4|0;V=U+12|0;if((a[V]&1)==0){Z=W;c[Z>>2]=c[V>>2];c[Z+4>>2]=c[V+4>>2];c[Z+8>>2]=c[V+8>>2]}else{V=c[U+20>>2]|0;Z=c[U+16>>2]|0;if(Z>>>0>4294967279>>>0){pH(0)}if(Z>>>0<11>>>0){a[W]=Z<<1&255;$=W+1|0}else{Y=Z+16&-16;aa=w0(Y)|0;c[m+12>>2]=aa;c[W>>2]=Y|1;c[m+8>>2]=Z;$=aa}xa($|0,V|0,Z)|0;a[$+Z|0]=0}c[m+16>>2]=c[U+24>>2];Z=w0(16)|0;V=n+8|0;c[V>>2]=Z;c[n>>2]=17;c[n+4>>2]=13;xa(Z|0,5640,13)|0;a[Z+13|0]=0;oJ(d,m,n);if((a[n]&1)!=0){w2(c[V>>2]|0)}if((a[W]&1)!=0){w2(c[m+12>>2]|0)}nL(b,0.0);break}}do{if((T|0)==0){W=U+4|0;V=c[W>>2]|0;if((c[V+8>>2]|0)!=3){break}Z=U+12|0;if((a[Z]&1)==0){aa=o;c[aa>>2]=c[Z>>2];c[aa+4>>2]=c[Z+4>>2];c[aa+8>>2]=c[Z+8>>2];ab=V}else{V=c[U+20>>2]|0;aa=c[U+16>>2]|0;if(aa>>>0>4294967279>>>0){pH(0)}if(aa>>>0<11>>>0){a[o]=aa<<1&255;ac=o+1|0}else{Y=aa+16&-16;ad=w0(Y)|0;c[o+8>>2]=ad;c[o>>2]=Y|1;c[o+4>>2]=aa;ac=ad}xa(ac|0,V|0,aa)|0;a[ac+aa|0]=0;ab=c[W>>2]|0}aa=U|0;c[(c[aa>>2]|0)+4>>2]=ab;c[c[W>>2]>>2]=c[aa>>2];c[Q>>2]=(c[Q>>2]|0)-1;if((a[Z]&1)!=0){w2(c[U+20>>2]|0)}w2(U);oM(p,d,g);do{if((c[Q>>2]|0)==0){Z=o;if((a[Z]&1)==0){aa=s;c[aa>>2]=c[Z>>2];c[aa+4>>2]=c[Z+4>>2];c[aa+8>>2]=c[Z+8>>2]}else{Z=c[o+8>>2]|0;aa=c[o+4>>2]|0;if(aa>>>0>4294967279>>>0){pH(0)}if(aa>>>0<11>>>0){a[s]=aa<<1&255;ae=s+1|0}else{W=aa+16&-16;V=w0(W)|0;c[s+8>>2]=V;c[s>>2]=W|1;c[s+4>>2]=aa;ae=V}xa(ae|0,Z|0,aa)|0;a[ae+aa|0]=0}aa=u|0;Z=u;c[aa>>2]=Z;V=u+4|0;c[V>>2]=Z;W=u+8|0;c[W>>2]=0;ad=p;Y=c[p+4>>2]|0;if((Y|0)!=(ad|0)){af=Y;do{oN(u,af+8|0);af=c[af+4>>2]|0;}while((af|0)!=(ad|0))}oP(t,d,u);nS(b,s,t);nU(t);do{if((c[W>>2]|0)!=0){ad=c[V>>2]|0;af=(c[aa>>2]|0)+4|0;Y=ad|0;c[(c[Y>>2]|0)+4>>2]=c[af>>2];c[c[af>>2]>>2]=c[Y>>2];c[W>>2]=0;if((ad|0)==(Z|0)){break}else{ag=ad}while(1){ad=c[ag+4>>2]|0;if((a[ag+12|0]&1)!=0){w2(c[ag+20>>2]|0)}w2(ag);if((ad|0)==(Z|0)){break}else{ag=ad}}}}while(0);if((a[s]&1)==0){break}w2(c[s+8>>2]|0)}else{Z=c[S>>2]|0;c[q>>2]=c[Z+8>>2];W=q+4|0;aa=Z+12|0;if((a[aa]&1)==0){V=W;c[V>>2]=c[aa>>2];c[V+4>>2]=c[aa+4>>2];c[V+8>>2]=c[aa+8>>2]}else{aa=c[Z+20>>2]|0;V=c[Z+16>>2]|0;if(V>>>0>4294967279>>>0){pH(0)}if(V>>>0<11>>>0){a[W]=V<<1&255;ah=W+1|0}else{ad=V+16&-16;Y=w0(ad)|0;c[q+12>>2]=Y;c[W>>2]=ad|1;c[q+8>>2]=V;ah=Y}xa(ah|0,aa|0,V)|0;a[ah+V|0]=0}c[q+16>>2]=c[Z+24>>2];Z=w0(32)|0;V=r+8|0;c[V>>2]=Z;c[r>>2]=33;c[r+4>>2]=16;xa(Z|0,5536,16)|0;a[Z+16|0]=0;oJ(d,q,r);if((a[r]&1)!=0){w2(c[V>>2]|0)}if((a[W]&1)!=0){w2(c[q+12>>2]|0)}nL(b,0.0)}}while(0);W=p+8|0;do{if((c[W>>2]|0)!=0){V=c[p+4>>2]|0;Z=p;aa=(c[p>>2]|0)+4|0;Y=V|0;c[(c[Y>>2]|0)+4>>2]=c[aa>>2];c[c[aa>>2]>>2]=c[Y>>2];c[W>>2]=0;if((V|0)==(Z|0)){break}else{ai=V}while(1){V=c[ai+4>>2]|0;if((a[ai+12|0]&1)!=0){w2(c[ai+20>>2]|0)}w2(ai);if((V|0)==(Z|0)){break}else{ai=V}}}}while(0);if((a[o]&1)==0){break L3678}w2(c[o+8>>2]|0);break L3678}}while(0);S=v|0;T=v;c[S>>2]=T;W=v+4|0;c[W>>2]=T;Z=v+8|0;c[Z>>2]=0;V=g;if((U|0)!=(V|0)){Y=U;do{oN(v,Y+8|0);Y=c[Y+4>>2]|0;}while((Y|0)!=(V|0))}oP(b,d,v);if((c[Z>>2]|0)==0){break}V=c[W>>2]|0;Y=(c[S>>2]|0)+4|0;U=V|0;c[(c[U>>2]|0)+4>>2]=c[Y>>2];c[c[Y>>2]>>2]=c[U>>2];c[Z>>2]=0;if((V|0)==(T|0)){break}else{aj=V}while(1){V=c[aj+4>>2]|0;if((a[aj+12|0]&1)!=0){w2(c[aj+20>>2]|0)}w2(aj);if((V|0)==(T|0)){break L3678}else{aj=V}}}T=w|0;Z=w;c[T>>2]=Z;S=w+4|0;c[S>>2]=Z;W=w+8|0;c[W>>2]=0;V=w0(20)|0;U=V;Y=V+8|0;do{if((Y|0)==0){ak=Z}else{aa=Y;ad=Y;c[Y>>2]=ad;c[V+12>>2]=ad;c[V+16>>2]=0;ad=g;af=c[g+4>>2]|0;if((af|0)==(ad|0)){ak=Z;break}else{al=af}do{oN(aa,al+8|0);al=c[al+4>>2]|0;}while((al|0)!=(ad|0));ak=c[T>>2]|0}}while(0);c[ak+4>>2]=U;c[V>>2]=c[T>>2];c[T>>2]=U;c[V+4>>2]=Z;c[W>>2]=(c[W>>2]|0)+1;Y=x+8|0;ad=x+4|0;aa=x;af=x|0;while(1){if((c[P>>2]|0)==0){am=3510;break}oM(x,d,e);an=w0(20)|0;ao=an;ap=an+8|0;do{if((ap|0)!=0){aq=ap;ar=ap;c[aq>>2]=ar;c[an+12>>2]=ar;as=an+16|0;c[as>>2]=0;if((c[Y>>2]|0)==0){break}at=c[ad>>2]|0;au=c[af>>2]|0;av=au+4|0;aw=at|0;c[(c[aw>>2]|0)+4>>2]=c[av>>2];c[c[av>>2]>>2]=c[aw>>2];c[(c[aq>>2]|0)+4>>2]=at;c[aw>>2]=c[aq>>2];c[aq>>2]=au;c[av>>2]=ar;c[as>>2]=(c[as>>2]|0)+(c[Y>>2]|0);c[Y>>2]=0}}while(0);c[(c[T>>2]|0)+4>>2]=ao;c[an>>2]=c[T>>2];c[T>>2]=ao;c[an+4>>2]=Z;c[W>>2]=(c[W>>2]|0)+1;do{if((c[Y>>2]|0)!=0){ap=c[ad>>2]|0;as=(c[af>>2]|0)+4|0;ar=ap|0;c[(c[ar>>2]|0)+4>>2]=c[as>>2];c[c[as>>2]>>2]=c[ar>>2];c[Y>>2]=0;if((ap|0)==(aa|0)){break}else{ax=ap}while(1){ap=c[ax+4>>2]|0;if((a[ax+12|0]&1)!=0){w2(c[ax+20>>2]|0)}w2(ax);if((ap|0)==(aa|0)){break}else{ax=ap}}}}while(0);if((c[(c[T>>2]|0)+16>>2]|0)==0){am=3488;break}}L3851:do{if((am|0)==3488){do{if((a[d+12|0]&1)==0){xc(A|0,0,12);c[y>>2]=5;aa=y+4|0;Y=aa;c[Y>>2]=c[A>>2];c[Y+4>>2]=c[A+4>>2];c[Y+8>>2]=c[A+8>>2];c[y+16>>2]=-1;Y=w0(16)|0;af=z+8|0;c[af>>2]=Y;c[z>>2]=17;c[z+4>>2]=14;xa(Y|0,5744,14)|0;a[Y+14|0]=0;oJ(d,y,z);if((a[z]&1)!=0){w2(c[af>>2]|0)}if((a[aa]&1)==0){break}w2(c[y+12>>2]|0)}}while(0);nL(b,0.0)}else if((am|0)==3510){aa=c[W>>2]|0;do{if((aa|0)==2){af=c[S>>2]|0;Y=af+16|0;if((c[Y>>2]|0)!=1){break}ad=af+12|0;V=c[ad>>2]|0;if((c[V+8>>2]|0)!=2){am=3547;break}U=V+12|0;if((a[U]&1)==0){ay=U+1|0}else{ay=c[V+20>>2]|0}if((a[ay]|0)!=45){am=3547;break}V=af+4|0;U=af|0;c[(c[U>>2]|0)+4>>2]=c[V>>2];c[c[V>>2]>>2]=c[U>>2];c[W>>2]=(c[W>>2]|0)-1;U=af+8|0;do{if((c[Y>>2]|0)!=0){V=c[ad>>2]|0;an=U;ao=(c[U>>2]|0)+4|0;ap=V|0;c[(c[ap>>2]|0)+4>>2]=c[ao>>2];c[c[ao>>2]>>2]=c[ap>>2];c[Y>>2]=0;if((V|0)==(an|0)){break}else{az=V}while(1){V=c[az+4>>2]|0;if((a[az+12|0]&1)!=0){w2(c[az+20>>2]|0)}w2(az);if((V|0)==(an|0)){break}else{az=V}}}}while(0);w2(af);Y=c[S>>2]|0;U=C|0;ad=C;c[U>>2]=ad;an=C+4|0;c[an>>2]=ad;V=C+8|0;c[V>>2]=0;ap=Y+8|0;ao=c[Y+12>>2]|0;if((ao|0)!=(ap|0)){Y=ao;do{oN(C,Y+8|0);Y=c[Y+4>>2]|0;}while((Y|0)!=(ap|0))}oP(B,d,C);nT(D);nQ(b,12,B,D);nU(D);nU(B);if((c[V>>2]|0)==0){break L3851}ap=c[an>>2]|0;Y=(c[U>>2]|0)+4|0;af=ap|0;c[(c[af>>2]|0)+4>>2]=c[Y>>2];c[c[Y>>2]>>2]=c[af>>2];c[V>>2]=0;if((ap|0)==(ad|0)){break L3851}else{aA=ap}while(1){ap=c[aA+4>>2]|0;if((a[aA+12|0]&1)!=0){w2(c[aA+20>>2]|0)}w2(aA);if((ap|0)==(ad|0)){break L3851}else{aA=ap}}}else{am=3547}}while(0);do{if((am|0)==3547){if((aa&1|0)==0){break}L3897:do{if(aa>>>0>3>>>0){ad=d+12|0;while(1){oO(d,w);if((a[ad]&1)!=0){break}if((c[W>>2]|0)>>>0<=3>>>0){break L3897}}nL(b,0.0);break L3851}}while(0);ad=c[S>>2]|0;V=H|0;U=H;c[V>>2]=U;an=H+4|0;c[an>>2]=U;ap=H+8|0;c[ap>>2]=0;af=ad+8|0;Y=c[ad+12>>2]|0;if((Y|0)!=(af|0)){ad=Y;do{oN(H,ad+8|0);ad=c[ad+4>>2]|0;}while((ad|0)!=(af|0))}oP(G,d,H);do{if((c[ap>>2]|0)!=0){af=c[an>>2]|0;ad=(c[V>>2]|0)+4|0;Y=af|0;c[(c[Y>>2]|0)+4>>2]=c[ad>>2];c[c[ad>>2]>>2]=c[Y>>2];c[ap>>2]=0;if((af|0)==(U|0)){break}else{aB=af}while(1){af=c[aB+4>>2]|0;if((a[aB+12|0]&1)!=0){w2(c[aB+20>>2]|0)}w2(aB);if((af|0)==(U|0)){break}else{aB=af}}}}while(0);U=c[T>>2]|0;ap=J|0;V=J;c[ap>>2]=V;an=J+4|0;c[an>>2]=V;af=J+8|0;c[af>>2]=0;Y=U+8|0;ad=c[U+12>>2]|0;if((ad|0)!=(Y|0)){U=ad;do{oN(J,U+8|0);U=c[U+4>>2]|0;}while((U|0)!=(Y|0))}oP(I,d,J);do{if((c[af>>2]|0)!=0){Y=c[an>>2]|0;U=(c[ap>>2]|0)+4|0;ad=Y|0;c[(c[ad>>2]|0)+4>>2]=c[U>>2];c[c[U>>2]>>2]=c[ad>>2];c[af>>2]=0;if((Y|0)==(V|0)){break}else{aC=Y}while(1){Y=c[aC+4>>2]|0;if((a[aC+12|0]&1)!=0){w2(c[aC+20>>2]|0)}w2(aC);if((Y|0)==(V|0)){break}else{aC=Y}}}}while(0);V=c[S>>2]|0;af=V+4|0;ap=V|0;c[(c[ap>>2]|0)+4>>2]=c[af>>2];c[c[af>>2]>>2]=c[ap>>2];c[W>>2]=(c[W>>2]|0)-1;ap=V+8|0;af=V+16|0;do{if((c[af>>2]|0)!=0){an=c[V+12>>2]|0;Y=ap;ad=(c[ap>>2]|0)+4|0;U=an|0;c[(c[U>>2]|0)+4>>2]=c[ad>>2];c[c[ad>>2]>>2]=c[U>>2];c[af>>2]=0;if((an|0)==(Y|0)){break}else{aD=an}while(1){an=c[aD+4>>2]|0;if((a[aD+12|0]&1)!=0){w2(c[aD+20>>2]|0)}w2(aD);if((an|0)==(Y|0)){break}else{aD=an}}}}while(0);w2(V);af=c[S>>2]|0;ap=c[af+12>>2]|0;Y=c[ap+8>>2]|0;L3941:do{if((c[af+16>>2]|0)==1&(Y|0)==2){an=ap+12|0;if((a[an]&1)==0){aE=an+1|0}else{aE=c[ap+20>>2]|0}switch(a[aE]|0){case 43:{nQ(b,6,G,I);break L3941;break};case 45:{nQ(b,7,G,I);break L3941;break};case 42:{nQ(b,8,G,I);break L3941;break};case 47:{nQ(b,9,G,I);break L3941;break};case 37:{nQ(b,10,G,I);break L3941;break};case 44:{nQ(b,11,G,I);break L3941;break};default:{xc(O|0,0,12);c[M>>2]=5;an=M+4|0;U=an;c[U>>2]=c[O>>2];c[U+4>>2]=c[O+4>>2];c[U+8>>2]=c[O+8>>2];c[M+16>>2]=-1;U=w0(32)|0;ad=N+8|0;c[ad>>2]=U;c[N>>2]=33;c[N+4>>2]=16;xa(U|0,5416,16)|0;a[U+16|0]=0;oJ(d,M,N);if((a[N]&1)!=0){w2(c[ad>>2]|0)}if((a[an]&1)!=0){w2(c[M+12>>2]|0)}nL(b,0.0);break L3941}}}else{c[K>>2]=Y;an=K+4|0;ad=ap+12|0;if((a[ad]&1)==0){U=an;c[U>>2]=c[ad>>2];c[U+4>>2]=c[ad+4>>2];c[U+8>>2]=c[ad+8>>2]}else{ad=c[ap+20>>2]|0;U=c[ap+16>>2]|0;if(U>>>0>4294967279>>>0){pH(0)}if(U>>>0<11>>>0){a[an]=U<<1&255;aF=an+1|0}else{ao=U+16&-16;ar=w0(ao)|0;c[K+12>>2]=ar;c[an>>2]=ao|1;c[K+8>>2]=U;aF=ar}xa(aF|0,ad|0,U)|0;a[aF+U|0]=0}c[K+16>>2]=c[ap+24>>2];U=w0(16)|0;ad=L+8|0;c[ad>>2]=U;c[L>>2]=17;c[L+4>>2]=15;xa(U|0,6024,15)|0;a[U+15|0]=0;oJ(d,K,L);if((a[L]&1)!=0){w2(c[ad>>2]|0)}if((a[an]&1)!=0){w2(c[K+12>>2]|0)}nL(b,0.0)}}while(0);nU(I);nU(G);break L3851}}while(0);aa=c[(c[S>>2]|0)+12>>2]|0;c[E>>2]=c[aa+8>>2];ap=E+4|0;Y=aa+12|0;if((a[Y]&1)==0){af=ap;c[af>>2]=c[Y>>2];c[af+4>>2]=c[Y+4>>2];c[af+8>>2]=c[Y+8>>2]}else{Y=c[aa+20>>2]|0;af=c[aa+16>>2]|0;if(af>>>0>4294967279>>>0){pH(0)}if(af>>>0<11>>>0){a[ap]=af<<1&255;aG=ap+1|0}else{V=af+16&-16;an=w0(V)|0;c[E+12>>2]=an;c[ap>>2]=V|1;c[E+8>>2]=af;aG=an}xa(aG|0,Y|0,af)|0;a[aG+af|0]=0}c[E+16>>2]=c[aa+24>>2];aa=w0(16)|0;af=F+8|0;c[af>>2]=aa;c[F>>2]=17;c[F+4>>2]=12;xa(aa|0,5896,12)|0;a[aa+12|0]=0;oJ(d,E,F);if((a[F]&1)!=0){w2(c[af>>2]|0)}if((a[ap]&1)!=0){w2(c[E+12>>2]|0)}nL(b,0.0)}}while(0);if((c[W>>2]|0)==0){break}ap=c[S>>2]|0;af=(c[T>>2]|0)+4|0;aa=ap|0;c[(c[aa>>2]|0)+4>>2]=c[af>>2];c[c[af>>2]>>2]=c[aa>>2];c[W>>2]=0;if((ap|0)==(Z|0)){break}else{aH=ap}while(1){ap=c[aH+4>>2]|0;aa=aH+8|0;af=aH+16|0;do{if((c[af>>2]|0)!=0){Y=c[aH+12>>2]|0;an=aa;V=(c[aa>>2]|0)+4|0;ad=Y|0;c[(c[ad>>2]|0)+4>>2]=c[V>>2];c[c[V>>2]>>2]=c[ad>>2];c[af>>2]=0;if((Y|0)==(an|0)){break}else{aI=Y}while(1){Y=c[aI+4>>2]|0;if((a[aI+12|0]&1)!=0){w2(c[aI+20>>2]|0)}w2(aI);if((Y|0)==(an|0)){break}else{aI=Y}}}}while(0);w2(aH);if((ap|0)==(Z|0)){break}else{aH=ap}}}}while(0);if((c[Q>>2]|0)==0){i=f;return}aH=c[g+4>>2]|0;aI=g;b=(c[g>>2]|0)+4|0;g=aH|0;c[(c[g>>2]|0)+4>>2]=c[b>>2];c[c[b>>2]>>2]=c[g>>2];c[Q>>2]=0;if((aH|0)==(aI|0)){i=f;return}else{aJ=aH}while(1){aH=c[aJ+4>>2]|0;if((a[aJ+12|0]&1)!=0){w2(c[aJ+20>>2]|0)}w2(aJ);if((aH|0)==(aI|0)){break}else{aJ=aH}}i=f;return}function oQ(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0;b=i;i=i+32|0;d=b|0;e=b+8|0;f=b+16|0;g=b+24|0;h=c[v>>2]|0;pa(197808,h,197936);c[49700]=17028;c[49702]=17048;c[49701]=0;p9(198808,197808);c[49720]=0;c[49721]=-1;j=c[s>>2]|0;c[49428]=16808;uv(197716);xc(197720,0,24);c[49428]=17176;c[49436]=j;uw(g,197716);k=uy(g,198136)|0;l=k;ux(g);c[49437]=l;c[49438]=197944;a[197756]=(dR[c[(c[k>>2]|0)+28>>2]&255](l)|0)&1;c[49634]=16932;c[49635]=16952;p9(198540,197712);c[49653]=0;c[49654]=-1;l=c[p>>2]|0;c[49440]=16808;uv(197764);xc(197768,0,24);c[49440]=17176;c[49448]=l;uw(f,197764);k=uy(f,198136)|0;g=k;ux(f);c[49449]=g;c[49450]=197952;a[197804]=(dR[c[(c[k>>2]|0)+28>>2]&255](g)|0)&1;c[49678]=16932;c[49679]=16952;p9(198716,197760);c[49697]=0;c[49698]=-1;g=c[(c[(c[49678]|0)-12>>2]|0)+198736>>2]|0;c[49656]=16932;c[49657]=16952;p9(198628,g);c[49675]=0;c[49676]=-1;c[(c[(c[49700]|0)-12>>2]|0)+198872>>2]=198536;g=(c[(c[49678]|0)-12>>2]|0)+198716|0;c[g>>2]=c[g>>2]|8192;c[(c[(c[49678]|0)-12>>2]|0)+198784>>2]=198536;oY(197656,h,197960);c[49612]=16980;c[49614]=17e3;c[49613]=0;p9(198456,197656);c[49632]=0;c[49633]=-1;c[49390]=16736;uv(197564);xc(197568,0,24);c[49390]=17104;c[49398]=j;uw(e,197564);j=uy(e,198128)|0;h=j;ux(e);c[49399]=h;c[49400]=197968;a[197604]=(dR[c[(c[j>>2]|0)+28>>2]&255](h)|0)&1;c[49542]=16884;c[49543]=16904;p9(198172,197560);c[49561]=0;c[49562]=-1;c[49402]=16736;uv(197612);xc(197616,0,24);c[49402]=17104;c[49410]=l;uw(d,197612);l=uy(d,198128)|0;h=l;ux(d);c[49411]=h;c[49412]=197976;a[197652]=(dR[c[(c[l>>2]|0)+28>>2]&255](h)|0)&1;c[49586]=16884;c[49587]=16904;p9(198348,197608);c[49605]=0;c[49606]=-1;h=c[(c[(c[49586]|0)-12>>2]|0)+198368>>2]|0;c[49564]=16884;c[49565]=16904;p9(198260,h);c[49583]=0;c[49584]=-1;c[(c[(c[49612]|0)-12>>2]|0)+198520>>2]=198168;h=(c[(c[49586]|0)-12>>2]|0)+198348|0;c[h>>2]=c[h>>2]|8192;c[(c[(c[49586]|0)-12>>2]|0)+198416>>2]=198168;i=b;return}function oR(a){a=a|0;qG(198536)|0;qG(198624)|0;qM(198168)|0;qM(198256)|0;return}function oS(a){a=a|0;c[a>>2]=16736;ux(a+4|0);return}function oT(a){a=a|0;c[a>>2]=16736;ux(a+4|0);w2(a);return}function oU(b,d){b=b|0;d=d|0;var e=0;dR[c[(c[b>>2]|0)+24>>2]&255](b)|0;e=uy(d,198128)|0;d=e;c[b+36>>2]=d;a[b+44|0]=(dR[c[(c[e>>2]|0)+28>>2]&255](d)|0)&1;return}function oV(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;b=i;i=i+16|0;d=b|0;e=b+8|0;f=a+36|0;g=a+40|0;h=d|0;j=d+8|0;k=d;d=a+32|0;while(1){a=c[f>>2]|0;l=dU[c[(c[a>>2]|0)+20>>2]&63](a,c[g>>2]|0,h,j,e)|0;a=(c[e>>2]|0)-k|0;if((a1(h|0,1,a|0,c[d>>2]|0)|0)!=(a|0)){m=-1;n=3742;break}if((l|0)==2){m=-1;n=3740;break}else if((l|0)!=1){n=3738;break}}if((n|0)==3740){i=b;return m|0}else if((n|0)==3742){i=b;return m|0}else if((n|0)==3738){m=((aY(c[d>>2]|0)|0)!=0)<<31>>31;i=b;return m|0}return 0}function oW(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if((a[b+44|0]&1)!=0){f=a1(d|0,4,e|0,c[b+32>>2]|0)|0;return f|0}g=b;if((e|0)>0){h=d;i=0}else{f=0;return f|0}while(1){if((d2[c[(c[g>>2]|0)+52>>2]&127](b,c[h>>2]|0)|0)==-1){f=i;j=3752;break}d=i+1|0;if((d|0)<(e|0)){h=h+4|0;i=d}else{f=d;j=3751;break}}if((j|0)==3751){return f|0}else if((j|0)==3752){return f|0}return 0}function oX(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;e=i;i=i+32|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=(d|0)==-1;L4086:do{if(!k){c[g>>2]=d;if((a[b+44|0]&1)!=0){if((a1(g|0,4,1,c[b+32>>2]|0)|0)==1){break}else{l=-1}i=e;return l|0}m=f|0;c[h>>2]=m;n=g+4|0;o=b+36|0;p=b+40|0;q=f+8|0;r=f;s=b+32|0;t=g;while(1){u=c[o>>2]|0;v=d7[c[(c[u>>2]|0)+12>>2]&31](u,c[p>>2]|0,t,n,j,m,q,h)|0;if((c[j>>2]|0)==(t|0)){l=-1;w=3770;break}if((v|0)==3){w=3759;break}u=(v|0)==1;if(v>>>0>=2>>>0){l=-1;w=3766;break}v=(c[h>>2]|0)-r|0;if((a1(m|0,1,v|0,c[s>>2]|0)|0)!=(v|0)){l=-1;w=3767;break}if(u){t=u?c[j>>2]|0:t}else{break L4086}}if((w|0)==3759){if((a1(t|0,1,1,c[s>>2]|0)|0)==1){break}else{l=-1}i=e;return l|0}else if((w|0)==3766){i=e;return l|0}else if((w|0)==3767){i=e;return l|0}else if((w|0)==3770){i=e;return l|0}}}while(0);l=k?0:d;i=e;return l|0}function oY(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+8|0;g=f|0;h=b|0;c[h>>2]=16736;j=b+4|0;uv(j);xc(b+8|0,0,24);c[h>>2]=17504;c[b+32>>2]=d;c[b+40>>2]=e;c[b+48>>2]=-1;a[b+52|0]=0;uw(g,j);j=uy(g,198128)|0;e=j;d=b+36|0;c[d>>2]=e;h=b+44|0;c[h>>2]=dR[c[(c[j>>2]|0)+24>>2]&255](e)|0;e=c[d>>2]|0;a[b+53|0]=(dR[c[(c[e>>2]|0)+28>>2]&255](e)|0)&1;if((c[h>>2]|0)<=8){ux(g);i=f;return}tR(160);ux(g);i=f;return}function oZ(a){a=a|0;c[a>>2]=16736;ux(a+4|0);return}function o_(a){a=a|0;c[a>>2]=16736;ux(a+4|0);w2(a);return}function o$(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=uy(d,198128)|0;d=e;f=b+36|0;c[f>>2]=d;g=b+44|0;c[g>>2]=dR[c[(c[e>>2]|0)+24>>2]&255](d)|0;d=c[f>>2]|0;a[b+53|0]=(dR[c[(c[d>>2]|0)+28>>2]&255](d)|0)&1;if((c[g>>2]|0)<=8){return}tR(160);return}function o0(a){a=a|0;return o3(a,0)|0}function o1(a){a=a|0;return o3(a,1)|0}function o2(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=b+52|0;l=(a[k]&1)!=0;if((d|0)==-1){if(l){m=-1;i=e;return m|0}n=c[b+48>>2]|0;a[k]=(n|0)!=-1|0;m=n;i=e;return m|0}n=b+48|0;L4129:do{if(l){c[h>>2]=c[n>>2];o=c[b+36>>2]|0;p=f|0;q=d7[c[(c[o>>2]|0)+12>>2]&31](o,c[b+40>>2]|0,h,h+4|0,j,p,f+8|0,g)|0;if((q|0)==3){a[p]=c[n>>2]&255;c[g>>2]=f+1}else if((q|0)==2|(q|0)==1){m=-1;i=e;return m|0}q=b+32|0;while(1){o=c[g>>2]|0;if(o>>>0<=p>>>0){break L4129}r=o-1|0;c[g>>2]=r;if((c$(a[r]|0,c[q>>2]|0)|0)==-1){m=-1;break}}i=e;return m|0}}while(0);c[n>>2]=d;a[k]=1;m=d;i=e;return m|0}function o3(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;e=i;i=i+32|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=b+52|0;if((a[k]&1)!=0){l=b+48|0;m=c[l>>2]|0;if(!d){n=m;i=e;return n|0}c[l>>2]=-1;a[k]=0;n=m;i=e;return n|0}m=c[b+44>>2]|0;k=(m|0)>1?m:1;L4149:do{if((k|0)>0){m=b+32|0;l=0;while(1){o=cx(c[m>>2]|0)|0;if((o|0)==-1){n=-1;break}a[f+l|0]=o&255;l=l+1|0;if((l|0)>=(k|0)){break L4149}}i=e;return n|0}}while(0);L4156:do{if((a[b+53|0]&1)==0){l=b+40|0;m=b+36|0;o=f|0;p=g+4|0;q=b+32|0;r=k;while(1){s=c[l>>2]|0;t=s;u=c[t>>2]|0;v=c[t+4>>2]|0;t=c[m>>2]|0;w=f+r|0;x=d7[c[(c[t>>2]|0)+16>>2]&31](t,s,o,w,h,g,p,j)|0;if((x|0)==3){y=3816;break}else if((x|0)==2){n=-1;y=3826;break}else if((x|0)!=1){z=r;break L4156}x=c[l>>2]|0;c[x>>2]=u;c[x+4>>2]=v;if((r|0)==8){n=-1;y=3827;break}v=cx(c[q>>2]|0)|0;if((v|0)==-1){n=-1;y=3828;break}a[w]=v&255;r=r+1|0}if((y|0)==3816){c[g>>2]=a[o]|0;z=r;break}else if((y|0)==3827){i=e;return n|0}else if((y|0)==3826){i=e;return n|0}else if((y|0)==3828){i=e;return n|0}}else{c[g>>2]=a[f|0]|0;z=k}}while(0);if(d){d=c[g>>2]|0;c[b+48>>2]=d;n=d;i=e;return n|0}d=b+32|0;b=z;while(1){if((b|0)<=0){break}z=b-1|0;if((c$(a[f+z|0]|0,c[d>>2]|0)|0)==-1){n=-1;y=3829;break}else{b=z}}if((y|0)==3829){i=e;return n|0}n=c[g>>2]|0;i=e;return n|0}function o4(a){a=a|0;c[a>>2]=16808;ux(a+4|0);return}function o5(a){a=a|0;c[a>>2]=16808;ux(a+4|0);w2(a);return}function o6(b,d){b=b|0;d=d|0;var e=0;dR[c[(c[b>>2]|0)+24>>2]&255](b)|0;e=uy(d,198136)|0;d=e;c[b+36>>2]=d;a[b+44|0]=(dR[c[(c[e>>2]|0)+28>>2]&255](d)|0)&1;return}function o7(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;b=i;i=i+16|0;d=b|0;e=b+8|0;f=a+36|0;g=a+40|0;h=d|0;j=d+8|0;k=d;d=a+32|0;while(1){a=c[f>>2]|0;l=dU[c[(c[a>>2]|0)+20>>2]&63](a,c[g>>2]|0,h,j,e)|0;a=(c[e>>2]|0)-k|0;if((a1(h|0,1,a|0,c[d>>2]|0)|0)!=(a|0)){m=-1;n=3843;break}if((l|0)==2){m=-1;n=3842;break}else if((l|0)!=1){n=3840;break}}if((n|0)==3842){i=b;return m|0}else if((n|0)==3843){i=b;return m|0}else if((n|0)==3840){m=((aY(c[d>>2]|0)|0)!=0)<<31>>31;i=b;return m|0}return 0}function o8(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;if((a[b+44|0]&1)!=0){g=a1(e|0,1,f|0,c[b+32>>2]|0)|0;return g|0}h=b;if((f|0)>0){i=e;j=0}else{g=0;return g|0}while(1){if((d2[c[(c[h>>2]|0)+52>>2]&127](b,d[i]|0)|0)==-1){g=j;k=3852;break}e=j+1|0;if((e|0)<(f|0)){i=i+1|0;j=e}else{g=e;k=3853;break}}if((k|0)==3853){return g|0}else if((k|0)==3852){return g|0}return 0}function o9(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;e=i;i=i+32|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=(d|0)==-1;L4207:do{if(!k){a[g]=d&255;if((a[b+44|0]&1)!=0){if((a1(g|0,1,1,c[b+32>>2]|0)|0)==1){break}else{l=-1}i=e;return l|0}m=f|0;c[h>>2]=m;n=g+1|0;o=b+36|0;p=b+40|0;q=f+8|0;r=f;s=b+32|0;t=g;while(1){u=c[o>>2]|0;v=d7[c[(c[u>>2]|0)+12>>2]&31](u,c[p>>2]|0,t,n,j,m,q,h)|0;if((c[j>>2]|0)==(t|0)){l=-1;w=3872;break}if((v|0)==3){w=3861;break}u=(v|0)==1;if(v>>>0>=2>>>0){l=-1;w=3868;break}v=(c[h>>2]|0)-r|0;if((a1(m|0,1,v|0,c[s>>2]|0)|0)!=(v|0)){l=-1;w=3870;break}if(u){t=u?c[j>>2]|0:t}else{break L4207}}if((w|0)==3872){i=e;return l|0}else if((w|0)==3870){i=e;return l|0}else if((w|0)==3861){if((a1(t|0,1,1,c[s>>2]|0)|0)==1){break}else{l=-1}i=e;return l|0}else if((w|0)==3868){i=e;return l|0}}}while(0);l=k?0:d;i=e;return l|0}function pa(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+8|0;g=f|0;h=b|0;c[h>>2]=16808;j=b+4|0;uv(j);xc(b+8|0,0,24);c[h>>2]=17576;c[b+32>>2]=d;c[b+40>>2]=e;c[b+48>>2]=-1;a[b+52|0]=0;uw(g,j);j=uy(g,198136)|0;e=j;d=b+36|0;c[d>>2]=e;h=b+44|0;c[h>>2]=dR[c[(c[j>>2]|0)+24>>2]&255](e)|0;e=c[d>>2]|0;a[b+53|0]=(dR[c[(c[e>>2]|0)+28>>2]&255](e)|0)&1;if((c[h>>2]|0)<=8){ux(g);i=f;return}tR(160);ux(g);i=f;return}function pb(a){a=a|0;c[a>>2]=16808;ux(a+4|0);return}function pc(a){a=a|0;c[a>>2]=16808;ux(a+4|0);w2(a);return}function pd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=uy(d,198136)|0;d=e;f=b+36|0;c[f>>2]=d;g=b+44|0;c[g>>2]=dR[c[(c[e>>2]|0)+24>>2]&255](d)|0;d=c[f>>2]|0;a[b+53|0]=(dR[c[(c[d>>2]|0)+28>>2]&255](d)|0)&1;if((c[g>>2]|0)<=8){return}tR(160);return}function pe(a){a=a|0;return ph(a,0)|0}function pf(a){a=a|0;return ph(a,1)|0}function pg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;i=i+32|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=b+52|0;l=(a[k]&1)!=0;if((d|0)==-1){if(l){m=-1;i=e;return m|0}n=c[b+48>>2]|0;a[k]=(n|0)!=-1|0;m=n;i=e;return m|0}n=b+48|0;L4250:do{if(l){a[h]=c[n>>2]&255;o=c[b+36>>2]|0;p=f|0;q=d7[c[(c[o>>2]|0)+12>>2]&31](o,c[b+40>>2]|0,h,h+1|0,j,p,f+8|0,g)|0;if((q|0)==2|(q|0)==1){m=-1;i=e;return m|0}else if((q|0)==3){a[p]=c[n>>2]&255;c[g>>2]=f+1}q=b+32|0;while(1){o=c[g>>2]|0;if(o>>>0<=p>>>0){break L4250}r=o-1|0;c[g>>2]=r;if((c$(a[r]|0,c[q>>2]|0)|0)==-1){m=-1;break}}i=e;return m|0}}while(0);c[n>>2]=d;a[k]=1;m=d;i=e;return m|0}function ph(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;f=i;i=i+32|0;g=f|0;h=f+8|0;j=f+16|0;k=f+24|0;l=b+52|0;if((a[l]&1)!=0){m=b+48|0;n=c[m>>2]|0;if(!e){o=n;i=f;return o|0}c[m>>2]=-1;a[l]=0;o=n;i=f;return o|0}n=c[b+44>>2]|0;l=(n|0)>1?n:1;L4270:do{if((l|0)>0){n=b+32|0;m=0;while(1){p=cx(c[n>>2]|0)|0;if((p|0)==-1){o=-1;break}a[g+m|0]=p&255;m=m+1|0;if((m|0)>=(l|0)){break L4270}}i=f;return o|0}}while(0);L4277:do{if((a[b+53|0]&1)==0){m=b+40|0;n=b+36|0;p=g|0;q=h+1|0;r=b+32|0;s=l;while(1){t=c[m>>2]|0;u=t;v=c[u>>2]|0;w=c[u+4>>2]|0;u=c[n>>2]|0;x=g+s|0;y=d7[c[(c[u>>2]|0)+16>>2]&31](u,t,p,x,j,h,q,k)|0;if((y|0)==2){o=-1;z=3931;break}else if((y|0)==3){z=3918;break}else if((y|0)!=1){A=s;break L4277}y=c[m>>2]|0;c[y>>2]=v;c[y+4>>2]=w;if((s|0)==8){o=-1;z=3934;break}w=cx(c[r>>2]|0)|0;if((w|0)==-1){o=-1;z=3933;break}a[x]=w&255;s=s+1|0}if((z|0)==3931){i=f;return o|0}else if((z|0)==3934){i=f;return o|0}else if((z|0)==3918){a[h]=a[p]|0;A=s;break}else if((z|0)==3933){i=f;return o|0}}else{a[h]=a[g|0]|0;A=l}}while(0);do{if(e){l=a[h]|0;c[b+48>>2]=l&255;B=l}else{l=b+32|0;k=A;while(1){if((k|0)<=0){z=3925;break}j=k-1|0;if((c$(d[g+j|0]|0|0,c[l>>2]|0)|0)==-1){o=-1;z=3928;break}else{k=j}}if((z|0)==3928){i=f;return o|0}else if((z|0)==3925){B=a[h]|0;break}}}while(0);o=B&255;i=f;return o|0}function pi(){oQ(0);by(130,198888,u|0)|0;return}function pj(a){a=a|0;return}function pk(a){a=a|0;var b=0;b=a+4|0;J=c[b>>2]|0,c[b>>2]=J+1,J;return}function pl(a){a=a|0;var b=0,d=0;b=a+4|0;if(((J=c[b>>2]|0,c[b>>2]=J+ -1,J)|0)!=0){d=0;return d|0}dP[c[(c[a>>2]|0)+8>>2]&1023](a);d=1;return d|0}function pm(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[a>>2]=15080;d=a+4|0;if((d|0)==0){return}a=xd(b|0)|0;e=a+1|0;f=w1(a+13|0)|0;c[f+4>>2]=a;c[f>>2]=a;a=f+12|0;c[d>>2]=a;c[f+8>>2]=0;xa(a|0,b|0,e)|0;return}function pn(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=15080;b=a+4|0;d=(c[b>>2]|0)-4|0;if(((J=c[d>>2]|0,c[d>>2]=J+ -1,J)-1|0)>=0){e=a;w2(e);return}d=(c[b>>2]|0)-12|0;if((d|0)==0){e=a;w2(e);return}w3(d);e=a;w2(e);return}function po(a){a=a|0;var b=0;c[a>>2]=15080;b=a+4|0;a=(c[b>>2]|0)-4|0;if(((J=c[a>>2]|0,c[a>>2]=J+ -1,J)-1|0)>=0){return}a=(c[b>>2]|0)-12|0;if((a|0)==0){return}w3(a);return}function pp(a){a=a|0;return c[a+4>>2]|0}function pq(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;c[b>>2]=14984;e=b+4|0;if((e|0)==0){return}if((a[d]&1)==0){f=d+1|0}else{f=c[d+8>>2]|0}d=xd(f|0)|0;b=d+1|0;g=w1(d+13|0)|0;c[g+4>>2]=d;c[g>>2]=d;d=g+12|0;c[e>>2]=d;c[g+8>>2]=0;xa(d|0,f|0,b)|0;return}function pr(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[a>>2]=14984;d=a+4|0;if((d|0)==0){return}a=xd(b|0)|0;e=a+1|0;f=w1(a+13|0)|0;c[f+4>>2]=a;c[f>>2]=a;a=f+12|0;c[d>>2]=a;c[f+8>>2]=0;xa(a|0,b|0,e)|0;return}function ps(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=14984;b=a+4|0;d=(c[b>>2]|0)-4|0;if(((J=c[d>>2]|0,c[d>>2]=J+ -1,J)-1|0)>=0){e=a;w2(e);return}d=(c[b>>2]|0)-12|0;if((d|0)==0){e=a;w2(e);return}w3(d);e=a;w2(e);return}function pt(a){a=a|0;var b=0;c[a>>2]=14984;b=a+4|0;a=(c[b>>2]|0)-4|0;if(((J=c[a>>2]|0,c[a>>2]=J+ -1,J)-1|0)>=0){return}a=(c[b>>2]|0)-12|0;if((a|0)==0){return}w3(a);return}function pu(a){a=a|0;return c[a+4>>2]|0}function pv(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=15080;b=a+4|0;d=(c[b>>2]|0)-4|0;if(((J=c[d>>2]|0,c[d>>2]=J+ -1,J)-1|0)>=0){e=a;w2(e);return}d=(c[b>>2]|0)-12|0;if((d|0)==0){e=a;w2(e);return}w3(d);e=a;w2(e);return}function pw(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=15080;b=a+4|0;d=(c[b>>2]|0)-4|0;if(((J=c[d>>2]|0,c[d>>2]=J+ -1,J)-1|0)>=0){e=a;w2(e);return}d=(c[b>>2]|0)-12|0;if((d|0)==0){e=a;w2(e);return}w3(d);e=a;w2(e);return}function px(a){a=a|0;return}function py(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=d;c[a+4>>2]=b;return}function pz(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;d5[c[(c[a>>2]|0)+12>>2]&63](f,a,b);if((c[f+4>>2]|0)!=(c[d+4>>2]|0)){g=0;i=e;return g|0}g=(c[f>>2]|0)==(c[d>>2]|0);i=e;return g|0}function pA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((c[b+4>>2]|0)!=(a|0)){e=0;return e|0}e=(c[b>>2]|0)==(d|0);return e|0}function pB(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;d=cV(e|0)|0;e=xd(d|0)|0;if(e>>>0>4294967279>>>0){pH(0)}if(e>>>0<11>>>0){a[b]=e<<1&255;f=b+1|0;xa(f|0,d|0,e)|0;g=f+e|0;a[g]=0;return}else{h=e+16&-16;i=w0(h)|0;c[b+8>>2]=i;c[b>>2]=h|1;c[b+4>>2]=e;f=i;xa(f|0,d|0,e)|0;g=f+e|0;a[g]=0;return}}function pC(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;g=i;h=f;j=i;i=i+12|0;i=i+7&-8;k=e|0;l=c[k>>2]|0;do{if((l|0)!=0){m=d[h]|0;if((m&1|0)==0){n=m>>>1}else{n=c[f+4>>2]|0}if((n|0)==0){o=l}else{pU(f,5192,2)|0;o=c[k>>2]|0}m=c[e+4>>2]|0;d5[c[(c[m>>2]|0)+24>>2]&63](j,m,o);m=j;p=a[m]|0;if((p&1)==0){q=j+1|0}else{q=c[j+8>>2]|0}r=p&255;if((r&1|0)==0){s=r>>>1}else{s=c[j+4>>2]|0}pU(f,q,s)|0;if((a[m]&1)==0){break}w2(c[j+8>>2]|0)}}while(0);j=b;c[j>>2]=c[h>>2];c[j+4>>2]=c[h+4>>2];c[j+8>>2]=c[h+8>>2];xc(h|0,0,12);i=g;return}function pD(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+32|0;g=d;d=i;i=i+8|0;c[d>>2]=c[g>>2];c[d+4>>2]=c[g+4>>2];g=f|0;h=f+16|0;j=xd(e|0)|0;if(j>>>0>4294967279>>>0){pH(0)}if(j>>>0<11>>>0){a[h]=j<<1&255;k=h+1|0}else{l=j+16&-16;m=w0(l)|0;c[h+8>>2]=m;c[h>>2]=l|1;c[h+4>>2]=j;k=m}xa(k|0,e|0,j)|0;a[k+j|0]=0;pC(g,d,h);pq(b|0,g);if((a[g]&1)!=0){w2(c[g+8>>2]|0)}if((a[h]&1)!=0){w2(c[h+8>>2]|0)}c[b>>2]=17072;h=d;d=b+8|0;b=c[h+4>>2]|0;c[d>>2]=c[h>>2];c[d+4>>2]=b;i=f;return}function pE(a){a=a|0;pt(a|0);w2(a);return}function pF(a){a=a|0;pt(a|0);return}function pG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e;if((c[a>>2]|0)==1){do{bh(197888,197864)|0;}while((c[a>>2]|0)==1)}if((c[a>>2]|0)!=0){f;return}c[a>>2]=1;g;dP[d&1023](b);h;c[a>>2]=-1;i;dz(197888)|0;return}function pH(a){a=a|0;a=dl(8)|0;pm(a,768);c[a>>2]=15048;ch(a|0,24024,70)}function pI(a){a=a|0;a=dl(8)|0;pm(a,768);c[a>>2]=15016;ch(a|0,24008,12)}function pJ(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=d;if((a[e]&1)==0){f=b;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];return}e=c[d+8>>2]|0;f=c[d+4>>2]|0;if(f>>>0>4294967279>>>0){pH(0)}if(f>>>0<11>>>0){a[b]=f<<1&255;g=b+1|0}else{d=f+16&-16;h=w0(d)|0;c[b+8>>2]=h;c[b>>2]=d|1;c[b+4>>2]=f;g=h}xa(g|0,e|0,f)|0;a[g+f|0]=0;return}function pK(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;if(e>>>0>4294967279>>>0){pH(0)}if(e>>>0<11>>>0){a[b]=e<<1&255;f=b+1|0;xa(f|0,d|0,e)|0;g=f+e|0;a[g]=0;return}else{h=e+16&-16;i=w0(h)|0;c[b+8>>2]=i;c[b>>2]=h|1;c[b+4>>2]=e;f=i;xa(f|0,d|0,e)|0;g=f+e|0;a[g]=0;return}}function pL(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;if(d>>>0>4294967279>>>0){pH(0)}if(d>>>0<11>>>0){a[b]=d<<1&255;f=b+1|0}else{g=d+16&-16;h=w0(g)|0;c[b+8>>2]=h;c[b>>2]=g|1;c[b+4>>2]=d;f=h}xc(f|0,e|0,d|0);a[f+d|0]=0;return}function pM(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;g=a[d]|0;h=g&255;if((h&1|0)==0){i=h>>>1}else{i=c[d+4>>2]|0}if(i>>>0<e>>>0){pI(0)}if((g&1)==0){j=d+1|0}else{j=c[d+8>>2]|0}d=j+e|0;j=i-e|0;e=j>>>0<f>>>0?j:f;if(e>>>0>4294967279>>>0){pH(0)}if(e>>>0<11>>>0){a[b]=e<<1&255;k=b+1|0;xa(k|0,d|0,e)|0;l=k+e|0;a[l]=0;return}else{f=e+16&-16;j=w0(f)|0;c[b+8>>2]=j;c[b>>2]=f|1;c[b+4>>2]=e;k=j;xa(k|0,d|0,e)|0;l=k+e|0;a[l]=0;return}}function pN(b){b=b|0;if((a[b]&1)==0){return}w2(c[b+8>>2]|0);return}function pO(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;if((b|0)==(d|0)){return b|0}e=a[d]|0;if((e&1)==0){f=d+1|0}else{f=c[d+8>>2]|0}g=e&255;if((g&1|0)==0){h=g>>>1}else{h=c[d+4>>2]|0}d=b;g=b;e=a[g]|0;if((e&1)==0){i=10;j=e}else{e=c[b>>2]|0;i=(e&-2)-1|0;j=e&255}if(i>>>0<h>>>0){e=j&255;if((e&1|0)==0){k=e>>>1}else{k=c[b+4>>2]|0}pV(b,i,h-i|0,k,0,k,h,f);return b|0}if((j&1)==0){l=d+1|0}else{l=c[b+8>>2]|0}xe(l|0,f|0,h|0);a[l+h|0]=0;if((a[g]&1)==0){a[g]=h<<1&255;return b|0}else{c[b+4>>2]=h;return b|0}return 0}function pP(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=xd(d|0)|0;f=b;g=b;h=a[g]|0;if((h&1)==0){i=10;j=h}else{h=c[b>>2]|0;i=(h&-2)-1|0;j=h&255}if(i>>>0<e>>>0){h=j&255;if((h&1|0)==0){k=h>>>1}else{k=c[b+4>>2]|0}pV(b,i,e-i|0,k,0,k,e,d);return b|0}if((j&1)==0){l=f+1|0}else{l=c[b+8>>2]|0}xe(l|0,d|0,e|0);a[l+e|0]=0;if((a[g]&1)==0){a[g]=e<<1&255;return b|0}else{c[b+4>>2]=e;return b|0}return 0}function pQ(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;f=b;g=a[f]|0;h=g&255;if((h&1|0)==0){i=h>>>1}else{i=c[b+4>>2]|0}if(i>>>0<d>>>0){h=d-i|0;pR(b,h,e)|0;return}if((g&1)==0){a[b+1+d|0]=0;a[f]=d<<1&255;return}else{a[(c[b+8>>2]|0)+d|0]=0;c[b+4>>2]=d;return}}function pR(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;if((d|0)==0){return b|0}f=b;g=a[f]|0;if((g&1)==0){h=10;i=g}else{g=c[b>>2]|0;h=(g&-2)-1|0;i=g&255}g=i&255;if((g&1|0)==0){j=g>>>1}else{j=c[b+4>>2]|0}if((h-j|0)>>>0<d>>>0){pW(b,h,d-h+j|0,j,j,0,0);k=a[f]|0}else{k=i}if((k&1)==0){l=b+1|0}else{l=c[b+8>>2]|0}xc(l+j|0,e|0,d|0);e=j+d|0;if((a[f]&1)==0){a[f]=e<<1&255}else{c[b+4>>2]=e}a[l+e|0]=0;return b|0}function pS(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;if(d>>>0>4294967279>>>0){pH(0)}e=b;f=b;g=a[f]|0;if((g&1)==0){h=10;i=g}else{g=c[b>>2]|0;h=(g&-2)-1|0;i=g&255}g=i&255;if((g&1|0)==0){j=g>>>1}else{j=c[b+4>>2]|0}g=j>>>0>d>>>0?j:d;if(g>>>0<11>>>0){k=11}else{k=g+16&-16}g=k-1|0;if((g|0)==(h|0)){return}if((g|0)==10){l=e+1|0;m=c[b+8>>2]|0;n=1;o=0}else{if(g>>>0>h>>>0){p=w0(k)|0}else{p=w0(k)|0}h=i&1;if(h<<24>>24==0){q=e+1|0}else{q=c[b+8>>2]|0}l=p;m=q;n=h<<24>>24!=0;o=1}h=i&255;if((h&1|0)==0){r=h>>>1}else{r=c[b+4>>2]|0}h=r+1|0;xa(l|0,m|0,h)|0;if(n){w2(m)}if(o){c[b>>2]=k|1;c[b+4>>2]=j;c[b+8>>2]=l;return}else{a[f]=j<<1&255;return}}function pT(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;e=b;f=a[e]|0;if((f&1)==0){g=(f&255)>>>1;h=10}else{g=c[b+4>>2]|0;h=(c[b>>2]&-2)-1|0}if((g|0)==(h|0)){pW(b,h,1,h,h,0,0);i=a[e]|0}else{i=f}if((i&1)==0){a[e]=(g<<1)+2&255;j=b+1|0;k=g+1|0;l=j+g|0;a[l]=d;m=j+k|0;a[m]=0;return}else{e=c[b+8>>2]|0;i=g+1|0;c[b+4>>2]=i;j=e;k=i;l=j+g|0;a[l]=d;m=j+k|0;a[m]=0;return}}function pU(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;f=b;g=a[f]|0;if((g&1)==0){h=10;i=g}else{g=c[b>>2]|0;h=(g&-2)-1|0;i=g&255}g=i&255;if((g&1|0)==0){j=g>>>1}else{j=c[b+4>>2]|0}if((h-j|0)>>>0<e>>>0){pV(b,h,e-h+j|0,j,j,0,e,d);return b|0}if((e|0)==0){return b|0}if((i&1)==0){k=b+1|0}else{k=c[b+8>>2]|0}i=k+j|0;xa(i|0,d|0,e)|0;d=j+e|0;if((a[f]&1)==0){a[f]=d<<1&255}else{c[b+4>>2]=d}a[k+d|0]=0;return b|0}function pV(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;if((-18-d|0)>>>0<e>>>0){pH(0)}if((a[b]&1)==0){k=b+1|0}else{k=c[b+8>>2]|0}do{if(d>>>0<2147483623>>>0){l=e+d|0;m=d<<1;n=l>>>0<m>>>0?m:l;if(n>>>0<11>>>0){o=11;break}o=n+16&-16}else{o=-17}}while(0);e=w0(o)|0;if((g|0)!=0){xa(e|0,k|0,g)|0}if((i|0)!=0){n=e+g|0;xa(n|0,j|0,i)|0}j=f-h|0;if((j|0)!=(g|0)){f=j-g|0;n=e+(i+g)|0;l=k+(h+g)|0;xa(n|0,l|0,f)|0}if((d|0)==10){p=b+8|0;c[p>>2]=e;q=o|1;r=b|0;c[r>>2]=q;s=j+i|0;t=b+4|0;c[t>>2]=s;u=e+s|0;a[u]=0;return}w2(k);p=b+8|0;c[p>>2]=e;q=o|1;r=b|0;c[r>>2]=q;s=j+i|0;t=b+4|0;c[t>>2]=s;u=e+s|0;a[u]=0;return}function pW(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if((-17-d|0)>>>0<e>>>0){pH(0)}if((a[b]&1)==0){j=b+1|0}else{j=c[b+8>>2]|0}do{if(d>>>0<2147483623>>>0){k=e+d|0;l=d<<1;m=k>>>0<l>>>0?l:k;if(m>>>0<11>>>0){n=11;break}n=m+16&-16}else{n=-17}}while(0);e=w0(n)|0;if((g|0)!=0){xa(e|0,j|0,g)|0}m=f-h|0;if((m|0)!=(g|0)){f=m-g|0;m=e+(i+g)|0;i=j+(h+g)|0;xa(m|0,i|0,f)|0}if((d|0)==10){o=b+8|0;c[o>>2]=e;p=n|1;q=b|0;c[q>>2]=p;return}w2(j);o=b+8|0;c[o>>2]=e;p=n|1;q=b|0;c[q>>2]=p;return}function pX(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=b;h=a[g]|0;i=h&255;if((i&1|0)==0){j=i>>>1}else{j=c[b+4>>2]|0}if(j>>>0<d>>>0){pI(0);return 0}if((h&1)==0){k=10;l=h}else{h=c[b>>2]|0;k=(h&-2)-1|0;l=h&255}if((k-j|0)>>>0<f>>>0){pV(b,k,j+f-k|0,j,d,0,f,e);return b|0}if((f|0)==0){return b|0}if((l&1)==0){m=b+1|0}else{m=c[b+8>>2]|0}l=j-d|0;k=m+d|0;if((j|0)==(d|0)){n=e}else{do{if(k>>>0>e>>>0){o=e}else{if((m+j|0)>>>0<=e>>>0){o=e;break}o=e+f|0}}while(0);xe(m+(f+d)|0,k|0,l|0);n=o}xe(k|0,n|0,f|0);n=j+f|0;if((a[g]&1)==0){a[g]=n<<1&255}else{c[b+4>>2]=n}a[m+n|0]=0;return b|0}function pY(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;h=b;i=a[h]|0;j=i&255;if((j&1|0)==0){k=j>>>1}else{k=c[b+4>>2]|0}if(k>>>0<d>>>0){pI(0);return 0}j=k-d|0;l=j>>>0<e>>>0?j:e;if((i&1)==0){m=10;n=i}else{i=c[b>>2]|0;m=(i&-2)-1|0;n=i&255}if((l-k+m|0)>>>0<g>>>0){pV(b,m,k+g-l-m|0,k,d,l,g,f);return b|0}if((n&1)==0){o=b+1|0}else{o=c[b+8>>2]|0}do{if((l|0)==(g|0)){p=d;q=f;r=g;s=g;t=4354}else{n=j-l|0;if((j|0)==(l|0)){p=d;q=f;r=g;s=j;t=4354;break}m=o+d|0;if(l>>>0>g>>>0){xe(m|0,f|0,g|0);xe(o+(g+d)|0,o+(l+d)|0,n|0);u=g;v=l;break}do{if(m>>>0<f>>>0){if((o+k|0)>>>0<=f>>>0){w=d;x=f;y=g;z=l;break}i=l+d|0;if((o+i|0)>>>0>f>>>0){xe(m|0,f|0,l|0);w=i;x=f+g|0;y=g-l|0;z=0;break}else{w=d;x=f+(g-l)|0;y=g;z=l;break}}else{w=d;x=f;y=g;z=l}}while(0);xe(o+(w+y)|0,o+(w+z)|0,n|0);p=w;q=x;r=y;s=z;t=4354}}while(0);if((t|0)==4354){xe(o+p|0,q|0,r|0);u=r;v=s}s=u-v+k|0;if((a[h]&1)==0){a[h]=s<<1&255}else{c[b+4>>2]=s}a[o+s|0]=0;return b|0}function pZ(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if(e>>>0>1073741807>>>0){pH(0)}if(e>>>0<2>>>0){a[b]=e<<1&255;f=b+4|0;g=wr(f,d,e)|0;h=f+(e<<2)|0;c[h>>2]=0;return}else{i=e+4&-4;j=w0(i<<2)|0;c[b+8>>2]=j;c[b>>2]=i|1;c[b+4>>2]=e;f=j;g=wr(f,d,e)|0;h=f+(e<<2)|0;c[h>>2]=0;return}}function p_(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;if(d>>>0>1073741807>>>0){pH(0)}if(d>>>0<2>>>0){a[b]=d<<1&255;f=b+4|0;g=wt(f,e,d)|0;h=f+(d<<2)|0;c[h>>2]=0;return}else{i=d+4&-4;j=w0(i<<2)|0;c[b+8>>2]=j;c[b>>2]=i|1;c[b+4>>2]=d;f=j;g=wt(f,e,d)|0;h=f+(d<<2)|0;c[h>>2]=0;return}}function p$(b){b=b|0;if((a[b]&1)==0){return}w2(c[b+8>>2]|0);return}function p0(a,b){a=a|0;b=b|0;return p1(a,b,wq(b)|0)|0}function p1(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;f=b;g=a[f]|0;if((g&1)==0){h=1;i=g}else{g=c[b>>2]|0;h=(g&-2)-1|0;i=g&255}if(h>>>0<e>>>0){g=i&255;if((g&1|0)==0){j=g>>>1}else{j=c[b+4>>2]|0}p4(b,h,e-h|0,j,0,j,e,d);return b|0}if((i&1)==0){k=b+4|0}else{k=c[b+8>>2]|0}ws(k,d,e)|0;c[k+(e<<2)>>2]=0;if((a[f]&1)==0){a[f]=e<<1&255;return b|0}else{c[b+4>>2]=e;return b|0}return 0}function p2(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if(d>>>0>1073741807>>>0){pH(0)}e=b;f=a[e]|0;if((f&1)==0){g=1;h=f}else{f=c[b>>2]|0;g=(f&-2)-1|0;h=f&255}f=h&255;if((f&1|0)==0){i=f>>>1}else{i=c[b+4>>2]|0}f=i>>>0>d>>>0?i:d;if(f>>>0<2>>>0){j=2}else{j=f+4&-4}f=j-1|0;if((f|0)==(g|0)){return}if((f|0)==1){k=b+4|0;l=c[b+8>>2]|0;m=1;n=0}else{d=j<<2;if(f>>>0>g>>>0){o=w0(d)|0}else{o=w0(d)|0}d=h&1;if(d<<24>>24==0){p=b+4|0}else{p=c[b+8>>2]|0}k=o;l=p;m=d<<24>>24!=0;n=1}d=k;k=h&255;if((k&1|0)==0){q=k>>>1}else{q=c[b+4>>2]|0}wr(d,l,q+1|0)|0;if(m){w2(l)}if(n){c[b>>2]=j|1;c[b+4>>2]=i;c[b+8>>2]=d;return}else{a[e]=i<<1&255;return}}function p3(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;e=b;f=a[e]|0;if((f&1)==0){g=(f&255)>>>1;h=1}else{g=c[b+4>>2]|0;h=(c[b>>2]&-2)-1|0}if((g|0)==(h|0)){p5(b,h,1,h,h,0,0);i=a[e]|0}else{i=f}if((i&1)==0){a[e]=(g<<1)+2&255;j=b+4|0;k=g+1|0;l=j+(g<<2)|0;c[l>>2]=d;m=j+(k<<2)|0;c[m>>2]=0;return}else{e=c[b+8>>2]|0;i=g+1|0;c[b+4>>2]=i;j=e;k=i;l=j+(g<<2)|0;c[l>>2]=d;m=j+(k<<2)|0;c[m>>2]=0;return}}function p4(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;if((1073741806-d|0)>>>0<e>>>0){pH(0)}if((a[b]&1)==0){k=b+4|0}else{k=c[b+8>>2]|0}do{if(d>>>0<536870887>>>0){l=e+d|0;m=d<<1;n=l>>>0<m>>>0?m:l;if(n>>>0<2>>>0){o=2;break}o=n+4&-4}else{o=1073741807}}while(0);e=w0(o<<2)|0;if((g|0)!=0){wr(e,k,g)|0}if((i|0)!=0){n=e+(g<<2)|0;wr(n,j,i)|0}j=f-h|0;if((j|0)!=(g|0)){f=j-g|0;n=e+(i+g<<2)|0;l=k+(h+g<<2)|0;wr(n,l,f)|0}if((d|0)==1){p=b+8|0;c[p>>2]=e;q=o|1;r=b|0;c[r>>2]=q;s=j+i|0;t=b+4|0;c[t>>2]=s;u=e+(s<<2)|0;c[u>>2]=0;return}w2(k);p=b+8|0;c[p>>2]=e;q=o|1;r=b|0;c[r>>2]=q;s=j+i|0;t=b+4|0;c[t>>2]=s;u=e+(s<<2)|0;c[u>>2]=0;return}function p5(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;if((1073741807-d|0)>>>0<e>>>0){pH(0)}if((a[b]&1)==0){j=b+4|0}else{j=c[b+8>>2]|0}do{if(d>>>0<536870887>>>0){k=e+d|0;l=d<<1;m=k>>>0<l>>>0?l:k;if(m>>>0<2>>>0){n=2;break}n=m+4&-4}else{n=1073741807}}while(0);e=w0(n<<2)|0;if((g|0)!=0){wr(e,j,g)|0}m=f-h|0;if((m|0)!=(g|0)){f=m-g|0;m=e+(i+g<<2)|0;i=j+(h+g<<2)|0;wr(m,i,f)|0}if((d|0)==1){o=b+8|0;c[o>>2]=e;p=n|1;q=b|0;c[q>>2]=p;return}w2(j);o=b+8|0;c[o>>2]=e;p=n|1;q=b|0;c[q>>2]=p;return}function p6(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+8|0;f=e|0;g=(c[b+24>>2]|0)==0;if(g){c[b+16>>2]=d|1}else{c[b+16>>2]=d}if(((g&1|d)&c[b+20>>2]|0)==0){i=e;return}e=dl(16)|0;do{if((a[200472]|0)==0){if((b_(200472)|0)==0){break}c[49248]=16544;by(150,196992,u|0)|0}}while(0);b=xh(196992,0,32)|0;c[f>>2]=b&0|1;c[f+4>>2]=L|0;pD(e,f,5488);c[e>>2]=15728;ch(e|0,24600,62)}function p7(a){a=a|0;var b=0,d=0,e=0,f=0;c[a>>2]=15704;b=c[a+40>>2]|0;d=a+32|0;e=a+36|0;if((b|0)!=0){f=b;do{f=f-1|0;d5[c[(c[d>>2]|0)+(f<<2)>>2]&63](0,a,c[(c[e>>2]|0)+(f<<2)>>2]|0);}while((f|0)!=0)}ux(a+28|0);wX(c[d>>2]|0);wX(c[e>>2]|0);wX(c[a+48>>2]|0);wX(c[a+60>>2]|0);return}function p8(a,b){a=a|0;b=b|0;uw(a,b+28|0);return}function p9(a,b){a=a|0;b=b|0;c[a+24>>2]=b;c[a+16>>2]=(b|0)==0;c[a+20>>2]=0;c[a+4>>2]=4098;c[a+12>>2]=0;c[a+8>>2]=6;b=a+28|0;xc(a+32|0,0,40);if((b|0)==0){return}uv(b);return}function qa(a){a=a|0;c[a>>2]=16808;ux(a+4|0);w2(a);return}function qb(a){a=a|0;c[a>>2]=16808;ux(a+4|0);return}function qc(a,b){a=a|0;b=b|0;return}function qd(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function qe(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;g=a;c[g>>2]=0;c[g+4>>2]=0;g=a+8|0;c[g>>2]=-1;c[g+4>>2]=-1;return}function qf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;e=i;b=d;d=i;i=i+16|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;i=e;return}function qg(a){a=a|0;return 0}function qh(a){a=a|0;return 0}function qi(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=b;if((e|0)<=0){g=0;return g|0}h=b+12|0;i=b+16|0;j=d;d=0;while(1){k=c[h>>2]|0;if(k>>>0<(c[i>>2]|0)>>>0){c[h>>2]=k+1;l=a[k]|0}else{k=dR[c[(c[f>>2]|0)+40>>2]&255](b)|0;if((k|0)==-1){g=d;m=4521;break}l=k&255}a[j]=l;k=d+1|0;if((k|0)<(e|0)){j=j+1|0;d=k}else{g=k;m=4519;break}}if((m|0)==4519){return g|0}else if((m|0)==4521){return g|0}return 0}function qj(a){a=a|0;return-1|0}function qk(a){a=a|0;var b=0,e=0;if((dR[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1){b=-1;return b|0}e=a+12|0;a=c[e>>2]|0;c[e>>2]=a+1;b=d[a]|0;return b|0}function ql(a,b){a=a|0;b=b|0;return-1|0}function qm(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=b;if((f|0)<=0){h=0;return h|0}i=b+24|0;j=b+28|0;k=0;l=e;while(1){e=c[i>>2]|0;if(e>>>0<(c[j>>2]|0)>>>0){m=a[l]|0;c[i>>2]=e+1;a[e]=m}else{if((d2[c[(c[g>>2]|0)+52>>2]&127](b,d[l]|0)|0)==-1){h=k;n=4537;break}}m=k+1|0;if((m|0)<(f|0)){k=m;l=l+1|0}else{h=m;n=4538;break}}if((n|0)==4538){return h|0}else if((n|0)==4537){return h|0}return 0}function qn(a,b){a=a|0;b=b|0;return-1|0}function qo(a){a=a|0;c[a>>2]=16736;ux(a+4|0);w2(a);return}function qp(a){a=a|0;c[a>>2]=16736;ux(a+4|0);return}function qq(a,b){a=a|0;b=b|0;return}function qr(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function qs(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;g=a;c[g>>2]=0;c[g+4>>2]=0;g=a+8|0;c[g>>2]=-1;c[g+4>>2]=-1;return}function qt(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;e=i;b=d;d=i;i=i+16|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;i=e;return}function qu(a){a=a|0;return 0}function qv(a){a=a|0;return 0}function qw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=a;if((d|0)<=0){f=0;return f|0}g=a+12|0;h=a+16|0;i=b;b=0;while(1){j=c[g>>2]|0;if(j>>>0<(c[h>>2]|0)>>>0){c[g>>2]=j+4;k=c[j>>2]|0}else{j=dR[c[(c[e>>2]|0)+40>>2]&255](a)|0;if((j|0)==-1){f=b;l=4555;break}else{k=j}}c[i>>2]=k;j=b+1|0;if((j|0)<(d|0)){i=i+4|0;b=j}else{f=j;l=4556;break}}if((l|0)==4555){return f|0}else if((l|0)==4556){return f|0}return 0}function qx(a){a=a|0;return-1|0}function qy(a){a=a|0;var b=0,d=0;if((dR[c[(c[a>>2]|0)+36>>2]&255](a)|0)==-1){b=-1;return b|0}d=a+12|0;a=c[d>>2]|0;c[d>>2]=a+4;b=c[a>>2]|0;return b|0}function qz(a,b){a=a|0;b=b|0;return-1|0}function qA(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=a;if((d|0)<=0){f=0;return f|0}g=a+24|0;h=a+28|0;i=0;j=b;while(1){b=c[g>>2]|0;if(b>>>0<(c[h>>2]|0)>>>0){k=c[j>>2]|0;c[g>>2]=b+4;c[b>>2]=k}else{if((d2[c[(c[e>>2]|0)+52>>2]&127](a,c[j>>2]|0)|0)==-1){f=i;l=4573;break}}k=i+1|0;if((k|0)<(d|0)){i=k;j=j+4|0}else{f=k;l=4574;break}}if((l|0)==4574){return f|0}else if((l|0)==4573){return f|0}return 0}function qB(a,b){a=a|0;b=b|0;return-1|0}function qC(a){a=a|0;p7(a+8|0);w2(a);return}function qD(a){a=a|0;p7(a+8|0);return}function qE(a){a=a|0;var b=0,d=0;b=a;d=c[(c[a>>2]|0)-12>>2]|0;p7(b+(d+8)|0);w2(b+d|0);return}function qF(a){a=a|0;p7(a+((c[(c[a>>2]|0)-12>>2]|0)+8)|0);return}function qG(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+8|0;e=d|0;f=b;g=c[(c[f>>2]|0)-12>>2]|0;h=b;if((c[h+(g+24)>>2]|0)==0){i=d;return b|0}j=e|0;a[j]=0;c[e+4>>2]=b;do{if((c[h+(g+16)>>2]|0)==0){k=c[h+(g+72)>>2]|0;if((k|0)!=0){qG(k)|0}a[j]=1;k=c[h+((c[(c[f>>2]|0)-12>>2]|0)+24)>>2]|0;if((dR[c[(c[k>>2]|0)+24>>2]&255](k)|0)!=-1){break}k=c[(c[f>>2]|0)-12>>2]|0;p6(h+k|0,c[h+(k+16)>>2]|1)}}while(0);qR(e);i=d;return b|0}function qH(a){a=a|0;var b=0;b=a+16|0;c[b>>2]=c[b>>2]|1;if((c[a+20>>2]&1|0)==0){return}else{bi()}}function qI(a){a=a|0;p7(a+8|0);w2(a);return}function qJ(a){a=a|0;p7(a+8|0);return}function qK(a){a=a|0;var b=0,d=0;b=a;d=c[(c[a>>2]|0)-12>>2]|0;p7(b+(d+8)|0);w2(b+d|0);return}function qL(a){a=a|0;p7(a+((c[(c[a>>2]|0)-12>>2]|0)+8)|0);return}function qM(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+8|0;e=d|0;f=b;g=c[(c[f>>2]|0)-12>>2]|0;h=b;if((c[h+(g+24)>>2]|0)==0){i=d;return b|0}j=e|0;a[j]=0;c[e+4>>2]=b;do{if((c[h+(g+16)>>2]|0)==0){k=c[h+(g+72)>>2]|0;if((k|0)!=0){qM(k)|0}a[j]=1;k=c[h+((c[(c[f>>2]|0)-12>>2]|0)+24)>>2]|0;if((dR[c[(c[k>>2]|0)+24>>2]&255](k)|0)!=-1){break}k=c[(c[f>>2]|0)-12>>2]|0;p6(h+k|0,c[h+(k+16)>>2]|1)}}while(0);qY(e);i=d;return b|0}function qN(a){a=a|0;p7(a+4|0);w2(a);return}function qO(a){a=a|0;p7(a+4|0);return}function qP(a){a=a|0;var b=0,d=0;b=a;d=c[(c[a>>2]|0)-12>>2]|0;p7(b+(d+4)|0);w2(b+d|0);return}function qQ(a){a=a|0;p7(a+((c[(c[a>>2]|0)-12>>2]|0)+4)|0);return}function qR(a){a=a|0;var b=0,d=0,e=0;b=a+4|0;a=c[b>>2]|0;d=c[(c[a>>2]|0)-12>>2]|0;e=a;if((c[e+(d+24)>>2]|0)==0){return}if((c[e+(d+16)>>2]|0)!=0){return}if((c[e+(d+4)>>2]&8192|0)==0){return}if(b3()|0){return}d=c[b>>2]|0;e=c[d+((c[(c[d>>2]|0)-12>>2]|0)+24)>>2]|0;if((dR[c[(c[e>>2]|0)+24>>2]&255](e)|0)!=-1){return}e=c[b>>2]|0;b=c[(c[e>>2]|0)-12>>2]|0;d=e;p6(d+b|0,c[d+(b+16)>>2]|1);return}function qS(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;e=i;i=i+40|0;f=e|0;g=e+8|0;h=e+16|0;j=e+24|0;k=e+32|0;l=h|0;a[l]=0;c[h+4>>2]=b;m=b;n=c[(c[m>>2]|0)-12>>2]|0;o=b;do{if((c[o+(n+16)>>2]|0)==0){p=c[o+(n+72)>>2]|0;if((p|0)!=0){qG(p)|0}a[l]=1;uw(j,o+((c[(c[m>>2]|0)-12>>2]|0)+28)|0);p=uy(j,198088)|0;ux(j);q=c[(c[m>>2]|0)-12>>2]|0;r=c[o+(q+24)>>2]|0;s=o+(q+76)|0;t=c[s>>2]|0;if((t|0)==-1){uw(g,o+(q+28)|0);u=uy(g,198440)|0;v=d2[c[(c[u>>2]|0)+28>>2]&127](u,32)|0;ux(g);c[s>>2]=v<<24>>24;w=v}else{w=t&255}t=c[(c[p>>2]|0)+16>>2]|0;c[f>>2]=r;dY[t&63](k,p,f,o+q|0,w,d);if((c[k>>2]|0)!=0){break}q=c[(c[m>>2]|0)-12>>2]|0;p6(o+q|0,c[o+(q+16)>>2]|5)}}while(0);qR(h);i=e;return b|0}function qT(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=i;i=i+8|0;f=e|0;g=f|0;a[g]=0;c[f+4>>2]=b;h=b;j=c[(c[h>>2]|0)-12>>2]|0;k=b;do{if((c[k+(j+16)>>2]|0)==0){l=c[k+(j+72)>>2]|0;if((l|0)!=0){qG(l)|0}a[g]=1;l=c[k+((c[(c[h>>2]|0)-12>>2]|0)+24)>>2]|0;m=l;if((l|0)==0){n=m}else{o=l+24|0;p=c[o>>2]|0;if((p|0)==(c[l+28>>2]|0)){q=d2[c[(c[l>>2]|0)+52>>2]&127](m,d&255)|0}else{c[o>>2]=p+1;a[p]=d;q=d&255}n=(q|0)==-1?0:m}if((n|0)!=0){break}m=c[(c[h>>2]|0)-12>>2]|0;p6(k+m|0,c[k+(m+16)>>2]|1)}}while(0);qR(f);i=e;return b|0}function qU(a){a=a|0;p7(a+4|0);w2(a);return}function qV(a){a=a|0;p7(a+4|0);return}function qW(a){a=a|0;var b=0,d=0;b=a;d=c[(c[a>>2]|0)-12>>2]|0;p7(b+(d+4)|0);w2(b+d|0);return}function qX(a){a=a|0;p7(a+((c[(c[a>>2]|0)-12>>2]|0)+4)|0);return}function qY(a){a=a|0;var b=0,d=0,e=0;b=a+4|0;a=c[b>>2]|0;d=c[(c[a>>2]|0)-12>>2]|0;e=a;if((c[e+(d+24)>>2]|0)==0){return}if((c[e+(d+16)>>2]|0)!=0){return}if((c[e+(d+4)>>2]&8192|0)==0){return}if(b3()|0){return}d=c[b>>2]|0;e=c[d+((c[(c[d>>2]|0)-12>>2]|0)+24)>>2]|0;if((dR[c[(c[e>>2]|0)+24>>2]&255](e)|0)!=-1){return}e=c[b>>2]|0;b=c[(c[e>>2]|0)-12>>2]|0;d=e;p6(d+b|0,c[d+(b+16)>>2]|1);return}function qZ(a){a=a|0;return 6688}function q_(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)==1){pK(a,7224,35);return}else{pB(a,b|0,c);return}}function q$(a){a=a|0;px(a|0);return}function q0(a){a=a|0;pF(a|0);w2(a);return}function q1(a){a=a|0;pF(a|0);return}function q2(a){a=a|0;p7(a);w2(a);return}function q3(a){a=a|0;px(a|0);w2(a);return}function q4(a){a=a|0;pj(a|0);w2(a);return}function q5(a){a=a|0;pj(a|0);return}function q6(a){a=a|0;pj(a|0);return}function q7(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;L5187:do{if((e|0)==(f|0)){g=c}else{b=c;h=e;while(1){if((b|0)==(d|0)){i=-1;j=4738;break}k=a[b]|0;l=a[h]|0;if(k<<24>>24<l<<24>>24){i=-1;j=4736;break}if(l<<24>>24<k<<24>>24){i=1;j=4739;break}k=b+1|0;l=h+1|0;if((l|0)==(f|0)){g=k;break L5187}else{b=k;h=l}}if((j|0)==4736){return i|0}else if((j|0)==4739){return i|0}else if((j|0)==4738){return i|0}}}while(0);i=(g|0)!=(d|0)|0;return i|0}function q8(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;d=e;g=f-d|0;if(g>>>0>4294967279>>>0){pH(b)}if(g>>>0<11>>>0){a[b]=g<<1&255;h=b+1|0}else{i=g+16&-16;j=w0(i)|0;c[b+8>>2]=j;c[b>>2]=i|1;c[b+4>>2]=g;h=j}if((e|0)==(f|0)){k=h;a[k]=0;return}j=f+(-d|0)|0;d=h;g=e;while(1){a[d]=a[g]|0;e=g+1|0;if((e|0)==(f|0)){break}else{d=d+1|0;g=e}}k=h+j|0;a[k]=0;return}function q9(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;if((c|0)==(d|0)){e=0;return e|0}else{f=c;g=0}while(1){c=(a[f]|0)+(g<<4)|0;b=c&-268435456;h=(b>>>24|b)^c;c=f+1|0;if((c|0)==(d|0)){e=h;break}else{f=c;g=h}}return e|0}function ra(a){a=a|0;pj(a|0);w2(a);return}function rb(a){a=a|0;pj(a|0);return}function rc(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;L5223:do{if((e|0)==(f|0)){g=b}else{a=b;h=e;while(1){if((a|0)==(d|0)){i=-1;j=4768;break}k=c[a>>2]|0;l=c[h>>2]|0;if((k|0)<(l|0)){i=-1;j=4769;break}if((l|0)<(k|0)){i=1;j=4767;break}k=a+4|0;l=h+4|0;if((l|0)==(f|0)){g=k;break L5223}else{a=k;h=l}}if((j|0)==4768){return i|0}else if((j|0)==4769){return i|0}else if((j|0)==4767){return i|0}}}while(0);i=(g|0)!=(d|0)|0;return i|0}function rd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;d=e;g=f-d|0;h=g>>2;if(h>>>0>1073741807>>>0){pH(b)}if(h>>>0<2>>>0){a[b]=g>>>1&255;i=b+4|0}else{g=h+4&-4;j=w0(g<<2)|0;c[b+8>>2]=j;c[b>>2]=g|1;c[b+4>>2]=h;i=j}if((e|0)==(f|0)){k=i;c[k>>2]=0;return}j=(f-4+(-d|0)|0)>>>2;d=i;h=e;while(1){c[d>>2]=c[h>>2];e=h+4|0;if((e|0)==(f|0)){break}else{d=d+4|0;h=e}}k=i+(j+1<<2)|0;c[k>>2]=0;return}function re(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;if((b|0)==(d|0)){e=0;return e|0}else{f=b;g=0}while(1){b=(c[f>>2]|0)+(g<<4)|0;a=b&-268435456;h=(a>>>24|a)^b;b=f+4|0;if((b|0)==(d|0)){e=h;break}else{f=b;g=h}}return e|0}function rf(a){a=a|0;pj(a|0);w2(a);return}function rg(a){a=a|0;pj(a|0);return}function rh(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;k=i;i=i+112|0;l=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[l>>2];l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=k|0;m=k+16|0;n=k+32|0;o=k+40|0;p=k+48|0;q=k+56|0;r=k+64|0;s=k+72|0;t=k+80|0;u=k+104|0;if((c[g+4>>2]&1|0)==0){c[n>>2]=-1;v=c[(c[d>>2]|0)+16>>2]|0;w=e|0;c[p>>2]=c[w>>2];c[q>>2]=c[f>>2];d_[v&127](o,d,p,q,g,h,n);q=c[o>>2]|0;c[w>>2]=q;w=c[n>>2]|0;if((w|0)==0){a[j]=0}else if((w|0)==1){a[j]=1}else{a[j]=1;c[h>>2]=4}c[b>>2]=q;i=k;return}p8(r,g);q=r|0;r=c[q>>2]|0;if((c[49610]|0)!=-1){c[m>>2]=198440;c[m+4>>2]=26;c[m+8>>2]=0;pG(198440,m,202)}m=(c[49611]|0)-1|0;w=c[r+8>>2]|0;do{if((c[r+12>>2]|0)-w>>2>>>0>m>>>0){n=c[w+(m<<2)>>2]|0;if((n|0)==0){break}o=n;n=c[q>>2]|0;pl(n)|0;p8(s,g);n=s|0;p=c[n>>2]|0;if((c[49514]|0)!=-1){c[l>>2]=198056;c[l+4>>2]=26;c[l+8>>2]=0;pG(198056,l,202)}d=(c[49515]|0)-1|0;v=c[p+8>>2]|0;do{if((c[p+12>>2]|0)-v>>2>>>0>d>>>0){x=c[v+(d<<2)>>2]|0;if((x|0)==0){break}y=x;z=c[n>>2]|0;pl(z)|0;z=t|0;A=x;dQ[c[(c[A>>2]|0)+24>>2]&255](z,y);dQ[c[(c[A>>2]|0)+28>>2]&255](t+12|0,y);c[u>>2]=c[f>>2];a[j]=(ri(e,u,z,t+24|0,o,h,1)|0)==(z|0)|0;c[b>>2]=c[e>>2];pN(t+12|0);pN(t|0);i=k;return}}while(0);o=dl(4)|0;wv(o);ch(o|0,23976,298)}}while(0);k=dl(4)|0;wv(k);ch(k|0,23976,298)}function ri(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0;l=i;i=i+104|0;m=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[m>>2];m=(g-f|0)/12|0;n=l|0;do{if(m>>>0>100>>>0){o=wW(m)|0;if((o|0)!=0){p=o;q=o;break}w7();p=0;q=0}else{p=n;q=0}}while(0);n=(f|0)==(g|0);if(n){r=m;s=0}else{o=m;m=0;t=p;u=f;while(1){v=d[u]|0;if((v&1|0)==0){w=v>>>1}else{w=c[u+4>>2]|0}if((w|0)==0){a[t]=2;x=m+1|0;y=o-1|0}else{a[t]=1;x=m;y=o}v=u+12|0;if((v|0)==(g|0)){r=y;s=x;break}else{o=y;m=x;t=t+1|0;u=v}}}u=b|0;b=e|0;e=h;t=0;x=s;s=r;while(1){r=c[u>>2]|0;do{if((r|0)==0){z=0}else{if((c[r+12>>2]|0)!=(c[r+16>>2]|0)){z=r;break}if((dR[c[(c[r>>2]|0)+36>>2]&255](r)|0)==-1){c[u>>2]=0;z=0;break}else{z=c[u>>2]|0;break}}}while(0);r=(z|0)==0;m=c[b>>2]|0;if((m|0)==0){A=z;B=0}else{do{if((c[m+12>>2]|0)==(c[m+16>>2]|0)){if((dR[c[(c[m>>2]|0)+36>>2]&255](m)|0)!=-1){C=m;break}c[b>>2]=0;C=0}else{C=m}}while(0);A=c[u>>2]|0;B=C}D=(B|0)==0;if(!((r^D)&(s|0)!=0)){break}m=c[A+12>>2]|0;if((m|0)==(c[A+16>>2]|0)){E=(dR[c[(c[A>>2]|0)+36>>2]&255](A)|0)&255}else{E=a[m]|0}if(k){F=E}else{F=d2[c[(c[e>>2]|0)+12>>2]&127](h,E)|0}do{if(n){G=x;H=s}else{m=t+1|0;L5334:do{if(k){y=s;o=x;w=p;v=0;I=f;while(1){do{if((a[w]|0)==1){J=I;if((a[J]&1)==0){K=I+1|0}else{K=c[I+8>>2]|0}if(F<<24>>24!=(a[K+t|0]|0)){a[w]=0;L=v;M=o;N=y-1|0;break}O=d[J]|0;if((O&1|0)==0){P=O>>>1}else{P=c[I+4>>2]|0}if((P|0)!=(m|0)){L=1;M=o;N=y;break}a[w]=2;L=1;M=o+1|0;N=y-1|0}else{L=v;M=o;N=y}}while(0);O=I+12|0;if((O|0)==(g|0)){Q=N;R=M;S=L;break L5334}y=N;o=M;w=w+1|0;v=L;I=O}}else{I=s;v=x;w=p;o=0;y=f;while(1){do{if((a[w]|0)==1){O=y;if((a[O]&1)==0){T=y+1|0}else{T=c[y+8>>2]|0}if(F<<24>>24!=(d2[c[(c[e>>2]|0)+12>>2]&127](h,a[T+t|0]|0)|0)<<24>>24){a[w]=0;U=o;V=v;W=I-1|0;break}J=d[O]|0;if((J&1|0)==0){X=J>>>1}else{X=c[y+4>>2]|0}if((X|0)!=(m|0)){U=1;V=v;W=I;break}a[w]=2;U=1;V=v+1|0;W=I-1|0}else{U=o;V=v;W=I}}while(0);J=y+12|0;if((J|0)==(g|0)){Q=W;R=V;S=U;break L5334}I=W;v=V;w=w+1|0;o=U;y=J}}}while(0);if(!S){G=R;H=Q;break}m=c[u>>2]|0;y=m+12|0;o=c[y>>2]|0;if((o|0)==(c[m+16>>2]|0)){w=c[(c[m>>2]|0)+40>>2]|0;dR[w&255](m)|0}else{c[y>>2]=o+1}if((R+Q|0)>>>0<2>>>0|n){G=R;H=Q;break}o=t+1|0;y=R;m=p;w=f;while(1){do{if((a[m]|0)==2){v=d[w]|0;if((v&1|0)==0){Y=v>>>1}else{Y=c[w+4>>2]|0}if((Y|0)==(o|0)){Z=y;break}a[m]=0;Z=y-1|0}else{Z=y}}while(0);v=w+12|0;if((v|0)==(g|0)){G=Z;H=Q;break}else{y=Z;m=m+1|0;w=v}}}}while(0);t=t+1|0;x=G;s=H}do{if((A|0)==0){_=0}else{if((c[A+12>>2]|0)!=(c[A+16>>2]|0)){_=A;break}if((dR[c[(c[A>>2]|0)+36>>2]&255](A)|0)==-1){c[u>>2]=0;_=0;break}else{_=c[u>>2]|0;break}}}while(0);u=(_|0)==0;do{if(D){$=4912}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){if(u){break}else{$=4914;break}}if((dR[c[(c[B>>2]|0)+36>>2]&255](B)|0)==-1){c[b>>2]=0;$=4912;break}else{if(u^(B|0)==0){break}else{$=4914;break}}}}while(0);if(($|0)==4912){if(u){$=4914}}if(($|0)==4914){c[j>>2]=c[j>>2]|2}L5413:do{if(n){$=4919}else{u=f;B=p;while(1){if((a[B]|0)==2){aa=u;break L5413}b=u+12|0;if((b|0)==(g|0)){$=4919;break L5413}u=b;B=B+1|0}}}while(0);if(($|0)==4919){c[j>>2]=c[j>>2]|4;aa=g}if((q|0)==0){i=l;return aa|0}wX(q);i=l;return aa|0}function rj(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];rk(a,0,j,k,f,g,h);i=b;return}function rk(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;e=i;i=i+72|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+32|0;n=e+40|0;o=e+56|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==0){v=0}else if((u|0)==8){v=16}else if((u|0)==64){v=8}else{v=10}u=l|0;r0(n,h,u,m);xc(p|0,0,12);h=o;pQ(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=a[m]|0;m=w;w=c[h>>2]|0;L5437:while(1){do{if((w|0)==0){B=0}else{if((c[w+12>>2]|0)!=(c[w+16>>2]|0)){B=w;break}if((dR[c[(c[w>>2]|0)+36>>2]&255](w)|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);C=(B|0)==0;D=c[f>>2]|0;do{if((D|0)==0){E=4947}else{if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(C){F=D;G=0;break}else{H=m;I=D;J=0;break L5437}}if((dR[c[(c[D>>2]|0)+36>>2]&255](D)|0)==-1){c[f>>2]=0;E=4947;break}else{K=(D|0)==0;if(C^K){F=D;G=K;break}else{H=m;I=D;J=K;break L5437}}}}while(0);if((E|0)==4947){E=0;if(C){H=m;I=0;J=1;break}else{F=0;G=1}}D=d[p]|0;K=(D&1|0)==0;if(((c[q>>2]|0)-m|0)==((K?D>>>1:c[z>>2]|0)|0)){if(K){L=D>>>1;M=D>>>1}else{D=c[z>>2]|0;L=D;M=D}pQ(o,L<<1,0);if((a[p]&1)==0){N=10}else{N=(c[g>>2]&-2)-1|0}pQ(o,N,0);if((a[p]&1)==0){O=x}else{O=c[y>>2]|0}c[q>>2]=O+M;P=O}else{P=m}D=B+12|0;K=c[D>>2]|0;Q=B+16|0;if((K|0)==(c[Q>>2]|0)){R=(dR[c[(c[B>>2]|0)+36>>2]&255](B)|0)&255}else{R=a[K]|0}if((rC(R,v,P,q,t,A,n,l,s,u)|0)!=0){H=P;I=F;J=G;break}K=c[D>>2]|0;if((K|0)==(c[Q>>2]|0)){Q=c[(c[B>>2]|0)+40>>2]|0;dR[Q&255](B)|0;m=P;w=B;continue}else{c[D>>2]=K+1;m=P;w=B;continue}}w=d[n]|0;if((w&1|0)==0){S=w>>>1}else{S=c[n+4>>2]|0}do{if((S|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}P=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=P}}while(0);c[k>>2]=v9(H,c[q>>2]|0,j,v)|0;tV(n,l,c[s>>2]|0,j);do{if(C){T=0}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){T=B;break}if((dR[c[(c[B>>2]|0)+36>>2]&255](B)|0)!=-1){T=B;break}c[h>>2]=0;T=0}}while(0);h=(T|0)==0;L5497:do{if(J){E=4988}else{do{if((c[I+12>>2]|0)==(c[I+16>>2]|0)){if((dR[c[(c[I>>2]|0)+36>>2]&255](I)|0)!=-1){break}c[f>>2]=0;E=4988;break L5497}}while(0);if(!(h^(I|0)==0)){break}U=b|0;c[U>>2]=T;pN(o);pN(n);i=e;return}}while(0);do{if((E|0)==4988){if(h){break}U=b|0;c[U>>2]=T;pN(o);pN(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;U=b|0;c[U>>2]=T;pN(o);pN(n);i=e;return}function rl(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];rm(a,0,j,k,f,g,h);i=b;return}function rm(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;e=i;i=i+72|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+32|0;n=e+40|0;o=e+56|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==0){v=0}else if((u|0)==64){v=8}else if((u|0)==8){v=16}else{v=10}u=l|0;r0(n,h,u,m);xc(p|0,0,12);h=o;pQ(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=a[m]|0;m=w;w=c[h>>2]|0;L5522:while(1){do{if((w|0)==0){B=0}else{if((c[w+12>>2]|0)!=(c[w+16>>2]|0)){B=w;break}if((dR[c[(c[w>>2]|0)+36>>2]&255](w)|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);C=(B|0)==0;D=c[f>>2]|0;do{if((D|0)==0){E=5016}else{if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(C){F=D;G=0;break}else{H=m;I=D;J=0;break L5522}}if((dR[c[(c[D>>2]|0)+36>>2]&255](D)|0)==-1){c[f>>2]=0;E=5016;break}else{K=(D|0)==0;if(C^K){F=D;G=K;break}else{H=m;I=D;J=K;break L5522}}}}while(0);if((E|0)==5016){E=0;if(C){H=m;I=0;J=1;break}else{F=0;G=1}}D=d[p]|0;K=(D&1|0)==0;if(((c[q>>2]|0)-m|0)==((K?D>>>1:c[z>>2]|0)|0)){if(K){M=D>>>1;N=D>>>1}else{D=c[z>>2]|0;M=D;N=D}pQ(o,M<<1,0);if((a[p]&1)==0){O=10}else{O=(c[g>>2]&-2)-1|0}pQ(o,O,0);if((a[p]&1)==0){P=x}else{P=c[y>>2]|0}c[q>>2]=P+N;Q=P}else{Q=m}D=B+12|0;K=c[D>>2]|0;R=B+16|0;if((K|0)==(c[R>>2]|0)){S=(dR[c[(c[B>>2]|0)+36>>2]&255](B)|0)&255}else{S=a[K]|0}if((rC(S,v,Q,q,t,A,n,l,s,u)|0)!=0){H=Q;I=F;J=G;break}K=c[D>>2]|0;if((K|0)==(c[R>>2]|0)){R=c[(c[B>>2]|0)+40>>2]|0;dR[R&255](B)|0;m=Q;w=B;continue}else{c[D>>2]=K+1;m=Q;w=B;continue}}w=d[n]|0;if((w&1|0)==0){T=w>>>1}else{T=c[n+4>>2]|0}do{if((T|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}Q=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=Q}}while(0);t=v8(H,c[q>>2]|0,j,v)|0;c[k>>2]=t;c[k+4>>2]=L;tV(n,l,c[s>>2]|0,j);do{if(C){U=0}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){U=B;break}if((dR[c[(c[B>>2]|0)+36>>2]&255](B)|0)!=-1){U=B;break}c[h>>2]=0;U=0}}while(0);h=(U|0)==0;L5582:do{if(J){E=5057}else{do{if((c[I+12>>2]|0)==(c[I+16>>2]|0)){if((dR[c[(c[I>>2]|0)+36>>2]&255](I)|0)!=-1){break}c[f>>2]=0;E=5057;break L5582}}while(0);if(!(h^(I|0)==0)){break}V=b|0;c[V>>2]=U;pN(o);pN(n);i=e;return}}while(0);do{if((E|0)==5057){if(h){break}V=b|0;c[V>>2]=U;pN(o);pN(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;V=b|0;c[V>>2]=U;pN(o);pN(n);i=e;return}function rn(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];ro(a,0,j,k,f,g,h);i=b;return}function ro(e,f,g,h,j,k,l){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;f=i;i=i+72|0;m=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[m>>2];m=h;h=i;i=i+4|0;i=i+7&-8;c[h>>2]=c[m>>2];m=f|0;n=f+32|0;o=f+40|0;p=f+56|0;q=p;r=i;i=i+4|0;i=i+7&-8;s=i;i=i+160|0;t=i;i=i+4|0;i=i+7&-8;u=i;i=i+4|0;i=i+7&-8;v=c[j+4>>2]&74;if((v|0)==0){w=0}else if((v|0)==8){w=16}else if((v|0)==64){w=8}else{w=10}v=m|0;r0(o,j,v,n);xc(q|0,0,12);j=p;pQ(p,10,0);if((a[q]&1)==0){m=j+1|0;x=m;y=m;z=p+8|0}else{m=p+8|0;x=c[m>>2]|0;y=j+1|0;z=m}c[r>>2]=x;m=s|0;c[t>>2]=m;c[u>>2]=0;j=g|0;g=h|0;h=p|0;A=p+4|0;B=a[n]|0;n=x;x=c[j>>2]|0;L5607:while(1){do{if((x|0)==0){C=0}else{if((c[x+12>>2]|0)!=(c[x+16>>2]|0)){C=x;break}if((dR[c[(c[x>>2]|0)+36>>2]&255](x)|0)!=-1){C=x;break}c[j>>2]=0;C=0}}while(0);D=(C|0)==0;E=c[g>>2]|0;do{if((E|0)==0){F=5085}else{if((c[E+12>>2]|0)!=(c[E+16>>2]|0)){if(D){G=E;H=0;break}else{I=n;J=E;K=0;break L5607}}if((dR[c[(c[E>>2]|0)+36>>2]&255](E)|0)==-1){c[g>>2]=0;F=5085;break}else{L=(E|0)==0;if(D^L){G=E;H=L;break}else{I=n;J=E;K=L;break L5607}}}}while(0);if((F|0)==5085){F=0;if(D){I=n;J=0;K=1;break}else{G=0;H=1}}E=d[q]|0;L=(E&1|0)==0;if(((c[r>>2]|0)-n|0)==((L?E>>>1:c[A>>2]|0)|0)){if(L){M=E>>>1;N=E>>>1}else{E=c[A>>2]|0;M=E;N=E}pQ(p,M<<1,0);if((a[q]&1)==0){O=10}else{O=(c[h>>2]&-2)-1|0}pQ(p,O,0);if((a[q]&1)==0){P=y}else{P=c[z>>2]|0}c[r>>2]=P+N;Q=P}else{Q=n}E=C+12|0;L=c[E>>2]|0;R=C+16|0;if((L|0)==(c[R>>2]|0)){S=(dR[c[(c[C>>2]|0)+36>>2]&255](C)|0)&255}else{S=a[L]|0}if((rC(S,w,Q,r,u,B,o,m,t,v)|0)!=0){I=Q;J=G;K=H;break}L=c[E>>2]|0;if((L|0)==(c[R>>2]|0)){R=c[(c[C>>2]|0)+40>>2]|0;dR[R&255](C)|0;n=Q;x=C;continue}else{c[E>>2]=L+1;n=Q;x=C;continue}}x=d[o]|0;if((x&1|0)==0){T=x>>>1}else{T=c[o+4>>2]|0}do{if((T|0)!=0){x=c[t>>2]|0;if((x-s|0)>=160){break}Q=c[u>>2]|0;c[t>>2]=x+4;c[x>>2]=Q}}while(0);b[l>>1]=v7(I,c[r>>2]|0,k,w)|0;tV(o,m,c[t>>2]|0,k);do{if(D){U=0}else{if((c[C+12>>2]|0)!=(c[C+16>>2]|0)){U=C;break}if((dR[c[(c[C>>2]|0)+36>>2]&255](C)|0)!=-1){U=C;break}c[j>>2]=0;U=0}}while(0);j=(U|0)==0;L5667:do{if(K){F=5126}else{do{if((c[J+12>>2]|0)==(c[J+16>>2]|0)){if((dR[c[(c[J>>2]|0)+36>>2]&255](J)|0)!=-1){break}c[g>>2]=0;F=5126;break L5667}}while(0);if(!(j^(J|0)==0)){break}V=e|0;c[V>>2]=U;pN(p);pN(o);i=f;return}}while(0);do{if((F|0)==5126){if(j){break}V=e|0;c[V>>2]=U;pN(p);pN(o);i=f;return}}while(0);c[k>>2]=c[k>>2]|2;V=e|0;c[V>>2]=U;pN(p);pN(o);i=f;return}function rp(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];rq(a,0,j,k,f,g,h);i=b;return}function rq(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;e=i;i=i+72|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+32|0;n=e+40|0;o=e+56|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==0){v=0}else if((u|0)==64){v=8}else if((u|0)==8){v=16}else{v=10}u=l|0;r0(n,h,u,m);xc(p|0,0,12);h=o;pQ(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=a[m]|0;m=w;w=c[h>>2]|0;L5692:while(1){do{if((w|0)==0){B=0}else{if((c[w+12>>2]|0)!=(c[w+16>>2]|0)){B=w;break}if((dR[c[(c[w>>2]|0)+36>>2]&255](w)|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);C=(B|0)==0;D=c[f>>2]|0;do{if((D|0)==0){E=5154}else{if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(C){F=D;G=0;break}else{H=m;I=D;J=0;break L5692}}if((dR[c[(c[D>>2]|0)+36>>2]&255](D)|0)==-1){c[f>>2]=0;E=5154;break}else{K=(D|0)==0;if(C^K){F=D;G=K;break}else{H=m;I=D;J=K;break L5692}}}}while(0);if((E|0)==5154){E=0;if(C){H=m;I=0;J=1;break}else{F=0;G=1}}D=d[p]|0;K=(D&1|0)==0;if(((c[q>>2]|0)-m|0)==((K?D>>>1:c[z>>2]|0)|0)){if(K){L=D>>>1;M=D>>>1}else{D=c[z>>2]|0;L=D;M=D}pQ(o,L<<1,0);if((a[p]&1)==0){N=10}else{N=(c[g>>2]&-2)-1|0}pQ(o,N,0);if((a[p]&1)==0){O=x}else{O=c[y>>2]|0}c[q>>2]=O+M;P=O}else{P=m}D=B+12|0;K=c[D>>2]|0;Q=B+16|0;if((K|0)==(c[Q>>2]|0)){R=(dR[c[(c[B>>2]|0)+36>>2]&255](B)|0)&255}else{R=a[K]|0}if((rC(R,v,P,q,t,A,n,l,s,u)|0)!=0){H=P;I=F;J=G;break}K=c[D>>2]|0;if((K|0)==(c[Q>>2]|0)){Q=c[(c[B>>2]|0)+40>>2]|0;dR[Q&255](B)|0;m=P;w=B;continue}else{c[D>>2]=K+1;m=P;w=B;continue}}w=d[n]|0;if((w&1|0)==0){S=w>>>1}else{S=c[n+4>>2]|0}do{if((S|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}P=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=P}}while(0);c[k>>2]=v6(H,c[q>>2]|0,j,v)|0;tV(n,l,c[s>>2]|0,j);do{if(C){T=0}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){T=B;break}if((dR[c[(c[B>>2]|0)+36>>2]&255](B)|0)!=-1){T=B;break}c[h>>2]=0;T=0}}while(0);h=(T|0)==0;L5752:do{if(J){E=5195}else{do{if((c[I+12>>2]|0)==(c[I+16>>2]|0)){if((dR[c[(c[I>>2]|0)+36>>2]&255](I)|0)!=-1){break}c[f>>2]=0;E=5195;break L5752}}while(0);if(!(h^(I|0)==0)){break}U=b|0;c[U>>2]=T;pN(o);pN(n);i=e;return}}while(0);do{if((E|0)==5195){if(h){break}U=b|0;c[U>>2]=T;pN(o);pN(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;U=b|0;c[U>>2]=T;pN(o);pN(n);i=e;return}function rr(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];rs(a,0,j,k,f,g,h);i=b;return}function rs(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0;e=i;i=i+72|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+32|0;n=e+40|0;o=e+56|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==0){v=0}else if((u|0)==8){v=16}else if((u|0)==64){v=8}else{v=10}u=l|0;r0(n,h,u,m);xc(p|0,0,12);h=o;pQ(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=a[m]|0;m=w;w=c[h>>2]|0;L5777:while(1){do{if((w|0)==0){B=0}else{if((c[w+12>>2]|0)!=(c[w+16>>2]|0)){B=w;break}if((dR[c[(c[w>>2]|0)+36>>2]&255](w)|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);C=(B|0)==0;D=c[f>>2]|0;do{if((D|0)==0){E=5223}else{if((c[D+12>>2]|0)!=(c[D+16>>2]|0)){if(C){F=D;G=0;break}else{H=m;I=D;J=0;break L5777}}if((dR[c[(c[D>>2]|0)+36>>2]&255](D)|0)==-1){c[f>>2]=0;E=5223;break}else{K=(D|0)==0;if(C^K){F=D;G=K;break}else{H=m;I=D;J=K;break L5777}}}}while(0);if((E|0)==5223){E=0;if(C){H=m;I=0;J=1;break}else{F=0;G=1}}D=d[p]|0;K=(D&1|0)==0;if(((c[q>>2]|0)-m|0)==((K?D>>>1:c[z>>2]|0)|0)){if(K){L=D>>>1;M=D>>>1}else{D=c[z>>2]|0;L=D;M=D}pQ(o,L<<1,0);if((a[p]&1)==0){N=10}else{N=(c[g>>2]&-2)-1|0}pQ(o,N,0);if((a[p]&1)==0){O=x}else{O=c[y>>2]|0}c[q>>2]=O+M;P=O}else{P=m}D=B+12|0;K=c[D>>2]|0;Q=B+16|0;if((K|0)==(c[Q>>2]|0)){R=(dR[c[(c[B>>2]|0)+36>>2]&255](B)|0)&255}else{R=a[K]|0}if((rC(R,v,P,q,t,A,n,l,s,u)|0)!=0){H=P;I=F;J=G;break}K=c[D>>2]|0;if((K|0)==(c[Q>>2]|0)){Q=c[(c[B>>2]|0)+40>>2]|0;dR[Q&255](B)|0;m=P;w=B;continue}else{c[D>>2]=K+1;m=P;w=B;continue}}w=d[n]|0;if((w&1|0)==0){S=w>>>1}else{S=c[n+4>>2]|0}do{if((S|0)!=0){w=c[s>>2]|0;if((w-r|0)>=160){break}P=c[t>>2]|0;c[s>>2]=w+4;c[w>>2]=P}}while(0);c[k>>2]=v5(H,c[q>>2]|0,j,v)|0;tV(n,l,c[s>>2]|0,j);do{if(C){T=0}else{if((c[B+12>>2]|0)!=(c[B+16>>2]|0)){T=B;break}if((dR[c[(c[B>>2]|0)+36>>2]&255](B)|0)!=-1){T=B;break}c[h>>2]=0;T=0}}while(0);h=(T|0)==0;L5837:do{if(J){E=5264}else{do{if((c[I+12>>2]|0)==(c[I+16>>2]|0)){if((dR[c[(c[I>>2]|0)+36>>2]&255](I)|0)!=-1){break}c[f>>2]=0;E=5264;break L5837}}while(0);if(!(h^(I|0)==0)){break}U=b|0;c[U>>2]=T;pN(o);pN(n);i=e;return}}while(0);do{if((E|0)==5264){if(h){break}U=b|0;c[U>>2]=T;pN(o);pN(n);i=e;return}}while(0);c[j>>2]=c[j>>2]|2;U=b|0;c[U>>2]=T;pN(o);pN(n);i=e;return}function rt(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0;b=i;i=i+16|0;j=d;d=i;i=i+4|0;i=i+7&-8;c[d>>2]=c[j>>2];j=e;e=i;i=i+4|0;i=i+7&-8;c[e>>2]=c[j>>2];j=b|0;k=b+8|0;c[j>>2]=c[d>>2];c[k>>2]=c[e>>2];ru(a,0,j,k,f,g,h);i=b;return}function ru(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;e=i;i=i+72|0;l=f;f=i;i=i+4|0;i=i+7&-8;c[f>>2]=c[l>>2];l=g;g=i;i=i+4|0;i=i+7&-8;c[g>>2]=c[l>>2];l=e|0;m=e+32|0;n=e+40|0;o=e+56|0;p=o;q=i;i=i+4|0;i=i+7&-8;r=i;i=i+160|0;s=i;i=i+4|0;i=i+7&-8;t=i;i=i+4|0;i=i+7&-8;u=c[h+4>>2]&74;if((u|0)==0){v=0}else if((u|0)==64){v=8}else if((u|0)==8){v=16}else{v=10}u=l|0;r0(n,h,u,m);xc(p|0,0,12);h=o;pQ(o,10,0);if((a[p]&1)==0){l=h+1|0;w=l;x=l;y=o+8|0}else{l=o+8|0;w=c[l>>2]|0;x=h+1|0;y=l}c[q>>2]=w;l=r|0;c[s>>2]=l;c[t>>2]=0;h=f|0;f=g|0;g=o|0;z=o+4|0;A=a[m]|0;m=w;w=c[h>>2]|0;L5862:while(1){do{if((w|0)==0){B=0}else{if((c[w+12>>2]|0)!=(c[w+16>>2]|0)){B=w;break}if((dR[c[(c[w>>2]|0)+36>>2]&255](w)|0)!=-1){B=w;break}c[h>>2]=0;B=0}}while(0);C=(B|0)==0;D=c[f>>2]|0;do{if((D|0)==0){E=5292}else{if(