//geolocalisation
function initMap() {
    	  var directionsService = new google.maps.DirectionsService;
    	  var directionsDisplay = new google.maps.DirectionsRenderer;
		  //option du map
    	  var myOptions = {
        	    zoom: 15,
        	    center: {lat: -18.938190, lng: 47.521778}
    	  };
    	  //initialisation du map
    	  var map = new google.maps.Map(document.getElementById('map'), myOptions);7
    	  function successCallback(position){
    		  var latitude = position.coords.latitude;
    		  var longitude = position.coords.longitude;
   			  var currentLocation = new google.maps.LatLng(latitude, longitude);
   			  directionsDisplay.setMap(map);
			  directionsDisplay.setPanel(document.getElementById('panel'));
  		  }
    	  function errorCallback(){
    		  document.getElementById('dynamicdata').innerHTML=	"On peut pas vous localiser";
    	  }
    	  
    	  if("geolocation" in navigator) {
    		  navigator.geolocation.watchPosition(successCallback, errorCallback);
        	  var onChangeHandler = function() {
          	    calculateAndDisplayRoute(directionsService, directionsDisplay);
          	  };
          	  document.getElementById('dest').addEventListener('change', onChangeHandler);
    	  }
    	  else {
    		  document.getElementById('dynamicdata').innerHTML= "Geolocalisation non disponible."
    	  }
    	  
    	  
    	}
		
		var lat1= -18.938190;
		var lng1= 47.521778;
    	function calculateAndDisplayRoute(directionsService, directionsDisplay, position)	{
    	  directionsService.route({
    	    origin: {lat: lat1, lng: lng1},
    	    destination: document.getElementById('dest').value,
    	    travelMode: google.maps.TravelMode.DRIVING
    	  }, function(response, status) {
    	    if (status === google.maps.DirectionsStatus.OK) {
    	      directionsDisplay.setDirections(response);
    	    } else {
    	      window.alert('Directions request failed due to ' + status);
    	    }
    	  });
    	}
    	
    	function calcRoute() {
    		  var dest = document.getElementById("dest").value;
    		  var request = {
    		    origin: {lat: lat1, lng: lng1},
    		    destination: dest,
    		    travelMode: google.maps.TravelMode.DRIVING
    		  };
    		  directionsService.route(request, function(result, status) {
    		    if (status == google.maps.DirectionsStatus.OK) {
    		      directionsDisplay.setDirections(result);
    		    }
    		  });
    		}
    	
var reload = document.querySelector("#reload");
if (reload) {
    reload.onclick = function () {
        location.reload(true);
    };
}