'use strict';

var Config = {
	UserName: "",
	Password: "",
	Uuid: "",
	Brand: "",
	AskDirection: false,

	Load: function ()
	{
		var settings = window.localStorage;
		this.UserName = settings.getItem("UserName");
		this.Uuid = settings.getItem("PhoneUuid");
		this.Password = Utils.Decrypt(settings.getItem("PC1"));
		this.Brand = settings.getItem("Brand");
		this.AskDirection = settings.getItem("AskDirection") == "true";
	},

	Save: function ()
	{
		var settings = window.localStorage;
		if (this.Uuid != null) settings.setItem("PhoneUuid", this.Uuid);
		if (this.UserName != null) settings.setItem("UserName", this.UserName);
		if (this.Password != null) settings.setItem("PC1", Utils.Encrypt(this.Password));
		if (this.Brand != null) settings.setItem("Brand", this.Brand);
		if (this.AskDirection != null) settings.setItem("AskDirection", this.AskDirection);
	},

	SetAskDirection: function()
	{
		if (!this.AskDirection)
		{
			this.AskDirection = true;
			window.localStorage.setItem("AskDirection", true);
		}
	},

	CreateUuid: function ()
	{
		if (!this.Uuid)
		{
			this.Uuid = Utils.NewGuid();
			this.AskDirection = true;
			this.Save();
		}
	}
};
