'use strict';

var RM = {
	Append: function (lang)
	{
		var xhr = new XMLHttpRequest();
		xhr.overrideMimeType("text/plain");
		xhr.open("GET", "language/" + lang + ".txt", true);
		xhr.onload = this.Parse.bind(this, lang);
		xhr.send();
	},

	Parse: function (lang, e)
	{
		var lines = e.target.response.match(/[^\r\n]+/g);
		for (var i = 0; i < lines.length; i++)
		{
			var m = lines[i].match(/^([^=\s]+)\s*=\s*(.*)$/);
			if (m)
			{
				var text = m[2].replace(/\\n/g, '\n').replace(/&/g, '');
				//text = "" + text + "";
				this.Dict[m[1]] = text;
			}
		}
		this.LangCode = lang;
	},

	Load: function (lang)
	{
		this.Dict = {};
		this.Append("en");
		try
		{
			if (lang.length > 2 && lang[2] == '-') lang = lang.substr(0, 2);
			if (lang != "en") this.Append(lang);
		}
		catch (ex) { }
	},

	GetString: function (key)
	{
		var value = this.Dict[key];
		return value ? value : key;
	},

	Translate: function ()
	{
		var nodes = document.querySelectorAll('*[id]');
		for (var i = 0; i < nodes.length; i++)
		{
			var el = nodes[i];
			var value = this.Dict[el.id];
			if (value)
			{
				var typ = el.getAttribute("type");
				if (typ == "checkbox" || typ == "radio")
				{
					var lbl = el.nextSibling;
					if (lbl.getAttribute("for") == el.id) lbl.textContent = value
				}
				else
				{
					el.textContent = value;
				}
			}
		}
	},

	FixUrl: function(id)
	{
		var a = $(id);
		a.href = a.href.replace("/en/", '/' + this.LangCode + '/');
	}
};

RM.Load(navigator.language);
