'use strict';

function LoadCaptcha()
{
	$("lblLoadingCaptcha").hidden = false;
	$("lblMessage").textContent = "";

	Synchronization.InitRemote();

	//get ticket
	Synchronization.remote.RequestTicket(
	function (url)
	{
		//download captcha
		$("imgCaptcha").src = Remote.prototype.PhoneCopyUrl + url.substr(1);
		$("imgCaptcha").onload = function ()
		{
			$("imgCaptcha").hidden = false;
			$("btnSignUp").disabled = false;
			$("lblLoadingCaptcha").hidden = true;
		}
	});
};

window.addEventListener("DOMContentLoaded", function ()
{
	RM.Translate();
	RM.FixUrl("lnkTerms2");
	RM.FixUrl("lnkPrivacy");

	Config.Load();
	$("ddlTimezone").value = "Europe/London";
	LoadCaptcha();
});

$('btnSignUp').addEventListener('click', function ()
{
	$("pnlButtons").hidden = true;

	var err;
	var username = $("txtUsername").value;
	var password = $("txtPassword").value;
	var captcha = $("txtCaptcha").value;
	var email = $("txtEmail").value;
	var zone = $("ddlTimezone").value;
	var focus;

	if ($("txtConfirm").value != password)
	{
		err = "errPwdMatch";
		focus = "txtConfirm";
	}
	else if (!username)
	{
		err = "reqUser";
		focus = "txtUsername";
	}
	else if (username.length < 3)
	{
		err = "errUserLen";
		focus = "txtUsername";
	}
	else if (password.length < 5)
	{
		err = "errPwdLen";
		focus = "txtPassword";
	}
	else if (!email)
	{
		err = "reqEmail";
		focus = "txtEmail";
	}
	else if (!/^[a-zA-Z0-9_]+([-+.][a-zA-Z0-9_]+)*@[a-zA-Z0-9_]+([-.][a-zA-Z0-9_]+)*\.[a-zA-Z0-9]{2,6}$/.test(email))
	{
		err = "errEmail";
		focus = "txtEmail";
	}
	else if (!captcha)
	{
		err = "reqCaptcha";
		focus = "txtCaptcha";
	}
	else if (!chkEULA.checked)
	{
		err = "reqTerms";
		focus = "chkEULA";
	}
	else
	{
		Synchronization.InitRemote();
		Synchronization.remote.UserData =
		{
			Username: username,
			Password: password,
			Uuid: Config.Uuid
		};
		Synchronization.remote.Register(captcha, email, zone,
		function ()
		{
			//save username and password
			Config.UserName = username;
			Config.Password = password;
			Config.Save();

			//registration successful
			if (Synchronization.remote.UserData.UserId)
			{
				alert(RM.GetString("RegistrationSuccess").replace("{0}", email));
			}
			window.location = "index.html";
		});
	}

	if (err)
	{
		ShowError(RM.GetString(err));
		if (focus) $(focus).focus();
	}
});

function ShowError(err)
{
	$("pnlButtons").hidden = false;
	$("lblMessage").textContent = err;
}

$('btnCancel').addEventListener('click', function ()
{
	window.location = "index.html";
});
