'use strict';

var AppVersion = "1.2";

function Remote() { }
Remote.prototype = {
	PHONECOPY_REST_PROTOCOL: "3",
	REST_HEADER: "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
			"<restsync xmlns=\"http://restsync.org/ns/restsync/1/\">\n",
	PhoneCopyUrl: "https://www.phonecopy.com/",

	Request: function (url, method, authType, body, onsuccess, responseType)
	{
		var _this = this;
		var secondRequest = false;
		this.Method = method;

		(function Request1()
		{
			if (url.substr(0, 4) != "http")
			{
				while (url.length > 0 && url.charAt(0) == '/') url = url.substr(1);
				url = _this.PhoneCopyUrl + url;
			}

			// mozSystem is necessary to avoid CORS errors (Cross Origin Resource Sharing)
			var req = new XMLHttpRequest({ mozSystem: true });
			req.onload = function ()
			{
				if (this.status == 401 && authType == "Digest" && !secondRequest)
				{
					secondRequest = true;
					_this.ParseDigest(this.getResponseHeader("WWW-Authenticate"));
					Request1();
				}
				else if (this.status == 500)
				{
					var err = Remote.prototype.ParseError(this.responseXML);
					if (!err) err = this.statusText;
					Program.SyncException(err);
				}
				else
				{
					onsuccess.call(this);
				}
			}
			req.onerror = function ()
			{
				Program.Exception(RM.GetString("errNetwork"));
			};

			if (authType == "Basic")
				req.open(method, url, true, _this.UserData.Username, _this.UserData.Password);
			else
				req.open(method, url, true);

			if (method != "GET") req.setRequestHeader("Content-Type", "application/xml");
			if (responseType) req.responseType = responseType;

			if (authType == "Digest" && _this._cnonce && _this._user == _this.UserData.RestUsername && _this._password == _this.UserData.RestPassword)
				req.setRequestHeader("Authorization", _this.GetAuthorizationHeader(url));

			if (typeof body == "function") body(function (_body) { req.send(_body); });
			else req.send(body);
		})();
	},

	ParseDeviceOrUser: function (response)
	{
		var x0, x1, x2, c0, c1, i0, i1;
		var UserData = this.UserData;

		if (response)
		{
			x0 = response.documentElement;
			if (x0)
			{
				c0 = Utils.ChildNodes(x0);
				for (i0 = 0; i0 < c0.length; i0++)
				{
					x1 = c0[i0];
					if (Utils.XmlNodeName(x1) == "device")
					{
						c1 = Utils.ChildNodes(x1);
						for (i1 = 0; i1 < c1.length; i1++)
						{
							x2 = c1[i1];
							switch (Utils.XmlNodeName(x2))
							{
								case "username":
									UserData.RestUsername = Utils.XmlNodeText(x2);
									break;
								case "password":
									UserData.RestPassword = Utils.XmlNodeText(x2);
									break;
								case "id":
									UserData.RestDeviceId = Utils.XmlNodeText(x2);
									break;
							}
						}
					}
					if (Utils.XmlNodeName(x1) == "user")
					{
						UserData.PremiumUntilDate = null;
						c1 = Utils.ChildNodes(x1);
						for (i1 = 0; i1 < c1.length; i1++)
						{
							x2 = c1[i1];
							switch (Utils.XmlNodeName(x2))
							{
								case "id":
									UserData.UserId = Utils.XmlNodeText(x2);
									break;
								case "premiumUntil":
									UserData.PremiumUntilDate = Date.parse(Utils.XmlNodeText(x2));
									break;
							}
						}
					}
				}
			}
		}
	},

	Login: function (onsuccess)
	{
		var _this = this;
		this.Request("ws/rest/users/login", "POST", "", this.REST_HEADER + this.DeviceInfo() +
			"	<user>\n" +
			"		<username>" + Utils.XmlEncode(this.UserData.Username) + "</username>\n" +
			"		<password>" + Utils.XmlEncode(this.UserData.Password) + "</password>\n" +
			"	</user>\n" +
			"</restsync>\n",
		function ()
		{
			_this.ParseDeviceOrUser(this.responseXML);
			if (!parseInt(_this.UserData.UserId)) return Program.FatalException(RM.GetString("errServerLogin"));
			onsuccess();
		});
	},

	DeviceInfo: function ()
	{
		var m = navigator.userAgent.match(/Firefox\/(\d+)/);
		return "	<device>\n" +
			"		<manufacturer>PhoneCopy.com</manufacturer>\n" +
			"		<name>Firefox OS</name>\n" +
			"		<model>PhoneCopy for Firefox OS " + (m ? m[1] : "") + "</model>\n" +
			"		<version>" + AppVersion + "</version>\n" +
			"		<appName>PhoneCopy for Firefox OS</appName>\n" +
			"		<appVersion>" + AppVersion + "</appVersion>\n" +
			"		<uuid>" + this.UserData.Uuid + "</uuid>\n" +
			"		<protocol>" + this.PHONECOPY_REST_PROTOCOL + "</protocol>\n" +

			(this.UserData && this.UserData.RestUsername ?
			"		<username>" + this.UserData.RestUsername + "</username>\n" +
			"		<password>" + this.UserData.RestPassword + "</password>\n" : "") +
			"	</device>\n";
	},

	CreateRestDevice: function (onsuccess)
	{
		//the first synchronization can't be fast
		if (Synchronization.SyncDirection == "fast")
		{
			Synchronization.ChooseDirection();
			return;
		}

		if (!parseInt(this.UserData.UserId))
			return Program.FatalException(RM.GetString("errServerUserId") + " " + this.UserData.UserId);

		//create new device
		var _this = this;
		this.Request("ws/rest/device/", "POST", "", this.REST_HEADER +
			this.DeviceInfo() +
			"</restsync>",
			function ()
			{
				_this.ParseDeviceOrUser(this.responseXML);

				var UserData = _this.UserData;

				if (!UserData.RestDeviceId)
					return Program.FatalException(RM.GetString("errServerDeviceId"));

				//associate device with user,
				//ignore result, because it contains UserId inside device element
				_this.Request("ws/rest/user/" + UserData.UserId + "/devices", "POST", "Basic",
					_this.REST_HEADER +
					"	<device>\n" +
					"		<type>rest</type>\n" +
					"		<username>" + UserData.RestUsername + "</username>\n" +
					"		<password>" + UserData.RestPassword + "</password>\n" +
					"		<id>" + UserData.RestDeviceId + "</id>\n" +
					"	</device>\n" +
					"</restsync>\n", onsuccess);
			});
	},

	/*
	CheckDevice: function (onsuccess)
	{
		this.Request("ws/rest/user/" + this.UserData.UserId + "/devices/" + this.UserData.RestDeviceId,
			"GET", "Basic", "",
		function ()
		{
			if (this.status == 404)
			{
				// recreate REST device if user deleted it by web
				_this.CreateRestDevice(onsuccess);
			}
			else onsuccess();
		});
	},
	*/

	GetInfo: function (onsuccess)
	{
		this.Request("ws/rest/device/" + this.UserData.RestDeviceId + "/info", "GET", "Digest", null, onsuccess);
	},

	SyncBegin: function (pimTypes, onsuccess)
	{
		if (!Synchronization.SyncDirection) return Program.FatalException("Unknown sync direction");
		if (Synchronization.SyncDirection == "fast") Synchronization.SyncDirection = "twoway";

		var _this = this;
		this.Request("ws/rest/device/" + this.UserData.RestDeviceId + "/sync", "POST", "Digest",
			this.REST_HEADER + this.DeviceInfo() +
			"	<sync>\n" +
			"		<meta>\n" +
			"			<slow/>\n" +
			"			<way type=\"" + Synchronization.SyncDirection + "\"/>\n" +
			"			<pimtypes>\n" +
			"				" + pimTypes + "\n" +
			"			</pimtypes>\n" +
			"		</meta>\n" +
			"	</sync>\n" +
			"</restsync>\n",
		function ()
		{
			if (this.status == 401) //bad username/password or device has been deleted
			{
				/*if (!_this.deviceChecked)
				{
					_this.deviceChecked = true;
					_this.CheckDevice(function ()
					{
						//try again
						_this.SyncBegin1(pimTypes, onsuccess);
					});
					return;
				}*/
				return Program.FatalException(this.statusText);
			}

			var x = this.responseXML;
			var x2 = x && Utils.SelectSingleNode(x, "sync/meta/id");
			if (!x2) return Program.FatalException(RM.GetString("errServerSession"));
			_this.SyncUrl = Utils.XmlAttribute(x2, "xlink:href");
			onsuccess();
		});
	},

	ParseAck: function (x)
	{
		if (x && !Utils.SelectSingleNode(x, "sync/meta/ack"))
			Program.FatalException(RM.GetString("errServerACK"));
	},

	SyncPut: function (data, onsuccess)
	{
		var _this = this;
		this.Request(this.SyncUrl, "PUT", "Digest", data,
		function ()
		{
			_this.ParseAck(this.responseXML);
			onsuccess();
		});
	},

	SyncGet: function (onsuccess)
	{
		this.Request(this.SyncUrl, "GET", "Digest", null, onsuccess);
	},

	SyncLuid: function (list, onsuccess)
	{
		var _this = this;
		var s = this.REST_HEADER +
			"	<sync number=\"" + (++this.SyncCounter) + "\">\n" +
			"		<meta>\n" +
			"			<final/>\n" +
			"		</meta>\n\n";
		list.forEach(function (item)
		{
			if (item.modificationType == "created")
				s += "		<map>\n" +
					"			<number>" + item.number + "</number>\n" +
					"			<luid>" + item.luid + "</luid>\n" +
					"		</map>\n";
		});
		this.Request(this.SyncUrl, "PUT", "Digest", s +
			"	</sync>\n" +
			"</restsync>",
		function ()
		{
			_this.ParseAck(this.responseXML);
			onsuccess();
		});
	},

	RequestTicket: function (onsuccess)
	{
		var _this = this;
		this.Request("ws/rest/users/ticket", "POST", "", "",
		function ()
		{
			var x2 = Utils.SelectSingleNode(this.responseXML, "ticket/id");
			_this.ticketId = Utils.XmlNodeText(x2);
			onsuccess(Utils.XmlAttribute(x2, "xlink:href"));
		});
	},

	GetCaptcha: function (url, onsuccess)
	{
		this.Request(url, "GET", "", "", onsuccess, "blob");
	},

	Register: function (captcha, email, timezone, onsuccess)
	{
		var _this = this;
		this.Request("ws/rest/users/registration", "POST", "", this.REST_HEADER +
			this.DeviceInfo() +
			"	<user>\n" +
			"		<username>" + Utils.XmlEncode(this.UserData.Username) + "</username>\n" +
			"		<password>" + Utils.XmlEncode(this.UserData.Password) + "</password>\n" +
			"		<email>" + Utils.XmlEncode(email) + "</email>\n" +
			"		<ticket>" + _this.ticketId + "</ticket>\n" +
			"		<captcha>" + Utils.XmlEncode(captcha) + "</captcha>\n" +
			"		<timezone format=\"location\">" + timezone + "</timezone>\n" +
			"	</user>\n" +
			"</restsync>\n",
		function ()
		{
			_this.ParseDeviceOrUser(this.responseXML);
			onsuccess();
		});
	},

	ParseError: function (doc)
	{
		var err = null;
		if (doc)
		{
			var x = Utils.SelectSingleNode(doc, "error/message");
			if (x) err = Utils.XmlNodeText(x);
			x = Utils.SelectSingleNode(doc, "error/form");
			if (x)
			{
				var c0 = Utils.ChildNodes(x);
				for (var i0 = 0; i0 < c0.length; i0++)
				{
					var x2 = c0[i0];
					err += "\r\n" + Utils.XmlNodeName(x2) + ": " + Utils.XmlNodeText(x2);
				}
			}
		}
		return err;
	},

	ParseDigest: function (wwwAuthValue)
	{
		if (!wwwAuthValue) return;
		var regex = /(\w+)\s*=\s*((\")([^\"]*)(\3)|([^,]*))/g;
		var authKeys = {};
		var match;
		while ((match = regex.exec(wwwAuthValue)) != null)
		{
			authKeys[match[1]] = match[4] || match[6];
		}
		this._realm = authKeys["realm"];
		this._nonce = authKeys["nonce"];
		this._opaque = authKeys["opaque"];
		this._cnonce = Utils.NewGuid().replace(/-/g, "");
		this._nonceCount = 0;
		this._user = this.UserData.RestUsername;
		this._password = this.UserData.RestPassword;
	},

	GetAuthorizationHeader: function (url)
	{
		this._nonceCount++;
		var nc = ('00000000' + this._nonceCount.toString(16)).slice(-8);
		if (url.substr(0, 7) == "http://") url = url.substr(url.indexOf('/', 7));
		else if (url[0] != '/') url = '/' + url;

		var ha1 = md5(this._user + ':' + this._realm + ':' + this._password);
		var ha2 = md5(this.Method + ':' + url);
		var response = md5(ha1 + ':' + this._nonce + ':' + nc + ':' + this._cnonce + ":auth:" + ha2);
		return "Digest username=\"" + this._user + "\"," + " realm=\"" + this._realm + "\"," + " nonce=\"" + this._nonce + "\"," +
			" uri=\"" + url + "\"," + " algorithm=\"MD5\"," + " qop=auth," +
			" nc=" + nc + "," + " cnonce=\"" + this._cnonce + "\"," + " response=\"" + response + "\"" +
			(this._opaque ? ", opaque=\"" + this._opaque + "\"" : "");
	}

};
