'use strict';

var ContactList;
var outputSync = $('lblOutput');


function ShowLogo()
{
	var logo = Config.Brand ? (Config.Brand + "windowsphone_logo.png") : "images/PhoneCopy.png";
	if (logo.indexOf("https://rc.") == 0) logo = "http" + logo.substr(5); //rc server has not trusted certificate
	$("logo").src = logo;
}

window.addEventListener("DOMContentLoaded", function ()
{
	RM.Translate();
	RM.FixUrl("lnkTerms2");
	RM.FixUrl("lnkPrivacy");

	//load configuration
	Config.Load();
	$("txtLogin").value = Config.UserName;
	$("txtPassword").value = Config.Password;

	ShowLogo();

	outputSync.textContent = RM.GetString("lblVersion") + ": " + AppVersion;
});

function save()
{
	var config = Config;
	config.UserName = $("txtLogin").value;
	config.Password = $("txtPassword").value;
	config.Save();
};

function sync()
{
	outputSync.style.color = "inherit";
	Synchronization.OnSetProgressText("progressReadContact");

	//get contacts
	ContactList = [];
	var cursor = navigator.mozContacts.getAll({});

	cursor.onsuccess = function ()
	{
		var contact = cursor.result;
		if (contact)
		{
			//add a contact to the array
			var item = new ContactItem(contact);
			ContactList.push(item);
			//item.SerializePim(function (pim) { console.log(pim.length + " " + pim); });
			cursor["continue"]();
		}
		else
		{
			//synchronize
			Synchronization.LoginAndSynchronize();
		}
	};
	cursor.onerror = function (ev)
	{
		var name = "";
		try
		{
			name = ev.target.error.name;
		}
		catch (ex) { }
		var msg = RM.GetString("errContacts");
		if (name == "Not Allowed") ShowError(msg);
		else Program.FatalException(msg + ": " + name);
	};
};

$('btnSyncContact').addEventListener('click', function ()
{
	$("pnlButtons").style.visibility = 'hidden';
	save();
	Synchronization.SyncDirection = "fast";
	sync();
});

$('btnContinue').addEventListener('click', function ()
{
	Synchronization.SyncDirection = document.querySelector('input[name=direction]:checked').value;
	$('btnContinue').disabled = true;
	$('pnlMain').hidden = false;
	$('pnlDirection').hidden = true;
	sync();
});

function rdbDirectionClick() { $('btnContinue').disabled = false; }
$('rdbFromClient').addEventListener('click', rdbDirectionClick);
$('rdbFromServer').addEventListener('click', rdbDirectionClick);
$('rdbTwoWay').addEventListener('click', rdbDirectionClick);

//$('btnLogout').addEventListener('click', function ()
//{
//	window.localStorage.clear();
//	$("txtLogin").value = "";
//	$("txtPassword").value = "";
//});

$('btnRegister').addEventListener('click', function ()
{
	window.location = "register.html";
});

function ShowError(message)
{
	$('pnlMain').hidden = false;
	$('pnlDirection').hidden = true;
	$("pnlButtons").style.visibility = 'visible';
	if (message) outputSync.style.color = "red";
	outputSync.textContent = message;
};
