'use strict';

var Synchronization =
{
	BatchSize: 210000,

	InitRemote: function ()
	{
		if (!this.remote) this.remote = new Remote();

		Config.CreateUuid();

		var remote = this.remote;
		remote.UserData = {};
		remote.UserData.Username = Config.UserName;
		remote.UserData.Uuid = Config.Uuid;
		remote.UserData.Password = Config.Password;
	},

	LoginAndSynchronize: function ()
	{
		if (!Config.UserName) return Program.SyncException(RM.GetString("errNoUser"));

		this.InitRemote();

		var remote = this.remote;

		this.OnSetProgressText("progressConnect");

		var _this = this;

		remote.Login(function ()
		{
			if (!remote.UserData.RestDeviceId)
			{
				_this.OnSetProgressText("progressDevice");
				Config.SetAskDirection();
				_this.CreateRestDevice();
				return;
			}
			if ((Config.AskDirection || ContactList.length == 0) && _this.SyncDirection == "fast")
			{
				_this.ChooseDirection();
				return;
			}

			_this.Synchronize();
		});
	},

	CreateRestDevice: function ()
	{
		var user = this.remote.UserData;
		user.RestUsername = Utils.NewGuid();
		user.RestPassword = Utils.NewGuid();
		var _this = this;
		this.remote.CreateRestDevice(function () { _this.Synchronize(); });
	},

	GetInfo: function (onsuccess)
	{
		var _this = this;
		this.remote.GetInfo(
		function ()
		{
			var x = this.responseXML;
			if (x)
			{
				var x2 = Utils.SelectSingleNode(x, "info/branding");
				var brand = x2 ? Utils.XmlNodeText(x2) : "";
				if (brand != Config.Brand)
				{
					_this.OnSetProgressText("progressLogo");
					Config.Brand = brand;
					Config.Save();
					ShowLogo();
				}
			}
			onsuccess();
		});
	},

	SendBatch: function (onsuccess)
	{
		var s = this.remote.REST_HEADER + "<sync number=\"" + (++this.remote.SyncCounter) + "\">" +
			"<meta>" + (this.IsFinal ? "<final/>" : "") +
			"<anchor>" + this.Anchor + "</anchor></meta>";
		var _this = this;

		(function SerializeItem()
		{
			if (_this.ItemsBatch.length > 0)
			{
				var item = _this.ItemsBatch.shift();
				item.Serialize(++_this.ModificationNumber,
				function (xml)
				{
					s += xml;
					SerializeItem();
				});
			}
			else
			{
				onsuccess(s + "</sync></restsync>");
			}
		})();
	},

	SynchronizeFromClient: function (onsuccess)
	{
		var list;
		if (this.SyncDirection == "fromserver")
			list = [];
		else
			list = ContactList;

		//total estimated size
		var total = list.reduce(function (previousValue, item)
		{
			return previousValue + item.EstimateSize();
		}, 0);

		this.remote.SyncCounter = 0;
		this.IsFinal = false;
		this.ModificationNumber = 0;
		this.Anchor = Date.now();

		var sendBatch = this.SendBatch.bind(this);
		var _this = this;
		var current = 0, index = 0;

		//split uploaded data to multiple http requests
		(function SyncBatch()
		{
			_this.ItemsBatch = [];
			var size = 0;
			while (index < list.length)
			{
				var item = list[index];
				var n = item.EstimateSize();
				if (size + n > _this.BatchSize && _this.ItemsBatch.length > 0)
				{
					current += size;

					//upload batch
					_this.remote.SyncPut(sendBatch,
					function ()
					{
						//progress
						var p = Math.round(current * 100 / total);
						if (p == 0) p = 1;
						_this.OnSetProgressText1(RM.GetString("progressUpload").replace("{0} ", "") + " " + p + "%");

						SyncBatch();
					});
					return;
				}
				_this.ItemsBatch.push(item);
				size += n;
				index++;
			}
			_this.IsFinal = true;
			_this.remote.SyncPut(sendBatch, onsuccess);
		})();
	},

	SynchronizeFromServer: function (onsuccess)
	{
		var _this = this;

		this.OnSetProgressText("progressDownload");
		this.remote.SyncGet(
		function ()
		{
			_this.OnSetProgressText("progressDeserialize");
			var list = _this.SyncDeserialize(this.responseXML);
			_this.OnSetProgressText("progressSave");
			_this.ProcessServerModifications(list,
			function ()
			{
				_this.OnSetProgressText("progressCommit");
				_this.remote.SyncLuid(list, onsuccess);
			});
		});
	},

	SyncDeserialize: function (doc)
	{
		var c0, c1, i0, i1, x0, x1, x2, x3;
		var list = [];
		x0 = Utils.SelectSingleNode(doc, "sync");
		if (x0)
		{
			c0 = Utils.ChildNodes(x0);
			for (i0 = 0; i0 < c0.length; i0++)
			{
				x1 = c0[i0];
				if (Utils.XmlNodeName(x1) == "modification")
				{
					var modifItem = {
						modificationType: Utils.XmlAttribute(x1, "type"),
						number: Utils.XmlAttribute(x1, "number")
					};
					c1 = Utils.ChildNodes(x1);
					for (i1 = 0; i1 < c1.length; i1++)
					{
						x2 = c1[i1];
						switch (Utils.XmlNodeName(x2))
						{
							case "luid":
								modifItem.luid = Utils.XmlNodeText(x2);
								break;
							case "pim":
								x3 = Utils.ChildNodes(x2)[0];
								if (x3)
									if (Utils.XmlNodeName(x3) == "contact") modifItem.xml = x3;
									else Program.Warning("Unsupported item type: " + Utils.XmlNodeName(x3));
								break;
						}
					}
					list.push(modifItem);
				}
			}
		}
		return list;
	},

	FindContact: function (id, onsuccess)
	{
		var search = navigator.mozContacts.find({
			filterValue: id,
			filterBy: ["id"],
			filterOp: "equals",
		});

		search.onsuccess = function ()
		{
			var result = search.result[0];
			if (!result) Program.Warning(RM.GetString("errContactNotFound") + ": " + id);
			onsuccess(result);
		};

		search.onerror = function ()
		{
			Program.FatalException(RM.GetString("errContactNotFound") + ": " + id);
		};
	},

	ProcessServerModifications: function (newlist, onsuccess)
	{
		var _this = this;
		var index = 0;

		function ProcessItem()
		{
			var item;

			function SaveItem(person)
			{
				ContactItem.prototype.DeserializePim(item.xml, person);
				var saving = navigator.mozContacts.save(person);
				saving.onsuccess = function ()
				{
					item.luid = person.id;
					ProcessItem();
				};
				saving.onerror = function (err)
				{
					console.error(err);
					ProcessItem();
				};
			};

			if (index >= newlist.length)
			{
				onsuccess();
			}
			else
			{
				item = newlist[index++];

				switch (item.modificationType)
				{
					case "updated":
						_this.FindContact(item.luid,
						function (person)
						{
							if (!person) ProcessItem();
							else
							{
								ContactItem.prototype.Reset(person);
								SaveItem(person);
							}
						});
						break;
					case "created":
						SaveItem(new mozContact());
						break;
					case "deleted":
						_this.FindContact(item.luid,
						function (person)
						{
							if (!person) ProcessItem();
							else
							{
								var result = navigator.mozContacts.remove(person);
								result.onsuccess = ProcessItem;
								result.onerror = function (err)
								{
									console.error(err);
									ProcessItem();
								};
							}
						});
						break;
					default:
						Program.FatalException("Unknown modification type: " + modificationType);
						break;
				}
			}
		};

		if (this.SyncDirection == "fromserver")
		{
			if (newlist.length == 0) return Program.SyncException(RM.GetString("errNoServerContacts"));

			//delete all contacts
			var result = navigator.mozContacts.clear();
			result.onsuccess = function ()
			{
				//console.log('All contacts have been removed.');
				ProcessItem();
			};
			result.onerror = function (err)
			{
				Program.FatalException(RM.GetString("errContactDelete") + ", " + err);
			};
		}
		else
		{
			ProcessItem();
		}
	},

	Synchronize: function ()
	{
		var _this = this;

		this.GetInfo(
		function ()
		{
			_this.OnSetProgressText("progressSession");

			_this.remote.SyncBegin("<contact/>",
			function ()
			{
				if (_this.SyncDirection == "fromclient" || _this.SyncDirection == "fromserver")
					Config.SetAskDirection();

				_this.OnSetProgressText1(RM.GetString("progressUpload").replace("{0} ", ""));
				_this.SynchronizeFromClient(
				function ()
				{
					_this.SynchronizeFromServer(
					function ()
					{
						if (Config.AskDirection)
						{
							Config.AskDirection = false;
							Config.Save();
						}

						ShowError("");
						_this.OnSetProgressText("SyncSuccess");
					});
				});
			});
		});
	},

	OnSetProgressText1: function (text)
	{
		if (text.length > 0 && text[text.length - 1] != '.') text += "...";
		window.outputSync.textContent = text;
		//console.log(text);
	},

	OnSetProgressText: function (text)
	{
		this.OnSetProgressText1(RM.GetString(text));
	},

	ChooseDirection: function ()
	{
		this.OnSetProgressText("");
		$('pnlMain').hidden = true;
		$('pnlDirection').hidden = false;
		$('rdbFromClient').checked = false;
		$('rdbFromServer').checked = false;
		$('rdbTwoWay').checked = false;
	}
};
