'use strict';

function $(id)
{
	return document.getElementById(id);
}

var Utils = {
	XmlEncode: function (str)
	{
		if (!str) return str;
		return str.replace(/[<>&'"]/g, function (c)
		{
			switch (c)
			{
				case '<': return '&lt;';
				case '>': return '&gt;';
				case '&': return '&amp;';
				case '\'': return '&apos;';
				case '"': return '&quot;';
			}
		});
	},

	ChildNodes: function (x)
	{
		return x.children;
	},

	XmlNodeName: function (x)
	{
		return x.localName;
	},

	XmlNodeText: function (x)
	{
		return x.textContent;
	},

	XmlAttribute: function (x, name)
	{
		return x.getAttribute(name);
	},

	DateToYYYMMDD: function (d)
	{
		function pad(number) { return (number < 10) ? '0' + number : number.toString(); }

		return d.getUTCFullYear() + pad(d.getUTCMonth() + 1) + pad(d.getUTCDate());
	},

	NewGuid: function ()
	{
		var buf = new Uint16Array(8);
		if (window.crypto)
			window.crypto.getRandomValues(buf);
		else 
			for (var i = 0; i < 8; i++) buf[i] = Math.floor(Math.random() * 0x10000);

		var S4 = function (num)
		{
			var ret = num.toString(16);
			while (ret.length < 4)
			{
				ret = "0" + ret;
			}
			return ret;
		};
		return (S4(buf[0]) + S4(buf[1]) + "-" + S4(buf[2]) + "-" + S4(buf[3]) + "-" + S4(buf[4]) + "-" + S4(buf[5]) + S4(buf[6]) + S4(buf[7]));
	},

	SelectSingleNode: function (doc, xpath)
	{
		function SelectSingleNode1(x, paths, pathIndex)
		{
			if (!x) return null;
			if (pathIndex >= paths.length) return x;
			var name = paths[pathIndex++];

			var c0 = Utils.ChildNodes(x);
			for (var i0 = 0; i0 < c0.length; i0++)
			{
				var x1 = c0[i0];
				if (x1.localName == name)
					return SelectSingleNode1(x1, paths, pathIndex);
			}
			return null;
		}
		return SelectSingleNode1(doc.documentElement, xpath.split('/'), 0);

		//evaluate function is insecure
		//return doc.evaluate(xpath, doc.documentElement, function (ns) { return ns == "rs" ? "http://restsync.org/ns/restsync/1/" : null; }, XPathResult.ANY_TYPE, null).iterateNext();
	},

	ToBase64String: function (blob, onsuccess)
	{
		var reader = new FileReader();
		reader.onloadend = function ()
		{
			var url = reader.result;
			var base64 = url.substr(url.indexOf(',') + 1); //data:image/jpeg;base64,
			onsuccess(base64);
		};
		reader.readAsDataURL(blob);
	},

	FromBase64String: function (base64Data)
	{
		var sliceSize = 1024;
		var byteCharacters = atob(base64Data);
		var bytesLength = byteCharacters.length;
		var slicesCount = Math.ceil(bytesLength / sliceSize);
		var byteArrays = new Array(slicesCount);

		for (var sliceIndex = 0; sliceIndex < slicesCount; ++sliceIndex)
		{
			var begin = sliceIndex * sliceSize;
			var end = Math.min(begin + sliceSize, bytesLength);

			var bytes = new Array(end - begin);
			for (var offset = begin, i = 0 ; offset < end; ++i, ++offset)
			{
				bytes[i] = byteCharacters[offset].charCodeAt(0);
			}
			byteArrays[sliceIndex] = new Uint8Array(bytes);
		}
		return new Blob(byteArrays, { type: "image/jpeg" });
	},

	ParseISO8601: function (s)
	{
		//TODO
		if (s.length == 8 || s.length > 9 && s[8] == 'T')
		{
			return new Date(Date.UTC(s.substr(0, 4), s.substr(4, 2) - 1, s.substr(6, 2)));
		}
		return null;
	},

	Encrypt: function (s)
	{
		if (!s) return s;
		var r = Math.floor(32 + Math.random() * 223);
		var result = String.fromCharCode(r);
		for (var i = 0; i < s.length; i++)
		{
			r = ((r * 367427) % 7563277) + 1746821;
			var c = s.charCodeAt(i) ^ (r & 31);
			result += String.fromCharCode(c);
			r += c;
		}
		return result;
	},

	Decrypt: function (s)
	{
		if (!s) return s;
		var r = s.charCodeAt(0);
		var result = "";
		for (var i = 1; i < s.length; i++)
		{
			r = ((r * 367427) % 7563277) + 1746821;
			var c = s.charCodeAt(i);
			result += String.fromCharCode(c ^ (r & 31));
			r += c;
		}
		return result;
	}
};


var Program = {
	ErrorInfoTable: {},

	Exception: function (message)
	{
		//show error message to user
		if (typeof(ShowError)=='function') ShowError(message);
		else alert(message);
	},

	SyncException: function (message)
	{
		this.Exception(message);
	},

	FatalException: function (message, info)
	{
		this.Exception(message);

		//send error info to developer
		try
		{
			if (!this.ErrorInfoTable[message])
			{
				this.ErrorInfoTable[message] = true;

				var formData = new FormData();
				formData.append("ErrInfo", "PhoneCopy: " + AppVersion +
					"\nOS: " + navigator.userAgent + "\nLanguage: " + navigator.language +
					"\nUser: " + Config.UserName +
					"\n\nERROR: " + message + "\nStackTrace: " + (info || ""));

				var req = new XMLHttpRequest({ mozSystem: true });
				req.open("POST", "http://www.fractal.cz/PhoneCopy.aspx", true);
				req.send(formData);
			}
		}
		catch (ex) { }
	},

	Warning: function (message)
	{
		console.warn(message);
	}
};

window.onerror = function (errorMsg, url, lineNumber, column, errorObj)
{
	Program.FatalException(errorMsg,
		(errorObj && errorObj.stack) ? errorObj.stack : url + ":" + lineNumber + ":" + column);
};
