﻿var imageSouce = "appImages/atish.JPG";
var tempImageSource;
var screenHeight;
var screenWidth;
var canvasHeight = 340;
var canvasWidth = 276;
var imageCurrentState = 0;
var imageSourceArray = [];
var currentCanvas;
var imageSourceUndo = [];
var imageSourceRedo = [];

$(document).ready(function () {
   imageSourceUndo.push(imageSouce);
   imageSourceRedo.push(imageSouce);
    screenHeight = $(window).height();
    screenWidth = $(window).width();

    var defultImage = new Image();
    defultImage.src = imageSouce;
    defultImage.height = canvasHeight;
    defultImage.width = canvasWidth;
    defultImage.onload = function () {
        $('.filterImageContent').append(defultImage);
    };

    $('.btnfilterAction').on('click', function () {
        $.mobile.changePage("#actionPage", {
            transition: "pop",
            changeHash: false
        });
    });

    $('.btnShare').on('click', function () {
    console.log("fb");
        $.mobile.changePage("#sharePhoto", {
            transition: "slide",
            changeHash: false
        });
  
     });

    $('.btnSave').on('click', function () {

        currentCanvas.toBlob(function (blob) { 

        var randomFileName = "PhotoFilter" + Math.random().toString(36).substr(2, 15) + ".png";
        
        var sdcard = navigator.getDeviceStorage("sdcard");
        var request = sdcard.delete(randomFileName);
     
        request.onsuccess = function () {
                            savePhotoToSdCard(blob,randomFileName);
                            console.log("success and savePhotoToSdCard called");
                            };

        request.onerror = function () {
                            savePhotoToSdCard(blob,randomFileName);
                            console.log("error and savePhotoToSdCard called" + this.error.name);
                            };
        });

    });

    $('.btnChangePhoto').on('click', function () {
        var pickImage = new MozActivity({
            name: "pick",
            data: {
                type: ["image/png", "image/jpg", "image/jpeg"]
            }
        });
        pickImage.onsuccess = function () {
            imageSouce = window.URL.createObjectURL(this.result.blob);
            console.log(imageSouce);
            imageSourceArray.push(imageSouce);
            imageCurrentState++;
            var pickedImage = new Image();
            pickedImage.src = imageSouce;
            pickedImage.height = canvasHeight;
            pickedImage.width = canvasWidth;
            pickedImage.onload = function () {
                $('.filterImageContent').empty();
                $('.filterImageContent').append(pickedImage);
            };
        };
    });

    $('.btnUndo').on('click', function () {
            undoCurrentPhoto();
    });

    $('.btnRedo').on('click', function () {
            redoCurrentPhoto();
    });



    $('#actionListview li a').on('click', function () {
        $.mobile.changePage($(this).data("action"), {
            transition: "flip",
            changeHash: false
        });
    });

    $('#btnGrayScaleFilter').on('click', function () {
        graySacaleFilter(imageSouce);
    });

    $('#btnSolarizeFilter').on('click', function () {
        solarizeFilter(imageSouce);
    });

    $('#btnInverseFilter').on('click', function () {
        inverseFilter(imageSouce);
    });

    $('#btnSepiaFilter').on('click', function () {
        sepiaFilter(imageSouce, $('#sepiaNoiseRange').val());
    });

    $('#btnBlurFilter').on('click', function () {
        blurFilter(imageSouce);
    });

    $('#btnBrightnessFilter').on('click', function () {
        brightnessFilter(imageSouce, $('#brightnessRange').val());
    });

    $('#btnContrastFilter').on('click', function () {
        contrastFilter(imageSouce, $('#contrastRange').val());
    });

    $('#btnSharpnessFilter').on('click', function () {
        sharpnessFilter(imageSouce, $('#contrastRange').val());
    });

    $('#btnFlipVertical').on('click', function () {
        flipVerticalFilter(imageSouce);
        console.log("Flip V");
    });

    $('#flipHorizontalPage').on('click', function () {
        flipHorizontalFilter(imageSouce);
    });

    $('#btnHistogramFilter').on('click', function () {
        histogramFilter(imageSouce, $('#contrastRange').val());
    });

    $('#btnEdgeDitect').on('click', function () {
        edgeDitectFilter(imageSouce, $('#contrastRange').val());
    });

});

function drawFilteredImage(canvas) {
    var image = new Image();
    image.src = canvas.toDataURL("image/png");
    image.height = canvasHeight;
    image.width = canvasWidth;
    image.onload = function () {
        imageSouce = image.src;
        $('.filterImageContent').empty();
        $('.filterImageContent').append(image);
        imageSourceUndo.push(imageSouce);
        imageSourceRedo.push(imageSouce);
       
        imageCurrentState++;
        currentCanvas = canvas;
    };
}

function savePhotoToSdCard(blob, randomFileName) {

    var sdcard = navigator.getDeviceStorage("sdcard");
    var request = sdcard.addNamed(blob, "Photo Filter/"+randomFileName);

    request.onsuccess = function () {
        var name = this.result;
        console.log(name);
        console.log('File "' + name + '" successfully wrote on the sdcard storage area');
        alert("Photo Save Successfully.");
    };

    request.onerror = function (e) {
        console.log(e.target.error.name);
        console.log('Unable to write the file: ' + e.target.error.name);
    };
}

function undoCurrentPhoto()
 {
   if(imageSourceUndo.length>1)
            {
            imageSourceUndo.pop()
             var currentSource = imageSourceUndo[imageSourceUndo.length-1];
             
             var undoImage = new Image();
            undoImage.height = canvasHeight;
            undoImage.width = canvasWidth;
            undoImage.src = currentSource;
            $('.filterImageContent').empty();
            $('.filterImageContent').append(undoImage);
            imageSouce = currentSource;
            
            }
            else {
            alert("No Changes Exist.");
        }
        
 }

 function redoCurrentPhoto()
 {
   if(imageSourceRedo.length > imageSourceUndo.length)
   {
            var currentSourceIndex = imageSourceUndo.length - 1;

            var redoImage = new Image();
            redoImage.height = canvasHeight;
            redoImage.width = canvasWidth;
            redoImage.src = imageSourceRedo[currentSourceIndex+1];
            $('.filterImageContent').empty();
            $('.filterImageContent').append(redoImage);
            imageSouce = imageSourceRedo[currentSourceIndex+1];
            imageSourceRedo.splice(imageSourceRedo.indexOf(imageSourceRedo[currentSourceIndex+1]), 1);

   }
            else {
            alert("No Changes Exist.");
        }
 }

 function flipHorizontalFilter(currentImageSource)
  {
    var canvas = document.createElement("canvas");
    var context = canvas.getContext("2d");

    var image = new Image();
    image.src = currentImageSource;
    image.onload = function() {
      canvas.width=image.width;
      canvas.height=image.height;
      context.save();
      context.scale(-1,1);
      context.drawImage(image,-canvas.width,0);
      context.restore();
        drawFilteredImage(canvas);
        }

        image.src = currentImageSource;
  }

  function flipVerticalFilter(currentImageSource)
  {
    var canvas = document.createElement("canvas");
    var context = canvas.getContext("2d");

    var image = new Image();
    image.src = currentImageSource;
    image.onload = function() {
      canvas.width=image.width;
      canvas.height=image.height;
      context.save();
      context.scale(1,-1);
      context.translate(0,image.width);
      context.drawImage(image,0,0);
      context.restore();
        drawFilteredImage(canvas);
        }

        image.src = currentImageSource;
  }

//C:\Users\BS87-Atish\AppData\Roaming\Mozilla\Firefox\Profiles\9ctjud00.default\extensions\r2d2b2g@mozilla.org\profile\fake-sdcard


