﻿function blurFilter(currentImageSource) {
    var canvas = document.createElement("canvas");
    canvas.setAttribute("height", canvasHeight);
    canvas.setAttribute("width", canvasWidth);
    var context = canvas.getContext("2d");

    var image = new Image();
    image.src = currentImageSource;
    var height = canvasHeight;
    var width = canvasWidth;
    image.onload = function() {
        context.drawImage(image, 0, 0, canvasWidth, canvasHeight);
        var imageData = context.getImageData(0, 0, canvas.width, canvas.height);
        var pixels = imageData.data;

        for (var y = 1; y < height; y++) {
            for (var x = 1; x < width; x++) {
                pixels[((width * y) + x) * 4] = (pixels[((width * (y - 1)) + (x - 1)) * 4] +

                                             pixels[((width * (y - 1)) + x) * 4] +

                                             pixels[((width * (y - 1)) + (x + 1)) * 4] +

                                             pixels[((width * y) + (x - 1)) * 4] +

                                             pixels[((width * y) + (x + 1)) * 4] +

                                             pixels[((width * (y + 1)) + (x - 1)) * 4] +

                                             pixels[((width * (y + 1)) + x) * 4] +

                                             pixels[((width * (y + 1)) + (x + 1)) * 4]) / 8;

                pixels[((width * y) + x) * 4 + 1] = (pixels[((width * (y - 1)) + (x - 1)) * 4 + 1] +

                                             pixels[((width * (y - 1)) + x) * 4 + 1] +

                                             pixels[((width * (y - 1)) + (x + 1)) * 4 + 1] +

                                             pixels[((width * y) + (x - 1)) * 4 + 1] +

                                             pixels[((width * y) + (x + 1)) * 4 + 1] +

                                             pixels[((width * (y + 1)) + (x - 1)) * 4 + 1] +

                                             pixels[((width * (y + 1)) + x) * 4 + 1] +

                                             pixels[((width * (y + 1)) + (x + 1)) * 4 + 1]) / 8;

                pixels[((width * y) + x) * 4 + 2] = (pixels[((width * (y - 1)) + (x - 1)) * 4 + 2] +

                                             pixels[((width * (y - 1)) + x) * 4 + 2] +

                                             pixels[((width * (y - 1)) + (x + 1)) * 4 + 2] +

                                             pixels[((width * y) + (x - 1)) * 4 + 2] +

                                             pixels[((width * y) + (x + 1)) * 4 + 2] +

                                             pixels[((width * (y + 1)) + (x - 1)) * 4 + 2] +

                                             pixels[((width * (y + 1)) + x) * 4 + 2] +

                                             pixels[((width * (y + 1)) + (x + 1)) * 4 + 2]) / 8;

            }
        }

        context.putImageData(imageData, 0, 0);

        drawFilteredImage(canvas);
    };
}

