﻿function brightnessFilter(currentImageSource, gamma) {
    var canvas = document.createElement("canvas");
    canvas.setAttribute("height", canvasHeight);
    canvas.setAttribute("width", canvasWidth);
    var context = canvas.getContext("2d");

    var image = new Image();
    image.src = currentImageSource;
    
    image.onload = function() {
        context.drawImage(image, 0, 0, canvasWidth, canvasHeight);
        var imageData = context.getImageData(0, 0, canvas.width, canvas.height);
        var pixels = imageData.data;
        var gammaInvert = 1 / gamma;
        var hslValue = { h: 0, s: 0, l: 0 };
        var rgbValue = { r: 0, g: 0, b: 0 };

        for (var i = 0; i < pixels.length; i += 4) {
            rgbToHsl(pixels[i], pixels[i + 1], pixels[i + 2], hslValue);
            hslValue.l = Math.pow(hslValue.l, gammaInvert);
            hslToRgb(hslValue.h, hslValue.s, hslValue.l, rgbValue);
            pixels[i] = rgbValue.r;
            pixels[i + 1] = rgbValue.g;
            pixels[i + 2] = rgbValue.b;
        }

        context.putImageData(imageData, 0, 0);

        drawFilteredImage(canvas);
    };
}

function hslToRgb(h, s, l, res) {
    var r = 0,
        g = 0,
        b = 0;
    var var1 = 0,
        var2 = 0;

    if (s == 0) { //HSL from 0 to 1
        r = l * 255; //RGB results from 0 to 255
        g = l * 255;
        b = l * 255;
    } else {
        var2 = (l < 0.5) ? l * (1 + s) : (l + s) - (s * l);
        var1 = 2 * l - var2;

        r = 255 * Hue_2_RGB(var1, var2, h + (1 / 3));
        g = 255 * Hue_2_RGB(var1, var2, h);
        b = 255 * Hue_2_RGB(var1, var2, h - (1 / 3));
    }
    res.r = r;
    res.g = g;
    res.b = b;
}

function Hue_2_RGB(v1, v2, vH) { //Function Hue_2_RGB

    if (vH < 0) vH += 1;
    if (vH > 1) vH -= 1;
    if ((6 * vH) < 1) return (v1 + (v2 - v1) * 6 * vH);
    if ((2 * vH) < 1) return (v2);
    if ((3 * vH) < 2) return (v1 + (v2 - v1) * ((2 / 3) - vH) * 6);
    return (v1);
}

function RGBToHex(r, g, b) {
    r = 0 | r;
    g = 0 | g;
    b = 0 | b;
    var bin = r << 16 | g << 8 | b;
    bin = bin.toString(16);
    while (bin.length < 6) bin = "0" + bin;
    return "#" + bin;
}

function rgbToHsl(r, g, b, res) {

    var varR = (r / 255); //RGB from 0 to 255
    var varG = (g / 255);
    var varB = (b / 255);

    var h = 0,
        s = 0,
        l = 0;

    var varMin = Math.min(varR, varG, varB); //Min. value of RGB
    var varMax = Math.max(varR, varG, varB); //Max. value of RGB
    var delMax = varMax - varMin; //Delta RGB value

    l = (varMax + varMin) / 2;

    if (delMax == 0) { //This is a gray, no chroma...
        h = 0; //HSL results from 0 to 1
        s = 0;
    } else { //Chromatic data...    
        s = (l < 0.5) ? delMax / (varMax + varMin) : delMax / (2 - varMax - varMin);


        var delR = (((varMax - varR) / 6) + (delMax / 2)) / delMax;
        var delG = (((varMax - varG) / 6) + (delMax / 2)) / delMax;
        var delB = (((varMax - varB) / 6) + (delMax / 2)) / delMax;

        if (varR == varMax) {
            h = delB - delG;
        } else if (varG == varMax) {
            h = (1 / 3) + delR - delB;
        } else if (varB == varMax) {
            h = (2 / 3) + delG - delR;
        }

        if (h < 0) h += 1;
        if (h > 1) h -= 1;
    }
    res.h = h;
    res.s = s;
    res.l = l;
}
